/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import org.eclipse.ui.services.IDisposable;

public class SplitPaneStructNode
extends SplitPane
implements IBaseControl,
IDisposable {
    private EfuseStructSetting structSetting;

    public SplitPaneStructNode(EfuseStructSetting structSetting) {
        this.structSetting = structSetting;
        this.create();
    }

    public void create() {
        this.setId(this.structSetting.getId());
        this.setDividerPositions(new double[]{0.4f, 0.7f});
        for (EfuseStructSetting childStruct : this.structSetting.getStructSettings()) {
            ScrollPane childStructScrollPane = new ScrollPane();
            StructSettingNode structSettingNode = new StructSettingNode(childStruct);
            childStructScrollPane.setContent((Node)structSettingNode.getRegion());
            childStructScrollPane.setFitToWidth(true);
            this.getItems().add((Object)childStructScrollPane);
            UctLayoutUtils.updateNodeState((Node)childStructScrollPane, (ABaseUIComponentSetting)childStruct);
        }
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IBaseControl)) continue;
            ((IBaseControl)childContent).refresh();
        }
    }

    public void dispose() {
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IDisposable)) continue;
            ((IDisposable)childContent).dispose();
        }
        EfuseSceneCreator.getNodes().remove((Object)this);
        this.getItems().clear();
    }
}

