/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.base;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.Messages;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import com.nxp.s32ds.ext.cdt.dsf.cmd.DsfCmdRequestor;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.osgi.util.NLS;

public class DsfMemoryCmdRequestor
extends DsfCmdRequestor<MemorySpace, byte[], MemoryByte[]> {
    private static final String MEM_READ_CMD = "mem_read 0x%s %d %s %d";
    private static final String MEM_WRITE_CMD = "mem_write 0x%s %d %s 0x%s";
    private static final DsfMemoryCmdRequestor INSTANCE = new DsfMemoryCmdRequestor();

    public static DsfMemoryCmdRequestor getInstance() {
        return INSTANCE;
    }

    private DsfMemoryCmdRequestor() {
    }

    protected String getReadCommand(DsfRequest<MemorySpace, ?> request) {
        int accessSize;
        MemorySpace memorySpace = (MemorySpace)request.base;
        long countBlock = memorySpace.getDataSize();
        if (countBlock / 4L > 1L) {
            accessSize = 4;
            countBlock /= 4L;
        } else {
            accessSize = 1;
        }
        return String.format(MEM_READ_CMD, memorySpace.getBaseAddress().toString(16), accessSize, memorySpace.getId(), countBlock);
    }

    protected String getWriteCommand(DsfRequest<MemorySpace, byte[]> request) {
        MemorySpace memorySpace = (MemorySpace)request.base;
        byte[] bytes = (byte[])request.value;
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return String.format(MEM_WRITE_CMD, memorySpace.getBaseAddress().toString(16), bytes.length, memorySpace.getId(), sb.toString());
    }

    protected DsfResponse<MemorySpace, MemoryByte[]> createResponse(DsfRequest<MemorySpace, ?> request, MIConsoleStreamOutput output) {
        String outputStr = output.getCString();
        int blockSize = outputStr.length();
        MemoryByte[] blocks = new MemoryByte[blockSize / 2];
        int i = 0;
        int j = 0;
        while (i < blockSize) {
            String hex = outputStr.substring(i, i + 2);
            try {
                Integer a = Integer.decode(String.format("0x%s", hex));
                blocks[j] = new MemoryByte(a.byteValue(), 35);
            }
            catch (NumberFormatException numberFormatException) {
                blocks[j] = new MemoryByte(0, 0);
            }
            i += 2;
            ++j;
        }
        return new DsfResponse(request, (Object)blocks);
    }

    protected String getRequestDescription(DsfRequest<MemorySpace, ?> request) {
        return NLS.bind((String)Messages.DsfMemoryCmdRequestor_the_memory_space_0, (Object)((MemorySpace)request.base).getName());
    }
}

