/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.processors;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.nxp.s32ds.ext.cdt.internal.core.CoreMessages;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SetIncrementalBuildOpt
extends ProcessRunner {
    private static final String ARG_OPTION = "option";
    private static final String ARG_PROJECT_NAME = "projectName";
    private static final String ARG_CONFIG_NAME = "configName";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (!SetIncrementalBuildOpt.checkArguments(args)) {
            return;
        }
        String value = args[0].getSimpleValue();
        String configName = args[1].getSimpleValue();
        String projectName = args[2].getSimpleValue();
        IProject projectHandle = EclipseUtils.getProjectByName((String)projectName);
        if (projectHandle == null || !projectHandle.exists()) {
            SetIncrementalBuildOpt.log(NLS.bind((String)CoreMessages.SetIncrementalBuildOpt_unknown_project, (Object)projectName));
            return;
        }
        IConfiguration[] iConfigurationArray = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (configName.equals(config.getName())) {
                IBuilder builder = config.getToolChain().getBuilder();
                try {
                    builder.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", value);
                }
                catch (CoreException ex) {
                    SetIncrementalBuildOpt.log(SetIncrementalBuildOpt.createStatus(CoreMessages.SetIncrementalBuildOpt_failed_to_set_incremental_build_target_option, ex));
                }
            }
            ++n2;
        }
    }

    private static boolean checkArguments(ProcessArgument[] args) {
        if (args == null || args.length != 3) {
            SetIncrementalBuildOpt.log(CoreMessages.SetIncrementalBuildOpt_incorrect_arguments_count);
            return false;
        }
        String option = args[0].getName();
        if (!option.equals(ARG_OPTION)) {
            SetIncrementalBuildOpt.log(NLS.bind((String)CoreMessages.SetIncrementalBuildOpt_incorrect_argument, (Object)option));
            return false;
        }
        String configName = args[1].getName();
        if (!configName.equals(ARG_CONFIG_NAME)) {
            SetIncrementalBuildOpt.log(NLS.bind((String)CoreMessages.SetIncrementalBuildOpt_incorrect_argument, (Object)configName));
            return false;
        }
        String projectName = args[2].getName();
        if (!projectName.equals(ARG_PROJECT_NAME)) {
            SetIncrementalBuildOpt.log(NLS.bind((String)CoreMessages.SetIncrementalBuildOpt_incorrect_argument, (Object)projectName));
            return false;
        }
        return true;
    }

    private static IStatus createStatus(String msg) {
        return SetIncrementalBuildOpt.createStatus(msg, null);
    }

    private static IStatus createStatus(String msg, Throwable e) {
        return new Status(4, "com.nxp.s32ds.ext.cdt.core", msg, e);
    }

    private static void log(String e) {
        SetIncrementalBuildOpt.log(SetIncrementalBuildOpt.createStatus(e));
    }

    private static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }
}

