/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.gtm.controls.BoolSettingControl;
import com.nxp.swtools.gtm.controls.EnumSettingControl;
import com.nxp.swtools.gtm.controls.IntegerSettingControl;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.controls.TextSettingControl;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.eclipse.ui.services.IDisposable;

public class BorderPaneStructNode
extends BorderPane
implements IBaseControl,
IDisposable {
    private GtmStructSetting structSetting;
    private GridPane content;

    public BorderPaneStructNode(GtmStructSetting structSetting) {
        this.structSetting = structSetting;
        this.content = new GridPane();
        this.create();
    }

    public void create() {
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.content.getColumnConstraints().add((Object)columnConstraints);
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setVgrow(Priority.ALWAYS);
        this.content.getRowConstraints().add((Object)rowConstraints);
        this.setId(this.structSetting.getId());
        Label title = new Label(this.structSetting.getLabel());
        this.getStyleClass().add((Object)"border-pane-border");
        title.getStyleClass().add((Object)"bordered-pane-title");
        BorderPane.setAlignment((Node)title, (Pos)Pos.CENTER);
        this.setTop((Node)title);
        GridPane.setFillWidth((Node)this, (Boolean)Boolean.TRUE);
        GridPane.setFillHeight((Node)this, (Boolean)Boolean.TRUE);
        for (GtmStructSetting childStructSetting : this.structSetting.getStructSettings()) {
            if (!childStructSetting.getInitVisibleState()) continue;
            StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
            this.content.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow(), childStructSetting.getColumnSpan(), childStructSetting.getRowSpan());
            GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setFillHeight((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
            childStructSettingNode.getRegion().prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            childStructSettingNode.getRegion().prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
            UctLayoutUtils.updateNodeState((Node)childStructSettingNode.getRegion(), (ABaseUIComponentSetting)childStructSetting);
        }
        for (GtmTextSetting textSetting : this.structSetting.getTextSettings()) {
            TextSettingControl textSettingControl = new TextSettingControl(textSetting, (Parent)this);
            this.content.add((Node)textSettingControl, textSetting.getColumn(), textSetting.getRow());
        }
        for (GtmBoolSetting boolSetting : this.structSetting.getBoolSettings()) {
            BoolSettingControl boolSettingControl = new BoolSettingControl((BoolSetting)boolSetting, (Parent)this);
            this.content.add((Node)boolSettingControl, boolSetting.getColumn(), boolSetting.getRow());
        }
        for (GtmEnumSetting enumSetting : this.structSetting.getEnumSettings()) {
            EnumSettingControl enumSettingControl = new EnumSettingControl(enumSetting, (Parent)this);
            this.content.add((Node)enumSettingControl, enumSetting.getColumn(), enumSetting.getRow());
        }
        for (GtmIntegerSetting integerSetting : this.structSetting.getIntegerSettings()) {
            IntegerSettingControl integerSettingControl = new IntegerSettingControl(integerSetting, (Parent)this);
            this.content.add((Node)integerSettingControl, integerSetting.getColumn(), integerSetting.getRow());
        }
        this.setCenter((Node)this.content);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)this.content);
    }

    public GtmStructSetting getStructSetting() {
        return this.structSetting;
    }

    public void dispose() {
        for (Node child : this.getChildren()) {
            if (!(child instanceof IDisposable)) continue;
            ((IDisposable)child).dispose();
        }
        GtmSceneCreator.getNodes().remove((Object)this);
        GtmSceneCreator.getNodes().remove(this.content);
        this.getChildren().clear();
        this.content.getChildren().clear();
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node node : this.content.getChildren()) {
            if (!(node instanceof IBaseControl)) continue;
            ((IBaseControl)node).refresh();
        }
    }
}

