/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.internal.core.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommandLineInputHandler
extends DefaultHandler {
    private StringBuilder stringBuilder = new StringBuilder();
    private String projectName;
    private String coreId;
    private String archId;
    private String sdkPath;
    private String toolchain;
    private boolean isExec = true;
    private Map<String, String> globalSettings = new HashMap<String, String>();
    private Map<String, String> projectSettings = new HashMap<String, String>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.stringBuilder.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase("projectName")) {
            this.projectName = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("coreId")) {
            this.coreId = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("archId")) {
            this.archId = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("sdkPath")) {
            this.sdkPath = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("toolchain")) {
            this.toolchain = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("library") || qName.equalsIgnoreCase("io") || qName.equalsIgnoreCase("fpu") || qName.equalsIgnoreCase("language") || qName.equalsIgnoreCase("opmode")) {
            this.projectSettings.put(qName, this.stringBuilder.toString());
        }
        if (qName.equalsIgnoreCase("debugger")) {
            this.globalSettings.put(qName, this.stringBuilder.toString());
        }
        if (qName.equalsIgnoreCase("isExec")) {
            this.isExec = this.stringBuilder.toString().equalsIgnoreCase("true");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.stringBuilder.append(ch, start, length);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getCoreId() {
        return this.coreId;
    }

    public String getArchId() {
        return this.archId;
    }

    public boolean isExec() {
        return this.isExec;
    }

    public String getSdkPath() {
        return this.sdkPath;
    }

    public String getToolchain() {
        return this.toolchain;
    }

    public Map<String, String> getProjectSettings() {
        return this.projectSettings;
    }

    public Map<String, String> getGlobalSettings() {
        return this.globalSettings;
    }

    public static CommandLineInputHandler parseInputFile(String filename) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SAXParser saxParser = factory.newSAXParser();
        CommandLineInputHandler handler = new CommandLineInputHandler();
        saxParser.parse(filename, (DefaultHandler)handler);
        return handler;
    }
}

