/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.interchange.registers.SvdRegistersInterchange;
import com.nxp.s32ds.cdt.svd.interchange.registers.model.Register;
import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportedRegister;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeDeviceModel;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdStringToNumber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class SvdRegistersImports {
    public static Collection<SvdImportedRegister> importFile(SvdCompositeDeviceModel model, Path filePath) throws CoreException {
        ArrayList<SvdRegister> svdRegisters = new ArrayList<SvdRegister>();
        HashMap<SvdRegister, BigInteger> valuesMap = new HashMap<SvdRegister, BigInteger>();
        List<Register> registers = SvdRegistersImports.readRegisters(filePath);
        for (Register register : registers) {
            String path = register.getPath();
            if (path == null || path.isEmpty()) {
                CdtSvdUiActivator.getInstance().logWarning(NLS.bind((String)Messages.SvdImportRegistersResult_register_0_has_empty_path, (Object)registers.indexOf(register)));
                continue;
            }
            SvdChildElement childElement = model.getByShortPath(path);
            if (!(childElement instanceof SvdRegister)) {
                CdtSvdUiActivator.getInstance().logWarning(NLS.bind((String)Messages.SvdImportRegistersResult_cannot_find_register_with_path_0, (Object)path));
                continue;
            }
            SvdRegister svdRegister = (SvdRegister)childElement;
            svdRegisters.add(svdRegister);
            String value = register.getValue();
            if (value == null || value.isEmpty()) continue;
            try {
                valuesMap.put(svdRegister, SvdStringToNumber.fromHexString((String)value));
            }
            catch (NumberFormatException numberFormatException) {
                CdtSvdUiActivator.getInstance().logWarning(NLS.bind((String)Messages.SvdImportRegistersResult_register_0_has_wrong_value_1, (Object)path, (Object)value));
            }
        }
        return svdRegisters.stream().map(r -> new SvdImportedRegister((SvdRegister)r, (BigInteger)valuesMap.get(r))).collect(Collectors.toList());
    }

    private static List<Register> readRegisters(Path path) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                return SvdRegistersInterchange.unmarshal((Reader)reader).getRegister();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(CdtSvdUiActivator.getInstance().createError(NLS.bind((String)Messages.SvdRegistersImports_error_during_loading_registers_0, (Object)e.getMessage()), e));
        }
    }
}

