/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.lc;

import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public abstract class AbstractLaunchConfigurationMigrationEntity
implements MigrationEntity {
    private static final String GDB_PATH_OUTDATED_MARKER = "com.nxp.s32ds.cle.debug.s32debugger.gdb.path.invalid.launch.marker";

    public IStatus applicable(String sourceId, String targetId, Map<String, Object> attributes) {
        return Status.OK_STATUS;
    }

    protected List<ILaunchConfiguration> getLaunchConfigurations(String projectName) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(projectName) && launchConfiguration.getType().getIdentifier().equals(this.getConfigurationName())) {
                configurations.add(launchConfiguration);
            }
            ++n2;
        }
        return configurations;
    }

    public IStatus migrate(String attributeId, String targetToolchain, Map<String, Object> attributes, IProgressMonitor monitor) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (project == null || !project.exists()) {
            return Status.CANCEL_STATUS;
        }
        try {
            List<ILaunchConfiguration> launchConfigurations = this.getLaunchConfigurations(project.getName());
            if (launchConfigurations.isEmpty()) {
                return Status.OK_STATUS;
            }
            for (ILaunchConfiguration configuration : launchConfigurations) {
                ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                if (Status.CANCEL_STATUS.equals(this.migrateWorkingCopy(workingCopy, project, targetToolchain))) {
                    return Status.CANCEL_STATUS;
                }
                workingCopy.doSave();
            }
            AbstractLaunchConfigurationMigrationEntity.removeMarker(project);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private static void removeMarker(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(GDB_PATH_OUTDATED_MARKER, false, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    protected abstract IStatus migrateWorkingCopy(ILaunchConfigurationWorkingCopy var1, IProject var2, String var3) throws CoreException;

    protected abstract String getDebuggerId();

    protected abstract String getConfigurationName();
}

