/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.project.configuration;

import com.nxp.s32ds.cle.runtime.migration.MigrationPostInitializationValidator;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@MigrationEntityAnnotation(name="Modify CDT environment variable.", description="Modify (remove, replace, prepend, append) a value of environment variable in CDT configrations.")
public class ModifyEnvironmentVariableAction
implements MigrationAction,
MigrationPostInitializationValidator {
    @MigrationPropertyAnnotation(description="The 'remove' operation removes variable.\nThe 'replace' operation replaces current value of variable.\nThe 'prepend' and 'append' operations prepends and appends replaces target value to currentvalue of variable using OS specific path separator.")
    private EnvironmentVariableOperation operation;
    @MigrationPropertyAnnotation(description="The name of variable")
    private String variableName;
    private static final String VARIABLE_VALUE = "variableValue";
    @MigrationPropertyAnnotation(name="variableValue", description="The value of variable. Required for all operation except the remove", minOccurs=0)
    private String variableValue;

    public IStatus validate() {
        if (this.operation != EnvironmentVariableOperation.REMOVE && this.variableValue == null) {
            return MigrationsAssert.propertyExpected((String)VARIABLE_VALUE);
        }
        return Status.OK_STATUS;
    }

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        int code = this.operation.getCode();
        ICProjectDescriptionManager descriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
        IContributedEnvironment environment = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
        ICProjectDescription descriptor = descriptionManager.getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = descriptor.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            environment.addVariable(this.variableName, this.variableValue, code, File.pathSeparator, cfg);
            ++n2;
        }
        descriptionManager.setProjectDescription(project, descriptor, false, monitor);
    }

    public static enum EnvironmentVariableOperation {
        REPLACE(1),
        REMOVE(2),
        PREPEND(3),
        APPEND(4);

        private final int code;

        private EnvironmentVariableOperation(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

