/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.core;

import com.nxp.s32ds.ext.ide.core.refactoring.RenameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;

public interface IChangeValidator {
    public static final String QUOTE = "\"";
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.ide.ui";
    public static final String ATTRIBUTE_PREFIX = "<";
    public static final Matcher LIST_ENTRY_PREFIX = Pattern.compile("^\\s*<listEntry").matcher("");
    public static final Matcher LIST_ATTRIBUTE_PREFIX = Pattern.compile("^\\s*<listAttribute").matcher("");
    public static final Matcher MAP_ENTRY_PREFIX = Pattern.compile("^\\s*<mapEntry").matcher("");
    public static final Matcher MAP_ATTRIBUTE_PREFIX = Pattern.compile("^\\s*<mapAttribute").matcher("");
    public static final String S32DS_VARIABLE_PREFIX = "${S32DS_";
    public static final String REGEX_FOR_NAMED_VALUE = "=\"[^\"]*?%s[^\"]*?\"";
    public static final String REGEX_FOR_VALUE_WITHOUT_NAME = ">.*%s.*<";

    default public boolean skipChange(List<AttributeLine> affectedAttributes, IDocument doc, ReplaceEdit re, List<String> filter) {
        block10: {
            List<AttributeLine> attributesWithFoundValue;
            String line;
            block11: {
                String oldName;
                int indexOfOldNameInLine;
                int lin;
                block9: {
                    block8: {
                        if (affectedAttributes == null || affectedAttributes.isEmpty()) {
                            return true;
                        }
                        int pos = re.getOffset();
                        lin = doc.getLineOfOffset(pos);
                        int off = doc.getLineOffset(lin);
                        int len = doc.getLineLength(lin);
                        indexOfOldNameInLine = pos - off;
                        line = doc.get(off, len);
                        oldName = doc.get(pos, re.getLength());
                        if (!filter.stream().noneMatch(f -> line.contains((CharSequence)f)) && !IChangeValidator.containsMulti(line, oldName) || RenameUtils.isProjectName(line, oldName, indexOfOldNameInLine)) break block8;
                        return true;
                    }
                    if (IChangeValidator.isLocalPathOrName(line, indexOfOldNameInLine, oldName.length())) break block9;
                    return true;
                }
                try {
                    attributesWithFoundValue = IChangeValidator.getAttributesWithFoundValue(line, oldName, affectedAttributes, indexOfOldNameInLine);
                    if (attributesWithFoundValue == null || attributesWithFoundValue.isEmpty()) break block10;
                    if (!this.startsWith(line, LIST_ENTRY_PREFIX) && !this.startsWith(line, MAP_ENTRY_PREFIX)) break block11;
                    int i = lin - 1;
                    while (i > 0) {
                        String s = doc.get(doc.getLineOffset(i), doc.getLineLength(i));
                        if (this.startsWith(s, LIST_ATTRIBUTE_PREFIX) || this.startsWith(s, MAP_ATTRIBUTE_PREFIX)) {
                            return !IChangeValidator.containsKey(s, attributesWithFoundValue);
                        }
                        --i;
                    }
                    return true;
                }
                catch (BadLocationException e) {
                    Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, e.getMessage(), (Throwable)e);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return true;
                }
            }
            return !IChangeValidator.containsKey(line, attributesWithFoundValue);
        }
        return true;
    }

    default public boolean skipChange(List<AttributeLine> affectedAttributes, IDocument doc, ReplaceEdit re) {
        return this.skipChange(affectedAttributes, doc, re, Collections.emptyList());
    }

    default public boolean startsWith(String line, Matcher matcher) {
        return matcher.reset(line).find();
    }

    public static List<AttributeLine> getAttributesWithFoundValue(String line, String oldName, List<AttributeLine> affectedAttributes, int indexOfName) {
        ArrayList<AttributeLine> attributesWithFoundValue = new ArrayList<AttributeLine>();
        String valuePatternUsedWithName = null;
        block0: for (AttributeLine attrLine : affectedAttributes) {
            if (valuePatternUsedWithName == null) {
                for (String valuePattern : attrLine.valuePatterns) {
                    Matcher matcher = Pattern.compile(String.format(valuePattern, oldName)).matcher(line);
                    if (!matcher.find() || matcher.end() <= indexOfName || matcher.start() >= indexOfName) continue;
                    attributesWithFoundValue.add(attrLine);
                    valuePatternUsedWithName = valuePattern;
                    continue block0;
                }
                continue;
            }
            if (!attrLine.valuePatterns.contains(valuePatternUsedWithName)) continue;
            attributesWithFoundValue.add(attrLine);
        }
        return attributesWithFoundValue;
    }

    public static boolean containsKey(String line, List<AttributeLine> affectedAttributes) {
        return affectedAttributes.stream().anyMatch(attr -> line.contains(attr.keyPattern) && (attr.attributeName == null || Pattern.compile(attr.attributeName).matcher(line).find()));
    }

    public static boolean isLocalPathOrName(String line, int indexOfName, int nameLength) {
        int indexOfNearestQuotes1 = line.substring(0, indexOfName).lastIndexOf(QUOTE);
        int indexOfNearestQuotes2 = line.indexOf(QUOTE, indexOfName + nameLength);
        return indexOfNearestQuotes1 == -1 || indexOfNearestQuotes2 == -1 || !line.substring(indexOfNearestQuotes1, indexOfNearestQuotes2).contains(S32DS_VARIABLE_PREFIX);
    }

    public static boolean containsMulti(String src, String sub) {
        return src.indexOf(sub) != src.lastIndexOf(sub);
    }

    public static class AttributeLine {
        String keyPattern;
        public String launchConfigurationType;
        List<String> valuePatterns;
        String attributeName;

        public AttributeLine(String keyPattern, List<String> valuePatterns, String attributeName) {
            this.keyPattern = keyPattern;
            this.valuePatterns = valuePatterns;
            this.attributeName = attributeName;
        }

        public AttributeLine(String keyPattern, List<String> valuePatterns, String attributeName, String launchConfigurationType) {
            this.keyPattern = keyPattern;
            this.valuePatterns = valuePatterns;
            this.attributeName = attributeName;
            this.launchConfigurationType = launchConfigurationType;
        }
    }
}

