/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.core;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class GdbClientLaunchConfigurationMarker {
    private static final String MARKER_ID = "com.nxp.s32ds.ext.ide.validation.core.gdb.client.lc.marker";

    public static IStatus createMarker(IResource launchFile, IProject project, String attributeValue) {
        try {
            IMarker marker = launchFile.createMarker(MARKER_ID);
            if (marker.exists()) {
                marker.setAttribute("severity", 1);
                String attributeString = NLS.bind((String)Messages.LaunchConfigurationMarker_AtributeValueToUpdate, (Object)attributeValue);
                String msg = NLS.bind((String)Messages.LaunchConfigurationMarker_UserLaunchConfigurationMessage, (Object)launchFile.getName(), (Object)attributeString);
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute(Messages.LaunchConfigurationMarker_MarkerAttFileName, (Object)launchFile.getName());
            }
        }
        catch (CoreException ce) {
            ExtIdeCoreActivator.getInstance().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static IStatus delete(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static boolean containsMarker(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers(MARKER_ID, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            ExtIdeCoreActivator.getInstance().log(e.getStatus());
        }
        return false;
    }
}

