/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.e200.checker;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.ReplaceEdit;

public class MarkerHandler {
    public static final String MARKER_LINKER_NAME = "linker.file";
    public static final String MARKER_LINKER_FIX_MSG = "linker.fix.msg";
    public static final String MARKER_TYPE_FIX = "Fix type";
    public static final String MARKER_TYPE_FIX_LINKER_SECTION = "Fixing linker section";
    public static final String MARKER_TYPE_FIX_ADD_LINKER = "Add linker section";
    private static final String MARKER_TYPE_WRONG_LINKER = "com.freescale.s32ds.cross.e200.marker.wrong.linker";
    private static final String MARKER_TYPE_LINKER_CALL_MISSED = "com.freescale.s32ds.cross.e200.marker.missed.linker.section";
    public static final String MARKER_TYPE_SECTION = "Type linker section";

    public static IStatus createMarkerDeprecatedSection(IResource linker, IProject project, List<ReplaceEdit> replaceEdit) {
        try {
            for (ReplaceEdit re : replaceEdit) {
                IMarker marker = linker.createMarker(MARKER_TYPE_WRONG_LINKER);
                if (!marker.exists()) continue;
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)String.format("Linker script has deprecated section by position %s.", re.getOffset()));
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute(MARKER_LINKER_NAME, (Object)linker.getName());
                marker.setAttribute("charStart", re.getOffset());
                marker.setAttribute("charEnd", re.getExclusiveEnd());
                marker.setAttribute(MARKER_LINKER_FIX_MSG, (Object)String.format("Add/Replace deprecated section by '%s'", "KEEP(*(...))"));
                marker.setAttribute(MARKER_TYPE_FIX, (Object)MARKER_TYPE_FIX_LINKER_SECTION);
                marker.setAttribute("categoryId", (Object)"S32DSdeprecated");
            }
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static IStatus createMarkerMissedSection(Set<IFile> linkers, String msg, String section) {
        MultiStatus mt = new MultiStatus("com.nxp.s32ds.e200.checker", 0, new String(), null);
        for (IResource iResource : linkers) {
            mt.add(MarkerHandler.createMarkerMissedSection(iResource, msg, section));
        }
        return mt;
    }

    public static IStatus createMarkerMissedSection(IResource linker, String msg, String section) {
        String msgfix = String.format("Add missed section in linker script", section);
        try {
            IMarker marker = linker.createMarker(MARKER_TYPE_LINKER_CALL_MISSED);
            if (marker.exists()) {
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)msg);
                IProject project = linker.getProject();
                if (project != null) {
                    marker.setAttribute("location", (Object)project.getName());
                } else {
                    marker.setAttribute("location", (Object)linker.getName());
                }
                marker.setAttribute(MARKER_LINKER_NAME, (Object)linker.getName());
                marker.setAttribute(MARKER_LINKER_FIX_MSG, (Object)msgfix);
                marker.setAttribute(MARKER_TYPE_FIX, (Object)MARKER_TYPE_FIX_ADD_LINKER);
                marker.setAttribute(MARKER_TYPE_SECTION, (Object)section);
                marker.setAttribute("categoryId", (Object)"S32DSmissed");
            }
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static void delete(IProject project) {
        try {
            project.deleteMarkers(MARKER_TYPE_WRONG_LINKER, true, 2);
            project.deleteMarkers(MARKER_TYPE_LINKER_CALL_MISSED, true, 2);
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
        }
    }
}

