/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.e200.checker;

import com.nxp.s32ds.e200.checker.MarkerEditRegistry;
import com.nxp.s32ds.e200.checker.MarkerHandler;
import com.nxp.s32ds.e200.checker.ResourceChangeDiscovery;
import com.nxp.s32ds.ext.ide.checker.CheckerStateStore;
import com.nxp.s32ds.ext.ide.checker.IResourceChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.ReplaceEdit;

public class LinkerChecker
implements IResourceChecker {
    private static final String DTORS = "dtors";
    private static final String CTORS = "ctors";
    private static final String FINI_ARRAY = "fini_array";
    private static final String INIT_ARRAY = "init_array";
    private static final String PREINIT_ARRAY = "preinit_array";
    private static final String[] FILES = new String[]{"*.ld"};
    public static final String BUNDLE_ID = "com.nxp.s32ds.e200.checker";
    private static final String PRODUCT_VERSION_V_1 = "v1.1";
    private static final String SEARCH_INIT_REGX = "^[\\s]*(?!KEEP\\()\\*\\(\\.init\\)(?!\\))";
    private static final String SEARCH_K_INI_REGX = "KEEP\\(\\*\\(\\.init\\)\\)";
    private static final String REPLACE_INIT = "KEEP(*(.init))";
    private static final String SEARCH_FINI_REGX = "^[\\s]*(?!KEEP\\()\\*\\(\\.fini\\)(?!\\))";
    private static final String SEARCH_K_FINI_REGX = "KEEP\\(\\*\\(\\.fini\\)\\)";
    private static final String REPLACE_FINI = "KEEP(*(.fini))";
    private static final String SEARCH_CTORS = "\\.ctors";
    private static final String SEARCH_DTORS = "\\.dtors";
    private static final String SEARCH_FINI_ARRAY = "\\.fini_array";
    private static final String SEARCH_INIT_ARRAY = "\\.init_array";
    private static final String SEARCH_PREINIT_ARRAY = "\\.preinit_array";
    Map<IProject, List<IFile>> store = new HashMap<IProject, List<IFile>>();

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        MultiStatus mt = new MultiStatus(BUNDLE_ID, 0, new String(), null);
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if (!project.isOpen()) {
                return Status.OK_STATUS;
            }
            if (!this.verifyProject(project)) {
                MarkerHandler.delete(project);
                return Status.OK_STATUS;
            }
            MarkerHandler.delete(project);
            Map<String, Map<IFile, List<ReplaceEdit>>> mapProjectChanges = this.searchChangesForProject(project, monitor);
            Map<IFile, List<ReplaceEdit>> linkerChanges = this.findChangesForProject(project, monitor, mapProjectChanges);
            if (linkerChanges != null && !linkerChanges.isEmpty()) {
                for (IFile linker : linkerChanges.keySet()) {
                    if (!MarkerHandler.createMarkerDeprecatedSection((IResource)linker, project, linkerChanges.get(linker)).isOK()) continue;
                    MarkerEditRegistry.getInstance().addToRegistry(linker, linkerChanges.get(linker));
                }
            }
            List<IFile> listLinkerWithMissedSection = this.getLinkersWithMissedSection(mapProjectChanges);
            for (IFile linker : listLinkerWithMissedSection) {
                mt.add(this.checkDefinedSection(linker, SEARCH_CTORS, CTORS, monitor));
                mt.add(this.checkDefinedSection(linker, SEARCH_DTORS, DTORS, monitor));
                mt.add(this.checkDefinedSection(linker, SEARCH_PREINIT_ARRAY, PREINIT_ARRAY, monitor));
                mt.add(this.checkDefinedSection(linker, SEARCH_INIT_ARRAY, INIT_ARRAY, monitor));
                mt.add(this.checkDefinedSection(linker, SEARCH_FINI_ARRAY, FINI_ARRAY, monitor));
            }
        }
        return mt;
    }

    private List<IFile> getLinkersWithMissedSection(Map<String, Map<IFile, List<ReplaceEdit>>> mapProjectChanges) {
        ArrayList<IFile> linkerFiles = new ArrayList<IFile>();
        Map<IFile, List<ReplaceEdit>> chInit = mapProjectChanges.get(SEARCH_INIT_REGX);
        Map<IFile, List<ReplaceEdit>> chKEEPInit = mapProjectChanges.get(SEARCH_K_INI_REGX);
        for (IFile f : chInit.keySet()) {
            linkerFiles.add(f);
        }
        for (IFile f : chKEEPInit.keySet()) {
            if (linkerFiles.contains(f)) continue;
            linkerFiles.add(f);
        }
        return linkerFiles;
    }

    private IStatus checkDefinedSection(IFile linker, String sectionRegx, String sectionName, IProgressMonitor monitor) {
        boolean containsSection = this.findSectionInLinkerFile(linker, sectionRegx, monitor);
        if (!containsSection) {
            String msg = String.format("Linker script does not contain '%s' sections", sectionName);
            return MarkerHandler.createMarkerMissedSection((IResource)linker, msg, sectionName);
        }
        return Status.OK_STATUS;
    }

    public boolean verifyProject(IProject project) {
        return !CheckerStateStore.get((String)BUNDLE_ID, (IProject)project).isDone();
    }

    public boolean findSectionInLinkerFile(IFile file, String section, IProgressMonitor monitor) {
        HashMap<IFile, List<ReplaceEdit>> changes = ResourceChangeDiscovery.findInResource((IResource)file, FILES, section, new String(), monitor);
        return !changes.isEmpty();
    }

    public Map<String, Map<IFile, List<ReplaceEdit>>> searchChangesForProject(IProject project, IProgressMonitor monitor) {
        HashMap<String, Map<IFile, List<ReplaceEdit>>> mapChanges = new HashMap<String, Map<IFile, List<ReplaceEdit>>>();
        HashMap<IFile, List<ReplaceEdit>> chFini = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_FINI_REGX, new String(), monitor);
        HashMap<IFile, List<ReplaceEdit>> chInit = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_INIT_REGX, new String(), monitor);
        HashMap<IFile, List<ReplaceEdit>> chKEEPFini = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_K_FINI_REGX, new String(), monitor);
        HashMap<IFile, List<ReplaceEdit>> chKEEPInit = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_K_INI_REGX, new String(), monitor);
        mapChanges.put(SEARCH_FINI_REGX, chFini);
        mapChanges.put(SEARCH_FINI_REGX, chFini);
        mapChanges.put(SEARCH_INIT_REGX, chInit);
        mapChanges.put(SEARCH_K_FINI_REGX, chKEEPFini);
        mapChanges.put(SEARCH_K_INI_REGX, chKEEPInit);
        return mapChanges;
    }

    public Map<IFile, List<ReplaceEdit>> findChangesForProject(IProject project, IProgressMonitor monitor, Map<String, Map<IFile, List<ReplaceEdit>>> mapChanges) {
        Map<Object, Object> changes = new HashMap();
        Map<IFile, List<ReplaceEdit>> chFini = mapChanges.get(SEARCH_FINI_REGX);
        Map<IFile, List<ReplaceEdit>> chInit = mapChanges.get(SEARCH_INIT_REGX);
        Map<IFile, List<ReplaceEdit>> chKEEPFini = mapChanges.get(SEARCH_K_FINI_REGX);
        Map<IFile, List<ReplaceEdit>> chKEEPInit = mapChanges.get(SEARCH_K_INI_REGX);
        if (!chFini.isEmpty() && !chInit.isEmpty()) {
            HashMap<IFile, List<ReplaceEdit>> replacementF = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_FINI_REGX, REPLACE_FINI, monitor);
            HashMap<IFile, List<ReplaceEdit>> replacementI = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_INIT_REGX, REPLACE_INIT, monitor);
            changes = this.splitChanges(replacementF, replacementI);
        } else if (chFini.isEmpty() && !chInit.isEmpty() && chKEEPFini.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_INIT_REGX, "KEEP(*(.init))\n\t\tKEEP(*(.fini))", monitor);
        } else if (!chFini.isEmpty() && chInit.isEmpty() && chKEEPInit.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_FINI_REGX, "KEEP(*(.fini))\n\t\tKEEP(*(.init))", monitor);
        } else if (chFini.isEmpty() && !chInit.isEmpty() && !chKEEPFini.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_INIT_REGX, REPLACE_INIT, monitor);
        } else if (!chFini.isEmpty() && chInit.isEmpty() && !chKEEPInit.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_FINI_REGX, REPLACE_FINI, monitor);
        } else if (chFini.isEmpty() && chInit.isEmpty() && !chKEEPInit.isEmpty() && chKEEPFini.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_K_INI_REGX, "KEEP(*(.init))\n\t\tKEEP(*(.fini))", monitor);
        } else if (chFini.isEmpty() && chInit.isEmpty() && chKEEPInit.isEmpty() && !chKEEPFini.isEmpty()) {
            changes = ResourceChangeDiscovery.findInResource((IResource)project, FILES, SEARCH_K_FINI_REGX, "KEEP(*(.fini))\n\t\tKEEP(*(.init))", monitor);
        }
        return changes;
    }

    private Map<IFile, List<ReplaceEdit>> splitChanges(HashMap<IFile, List<ReplaceEdit>> findInResource, Map<IFile, List<ReplaceEdit>> changes) {
        if (changes == null || changes.isEmpty()) {
            return findInResource;
        }
        if (findInResource != null && !findInResource.isEmpty()) {
            for (Map.Entry<IFile, List<ReplaceEdit>> it : findInResource.entrySet()) {
                if (changes.containsKey(it.getKey())) {
                    List<ReplaceEdit> lstTarget = changes.get(it.getKey());
                    lstTarget.addAll((Collection<ReplaceEdit>)it.getValue());
                    changes.put(it.getKey(), lstTarget);
                    continue;
                }
                changes.put(it.getKey(), it.getValue());
            }
        }
        return changes;
    }
}

