/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.e200.resolution;

import com.freescale.s32ds.e200.resolution.IgnoreQuickFix;
import com.freescale.s32ds.e200.resolution.LinkerFileQuickFix;
import com.freescale.s32ds.e200.resolution.LinkerSectionsQuickFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class LinkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final String IGNORE_S32DS_MIGRATION_PROBLEMS = "Ignore all migration problems for project";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            String type = (String)marker.getAttribute("Fix type");
            String message = (String)marker.getAttribute("linker.fix.msg");
            if ("Fixing linker section".equals(type)) {
                return new IMarkerResolution[]{new LinkerFileQuickFix(message, marker), new IgnoreQuickFix(IGNORE_S32DS_MIGRATION_PROBLEMS, marker)};
            }
            if ("Add linker section".equals(type)) {
                return new IMarkerResolution[]{new LinkerSectionsQuickFix(message, marker), new IgnoreQuickFix(IGNORE_S32DS_MIGRATION_PROBLEMS, marker)};
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return new IMarkerResolution[0];
    }
}

