/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.e200.resolution;

import com.freescale.s32ds.e200.resolution.QuickFixUtil;
import com.nxp.s32ds.e200.checker.MarkerEditRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class LinkerFileQuickFix
extends WorkbenchMarkerResolution {
    String label;
    public String DESCRIPTION = "Description";
    private static final String ERROR_DIALOG_TITLE = "Error dialog";
    private IMarker selectedMarker;

    public LinkerFileQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        IStatus status = Status.OK_STATUS;
        try {
            if (!marker.exists()) {
                return;
            }
            String linkerFileName = (String)marker.getAttribute("linker.file");
            if (marker.getResource() instanceof IFile) {
                IFile file = (IFile)marker.getResource();
                IEditorPart editPart = QuickFixUtil.openInEditor(linkerFileName, file);
                IDocument document = QuickFixUtil.openDocument(editPart);
                if (document != null) {
                    status = this.modifyDocument(file, document);
                    if (status.isOK()) {
                        editPart.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    status = new Status(4, "com.nxp.s32ds.e200.checker", "Failed open document");
                }
            }
        }
        catch (CoreException e) {
            status = e.getStatus();
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        if (!status.isOK()) {
            Display disp = Display.getDefault();
            ErrorDialog.openError((Shell)disp.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)"", (IStatus)status);
        }
    }

    public IStatus modifyDocument(IFile linkerFile, IDocument document) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.e200.checker", 0, new String(), null);
        List<ReplaceEdit> lstEdits = MarkerEditRegistry.getInstance().getMarkerEdit(linkerFile);
        if (lstEdits == null || lstEdits.isEmpty()) {
            result.add((IStatus)new Status(4, "com.nxp.s32ds.e200.checker", "Rules for marker not found"));
            return result;
        }
        MultiTextEdit mte = new MultiTextEdit();
        for (ReplaceEdit it : lstEdits) {
            mte.addChild((TextEdit)it);
        }
        try {
            mte.apply(document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            result.add((IStatus)new Status(4, "com.nxp.s32ds.e200.checker", e.getMessage(), e));
        }
        return result;
    }

    public String getDescription() {
        return this.DESCRIPTION;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker it = iMarkerArray[n2];
            if (!it.equals((Object)this.selectedMarker)) {
                try {
                    String type = (String)it.getAttribute("Fix type");
                    if ("Fixing linker section".equals(type)) {
                        lstMarkers.add(it);
                    }
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }
}

