/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.e200.resolution;

import com.nxp.s32ds.ext.ide.checker.CheckerStateStore;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.osgi.service.prefs.BackingStoreException;

public class IgnoreQuickFix
extends WorkbenchMarkerResolution {
    private final String label;
    private String DESCRIPTION = "Ignore this error";
    private IMarker selectedMarker;
    private static final String ERROR_DIALOG_TITLE = "Error migration dialog";

    public IgnoreQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        IStatus status = Status.OK_STATUS;
        try {
            IProject project = null;
            if (marker.getResource() instanceof IFile) {
                IFile file = (IFile)marker.getResource();
                project = file.getProject();
            } else if (marker.getResource() instanceof IProject) {
                project = (IProject)marker.getResource();
            }
            if (project != null) {
                CheckerStateStore checkerStateStore = CheckerStateStore.get((String)"com.nxp.s32ds.e200.checker", (IProject)project);
                checkerStateStore.setDone(true);
                checkerStateStore.flush();
            }
        }
        catch (BackingStoreException e) {
            Status errorStatus = new Status(4, "com.nxp.s32ds.e200.checker", e.getMessage());
            ResourcesPlugin.getPlugin().getLog().log((IStatus)errorStatus);
            status = errorStatus;
        }
        if (!status.isOK()) {
            Display disp = Display.getDefault();
            ErrorDialog.openError((Shell)disp.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)"", (IStatus)status);
        }
    }

    public String getDescription() {
        return this.DESCRIPTION;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker it = iMarkerArray[n2];
            if (!it.equals((Object)this.selectedMarker)) {
                try {
                    String type = (String)it.getAttribute("Fix type");
                    String typeSelected = (String)this.selectedMarker.getAttribute("Fix type");
                    if (typeSelected.equals(type)) {
                        lstMarkers.add(it);
                    }
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }
}

