package com.freescale.s32ds.cross.sdk.MPC574xx_1_0_0.pexconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

class PExConfigAdjuster {
	private static final String[] sourceFolders = new String[] { "SDK", "Generated_Code", "Sources" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	private static final String[] includeFolders = new String[]{"Generated_Code", "Sources"};  //$NON-NLS-1$ //$NON-NLS-2$
	private static final String[] backupFolders = new String[] { "Project_Settings", "src", "include" };//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	private static final String[] backupFiles = new String[] { ".cproject" }; //$NON-NLS-1$

	private static final Map<String, String> toolchainsIncludeOptions = new HashMap<String, String>(); 
	{
		// GCC
		toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.compiler", "gnu.c.compiler.option.include.paths"); //$NON-NLS-1$ //$NON-NLS-2$
		toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.cpp.compiler", "gnu.cpp.compiler.option.include.paths"); //$NON-NLS-1$ //$NON-NLS-2$
		toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.assembler", "gnu.both.asm.option.include.paths"); //$NON-NLS-1$ //$NON-NLS-2$
		// GHS
		toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cx_compiler", "ghs.managedmake.ppc.executable.toolchain.cx_compiler.project.include_directories"); //$NON-NLS-1$ //$NON-NLS-2$
		toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.project.include_directories"); //$NON-NLS-1$ //$NON-NLS-2$
		// DIAB
		toolchainsIncludeOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.includePath"); //$NON-NLS-1$ //$NON-NLS-2$
		toolchainsIncludeOptions.put("com.windriver.cdt.diab.tool.compiler.cxx", "com.windriver.cdt.diab.option.compiler.includePath"); //$NON-NLS-1$ //$NON-NLS-2$
	};

	protected static final Map<String, String> toolchainsAsmOptions = new HashMap<String, String>(); 
	{
		// GCC
		toolchainsAsmOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.assembler", "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs"); //$NON-NLS-1$ //$NON-NLS-2$
		// GHS
		//toolchainsAsmOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.preprocessor.define_preprocessor_symbol");
		// DIAB
	toolchainsAsmOptions.put("com.windriver.cdt.diab.tool.assembler", "com.windriver.cdt.diab.option.assembler.defines"); //$NON-NLS-1$ //$NON-NLS-2$
	};
	protected static final List<String> AsmDefines = Arrays.asList("SEMIHOSTING"); //$NON-NLS-1$    

	protected static final Map<String, String> toolchainsCOptions = new HashMap<String, String>(); 
	{
		// GCC
		toolchainsCOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.compiler", "gnu.c.compiler.option.preprocessor.def.symbols"); //$NON-NLS-1$ //$NON-NLS-2$
		// GHS
		//toolchainsCOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.preprocessor.define_preprocessor_symbol");
		// DIAB
	toolchainsCOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.defines"); //$NON-NLS-1$ //$NON-NLS-2$
	};

	protected static final Map<String, String> toolchainsLinkerOptions = new HashMap<String, String>(); 
	{
		// GCC
		toolchainsLinkerOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.linker", "com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile"); //$NON-NLS-1$ //$NON-NLS-2$
		// GHS
		//toolchainsCOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.preprocessor.define_preprocessor_symbol");
		// DIAB
		toolchainsLinkerOptions.put("com.windriver.cdt.diab.tool.linker.c", "com.windriver.cdt.diab.option.linker.other"); //$NON-NLS-1$ //$NON-NLS-2$
	};

	protected static final Map<String, String> toolchainsOtherOptions = new HashMap<String, String>(); 
	{
		// GCC
		toolchainsOtherOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.linker", "com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile"); //$NON-NLS-1$ //$NON-NLS-2$
		// DIAB
		toolchainsOtherOptions.put("com.windriver.cdt.diab.tool.compiler.c", "com.windriver.cdt.diab.option.compiler.other"); //$NON-NLS-1$ //$NON-NLS-2$
		toolchainsOtherOptions.put("com.windriver.cdt.diab.tool.linker.c", "com.windriver.cdt.diab.option.linker.other"); //$NON-NLS-1$ //$NON-NLS-2$
	};
	protected static final Map<String, List<String>> OtherOptions = new HashMap<String, List<String>>(); 
	{
		OtherOptions.put("com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile", //$NON-NLS-1$ 
				Arrays.asList("")); //$NON-NLS-1$
		
		OtherOptions.put("com.windriver.cdt.diab.option.compiler.other", //$NON-NLS-1$
				Arrays.asList("-ei5388,5387,1824", //$NON-NLS-1$
				"-Wa,-Xisa-vle", "-Xdialect-c99", "-Xsmall-data=0", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				"-Xsmall-const=0", "-Xdebug-dwarf2", "-Xdebug-local-all", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				"-Xdebug-local-cie", "-Xdebug-struct-all" )); //$NON-NLS-1$ //$NON-NLS-2$
		OtherOptions.put("com.windriver.cdt.diab.option.linker.other", //$NON-NLS-1$ 
				Arrays.asList("-Xpreprocess-lecl", "-m6 > ${ProjName}.map")); //$NON-NLS-1$
	};

	protected IProject project;

	PExConfigAdjuster(IProject project) {
		this.project = project;
	}

	void adjustPExConfiguration() {
		try {
			backupProjectResources();
			createSourceEntries();
			adjustOptions();
			cleanupFolders();
		} catch (Exception e) {
			Activator.log(e);
		}
	}

	protected void setOptions(IOption option, String idx, List<String> l, Map<String, List<String>> m) {
		try {
			if (option != null && option.getBasicValueType() == IOption.STRING_LIST) {
				Set<String> opt = new LinkedHashSet<>();
				if (l != null) {
					opt.addAll(l);
				}
				if (m!= null && m.containsKey(idx)) {
					opt.addAll(m.get(idx));
				}
				option.setValue(new ArrayList<String>(opt));
			}
		} catch (BuildException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	protected void insertOptions(IOption option, String idx, List<String> l, Map<String, List<String>> m, int pos) {
		try {
			if (option != null && option.getBasicValueType() == IOption.STRING_LIST) {
				Set<String> old = new LinkedHashSet<>(Arrays.asList(option.getBasicStringListValue()));
				setOptions(option, idx, l, m);
				Set<String> cur = new LinkedHashSet<>(Arrays.asList(option.getBasicStringListValue()));
				if (pos == 0) {
					cur.addAll(old);
					option.setValue(new ArrayList<String>(cur));
				}
				else {
					old.addAll(cur);
					option.setValue(new ArrayList<String>(old));
				}
			}
		} catch (BuildException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	protected void adjustOptions() throws BuildException {
	IConfiguration[] configs = ManagedBuildManager.getBuildInfo(project).getManagedProject().getConfigurations();
	for (IConfiguration config : configs) {
			ITool[] tools = config.getTools();
			for (ITool tool : tools) {
				String toolBaseId = tool.getBaseId();
				String optionSuperClassId;

				optionSuperClassId = toolchainsIncludeOptions.get(toolBaseId);
				if(optionSuperClassId != null) {
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					for(String includeFolder: includeFolders) {
						addOptionValue(option, includeFolder);
					}
				}

				optionSuperClassId = toolchainsAsmOptions.get(toolBaseId);
				if (optionSuperClassId != null) {
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					insertOptions(option, null, AsmDefines, null, 0);
				}
				
				optionSuperClassId = toolchainsOtherOptions.get(toolBaseId);
				if (optionSuperClassId != null) {
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					setOptions(option, optionSuperClassId, null, OtherOptions);
				}
			}
		}
	}

	protected void createSourceEntries() throws CoreException {
		Set<ICSourceEntry> additionalSourceEntrires = new HashSet<>();
		for (String sourceFolder : sourceFolders) {
			additionalSourceEntrires.add(new CSourceEntry(project.getFolder(sourceFolder), null, 0));
		}
		ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(project);
		for (ICConfigurationDescription config : description.getConfigurations()) {
			Set<ICSourceEntry> sourceEntries = new HashSet<>(Arrays.asList(config.getSourceEntries()));
			sourceEntries.addAll(additionalSourceEntrires);
			config.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
		}
		CCorePlugin.getDefault().setProjectDescription(project, description, false, new NullProgressMonitor());
	}

	protected void addOptionValue(IOption opt, String value) throws BuildException {
		if (opt == null) {
			return;
		}
		List<String> curValueList = new ArrayList<>(Arrays.asList(opt.getBasicStringListValue()));
		curValueList.add("\"${ProjDirPath}/" + value + "\""); //$NON-NLS-1$ //$NON-NLS-2$
		opt.setValue(curValueList);
	}

	protected void addOptionValue(int pos, IOption opt, String value) throws BuildException {
		if (opt == null || pos < 0) {
			return;
		}
		if (opt.getBasicValueType() == IOption.STRING_LIST) {
			List<String> curValueList;
			curValueList = new ArrayList<>(Arrays.asList(opt.getBasicStringListValue()));
			if (!curValueList.contains(value))
				curValueList.add(pos, value);
			opt.setValue(curValueList);
		}
	}

	protected void cleanupFolder(String path, List<String> exclude) throws CoreException {
		IFolder fld = project.getFolder(path);
		if (fld.exists() && !fld.isLinked()) {
			for (IResource fx : fld.members()) {
				if (fx instanceof IFile) {
					IPath fullPath = fx.getFullPath();
					if (fullPath.segmentCount() > 0) {
						String lastSegment = fullPath.lastSegment().toLowerCase();
						if (exclude == null || !exclude.stream().anyMatch(lastSegment::equalsIgnoreCase)) {
							fx.delete(true, new NullProgressMonitor());
						}
					}
				}
			}
		}
	}

	protected void cleanupFolders(Map<String, List<String>> cleanup) throws CoreException {
		for (Map.Entry<String, List<String>> entry : cleanup.entrySet()) {
		    cleanupFolder(entry.getKey(), entry.getValue());
		}
	}

	/**
	 * May be overriden by PExConfig*Adjuster classes if necessary.
	 */
	protected void cleanupFolders() throws CoreException {
		cleanupFolder("include", null);
		cleanupFolder("src", null);
		IFolder fld = project.getFolder("src"); //$NON-NLS-1$
		if (fld.exists() && !fld.isLinked()) {
			fld.delete(true, new NullProgressMonitor());
		}
	}

	protected void backupProjectResources() throws CoreException {
		Stream.of(backupFiles)
				.map(f -> project.getFile(f))
				.filter(file -> (file.exists() && !file.isLinked()))
				.forEach(this::backupFile);

		Stream.of(backupFolders)
				.map(f -> project.getFolder(f))
				.filter(fld -> (fld.exists() && !fld.isLinked()))
				.forEach(this::backupFolder);
	}

	/**
	 * May be called from PExConfig*Adjuster classes for backup folders that are
	 * not defined in global list.
	 * 
	 * @param sourceFolder
	 *            folder to be backed up.
	 */
	protected void backupFolder(IFolder sourceFolder) {
		try {
			IFolder folder = project.getFolder(sourceFolder.getName() + ".bak");
			if (folder == null || folder.exists()) {
				return;
			}
			folder.create(IResource.FORCE, true, new NullProgressMonitor());
			IPath newFolderPath = folder.getFullPath();
			for (IResource resource : sourceFolder.members()) {
				IPath copyToPath = newFolderPath.append(resource.getFullPath().lastSegment());
				resource.copy(copyToPath, true, new NullProgressMonitor());
			}
			folder.accept(new IResourceVisitor() {
				@Override
				public boolean visit(IResource backupResource) throws CoreException {
					if (IResource.FILE == backupResource.getType()) {
						backupFile((IFile) backupResource, true);
					}
					return true;
				}
			});

		} catch (CoreException ce) {
			Activator.log(ce);
		}
	}

	/**
	 * May be called from PExConfig*Adjuster classes for backup files that are
	 * not defined in global list.
	 * 
	 * @param sourceFile
	 *            file to be backed up.
	 */
	protected void backupFile(IFile sourceFile) {
		backupFile(sourceFile, false);
	}

	protected void backupFile(IFile sourceFile, boolean isDeleteSource) {
		try {
			String pathStr = sourceFile.getFullPath().lastSegment() + ".bak";
			IFile file = project.getFile(pathStr);
			if (file.exists()) {
				return;
			}
			if (isDeleteSource) {
				sourceFile.move(new Path(pathStr), true, new NullProgressMonitor());
			} else {
				sourceFile.copy(new Path(pathStr), true, new NullProgressMonitor());
			}
		} catch (CoreException ce) {
			Activator.log(ce);
		}
	}
}
