package com.freescale.s32ds.cross.sdk.MPC574xx_1_0_0.pexconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

class PExConfig5745bAdjuster extends PExConfigAdjuster {

	PExConfig5745bAdjuster(IProject project) {
		super(project);
	}

	private static final String CPU_NAME = "MPC5745B"; //$NON-NLS-1$
	private static final String CPU_DEFINE = "CPU_"+CPU_NAME; //$NON-NLS-1$

	private static final Map<String, String> corePostfix = new HashMap<String, String>();
	static {
		corePostfix.put("", "0"); //$NON-NLS-1$ //$NON-NLS-2$
	};
	protected String getCoreIdx() {
		//dirty hack to find out core number
		for (String key : corePostfix.keySet()) {
			if (project.getName().indexOf(key) != -1) {
				return corePostfix.get(key);
			}
		}
		return ""; //$NON-NLS-1$
	}

	protected static final Map<String, List<String>> AsmDefines = new HashMap<String, List<String>>(); 
	{
		AsmDefines.put("0", Arrays.asList(CPU_DEFINE, "TURN_ON_CPU0")); //$NON-NLS-1$ //$NON-NLS-2$
		AsmDefines.put("1", Arrays.asList(CPU_DEFINE, "TURN_ON_CPU1")); //$NON-NLS-1$ //$NON-NLS-2$
		AsmDefines.put("2", Arrays.asList(CPU_DEFINE, "TURN_ON_CPU2")); //$NON-NLS-1$ //$NON-NLS-2$
	};
	protected static final List<String> CDefines = Arrays.asList(CPU_DEFINE);

	private static final String linkerFilesPath = "Project_Settings/Linker_Files"; //$NON-NLS-1$
	private static final List<String> excludedLinkerFiles = Arrays.asList(
			CPU_NAME+"_flash.ld", //$NON-NLS-1$
			CPU_NAME+"_ram.ld", //$NON-NLS-1$
			CPU_NAME+"_flash.dld", //$NON-NLS-1$
			CPU_NAME+"_ram.dld", //$NON-NLS-1$
			"default.ld" //$NON-NLS-1$
			);

	protected static final List<String> LinkerFlags = 
			Arrays.asList("$(ProjDirPath)/" + linkerFilesPath + "/" + CPU_DEFINE);

	private static final String startupFilesPath = "Project_Settings/Startup_Code"; //$NON-NLS-1$
	private static final List<String> excludedStartupFiles = Arrays.asList(
			"startup_"+CPU_NAME+".s", //$NON-NLS-1$ //$NON-NLS-2$
			"startup_"+CPU_NAME+".S", //$NON-NLS-1$ //$NON-NLS-2$
			"interrupt_vectors.S", //$NON-NLS-1$
			"core0_intc_sw_handlers.S", //$NON-NLS-1$
			"core1_intc_sw_handlers.S", //$NON-NLS-1$
			"core2_intc_sw_handlers.S" //$NON-NLS-1$
			);
	private static final Map<String, List<String>> cleanup = new HashMap<String, List<String>>(); 
	{
		cleanup.put(linkerFilesPath, excludedLinkerFiles);
		cleanup.put(startupFilesPath, excludedStartupFiles);
	};
	
	protected void adjustOptions() throws BuildException {
		super.adjustOptions();
		IConfiguration[] configs = ManagedBuildManager.getBuildInfo(project).getManagedProject().getConfigurations();
		for (IConfiguration config : configs) {
			ITool[] tools = config.getTools();
			for (ITool tool : tools) {
				String toolBaseId = tool.getBaseId();
				String coreIdx = getCoreIdx();

				String optionSuperClassId = toolchainsAsmOptions.get(toolBaseId);
				if (optionSuperClassId != null) { 
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					insertOptions(option, coreIdx, null, AsmDefines, 0);
				}

				optionSuperClassId = toolchainsCOptions.get(toolBaseId);
				if (optionSuperClassId != null) { 
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					insertOptions(option, null, CDefines, null, 0);
				}
				
				
				optionSuperClassId = toolchainsLinkerOptions.get(toolBaseId);
				if (optionSuperClassId != null) {
					IOption option = tool.getOptionToSet(tool.getOptionBySuperClassId(optionSuperClassId), false);
					String ld_file = "\"${ProjDirPath}/" + linkerFilesPath + "/" + CPU_NAME;
					if (config.getName().equals("Debug_RAM")) { //$NON-NLS-1$
						ld_file += "_ram"; //$NON-NLS-1$
					}
					else {
						ld_file += "_flash"; //$NON-NLS-1$
					}
					if (toolBaseId.equals("com.windriver.cdt.diab.tool.linker.c")) { //$NON-NLS-1$
						ld_file += ".dld\""; //$NON-NLS-1$
					}
					else {
						ld_file += ".ld\""; //$NON-NLS-1$
					}
					List<String> l = Arrays.asList(ld_file);
					insertOptions(option, null, l, null, -1);
				}
			}
		}
	}

	protected void cleanupFolders() throws CoreException {
		super.cleanupFolders();
		cleanupFolders(cleanup);
	}
}
