package com.freescale.s32ds.cross.sdk.MPC574xx_1_0_0.pexconf;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;

public class PExConfig implements ISDKHook {
	protected static final int MODE_BEFORE_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_BEFORE;
	protected static final int MODE_AFTER_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_AFTER;

	private static final int MODE_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_AFTER;

	public PExConfig() {
	}

	@Override
	public void stateChange(int mode, ISDK sdk, Object cfg, String path) {
		if (mode == MODE_ALL) {
			IProject curProject = getProject(cfg);
			if (curProject != null) {
				new PExConfigAdjuster(curProject).adjustPExConfiguration();
				ManagedBuildManager.saveBuildInfo(curProject, true);
			}
		}
	}

	protected IProject getProject(Object cfg) {
		IProject curProject = null;
		if (cfg instanceof ICConfigurationDescription) {
			ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
			curProject = cfgd.getProjectDescription().getProject();
		} else if (cfg instanceof IConfiguration) {
			curProject = (IProject) ((IConfiguration) cfg)
			        .getManagedProject().getOwner();
		} else {
			Activator.log(new IllegalArgumentException("Fail to invoke PExConfig Hook")); //$NON-NLS-1$
		}
		return curProject;
	}
}