/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cll;

import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;

public class CLL
implements ICLL {
    private static final boolean IS_OS_WINDOWS = CLL.getOSMatchesName("Windows");
    private static final boolean IS_OS_LINUX = CLL.getOSMatchesName("Linux") || CLL.getOSMatchesName("LINUX");
    private static final boolean is64 = System.getProperty("os.arch").contains("64");
    private static final String[] libs = CLL.initLibList();

    static {
        if (!IS_OS_WINDOWS && !IS_OS_LINUX) {
            throw new IllegalStateException("Can't detect OS: " + System.getProperty("os.name"));
        }
        try {
            CLL.loadLibs();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            CLL.loadLibsFromJar();
        }
    }

    private static void loadLibs() {
        if (IS_OS_LINUX) {
            System.loadLibrary("clljni");
        } else {
            String[] stringArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                System.loadLibrary(lib);
                ++n2;
            }
        }
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        return CLL.isOSNameMatch(System.getProperty("os.name"), osNamePrefix);
    }

    private static void loadLibsFromJar() {
        String libOSName;
        String lib;
        String outputFolder;
        final LinkedList<File> deleteFiles = new LinkedList<File>();
        try {
            outputFolder = String.valueOf(Files.createTempDirectory("s32dsCLLlibs", new FileAttribute[0]).toString()) + File.separator;
            deleteFiles.add(new File(outputFolder));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp folder", e);
        }
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            lib = stringArray[n2];
            try {
                libOSName = IS_OS_LINUX && "FnpCommsSoap".equals(lib) ? "FnpCommsSoap.so" : System.mapLibraryName(lib);
                InputStream in = CLL.class.getResourceAsStream(String.valueOf(is64 ? "/x64/" : "/i86/") + libOSName);
                String libPath = String.valueOf(outputFolder) + libOSName;
                Files.copy(in, Paths.get(libPath, new String[0]), new CopyOption[0]);
                deleteFiles.addFirst(new File(libPath));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to unpack required library: " + lib, e);
            }
            ++n2;
        }
        stringArray = libs;
        n = libs.length;
        n2 = 0;
        while (n2 < n) {
            lib = stringArray[n2];
            libOSName = IS_OS_LINUX && "FnpCommsSoap".equals(lib) ? "FnpCommsSoap.so" : System.mapLibraryName(lib);
            String libPath = String.valueOf(outputFolder) + libOSName;
            if (IS_OS_LINUX) {
                if ("clljni".equals(lib)) {
                    System.load(libPath);
                }
            } else {
                System.load(libPath);
            }
            ++n2;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (File f : deleteFiles) {
                    f.delete();
                }
            }
        });
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    @Override
    public CLLReason installService(String productName) {
        return CLL.cllInstallService(productName);
    }

    private static native CLLReason cllInstallService(String var0);

    @Override
    public CLLReason uninstallService(String productName) {
        return CLL.cllUninstallService(productName);
    }

    private static native CLLReason cllUninstallService(String var0);

    @Override
    public CLLReason verifyLicenseAvailability(String productName, String featureName, String version) {
        return CLL.cllVerifyLicenseAvailability(productName, featureName, version);
    }

    private static native CLLReason cllVerifyLicenseAvailability(String var0, String var1, String var2);

    @Override
    public CLLFeatureDetail listActivatedFeatures(String activationID, CLLReason ppReason) {
        return CLL.cllListActivatedFeatures(activationID, ppReason);
    }

    private static native CLLFeatureDetail cllListActivatedFeatures(String var0, CLLReason var1);

    @Override
    public CLLReason loadASR(String ASRFileName) {
        return CLL.cllLoadASR(ASRFileName);
    }

    private static native CLLReason cllLoadASR(String var0);

    @Override
    public CLLReason setLicenseLocation(String directory, String serverNameOrIP, int serverPort) {
        return CLL.cllSetLicenseLocation(directory, serverNameOrIP, serverPort);
    }

    private static native CLLReason cllSetLicenseLocation(String var0, String var1, int var2);

    @Override
    public CLLReason configureProxy(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        return CLL.cllConfigureProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    private static native CLLReason cllConfigureProxy(String var0, int var1, String var2, String var3);

    @Override
    public CLLReason activateLicense(String activationID, CLLActivationType activationType, String saveFileName, Long duration, Long quantity) {
        return CLL.cllActivateLicense(activationID, activationType, saveFileName, duration, quantity);
    }

    private static native CLLReason cllActivateLicense(String var0, CLLActivationType var1, String var2, long var3, long var5);

    @Override
    public CLLReason processOfflineResponse(String responseFileName) {
        return CLL.cllProcessOfflineResponse(responseFileName);
    }

    private static native CLLReason cllProcessOfflineResponse(String var0);

    @Override
    public CLLReason repairLicense(String activationID, boolean bOfflineFNO, String saveFileName) {
        return CLL.cllRepairLicense(activationID, bOfflineFNO, saveFileName);
    }

    private static native CLLReason cllRepairLicense(String var0, boolean var1, String var2);

    @Override
    public CLLReason returnLicense(String activationID, boolean bOfflineFNO, String saveFileName) {
        return CLL.cllReturnLicense(activationID, bOfflineFNO, saveFileName);
    }

    private static native CLLReason cllReturnLicense(String var0, boolean var1, String var2);

    @Override
    public CLLFeatureDetail listFeatures(String productName, String featureName, String version, CLLReason ppReason) {
        return CLL.cllListFeatures(productName, featureName, version, ppReason);
    }

    private static native CLLFeatureDetail cllListFeatures(String var0, String var1, String var2, CLLReason var3);

    @Override
    public CLLReason checkoutFeature(String productName, String featureName, String version, CLLFeatureDetail ppFeatureDetail, boolean bTest) {
        return CLL.cllCheckoutFeature(productName, featureName, version, ppFeatureDetail, bTest);
    }

    private static native CLLReason cllCheckoutFeature(String var0, String var1, String var2, CLLFeatureDetail var3, boolean var4);

    @Override
    public CLLReason refreshLicense(String activationID, boolean bOfflineFNO, String saveFileName, long duration, long quantity) {
        return CLL.cllRefreshLicense(activationID, bOfflineFNO, saveFileName, duration, quantity);
    }

    private static native CLLReason cllRefreshLicense(String var0, boolean var1, String var2, long var3, long var5);

    @Override
    public void checkinFeature(String featureName) {
        CLL.cllCheckinFeature(featureName);
    }

    private static native void cllCheckinFeature(String var0);

    @Override
    public void setFNOUrlForTesting(boolean bUseTestUrl) {
        CLL.cllSetFNOUrlForTesting(bUseTestUrl);
    }

    private static native void cllSetFNOUrlForTesting(boolean var0);

    private static String[] initLibList() {
        if (IS_OS_LINUX) {
            return new String[]{"cll_app_libFNP", "cll_app", "cll_svr_libFNP", "cll_svr", "FnpCommsSoap", "clljni"};
        }
        return new String[]{"FNP_Act_Installer", "cll_app_libFNP", "cll_app", "cll_svr_libFNP", "cll_svr", "FnpCommsSoap", "clljni"};
    }
}

