/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.ui;

import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTDirective;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionOption;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionParam;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SPTInstructionDialog
extends TitleAreaDialog {
    private ISPTInstruction instruction;
    private Map<Control, Boolean> allParams;
    private String result;
    private Button okButton;

    SPTInstructionDialog(Shell parent, ISPTInstruction instruction) {
        super(parent);
        this.instruction = instruction;
        this.allParams = new LinkedHashMap<Control, Boolean>();
    }

    String getResult() {
        return this.result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Set Instruction Parameters");
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)contents);
        this.setTitle(String.format("%s instruction", this.instruction.getName().toUpperCase()));
        this.setMessage("Please define options and parameters for instruction:");
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createWidgets(contents);
        SPTInstructionDialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void okPressed() {
        this.result = this.getInstruction();
        super.okPressed();
    }

    private String getInstruction() {
        StringBuilder sb = new StringBuilder();
        boolean isLabelDirective = this.instruction.getName().equals(".label");
        if (!isLabelDirective) {
            sb.append(this.instruction.getName()).append(' ');
        }
        for (Control c : this.allParams.keySet()) {
            String text;
            if (c instanceof Combo) {
                Combo combo = (Combo)c;
                int selectionIndex = combo.getSelectionIndex();
                if (selectionIndex >= 0) {
                    sb.append(combo.getItem(selectionIndex));
                    if (this.allParams.get(c).booleanValue()) {
                        sb.append(',');
                    }
                }
            } else if (c instanceof Text && !(text = ((Text)c).getText()).trim().isEmpty()) {
                if (isLabelDirective) {
                    sb.append(text.toUpperCase()).append(':');
                } else {
                    sb.append(text);
                    if (this.allParams.get(c).booleanValue()) {
                        sb.append(',');
                    }
                }
            }
            sb.append(' ');
        }
        String result = sb.toString().trim();
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void createWidgets(Composite contents) {
        List<ISPTInstructionParam> params = this.instruction.getParams();
        for (ISPTInstructionParam param : params) {
            Label l = new Label(contents, 0);
            l.setText(String.valueOf(param.getName().toUpperCase()) + ":");
            if (this.instruction instanceof ISPTDirective) {
                Text t = new Text(contents, 2052);
                t.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                t.setText(((ISPTDirective)this.instruction).getDirective().getParamLabel());
                this.allParams.put((Control)t, false);
                continue;
            }
            if (param instanceof ISPTInstructionOption) {
                ISPTInstructionOption option = (ISPTInstructionOption)param;
                if (option.getValues().isEmpty()) {
                    this.allParams.put((Control)this.createTextField(contents, option), option.isCommaNeeded());
                    continue;
                }
                this.allParams.put((Control)this.createCombo(contents, option), option.isCommaNeeded());
                continue;
            }
            this.allParams.put((Control)this.createTextField(contents, param), param.isCommaNeeded());
        }
    }

    private Combo createCombo(Composite contents, ISPTInstructionOption option) {
        Combo c = new Combo(contents, 12);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (String pe : option.getValues()) {
            c.add(pe);
        }
        c.select(0);
        c.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPTInstructionDialog.this.validate();
            }
        });
        return c;
    }

    private Text createTextField(Composite contents, ISPTInstructionParam option) {
        Text t = new Text(contents, 2052);
        t.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ISPTInstructionParam.Type type = option.getType();
        if (type != null) {
            t.setText(type.getMask());
        }
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SPTInstructionDialog.this.validate();
            }
        });
        return t;
    }

    private void validate() {
        this.okButton.setEnabled(true);
        for (Control c : this.allParams.keySet()) {
            if (c instanceof Combo) {
                if (((Combo)c).getSelectionIndex() >= 0) continue;
                this.okButton.setEnabled(false);
                return;
            }
            if (!(c instanceof Text) || !((Text)c).getText().trim().isEmpty()) continue;
            this.okButton.setEnabled(false);
            return;
        }
    }
}

