/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.ui;

import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionGroup;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.ui.SPTInstructionDialog;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

class SPTExplorerDragSourceListener
extends ADragSourceListener {
    private static final String SPT_SOURCE_CONTENT_TYPE_ID = "com.freescale.s32ds.cross.gnu.e200.sptSource";

    SPTExplorerDragSourceListener(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite workbenchPartSite) {
        super(abstractTreeViewer, workbenchPartSite);
    }

    protected boolean isProcessDataDragAndDrop(Object data) {
        return data instanceof ISPTInstruction && !(data instanceof ISPTInstructionGroup) && this.isDropTargetValid();
    }

    protected void performDragSetData(DragSourceEvent event, Object data) {
        if (data instanceof SPTInstruction) {
            String result = null;
            ISPTInstruction inst = (ISPTInstruction)data;
            if (!inst.getParams().isEmpty()) {
                SPTInstructionDialog id = new SPTInstructionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), inst);
                if (id.open() == 0) {
                    result = id.getResult();
                }
            } else {
                result = inst.getSignature();
            }
            event.data = result != null ? result : " ";
        }
    }

    protected void performDragFinished(DragSourceEvent event) {
    }

    private boolean isDropTargetValid() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return false;
        }
        IWorkingCopy tuDst = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (tuDst == null) {
            return false;
        }
        return tuDst.getContentTypeId().equals(SPT_SOURCE_CONTENT_TYPE_ID);
    }
}

