/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.ui;

import com.freescale.s32ds.cross.core.SPTSettings;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorer;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerContentProvider;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerLabelProvider;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import com.nxp.s32ds.cross.spt.explorer.Activator;
import com.nxp.s32ds.cross.spt.explorer.internal.SPTInstructionsParser;
import com.nxp.s32ds.cross.spt.explorer.internal.SPTInstructionsRoot;
import com.nxp.s32ds.cross.spt.explorer.ui.SPTExplorerContentProvider;
import com.nxp.s32ds.cross.spt.explorer.ui.SPTExplorerDragSourceListener;
import com.nxp.s32ds.cross.spt.explorer.ui.SPTExplorerLabelProvider;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class SPTExplorer
extends ADnDExplorer {
    private static final String SIRIUS_MODELINGPROJECT_NATURE = "org.eclipse.sirius.nature.modelingproject";
    private static SPTInstructionsRoot root = SPTInstructionsParser.parse();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject selectedProject = this.getValidProjectFromSelection(selection);
        if (selectedProject != null) {
            this.updateTree(selectedProject);
        } else {
            this.updateTree(null);
        }
    }

    protected ADnDExplorerContentProvider newContentProvider() {
        return new SPTExplorerContentProvider(this.getTreeViewer());
    }

    protected ADnDExplorerLabelProvider newLabelProvider() {
        return new SPTExplorerLabelProvider();
    }

    protected ADragSourceListener newDragSourceListener() {
        return new SPTExplorerDragSourceListener((AbstractTreeViewer)this.getTreeViewer(), this.getSite());
    }

    protected Object getData() {
        String version;
        block19: {
            version = null;
            if (this.project == null) {
                root.setSptVersion(null);
                return root;
            }
            try {
                IProject[] projects;
                String selectedProjectName = this.project.getName();
                if (this.project.hasNature(SIRIUS_MODELINGPROJECT_NATURE)) {
                    version = this.getVersion(selectedProjectName, this.project.getFolder("model"));
                    break block19;
                }
                version = SPTSettings.loadVersion((IProject)this.project);
                if (version != null && !version.isEmpty()) {
                    root.setSptVersion(version);
                    return root;
                }
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder modelFolder;
                    IProject p = iProjectArray[n2];
                    if (p.isAccessible() && p.hasNature(SIRIUS_MODELINGPROJECT_NATURE) && (modelFolder = p.getFolder("model")).exists()) {
                        IResource[] iResourceArray = modelFolder.members();
                        int n3 = iResourceArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            block20: {
                                IFile modelFile;
                                IResource member = iResourceArray[n4];
                                if (member instanceof IFile && (modelFile = (IFile)member).getFileExtension().equals("sptgen")) {
                                    Throwable throwable = null;
                                    Object var15_17 = null;
                                    try {
                                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(modelFile.getLocation().toOSString()));
                                        try {
                                            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                                            parser.setErrorHandler(new DefaultHandler());
                                            Element root = parser.parse(bis).getDocumentElement();
                                            String projectDirectory = root.getAttribute("projectDirectory");
                                            if (!projectDirectory.equals(selectedProjectName)) break block20;
                                            version = this.getVersion(selectedProjectName, modelFolder);
                                            break;
                                        }
                                        catch (Throwable throwable2) {
                                            throw throwable2;
                                        }
                                        finally {
                                            if (bis == null) break;
                                            bis.close();
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        throw throwable;
                                    }
                                }
                            }
                            ++n4;
                        }
                        if (version != null && !version.isEmpty()) break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Activator.log((IStatus)new Status(4, "com.nxp.s32ds.cross.spt.explorer", "Unable to determine SPT version: skip", (Throwable)e));
            }
        }
        root.setSptVersion(version);
        return root;
    }

    private IProject getValidProjectFromSelection(ISelection selection) {
        IAdaptable adaptable;
        Object resource;
        Object element;
        IProject selectedProject = null;
        if (selection instanceof ITextSelection) {
            IResource resource2 = this.getEditorInputResource(this.getEditorInput());
            selectedProject = resource2 != null ? resource2.getProject() : this.project;
        } else if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (resource = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) instanceof IResource) {
            selectedProject = ((IResource)resource).getProject();
        }
        try {
            boolean isValid;
            boolean bl = isValid = selectedProject != null && selectedProject.isAccessible() && !"RemoteSystemsTempFiles".equals(selectedProject.getName()) && (selectedProject.hasNature("org.eclipse.cdt.core.cnature") || selectedProject.hasNature("org.eclipse.cdt.core.ccnature") || selectedProject.hasNature(SIRIUS_MODELINGPROJECT_NATURE));
            if (!isValid) {
                selectedProject = null;
            }
        }
        catch (CoreException ce) {
            Activator.log((IStatus)new Status(4, "com.nxp.s32ds.cross.spt.explorer", "Unable to determine SPT version: skip", (Throwable)ce));
        }
        return selectedProject;
    }

    private String getVersion(String projectName, IFolder modelFolder) {
        String version = null;
        if (modelFolder.getFile(String.valueOf(projectName) + ".spt1").exists()) {
            version = SPTSettings.SptKeys.SPT_1_0.getValue();
        } else if (modelFolder.getFile(String.valueOf(projectName) + ".spt2").exists()) {
            version = SPTSettings.SptKeys.SPT_2_0.getValue();
        } else if (modelFolder.getFile(String.valueOf(projectName) + ".spt25").exists()) {
            version = SPTSettings.SptKeys.SPT_2_5.getValue();
        }
        return version;
    }
}

