/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.sirius.internal.Messages;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Bundle;

public class SiriusCore {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.sirius";
    public static final String MODELING_NATURA = "org.eclipse.sirius.nature.modelingproject";

    public static Session extractSession(IProject project, String modelPath, String representationsName, IProgressMonitor monitor) throws CoreException {
        Session session;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        } else {
            Session attempt = null;
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(URI.createPlatformResourceURI((String)(String.valueOf(modelPath) + representationsName), (boolean)true), monitor);
            sessionCreationOperation.execute();
            attempt = sessionCreationOperation.getCreatedSession();
            session = attempt;
        }
        return session;
    }

    public static void log(String message, Throwable exception) {
        Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, message, exception);
        SiriusCore.log((IStatus)status);
    }

    public static void log(IStatus status) {
        if (status == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)BUNDLE_SYMBOLIC_NAME);
        if (bundle != null) {
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(status);
        }
    }

    public static Set<DRepresentation> extractRepresentations(IProject project, IProgressMonitor monitor) {
        Session session;
        ModelingProject modelingProject;
        Option mainSessionFileURI;
        Option opionalModelingProject = ModelingProject.asModelingProject((IProject)project);
        if (opionalModelingProject.some() && (mainSessionFileURI = (modelingProject = (ModelingProject)opionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), false, false)).some() && (session = SessionManager.INSTANCE.getSession((URI)mainSessionFileURI.get(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10))) != null && !session.getSelectedViews().isEmpty()) {
            LinkedHashSet<DRepresentation> representationsToOpen = new LinkedHashSet<DRepresentation>();
            for (DView view : session.getSelectedViews()) {
                for (DRepresentationDescriptor dRepresentation : view.getOwnedRepresentationDescriptors()) {
                    representationsToOpen.add(dRepresentation.getRepresentation());
                }
            }
            return representationsToOpen;
        }
        return Collections.emptySet();
    }

    public static IStatus findAndOpenDiagram(EObject model, IProgressMonitor monitor) {
        try {
            IFile file = WorkspaceResources.getFile((IPath)EmfResources.getPath((Resource)model.eResource()));
            IProject project = file.getProject();
            Set<DRepresentation> setRepr = SiriusCore.extractRepresentations(project, monitor);
            for (DRepresentation iterator : setRepr) {
                Resource eResource;
                DSemanticDecorator dSemDecorator;
                EObject target;
                if (!(iterator instanceof DSemanticDecorator) || (target = (dSemDecorator = (DSemanticDecorator)iterator).getTarget()) == null || (eResource = iterator.eResource()) == null) continue;
                URI uri = eResource.getURI();
                Session session = SessionManager.INSTANCE.getSession(uri, monitor);
                if (!session.isOpen()) {
                    session.open(monitor);
                }
                DialectUIManager.INSTANCE.openEditor(session, iterator, monitor);
                return Status.OK_STATUS;
            }
        }
        catch (Exception ex) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, Messages.SiriusCore_diagram_not_found, (Throwable)ex);
        }
        return new Status(4, BUNDLE_SYMBOLIC_NAME, Messages.SiriusCore_diagram_not_found);
    }
}

