/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.acceleo;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class TemplateURIConverter
extends ExtensibleURIConverterImpl {
    private static final String LIB_PATH = "lib";
    private static final String EMF_ACCELEO_ENTRY = "com.nxp.s32ds.ext.emf.acceleo";
    private static final String JAR_URI_SCHEME = TemplateURIConverter.isWindowsPlatform() ? "jar:file:/" : "jar:file:";
    private Map<String, String> templates = null;

    public TemplateURIConverter(Map<String, String> templates) {
        this.templates = templates;
    }

    private static boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name", "undefined").toLowerCase();
        return osName.indexOf("win") >= 0;
    }

    public URI normalize(URI uri) {
        String src = uri.toString();
        if (this.templates == null) {
            return super.normalize(uri);
        }
        for (Map.Entry<String, String> entry : this.templates.entrySet()) {
            Map map;
            URI normalized;
            if (!src.contains(entry.getKey()) || (normalized = (URI)(map = this.getURIMap()).get(uri)) != null) continue;
            Path startPath = Paths.get(LIB_PATH, new String[0]);
            Path curPath = Paths.get("", new String[0]);
            String out = "";
            try {
                Throwable throwable = null;
                Object var11_12 = null;
                try (Stream<Path> stream = Files.find(startPath, 1, (path, attr) -> String.valueOf(path).endsWith(".jar"), new FileVisitOption[0]);){
                    Optional<String> p = stream.map(String::valueOf).filter(e -> e.contains(EMF_ACCELEO_ENTRY)).findFirst();
                    out = curPath.toAbsolutePath() + File.separator + p.get();
                    out = out.replaceAll(Pattern.quote("\\"), "/");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return uri;
            }
            String dst = String.valueOf(JAR_URI_SCHEME) + out + entry.getValue();
            URI dstUri = URI.createURI((String)dst);
            map.put(uri, dstUri);
            return dstUri;
        }
        return super.normalize(uri);
    }
}

