/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.api;

import com.pemicro.debug.gdbjtag.pne.api.IPemicroUtil;
import com.pemicro.debug.gdbjtag.ppc.ui.TabDebugger;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class PemicroUtil
implements IPemicroUtil {
    @Override
    public void setInterfaceType(IPemicroUtil.PemicroInterface iface, ILaunchConfigurationWorkingCopy config) {
        String postfix = "";
        switch (iface.interfaceEnum) {
            case MULTILINK: {
                postfix = ".ml.";
                break;
            }
            case CYCLONE_SERIAL: {
                postfix = ".cyc_ser.";
                break;
            }
            case CYCLONE_USB: {
                postfix = ".cyc_usb.";
                break;
            }
            case CYCLONE_ETHERNET: {
                postfix = ".cyc_eth.";
                break;
            }
            case TRACELINK_USB: {
                postfix = ".trc_usb.";
                break;
            }
            case TRACELINK_ETHERNET: {
                postfix = ".trc_eth.";
                break;
            }
            case OPENSDA: {
                postfix = ".sda.";
            }
        }
        String attributeHeader = "com.pemicro.debug.gdbjtag.ppc" + postfix;
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", iface.port);
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", iface.portString);
        config.setAttribute("com.pemicro.debug.gdbjtag.ppc.PE.HARDWARE_INTERFACE", iface.interfaceEnum.ordinal());
    }

    @Override
    public ArrayList<IPemicroUtil.PemicroInterface> getPemicroInterfaces() {
        ArrayList<TabDebugger.HardwarePorts> detectedHardware = TabDebugger.getHardwarePorts();
        ArrayList<IPemicroUtil.PemicroInterface> result = new ArrayList<IPemicroUtil.PemicroInterface>();
        int i = 0;
        while (i < detectedHardware.size()) {
            TabDebugger.HardwarePorts currentIface = detectedHardware.get(i);
            int j = 0;
            while (j < currentIface.ports.size()) {
                IPemicroUtil.PemicroInterface temp = new IPemicroUtil.PemicroInterface();
                temp.interfaceEnum = IPemicroUtil.interfaceType.values()[i];
                temp.port = j;
                temp.humanString = currentIface.comboStrings.get(j);
                temp.portString = currentIface.ports.get(j);
                result.add(temp);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void setPemicroDevice(String freescaleDevice, ILaunchConfigurationWorkingCopy config) {
        Pattern p = Pattern.compile("M([A-Z]+\\d+[A-Z]+\\d+(?:M\\d+)?)[A-Z]+(\\d+)");
        Matcher m = p.matcher(freescaleDevice);
        String result = "";
        if (m.find()) {
            result = String.valueOf(m.group(1)) + 'M' + m.group(2);
        }
        String family = PemicroUtil.getPemicroFamily(result);
        result = "Freescale_" + family + "_" + result;
        config.setAttribute("com.pemicro.debug.gdbjtag.ppc.PE.DEVICE_NAME", result);
    }

    public static String getPemicroFamily(String deviceName) {
        if (deviceName.startsWith("WPR")) {
            return "Sensors";
        }
        Pattern p = Pattern.compile("K(?:L?\\d|[EMVW])");
        Matcher m = p.matcher(deviceName);
        m.find();
        String family = m.group();
        return String.valueOf(family) + "x";
    }
}

