/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.utils;

import java.math.BigInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.model.MemoryByte;

public class Utils {
    private Utils() {
    }

    public static <T, U extends Comparable<U>> int compare(T a, T b, Function<T, U> f) {
        return ((Comparable)f.apply(a)).compareTo((Comparable)f.apply(b));
    }

    public static long convertbig2little(long value) {
        long a = value >> 24;
        long b = (value & 0xFFFFFFFF00FF0000L) >> 8;
        long c = (value & 0xFFFFFFFF0000FF00L) << 8;
        long d = (value & 0xFFFFFFFF000000FFL) << 24;
        return a | b | c | d;
    }

    private static Matcher getLineMatcher(String fulltext) {
        return Pattern.compile("^(.*)$", 8).matcher(fulltext);
    }

    public static String getTextLine(int number, String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        int i = 1;
        while (i <= number) {
            if (matcher.find() && i == number) {
                return matcher.group(1);
            }
            ++i;
        }
        return "";
    }

    public static String getFirstNotEmptyTextLine(String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            if (matcher.group(1).equals("")) continue;
            return matcher.group(1);
        }
        return "";
    }

    public static int countTextLines(String fulltext) {
        int i = 0;
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            ++i;
        }
        return i;
    }

    public static int getBitFromValue(int bitnr, long value) {
        return (int)(value >> bitnr & 1L);
    }

    public static String longtobinarystring(long wert, int bits) {
        StringBuilder text = new StringBuilder();
        String x = Long.toBinaryString(wert);
        int missingLen = bits - x.length();
        if (missingLen < 0) {
            String value = x.substring(-missingLen);
            text.append(value.toUpperCase());
        } else {
            int i = 0;
            while (i < missingLen) {
                text.append('0');
                ++i;
            }
            text.append(x.toUpperCase());
        }
        return text.toString();
    }

    public static String longtoHexString(long wert, int bits) {
        int hexdigits = bits / 4;
        if (bits % 4 != 0) {
            ++hexdigits;
        }
        StringBuilder hex = new StringBuilder();
        hex.append("0x");
        String x = Long.toHexString(wert);
        int missingLen = hexdigits - x.length();
        if (missingLen < 0) {
            String value = x.substring(-missingLen);
            hex.append(value.toUpperCase());
        } else {
            int i = 0;
            while (i < missingLen) {
                hex.append('0');
                ++i;
            }
            hex.append(x.toUpperCase());
        }
        return hex.toString();
    }

    public static boolean convertToUnsigned(MemoryByte[] bytes, int regOffset, int regByteSize, long[] ret) {
        if (bytes[regOffset].isEndianessKnown() && bytes[regOffset].isReadable()) {
            int k;
            byte[] arraybytes = new byte[regByteSize + 1];
            if (!bytes[regOffset].isBigEndian()) {
                k = 0;
                while (k < regByteSize) {
                    arraybytes[k + 1] = bytes[regOffset + regByteSize - 1 - k].getValue();
                    ++k;
                }
            } else {
                k = 0;
                while (k < regByteSize) {
                    arraybytes[k + 1] = bytes[regOffset + k].getValue();
                    ++k;
                }
            }
            arraybytes[0] = 0;
            BigInteger big = new BigInteger(arraybytes);
            ret[0] = Long.parseLong(big.toString());
            return true;
        }
        return false;
    }

    public static IProject getProjectByName(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }
}

