/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.internal.RegisterXMLParser;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRange;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;

public class EmbSysRegModel {
    public static final int SIZE_ONEBYTE = 1;
    public static final int SIZE_TWOBYTES = 2;
    public static final int SIZE_FOURBYTES = 4;
    private TreeParent invisibleRoot;
    private IProject project;
    private Queue<TreeRegister> pendingToWrite;
    private Queue<TreeRegister> pendingToRead;
    private Map<Long, TreeRegister> cherryPicked = new HashMap<Long, TreeRegister>();
    private final EmbSysRegView.RegSet regSet;

    public EmbSysRegModel(EmbSysRegView.RegSet regSet) {
        this.pendingToWrite = new LinkedList<TreeRegister>();
        this.pendingToRead = new LinkedList<TreeRegister>();
        this.regSet = regSet;
    }

    public void setRegisterLive(TreeRegister treeRegister) {
        treeRegister.setRetrievalActive(true);
        for (TreeRegister altReg : treeRegister.getAlterName()) {
            altReg.setRetrievalActive(true);
        }
        this.cherryPicked.put(treeRegister.getRegisterAddress(), treeRegister);
        this.pendingToRead.offer(treeRegister);
    }

    public void pushRegister(TreeRegister register) {
        TreeRegister old = this.cherryPicked.get(register.getRegisterAddress());
        long lvalue = register.getValue();
        if (old != null) {
            old.setValue(lvalue);
            for (TreeRegister altReg : old.getAlterName()) {
                if (old.getByteSize() != altReg.getByteSize()) continue;
                altReg.setValue(lvalue);
            }
        }
    }

    public Set<TreeRange> createRangeList() {
        this.pendingToRead.clear();
        return this.cherryPicked.values().stream().map(TreeRegister::getRange).distinct().collect(Collectors.toSet());
    }

    public final TreeParent getRoot() {
        return this.invisibleRoot;
    }

    public boolean isEmpty() {
        return this.invisibleRoot == null || !this.invisibleRoot.hasChildren();
    }

    public IStatus initialize() {
        this.cherryPicked.clear();
        this.pendingToRead.clear();
        this.project = null;
        this.invisibleRoot = new TreeParent("", "");
        return Status.OK_STATUS;
    }

    public IStatus initialize(IProject proj) {
        this.initialize();
        this.project = proj;
        try {
            this.invisibleRoot = new RegisterXMLParser(this.project).loadXML(this.regSet);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public void setRegisterOffLine(TreeRegister treeRegister) {
        treeRegister.setRetrievalActive(false);
        for (TreeRegister altReg : treeRegister.getAlterName()) {
            altReg.setRetrievalActive(false);
        }
        this.cherryPicked.remove(treeRegister.getRegisterAddress());
    }

    public final IProject getProject() {
        return this.project;
    }

    public void setRegisterToWrite(TreeRegister treeRegister) {
        this.pendingToWrite.offer(treeRegister);
    }

    public TreeRegister getPendingReg() {
        return this.pendingToWrite.poll();
    }

    public TreeRegister getPendingRead() {
        return this.pendingToRead.poll();
    }

    public void applyRangeData(TreeRange range, MemoryByte[] bytes) {
        List<TreeElement> objsModel = range.getModelChildren();
        for (TreeElement obj : objsModel) {
            if (!(obj instanceof TreeRegister)) continue;
            TreeRegister regModel = (TreeRegister)obj;
            int regByteSize = regModel.getByteSize();
            int regOffset = (int)regModel.getRegisterAddress() - (int)range.getStartAddress();
            long[] ret = new long[]{-1L};
            if (Utils.convertToUnsigned(bytes, regOffset, regByteSize, ret)) {
                long val = ret[0];
                regModel.setValue(val);
                for (TreeRegister altReg : regModel.getAlterName()) {
                    altReg.setValue(val);
                }
                continue;
            }
            regModel.clearValue();
            for (TreeRegister altReg : regModel.getAlterName()) {
                altReg.clearValue();
            }
        }
    }

    public void setRootReadOnly(boolean flag) {
        TreeElement.setAccessGranted(!flag);
    }

    public void cleanList(boolean sessionFlag) {
        if (sessionFlag) {
            this.cherryPicked.forEach((key, value) -> value.clearValue());
        }
    }

    public Map<Long, TreeRegister> getCherryPicked() {
        return this.cherryPicked;
    }

    public EmbSysRegView.RegSet getRegSet() {
        return this.regSet;
    }
}

