/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.sdk.radar_1_0_0;

import com.nxp.s32ds.cross.sdk.radar_1_0_0.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

class RSDKConfigAdjuster {
    private static final Map<String, String> corePostfix = new HashMap<String, String>();
    private static final String ASM_TOOL = "com.freescale.s32ds.cross.gnu.e200.tool.assembler";
    private static final String OPTION_ASM_DEF = "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs";
    private static final String C_LINKER_TOOL = "com.freescale.s32ds.cross.gnu.e200.tool.c.linker";
    private static final String OPTION_C_LINKER_FLASGS = "gnu.c.link.option.ldflags";
    private static final String OPTION_C_LINKER_PATHS = "gnu.c.link.option.paths";
    private static final String CPP_LINKER_TOOL = "com.freescale.s32ds.cross.gnu.e200.tool.cpp.linker";
    private static final String OPTION_CPP_LINKER_FLAGS = "gnu.cpp.link.option.ldflags";
    private static final String OPTION_CPP_LINKER_PATHS = "gnu.cpp.link.option.paths";
    private static final String LINKER_FLAG = "-Wl,--start-group";
    private static final String LINKER_PATH = "\"${ProjDirPath}/Project_Settings/Linker_Files\"";
    private static final String CORE_DEF = "CORE";
    private final IProject project;

    static {
        corePostfix.put("_Z4", "0");
        corePostfix.put("_Z7_0", "1");
        corePostfix.put("_Z7_1", "2");
    }

    RSDKConfigAdjuster(IProject project) {
        this.project = project;
    }

    void adjustConfiguration() {
        try {
            this.createSourceEntries();
            this.adjustOptions();
            this.excludeResources();
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private String getCoreIdx() {
        for (String key : corePostfix.keySet()) {
            if (this.project.getName().indexOf(key) == -1) continue;
            return corePostfix.get(key);
        }
        return "";
    }

    private void adjustOptions() throws BuildException {
        IConfiguration[] configs;
        if (!this.project.isAccessible()) {
            Activator.error(NLS.bind((String)"Project {0} is not accessible", (Object)this.project));
            return;
        }
        String core = this.getCoreIdx();
        IConfiguration[] iConfigurationArray = configs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration config = iConfigurationArray[n2];
            ITool[] iToolArray = tools = config.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                String toolBaseId = tool.getBaseId();
                IOption option = null;
                if (toolBaseId.equals(ASM_TOOL)) {
                    option = tool.getOptionBySuperClassId(OPTION_ASM_DEF);
                    this.addOptionValue(0, option, CORE_DEF + core);
                }
                IOption linker_option1 = null;
                IOption linker_option2 = null;
                if (toolBaseId.equals(C_LINKER_TOOL)) {
                    linker_option1 = tool.getOptionBySuperClassId(OPTION_C_LINKER_FLASGS);
                    linker_option2 = tool.getOptionBySuperClassId(OPTION_C_LINKER_PATHS);
                } else if (toolBaseId.equals(CPP_LINKER_TOOL)) {
                    linker_option1 = tool.getOptionBySuperClassId(OPTION_CPP_LINKER_FLAGS);
                    linker_option2 = tool.getOptionBySuperClassId(OPTION_CPP_LINKER_PATHS);
                }
                if (linker_option1 != null) {
                    linker_option1.setValue(LINKER_FLAG);
                }
                if (linker_option2 != null) {
                    this.addOptionValue(0, linker_option2, LINKER_PATH);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createSourceEntries() throws CoreException {
        HashSet additionalSourceEntrires = new HashSet();
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(this.project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
            HashSet<ICSourceEntry> sourceEntries = new HashSet<ICSourceEntry>(Arrays.asList(config.getSourceEntries()));
            sourceEntries.addAll(additionalSourceEntrires);
            config.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            ++n2;
        }
        CCorePlugin.getDefault().setProjectDescription(this.project, description, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addOptionValue(int pos, IOption opt, String value) throws BuildException {
        if (opt == null || pos < 0) {
            return;
        }
        if (opt.getBasicValueType() == 3) {
            ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
            if (!curValueList.contains(value)) {
                curValueList.add(pos, value);
            }
            opt.setValue(curValueList);
        }
    }

    private void excludeResources() throws CoreException {
        IConfiguration[] configs;
        IFolder linkedFilesFolder = this.project.getFolder("Project_Settings/Linker_Files");
        IConfiguration[] iConfigurationArray = configs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IResourceConfiguration resourceConfig = config.getResourceConfiguration(linkedFilesFolder.getFullPath().toString());
            if (resourceConfig == null) {
                resourceConfig = config.createFileInfo(linkedFilesFolder.getFullPath().removeFirstSegments(1));
            }
            if (resourceConfig != null) {
                resourceConfig.setExclude(true);
            }
            ++n2;
        }
    }
}

