/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.ui.usages.handlers;

import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.ui.MdtIdeUiActivator;
import com.nxp.s32ds.mdt.ide.ui.internal.Messages;
import com.nxp.s32ds.mdt.ide.ui.usages.FindUsagesDialog;
import com.nxp.s32ds.mdt.ide.ui.usages.SemanticElementOpener;
import com.nxp.s32ds.mdt.ide.ui.usages.internal.SemanticElementOpenersRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindUsagesHandler
extends AbstractHandler {
    private List<EObject> usages;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Shell shell = null;
        if (activeWindow != null) {
            shell = activeWindow.getShell();
        }
        IStructuredSelection selectedElements = selection;
        for (final Object element : selectedElements) {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                pmd.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        EObject eObject = MdtIdeCore.extractSemanticElement((Object)element);
                        FindUsagesHandler.this.usages = MdtIdeCore.findUsages((EObject)eObject, (IProgressMonitor)monitor);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)shell, (String)Messages.FindUsagesDialog_default_open_error_message, (String)e.getTargetException().getMessage());
                return null;
            }
            if (this.usages == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.FindUsagesDialog_dafault_title, (String)Messages.FindUsagesDialog_message_not_found);
                return null;
            }
            int size = this.usages.size();
            if (size == 0) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.FindUsagesDialog_dafault_title, (String)Messages.FindUsagesDialog_message_not_found);
                return null;
            }
            if (size == 1) {
                IStatus status = this.openUsage(shell, this.usages.get(0));
                if (!status.isOK()) {
                    MessageDialog.openError((Shell)shell, (String)Messages.FindUsagesHandler_error, (String)status.getMessage());
                }
                return null;
            }
            if (size <= 1) continue;
            EObject obj = new FindUsagesDialog().open(shell, this.usages.toArray());
            if (obj == null) {
                return null;
            }
            IStatus status = this.openUsage(shell, obj);
            if (!status.isOK()) {
                MessageDialog.openError((Shell)shell, (String)Messages.FindUsagesHandler_error, (String)status.getMessage());
            }
            return null;
        }
        return null;
    }

    private SemanticElementOpener findOpener(EObject object) {
        SemanticElementOpenersRegistry registry = MdtIdeUiActivator.getDefault().getSemanticElementOpenersRegistry();
        List<SemanticElementOpener> openers = registry.getAll();
        if (openers.size() > 0) {
            for (SemanticElementOpener opener : openers) {
                if (!opener.isApplicable(object)) continue;
                return opener;
            }
        }
        return null;
    }

    private IStatus openUsage(Shell shell, EObject object) {
        SemanticElementOpener opener = this.findOpener(object);
        if (opener == null) {
            return new Status(4, "com.nxp.s32ds.mdt.ide.ui", Messages.FindUsagesHandler_could_not_open_usage);
        }
        return opener.openElement(object, shell);
    }
}

