/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameRefactoring;
import com.nxp.s32ds.ext.ide.ui.refactoring.IChangeValidator;
import com.nxp.s32ds.ext.ide.validation.utils.TextChangeFinder;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class VgtResourcesRefactoring
implements IRenameRefactoring,
IChangeValidator {
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.ui.refactoring";
    private static final String AFFECTED_KEY_PATTERN = "headers path";
    private static final String AFFECTED_VALUE_PATTERN = "fileName";
    private static final String[] VGT_FILES = new String[]{"*.aird", "*.apugen", "*.apuprogram", "*.apugraph", "*.apukernel", "*.isp", "*.ispgen", "*.sptgen", "*.spt1", "*.spt2", "*.spt25", "*.spt"};
    private static final String S32DS_VARIABLE_PREFIX = "${S32DS";

    public IStatus renameRefactorResources(IResource resources, String search, String replace, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.applyOperation(resources, VGT_FILES, search, replace, monitor);
    }

    private IStatus applyOperation(IResource projects, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        try {
            Map mapEdit = TextChangeFinder.findInResource((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            List fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            if (!mapEdit.isEmpty()) {
                for (Map.Entry iter : mapEdit.entrySet()) {
                    this.applyChanges((IFile)iter.getKey(), (List)iter.getValue(), monitor);
                    mtStatus.add(this.renameFile((IFile)iter.getKey(), search, replace, monitor));
                }
            }
            if (!fileForRenameNotMatcher.isEmpty()) {
                for (IFile file : fileForRenameNotMatcher) {
                    mtStatus.add(this.renameFile(file, search, replace, monitor));
                }
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }

    private void applyChanges(IFile fCurrentFile, List<ReplaceEdit> lstChanges, IProgressMonitor monitor) throws CoreException {
        IDocument result = null;
        monitor.beginTask("", 2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                IPath path = fCurrentFile.getFullPath();
                manager.connect(path, LocationKind.NORMALIZE, monitor);
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                result = buffer.getDocument();
                MultiTextEdit mte = new MultiTextEdit();
                for (ReplaceEdit it : lstChanges) {
                    if (this.skipChange(null, AFFECTED_KEY_PATTERN, AFFECTED_VALUE_PATTERN, result, it)) continue;
                    mte.addChild((TextEdit)it);
                }
                mte.apply(result);
                buffer.commit(monitor, true);
            }
            catch (Exception e) {
                Status status = new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (result != null) {
                manager.disconnect(fCurrentFile.getFullPath(), LocationKind.NORMALIZE, monitor);
            }
        }
        monitor.done();
    }

    @Override
    public boolean skipChange(List<String> affectedList, String key, String value, IDocument doc, ReplaceEdit re) {
        int fileName;
        int headersPath;
        String line;
        block3: {
            try {
                int pos = re.getOffset();
                int lin = doc.getLineOfOffset(pos);
                int off = doc.getLineOffset(lin);
                int len = doc.getLineLength(lin);
                line = doc.get(off, len);
                headersPath = line.indexOf(AFFECTED_KEY_PATTERN);
                fileName = line.indexOf(AFFECTED_VALUE_PATTERN);
                if (headersPath >= 0 && fileName >= 0 && pos >= off + headersPath + AFFECTED_VALUE_PATTERN.length()) break block3;
                return false;
            }
            catch (BadLocationException e) {
                Status status = new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                return true;
            }
        }
        return line.substring(headersPath, fileName).contains(S32DS_VARIABLE_PREFIX);
    }
}

