/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.mwe2.core;

import com.nxp.s32ds.mdt.ide.mwe2.core.Messages;
import com.nxp.s32ds.mdt.ide.mwe2.core.Mwe2Initializer;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class BaseMwe2Initializer
implements Mwe2Initializer {
    private static final String DEFAULT_STR = "";
    protected String mwe2File = "";
    protected String bundleId = "";
    protected String nsUriToCheck = "";

    @Override
    public void saveConfiguration(String nsUri, String dstDirPath) throws CoreException {
        Path path = Paths.get(dstDirPath, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new CoreException((IStatus)new Status(4, this.bundleId, Messages.BaseMwe2Intializer_destination_path_should_be_directory));
        }
        if (!Files.isWritable(path)) {
            throw new CoreException((IStatus)new Status(4, this.bundleId, Messages.BaseMwe2Intializer_destination_path_should_be_writable));
        }
        if (nsUri == null || nsUri.isEmpty() || !nsUri.equals(this.nsUriToCheck)) {
            throw new CoreException((IStatus)new Status(4, this.bundleId, Messages.BaseMwe2Intializer_unsupported_ns_uri));
        }
        this.extractTemplate(dstDirPath);
    }

    private void extractTemplate(String dstDirPath) throws CoreException {
        String path = String.valueOf(File.separator) + this.mwe2File;
        Bundle bundle = Platform.getBundle((String)this.bundleId);
        URL fileUrl = bundle.getEntry("resources" + path);
        File file = null;
        try {
            file = new File(FileLocator.resolve((URL)fileUrl).toURI());
            this.putConfig(file.getAbsolutePath(), String.valueOf(dstDirPath) + path);
        }
        catch (IOException | URISyntaxException ex) {
            throw new CoreException((IStatus)new Status(4, this.bundleId, Messages.BaseMwe2Intializer_error_while_saving_configuration, (Throwable)ex));
        }
    }

    private void putConfig(String srcPath, String dstDirPath) throws IOException {
        Files.copy(Paths.get(srcPath, new String[0]), Paths.get(dstDirPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }
}

