/*
 * Copyright: Freescale Semiconductor, Inc. All Rights Reserved.
 * @author John Cortel
 **/
package com.processorexpert.derivative;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator extends AbstractUIPlugin {

	/** The plug-in's ID */
	public static final String PLUGIN_ID = "com.freescale.processorexpert.derivative"; //$NON-NLS-1$
	
	/** Singleton instance */
	private static Activator plugin;

	/** Return the singleton instance */
	public static Activator getDefault() {
		return plugin;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext bundleContext) throws Exception {
		super.start(bundleContext);
		plugin = this;
		assert bundleContext.getBundle().getSymbolicName().equals(PLUGIN_ID);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext bundleContext) throws Exception {
		plugin = null;
		super.stop(bundleContext);
	}
	
	/** Logs an exception to the eclipse error log */
	public static void log(Throwable t) {
		log(IStatus.ERROR, "Internal Error", t); //$NON-NLS-1$
	}

	/** Logs a message and exception to the eclipse error log */
	public static void log(int severity, String message, Throwable t) {
		log(new Status(severity, PLUGIN_ID, message != null ? message : "", t)); //$NON-NLS-1$
	}

	/** Logs a message to the eclipse error log */
	public static void log(int severity, String message) {
		log(new Status(severity, PLUGIN_ID, message != null ? message : "", null)); //$NON-NLS-1$
	}
	
	/** Logs a status object to the eclipse error log */
	public static void log(IStatus status) {
		Activator _plugin = plugin; // for thread safety
		if (_plugin != null) {
			_plugin.getLog().log(status);
		}
		else {
			Throwable exc = status.getException();
			if (exc != null) {
				exc.printStackTrace();
			}
			else {
				System.out.println(status.toString());
			}
		}
	}
}
