/**************************************************************************
 * FILE NAME: MPC5746C.h                     COPYRIGHT (c) Freescale 2016 *
 * REVISION:  4.0.0                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5746C.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 1.0      M.D.      28-FEB-14     -First release.                       *
 *                                                                        *
 * 1.0.1    M.D.      06-JUN-14     -Generated from updated RDP           *
 *                                                                        *
 * 2.0.0    M.D.      28-AUG-14     -Generated from updated RDP Rev2      *
 *                                                                        *
 * 4.0.0    M.D.      06-MAY-16     -Generated from updated RDP Rev4      *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5746C_H_
#define _MPC5746C_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;                 /* Overwrite enable. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t NSTART:1;
    vuint32_t _unused_23:1;
    vuint32_t JTRGEN:1;                /* Injection external trigger enable. */
    vuint32_t JEDGE:1;                 /* Injection trigger edge selection. */
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t _unused_18:2;
    vuint32_t CTUEN:1;                 /* Crosstrigger Unit Enable. */
    vuint32_t CTU_MODE:1;              /* Crosstrigger Unit MODE bit */
    vuint32_t _unused_15:1;
    vuint32_t _unused_9:6;
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t PWDN:1;                  /* Power-down enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
    vuint32_t _unused_25:6;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t JABORT:1;
    vuint32_t _unused_21:2;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t CTUSTART:1;              /* This status bit is used to signal that a BCTU conversion is ongoing. */
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t _unused_6:3;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EOCTU:1;
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t ECH:1;                   /* End of chain conversion. */
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH31:1;               /* EOC Channel 31. */
    vuint32_t EOCCH30:1;               /* EOC Channel 30. */
    vuint32_t EOCCH29:1;               /* EOC Channel 29. */
    vuint32_t EOCCH28:1;               /* EOC Channel 28. */
    vuint32_t EOCCH27:1;               /* EOC Channel 27. */
    vuint32_t EOCCH26:1;               /* EOC Channel 26. */
    vuint32_t EOCCH25:1;               /* EOC Channel 25. */
    vuint32_t EOCCH24:1;               /* EOC Channel 24. */
    vuint32_t EOCCH23:1;               /* EOC Channel 23. */
    vuint32_t EOCCH22:1;               /* EOC Channel 22. */
    vuint32_t EOCCH21:1;               /* EOC Channel 21. */
    vuint32_t EOCCH20:1;               /* EOC Channel 20. */
    vuint32_t EOCCH19:1;               /* EOC Channel 19. */
    vuint32_t EOCCH18:1;               /* EOC Channel 18. */
    vuint32_t EOCCH17:1;               /* EOC Channel 17. */
    vuint32_t EOCCH16:1;               /* EOC Channel 16. */
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_CEOCFR1_union_tag {  /* Channel Pending register 1 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH63:1;               /* EOC Channel 63. */
    vuint32_t EOCCH62:1;               /* EOC Channel 62. */
    vuint32_t EOCCH61:1;               /* EOC Channel 61. */
    vuint32_t EOCCH60:1;               /* EOC Channel 60. */
    vuint32_t EOCCH59:1;               /* EOC Channel 59. */
    vuint32_t EOCCH58:1;               /* EOC Channel 58. */
    vuint32_t EOCCH57:1;               /* EOC Channel 57. */
    vuint32_t EOCCH56:1;               /* EOC Channel 56. */
    vuint32_t EOCCH55:1;               /* EOC Channel 55. */
    vuint32_t EOCCH54:1;               /* EOC Channel 54. */
    vuint32_t EOCCH53:1;               /* EOC Channel 53. */
    vuint32_t EOCCH52:1;               /* EOC Channel 52. */
    vuint32_t EOCCH51:1;               /* EOC Channel 51. */
    vuint32_t EOCCH50:1;               /* EOC Channel 50. */
    vuint32_t EOCCH49:1;               /* EOC Channel 49. */
    vuint32_t EOCCH48:1;               /* EOC Channel 48 */
    vuint32_t EOCCH47:1;               /* EOC Channel 47. */
    vuint32_t EOCCH46:1;               /* EOC Channel 46. */
    vuint32_t EOCCH45:1;               /* EOC Channel 45. */
    vuint32_t EOCCH44:1;               /* EOC Channel 44. */
    vuint32_t EOCCH43:1;               /* EOC Channel 43. */
    vuint32_t EOCCH42:1;               /* EOC Channel 42. */
    vuint32_t EOCCH41:1;               /* EOC Channel 41. */
    vuint32_t EOCCH40:1;               /* EOC Channel 40. */
    vuint32_t EOCCH39:1;               /* EOC Channel 39. */
    vuint32_t EOCCH38:1;               /* EOC Channel 38. */
    vuint32_t EOCCH37:1;               /* EOC Channel 37. */
    vuint32_t EOCCH36:1;               /* EOC Channel 36. */
    vuint32_t EOCCH35:1;               /* EOC Channel 35. */
    vuint32_t EOCCH34:1;               /* EOC Channel 34. */
    vuint32_t EOCCH33:1;               /* EOC Channel 33. */
    vuint32_t EOCCH32:1;               /* EOC Channel 32. */
  } B;
} ADC_CEOCFR1_tag;

typedef union ADC_CEOCFR2_union_tag {  /* Channel Pending register 2 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH95:1;               /* EOC Channel 95. */
    vuint32_t EOCCH94:1;               /* EOC Channel 94. */
    vuint32_t EOCCH93:1;               /* EOC Channel 93. */
    vuint32_t EOCCH92:1;               /* EOC Channel 92. */
    vuint32_t EOCCH91:1;               /* EOC Channel 91. */
    vuint32_t EOCCH90:1;               /* EOC Channel 90. */
    vuint32_t EOCCH89:1;               /* EOC Channel 89. */
    vuint32_t EOCCH88:1;               /* EOC Channel 88. */
    vuint32_t EOCCH87:1;               /* EOC Channel 87. */
    vuint32_t EOCCH86:1;               /* EOC Channel 86. */
    vuint32_t EOCCH85:1;               /* EOC Channel 85. */
    vuint32_t EOCCH84:1;               /* EOC Channel 84. */
    vuint32_t EOCCH83:1;               /* EOC Channel 83. */
    vuint32_t EOCCH82:1;               /* EOC Channel 82. */
    vuint32_t EOCCH81:1;               /* EOC Channel 81. */
    vuint32_t EOCCH80:1;               /* EOC Channel 80. */
    vuint32_t EOCCH79:1;               /* EOC Channel 79. */
    vuint32_t EOCCH78:1;               /* EOC Channel 78. */
    vuint32_t EOCCH77:1;               /* EOC Channel 77. */
    vuint32_t EOCCH76:1;               /* EOC Channel 76. */
    vuint32_t EOCCH75:1;               /* EOC Channel 75. */
    vuint32_t EOCCH74:1;               /* EOC Channel 74. */
    vuint32_t EOCCH73:1;               /* EOC Channel 73. */
    vuint32_t EOCCH72:1;               /* EOC Channel 72. */
    vuint32_t EOCCH71:1;               /* EOC Channel 71. */
    vuint32_t EOCCH70:1;               /* EOC Channel 70. */
    vuint32_t EOCCH69:1;               /* EOC Channel 69. */
    vuint32_t EOCCH68:1;               /* EOC Channel 68. */
    vuint32_t EOCCH67:1;               /* EOC Channel 67. */
    vuint32_t EOCCH66:1;               /* EOC Channel 66. */
    vuint32_t EOCCH65:1;               /* EOC Channel 65. */
    vuint32_t EOCCH64:1;               /* EOC Channel 64. */
  } B;
} ADC_CEOCFR2_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_5:10;
    vuint32_t MSKEOCTU:1;              /* Mask bit for EOCTU. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CIM31:1;                 /* Channel 31 interrupt enable. */
    vuint32_t CIM30:1;                 /* Channel 30 interrupt enable. */
    vuint32_t CIM29:1;                 /* Channel 29 interrupt enable. */
    vuint32_t CIM28:1;                 /* Channel 28 interrupt enable. */
    vuint32_t CIM27:1;                 /* Channel 27 interrupt enable. */
    vuint32_t CIM26:1;                 /* Channel 26 interrupt enable. */
    vuint32_t CIM25:1;                 /* Channel 25 interrupt enable. */
    vuint32_t CIM24:1;                 /* Channel 24 interrupt enable. */
    vuint32_t CIM23:1;                 /* Channel 23 interrupt enable. */
    vuint32_t CIM22:1;                 /* Channel 22 interrupt enable. */
    vuint32_t CIM21:1;                 /* Channel 21 interrupt enable. */
    vuint32_t CIM20:1;                 /* Channel 20 interrupt enable. */
    vuint32_t CIM19:1;                 /* Channel 19 interrupt enable. */
    vuint32_t CIM18:1;                 /* Channel 18 interrupt enable. */
    vuint32_t CIM17:1;                 /* Channel 17 interrupt enable. */
    vuint32_t CIM16:1;                 /* Channel 16 interrupt enable. */
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_CIMR1_union_tag {    /* Channel Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CIM63:1;                 /* Channel 63 interrupt enable. */
    vuint32_t CIM62:1;                 /* Channel 62 interrupt enable. */
    vuint32_t CIM61:1;                 /* Channel 61 interrupt enable. */
    vuint32_t CIM60:1;                 /* Channel 60 interrupt enable. */
    vuint32_t CIM59:1;                 /* Channel 59 interrupt enable. */
    vuint32_t CIM58:1;                 /* Channel 58 interrupt enable. */
    vuint32_t CIM57:1;                 /* Channel 57 interrupt enable. */
    vuint32_t CIM56:1;                 /* Channel 56 interrupt enable. */
    vuint32_t CIM55:1;                 /* Channel 55 interrupt enable. */
    vuint32_t CIM54:1;                 /* Channel 54 interrupt enable. */
    vuint32_t CIM53:1;                 /* Channel 53 interrupt enable. */
    vuint32_t CIM52:1;                 /* Channel 52 interrupt enable. */
    vuint32_t CIM51:1;                 /* Channel 51 interrupt enable. */
    vuint32_t CIM50:1;                 /* Channel 50 interrupt enable. */
    vuint32_t CIM49:1;                 /* Channel 49 interrupt enable. */
    vuint32_t CIM48:1;                 /* Channel 48 interrupt enable. */
    vuint32_t CIM47:1;                 /* Channel 47 interrupt enable. */
    vuint32_t CIM46:1;                 /* Channel 46 interrupt enable. */
    vuint32_t CIM45:1;                 /* Channel 45 interrupt enable. */
    vuint32_t CIM44:1;                 /* Channel 44 interrupt enable. */
    vuint32_t CIM43:1;                 /* Channel 43 interrupt enable. */
    vuint32_t CIM42:1;                 /* Channel 42 interrupt enable. */
    vuint32_t CIM41:1;                 /* Channel 41 interrupt enable. */
    vuint32_t CIM40:1;                 /* Channel 40 interrupt enable. */
    vuint32_t CIM39:1;                 /* Channel 39 interrupt enable. */
    vuint32_t CIM38:1;                 /* Channel 38 interrupt enable. */
    vuint32_t CIM37:1;                 /* Channel 37 interrupt enable. */
    vuint32_t CIM36:1;                 /* Channel 36 interrupt enable. */
    vuint32_t CIM35:1;                 /* Channel 35 interrupt enable. */
    vuint32_t CIM34:1;                 /* Channel 34 interrupt enable. */
    vuint32_t CIM33:1;                 /* Channel 33 interrupt enable. */
    vuint32_t CIM32:1;                 /* Channel 32 interrupt enable. */
  } B;
} ADC_CIMR1_tag;

typedef union ADC_CIMR2_union_tag {    /* Channel Interrupt Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CIM95:1;                 /* Channel 95 interrupt enable. */
    vuint32_t CIM94:1;                 /* Channel 94 interrupt enable. */
    vuint32_t CIM93:1;                 /* Channel 93 interrupt enable. */
    vuint32_t CIM92:1;                 /* Channel 92 interrupt enable. */
    vuint32_t CIM91:1;                 /* Channel 91 interrupt enable. */
    vuint32_t CIM90:1;                 /* Channel 90 interrupt enable. */
    vuint32_t CIM89:1;                 /* Channel 89 interrupt enable. */
    vuint32_t CIM88:1;                 /* Channel 88 interrupt enable. */
    vuint32_t CIM87:1;                 /* Channel 87 interrupt enable. */
    vuint32_t CIM86:1;                 /* Channel 86 interrupt enable. */
    vuint32_t CIM85:1;                 /* Channel 85 interrupt enable. */
    vuint32_t CIM84:1;                 /* Channel 84 interrupt enable. */
    vuint32_t CIM83:1;                 /* Channel 83 interrupt enable. */
    vuint32_t CIM82:1;                 /* Channel 82 interrupt enable. */
    vuint32_t CIM81:1;                 /* Channel 81 interrupt enable. */
    vuint32_t CIM80:1;                 /* Channel 80 interrupt enable. */
    vuint32_t CIM79:1;                 /* Channel 79 interrupt enable. */
    vuint32_t CIM78:1;                 /* Channel 78 interrupt enable. */
    vuint32_t CIM77:1;                 /* Channel 77 interrupt enable. */
    vuint32_t CIM76:1;                 /* Channel 76 interrupt enable. */
    vuint32_t CIM75:1;                 /* Channel 75 interrupt enable. */
    vuint32_t CIM74:1;                 /* Channel 74 interrupt enable. */
    vuint32_t CIM73:1;                 /* Channel 73 interrupt enable. */
    vuint32_t CIM72:1;                 /* Channel 72 interrupt enable. */
    vuint32_t CIM71:1;                 /* Channel 71 interrupt enable. */
    vuint32_t CIM70:1;                 /* Channel 70 interrupt enable. */
    vuint32_t CIM69:1;                 /* Channel 69 interrupt enable. */
    vuint32_t CIM68:1;                 /* Channel 68 interrupt enable. */
    vuint32_t CIM67:1;                 /* Channel 67 interrupt enable. */
    vuint32_t CIM66:1;                 /* Channel 66 interrupt enable. */
    vuint32_t CIM65:1;                 /* Channel 65 interrupt enable. */
    vuint32_t CIM64:1;                 /* Channel 64 interrupt enable. */
  } B;
} ADC_CIMR2_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t WDG5H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t DCLR:1;                  /* DMA Clear sequence enable. */
    vuint32_t DMAEN:1;                 /* DMA global enable. */
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DMA31:1;                 /* DMA enable for channel 31. */
    vuint32_t DMA30:1;                 /* DMA enable for channel 30. */
    vuint32_t DMA29:1;                 /* DMA enable for channel 29. */
    vuint32_t DMA28:1;                 /* DMA enable for channel 28. */
    vuint32_t DMA27:1;                 /* DMA enable for channel 27. */
    vuint32_t DMA26:1;                 /* DMA enable for channel 26. */
    vuint32_t DMA25:1;                 /* DMA enable for channel 25. */
    vuint32_t DMA24:1;                 /* DMA enable for channel 24. */
    vuint32_t DMA23:1;                 /* DMA enable for channel 23. */
    vuint32_t DMA22:1;                 /* DMA enable for channel 22. */
    vuint32_t DMA21:1;                 /* DMA enable for channel 21. */
    vuint32_t DMA20:1;                 /* DMA enable for channel 20. */
    vuint32_t DMA19:1;                 /* DMA enable for channel 19. */
    vuint32_t DMA18:1;                 /* DMA enable for channel 18. */
    vuint32_t DMA17:1;                 /* DMA enable for channel 17. */
    vuint32_t DMA16:1;                 /* DMA enable for channel 16. */
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_DMAR1_union_tag {    /* DMA Channel Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DMA63:1;                 /* DMA enable for channel 63. */
    vuint32_t DMA62:1;                 /* DMA enable for channel 62. */
    vuint32_t DMA61:1;                 /* DMA enable for channel 61. */
    vuint32_t DMA60:1;                 /* DMA enable for channel 60. */
    vuint32_t DMA59:1;                 /* DMA enable for channel 59. */
    vuint32_t DMA58:1;                 /* DMA enable for channel 58. */
    vuint32_t DMA57:1;                 /* DMA enable for channel 57. */
    vuint32_t DMA56:1;                 /* DMA enable for channel 56. */
    vuint32_t DMA55:1;                 /* DMA enable for channel 55. */
    vuint32_t DMA54:1;                 /* DMA enable for channel 54. */
    vuint32_t DMA53:1;                 /* DMA enable for channel 53. */
    vuint32_t DMA52:1;                 /* DMA enable for channel 52. */
    vuint32_t DMA51:1;                 /* DMA enable for channel 51. */
    vuint32_t DMA50:1;                 /* DMA enable for channel 50. */
    vuint32_t DMA49:1;                 /* DMA enable for channel 49. */
    vuint32_t DMA48:1;                 /* DMA enable for channel 48. */
    vuint32_t DMA47:1;                 /* DMA enable for channel 47. */
    vuint32_t DMA46:1;                 /* DMA enable for channel 46. */
    vuint32_t DMA45:1;                 /* DMA enable for channel 45. */
    vuint32_t DMA44:1;                 /* DMA enable for channel 44. */
    vuint32_t DMA43:1;                 /* DMA enable for channel 43. */
    vuint32_t DMA42:1;                 /* DMA enable for channel 42. */
    vuint32_t DMA41:1;                 /* DMA enable for channel 41. */
    vuint32_t DMA40:1;                 /* DMA enable for channel 40. */
    vuint32_t DMA39:1;                 /* DMA enable for channel 39. */
    vuint32_t DMA38:1;                 /* DMA enable for channel 38. */
    vuint32_t DMA37:1;                 /* DMA enable for channel 37. */
    vuint32_t DMA36:1;                 /* DMA enable for channel 36. */
    vuint32_t DMA35:1;                 /* DMA enable for channel 35. */
    vuint32_t DMA34:1;                 /* DMA enable for channel 34. */
    vuint32_t DMA33:1;                 /* DMA enable for channel 33. */
    vuint32_t DMA32:1;                 /* DMA enable for channel 32. */
  } B;
} ADC_DMAR1_tag;

typedef union ADC_DMAR2_union_tag {    /* DMA Channel Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DMA95:1;                 /* DMA enable for channel 95. */
    vuint32_t DMA94:1;                 /* DMA enable for channel 94. */
    vuint32_t DMA93:1;                 /* DMA enable for channel 93. */
    vuint32_t DMA92:1;                 /* DMA enable for channel 92. */
    vuint32_t DMA91:1;                 /* DMA enable for channel 91. */
    vuint32_t DMA90:1;                 /* DMA enable for channel 90. */
    vuint32_t DMA89:1;                 /* DMA enable for channel 89. */
    vuint32_t DMA88:1;                 /* DMA enable for channel 88. */
    vuint32_t DMA87:1;                 /* DMA enable for channel 87. */
    vuint32_t DMA86:1;                 /* DMA enable for channel 86. */
    vuint32_t DMA85:1;                 /* DMA enable for channel 85. */
    vuint32_t DMA84:1;                 /* DMA enable for channel 84. */
    vuint32_t DMA83:1;                 /* DMA enable for channel 83. */
    vuint32_t DMA82:1;                 /* DMA enable for channel 82. */
    vuint32_t DMA81:1;                 /* DMA enable for channel 81. */
    vuint32_t DMA80:1;                 /* DMA enable for channel 80. */
    vuint32_t DMA79:1;                 /* DMA enable for channel 79. */
    vuint32_t DMA78:1;                 /* DMA enable for channel 78. */
    vuint32_t DMA77:1;                 /* DMA enable for channel 77. */
    vuint32_t DMA76:1;                 /* DMA enable for channel 76. */
    vuint32_t DMA75:1;                 /* DMA enable for channel 75. */
    vuint32_t DMA74:1;                 /* DMA enable for channel 74. */
    vuint32_t DMA73:1;                 /* DMA enable for channel 73. */
    vuint32_t DMA72:1;                 /* DMA enable for channel 72. */
    vuint32_t DMA71:1;                 /* DMA enable for channel 71. */
    vuint32_t DMA70:1;                 /* DMA enable for channel 70. */
    vuint32_t DMA69:1;                 /* DMA enable for channel 69. */
    vuint32_t DMA68:1;                 /* DMA enable for channel 68. */
    vuint32_t DMA67:1;                 /* DMA enable for channel 67. */
    vuint32_t DMA66:1;                 /* DMA enable for channel 66. */
    vuint32_t DMA65:1;                 /* DMA enable for channel 65. */
    vuint32_t DMA64:1;                 /* DMA enable for channel 64. */
  } B;
} ADC_DMAR2_tag;

typedef union ADC_THRHLR0_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR0_tag;

typedef union ADC_THRHLR1_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR1_tag;

typedef union ADC_THRHLR2_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR2_tag;

typedef union ADC_THRHLR3_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR3_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t PREVAL2:2;               /* Internal voltage selection for Presampling */
    vuint32_t PREVAL1:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PRECONV:1;               /* Convert Presampled value */
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t PRES31:1;                /* Presampling enable for channel 31. */
    vuint32_t PRES30:1;                /* Presampling enable for channel 30. */
    vuint32_t PRES29:1;                /* Presampling enable for channel 29. */
    vuint32_t PRES28:1;                /* Presampling enable for channel 28. */
    vuint32_t PRES27:1;                /* Presampling enable for channel 27. */
    vuint32_t PRES26:1;                /* Presampling enable for channel 26. */
    vuint32_t PRES25:1;                /* Presampling enable for channel 25. */
    vuint32_t PRES24:1;                /* Presampling enable for channel 24. */
    vuint32_t PRES23:1;                /* Presampling enable for channel 23. */
    vuint32_t PRES22:1;                /* Presampling enable for channel 22. */
    vuint32_t PRES21:1;                /* Presampling enable for channel 21. */
    vuint32_t PRES20:1;                /* Presampling enable for channel 20. */
    vuint32_t PRES19:1;                /* Presampling enable for channel 19. */
    vuint32_t PRES18:1;                /* Presampling enable for channel 18. */
    vuint32_t PRES17:1;                /* Presampling enable for channel 17. */
    vuint32_t PRES16:1;                /* Presampling enable for channel 16. */
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_PSR1_union_tag {     /* Presampling register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRES63:1;                /* Presampling enable for channel 63. */
    vuint32_t PRES62:1;                /* Presampling enable for channel 62. */
    vuint32_t PRES61:1;                /* Presampling enable for channel 61. */
    vuint32_t PRES60:1;                /* Presampling enable for channel 60. */
    vuint32_t PRES59:1;                /* Presampling enable for channel 59. */
    vuint32_t PRES58:1;                /* Presampling enable for channel 58. */
    vuint32_t PRES57:1;                /* Presampling enable for channel 57. */
    vuint32_t PRES56:1;                /* Presampling enable for channel 56. */
    vuint32_t PRES55:1;                /* Presampling enable for channel 55. */
    vuint32_t PRES54:1;                /* Presampling enable for channel 54. */
    vuint32_t PRES53:1;                /* Presampling enable for channel 53. */
    vuint32_t PRES52:1;                /* Presampling enable for channel 52. */
    vuint32_t PRES51:1;                /* Presampling enable for channel 51. */
    vuint32_t PRES50:1;                /* Presampling enable for channel 50. */
    vuint32_t PRES49:1;                /* Presampling enable for channel 49. */
    vuint32_t PRES48:1;                /* Presampling enable for channel 48. */
    vuint32_t PRES47:1;                /* Presampling enable for channel 47. */
    vuint32_t PRES46:1;                /* Presampling enable for channel 46. */
    vuint32_t PRES45:1;                /* Presampling enable for channel 45. */
    vuint32_t PRES44:1;                /* Presampling enable for channel 44. */
    vuint32_t PRES43:1;                /* Presampling enable for channel 43. */
    vuint32_t PRES42:1;                /* Presampling enable for channel 42. */
    vuint32_t PRES41:1;                /* Presampling enable for channel 41. */
    vuint32_t PRES40:1;                /* Presampling enable for channel 40. */
    vuint32_t PRES39:1;                /* Presampling enable for channel 39. */
    vuint32_t PRES38:1;                /* Presampling enable for channel 38. */
    vuint32_t PRES37:1;                /* Presampling enable for channel 37. */
    vuint32_t PRES36:1;                /* Presampling enable for channel 36. */
    vuint32_t PRES35:1;                /* Presampling enable for channel 35. */
    vuint32_t PRES34:1;                /* Presampling enable for channel 34. */
    vuint32_t PRES33:1;                /* Presampling enable for channel 33. */
    vuint32_t PRES32:1;                /* Presampling enable for channel 32. */
  } B;
} ADC_PSR1_tag;

typedef union ADC_PSR2_union_tag {     /* Presampling register 2 */
  vuint32_t R;
  struct {
    vuint32_t PRES95:1;                /* Presampling enable for channel 95. */
    vuint32_t PRES94:1;                /* Presampling enable for channel 94. */
    vuint32_t PRES93:1;                /* Presampling enable for channel 93. */
    vuint32_t PRES92:1;                /* Presampling enable for channel 92. */
    vuint32_t PRES91:1;                /* Presampling enable for channel 91. */
    vuint32_t PRES90:1;                /* Presampling enable for channel 90. */
    vuint32_t PRES89:1;                /* Presampling enable for channel 89. */
    vuint32_t PRES88:1;                /* Presampling enable for channel 88. */
    vuint32_t PRES87:1;                /* Presampling enable for channel 87. */
    vuint32_t PRES86:1;                /* Presampling enable for channel 86. */
    vuint32_t PRES85:1;                /* Presampling enable for channel 85. */
    vuint32_t PRES84:1;                /* Presampling enable for channel 84. */
    vuint32_t PRES83:1;                /* Presampling enable for channel 83. */
    vuint32_t PRES82:1;                /* Presampling enable for channel 82. */
    vuint32_t PRES81:1;                /* Presampling enable for channel 81. */
    vuint32_t PRES80:1;                /* Presampling enable for channel 80. */
    vuint32_t PRES79:1;                /* Presampling enable for channel 79. */
    vuint32_t PRES78:1;                /* Presampling enable for channel 78. */
    vuint32_t PRES77:1;                /* Presampling enable for channel 77. */
    vuint32_t PRES76:1;                /* Presampling enable for channel 76. */
    vuint32_t PRES75:1;                /* Presampling enable for channel 75. */
    vuint32_t PRES74:1;                /* Presampling enable for channel 74. */
    vuint32_t PRES73:1;                /* Presampling enable for channel 73. */
    vuint32_t PRES72:1;                /* Presampling enable for channel 72. */
    vuint32_t PRES71:1;                /* Presampling enable for channel 71. */
    vuint32_t PRES70:1;                /* Presampling enable for channel 70. */
    vuint32_t PRES69:1;                /* Presampling enable for channel 69. */
    vuint32_t PRES68:1;                /* Presampling enable for channel 68. */
    vuint32_t PRES67:1;                /* Presampling enable for channel 67. */
    vuint32_t PRES66:1;                /* Presampling enable for channel 66. */
    vuint32_t PRES65:1;                /* Presampling enable for channel 65. */
    vuint32_t PRES64:1;                /* Presampling enable for channel 64. */
  } B;
} ADC_PSR2_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_12:2;
    vuint32_t _unused_11:1;
    vuint32_t _unused_9:2;
    vuint32_t _unused_8:1;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR1_tag;

typedef union ADC_CTR2_union_tag {     /* Conversion Timing Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR2_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH31:1;                  /* Normal sampling enable for channel 31. */
    vuint32_t CH30:1;                  /* Normal sampling enable for channel 30. */
    vuint32_t CH29:1;                  /* Normal sampling enable for channel 29. */
    vuint32_t CH28:1;                  /* Normal sampling enable for channel 28. */
    vuint32_t CH27:1;                  /* Normal sampling enable for channel 27. */
    vuint32_t CH26:1;                  /* Normal sampling enable for channel 26. */
    vuint32_t CH25:1;                  /* Normal sampling enable for channel 25. */
    vuint32_t CH24:1;                  /* Normal sampling enable for channel 24. */
    vuint32_t CH23:1;                  /* Normal sampling enable for channel 23. */
    vuint32_t CH22:1;                  /* Normal sampling enable for channel 22. */
    vuint32_t CH21:1;                  /* Normal sampling enable for channel 21. */
    vuint32_t CH20:1;                  /* Normal sampling enable for channel 20. */
    vuint32_t CH19:1;                  /* Normal sampling enable for channel 19. */
    vuint32_t CH18:1;                  /* Normal sampling enable for channel 18. */
    vuint32_t CH17:1;                  /* Normal sampling enable for channel 17. */
    vuint32_t CH16:1;                  /* Normal sampling enable for channel 16. */
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_NCMR1_union_tag {    /* Normal Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH63:1;                  /* Normal sampling enable for channel 63. */
    vuint32_t CH62:1;                  /* Normal sampling enable for channel 62. */
    vuint32_t CH61:1;                  /* Normal sampling enable for channel 61. */
    vuint32_t CH60:1;                  /* Normal sampling enable for channel 60. */
    vuint32_t CH59:1;                  /* Normal sampling enable for channel 59. */
    vuint32_t CH58:1;                  /* Normal sampling enable for channel 58. */
    vuint32_t CH57:1;                  /* Normal sampling enable for channel 57. */
    vuint32_t CH56:1;                  /* Normal sampling enable for channel 56. */
    vuint32_t CH55:1;                  /* Normal sampling enable for channel 55. */
    vuint32_t CH54:1;                  /* Normal sampling enable for channel 54. */
    vuint32_t CH53:1;                  /* Normal sampling enable for channel 53. */
    vuint32_t CH52:1;                  /* Normal sampling enable for channel 52. */
    vuint32_t CH51:1;                  /* Normal sampling enable for channel 51. */
    vuint32_t CH50:1;                  /* Normal sampling enable for channel 50. */
    vuint32_t CH49:1;                  /* Normal sampling enable for channel 49. */
    vuint32_t CH48:1;                  /* Normal sampling enable for channel 48. */
    vuint32_t CH47:1;                  /* Normal sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Normal sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Normal sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Normal sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Normal sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Normal sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Normal sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Normal sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Normal sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Normal sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Normal sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Normal sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Normal sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Normal sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Normal sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Normal sampling enable for channel 32. */
  } B;
} ADC_NCMR1_tag;

typedef union ADC_NCMR2_union_tag {    /* Normal Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Normal sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Normal sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Normal sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Normal sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Normal sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Normal sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Normal sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Normal sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Normal sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Normal sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Normal sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Normal sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Normal sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Normal sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Normal sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Normal sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Normal sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Normal sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Normal sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Normal sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Normal sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Normal sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Normal sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Normal sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Normal sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Normal sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Normal sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Normal sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Normal sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Normal sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Normal sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Normal sampling enable for channel 64. */
  } B;
} ADC_NCMR2_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH31:1;                  /* Injected sampling enable for channel 31. */
    vuint32_t CH30:1;                  /* Injected sampling enable for channel 30. */
    vuint32_t CH29:1;                  /* Injected sampling enable for channel 29. */
    vuint32_t CH28:1;                  /* Injected sampling enable for channel 28. */
    vuint32_t CH27:1;                  /* Injected sampling enable for channel 27. */
    vuint32_t CH26:1;                  /* Injected sampling enable for channel 26. */
    vuint32_t CH25:1;                  /* Injected sampling enable for channel 25. */
    vuint32_t CH24:1;                  /* Injected sampling enable for channel 24. */
    vuint32_t CH23:1;                  /* Injected sampling enable for channel 23. */
    vuint32_t CH22:1;                  /* Injected sampling enable for channel 22. */
    vuint32_t CH21:1;                  /* Injected sampling enable for channel 21. */
    vuint32_t CH20:1;                  /* Injected sampling enable for channel 20. */
    vuint32_t CH19:1;                  /* Injected sampling enable for channel 19. */
    vuint32_t CH18:1;                  /* Injected sampling enable for channel 18. */
    vuint32_t CH17:1;                  /* Injected sampling enable for channel 17. */
    vuint32_t CH16:1;                  /* Injected sampling enable for channel 16. */
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_JCMR1_union_tag {    /* Injected Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH63:1;                  /* Injected sampling enable for channel 63. */
    vuint32_t CH62:1;                  /* Injected sampling enable for channel 62. */
    vuint32_t CH61:1;                  /* Injected sampling enable for channel 61. */
    vuint32_t CH60:1;                  /* Injected sampling enable for channel 60. */
    vuint32_t CH59:1;                  /* Injected sampling enable for channel 59. */
    vuint32_t CH58:1;                  /* Injected sampling enable for channel 58. */
    vuint32_t CH57:1;                  /* Injected sampling enable for channel 57. */
    vuint32_t CH56:1;                  /* Injected sampling enable for channel 56. */
    vuint32_t CH55:1;                  /* Injected sampling enable for channel 55. */
    vuint32_t CH54:1;                  /* Injected sampling enable for channel 54. */
    vuint32_t CH53:1;                  /* Injected sampling enable for channel 53. */
    vuint32_t CH52:1;                  /* Injected sampling enable for channel 52. */
    vuint32_t CH51:1;                  /* Injected sampling enable for channel 51. */
    vuint32_t CH50:1;                  /* Injected sampling enable for channel 50. */
    vuint32_t CH49:1;                  /* Injected sampling enable for channel 49. */
    vuint32_t CH48:1;                  /* Injected sampling enable for channel 48. */
    vuint32_t CH47:1;                  /* Injected sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Injected sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Injected sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Injected sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Injected sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Injected sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Injected sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Injected sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Injected sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Injected sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Injected sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Injected sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Injected sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Injected sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Injected sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Injected sampling enable for channel 32. */
  } B;
} ADC_JCMR1_tag;

typedef union ADC_JCMR2_union_tag {    /* Injected Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Injected sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Injected sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Injected sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Injected sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Injected sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Injected sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Injected sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Injected sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Injected sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Injected sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Injected sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Injected sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Injected sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Injected sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Injected sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Injected sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Injected sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Injected sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Injected sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Injected sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Injected sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Injected sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Injected sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Injected sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Injected sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Injected sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Injected sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Injected sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Injected sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Injected sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Injected sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Injected sampling enable for channel 64. */
  } B;
} ADC_JCMR2_tag;

typedef union ADC_DSDR_union_tag {     /* Decode Signals Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DSD:16;
  } B;
} ADC_DSDR_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t PDED:8;
  } B;
} ADC_PDEDR_tag;

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
  } B;
} ADC_CDR_tag;

typedef union ADC_THRHLR4_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR4_tag;

typedef union ADC_THRHLR5_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR5_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWSELR2_union_tag {  /* Channel Watchdog Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH23:4;             /* Channel Watchdog select for channel 23. */
    vuint32_t WSEL_CH22:4;             /* Channel Watchdog select for channel 22. */
    vuint32_t WSEL_CH21:4;             /* Channel Watchdog select for channel 21. */
    vuint32_t WSEL_CH20:4;             /* Channel Watchdog select for channel 20. */
    vuint32_t WSEL_CH19:4;             /* Channel Watchdog select for channel 19. */
    vuint32_t WSEL_CH18:4;             /* Channel Watchdog select for channel 18. */
    vuint32_t WSEL_CH17:4;             /* Channel Watchdog select for channel 17. */
    vuint32_t WSEL_CH16:4;             /* Channel Watchdog select for channel 16. */
  } B;
} ADC_CWSELR2_tag;

typedef union ADC_CWSELR4_union_tag {  /* Channel Watchdog Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH39:4;             /* Channel Watchdog select for channel 39. */
    vuint32_t WSEL_CH38:4;             /* Channel Watchdog select for channel 38. */
    vuint32_t WSEL_CH37:4;             /* Channel Watchdog select for channel 37. */
    vuint32_t WSEL_CH36:4;             /* Channel Watchdog select for channel 36. */
    vuint32_t WSEL_CH35:4;             /* Channel Watchdog select for channel 35. */
    vuint32_t WSEL_CH34:4;             /* Channel Watchdog select for channel 34. */
    vuint32_t WSEL_CH33:4;             /* Channel Watchdog select for channel 33. */
    vuint32_t WSEL_CH32:4;             /* Channel Watchdog select for channel 32. */
  } B;
} ADC_CWSELR4_tag;

typedef union ADC_CWSELR5_union_tag {  /* Channel Watchdog Select Register 5 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH47:4;             /* Channel Watchdog select for channel 47. */
    vuint32_t WSEL_CH46:4;             /* Channel Watchdog select for channel 46. */
    vuint32_t WSEL_CH45:4;             /* Channel Watchdog select for channel 45. */
    vuint32_t WSEL_CH44:4;             /* Channel Watchdog select for channel 44. */
    vuint32_t WSEL_CH43:4;             /* Channel Watchdog select for channel 43. */
    vuint32_t WSEL_CH42:4;             /* Channel Watchdog select for channel 42. */
    vuint32_t WSEL_CH41:4;             /* Channel Watchdog select for channel 41. */
    vuint32_t WSEL_CH40:4;             /* Channel Watchdog select for channel 40. */
  } B;
} ADC_CWSELR5_tag;

typedef union ADC_CWSELR6_union_tag {  /* Channel Watchdog Select Register 6 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH55:4;             /* Channel Watchdog select for channel 55. */
    vuint32_t WSEL_CH54:4;             /* Channel Watchdog select for channel 54. */
    vuint32_t WSEL_CH53:4;             /* Channel Watchdog select for channel 53. */
    vuint32_t WSEL_CH52:4;             /* Channel Watchdog select for channel 52. */
    vuint32_t WSEL_CH51:4;             /* Channel Watchdog select for channel 51. */
    vuint32_t WSEL_CH50:4;             /* Channel Watchdog select for channel 50. */
    vuint32_t WSEL_CH49:4;             /* Channel Watchdog select for channel 49. */
    vuint32_t WSEL_CH48:4;             /* Channel Watchdog select for channel 48. */
  } B;
} ADC_CWSELR6_tag;

typedef union ADC_CWSELR7_union_tag {  /* Channel Watchdog Select Register 7 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH63:4;             /* Channel Watchdog select for channel 63. */
    vuint32_t WSEL_CH62:4;             /* Channel Watchdog select for channel 62. */
    vuint32_t WSEL_CH61:4;             /* Channel Watchdog select for channel 61. */
    vuint32_t WSEL_CH60:4;             /* Channel Watchdog select for channel 60. */
    vuint32_t WSEL_CH59:4;             /* Channel Watchdog select for channel 59. */
    vuint32_t WSEL_CH58:4;             /* Channel Watchdog select for channel 58. */
    vuint32_t WSEL_CH57:4;             /* Channel Watchdog select for channel 57. */
    vuint32_t WSEL_CH56:4;             /* Channel Watchdog select for channel 56. */
  } B;
} ADC_CWSELR7_tag;

typedef union ADC_CWSELR8_union_tag {  /* Channel Watchdog Select Register 8 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH71:4;             /* Channel Watchdog select for channel 71. */
    vuint32_t WSEL_CH70:4;             /* Channel Watchdog select for channel 70. */
    vuint32_t WSEL_CH69:4;             /* Channel Watchdog select for channel 69. */
    vuint32_t WSEL_CH68:4;             /* Channel Watchdog select for channel 68. */
    vuint32_t WSEL_CH67:4;             /* Channel Watchdog select for channel 67. */
    vuint32_t WSEL_CH66:4;             /* Channel Watchdog select for channel 66. */
    vuint32_t WSEL_CH65:4;             /* Channel Watchdog select for channel 65. */
    vuint32_t WSEL_CH64:4;             /* Channel Watchdog select for channel 64. */
  } B;
} ADC_CWSELR8_tag;

typedef union ADC_CWSELR9_union_tag {  /* Channel Watchdog Select Register 9 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH79:4;             /* Channel Watchdog select for channel 79. */
    vuint32_t WSEL_CH78:4;             /* Channel Watchdog select for channel 78. */
    vuint32_t WSEL_CH77:4;             /* Channel Watchdog select for channel 77. */
    vuint32_t WSEL_CH76:4;             /* Channel Watchdog select for channel 76. */
    vuint32_t WSEL_CH75:4;             /* Channel Watchdog select for channel 75. */
    vuint32_t WSEL_CH74:4;             /* Channel Watchdog select for channel 74. */
    vuint32_t WSEL_CH73:4;             /* Channel Watchdog select for channel 73. */
    vuint32_t WSEL_CH72:4;             /* Channel Watchdog select for channel 72. */
  } B;
} ADC_CWSELR9_tag;

typedef union ADC_CWSELR10_union_tag { /* Channel Watchdog Select Register 10 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH87:4;             /* Channel Watchdog select for channel 87. */
    vuint32_t WSEL_CH86:4;             /* Channel Watchdog select for channel 86. */
    vuint32_t WSEL_CH85:4;             /* Channel Watchdog select for channel 85. */
    vuint32_t WSEL_CH84:4;             /* Channel Watchdog select for channel 84. */
    vuint32_t WSEL_CH83:4;             /* Channel Watchdog select for channel 83. */
    vuint32_t WSEL_CH82:4;             /* Channel Watchdog select for channel 82. */
    vuint32_t WSEL_CH81:4;             /* Channel Watchdog select for channel 81. */
    vuint32_t WSEL_CH80:4;             /* Channel Watchdog select for channel 80. */
  } B;
} ADC_CWSELR10_tag;

typedef union ADC_CWSELR11_union_tag { /* Channel Watchdog Select Register 11 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH95:4;             /* Channel Watchdog select for channel 95. */
    vuint32_t WSEL_CH94:4;             /* Channel Watchdog select for channel 94. */
    vuint32_t WSEL_CH93:4;             /* Channel Watchdog select for channel 93. */
    vuint32_t WSEL_CH92:4;             /* Channel Watchdog select for channel 92. */
    vuint32_t WSEL_CH91:4;             /* Channel Watchdog select for channel 91. */
    vuint32_t WSEL_CH90:4;             /* Channel Watchdog select for channel 90. */
    vuint32_t WSEL_CH89:4;             /* Channel Watchdog select for channel 89. */
    vuint32_t WSEL_CH88:4;             /* Channel Watchdog select for channel 88. */
  } B;
} ADC_CWSELR11_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CWEN31:1;                /* Watchdog enable for channel 31. */
    vuint32_t CWEN30:1;                /* Watchdog enable for channel 30. */
    vuint32_t CWEN29:1;                /* Watchdog enable for channel 29. */
    vuint32_t CWEN28:1;                /* Watchdog enable for channel 28. */
    vuint32_t CWEN27:1;                /* Watchdog enable for channel 27. */
    vuint32_t CWEN26:1;                /* Watchdog enable for channel 26. */
    vuint32_t CWEN25:1;                /* Watchdog enable for channel 25. */
    vuint32_t CWEN24:1;                /* Watchdog enable for channel 24. */
    vuint32_t CWEN23:1;                /* Watchdog enable for channel 23. */
    vuint32_t CWEN22:1;                /* Watchdog enable for channel 22. */
    vuint32_t CWEN21:1;                /* Watchdog enable for channel 21. */
    vuint32_t CWEN20:1;                /* Watchdog enable for channel 20. */
    vuint32_t CWEN19:1;                /* Watchdog enable for channel 19. */
    vuint32_t CWEN18:1;                /* Watchdog enable for channel 18. */
    vuint32_t CWEN17:1;                /* Watchdog enable for channel 17. */
    vuint32_t CWEN16:1;                /* Watchdog enable for channel 16. */
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_CWENR1_union_tag {   /* Channel Watchdog Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CWEN63:1;                /* Watchdog enable for channel 63. */
    vuint32_t CWEN62:1;                /* Watchdog enable for channel 62. */
    vuint32_t CWEN61:1;                /* Watchdog enable for channel 61. */
    vuint32_t CWEN60:1;                /* Watchdog enable for channel 60. */
    vuint32_t CWEN59:1;                /* Watchdog enable for channel 59. */
    vuint32_t CWEN58:1;                /* Watchdog enable for channel 58. */
    vuint32_t CWEN57:1;                /* Watchdog enable for channel 57. */
    vuint32_t CWEN56:1;                /* Watchdog enable for channel 56. */
    vuint32_t CWEN55:1;                /* Watchdog enable for channel 55. */
    vuint32_t CWEN54:1;                /* Watchdog enable for channel 54. */
    vuint32_t CWEN53:1;                /* Watchdog enable for channel 53. */
    vuint32_t CWEN52:1;                /* Watchdog enable for channel 52. */
    vuint32_t CWEN51:1;                /* Watchdog enable for channel 51. */
    vuint32_t CWEN50:1;                /* Watchdog enable for channel 50. */
    vuint32_t CWEN49:1;                /* Watchdog enable for channel 49. */
    vuint32_t CWEN48:1;                /* Watchdog enable for channel 48. */
    vuint32_t CWEN47:1;                /* Watchdog enable for channel 47. */
    vuint32_t CWEN46:1;                /* Watchdog enable for channel 46. */
    vuint32_t CWEN45:1;                /* Watchdog enable for channel 45. */
    vuint32_t CWEN44:1;                /* Watchdog enable for channel 44. */
    vuint32_t CWEN43:1;                /* Watchdog enable for channel 43. */
    vuint32_t CWEN42:1;                /* Watchdog enable for channel 42. */
    vuint32_t CWEN41:1;                /* Watchdog enable for channel 41. */
    vuint32_t CWEN40:1;                /* Watchdog enable for channel 40. */
    vuint32_t CWEN39:1;                /* Watchdog enable for channel 39. */
    vuint32_t CWEN38:1;                /* Watchdog enable for channel 38. */
    vuint32_t CWEN37:1;                /* Watchdog enable for channel 37. */
    vuint32_t CWEN36:1;                /* Watchdog enable for channel 36. */
    vuint32_t CWEN35:1;                /* Watchdog enable for channel 35. */
    vuint32_t CWEN34:1;                /* Watchdog enable for channel 34. */
    vuint32_t CWEN33:1;                /* Watchdog enable for channel 33. */
    vuint32_t CWEN32:1;                /* Watchdog enable for channel 32. */
  } B;
} ADC_CWENR1_tag;

typedef union ADC_CWENR2_union_tag {   /* Channel Watchdog Enable Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CWEN95:1;                /* Watchdog enable for channel 95. */
    vuint32_t CWEN94:1;                /* Watchdog enable for channel 94. */
    vuint32_t CWEN93:1;                /* Watchdog enable for channel 93. */
    vuint32_t CWEN92:1;                /* Watchdog enable for channel 92. */
    vuint32_t CWEN91:1;                /* Watchdog enable for channel 91. */
    vuint32_t CWEN90:1;                /* Watchdog enable for channel 90. */
    vuint32_t CWEN89:1;                /* Watchdog enable for channel 89. */
    vuint32_t CWEN88:1;                /* Watchdog enable for channel 88. */
    vuint32_t CWEN87:1;                /* Watchdog enable for channel 87. */
    vuint32_t CWEN86:1;                /* Watchdog enable for channel 86. */
    vuint32_t CWEN85:1;                /* Watchdog enable for channel 85. */
    vuint32_t CWEN84:1;                /* Watchdog enable for channel 84. */
    vuint32_t CWEN83:1;                /* Watchdog enable for channel 83. */
    vuint32_t CWEN82:1;                /* Watchdog enable for channel 82. */
    vuint32_t CWEN81:1;                /* Watchdog enable for channel 81. */
    vuint32_t CWEN80:1;                /* Watchdog enable for channel 80. */
    vuint32_t CWEN79:1;                /* Watchdog enable for channel 79. */
    vuint32_t CWEN78:1;                /* Watchdog enable for channel 78. */
    vuint32_t CWEN77:1;                /* Watchdog enable for channel 77. */
    vuint32_t CWEN76:1;                /* Watchdog enable for channel 76. */
    vuint32_t CWEN75:1;                /* Watchdog enable for channel 75. */
    vuint32_t CWEN74:1;                /* Watchdog enable for channel 74. */
    vuint32_t CWEN73:1;                /* Watchdog enable for channel 73. */
    vuint32_t CWEN72:1;                /* Watchdog enable for channel 72. */
    vuint32_t CWEN71:1;                /* Watchdog enable for channel 71. */
    vuint32_t CWEN70:1;                /* Watchdog enable for channel 70. */
    vuint32_t CWEN69:1;                /* Watchdog enable for channel 69. */
    vuint32_t CWEN68:1;                /* Watchdog enable for channel 68. */
    vuint32_t CWEN67:1;                /* Watchdog enable for channel 67. */
    vuint32_t CWEN66:1;                /* Watchdog enable for channel 66. */
    vuint32_t CWEN65:1;                /* Watchdog enable for channel 65. */
    vuint32_t CWEN64:1;                /* Watchdog enable for channel 64. */
  } B;
} ADC_CWENR2_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH31:1;             /* Analog watchdog out of range for channel 31. */
    vuint32_t AWOR_CH30:1;             /* Analog watchdog out of range for channel 30. */
    vuint32_t AWOR_CH29:1;             /* Analog watchdog out of range for channel 29. */
    vuint32_t AWOR_CH28:1;             /* Analog watchdog out of range for channel 28. */
    vuint32_t AWOR_CH27:1;             /* Analog watchdog out of range for channel 27. */
    vuint32_t AWOR_CH26:1;             /* Analog watchdog out of range for channel 26. */
    vuint32_t AWOR_CH25:1;             /* Analog watchdog out of range for channel 25. */
    vuint32_t AWOR_CH24:1;             /* Analog watchdog out of range for channel 24. */
    vuint32_t AWOR_CH23:1;             /* Analog watchdog out of range for channel 23. */
    vuint32_t AWOR_CH22:1;             /* Analog watchdog out of range for channel 22. */
    vuint32_t AWOR_CH21:1;             /* Analog watchdog out of range for channel 21. */
    vuint32_t AWOR_CH20:1;             /* Analog watchdog out of range for channel 20. */
    vuint32_t AWOR_CH19:1;             /* Analog watchdog out of range for channel 19. */
    vuint32_t AWOR_CH18:1;             /* Analog watchdog out of range for channel 18. */
    vuint32_t AWOR_CH17:1;             /* Analog watchdog out of range for channel 17. */
    vuint32_t AWOR_CH16:1;             /* Analog watchdog out of range for channel 16. */
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_AWORR1_union_tag {   /* Analog Watchdog Out of Range Register 1 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH63:1;             /* Analog watchdog out of range for channel 63. */
    vuint32_t AWOR_CH62:1;             /* Analog watchdog out of range for channel 62. */
    vuint32_t AWOR_CH61:1;             /* Analog watchdog out of range for channel 61. */
    vuint32_t AWOR_CH60:1;             /* Analog watchdog out of range for channel 60. */
    vuint32_t AWOR_CH59:1;             /* Analog watchdog out of range for channel 59. */
    vuint32_t AWOR_CH58:1;             /* Analog watchdog out of range for channel 58. */
    vuint32_t AWOR_CH57:1;             /* Analog watchdog out of range for channel 57. */
    vuint32_t AWOR_CH56:1;             /* Analog watchdog out of range for channel 56. */
    vuint32_t AWOR_CH55:1;             /* Analog watchdog out of range for channel 55. */
    vuint32_t AWOR_CH54:1;             /* Analog watchdog out of range for channel 54. */
    vuint32_t AWOR_CH53:1;             /* Analog watchdog out of range for channel 53. */
    vuint32_t AWOR_CH52:1;             /* Analog watchdog out of range for channel 52. */
    vuint32_t AWOR_CH51:1;             /* Analog watchdog out of range for channel 51. */
    vuint32_t AWOR_CH50:1;             /* Analog watchdog out of range for channel 50. */
    vuint32_t AWOR_CH49:1;             /* Analog watchdog out of range for channel 49. */
    vuint32_t AWOR_CH48:1;             /* Analog watchdog out of range for channel 48. */
    vuint32_t AWOR_CH47:1;             /* Analog watchdog out of range for channel 47. */
    vuint32_t AWOR_CH46:1;             /* Analog watchdog out of range for channel 46. */
    vuint32_t AWOR_CH45:1;             /* Analog watchdog out of range for channel 45. */
    vuint32_t AWOR_CH44:1;             /* Analog watchdog out of range for channel 44. */
    vuint32_t AWOR_CH43:1;             /* Analog watchdog out of range for channel 43. */
    vuint32_t AWOR_CH42:1;             /* Analog watchdog out of range for channel 42. */
    vuint32_t AWOR_CH41:1;             /* Analog watchdog out of range for channel 41. */
    vuint32_t AWOR_CH40:1;             /* Analog watchdog out of range for channel 40. */
    vuint32_t AWOR_CH39:1;             /* Analog watchdog out of range for channel 39. */
    vuint32_t AWOR_CH38:1;             /* Analog watchdog out of range for channel 38. */
    vuint32_t AWOR_CH37:1;             /* Analog watchdog out of range for channel 37. */
    vuint32_t AWOR_CH36:1;             /* Analog watchdog out of range for channel 36. */
    vuint32_t AWOR_CH35:1;             /* Analog watchdog out of range for channel 35. */
    vuint32_t AWOR_CH34:1;             /* Analog watchdog out of range for channel 34. */
    vuint32_t AWOR_CH33:1;             /* Analog watchdog out of range for channel 33. */
    vuint32_t AWOR_CH32:1;             /* Analog watchdog out of range for channel 32. */
  } B;
} ADC_AWORR1_tag;

typedef union ADC_AWORR2_union_tag {   /* Analog Watchdog Out of Range Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH95:1;             /* Analog watchdog out of range for channel 95. */
    vuint32_t AWOR_CH94:1;             /* Analog watchdog out of range for channel 94. */
    vuint32_t AWOR_CH93:1;             /* Analog watchdog out of range for channel 93. */
    vuint32_t AWOR_CH92:1;             /* Analog watchdog out of range for channel 92. */
    vuint32_t AWOR_CH91:1;             /* Analog watchdog out of range for channel 91. */
    vuint32_t AWOR_CH90:1;             /* Analog watchdog out of range for channel 90. */
    vuint32_t AWOR_CH89:1;             /* Analog watchdog out of range for channel 89. */
    vuint32_t AWOR_CH88:1;             /* Analog watchdog out of range for channel 88. */
    vuint32_t AWOR_CH87:1;             /* Analog watchdog out of range for channel 87. */
    vuint32_t AWOR_CH86:1;             /* Analog watchdog out of range for channel 86. */
    vuint32_t AWOR_CH85:1;             /* Analog watchdog out of range for channel 85. */
    vuint32_t AWOR_CH84:1;             /* Analog watchdog out of range for channel 84. */
    vuint32_t AWOR_CH83:1;             /* Analog watchdog out of range for channel 83. */
    vuint32_t AWOR_CH82:1;             /* Analog watchdog out of range for channel 82. */
    vuint32_t AWOR_CH81:1;             /* Analog watchdog out of range for channel 81. */
    vuint32_t AWOR_CH80:1;             /* Analog watchdog out of range for channel 80. */
    vuint32_t AWOR_CH79:1;             /* Analog watchdog out of range for channel 79. */
    vuint32_t AWOR_CH78:1;             /* Analog watchdog out of range for channel 78. */
    vuint32_t AWOR_CH77:1;             /* Analog watchdog out of range for channel 77. */
    vuint32_t AWOR_CH76:1;             /* Analog watchdog out of range for channel 76. */
    vuint32_t AWOR_CH75:1;             /* Analog watchdog out of range for channel 75. */
    vuint32_t AWOR_CH74:1;             /* Analog watchdog out of range for channel 74. */
    vuint32_t AWOR_CH73:1;             /* Analog watchdog out of range for channel 73. */
    vuint32_t AWOR_CH72:1;             /* Analog watchdog out of range for channel 72. */
    vuint32_t AWOR_CH71:1;             /* Analog watchdog out of range for channel 71. */
    vuint32_t AWOR_CH70:1;             /* Analog watchdog out of range for channel 70. */
    vuint32_t AWOR_CH69:1;             /* Analog watchdog out of range for channel 69. */
    vuint32_t AWOR_CH68:1;             /* Analog watchdog out of range for channel 68. */
    vuint32_t AWOR_CH67:1;             /* Analog watchdog out of range for channel 67. */
    vuint32_t AWOR_CH66:1;             /* Analog watchdog out of range for channel 66. */
    vuint32_t AWOR_CH65:1;             /* Analog watchdog out of range for channel 65. */
    vuint32_t AWOR_CH64:1;             /* Analog watchdog out of range for channel 64. */
  } B;
} ADC_AWORR2_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_29:2;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t _unused_24:3;
    vuint32_t _unused_16:8;
    vuint32_t C_T_BUSY:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t _unused_1:2;
    vuint32_t TEST_EN:1;               /* Enable the test. */
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t GAIN_USER:10;
    vuint32_t _unused_8:8;
    vuint32_t OFFSET_USER:8;
  } B;
} ADC_OFSGNUSR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  ADC_CEOCFR1_tag CEOCFR1;             /* Channel Pending register 1 */
  ADC_CEOCFR2_tag CEOCFR2;             /* Channel Pending register 2 */
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  ADC_CIMR1_tag CIMR1;                 /* Channel Interrupt Mask Register 1 */
  ADC_CIMR2_tag CIMR2;                 /* Channel Interrupt Mask Register 2 */
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved1[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  ADC_DMAR1_tag DMAR1;                 /* DMA Channel Select Register 1 */
  ADC_DMAR2_tag DMAR2;                 /* DMA Channel Select Register 2 */
  uint8_t ADC_reserved2[16];
  ADC_THRHLR0_tag THRHLR0;             /* Threshold Register */
  ADC_THRHLR1_tag THRHLR1;             /* Threshold Register */
  ADC_THRHLR2_tag THRHLR2;             /* Threshold Register */
  ADC_THRHLR3_tag THRHLR3;             /* Threshold Register */
  uint8_t ADC_reserved3[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  ADC_PSR1_tag PSR1;                   /* Presampling register 1 */
  ADC_PSR2_tag PSR2;                   /* Presampling register 2 */
  uint8_t ADC_reserved4[4];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  ADC_CTR2_tag CTR2;                   /* Conversion Timing Register 2 */
  uint8_t ADC_reserved5[4];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  ADC_NCMR1_tag NCMR1;                 /* Normal Conversion Mask Register 1 */
  ADC_NCMR2_tag NCMR2;                 /* Normal Conversion Mask Register 2 */
  uint8_t ADC_reserved6[4];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  ADC_JCMR1_tag JCMR1;                 /* Injected Conversion Mask Register 1 */
  ADC_JCMR2_tag JCMR2;                 /* Injected Conversion Mask Register 2 */
  uint8_t ADC_reserved7[4];
  ADC_DSDR_tag DSDR;                   /* Decode Signals Delay Register */
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved8[52];
  ADC_CDR_tag CDR[96];                 /* Channel Data Register n (Precision Channels) */
  ADC_THRHLR4_tag THRHLR4;             /* Threshold Register */
  ADC_THRHLR5_tag THRHLR5;             /* Threshold Register */
  uint8_t ADC_reserved9[40];
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  ADC_CWSELR2_tag CWSELR2;             /* Channel Watchdog Select Register 2 */
  uint8_t ADC_reserved10[4];
  ADC_CWSELR4_tag CWSELR4;             /* Channel Watchdog Select Register 4 */
  ADC_CWSELR5_tag CWSELR5;             /* Channel Watchdog Select Register 5 */
  ADC_CWSELR6_tag CWSELR6;             /* Channel Watchdog Select Register 6 */
  ADC_CWSELR7_tag CWSELR7;             /* Channel Watchdog Select Register 7 */
  ADC_CWSELR8_tag CWSELR8;             /* Channel Watchdog Select Register 8 */
  ADC_CWSELR9_tag CWSELR9;             /* Channel Watchdog Select Register 9 */
  ADC_CWSELR10_tag CWSELR10;           /* Channel Watchdog Select Register 10 */
  ADC_CWSELR11_tag CWSELR11;           /* Channel Watchdog Select Register 11 */
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  ADC_CWENR1_tag CWENR1;               /* Channel Watchdog Enable Register 1 */
  ADC_CWENR2_tag CWENR2;               /* Channel Watchdog Enable Register 2 */
  uint8_t ADC_reserved11[4];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  ADC_AWORR1_tag AWORR1;               /* Analog Watchdog Out of Range Register 1 */
  ADC_AWORR2_tag AWORR2;               /* Analog Watchdog Out of Range Register 2 */
  uint8_t ADC_reserved12[164];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved13[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t _unused_27:1;
    vuint32_t MTR1:1;                  /* Master 1 trusted for read */
    vuint32_t MTW1:1;                  /* Master 1 trusted for writes */
    vuint32_t MPL1:1;                  /* Master 1 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t _unused_19:1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t _unused_15:1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t _unused_8:4;
    vuint32_t _unused_4:4;
    vuint32_t _unused_0:4;
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR8:1;                  /* Master 8 trusted for read */
    vuint32_t MTW8:1;                  /* Master 8 trusted for writes */
    vuint32_t MPL8:1;                  /* Master 8 privilege level */
    vuint32_t _unused_27:1;
    vuint32_t MTR9:1;                  /* Master 9 trusted for read */
    vuint32_t MTW9:1;                  /* Master 9 trusted for writes */
    vuint32_t MPL9:1;                  /* Master 9 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t _unused_20:3;
    vuint32_t _unused_19:1;
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;
    vuint32_t _unused_8:3;
    vuint32_t _unused_7:1;
    vuint32_t _unused_4:3;
    vuint32_t _unused_3:1;
    vuint32_t _unused_0:3;
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACR_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[248];
  AIPS_PACR_tag PACR[8];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[32];
  AIPS_OPACR_tag OPACR[32];            /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

typedef union AXBS_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} AXBS_PORT_PRS_tag;

typedef union AXBS_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t _unused_30:1;
    vuint32_t _unused_24:6;
    vuint32_t HPE7:1;
    vuint32_t HPE6:1;
    vuint32_t HPE5:1;
    vuint32_t HPE4:1;
    vuint32_t HPE3:1;
    vuint32_t HPE2:1;
    vuint32_t HPE1:1;
    vuint32_t HPE0:1;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} AXBS_PORT_CRS_tag;

typedef struct AXBS_PORT_struct_tag {
  AXBS_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  AXBS_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} AXBS_PORT_tag;

typedef union AXBS_MGPCR_MGPCR_union_tag { /* Master General Purpose Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t AULB:3;                  /* Arbitrates On Undefined Length Bursts */
  } B;
} AXBS_MGPCR_MGPCR_tag;

typedef struct AXBS_MGPCR_struct_tag {
  AXBS_MGPCR_MGPCR_tag MGPCR;          /* Master General Purpose Control Register */
  uint8_t MGPCR_reserved0[252];
} AXBS_MGPCR_tag;

struct AXBS_tag {
  AXBS_PORT_tag PORT[8];
  AXBS_MGPCR_tag MGPCR[8];
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

typedef union BCTU_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze mode - for debug operation. */
    vuint32_t _unused_27:2;
    vuint32_t GTRGEN:1;                /* Global Trigger Enable. */
    vuint32_t _unused_20:6;
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t _unused_18:1;
    vuint32_t DMA1:1;                  /* ADC1DR data transferring by DMA. */
    vuint32_t DMA0:1;                  /* ADC0DR data transferring by DMA. */
    vuint32_t _unused_8:8;
    vuint32_t TRGEN:1;                 /* Trigger interrupt request enable. */
    vuint32_t _unused_6:1;
    vuint32_t LIST_IEN:1;              /* LIST interrupt enable. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t IEN1:1;                  /* Interrupt enable bit for ADC1DR new data. */
    vuint32_t IEN0:1;                  /* Interrupt enable bit for ADC0DR new data. */
  } B;
} BCTU_MCR_tag;

typedef union BCTU_MSR_union_tag {     /* Module Status register */
  vuint32_t R;
  struct {
    vuint32_t TRGF_CLR:1;              /* TRGF clear */
    vuint32_t _unused_28:3;
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t LIST1_Last_CLR:1;
    vuint32_t LIST0_Last_CLR:1;
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t _unused_22:1;            /* Reserved. */
    vuint32_t DATAOVR1_CLR:1;          /* Clears DATAOVR1 flag */
    vuint32_t DATAOVR0_CLR:1;          /* Clears DATAOVR0 flag */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t _unused_18:1;            /* Reserved. */
    vuint32_t NDATA1_CLR:1;            /* Clears NDATA1 flag */
    vuint32_t NDATA0_CLR:1;            /* Clears NDATA0 flag */
    vuint32_t TRGF:1;                  /* Trigger Flag */
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t LIST1_Last:1;
    vuint32_t LIST0_Last:1;
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t _unused_6:1;             /* Reserved. */
    vuint32_t DATAOVR1:1;
    vuint32_t DATAOVR0:1;
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t NDATA1:1;
    vuint32_t NDATA0:1;
  } B;
} BCTU_MSR_tag;

typedef union BCTU_TRGCFG_union_tag {  /* Trigger Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* LOOP bit */
    vuint32_t _unused_24:7;
    vuint32_t _unused_16:8;            /* Reserved. */
    vuint32_t TRIGEN:1;                /* Trigger enable */
    vuint32_t TRG_FLAG:1;
    vuint32_t TRS:1;                   /* Trigger resolution */
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t ADC_SEL1:1;
    vuint32_t ADC_SEL0:1;
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t CHANNEL_VALUE_OR_LADDR:7; /* Channel Value or List Address Value. */
  } B;
} BCTU_TRGCFG_tag;

typedef union BCTU_WRPROT_union_tag {  /* Write Protection register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t PROTEC_CODE:4;           /* The Protection code sets protection for the write protected registers */
  } B;
} BCTU_WRPROT_tag;

typedef union BCTU_SFTRGR1_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG31:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG30:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG29:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG28:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG27:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG26:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG25:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG24:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG23:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG22:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG21:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG20:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG19:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG18:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG17:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG16:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG15:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG14:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG13:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG12:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG11:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG10:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG9:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG8:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG7:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG6:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG5:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG4:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG3:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG2:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG1:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG0:1;                /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR1_tag;

typedef union BCTU_SFTRGR2_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG63:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG62:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG61:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG60:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG59:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG58:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG57:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG56:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG55:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG54:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG53:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG52:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG51:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG50:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG49:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG48:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG47:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG46:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG45:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG44:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG43:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG42:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG41:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG40:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG39:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG38:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG37:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG36:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG35:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG34:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG33:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG32:1;               /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR2_tag;

typedef union BCTU_SFTRGR3_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG95:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG94:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG93:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG92:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG91:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG90:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG89:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG88:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG87:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG86:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG85:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG84:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG83:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG82:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG81:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG80:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG79:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG78:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG77:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG76:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG75:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG74:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG73:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG72:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG71:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG70:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG69:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG68:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG67:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG66:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG65:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG64:1;               /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR3_tag;

typedef union BCTU_ADC0DR_union_tag {  /* ADC0 Result Data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t _unused_12:2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC0DR_tag;

typedef union BCTU_ADC1DR_union_tag {  /* ADC1 result data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t _unused_12:2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC1DR_tag;

typedef union BCTU_LISTSTAR_union_tag { /* LIST Size Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;            /* Reserved. */
    vuint32_t LISTSZ:8;                /* Size of the LIST in number of elements. */
  } B;
} BCTU_LISTSTAR_tag;

typedef union BCTU_LISTCHR_union_tag { /* LIST Channel Address Register */
  vuint32_t R;
  struct {
    vuint32_t LAST_y:1;                /* Last channel in the list of channels. */
    vuint32_t _unused_28:3;
    vuint32_t _unused_24:4;            /* Reserved. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t ADC_CH_y:7;              /* ADC channel selection. */
    vuint32_t LAST_y_plus_1:1;         /* Second to last channel in the list of channels. */
    vuint32_t _unused_12:3;
    vuint32_t _unused_8:4;             /* Reserved. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t ADC_CHL_y_plus_1:7;      /* ADC channel selection. */
  } B;
} BCTU_LISTCHR_tag;

struct BCTU_tag {
  BCTU_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t BCTU_reserved0[4];
  BCTU_MSR_tag MSR;                    /* Module Status register */
  uint8_t BCTU_reserved1[12];
  BCTU_TRGCFG_tag TRGCFG[64];          /* Trigger Configuration Register */
  uint8_t BCTU_reserved2[272];
  BCTU_WRPROT_tag WRPROT;              /* Write Protection register */
  BCTU_SFTRGR1_tag SFTRGR1;            /* Software Trigger register 1 */
  BCTU_SFTRGR2_tag SFTRGR2;            /* Software Trigger register 1 */
  BCTU_SFTRGR3_tag SFTRGR3;            /* Software Trigger register 1 */
  uint8_t BCTU_reserved3[4];
  BCTU_ADC0DR_tag ADC0DR;              /* ADC0 Result Data register */
  BCTU_ADC1DR_tag ADC1DR;              /* ADC1 result data register */
  uint8_t BCTU_reserved4[8];
  BCTU_LISTSTAR_tag LISTSTAR;          /* LIST Size Status register */
  BCTU_LISTCHR_tag LISTCHR[16];        /* LIST Channel Address Register */
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t _unused_16:12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t _unused_12:1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t _unused_29:2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t _unused_30:1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t _unused_0:3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t _unused_19:11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t _unused_10:6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t _unused_7:1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t _unused_3:1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN_0 ==============================
   ============================================================================ */

typedef union CAN_0_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t WAKMSK:1;                /* Wake Up Interrupt Mask */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t SLFWAK:1;                /* Self Wake Up */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WAKSRC:1;                /* Wake Up Source */
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t _unused_15:1;
    vuint32_t PNET_EN:1;               /* Pretended Networking Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t _unused_10:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_0_MCR_tag;

typedef union CAN_0_CTRL1_union_tag {  /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_0_CTRL1_tag;

typedef union CAN_0_TIMER_union_tag {  /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_0_TIMER_tag;

typedef union CAN_0_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_0_RXMGMASK_tag;

typedef union CAN_0_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_0_RX14MASK_tag;

typedef union CAN_0_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_0_RX15MASK_tag;

typedef union CAN_0_ECR_union_tag {    /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_0_ECR_tag;

typedef union CAN_0_ESR1_union_tag {   /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_22:4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t WAKINT:1;                /* Wake-Up Interrupt */
  } B;
} CAN_0_ESR1_tag;

typedef union CAN_0_IMASK2_union_tag { /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_0_IMASK2_tag;

typedef union CAN_0_IMASK1_union_tag { /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_0_IMASK1_tag;

typedef union CAN_0_IFLAG2_union_tag { /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_0_IFLAG2_tag;

typedef union CAN_0_IFLAG1_union_tag { /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_0_IFLAG1_tag;

typedef union CAN_0_CTRL2_union_tag {  /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_2:9;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} CAN_0_CTRL2_tag;

typedef union CAN_0_ESR2_union_tag {   /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_0_ESR2_tag;

typedef union CAN_0_CRCR_union_tag {   /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_0_CRCR_tag;

typedef union CAN_0_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_0_RXFGMASK_tag;

typedef union CAN_0_RXFIR_union_tag {  /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_0_RXFIR_tag;

typedef union CAN_0_CBT_union_tag {    /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t _unused_20:1;
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_0_CBT_tag;

typedef union CAN_0_MB_CS_union_tag {  /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t _unused_23:1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_0_MB_CS_tag;

typedef union CAN_0_MB_ID_union_tag {  /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_0_MB_ID_tag;

typedef union CAN_0_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_0_MB_DATA_tag;

typedef struct CAN_0_MB_struct_tag {
  CAN_0_MB_CS_tag CS;                  /* Message Buffer 0 CS Register */
  CAN_0_MB_ID_tag ID;                  /* Message Buffer 0 ID Register */
  CAN_0_MB_DATA_tag DATA;
} CAN_0_MB_tag;

typedef union CAN_0_RXIMR_union_tag {  /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_0_RXIMR_tag;

typedef union CAN_0_CTRL1_PN_union_tag { /* Pretended Networking Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t WTOF_MSK:1;              /* Wake Up by Timeout Flag Mask Bit */
    vuint32_t WUMF_MSK:1;              /* Wake Up by Match Flag Mask Bit */
    vuint32_t NMATCH:8;                /* Number of Messages Matching the Same Filtering Criteria */
    vuint32_t _unused_6:2;
    vuint32_t PLFS:2;                  /* Payload Filtering Selection */
    vuint32_t IDFS:2;                  /* ID Filtering Selection */
    vuint32_t FCS:2;                   /* Filtering Combination Selection */
  } B;
} CAN_0_CTRL1_PN_tag;

typedef union CAN_0_CTRL2_PN_union_tag { /* Pretended Networking Control 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t MATCHTO:16;              /* Timeout for No Message Matching the Filtering Criteria */
  } B;
} CAN_0_CTRL2_PN_tag;

typedef union CAN_0_WU_MTC_union_tag { /* Pretended Networking Wake Up Match Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t WTOF:1;                  /* Wake Up by Timeout Flag Bit */
    vuint32_t WUMF:1;                  /* Wake Up by Match Flag Bit */
    vuint32_t MCOUNTER:8;              /* Number of Matches while in Pretended Networking */
    vuint32_t _unused_0:8;
  } B;
} CAN_0_WU_MTC_tag;

typedef union CAN_0_FLT_ID1_union_tag { /* Pretended Networking ID Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FLT_IDE:1;               /* ID Extended Filter */
    vuint32_t FLT_RTR:1;               /* Remote Transmission Request Filter */
    vuint32_t FLT_ID1:29;              /* ID Filter 1 for Pretended Networking filtering */
  } B;
} CAN_0_FLT_ID1_tag;

typedef union CAN_0_FLT_DLC_union_tag { /* Pretended Networking DLC Filter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FLT_DLC_LO:4;            /* Lower Limit for Length of Data Bytes Filter */
    vuint32_t _unused_4:12;
    vuint32_t FLT_DLC_HI:4;            /* Upper Limit for Length of Data Bytes Filter */
  } B;
} CAN_0_FLT_DLC_tag;

typedef union CAN_0_PL1_LO_union_tag { /* Pretended Networking Payload Low Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
    vuint32_t Data_byte_1:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
    vuint32_t Data_byte_2:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
    vuint32_t Data_byte_3:8;           /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
  } B;
} CAN_0_PL1_LO_tag;

typedef union CAN_0_PL1_HI_union_tag { /* Pretended Networking Payload High Filter 1 Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
    vuint32_t Data_byte_5:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
    vuint32_t Data_byte_6:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
    vuint32_t Data_byte_7:8;           /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
  } B;
} CAN_0_PL1_HI_tag;

typedef union CAN_0_FLT_ID2_IDMASK_union_tag { /* Pretended Networking ID Filter 2 Register / ID Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t IDE_MSK:1;               /* ID Extended Mask Bit */
    vuint32_t RTR_MSK:1;               /* Remote Transmission Request Mask Bit */
    vuint32_t FLT_ID2_IDMASK:29;       /* ID Filter 2 for Pretended Networking Filtering / ID Mask Bits for Pretended Networking ID Filtering */
  } B;
} CAN_0_FLT_ID2_IDMASK_tag;

typedef union CAN_0_PL2_PLMASK_LO_union_tag { /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
    vuint32_t Data_byte_1:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
    vuint32_t Data_byte_2:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
    vuint32_t Data_byte_3:8;           /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
  } B;
} CAN_0_PL2_PLMASK_LO_tag;

typedef union CAN_0_PL2_PLMASK_HI_union_tag { /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
    vuint32_t Data_byte_5:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
    vuint32_t Data_byte_6:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
    vuint32_t Data_byte_7:8;           /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
  } B;
} CAN_0_PL2_PLMASK_HI_tag;

typedef union CAN_0_WMB_CS_union_tag { /* Wake Up Message Buffer Register for C/S */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t SRR:1;                   /* Substitute Remote Request */
    vuint32_t IDE:1;                   /* ID Extended Bit */
    vuint32_t RTR:1;                   /* Remote Transmission Request Bit */
    vuint32_t DLC:4;                   /* Length of Data in Bytes */
    vuint32_t _unused_0:16;
  } B;
} CAN_0_WMB_CS_tag;

typedef union CAN_0_WMB_ID_union_tag { /* Wake Up Message Buffer Register for ID */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t ID:29;                   /* Received ID under Pretended Networking mode */
  } B;
} CAN_0_WMB_ID_tag;

typedef union CAN_0_WMB_D03_union_tag { /* Wake Up Message Buffer Register for Data 0-3 */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_0:8;           /* Received payload corresponding to the data byte 0 under Pretended Networking mode */
    vuint32_t Data_byte_1:8;           /* Received payload corresponding to the data byte 1 under Pretended Networking mode */
    vuint32_t Data_byte_2:8;           /* Received payload corresponding to the data byte 2 under Pretended Networking mode */
    vuint32_t Data_byte_3:8;           /* Received payload corresponding to the data byte 3 under Pretended Networking mode */
  } B;
} CAN_0_WMB_D03_tag;

typedef union CAN_0_WMB_D47_union_tag { /* Wake Up Message Buffer Register Data 4-7 */
  vuint32_t R;
  struct {
    vuint32_t Data_byte_4:8;           /* Received payload corresponding to the data byte 4 under Pretended Networking mode */
    vuint32_t Data_byte_5:8;           /* Received payload corresponding to the data byte 5 under Pretended Networking mode */
    vuint32_t Data_byte_6:8;           /* Received payload corresponding to the data byte 6 under Pretended Networking mode */
    vuint32_t Data_byte_7:8;           /* Received payload corresponding to the data byte 7 under Pretended Networking mode */
  } B;
} CAN_0_WMB_D47_tag;

typedef struct CAN_0_WMB_struct_tag {
  CAN_0_WMB_CS_tag CS;                 /* Wake Up Message Buffer Register for C/S */
  CAN_0_WMB_ID_tag ID;                 /* Wake Up Message Buffer Register for ID */
  CAN_0_WMB_D03_tag D03;               /* Wake Up Message Buffer Register for Data 0-3 */
  CAN_0_WMB_D47_tag D47;               /* Wake Up Message Buffer Register Data 4-7 */
} CAN_0_WMB_tag;

typedef union CAN_0_FDCTRL_union_tag { /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t _unused_27:4;
    vuint32_t _unused_25:2;
    vuint32_t _unused_24:1;
    vuint32_t _unused_22:2;
    vuint32_t _unused_21:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t _unused_13:1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_6:2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_0_FDCTRL_tag;

typedef union CAN_0_FDCBT_union_tag {  /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t FRJW:2;                  /* Fast Resync Jump Width */
    vuint32_t _unused_15:1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_8:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_0_FDCBT_tag;

typedef union CAN_0_FDCRC_union_tag {  /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_21:3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_0_FDCRC_tag;

struct CAN_0_tag {
  CAN_0_MCR_tag MCR;                   /* Module Configuration Register */
  CAN_0_CTRL1_tag CTRL1;               /* Control 1 register */
  CAN_0_TIMER_tag TIMER;               /* Free Running Timer */
  uint8_t CAN_0_reserved0[4];
  CAN_0_RXMGMASK_tag RXMGMASK;         /* Rx Mailboxes Global Mask Register */
  CAN_0_RX14MASK_tag RX14MASK;         /* Rx 14 Mask register */
  CAN_0_RX15MASK_tag RX15MASK;         /* Rx 15 Mask register */
  CAN_0_ECR_tag ECR;                   /* Error Counter */
  CAN_0_ESR1_tag ESR1;                 /* Error and Status 1 register */
  CAN_0_IMASK2_tag IMASK2;             /* Interrupt Masks 2 register */
  CAN_0_IMASK1_tag IMASK1;             /* Interrupt Masks 1 register */
  CAN_0_IFLAG2_tag IFLAG2;             /* Interrupt Flags 2 register */
  CAN_0_IFLAG1_tag IFLAG1;             /* Interrupt Flags 1 register */
  CAN_0_CTRL2_tag CTRL2;               /* Control 2 register */
  CAN_0_ESR2_tag ESR2;                 /* Error and Status 2 register */
  uint8_t CAN_0_reserved1[8];
  CAN_0_CRCR_tag CRCR;                 /* CRC Register */
  CAN_0_RXFGMASK_tag RXFGMASK;         /* Rx FIFO Global Mask register */
  CAN_0_RXFIR_tag RXFIR;               /* Rx FIFO Information Register */
  CAN_0_CBT_tag CBT;                   /* CAN Bit Timing Register */
  uint8_t CAN_0_reserved2[44];
  CAN_0_MB_tag MB[64];
  uint8_t CAN_0_reserved3[1024];
  CAN_0_RXIMR_tag RXIMR[64];           /* Rx Individual Mask Registers */
  uint8_t CAN_0_reserved4[384];
  CAN_0_CTRL1_PN_tag CTRL1_PN;         /* Pretended Networking Control 1 Register */
  CAN_0_CTRL2_PN_tag CTRL2_PN;         /* Pretended Networking Control 2 Register */
  CAN_0_WU_MTC_tag WU_MTC;             /* Pretended Networking Wake Up Match Register */
  CAN_0_FLT_ID1_tag FLT_ID1;           /* Pretended Networking ID Filter 1 Register */
  CAN_0_FLT_DLC_tag FLT_DLC;           /* Pretended Networking DLC Filter Register */
  CAN_0_PL1_LO_tag PL1_LO;             /* Pretended Networking Payload Low Filter 1 Register */
  CAN_0_PL1_HI_tag PL1_HI;             /* Pretended Networking Payload High Filter 1 Register */
  CAN_0_FLT_ID2_IDMASK_tag FLT_ID2_IDMASK; /* Pretended Networking ID Filter 2 Register / ID Mask Register */
  CAN_0_PL2_PLMASK_LO_tag PL2_PLMASK_LO; /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
  CAN_0_PL2_PLMASK_HI_tag PL2_PLMASK_HI; /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
  uint8_t CAN_0_reserved5[24];
  CAN_0_WMB_tag WMB[4];
  uint8_t CAN_0_reserved6[128];
  CAN_0_FDCTRL_tag FDCTRL;             /* CAN FD Control Register */
  CAN_0_FDCBT_tag FDCBT;               /* CAN FD Bit Timing Register */
  CAN_0_FDCRC_tag FDCRC;               /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CAN 1-7 ============================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t WAKMSK:1;                /* Wake Up Interrupt Mask */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t SLFWAK:1;                /* Self Wake Up */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WAKSRC:1;                /* Wake Up Source */
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t _unused_10:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_22:4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t WAKINT:1;                /* Wake-Up Interrupt */
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_2:9;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t _unused_20:1;
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_CBT_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t _unused_23:1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_FDCTRL_union_tag {   /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t _unused_27:4;
    vuint32_t _unused_25:2;
    vuint32_t _unused_24:1;
    vuint32_t _unused_22:2;
    vuint32_t _unused_21:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t _unused_13:1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_6:2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_FDCTRL_tag;

typedef union CAN_FDCBT_union_tag {    /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t FRJW:2;                  /* Fast Resync Jump Width */
    vuint32_t _unused_15:1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_8:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_FDCBT_tag;

typedef union CAN_FDCRC_union_tag {    /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_21:3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_FDCRC_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[44];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved3[1024];
  CAN_RXIMR_tag RXIMR[64];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved4[640];
  CAN_FDCTRL_tag FDCTRL;               /* CAN FD Control Register */
  CAN_FDCBT_tag FDCBT;                 /* CAN FD Bit Timing Register */
  CAN_FDCRC_tag FDCRC;                 /* CAN FD CRC Register */
};

/* ============================================================================
   =============================== Module: CMP ================================
   ============================================================================ */

typedef union CMP_C0_union_tag {       /* CMP Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t DMAEN:1;                 /* DMA Enable */
    vuint32_t _unused_29:1;
    vuint32_t IER:1;                   /* Comparator Interrupt Enable Rising */
    vuint32_t IEF:1;                   /* Comparator Interrupt Enable Falling */
    vuint32_t CFR:1;                   /* Analog Comparator Flag Rising */
    vuint32_t CFF:1;                   /* Analog Comparator Flag Falling */
    vuint32_t COUT:1;                  /* Analog Comparator Output */
    vuint32_t FPR:8;                   /* Filter Sample Period */
    vuint32_t SE:1;                    /* Sample Enable */
    vuint32_t WE:1;                    /* Windowing Enable */
    vuint32_t _unused_13:1;
    vuint32_t PMODE:1;                 /* Power Mode Select */
    vuint32_t INVT:1;                  /* Comparator invert */
    vuint32_t COS:1;                   /* Comparator Output Select */
    vuint32_t OPE:1;                   /* Comparator Output Pin Enable */
    vuint32_t EN:1;                    /* Comparator Module Enable */
    vuint32_t _unused_7:1;
    vuint32_t FILTER_CNT:3;            /* Filter Sample Count */
    vuint32_t _unused_2:2;
    vuint32_t HYSTCTR:2;               /* Comparator hard block hysteresis control */
  } B;
} CMP_C0_tag;

typedef union CMP_C1_union_tag {       /* CMP Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_24:7;
    vuint32_t CHN7:1;                  /* Channel 7 input enable */
    vuint32_t CHN6:1;                  /* Channel 6 input enable */
    vuint32_t CHN5:1;                  /* Channel 5 input enable */
    vuint32_t CHN4:1;                  /* Channel 4 input enable */
    vuint32_t CHN3:1;                  /* Channel 3 input enable */
    vuint32_t CHN2:1;                  /* Channel 2 input enable */
    vuint32_t CHN1:1;                  /* Channel 1 input enable */
    vuint32_t CHN0:1;                  /* Channel 0 input enable */
    vuint32_t DPSEL:1;                 /* DAC output to Plus side ANMUX selection */
    vuint32_t DMSEL:1;                 /* DAC output to Minus side ANMUX selection */
    vuint32_t PSEL:3;                  /* Plus Input MUX Control */
    vuint32_t MSEL:3;                  /* Minus Input MUX Control */
    vuint32_t DACEN:1;                 /* DAC Enable */
    vuint32_t VRSEL:1;                 /* Supply Voltage Reference Source Select */
    vuint32_t VOSEL:6;                 /* DAC Output Voltage Select */
  } B;
} CMP_C1_tag;

typedef union CMP_C2_union_tag {       /* CMP Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t RRE:1;                   /* Round-Robin Enable */
    vuint32_t RRIE:1;                  /* Round-Robin interrupt enable */
    vuint32_t FXMP:1;                  /* Fixed MUX Port */
    vuint32_t FXDACI:1;                /* Fix DAC input to the fixed mux port side */
    vuint32_t FXMXCH:3;                /* Fixed channel selection */
    vuint32_t _unused_24:1;
    vuint32_t CH7F:1;
    vuint32_t CH6F:1;
    vuint32_t CH5F:1;
    vuint32_t CH4F:1;
    vuint32_t CH3F:1;
    vuint32_t CH2F:1;
    vuint32_t CH1F:1;
    vuint32_t CH0F:1;
    vuint32_t NSAM:2;                  /* Number of sample clocks */
    vuint32_t _unused_8:6;
    vuint32_t ACOn:8;
  } B;
} CMP_C2_tag;

struct CMP_tag {
  CMP_C0_tag C0;                       /* CMP Control Register 0 */
  CMP_C1_tag C1;                       /* CMP Control Register 1 */
  CMP_C2_tag C2;                       /* CMP Control Register 2 */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_10:13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_3:5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG_union_tag {      /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_6:18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CFG_tag;

typedef union CRC_INP_union_tag {      /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP_tag;

typedef union CRC_CSTAT_union_tag {    /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT_tag;

typedef union CRC_OUTP_union_tag {     /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP_tag;

struct CRC_tag {
  CRC_CFG_tag CFG;                     /* Configuration Register */
  CRC_INP_tag INP;                     /* Input Register */
  CRC_CSTAT_tag CSTAT;                 /* Current Status Register */
  CRC_OUTP_tag OUTP;                   /* Output Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t _unused_11:5;
    vuint32_t GRP1PRI:1;               /* Channel Group 1 Priority */
    vuint32_t _unused_9:1;
    vuint32_t GRP0PRI:1;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t _unused_0:1;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_18:13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_13:1;
    vuint32_t ERRCHN:5;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t DBE:1;                   /* Destination Bus Error */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEI_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t SERQ:5;                   /* Set Enable Request */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t CERQ:5;                   /* Clear Enable Request */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t SEEI:5;                   /* Set Enable Error Interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t CEEI:5;                   /* Clear Enable Error Interrupt */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t _unused_5:1;
    vuint8_t CINT:5;                   /* Clear Interrupt Request */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t _unused_5:1;
    vuint8_t CERR:5;                   /* Clear Error Indicator */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t _unused_5:1;
    vuint8_t SSRT:5;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t _unused_5:1;
    vuint8_t CDNE:5;                   /* Clear DONE Bit */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRS_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;                    /* Enable Master ID replication */
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t _unused_4:2;
    vuint8_t MID:4;                    /* Master ID */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;                  /* Source Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t CITER:15;                /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Minor Loop Link Channel Number */
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Link Channel Number */
    vuint16_t BITER:9;                 /* Starting major iteration count */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;                   /* Bandwidth Control */
    vuint16_t _unused_13:1;
    vuint16_t MAJORLINKCH:5;           /* Major Loop Link Channel Number */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t START:1;                 /* Channel Start */
  } B;
} DMA_TCD_CSR_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_BITER_tag BITER;
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  uint8_t DMA_reserved5[200];
  DMA_DCHPRI_tag DCHPRI[32];           /* Channel n Priority Register */
  uint8_t DMA_reserved6[32];
  DMA_DCHMID_tag DCHMID[32];           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3744];
  DMA_TCD_tag TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

typedef union DSPI_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* Interface Configuration */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_4:4;
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} DSPI_MCR_tag;

typedef union DSPI_TCR_union_tag {     /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} DSPI_TCR_tag;

typedef union DSPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} DSPI_MODE_CTAR_tag;

typedef union DSPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t FMSZ:5;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t FMSZ5:1;                 /* MSB of Frame Size when DSI is used in 64-bit Mode */
    vuint32_t _unused_0:22;
  } B;
} DSPI_MODE_CTAR_SLAVE_tag;

typedef union DSPI_MODE_union_tag {
  DSPI_MODE_CTAR_tag CTAR[2];          /* Clock and Transfer Attributes Register (In Master Mode) */
  DSPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} DSPI_MODE_tag;

typedef union DSPI_CTAR_union_tag {    /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} DSPI_CTAR_tag;

typedef union DSPI_SR_union_tag {      /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t SPITCF:1;                /* SPI Frame Transfer Complete Flag. */
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t DSITCF:1;                /* DSI Frame Transfer Complete Flag. */
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t DPEF:1;                  /* DSI Parity Error Flag */
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t DDIF:1;                  /* DSI Data Received with Active Bits */
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} DSPI_SR_tag;

typedef union DSPI_RSER_union_tag {    /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t SPITCF_RE:1;             /* SPI Frame Transmission Complete Request Enable. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t DSITCF_RE:1;             /* DSI Frame Transmission Complete Request Enable. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t DPEF_RE:1;               /* DSI Parity Error Request Enable */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t DDIF_RE:1;               /* DSI data received with active bits Request Enable */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t DDIF_DIRS:1;             /* DSI data received with active bits - DMA or Interrupt Request Select. */
    vuint32_t _unused_0:14;
  } B;
} DSPI_RSER_tag;

typedef union DSPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_tag;

typedef union DSPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_SLAVE_tag;

typedef union DSPI_PUSHR_union_tag {
  DSPI_PUSHR_PUSHR_tag PUSHR;          /* PUSH TX FIFO Register In Master Mode */
  DSPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} DSPI_PUSHR_tag;

typedef union DSPI_POPR_union_tag {    /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} DSPI_POPR_tag;

typedef union DSPI_TXFR_union_tag {    /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_TXFR_tag;

typedef union DSPI_RXFR_union_tag {    /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} DSPI_RXFR_tag;

typedef union DSPI_DSICR0_union_tag {  /* DSI Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FMSZ4:1;                 /* MSB of the frame size in master mode. */
    vuint32_t _unused_24:6;
    vuint32_t FMSZ5:1;                 /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
    vuint32_t _unused_21:2;
    vuint32_t _unused_20:1;
    vuint32_t TXSS:1;                  /* Transmit Data Source Select. */
    vuint32_t TPOL:1;                  /* Trigger Polarity */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t DCONT:1;                 /* DSI Continuous Peripheral Chip Select Enable */
    vuint32_t DSICTAS:3;               /* DSI Clock and Transfer Attributes Select */
    vuint32_t DMS:1;                   /* Data Match Stop */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t DPCSx:8;                 /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR0_tag;

typedef union DSPI_SDR0_union_tag {    /* DSI Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR0_tag;

typedef union DSPI_ASDR0_union_tag {   /* DSI Alternate Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR0_tag;

typedef union DSPI_COMPR0_union_tag {  /* DSI Transmit Comparison Register 0 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR0_tag;

typedef union DSPI_DDR0_union_tag {    /* DSI Deserialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR0_tag;

typedef union DSPI_DSICR1_union_tag {  /* DSI Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_24:6;
    vuint32_t _unused_21:3;
    vuint32_t CSI_PRTY:1;              /* CSI Priority */
    vuint32_t _unused_19:1;
    vuint32_t DSI64E:1;                /* DSI 64-bit Mode Enable */
    vuint32_t _unused_16:2;
    vuint32_t _unused_8:8;
    vuint32_t _unused_0:8;
  } B;
} DSPI_DSICR1_tag;

typedef union DSPI_SSR0_union_tag {    /* DSI Serialization Source Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR0_tag;

typedef union DSPI_PISR0_union_tag {   /* DSI Parallel Input Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IPS7:4;                  /* Input Pin Select 7 */
    vuint32_t IPS6:4;                  /* Input Pin Select 6 */
    vuint32_t IPS5:4;                  /* Input Pin Select 5 */
    vuint32_t IPS4:4;                  /* Input Pin Select 5 */
    vuint32_t IPS3:4;                  /* Input Pin Select 3 */
    vuint32_t IPS2:4;                  /* Input Pin Select 2 */
    vuint32_t IPS1:4;                  /* Input Pin Select 1 */
    vuint32_t IPS0:4;                  /* Input Pin Select 0 */
  } B;
} DSPI_PISR0_tag;

typedef union DSPI_PISR1_union_tag {   /* DSI Parallel Input Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t IPS15:4;                 /* Input Pin Select 15 */
    vuint32_t IPS14:4;                 /* Input Pin Select 14 */
    vuint32_t IPS13:4;                 /* Input Pin Select 13 */
    vuint32_t IPS12:4;                 /* Input Pin Select 12 */
    vuint32_t IPS11:4;                 /* Input Pin Select 11 */
    vuint32_t IPS10:4;                 /* Input Pin Select 10 */
    vuint32_t IPS9:4;                  /* Input Pin Select 9 */
    vuint32_t IPS8:4;                  /* Input Pin Select 8 */
  } B;
} DSPI_PISR1_tag;

typedef union DSPI_PISR2_union_tag {   /* DSI Parallel Input Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t IPS23:4;                 /* Input Pin Select 23 */
    vuint32_t IPS22:4;                 /* Input Pin Select 22 */
    vuint32_t IPS21:4;                 /* Input Pin Select 21 */
    vuint32_t IPS20:4;                 /* Input Pin Select 20 */
    vuint32_t IPS19:4;                 /* Input Pin Select 19 */
    vuint32_t IPS18:4;                 /* Input Pin Select 18 */
    vuint32_t IPS17:4;                 /* Input Pin Select 17 */
    vuint32_t IPS16:4;                 /* Input Pin Select 16 */
  } B;
} DSPI_PISR2_tag;

typedef union DSPI_PISR3_union_tag {   /* DSI Parallel Input Select Register 3 */
  vuint32_t R;
  struct {
    vuint32_t IPS31:4;                 /* Input Pin Select 31 */
    vuint32_t IPS30:4;                 /* Input Pin Select 30 */
    vuint32_t IPS29:4;                 /* Input Pin Select 29 */
    vuint32_t IPS28:4;                 /* Input Pin Select 28 */
    vuint32_t IPS27:4;                 /* Input Pin Select 27 */
    vuint32_t IPS26:4;                 /* Input Pin Select 26 */
    vuint32_t IPS25:4;                 /* Input Pin Select 25 */
    vuint32_t IPS24:4;                 /* Input Pin Select 24 */
  } B;
} DSPI_PISR3_tag;

typedef union DSPI_DIMR0_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR0_tag;

typedef union DSPI_DPIR0_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR0_tag;

typedef union DSPI_SDR1_union_tag {    /* DSI Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR1_tag;

typedef union DSPI_ASDR1_union_tag {   /* DSI Alternate Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR1_tag;

typedef union DSPI_COMPR1_union_tag {  /* DSI Transmit Comparison Register 1 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR1_tag;

typedef union DSPI_DDR1_union_tag {    /* DSI Deserialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR1_tag;

typedef union DSPI_SSR1_union_tag {    /* DSI Serialization Source Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR1_tag;

typedef union DSPI_PISR4_union_tag {   /* DSI Parallel Input Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t IPS39:4;                 /* Input Pin Select 39 */
    vuint32_t IPS38:4;                 /* Input Pin Select 38 */
    vuint32_t IPS37:4;                 /* Input Pin Select 37 */
    vuint32_t IPS36:4;                 /* Input Pin Select 36 */
    vuint32_t IPS35:4;                 /* Input Pin Select 35 */
    vuint32_t IPS34:4;                 /* Input Pin Select 34 */
    vuint32_t IPS33:4;                 /* Input Pin Select 33 */
    vuint32_t IPS32:4;                 /* Input Pin Select 32 */
  } B;
} DSPI_PISR4_tag;

typedef union DSPI_PISR5_union_tag {   /* DSI Parallel Input Select Register 5 */
  vuint32_t R;
  struct {
    vuint32_t IPS47:4;                 /* Input Pin Select 47 */
    vuint32_t IPS46:4;                 /* Input Pin Select 46 */
    vuint32_t IPS45:4;                 /* Input Pin Select 45 */
    vuint32_t IPS44:4;                 /* Input Pin Select 44 */
    vuint32_t IPS43:4;                 /* Input Pin Select 43 */
    vuint32_t IPS42:4;                 /* Input Pin Select 42 */
    vuint32_t IPS41:4;                 /* Input Pin Select 41 */
    vuint32_t IPS40:4;                 /* Input Pin Select 40 */
  } B;
} DSPI_PISR5_tag;

typedef union DSPI_PISR6_union_tag {   /* DSI Parallel Input Select Register 6 */
  vuint32_t R;
  struct {
    vuint32_t IPS55:4;                 /* Input Pin Select 55 */
    vuint32_t IPS54:4;                 /* Input Pin Select 54 */
    vuint32_t IPS53:4;                 /* Input Pin Select 53 */
    vuint32_t IPS52:4;                 /* Input Pin Select 52 */
    vuint32_t IPS51:4;                 /* Input Pin Select 51 */
    vuint32_t IPS50:4;                 /* Input Pin Select 50 */
    vuint32_t IPS49:4;                 /* Input Pin Select 49 */
    vuint32_t IPS48:4;                 /* Input Pin Select 48 */
  } B;
} DSPI_PISR6_tag;

typedef union DSPI_PISR7_union_tag {   /* DSI Parallel Input Select Register 7 */
  vuint32_t R;
  struct {
    vuint32_t IPS63:4;                 /* Input Pin Select 63 */
    vuint32_t IPS62:4;                 /* Input Pin Select 62 */
    vuint32_t IPS61:4;                 /* Input Pin Select 61 */
    vuint32_t IPS60:4;                 /* Input Pin Select 60 */
    vuint32_t IPS59:4;                 /* Input Pin Select 59 */
    vuint32_t IPS58:4;                 /* Input Pin Select 58 */
    vuint32_t IPS57:4;                 /* Input Pin Select 57 */
    vuint32_t IPS56:4;                 /* Input Pin Select 56 */
  } B;
} DSPI_PISR7_tag;

typedef union DSPI_DIMR1_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR1_tag;

typedef union DSPI_DPIR1_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR1_tag;

typedef union DSPI_CTARE_union_tag {   /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t _unused_11:5;
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
  } B;
} DSPI_CTARE_tag;

typedef union DSPI_SREX_union_tag {    /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t _unused_12:2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t _unused_9:2;
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} DSPI_SREX_tag;

typedef union DSPI_TRIG_union_tag {    /* Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;                /* Trigger Register Enable */
    vuint32_t _unused_4:27;
    vuint32_t _unused_3:1;
    vuint32_t ASDR_WT:1;               /* ASDR Write Trigger Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
  } B;
} DSPI_TRIG_tag;

struct DSPI_tag {
  DSPI_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t DSPI_reserved0[4];
  DSPI_TCR_tag TCR;                    /* Transfer Count Register */
  DSPI_MODE_tag MODE;
  DSPI_CTAR_tag CTAR[4];               /* Clock and Transfer Attributes Register (In Master Mode) */
  uint8_t DSPI_reserved1[8];
  DSPI_SR_tag SR;                      /* Status Register */
  DSPI_RSER_tag RSER;                  /* DMA/Interrupt Request Select and Enable Register */
  DSPI_PUSHR_tag PUSHR;
  DSPI_POPR_tag POPR;                  /* POP RX FIFO Register */
  DSPI_TXFR_tag TXFR[4];               /* Transmit FIFO Registers */
  uint8_t DSPI_reserved2[48];
  DSPI_RXFR_tag RXFR[4];               /* Receive FIFO Registers */
  uint8_t DSPI_reserved3[48];
  DSPI_DSICR0_tag DSICR0;              /* DSI Configuration Register 0 */
  DSPI_SDR0_tag SDR0;                  /* DSI Serialization Data Register 0 */
  DSPI_ASDR0_tag ASDR0;                /* DSI Alternate Serialization Data Register 0 */
  DSPI_COMPR0_tag COMPR0;              /* DSI Transmit Comparison Register 0 */
  DSPI_DDR0_tag DDR0;                  /* DSI Deserialization Data Register 0 */
  DSPI_DSICR1_tag DSICR1;              /* DSI Configuration Register 1 */
  DSPI_SSR0_tag SSR0;                  /* DSI Serialization Source Select Register 0 */
  DSPI_PISR0_tag PISR0;                /* DSI Parallel Input Select Register 0 */
  DSPI_PISR1_tag PISR1;                /* DSI Parallel Input Select Register 1 */
  DSPI_PISR2_tag PISR2;                /* DSI Parallel Input Select Register 2 */
  DSPI_PISR3_tag PISR3;                /* DSI Parallel Input Select Register 3 */
  DSPI_DIMR0_tag DIMR0;                /* DSI Deserialized Data Interrupt Mask Register 0 */
  DSPI_DPIR0_tag DPIR0;                /* DSI Deserialized Data Polarity Interrupt Register 0 */
  DSPI_SDR1_tag SDR1;                  /* DSI Serialization Data Register 1 */
  DSPI_ASDR1_tag ASDR1;                /* DSI Alternate Serialization Data Register 1 */
  DSPI_COMPR1_tag COMPR1;              /* DSI Transmit Comparison Register 1 */
  DSPI_DDR1_tag DDR1;                  /* DSI Deserialization Data Register 1 */
  DSPI_SSR1_tag SSR1;                  /* DSI Serialization Source Select Register 1 */
  DSPI_PISR4_tag PISR4;                /* DSI Parallel Input Select Register 4 */
  DSPI_PISR5_tag PISR5;                /* DSI Parallel Input Select Register 5 */
  DSPI_PISR6_tag PISR6;                /* DSI Parallel Input Select Register 6 */
  DSPI_PISR7_tag PISR7;                /* DSI Parallel Input Select Register 7 */
  DSPI_DIMR1_tag DIMR1;                /* DSI Deserialized Data Interrupt Mask Register 1 */
  DSPI_DPIR1_tag DPIR1;                /* DSI Deserialized Data Polarity Interrupt Register 1 */
  DSPI_CTARE_tag CTARE[6];             /* Clock and Transfer Attributes Register Extended */
  uint8_t DSPI_reserved4[8];
  DSPI_SREX_tag SREX;                  /* Status Register Extended */
  DSPI_TRIG_tag TRIG;                  /* Trigger Register */
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

typedef union ENET_EIR_union_tag {     /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* Babbling Receive Error */
    vuint32_t BABT:1;                  /* Babbling Transmit Error */
    vuint32_t GRA:1;                   /* Graceful Stop Complete */
    vuint32_t TXF:1;                   /* Transmit Frame Interrupt */
    vuint32_t TXB:1;                   /* Transmit Buffer Interrupt */
    vuint32_t RXF:1;                   /* Receive Frame Interrupt */
    vuint32_t RXB:1;                   /* Receive Buffer Interrupt */
    vuint32_t MII:1;                   /* MII Interrupt. */
    vuint32_t EBERR:1;                 /* Ethernet Bus Error */
    vuint32_t LC:1;                    /* Late Collision */
    vuint32_t RL:1;                    /* Collision Retry Limit */
    vuint32_t UN:1;                    /* Transmit FIFO Underrun */
    vuint32_t PLR:1;                   /* Payload Receive Error */
    vuint32_t WAKEUP:1;                /* Node Wakeup Request Indication */
    vuint32_t TS_AVAIL:1;              /* Transmit Timestamp Available */
    vuint32_t TS_TIMER:1;              /* Timestamp Timer */
    vuint32_t RXFLUSH_2:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t _unused_11:1;
    vuint32_t PARSERR:1;
    vuint32_t PARSRF:1;
    vuint32_t _unused_8:1;
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
  } B;
} ENET_EIR_tag;

typedef union ENET_EIMR_union_tag {    /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* BABR Interrupt Mask */
    vuint32_t BABT:1;                  /* BABT Interrupt Mask */
    vuint32_t GRA:1;                   /* GRA Interrupt Mask */
    vuint32_t TXF:1;                   /* TXF Interrupt Mask */
    vuint32_t TXB:1;                   /* TXB Interrupt Mask */
    vuint32_t RXF:1;                   /* RXF Interrupt Mask */
    vuint32_t RXB:1;                   /* RXB Interrupt Mask */
    vuint32_t MII:1;                   /* MII Interrupt Mask */
    vuint32_t EBERR:1;                 /* EBERR Interrupt Mask */
    vuint32_t LC:1;                    /* LC Interrupt Mask */
    vuint32_t RL:1;                    /* RL Interrupt Mask */
    vuint32_t UN:1;                    /* UN Interrupt Mask */
    vuint32_t PLR:1;                   /* PLR Interrupt Mask */
    vuint32_t WAKEUP:1;                /* WAKEUP Interrupt Mask */
    vuint32_t TS_AVAIL:1;              /* TS_AVAIL Interrupt Mask */
    vuint32_t TS_TIMER:1;              /* TS_TIMER Interrupt Mask */
    vuint32_t RXFLUSH_2:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_0:1;
    vuint32_t _unused_11:1;
    vuint32_t PARSERR:1;
    vuint32_t PARSRF:1;
    vuint32_t _unused_8:1;
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
  } B;
} ENET_EIMR_tag;

typedef union ENET_RDAR_union_tag {    /* Receive Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR_tag;

typedef union ENET_TDAR_union_tag {    /* Transmit Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR_tag;

typedef union ENET_ECR_union_tag {     /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t SVLANDBL:1;              /* S-VLAN double tag */
    vuint32_t VLANUSE2ND:1;            /* VLAN use second tag */
    vuint32_t SVLANEN:1;               /* S-VLAN enable */
    vuint32_t DBSWP:1;                 /* Descriptor Byte Swapping Enable */
    vuint32_t _unused_7:1;
    vuint32_t DBGEN:1;                 /* Debug Enable */
    vuint32_t _unused_5:1;
    vuint32_t EN1588:1;                /* EN1588 Enable */
    vuint32_t SLEEP:1;                 /* Sleep Mode Enable */
    vuint32_t MAGICEN:1;               /* Magic Packet Detection Enable */
    vuint32_t ETHEREN:1;               /* Ethernet Enable */
    vuint32_t RESET:1;                 /* Ethernet MAC Reset */
  } B;
} ENET_ECR_tag;

typedef union ENET_MMFR_union_tag {    /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;                    /* Start Of Frame Delimiter */
    vuint32_t OP:2;                    /* Operation Code */
    vuint32_t PA:5;                    /* PHY Address */
    vuint32_t RA:5;                    /* Register Address */
    vuint32_t TA:2;                    /* Turn Around */
    vuint32_t DATA:16;                 /* Management Frame Data */
  } B;
} ENET_MMFR_tag;

typedef union ENET_MSCR_union_tag {    /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t HOLDTIME:3;              /* Hold time On MDIO Output */
    vuint32_t DIS_PRE:1;               /* Disable Preamble */
    vuint32_t MII_SPEED:6;             /* MII Speed */
    vuint32_t _unused_0:1;
  } B;
} ENET_MSCR_tag;

typedef union ENET_MIBC_union_tag {    /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;               /* Disable MIB Logic */
    vuint32_t MIB_IDLE:1;              /* MIB Idle */
    vuint32_t MIB_CLEAR:1;             /* MIB Clear */
    vuint32_t _unused_0:29;
  } B;
} ENET_MIBC_tag;

typedef union ENET_RCR_union_tag {     /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t GRS:1;                   /* Graceful Receive Stopped */
    vuint32_t NLC:1;                   /* Payload Length Check Disable */
    vuint32_t MAX_FL:14;               /* Maximum Frame Length */
    vuint32_t CFEN:1;                  /* MAC Control Frame Enable */
    vuint32_t CRCFWD:1;                /* Terminate/Forward Received CRC */
    vuint32_t PAUFWD:1;                /* Terminate/Forward Pause Frames */
    vuint32_t PADEN:1;                 /* Enable Frame Padding Remove On Receive */
    vuint32_t _unused_10:2;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;             /* RMII Mode Enable */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t FCE:1;                   /* Flow Control Enable */
    vuint32_t BC_REJ:1;                /* Broadcast Frame Reject */
    vuint32_t PROM:1;                  /* Promiscuous Mode */
    vuint32_t MII_MODE:1;              /* Media Independent Interface Mode */
    vuint32_t DRT:1;                   /* Disable Receive On Transmit */
    vuint32_t LOOP:1;                  /* Internal Loopback */
  } B;
} ENET_RCR_tag;

typedef union ENET_TCR_union_tag {     /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CRCFWD:1;                /* Forward Frame From Application With CRC */
    vuint32_t ADDINS:1;                /* Set MAC Address On Transmit */
    vuint32_t ADDSEL:3;                /* Source MAC Address Select On Transmit */
    vuint32_t RFC_PAUSE:1;             /* Receive Frame Control Pause */
    vuint32_t TFC_PAUSE:1;             /* Transmit Frame Control Pause */
    vuint32_t FDEN:1;                  /* Full-Duplex Enable */
    vuint32_t _unused_1:1;
    vuint32_t GTS:1;                   /* Graceful Transmit Stop */
  } B;
} ENET_TCR_tag;

typedef union ENET_PALR_union_tag {    /* Physical Address Lower Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;               /* Pause Address */
  } B;
} ENET_PALR_tag;

typedef union ENET_PAUR_union_tag {    /* Physical Address Upper Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;                 /* Type Field In PAUSE Frames */
  } B;
} ENET_PAUR_tag;

typedef union ENET_OPD_union_tag {     /* Opcode/Pause Duration Register */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;               /* Opcode Field In PAUSE Frames */
    vuint32_t PAUSE_DUR:16;            /* Pause Duration */
  } B;
} ENET_OPD_tag;

typedef union ENET_TXIC_union_tag {    /* Transmit Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ENET_TXIC_tag;

typedef union ENET_RXIC_union_tag {    /* Receive Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
  } B;
} ENET_RXIC_tag;

typedef union ENET_IAUR_union_tag {    /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} ENET_IAUR_tag;

typedef union ENET_IALR_union_tag {    /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} ENET_IALR_tag;

typedef union ENET_GAUR_union_tag {    /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} ENET_GAUR_tag;

typedef union ENET_GALR_union_tag {    /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} ENET_GALR_tag;

typedef union ENET_TFWR_union_tag {    /* Transmit FIFO Watermark Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t STRFWD:1;                /* Store And Forward Enable */
    vuint32_t _unused_6:2;
    vuint32_t TFWR:6;                  /* Transmit FIFO Write */
  } B;
} ENET_TFWR_tag;

typedef union ENET_RDSR1_union_tag {   /* Receive Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR1_tag;

typedef union ENET_TDSR1_union_tag {   /* Transmit Buffer Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR1_tag;

typedef union ENET_MRBR1_union_tag {   /* Maximum Receive Buffer Size Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR1_tag;

typedef union ENET_RDSR2_union_tag {   /* Receive Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR2_tag;

typedef union ENET_TDSR2_union_tag {   /* Transmit Buffer Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR2_tag;

typedef union ENET_MRBR2_union_tag {   /* Maximum Receive Buffer Size Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR2_tag;

typedef union ENET_RDSR_union_tag {    /* Receive Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR_tag;

typedef union ENET_TDSR_union_tag {    /* Transmit Buffer Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR_tag;

typedef union ENET_MRBR_union_tag {    /* Maximum Receive Buffer Size Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR_tag;

typedef union ENET_RSFL_union_tag {    /* Receive FIFO Section Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_SECTION_FULL:8;       /* Value Of Receive FIFO Section Full Threshold */
  } B;
} ENET_RSFL_tag;

typedef union ENET_RSEM_union_tag {    /* Receive FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t STAT_SECTION_EMPTY:5;    /* RX Status FIFO Section Empty Threshold */
    vuint32_t _unused_8:8;
    vuint32_t RX_SECTION_EMPTY:8;      /* Value Of The Receive FIFO Section Empty Threshold */
  } B;
} ENET_RSEM_tag;

typedef union ENET_RAEM_union_tag {    /* Receive FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_EMPTY:8;       /* Value Of The Receive FIFO Almost Empty Threshold */
  } B;
} ENET_RAEM_tag;

typedef union ENET_RAFL_union_tag {    /* Receive FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_FULL:8;        /* Value Of The Receive FIFO Almost Full Threshold */
  } B;
} ENET_RAFL_tag;

typedef union ENET_TSEM_union_tag {    /* Transmit FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_SECTION_EMPTY:8;      /* Value Of The Transmit FIFO Section Empty Threshold */
  } B;
} ENET_TSEM_tag;

typedef union ENET_TAEM_union_tag {    /* Transmit FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_EMPTY:8;       /* Value of Transmit FIFO Almost Empty Threshold */
  } B;
} ENET_TAEM_tag;

typedef union ENET_TAFL_union_tag {    /* Transmit FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_FULL:8;        /* Value Of The Transmit FIFO Almost Full Threshold */
  } B;
} ENET_TAFL_tag;

typedef union ENET_TIPG_union_tag {    /* Transmit Inter-Packet Gap */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IPG:5;                   /* Transmit Inter-Packet Gap */
  } B;
} ENET_TIPG_tag;

typedef union ENET_FTRL_union_tag {    /* Frame Truncation Length */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t TRUNC_FL:14;             /* Frame Truncation Length */
  } B;
} ENET_FTRL_tag;

typedef union ENET_TACC_union_tag {    /* Transmit Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PROCHK:1;
    vuint32_t IPCHK:1;
    vuint32_t _unused_1:2;
    vuint32_t SHIFT16:1;               /* TX FIFO Shift-16 */
  } B;
} ENET_TACC_tag;

typedef union ENET_RACC_union_tag {    /* Receive Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t SHIFT16:1;               /* RX FIFO Shift-16 */
    vuint32_t LINEDIS:1;               /* Enable Discard Of Frames With MAC Layer Errors */
    vuint32_t _unused_3:3;
    vuint32_t PRODIS:1;                /* Enable Discard Of Frames With Wrong Protocol Checksum */
    vuint32_t IPDIS:1;                 /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
    vuint32_t PADREM:1;                /* Enable Padding Removal For Short IP Frames */
  } B;
} ENET_RACC_tag;

typedef union ENET_RCMR_union_tag {    /* Receive Classification Match Register for Class n */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t MATCHEN:1;               /* Match Enable */
    vuint32_t _unused_15:1;
    vuint32_t CMP3:3;                  /* Compare 3 */
    vuint32_t _unused_11:1;
    vuint32_t CMP2:3;                  /* Compare 2 */
    vuint32_t _unused_7:1;
    vuint32_t CMP1:3;                  /* Compare 1 */
    vuint32_t _unused_3:1;
    vuint32_t CMP0:3;                  /* Compare 0 */
  } B;
} ENET_RCMR_tag;

typedef union ENET_DMACFG_union_tag {  /* DMA Class Based Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_18:6;
    vuint32_t CALC_NOIPG:1;            /* Calculate no IPG */
    vuint32_t DMA_CLASS_EN:1;          /* DMA class enable */
    vuint32_t IDLE_SLOPE:16;           /* Idle slope */
  } B;
} ENET_DMACFG_tag;

typedef union ENET_RDAR1_union_tag {   /* Receive Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR1_tag;

typedef union ENET_TDAR1_union_tag {   /* Transmit Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR1_tag;

typedef union ENET_RDAR2_union_tag {   /* Receive Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR2_tag;

typedef union ENET_TDAR2_union_tag {   /* Transmit Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR2_tag;

typedef union ENET_QOS_union_tag {     /* QOS Scheme */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t RX_FLUSH2:1;             /* RX Flush Ring 2 */
    vuint32_t RX_FLUSH1:1;             /* RX Flush Ring 1 */
    vuint32_t RX_FLUSH0:1;             /* RX Flush Ring 0 */
    vuint32_t TX_SCHEME:3;             /* TX scheme configuration */
  } B;
} ENET_QOS_tag;

typedef union ENET_RMON_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_RMON_T_DROP_tag;

typedef union ENET_RMON_T_PACKETS_union_tag { /* Tx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Packet count */
    vuint32_t TXPKTS14:1;              /* Packet count */
    vuint32_t TXPKTS13:1;              /* Packet count */
    vuint32_t TXPKTS12:1;              /* Packet count */
    vuint32_t TXPKTS11:1;              /* Packet count */
    vuint32_t TXPKTS10:1;              /* Packet count */
    vuint32_t TXPKTS9:1;               /* Packet count */
    vuint32_t TXPKTS8:1;               /* Packet count */
    vuint32_t TXPKTS7:1;               /* Packet count */
    vuint32_t TXPKTS6:1;               /* Packet count */
    vuint32_t TXPKTS5:1;               /* Packet count */
    vuint32_t TXPKTS4:1;               /* Packet count */
    vuint32_t TXPKTS3:1;               /* Packet count */
    vuint32_t TXPKTS2:1;               /* Packet count */
    vuint32_t TXPKTS1:1;               /* Packet count */
    vuint32_t TXPKTS0:1;               /* Packet count */
  } B;
} ENET_RMON_T_PACKETS_tag;

typedef union ENET_RMON_T_BC_PKT_union_tag { /* Tx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Broadcast packets */
    vuint32_t TXPKTS14:1;              /* Broadcast packets */
    vuint32_t TXPKTS13:1;              /* Broadcast packets */
    vuint32_t TXPKTS12:1;              /* Broadcast packets */
    vuint32_t TXPKTS11:1;              /* Broadcast packets */
    vuint32_t TXPKTS10:1;              /* Broadcast packets */
    vuint32_t TXPKTS9:1;               /* Broadcast packets */
    vuint32_t TXPKTS8:1;               /* Broadcast packets */
    vuint32_t TXPKTS7:1;               /* Broadcast packets */
    vuint32_t TXPKTS6:1;               /* Broadcast packets */
    vuint32_t TXPKTS5:1;               /* Broadcast packets */
    vuint32_t TXPKTS4:1;               /* Broadcast packets */
    vuint32_t TXPKTS3:1;               /* Broadcast packets */
    vuint32_t TXPKTS2:1;               /* Broadcast packets */
    vuint32_t TXPKTS1:1;               /* Broadcast packets */
    vuint32_t TXPKTS0:1;               /* Broadcast packets */
  } B;
} ENET_RMON_T_BC_PKT_tag;

typedef union ENET_RMON_T_MC_PKT_union_tag { /* Tx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Multicast packets */
    vuint32_t TXPKTS14:1;              /* Multicast packets */
    vuint32_t TXPKTS13:1;              /* Multicast packets */
    vuint32_t TXPKTS12:1;              /* Multicast packets */
    vuint32_t TXPKTS11:1;              /* Multicast packets */
    vuint32_t TXPKTS10:1;              /* Multicast packets */
    vuint32_t TXPKTS9:1;               /* Multicast packets */
    vuint32_t TXPKTS8:1;               /* Multicast packets */
    vuint32_t TXPKTS7:1;               /* Multicast packets */
    vuint32_t TXPKTS6:1;               /* Multicast packets */
    vuint32_t TXPKTS5:1;               /* Multicast packets */
    vuint32_t TXPKTS4:1;               /* Multicast packets */
    vuint32_t TXPKTS3:1;               /* Multicast packets */
    vuint32_t TXPKTS2:1;               /* Multicast packets */
    vuint32_t TXPKTS1:1;               /* Multicast packets */
    vuint32_t TXPKTS0:1;               /* Multicast packets */
  } B;
} ENET_RMON_T_MC_PKT_tag;

typedef union ENET_RMON_T_CRC_ALIGN_union_tag { /* Tx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS14:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS13:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS12:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS11:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS10:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS9:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS8:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS7:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS6:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS5:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS4:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS3:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS2:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS1:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS0:1;               /* Packets with CRC/align error */
  } B;
} ENET_RMON_T_CRC_ALIGN_tag;

typedef union ENET_RMON_T_UNDERSIZE_union_tag { /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets less than 64 bytes with good CRC */
  } B;
} ENET_RMON_T_UNDERSIZE_tag;

typedef union ENET_RMON_T_OVERSIZE_union_tag { /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
  } B;
} ENET_RMON_T_OVERSIZE_tag;

typedef union ENET_RMON_T_FRAG_union_tag { /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS14:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS13:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS12:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS11:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS10:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS9:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS8:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS7:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS6:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS5:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS4:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS3:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS2:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS1:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS0:1;               /* Number of packets less than 64 bytes with bad CRC */
  } B;
} ENET_RMON_T_FRAG_tag;

typedef union ENET_RMON_T_JAB_union_tag { /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
  } B;
} ENET_RMON_T_JAB_tag;

typedef union ENET_RMON_T_COL_union_tag { /* Tx Collision Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS14:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS13:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS12:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS11:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS10:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS9:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS8:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS7:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS6:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS5:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS4:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS3:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS2:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS1:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS0:1;               /* Number of transmit collisions */
  } B;
} ENET_RMON_T_COL_tag;

typedef union ENET_RMON_T_P64_union_tag { /* Tx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 64-byte transmit packets */
  } B;
} ENET_RMON_T_P64_tag;

typedef union ENET_RMON_T_P65TO127_union_tag { /* Tx 65- to 127-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 65- to 127-byte transmit packets */
  } B;
} ENET_RMON_T_P65TO127_tag;

typedef union ENET_RMON_T_P128TO255_union_tag { /* Tx 128- to 255-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 128- to 255-byte transmit packets */
  } B;
} ENET_RMON_T_P128TO255_tag;

typedef union ENET_RMON_T_P256TO511_union_tag { /* Tx 256- to 511-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 256- to 511-byte transmit packets */
  } B;
} ENET_RMON_T_P256TO511_tag;

typedef union ENET_RMON_T_P512TO1023_union_tag { /* Tx 512- to 1023-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 512- to 1023-byte transmit packets */
  } B;
} ENET_RMON_T_P512TO1023_tag;

typedef union ENET_RMON_T_P1024TO2047_union_tag { /* Tx 1024- to 2047-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 1024- to 2047-byte transmit packets */
  } B;
} ENET_RMON_T_P1024TO2047_tag;

typedef union ENET_RMON_T_P_GTE2048_union_tag { /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than 2048 bytes */
  } B;
} ENET_RMON_T_P_GTE2048_tag;

typedef union ENET_RMON_T_OCTETS_union_tag { /* Tx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXOCTS31:1;              /* Number of transmit octets */
    vuint32_t TXOCTS30:1;              /* Number of transmit octets */
    vuint32_t TXOCTS29:1;              /* Number of transmit octets */
    vuint32_t TXOCTS28:1;              /* Number of transmit octets */
    vuint32_t TXOCTS27:1;              /* Number of transmit octets */
    vuint32_t TXOCTS26:1;              /* Number of transmit octets */
    vuint32_t TXOCTS25:1;              /* Number of transmit octets */
    vuint32_t TXOCTS24:1;              /* Number of transmit octets */
    vuint32_t TXOCTS23:1;              /* Number of transmit octets */
    vuint32_t TXOCTS22:1;              /* Number of transmit octets */
    vuint32_t TXOCTS21:1;              /* Number of transmit octets */
    vuint32_t TXOCTS20:1;              /* Number of transmit octets */
    vuint32_t TXOCTS19:1;              /* Number of transmit octets */
    vuint32_t TXOCTS18:1;              /* Number of transmit octets */
    vuint32_t TXOCTS17:1;              /* Number of transmit octets */
    vuint32_t TXOCTS16:1;              /* Number of transmit octets */
    vuint32_t TXOCTS15:1;              /* Number of transmit octets */
    vuint32_t TXOCTS14:1;              /* Number of transmit octets */
    vuint32_t TXOCTS13:1;              /* Number of transmit octets */
    vuint32_t TXOCTS12:1;              /* Number of transmit octets */
    vuint32_t TXOCTS11:1;              /* Number of transmit octets */
    vuint32_t TXOCTS10:1;              /* Number of transmit octets */
    vuint32_t TXOCTS9:1;               /* Number of transmit octets */
    vuint32_t TXOCTS8:1;               /* Number of transmit octets */
    vuint32_t TXOCTS7:1;               /* Number of transmit octets */
    vuint32_t TXOCTS6:1;               /* Number of transmit octets */
    vuint32_t TXOCTS5:1;               /* Number of transmit octets */
    vuint32_t TXOCTS4:1;               /* Number of transmit octets */
    vuint32_t TXOCTS3:1;               /* Number of transmit octets */
    vuint32_t TXOCTS2:1;               /* Number of transmit octets */
    vuint32_t TXOCTS1:1;               /* Number of transmit octets */
    vuint32_t TXOCTS0:1;               /* Number of transmit octets */
  } B;
} ENET_RMON_T_OCTETS_tag;

typedef union ENET_IEEE_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_IEEE_T_DROP_tag;

typedef union ENET_IEEE_T_FRAME_OK_union_tag { /* Frames Transmitted OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT14:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT13:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT12:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT11:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT10:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT9:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT8:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT7:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT6:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT5:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT4:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT3:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT2:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT1:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT0:1;                /* Number of frames transmitted OK */
  } B;
} ENET_IEEE_T_FRAME_OK_tag;

typedef union ENET_IEEE_T_1COL_union_tag { /* Frames Transmitted with Single Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with one collision */
  } B;
} ENET_IEEE_T_1COL_tag;

typedef union ENET_IEEE_T_MCOL_union_tag { /* Frames Transmitted with Multiple Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with multiple collisions */
  } B;
} ENET_IEEE_T_MCOL_tag;

typedef union ENET_IEEE_T_DEF_union_tag { /* Frames Transmitted after Deferral Delay Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with deferral delay */
  } B;
} ENET_IEEE_T_DEF_tag;

typedef union ENET_IEEE_T_LCOL_union_tag { /* Frames Transmitted with Late Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with late collision */
  } B;
} ENET_IEEE_T_LCOL_tag;

typedef union ENET_IEEE_T_EXCOL_union_tag { /* Frames Transmitted with Excessive Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with excessive collisions */
  } B;
} ENET_IEEE_T_EXCOL_tag;

typedef union ENET_IEEE_T_MACERR_union_tag { /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with transmit FIFO underrun */
  } B;
} ENET_IEEE_T_MACERR_tag;

typedef union ENET_IEEE_T_CSERR_union_tag { /* Frames Transmitted with Carrier Sense Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with carrier sense error */
  } B;
} ENET_IEEE_T_CSERR_tag;

typedef union ENET_IEEE_T_SQE_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;
    vuint32_t COUNT14:1;
    vuint32_t COUNT13:1;
    vuint32_t COUNT12:1;
    vuint32_t COUNT11:1;
    vuint32_t COUNT10:1;
    vuint32_t COUNT9:1;
    vuint32_t COUNT8:1;
    vuint32_t COUNT7:1;
    vuint32_t COUNT6:1;
    vuint32_t COUNT5:1;
    vuint32_t COUNT4:1;
    vuint32_t COUNT3:1;
    vuint32_t COUNT2:1;
    vuint32_t COUNT1:1;
    vuint32_t COUNT0:1;
  } B;
} ENET_IEEE_T_SQE_tag;

typedef union ENET_IEEE_T_FDXFC_union_tag { /* Flow Control Pause Frames Transmitted Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT14:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT13:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT12:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT11:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT10:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT9:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT8:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT7:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT6:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT5:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT4:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT3:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT2:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT1:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT0:1;                /* Number of flow-control pause frames transmitted */
  } B;
} ENET_IEEE_T_FDXFC_tag;

typedef union ENET_IEEE_T_OCTETS_OK_union_tag { /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT30:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT29:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT28:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT27:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT26:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT25:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT24:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT23:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT22:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT21:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT20:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT19:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT18:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT17:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT16:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT15:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT14:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT13:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT12:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT11:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT10:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT9:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT8:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT7:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT6:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT5:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT4:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT3:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT2:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT1:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT0:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
  } B;
} ENET_IEEE_T_OCTETS_OK_tag;

typedef union ENET_RMON_R_PACKETS_union_tag { /* Rx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of packets received */
    vuint32_t COUNT14:1;               /* Number of packets received */
    vuint32_t COUNT13:1;               /* Number of packets received */
    vuint32_t COUNT12:1;               /* Number of packets received */
    vuint32_t COUNT11:1;               /* Number of packets received */
    vuint32_t COUNT10:1;               /* Number of packets received */
    vuint32_t COUNT9:1;                /* Number of packets received */
    vuint32_t COUNT8:1;                /* Number of packets received */
    vuint32_t COUNT7:1;                /* Number of packets received */
    vuint32_t COUNT6:1;                /* Number of packets received */
    vuint32_t COUNT5:1;                /* Number of packets received */
    vuint32_t COUNT4:1;                /* Number of packets received */
    vuint32_t COUNT3:1;                /* Number of packets received */
    vuint32_t COUNT2:1;                /* Number of packets received */
    vuint32_t COUNT1:1;                /* Number of packets received */
    vuint32_t COUNT0:1;                /* Number of packets received */
  } B;
} ENET_RMON_R_PACKETS_tag;

typedef union ENET_RMON_R_BC_PKT_union_tag { /* Rx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT14:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT13:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT12:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT11:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT10:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT9:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT8:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT7:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT6:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT5:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT4:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT3:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT2:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT1:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT0:1;                /* Number of receive broadcast packets */
  } B;
} ENET_RMON_R_BC_PKT_tag;

typedef union ENET_RMON_R_MC_PKT_union_tag { /* Rx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive multicast packets */
    vuint32_t COUNT14:1;               /* Number of receive multicast packets */
    vuint32_t COUNT13:1;               /* Number of receive multicast packets */
    vuint32_t COUNT12:1;               /* Number of receive multicast packets */
    vuint32_t COUNT11:1;               /* Number of receive multicast packets */
    vuint32_t COUNT10:1;               /* Number of receive multicast packets */
    vuint32_t COUNT9:1;                /* Number of receive multicast packets */
    vuint32_t COUNT8:1;                /* Number of receive multicast packets */
    vuint32_t COUNT7:1;                /* Number of receive multicast packets */
    vuint32_t COUNT6:1;                /* Number of receive multicast packets */
    vuint32_t COUNT5:1;                /* Number of receive multicast packets */
    vuint32_t COUNT4:1;                /* Number of receive multicast packets */
    vuint32_t COUNT3:1;                /* Number of receive multicast packets */
    vuint32_t COUNT2:1;                /* Number of receive multicast packets */
    vuint32_t COUNT1:1;                /* Number of receive multicast packets */
    vuint32_t COUNT0:1;                /* Number of receive multicast packets */
  } B;
} ENET_RMON_R_MC_PKT_tag;

typedef union ENET_RMON_R_CRC_ALIGN_union_tag { /* Rx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT14:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT13:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT12:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT11:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT10:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT9:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT8:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT7:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT6:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT5:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT4:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT3:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT2:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT1:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT0:1;                /* Number of receive packets with CRC or align error */
  } B;
} ENET_RMON_R_CRC_ALIGN_tag;

typedef union ENET_RMON_R_UNDERSIZE_union_tag { /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets with less than 64 bytes and good CRC */
  } B;
} ENET_RMON_R_UNDERSIZE_tag;

typedef union ENET_RMON_R_OVERSIZE_union_tag { /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets greater than MAX_FL and good CRC */
  } B;
} ENET_RMON_R_OVERSIZE_tag;

typedef union ENET_RMON_R_FRAG_union_tag { /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
  } B;
} ENET_RMON_R_FRAG_tag;

typedef union ENET_RMON_R_JAB_union_tag { /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
  } B;
} ENET_RMON_R_JAB_tag;

typedef union ENET_RMON_R_RESVD_0_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_0:16;
  } B;
} ENET_RMON_R_RESVD_0_tag;

typedef union ENET_RMON_R_P64_union_tag { /* Rx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT14:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT13:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT12:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT11:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT10:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT9:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT8:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT7:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT6:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT5:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT4:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT3:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT2:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT1:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT0:1;                /* Number of 64-byte receive packets */
  } B;
} ENET_RMON_R_P64_tag;

typedef union ENET_RMON_R_P65TO127_union_tag { /* Rx 65- to 127-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 65- to 127-byte recieve packets */
  } B;
} ENET_RMON_R_P65TO127_tag;

typedef union ENET_RMON_R_P128TO255_union_tag { /* Rx 128- to 255-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 128- to 255-byte recieve packets */
  } B;
} ENET_RMON_R_P128TO255_tag;

typedef union ENET_RMON_R_P256TO511_union_tag { /* Rx 256- to 511-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 256- to 511-byte recieve packets */
  } B;
} ENET_RMON_R_P256TO511_tag;

typedef union ENET_RMON_R_P512TO1023_union_tag { /* Rx 512- to 1023-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 512- to 1023-byte recieve packets */
  } B;
} ENET_RMON_R_P512TO1023_tag;

typedef union ENET_RMON_R_P1024TO2047_union_tag { /* Rx 1024- to 2047-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 1024- to 2047-byte recieve packets */
  } B;
} ENET_RMON_R_P1024TO2047_tag;

typedef union ENET_RMON_R_P_GTE2048_union_tag { /* Rx Packets Greater than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of greater-than-2048-byte recieve packets */
  } B;
} ENET_RMON_R_P_GTE2048_tag;

typedef union ENET_RMON_R_OCTETS_union_tag { /* Rx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Number of receive octets */
    vuint32_t COUNT30:1;               /* Number of receive octets */
    vuint32_t COUNT29:1;               /* Number of receive octets */
    vuint32_t COUNT28:1;               /* Number of receive octets */
    vuint32_t COUNT27:1;               /* Number of receive octets */
    vuint32_t COUNT26:1;               /* Number of receive octets */
    vuint32_t COUNT25:1;               /* Number of receive octets */
    vuint32_t COUNT24:1;               /* Number of receive octets */
    vuint32_t COUNT23:1;               /* Number of receive octets */
    vuint32_t COUNT22:1;               /* Number of receive octets */
    vuint32_t COUNT21:1;               /* Number of receive octets */
    vuint32_t COUNT20:1;               /* Number of receive octets */
    vuint32_t COUNT19:1;               /* Number of receive octets */
    vuint32_t COUNT18:1;               /* Number of receive octets */
    vuint32_t COUNT17:1;               /* Number of receive octets */
    vuint32_t COUNT16:1;               /* Number of receive octets */
    vuint32_t COUNT15:1;               /* Number of receive octets */
    vuint32_t COUNT14:1;               /* Number of receive octets */
    vuint32_t COUNT13:1;               /* Number of receive octets */
    vuint32_t COUNT12:1;               /* Number of receive octets */
    vuint32_t COUNT11:1;               /* Number of receive octets */
    vuint32_t COUNT10:1;               /* Number of receive octets */
    vuint32_t COUNT9:1;                /* Number of receive octets */
    vuint32_t COUNT8:1;                /* Number of receive octets */
    vuint32_t COUNT7:1;                /* Number of receive octets */
    vuint32_t COUNT6:1;                /* Number of receive octets */
    vuint32_t COUNT5:1;                /* Number of receive octets */
    vuint32_t COUNT4:1;                /* Number of receive octets */
    vuint32_t COUNT3:1;                /* Number of receive octets */
    vuint32_t COUNT2:1;                /* Number of receive octets */
    vuint32_t COUNT1:1;                /* Number of receive octets */
    vuint32_t COUNT0:1;                /* Number of receive octets */
  } B;
} ENET_RMON_R_OCTETS_tag;

typedef union ENET_IEEE_R_DROP_union_tag { /* Frames not Counted Correctly Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Frame count */
    vuint32_t COUNT14:1;               /* Frame count */
    vuint32_t COUNT13:1;               /* Frame count */
    vuint32_t COUNT12:1;               /* Frame count */
    vuint32_t COUNT11:1;               /* Frame count */
    vuint32_t COUNT10:1;               /* Frame count */
    vuint32_t COUNT9:1;                /* Frame count */
    vuint32_t COUNT8:1;                /* Frame count */
    vuint32_t COUNT7:1;                /* Frame count */
    vuint32_t COUNT6:1;                /* Frame count */
    vuint32_t COUNT5:1;                /* Frame count */
    vuint32_t COUNT4:1;                /* Frame count */
    vuint32_t COUNT3:1;                /* Frame count */
    vuint32_t COUNT2:1;                /* Frame count */
    vuint32_t COUNT1:1;                /* Frame count */
    vuint32_t COUNT0:1;                /* Frame count */
  } B;
} ENET_IEEE_R_DROP_tag;

typedef union ENET_IEEE_R_FRAME_OK_union_tag { /* Frames Received OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received OK */
    vuint32_t COUNT14:1;               /* Number of frames received OK */
    vuint32_t COUNT13:1;               /* Number of frames received OK */
    vuint32_t COUNT12:1;               /* Number of frames received OK */
    vuint32_t COUNT11:1;               /* Number of frames received OK */
    vuint32_t COUNT10:1;               /* Number of frames received OK */
    vuint32_t COUNT9:1;                /* Number of frames received OK */
    vuint32_t COUNT8:1;                /* Number of frames received OK */
    vuint32_t COUNT7:1;                /* Number of frames received OK */
    vuint32_t COUNT6:1;                /* Number of frames received OK */
    vuint32_t COUNT5:1;                /* Number of frames received OK */
    vuint32_t COUNT4:1;                /* Number of frames received OK */
    vuint32_t COUNT3:1;                /* Number of frames received OK */
    vuint32_t COUNT2:1;                /* Number of frames received OK */
    vuint32_t COUNT1:1;                /* Number of frames received OK */
    vuint32_t COUNT0:1;                /* Number of frames received OK */
  } B;
} ENET_IEEE_R_FRAME_OK_tag;

typedef union ENET_IEEE_R_CRC_union_tag { /* Frames Received with CRC Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT14:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT13:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT12:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT11:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT10:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT9:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT8:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT7:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT6:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT5:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT4:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT3:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT2:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT1:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT0:1;                /* Number of frames received with CRC error */
  } B;
} ENET_IEEE_R_CRC_tag;

typedef union ENET_IEEE_R_ALIGN_union_tag { /* Frames Received with Alignment Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT14:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT13:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT12:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT11:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT10:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT9:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT8:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT7:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT6:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT5:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT4:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT3:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT2:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT1:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT0:1;                /* Number of frames received with alignment error */
  } B;
} ENET_IEEE_R_ALIGN_tag;

typedef union ENET_IEEE_R_MACERR_union_tag { /* Receive FIFO Overflow Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT14:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT13:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT12:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT11:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT10:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT9:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT8:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT7:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT6:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT5:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT4:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT3:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT2:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT1:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT0:1;                /* Receive FIFO overflow count */
  } B;
} ENET_IEEE_R_MACERR_tag;

typedef union ENET_IEEE_R_FDXFC_union_tag { /* Flow Control Pause Frames Received Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT14:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT13:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT12:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT11:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT10:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT9:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT8:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT7:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT6:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT5:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT4:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT3:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT2:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT1:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT0:1;                /* Number of flow-control pause frames received */
  } B;
} ENET_IEEE_R_FDXFC_tag;

typedef union ENET_IEEE_R_OCTETS_OK_union_tag { /* Octet Count for Frames Received without Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT30:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT29:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT28:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT27:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT26:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT25:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT24:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT23:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT22:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT21:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT20:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT19:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT18:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT17:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT16:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT15:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT14:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT13:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT12:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT11:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT10:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT9:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT8:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT7:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT6:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT5:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT4:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT3:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT2:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT1:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT0:1;                /* Number of octets for frames received without error */
  } B;
} ENET_IEEE_R_OCTETS_OK_tag;

typedef union ENET_ATCR_union_tag {    /* Adjustable Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t SLAVE:1;                 /* Enable Timer Slave Mode */
    vuint32_t _unused_12:1;
    vuint32_t CAPTURE:1;               /* Capture Timer Value */
    vuint32_t _unused_10:1;
    vuint32_t RESTART:1;               /* Reset Timer */
    vuint32_t _unused_8:1;
    vuint32_t PINPER:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t PEREN:1;                 /* Enable Periodical Event */
    vuint32_t OFFRST:1;                /* Reset Timer On Offset Event */
    vuint32_t OFFEN:1;                 /* Enable One-Shot Offset Event */
    vuint32_t _unused_1:1;
    vuint32_t EN:1;                    /* Enable Timer */
  } B;
} ENET_ATCR_tag;

typedef union ENET_ATVR_union_tag {    /* Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t ATIME:32;
  } B;
} ENET_ATVR_tag;

typedef union ENET_ATOFF_union_tag {   /* Timer Offset Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:32;
  } B;
} ENET_ATOFF_tag;

typedef union ENET_ATPER_union_tag {   /* Timer Period Register */
  vuint32_t R;
  struct {
    vuint32_t PERIOD:32;
  } B;
} ENET_ATPER_tag;

typedef union ENET_ATCOR_union_tag {   /* Timer Correction Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t COR:31;                  /* Correction Counter Wrap-Around Value */
  } B;
} ENET_ATCOR_tag;

typedef union ENET_ATINC_union_tag {   /* Time-Stamping Clock Period Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t INC_CORR:7;              /* Correction Increment Value */
    vuint32_t _unused_7:1;
    vuint32_t INC:7;                   /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
  } B;
} ENET_ATINC_tag;

typedef union ENET_ATSTMP_union_tag {  /* Timestamp of Last Transmitted Frame */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:32;
  } B;
} ENET_ATSTMP_tag;

typedef union ENET_MDATA_union_tag {   /* Pattern Match Data Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHDATA:32;            /* Match Data */
  } B;
} ENET_MDATA_tag;

typedef union ENET_MMASK_union_tag {   /* Match Entry Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MATCHMASK:32;            /* Match Mask */
  } B;
} ENET_MMASK_tag;

typedef union ENET_MCONFIG_union_tag { /* Match Entry Rules Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t AF:1;                    /* Accept Frame */
    vuint32_t RF:1;                    /* Reject Frame */
    vuint32_t IM:1;                    /* Invert Match */
    vuint32_t _unused_24:5;
    vuint32_t OK_INDEX:8;
    vuint32_t _unused_8:8;
    vuint32_t FRMOFF:6;                /* Frame Offset */
    vuint32_t _unused_0:2;
  } B;
} ENET_MCONFIG_tag;

typedef union ENET_MENTRYRW_union_tag { /* Match Entry Read/Write Command Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t RD:1;                    /* Entry Read Command */
    vuint32_t WR:1;                    /* Entry write command */
    vuint32_t ENTRYADD:8;              /* Entry Address */
  } B;
} ENET_MENTRYRW_tag;

typedef union ENET_RXPCTL_union_tag {  /* Receive Parser Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t ACPTEERR:1;              /* Accept End Error */
    vuint32_t ENDERRQ:8;               /* End Error Queue */
    vuint32_t MAXINDEX:8;              /* Maximum Index */
    vuint32_t _unused_5:3;
    vuint32_t PRSRSCLR:1;              /* Clear Parser Statistics Counter */
    vuint32_t _unused_2:2;
    vuint32_t INVBYTORD:1;             /* Inverse Frame Byte Order */
    vuint32_t ENPARSER:1;              /* Enable Receive Parser */
  } B;
} ENET_RXPCTL_tag;

typedef union ENET_MAXFRMOFF_union_tag { /* Maximum Frame Offset */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t MXFRMOFF:6;              /* Max. Frame Offset */
  } B;
} ENET_MAXFRMOFF_tag;

typedef union ENET_RXPARST_union_tag { /* Receive Parser Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t RXPRSDN:1;               /* Receive Parser Done */
    vuint32_t _unused_6:2;
    vuint32_t INVMAXIDX:1;             /* Invalid Value of MAXINDEX */
    vuint32_t PRSENDERR:1;             /* Parser End Error */
    vuint32_t FMOFFERR:1;              /* Maximum Frame Offset Error */
    vuint32_t NOMTCERR:1;              /* No Match Error */
    vuint32_t TBLDPTERR:1;             /* Table Depth Error */
    vuint32_t MXINDERR:1;              /* Maximum Index Error */
  } B;
} ENET_RXPARST_tag;

typedef union ENET_PARSDSCD_union_tag { /* Parser Discard Count */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PARSDSCD_tag;

typedef union ENET_PRSACPT0_union_tag { /* Parser Accept Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT0_tag;

typedef union ENET_PRSRJCT0_union_tag { /* Parser Reject Count 0 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT0_tag;

typedef union ENET_PRSACPT1_union_tag { /* Parser Accept Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT1_tag;

typedef union ENET_PRSRJCT1_union_tag { /* Parser Reject Count 1 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT1_tag;

typedef union ENET_PRSACPT2_union_tag { /* Parser Accept Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSACPT2_tag;

typedef union ENET_PRSRJCT2_union_tag { /* Parser Reject Count 2 */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Count */
  } B;
} ENET_PRSRJCT2_tag;

typedef union ENET_TGSR_union_tag {    /* Timer Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t TF3:1;                   /* Copy Of Timer Flag For Channel 3 */
    vuint32_t TF2:1;                   /* Copy Of Timer Flag For Channel 2 */
    vuint32_t TF1:1;                   /* Copy Of Timer Flag For Channel 1 */
    vuint32_t TF0:1;                   /* Copy Of Timer Flag For Channel 0 */
  } B;
} ENET_TGSR_tag;

typedef union ENET_TIMER_TCSR_union_tag { /* Timer Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TF:1;                    /* Timer Flag */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TMODE:4;                 /* Timer Mode */
    vuint32_t _unused_1:1;
    vuint32_t TDRE:1;                  /* Timer DMA Request Enable */
  } B;
} ENET_TIMER_TCSR_tag;

typedef union ENET_TIMER_TCCR_union_tag { /* Timer Compare Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TCC:32;                  /* Timer Capture Compare */
  } B;
} ENET_TIMER_TCCR_tag;

typedef struct ENET_TIMER_struct_tag {
  ENET_TIMER_TCSR_tag TCSR;            /* Timer Control Status Register */
  ENET_TIMER_TCCR_tag TCCR;            /* Timer Compare Capture Register */
} ENET_TIMER_tag;

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  ENET_EIR_tag EIR;                    /* Interrupt Event Register */
  ENET_EIMR_tag EIMR;                  /* Interrupt Mask Register */
  uint8_t ENET_reserved1[4];
  ENET_RDAR_tag RDAR;                  /* Receive Descriptor Active Register - Ring 0 */
  ENET_TDAR_tag TDAR;                  /* Transmit Descriptor Active Register - Ring 0 */
  uint8_t ENET_reserved2[12];
  ENET_ECR_tag ECR;                    /* Ethernet Control Register */
  uint8_t ENET_reserved3[24];
  ENET_MMFR_tag MMFR;                  /* MII Management Frame Register */
  ENET_MSCR_tag MSCR;                  /* MII Speed Control Register */
  uint8_t ENET_reserved4[28];
  ENET_MIBC_tag MIBC;                  /* MIB Control Register */
  uint8_t ENET_reserved5[28];
  ENET_RCR_tag RCR;                    /* Receive Control Register */
  uint8_t ENET_reserved6[60];
  ENET_TCR_tag TCR;                    /* Transmit Control Register */
  uint8_t ENET_reserved7[28];
  ENET_PALR_tag PALR;                  /* Physical Address Lower Register */
  ENET_PAUR_tag PAUR;                  /* Physical Address Upper Register */
  ENET_OPD_tag OPD;                    /* Opcode/Pause Duration Register */
  ENET_TXIC_tag TXIC[3];               /* Transmit Interrupt Coalescing Register */
  uint8_t ENET_reserved8[4];
  ENET_RXIC_tag RXIC[3];               /* Receive Interrupt Coalescing Register */
  uint8_t ENET_reserved9[12];
  ENET_IAUR_tag IAUR;                  /* Descriptor Individual Upper Address Register */
  ENET_IALR_tag IALR;                  /* Descriptor Individual Lower Address Register */
  ENET_GAUR_tag GAUR;                  /* Descriptor Group Upper Address Register */
  ENET_GALR_tag GALR;                  /* Descriptor Group Lower Address Register */
  uint8_t ENET_reserved10[28];
  ENET_TFWR_tag TFWR;                  /* Transmit FIFO Watermark Register */
  uint8_t ENET_reserved11[24];
  ENET_RDSR1_tag RDSR1;                /* Receive Descriptor Ring 1 Start Register */
  ENET_TDSR1_tag TDSR1;                /* Transmit Buffer Descriptor Ring 1 Start Register */
  ENET_MRBR1_tag MRBR1;                /* Maximum Receive Buffer Size Register - Ring 1 */
  ENET_RDSR2_tag RDSR2;                /* Receive Descriptor Ring 2 Start Register */
  ENET_TDSR2_tag TDSR2;                /* Transmit Buffer Descriptor Ring 2 Start Register */
  ENET_MRBR2_tag MRBR2;                /* Maximum Receive Buffer Size Register - Ring 2 */
  uint8_t ENET_reserved12[8];
  ENET_RDSR_tag RDSR;                  /* Receive Descriptor Ring 0 Start Register */
  ENET_TDSR_tag TDSR;                  /* Transmit Buffer Descriptor Ring 0 Start Register */
  ENET_MRBR_tag MRBR;                  /* Maximum Receive Buffer Size Register - Ring 0 */
  uint8_t ENET_reserved13[4];
  ENET_RSFL_tag RSFL;                  /* Receive FIFO Section Full Threshold */
  ENET_RSEM_tag RSEM;                  /* Receive FIFO Section Empty Threshold */
  ENET_RAEM_tag RAEM;                  /* Receive FIFO Almost Empty Threshold */
  ENET_RAFL_tag RAFL;                  /* Receive FIFO Almost Full Threshold */
  ENET_TSEM_tag TSEM;                  /* Transmit FIFO Section Empty Threshold */
  ENET_TAEM_tag TAEM;                  /* Transmit FIFO Almost Empty Threshold */
  ENET_TAFL_tag TAFL;                  /* Transmit FIFO Almost Full Threshold */
  ENET_TIPG_tag TIPG;                  /* Transmit Inter-Packet Gap */
  ENET_FTRL_tag FTRL;                  /* Frame Truncation Length */
  uint8_t ENET_reserved14[12];
  ENET_TACC_tag TACC;                  /* Transmit Accelerator Function Configuration */
  ENET_RACC_tag RACC;                  /* Receive Accelerator Function Configuration */
  ENET_RCMR_tag RCMR[2];               /* Receive Classification Match Register for Class n */
  uint8_t ENET_reserved15[8];
  ENET_DMACFG_tag DMACFG[2];           /* DMA Class Based Configuration */
  ENET_RDAR1_tag RDAR1;                /* Receive Descriptor Active Register - Ring 1 */
  ENET_TDAR1_tag TDAR1;                /* Transmit Descriptor Active Register - Ring 1 */
  ENET_RDAR2_tag RDAR2;                /* Receive Descriptor Active Register - Ring 2 */
  ENET_TDAR2_tag TDAR2;                /* Transmit Descriptor Active Register - Ring 2 */
  ENET_QOS_tag QOS;                    /* QOS Scheme */
  uint8_t ENET_reserved16[12];
  ENET_RMON_T_DROP_tag RMON_T_DROP;    /* Reserved Statistic Register */
  ENET_RMON_T_PACKETS_tag RMON_T_PACKETS; /* Tx Packet Count Statistic Register */
  ENET_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* Tx Broadcast Packets Statistic Register */
  ENET_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* Tx Multicast Packets Statistic Register */
  ENET_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* Tx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  ENET_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  ENET_RMON_T_FRAG_tag RMON_T_FRAG;    /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_T_JAB_tag RMON_T_JAB;      /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  ENET_RMON_T_COL_tag RMON_T_COL;      /* Tx Collision Count Statistic Register */
  ENET_RMON_T_P64_tag RMON_T_P64;      /* Tx 64-Byte Packets Statistic Register */
  ENET_RMON_T_P65TO127_tag RMON_T_P65TO127; /* Tx 65- to 127-byte Packets Statistic Register */
  ENET_RMON_T_P128TO255_tag RMON_T_P128TO255; /* Tx 128- to 255-byte Packets Statistic Register */
  ENET_RMON_T_P256TO511_tag RMON_T_P256TO511; /* Tx 256- to 511-byte Packets Statistic Register */
  ENET_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* Tx 512- to 1023-byte Packets Statistic Register */
  ENET_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* Tx 1024- to 2047-byte Packets Statistic Register */
  ENET_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  ENET_RMON_T_OCTETS_tag RMON_T_OCTETS; /* Tx Octets Statistic Register */
  ENET_IEEE_T_DROP_tag IEEE_T_DROP;    /* Reserved Statistic Register */
  ENET_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames Transmitted OK Statistic Register */
  ENET_IEEE_T_1COL_tag IEEE_T_1COL;    /* Frames Transmitted with Single Collision Statistic Register */
  ENET_IEEE_T_MCOL_tag IEEE_T_MCOL;    /* Frames Transmitted with Multiple Collisions Statistic Register */
  ENET_IEEE_T_DEF_tag IEEE_T_DEF;      /* Frames Transmitted after Deferral Delay Statistic Register */
  ENET_IEEE_T_LCOL_tag IEEE_T_LCOL;    /* Frames Transmitted with Late Collision Statistic Register */
  ENET_IEEE_T_EXCOL_tag IEEE_T_EXCOL;  /* Frames Transmitted with Excessive Collisions Statistic Register */
  ENET_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  ENET_IEEE_T_CSERR_tag IEEE_T_CSERR;  /* Frames Transmitted with Carrier Sense Error Statistic Register */
  ENET_IEEE_T_SQE_tag IEEE_T_SQE;      /* Reserved Statistic Register */
  ENET_IEEE_T_FDXFC_tag IEEE_T_FDXFC;  /* Flow Control Pause Frames Transmitted Statistic Register */
  ENET_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  uint8_t ENET_reserved17[12];
  ENET_RMON_R_PACKETS_tag RMON_R_PACKETS; /* Rx Packet Count Statistic Register */
  ENET_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* Rx Broadcast Packets Statistic Register */
  ENET_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* Rx Multicast Packets Statistic Register */
  ENET_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* Rx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  ENET_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  ENET_RMON_R_FRAG_tag RMON_R_FRAG;    /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_JAB_tag RMON_R_JAB;      /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved Statistic Register */
  ENET_RMON_R_P64_tag RMON_R_P64;      /* Rx 64-Byte Packets Statistic Register */
  ENET_RMON_R_P65TO127_tag RMON_R_P65TO127; /* Rx 65- to 127-Byte Packets Statistic Register */
  ENET_RMON_R_P128TO255_tag RMON_R_P128TO255; /* Rx 128- to 255-Byte Packets Statistic Register */
  ENET_RMON_R_P256TO511_tag RMON_R_P256TO511; /* Rx 256- to 511-Byte Packets Statistic Register */
  ENET_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* Rx 512- to 1023-Byte Packets Statistic Register */
  ENET_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* Rx 1024- to 2047-Byte Packets Statistic Register */
  ENET_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* Rx Packets Greater than 2048 Bytes Statistic Register */
  ENET_RMON_R_OCTETS_tag RMON_R_OCTETS; /* Rx Octets Statistic Register */
  ENET_IEEE_R_DROP_tag IEEE_R_DROP;    /* Frames not Counted Correctly Statistic Register */
  ENET_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames Received OK Statistic Register */
  ENET_IEEE_R_CRC_tag IEEE_R_CRC;      /* Frames Received with CRC Error Statistic Register */
  ENET_IEEE_R_ALIGN_tag IEEE_R_ALIGN;  /* Frames Received with Alignment Error Statistic Register */
  ENET_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO Overflow Count Statistic Register */
  ENET_IEEE_R_FDXFC_tag IEEE_R_FDXFC;  /* Flow Control Pause Frames Received Statistic Register */
  ENET_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet Count for Frames Received without Error Statistic Register */
  uint8_t ENET_reserved18[284];
  ENET_ATCR_tag ATCR;                  /* Adjustable Timer Control Register */
  ENET_ATVR_tag ATVR;                  /* Timer Value Register */
  ENET_ATOFF_tag ATOFF;                /* Timer Offset Register */
  ENET_ATPER_tag ATPER;                /* Timer Period Register */
  ENET_ATCOR_tag ATCOR;                /* Timer Correction Register */
  ENET_ATINC_tag ATINC;                /* Time-Stamping Clock Period Register */
  ENET_ATSTMP_tag ATSTMP;              /* Timestamp of Last Transmitted Frame */
  uint8_t ENET_reserved19[356];
  ENET_MDATA_tag MDATA;                /* Pattern Match Data Register */
  ENET_MMASK_tag MMASK;                /* Match Entry Mask Register */
  ENET_MCONFIG_tag MCONFIG;            /* Match Entry Rules Configuration Register */
  ENET_MENTRYRW_tag MENTRYRW;          /* Match Entry Read/Write Command Register */
  ENET_RXPCTL_tag RXPCTL;              /* Receive Parser Control Register */
  ENET_MAXFRMOFF_tag MAXFRMOFF;        /* Maximum Frame Offset */
  ENET_RXPARST_tag RXPARST;            /* Receive Parser Status */
  uint8_t ENET_reserved20[4];
  ENET_PARSDSCD_tag PARSDSCD;          /* Parser Discard Count */
  ENET_PRSACPT0_tag PRSACPT0;          /* Parser Accept Count 0 */
  ENET_PRSRJCT0_tag PRSRJCT0;          /* Parser Reject Count 0 */
  ENET_PRSACPT1_tag PRSACPT1;          /* Parser Accept Count 1 */
  ENET_PRSRJCT1_tag PRSRJCT1;          /* Parser Reject Count 1 */
  ENET_PRSACPT2_tag PRSACPT2;          /* Parser Accept Count 2 */
  ENET_PRSRJCT2_tag PRSRJCT2;          /* Parser Reject Count 2 */
  uint8_t ENET_reserved21[72];
  ENET_TGSR_tag TGSR;                  /* Timer Global Status Register */
  ENET_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t FILTER_BYPASS:1;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t _unused_10:19;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_8:1;
    vuint32_t OPS:2;
    vuint32_t _unused_5:1;
    vuint32_t OPR:5;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t TGL:7;                   /* EOUT Toggling Time */
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t _unused_20:2;
    vuint32_t _unused_16:4;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t FOME:2;                  /* Fault Output Mode Extension */
    vuint32_t OD:1;
    vuint32_t _unused_11:1;
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC31:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC0:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC31:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC0:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS31:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS0:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE31:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE0:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE31:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE0:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timeout */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TO:3;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t EIN1:1;
    vuint32_t EIN0:1;
    vuint32_t _unused_2:2;
    vuint32_t EOUTX:2;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t PhysicErrorPin:2;
    vuint32_t ESTAT:1;
    vuint32_t STATUS:3;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t DMA_REQ:1;
    vuint32_t IRQ_EOUT:1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IRQ_EOUT_EN:1;
    vuint32_t _unused_1:2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;
    vuint32_t _unused_28:2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;
    vuint32_t _unused_20:2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;
    vuint32_t _unused_12:2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;
    vuint32_t _unused_4:2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t TRANSKEY:9;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t PERMNTKEY:9;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t T_TRG:14;                /* IRQ DMA trigger time */
    vuint32_t _unused_14:2;
    vuint32_t DELTA_T:14;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Fault-Output (EOUT) Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN30:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN29:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN28:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN27:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN26:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN25:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN24:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN23:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN22:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN21:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN20:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN19:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN18:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN17:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN16:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN15:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN14:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN13:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN12:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN11:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN10:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN9:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN8:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN7:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN6:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN5:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN4:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN3:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN2:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN1:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN0:1;               /* Fault-Output (EOUT) Signaling Enable */
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[3];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[36];
  FCCU_NCFS_CFG_tag NCFS_CFG[5];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[32];
  FCCU_NCF_S_tag NCF_S[3];             /* Noncritical Fault Status */
  uint8_t FCCU_reserved3[4];
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[3];             /* Noncritical Fault Enable */
  uint8_t FCCU_reserved4[4];
  FCCU_NCF_TOE_tag NCF_TOE[3];         /* Noncritical Fault Timeout Enable */
  uint8_t FCCU_reserved5[4];
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timeout */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved6[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[3]; /* IRQ Alarm Enable */
  uint8_t FCCU_reserved7[4];
  FCCU_NMI_EN_tag NMI_EN[3];           /* NMI Enable */
  uint8_t FCCU_reserved8[4];
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[3]; /* Fault-Output (EOUT) Signaling Enable */
};


/* ============================================================================
   =============================== Module: FIRC ===============================
   ============================================================================ */

typedef union FIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t _unused_16:6;
    vuint32_t _unused_13:3;
    vuint32_t FIRCDIV:5;               /* The FIRC Divider bits select the clock divider factor. */
    vuint32_t _unused_5:3;
    vuint32_t FIRCS:1;                 /* Describes the FIRC clock status. */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} FIRC_CTL_tag;

struct FIRC_tag {
  FIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

typedef union FR_MVR_union_tag {       /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t CHIVER:8;
    vuint16_t PEVER:8;
  } B;
} FR_MVR_tag;

typedef union FR_MCR_union_tag {       /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MEN:1;
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t SCM:1;
    vuint16_t CHB:1;
    vuint16_t CHA:1;
    vuint16_t SFFE:1;
    vuint16_t ECCE:1;
    vuint16_t _unused_8:1;             /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t FUM:1;
    vuint16_t FAM:1;
    vuint16_t _unused_5:1;
    vuint16_t CLKSEL:1;
    vuint16_t BITRATE:3;
    vuint16_t _unused_0:1;
  } B;
} FR_MCR_tag;

typedef union FR_SYMBADHR_union_tag {  /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
  } B;
} FR_SYMBADHR_tag;

typedef union FR_SYMBADLR_union_tag {  /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_SYMBADLR_tag;

typedef union FR_STBSCR_union_tag {    /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_12:3;
    vuint16_t SEL:4;
    vuint16_t _unused_5:3;
    vuint16_t ENB:1;
    vuint16_t _unused_2:2;
    vuint16_t STBPSEL:2;
  } B;
} FR_STBSCR_tag;

typedef union FR_MBDSR_union_tag {     /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t MBSEG2DS:7;
    vuint16_t _unused_7:1;
    vuint16_t MBSEG1DS:7;
  } B;
} FR_MBDSR_tag;

typedef union FR_MBSSUTR_union_tag {   /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t LAST_MB_SEG1:7;
    vuint16_t _unused_7:1;
    vuint16_t LAST_MB_UTIL:7;
  } B;
} FR_MBSSUTR_tag;

typedef union FR_PEDRAR_union_tag {    /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t INST:4;
    vuint16_t ADDR:11;
    vuint16_t DAD:1;
  } B;
} FR_PEDRAR_tag;

typedef union FR_PEDRDR_union_tag {    /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_PEDRDR_tag;

typedef union FR_POCR_union_tag {      /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t WME:1;
    vuint16_t _unused_12:3;
    vuint16_t EOC_AP:2;
    vuint16_t ERC_AP:2;
    vuint16_t BSY_WMC:1;
    vuint16_t _unused_4:3;
    vuint16_t POCCMD:4;
  } B;
} FR_POCR_tag;

typedef union FR_GIFER_union_tag {     /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
    vuint16_t MIE:1;
    vuint16_t PRIE:1;
    vuint16_t CHIE:1;
    vuint16_t WUPIE:1;
    vuint16_t FAFBIE:1;
    vuint16_t FAFAIE:1;
    vuint16_t RBIE:1;
    vuint16_t TBIE:1;
  } B;
} FR_GIFER_tag;

typedef union FR_PIFR0_union_tag {     /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IF:1;
    vuint16_t INTL_IF:1;
    vuint16_t ILCF_IF:1;
    vuint16_t CSA_IF:1;
    vuint16_t MRC_IF:1;
    vuint16_t MOC_IF:1;
    vuint16_t CCL_IF:1;
    vuint16_t MXS_IF:1;
    vuint16_t MTX_IF:1;
    vuint16_t LTXB_IF:1;
    vuint16_t LTXA_IF:1;
    vuint16_t TBVB_IF:1;
    vuint16_t TBVA_IF:1;
    vuint16_t TI2_IF:1;
    vuint16_t TI1_IF:1;
    vuint16_t CYS_IF:1;
  } B;
} FR_PIFR0_tag;

typedef union FR_PIFR1_union_tag {     /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IF:1;
    vuint16_t IPC_IF:1;
    vuint16_t PECF_IF:1;
    vuint16_t PSC_IF:1;
    vuint16_t SSI3_IF:1;
    vuint16_t SSI2_IF:1;
    vuint16_t SSI1_IF:1;
    vuint16_t SSI0_IF:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IF:1;
    vuint16_t ODT_IF:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIFR1_tag;

typedef union FR_PIER0_union_tag {     /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IE:1;
    vuint16_t INTL_IE:1;
    vuint16_t ILCF_IE:1;
    vuint16_t CSA_IE:1;
    vuint16_t MRC_IE:1;
    vuint16_t MOC_IE:1;
    vuint16_t CCL_IE:1;
    vuint16_t MXS_IE:1;
    vuint16_t MTX_IE:1;
    vuint16_t LTXB_IE:1;
    vuint16_t LTXA_IE:1;
    vuint16_t TBVB_IE:1;
    vuint16_t TBVA_IE:1;
    vuint16_t TI2_IE:1;
    vuint16_t TI1_IE:1;
    vuint16_t CYS_IE:1;
  } B;
} FR_PIER0_tag;

typedef union FR_PIER1_union_tag {     /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IE:1;
    vuint16_t IPC_IE:1;
    vuint16_t PECF_IE:1;
    vuint16_t PSC_IE:1;
    vuint16_t SSI3_IE:1;
    vuint16_t SSI2_IE:1;
    vuint16_t SSI1_IE:1;
    vuint16_t SSI0_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IE:1;
    vuint16_t ODT_IE:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIER1_tag;

typedef union FR_CHIERFR_union_tag {   /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t FRLB_EF:1;
    vuint16_t FRLA_EF:1;
    vuint16_t PCMI_EF:1;
    vuint16_t FOVB_EF:1;
    vuint16_t FOVA_EF:1;
    vuint16_t MBS_EF:1;
    vuint16_t MBU_EF:1;
    vuint16_t LCK_EF:1;
    vuint16_t _unused_7:1;
    vuint16_t SBCF_EF:1;
    vuint16_t FID_EF:1;
    vuint16_t DPL_EF:1;
    vuint16_t SPL_EF:1;
    vuint16_t NML_EF:1;
    vuint16_t NMF_EF:1;
    vuint16_t ILSA_EF:1;
  } B;
} FR_CHIERFR_tag;

typedef union FR_MBIVEC_union_tag {    /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t TBIVEC:7;
    vuint16_t _unused_7:1;
    vuint16_t RBIVEC:7;
  } B;
} FR_MBIVEC_tag;

typedef union FR_CASERCR_union_tag {   /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;
  } B;
} FR_CASERCR_tag;

typedef union FR_CBSERCR_union_tag {   /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;
  } B;
} FR_CBSERCR_tag;

typedef union FR_PSR0_union_tag {      /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t ERRMODE:2;
    vuint16_t SLOTMODE:2;
    vuint16_t _unused_11:1;
    vuint16_t PROTSTATE:3;
    vuint16_t STARTUPSTATE:4;
    vuint16_t _unused_3:1;
    vuint16_t WAKEUPSTATUS:3;
  } B;
} FR_PSR0_tag;

typedef union FR_PSR1_union_tag {      /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CSAA:1;
    vuint16_t CSP:1;
    vuint16_t _unused_13:1;
    vuint16_t REMCSAT:5;
    vuint16_t CPN:1;
    vuint16_t HHR:1;
    vuint16_t FRZ:1;
    vuint16_t APTAC:5;
  } B;
} FR_PSR1_tag;

typedef union FR_PSR2_union_tag {      /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t NBVB:1;
    vuint16_t NSEB:1;
    vuint16_t STCB:1;
    vuint16_t SBVB:1;
    vuint16_t SSEB:1;
    vuint16_t MTB:1;
    vuint16_t NBVA:1;
    vuint16_t NSEA:1;
    vuint16_t STCA:1;
    vuint16_t SBVA:1;
    vuint16_t SSEA:1;
    vuint16_t MTA:1;
    vuint16_t CKCORFCNT:4;
  } B;
} FR_PSR2_tag;

typedef union FR_PSR3_union_tag {      /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t WUB:1;
    vuint16_t ABVB:1;
    vuint16_t AACB:1;
    vuint16_t ACEB:1;
    vuint16_t ASEB:1;
    vuint16_t AVFB:1;
    vuint16_t _unused_6:2;
    vuint16_t WUA:1;
    vuint16_t ABVA:1;
    vuint16_t AACA:1;
    vuint16_t ACEA:1;
    vuint16_t ASEA:1;
    vuint16_t AVFA:1;
  } B;
} FR_PSR3_tag;

typedef union FR_MTCTR_union_tag {     /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t MTCT:14;
  } B;
} FR_MTCTR_tag;

typedef union FR_CYCTR_union_tag {     /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_6:10;
    vuint16_t CYCCNT:6;
  } B;
} FR_CYCTR_tag;

typedef union FR_SLTCTAR_union_tag {   /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTA:11;
  } B;
} FR_SLTCTAR_tag;

typedef union FR_SLTCTBR_union_tag {   /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTB:11;
  } B;
} FR_SLTCTBR_tag;

typedef union FR_RTCORVR_union_tag {   /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;
  } B;
} FR_RTCORVR_tag;

typedef union FR_OFCORVR_union_tag {   /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;
  } B;
} FR_OFCORVR_tag;

typedef union FR_CIFR_union_tag {      /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
  } B;
} FR_CIFR_tag;

typedef union FR_SYMATOR_union_tag {   /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t TIMEOUT:8;
  } B;
} FR_SYMATOR_tag;

typedef union FR_SFCNTR_union_tag {    /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFEVB:4;
    vuint16_t SFEVA:4;
    vuint16_t SFODB:4;
    vuint16_t SFODA:4;
  } B;
} FR_SFCNTR_tag;

typedef union FR_SFTOR_union_tag {     /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SFT_OFFSET:15;
    vuint16_t _unused_0:1;
  } B;
} FR_SFTOR_tag;

typedef union FR_SFTCCSR_union_tag {   /* Sync Frame Table Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t ELKT:1;
    vuint16_t OLKT:1;
    vuint16_t CYCNUM:6;
    vuint16_t ELKS:1;
    vuint16_t OLKS:1;
    vuint16_t EVAL:1;
    vuint16_t OVAL:1;
    vuint16_t _unused_3:1;
    vuint16_t OPT:1;
    vuint16_t SDVEN:1;
    vuint16_t SIDEN:1;
  } B;
} FR_SFTCCSR_tag;

typedef union FR_SFIDRFR_union_tag {   /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SYNFRID:10;
  } B;
} FR_SFIDRFR_tag;

typedef union FR_SFIDAFVR_union_tag {  /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FVAL:10;
  } B;
} FR_SFIDAFVR_tag;

typedef union FR_SFIDAFMR_union_tag {  /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FMSK:10;
  } B;
} FR_SFIDAFMR_tag;

typedef union FR_NMVR_union_tag {      /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;
  } B;
} FR_NMVR_tag;

typedef union FR_NMVLR_union_tag {     /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t NMVL:4;
  } B;
} FR_NMVLR_tag;

typedef union FR_TICCR_union_tag {     /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2_CFG:1;
    vuint16_t T2_REP:1;
    vuint16_t _unused_11:1;
    vuint16_t T2SP:1;
    vuint16_t T2TR:1;
    vuint16_t T2ST:1;
    vuint16_t _unused_5:3;
    vuint16_t T1_REP:1;
    vuint16_t _unused_3:1;
    vuint16_t T1SP:1;
    vuint16_t T1TR:1;
    vuint16_t T1ST:1;
  } B;
} FR_TICCR_tag;

typedef union FR_TI1CYSR_union_tag {   /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_CYC_VAL:6;
    vuint16_t _unused_6:2;
    vuint16_t T1_CYC_MSK:6;
  } B;
} FR_TI1CYSR_tag;

typedef union FR_TI1MTOR_union_tag {   /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_MTOFFSET:14;
  } B;
} FR_TI1MTOR_tag;

typedef union FR_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_6:2;
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
  } B;
} FR_TI2CR0_ABS_tag;

typedef union FR_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FR_TI2CR0_REL_tag;

typedef union FR_TI2CR0_union_tag {
  FR_TI2CR0_ABS_tag ABS;               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FR_TI2CR0_REL_tag REL;               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FR_TI2CR0_tag;

typedef union FR_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
  } B;
} FR_TI2CR1_ABS_tag;

typedef union FR_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FR_TI2CR1_REL_tag;

typedef union FR_TI2CR1_union_tag {
  FR_TI2CR1_ABS_tag ABS;               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FR_TI2CR1_REL_tag REL;               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FR_TI2CR1_tag;

typedef union FR_SSSR_union_tag {      /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SLOTNUMBER:11;
  } B;
} FR_SSSR_tag;

typedef union FR_SSCCR_union_tag {     /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t CNTCFG:2;
    vuint16_t MCY:1;
    vuint16_t VFR:1;
    vuint16_t SYF:1;
    vuint16_t NUF:1;
    vuint16_t SUF:1;
    vuint16_t STATUSMASK:4;
  } B;
} FR_SSCCR_tag;

typedef union FR_SSR_union_tag {       /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t VFB:1;
    vuint16_t SYB:1;
    vuint16_t NFB:1;
    vuint16_t SUB:1;
    vuint16_t SEB:1;
    vuint16_t CEB:1;
    vuint16_t BVB:1;
    vuint16_t TCB:1;
    vuint16_t VFA:1;
    vuint16_t SYA:1;
    vuint16_t NFA:1;
    vuint16_t SUA:1;
    vuint16_t SEA:1;
    vuint16_t CEA:1;
    vuint16_t BVA:1;
    vuint16_t TCA:1;
  } B;
} FR_SSR_tag;

typedef union FR_SSCR_union_tag {      /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;
  } B;
} FR_SSCR_tag;

typedef union FR_MTSACFR_union_tag {   /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSACFR_tag;

typedef union FR_MTSBCFR_union_tag {   /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSBCFR_tag;

typedef union FR_RSBIR_union_tag {     /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_8:4;
    vuint16_t RSBIDX:8;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
  } B;
} FR_RSBIR_tag;

typedef union FR_RFWMSR_union_tag {    /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
    vuint16_t _unused_1:7;
    vuint16_t SEL:1;
  } B;
} FR_RFWMSR_tag;

typedef union FR_RFSIR_union_tag {     /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
  } B;
} FR_RFSIR_tag;

typedef union FR_RFDSR_union_tag {     /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
    vuint16_t _unused_7:1;
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
  } B;
} FR_RFDSR_tag;

typedef union FR_RFARIR_union_tag {    /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFARIR_tag;

typedef union FR_RFBRIR_union_tag {    /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFBRIR_tag;

typedef union FR_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FR_RFMIDAFVR_tag;

typedef union FR_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FR_RFMIDAFMR_tag;

typedef union FR_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
  } B;
} FR_RFFIDRFVR_tag;

typedef union FR_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFMSK:11;
  } B;
} FR_RFFIDRFMR_tag;

typedef union FR_RFRFCFR_union_tag {   /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t IBD:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SID:11;                  /* Slot ID */
  } B;
} FR_RFRFCFR_tag;

typedef union FR_RFRFCTR_union_tag {   /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t F3MD:1;
    vuint16_t F2MD:1;
    vuint16_t F1MD:1;
    vuint16_t F0MD:1;
    vuint16_t _unused_4:4;
    vuint16_t F3EN:1;
    vuint16_t F2EN:1;
    vuint16_t F1EN:1;
    vuint16_t F0EN:1;
  } B;
} FR_RFRFCTR_tag;

typedef union FR_LDTXSLAR_union_tag {  /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTA:11;
  } B;
} FR_LDTXSLAR_tag;

typedef union FR_LDTXSLBR_union_tag {  /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTB:11;
  } B;
} FR_LDTXSLBR_tag;

typedef union FR_PCR0_union_tag {      /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t action_point_offset:6;
    vuint16_t static_slot_length:10;
  } B;
} FR_PCR0_tag;

typedef union FR_PCR1_union_tag {      /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t macro_after_first_static_slot:14;
  } B;
} FR_PCR1_tag;

typedef union FR_PCR2_union_tag {      /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t minislot_after_action_point:6;
    vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
  } B;
} FR_PCR2_tag;

typedef union FR_PCR3_union_tag {      /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_low:6;
    vuint16_t minislot_action_point_offset:5;
    vuint16_t coldstart_attempts:5;
  } B;
} FR_PCR3_tag;

typedef union FR_PCR4_union_tag {      /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t cas_rx_low_max:7;
    vuint16_t wakeup_symbol_rx_window:9;
  } B;
} FR_PCR4_tag;

typedef union FR_PCR5_union_tag {      /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t tss_transmitter:4;
    vuint16_t wakeup_symbol_tx_low:6;
    vuint16_t wakeup_symbol_rx_idle:6;
  } B;
} FR_PCR5_tag;

typedef union FR_PCR6_union_tag {      /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t symbol_window_after_action_point:8;
    vuint16_t macro_initial_offset_a:7;
  } B;
} FR_PCR6_tag;

typedef union FR_PCR7_union_tag {      /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_b:9;
    vuint16_t micro_per_macro_nom_half:7;
  } B;
} FR_PCR7_tag;

typedef union FR_PCR8_union_tag {      /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t max_without_clock_correction_fatal:4;
    vuint16_t max_without_clock_correction_passive:4;
    vuint16_t wakeup_symbol_tx_idle:8;
  } B;
} FR_PCR8_tag;

typedef union FR_PCR9_union_tag {      /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t minislot_exists:1;
    vuint16_t symbol_window_exists:1;
    vuint16_t offset_correction_out:14;
  } B;
} FR_PCR9_tag;

typedef union FR_PCR10_union_tag {     /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t single_slot_enabled:1;
    vuint16_t wakeup_channel:1;
    vuint16_t macro_per_cycle:14;
  } B;
} FR_PCR10_tag;

typedef union FR_PCR11_union_tag {     /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_used_for_startup:1;
    vuint16_t key_slot_used_for_sync:1;
    vuint16_t offset_correction_start:14;
  } B;
} FR_PCR11_tag;

typedef union FR_PCR12_union_tag {     /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t allow_passive_to_active:5;
    vuint16_t key_slot_header_crc:11;
  } B;
} FR_PCR12_tag;

typedef union FR_PCR13_union_tag {     /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t first_minislot_action_point_offset:6;
    vuint16_t static_slot_after_action_point:10;
  } B;
} FR_PCR13_tag;

typedef union FR_PCR14_union_tag {     /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t rate_correction_out:11;
    vuint16_t listen_timeout:5;
  } B;
} FR_PCR14_tag;

typedef union FR_PCR15_union_tag {     /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:16;
  } B;
} FR_PCR15_tag;

typedef union FR_PCR16_union_tag {     /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t macro_initial_offset_b:7;
    vuint16_t noise_listen_timeout:9;
  } B;
} FR_PCR16_tag;

typedef union FR_PCR17_union_tag {     /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:16;
  } B;
} FR_PCR17_tag;

typedef union FR_PCR18_union_tag {     /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_pattern:6;
    vuint16_t key_slot_id:10;
  } B;
} FR_PCR18_tag;

typedef union FR_PCR19_union_tag {     /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_a:9;
    vuint16_t payload_length_static:7;
  } B;
} FR_PCR19_tag;

typedef union FR_PCR20_union_tag {     /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t micro_initial_offset_b:8;
    vuint16_t micro_initial_offset_a:8;
  } B;
} FR_PCR20_tag;

typedef union FR_PCR21_union_tag {     /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t extern_rate_correction:3;
    vuint16_t latest_tx:13;
  } B;
} FR_PCR21_tag;

typedef union FR_PCR22_union_tag {     /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;            /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t comp_accepted_startup_range_a:11;
    vuint16_t micro_per_cycle:4;
  } B;
} FR_PCR22_tag;

typedef union FR_PCR23_union_tag {     /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:16;
  } B;
} FR_PCR23_tag;

typedef union FR_PCR24_union_tag {     /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t cluster_drift_damping:5;
    vuint16_t max_payload_length_dynamic:7;
    vuint16_t micro_per_cycle_min:4;
  } B;
} FR_PCR24_tag;

typedef union FR_PCR25_union_tag {     /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:16;
  } B;
} FR_PCR25_tag;

typedef union FR_PCR26_union_tag {     /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t allow_halt_due_to_clock:1;
    vuint16_t comp_accepted_startup_range_b:11;
    vuint16_t micro_per_cycle_max:4;
  } B;
} FR_PCR26_tag;

typedef union FR_PCR27_union_tag {     /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:16;
  } B;
} FR_PCR27_tag;

typedef union FR_PCR28_union_tag {     /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t dynamic_slot_idle_phase:2;
    vuint16_t macro_after_offset_correction:14;
  } B;
} FR_PCR28_tag;

typedef union FR_PCR29_union_tag {     /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t extern_offset_correction:3;
    vuint16_t minislots_max:13;
  } B;
} FR_PCR29_tag;

typedef union FR_PCR30_union_tag {     /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t sync_node_max:4;
  } B;
} FR_PCR30_tag;

typedef union FR_STPWR_union_tag {     /* StopWatch Count Register */
  vuint32_t R;
  struct {
    vuint32_t STPW:32;                 /* StopWatch Count Register */
  } B;
} FR_STPWR_tag;

typedef union FR_PEOER_union_tag {     /* Protocol Event Output Enable and StopWatch Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t STPW_EN:1;               /* Stopwatch count Enable */
    vuint16_t _unused_3:5;
    vuint16_t TIM2_EE:1;
    vuint16_t TIM1_EE:1;
    vuint16_t CYC_EE:1;
  } B;
} FR_PEOER_tag;

typedef union FR_RFSDOR_union_tag {    /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FR_RFSDOR_tag;

typedef union FR_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;
  } B;
} FR_RFSYMBADHR_tag;

typedef union FR_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_RFSYMBADLR_tag;

typedef union FR_RFPTR_union_tag {     /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t PTD:14;
  } B;
} FR_RFPTR_tag;

typedef union FR_RFFLPCR_union_tag {   /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLB_or_PCB:8;
    vuint16_t FLA_or_PCA:8;
  } B;
} FR_RFFLPCR_tag;

typedef union FR_EEIFER_union_tag {    /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t LRNE_OF:1;
    vuint16_t LRCE_OF:1;
    vuint16_t DRNE_OF:1;
    vuint16_t DRCE_OF:1;
    vuint16_t LRNE_IF:1;
    vuint16_t LRCE_IF:1;
    vuint16_t DRNE_IF:1;
    vuint16_t DRCE_IF:1;
    vuint16_t _unused_4:4;
    vuint16_t LRNE_IE:1;
    vuint16_t LRCE_IE:1;
    vuint16_t DRNE_IE:1;
    vuint16_t DRCE_IE:1;
  } B;
} FR_EEIFER_tag;

typedef union FR_EERICR_union_tag {    /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t BSY:1;
    vuint16_t _unused_10:5;
    vuint16_t ERS:2;
    vuint16_t _unused_5:3;
    vuint16_t ERM:1;
    vuint16_t _unused_2:2;
    vuint16_t EIM:1;
    vuint16_t EIE:1;
  } B;
} FR_EERICR_tag;

typedef union FR_EERAR_union_tag {     /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EERAR_tag;

typedef union FR_EERDR_union_tag {     /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EERDR_tag;

typedef union FR_EERCR_union_tag {     /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EERCR_tag;

typedef union FR_EEIAR_union_tag {     /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EEIAR_tag;

typedef union FR_EEIDR_union_tag {     /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EEIDR_tag;

typedef union FR_EEICR_union_tag {     /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EEICR_tag;

typedef union FR_MB_CCSR_union_tag {   /* Message Buffer Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_13:3;
    vuint16_t MTD:1;
    vuint16_t CMT:1;
    vuint16_t EDT:1;
    vuint16_t LCKT:1;
    vuint16_t MBIE:1;
    vuint16_t _unused_5:3;
    vuint16_t DUP:1;
    vuint16_t DVAL:1;
    vuint16_t EDS:1;
    vuint16_t LCKS:1;
    vuint16_t MBIF:1;
  } B;
} FR_MB_CCSR_tag;

typedef union FR_MB_CCFR_union_tag {   /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t MTM:1;
    vuint16_t CHA:1;
    vuint16_t CHB:1;
    vuint16_t CCFE:1;
    vuint16_t CCFMSK:6;
    vuint16_t CCFVAL:6;
  } B;
} FR_MB_CCFR_tag;

typedef union FR_MB_FIDR_union_tag {   /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FID:11;
  } B;
} FR_MB_FIDR_tag;

typedef union FR_MB_IDXR_union_tag {   /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MBIDX:8;
  } B;
} FR_MB_IDXR_tag;

typedef struct FR_MB_struct_tag {
  FR_MB_CCSR_tag CCSR;                 /* Message Buffer Configuration, Control, Status Register */
  FR_MB_CCFR_tag CCFR;                 /* Message Buffer Cycle Counter Filter Register */
  FR_MB_FIDR_tag FIDR;                 /* Message Buffer Frame ID Register */
  FR_MB_IDXR_tag IDXR;                 /* Message Buffer Index Register */
} FR_MB_tag;

typedef union FR_MBDOR_union_tag {     /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;
  } B;
} FR_MBDOR_tag;

typedef union FR_LEETR_union_tag {     /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;
  } B;
} FR_LEETR_tag;

struct FR_tag {
  FR_MVR_tag MVR;                      /* Module Version Register */
  FR_MCR_tag MCR;                      /* Module Configuration Register */
  FR_SYMBADHR_tag SYMBADHR;            /* System Memory Base Address High Register */
  FR_SYMBADLR_tag SYMBADLR;            /* System Memory Base Address Low Register */
  FR_STBSCR_tag STBSCR;                /* Strobe Signal Control Register */
  uint8_t FR_reserved0[2];
  FR_MBDSR_tag MBDSR;                  /* Message Buffer Data Size Register */
  FR_MBSSUTR_tag MBSSUTR;              /* Message Buffer Segment Size and Utilization Register */
  FR_PEDRAR_tag PEDRAR;                /* PE DRAM Access Register */
  FR_PEDRDR_tag PEDRDR;                /* PE DRAM Data Register */
  FR_POCR_tag POCR;                    /* Protocol Operation Control Register */
  FR_GIFER_tag GIFER;                  /* Global Interrupt Flag and Enable Register */
  FR_PIFR0_tag PIFR0;                  /* Protocol Interrupt Flag Register 0 */
  FR_PIFR1_tag PIFR1;                  /* Protocol Interrupt Flag Register 1 */
  FR_PIER0_tag PIER0;                  /* Protocol Interrupt Enable Register 0 */
  FR_PIER1_tag PIER1;                  /* Protocol Interrupt Enable Register 1 */
  FR_CHIERFR_tag CHIERFR;              /* CHI Error Flag Register */
  FR_MBIVEC_tag MBIVEC;                /* Message Buffer Interrupt Vector Register */
  FR_CASERCR_tag CASERCR;              /* Channel A Status Error Counter Register */
  FR_CBSERCR_tag CBSERCR;              /* Channel B Status Error Counter Register */
  FR_PSR0_tag PSR0;                    /* Protocol Status Register 0 */
  FR_PSR1_tag PSR1;                    /* Protocol Status Register 1 */
  FR_PSR2_tag PSR2;                    /* Protocol Status Register 2 */
  FR_PSR3_tag PSR3;                    /* Protocol Status Register 3 */
  FR_MTCTR_tag MTCTR;                  /* Macrotick Counter Register */
  FR_CYCTR_tag CYCTR;                  /* Cycle Counter Register */
  FR_SLTCTAR_tag SLTCTAR;              /* Slot Counter Channel A Register */
  FR_SLTCTBR_tag SLTCTBR;              /* Slot Counter Channel B Register */
  FR_RTCORVR_tag RTCORVR;              /* Rate Correction Value Register */
  FR_OFCORVR_tag OFCORVR;              /* Offset Correction Value Register */
  FR_CIFR_tag CIFR;                    /* Combined Interrupt Flag Register */
  FR_SYMATOR_tag SYMATOR;              /* System Memory Access Time-Out Register */
  FR_SFCNTR_tag SFCNTR;                /* Sync Frame Counter Register */
  FR_SFTOR_tag SFTOR;                  /* Sync Frame Table Offset Register */
  FR_SFTCCSR_tag SFTCCSR;              /* Sync Frame Table Configuration, Control, Status Register */
  FR_SFIDRFR_tag SFIDRFR;              /* Sync Frame ID Rejection Filter Register */
  FR_SFIDAFVR_tag SFIDAFVR;            /* Sync Frame ID Acceptance Filter Value Register */
  FR_SFIDAFMR_tag SFIDAFMR;            /* Sync Frame ID Acceptance Filter Mask Register */
  FR_NMVR_tag NMVR[6];                 /* Network Management Vector Register */
  FR_NMVLR_tag NMVLR;                  /* Network Management Vector Length Register */
  FR_TICCR_tag TICCR;                  /* Timer Configuration and Control Register */
  FR_TI1CYSR_tag TI1CYSR;              /* Timer 1 Cycle Set Register */
  FR_TI1MTOR_tag TI1MTOR;              /* Timer 1 Macrotick Offset Register */
  FR_TI2CR0_tag TI2CR0;
  FR_TI2CR1_tag TI2CR1;
  FR_SSSR_tag SSSR;                    /* Slot Status Selection Register */
  FR_SSCCR_tag SSCCR;                  /* Slot Status Counter Condition Register */
  FR_SSR_tag SSR[8];                   /* Slot Status Register */
  FR_SSCR_tag SSCR[4];                 /* Slot Status Counter Register */
  FR_MTSACFR_tag MTSACFR;              /* MTS A Configuration Register */
  FR_MTSBCFR_tag MTSBCFR;              /* MTS B Configuration Register */
  FR_RSBIR_tag RSBIR;                  /* Receive Shadow Buffer Index Register */
  FR_RFWMSR_tag RFWMSR;                /* Receive FIFO Watermark and Selection Register */
  FR_RFSIR_tag RFSIR;                  /* Receive FIFO Start Index Register */
  FR_RFDSR_tag RFDSR;                  /* Receive FIFO Depth and Size Register */
  FR_RFARIR_tag RFARIR;                /* Receive FIFO A Read Index Register */
  FR_RFBRIR_tag RFBRIR;                /* Receive FIFO B Read Index Register */
  FR_RFMIDAFVR_tag RFMIDAFVR;          /* Receive FIFO Message ID Acceptance Filter Value Register */
  FR_RFMIDAFMR_tag RFMIDAFMR;          /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FR_RFFIDRFVR_tag RFFIDRFVR;          /* Receive FIFO Frame ID Rejection Filter Value Register */
  FR_RFFIDRFMR_tag RFFIDRFMR;          /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FR_RFRFCFR_tag RFRFCFR;              /* Receive FIFO Range Filter Configuration Register */
  FR_RFRFCTR_tag RFRFCTR;              /* Receive FIFO Range Filter Control Register */
  FR_LDTXSLAR_tag LDTXSLAR;            /* Last Dynamic Transmit Slot Channel A Register */
  FR_LDTXSLBR_tag LDTXSLBR;            /* Last Dynamic Transmit Slot Channel B Register */
  FR_PCR0_tag PCR0;                    /* Protocol Configuration Register 0 */
  FR_PCR1_tag PCR1;                    /* Protocol Configuration Register 1 */
  FR_PCR2_tag PCR2;                    /* Protocol Configuration Register 2 */
  FR_PCR3_tag PCR3;                    /* Protocol Configuration Register 3 */
  FR_PCR4_tag PCR4;                    /* Protocol Configuration Register 4 */
  FR_PCR5_tag PCR5;                    /* Protocol Configuration Register 5 */
  FR_PCR6_tag PCR6;                    /* Protocol Configuration Register 6 */
  FR_PCR7_tag PCR7;                    /* Protocol Configuration Register 7 */
  FR_PCR8_tag PCR8;                    /* Protocol Configuration Register 8 */
  FR_PCR9_tag PCR9;                    /* Protocol Configuration Register 9 */
  FR_PCR10_tag PCR10;                  /* Protocol Configuration Register 10 */
  FR_PCR11_tag PCR11;                  /* Protocol Configuration Register 11 */
  FR_PCR12_tag PCR12;                  /* Protocol Configuration Register 12 */
  FR_PCR13_tag PCR13;                  /* Protocol Configuration Register 13 */
  FR_PCR14_tag PCR14;                  /* Protocol Configuration Register 14 */
  FR_PCR15_tag PCR15;                  /* Protocol Configuration Register 15 */
  FR_PCR16_tag PCR16;                  /* Protocol Configuration Register 16 */
  FR_PCR17_tag PCR17;                  /* Protocol Configuration Register 17 */
  FR_PCR18_tag PCR18;                  /* Protocol Configuration Register 18 */
  FR_PCR19_tag PCR19;                  /* Protocol Configuration Register 19 */
  FR_PCR20_tag PCR20;                  /* Protocol Configuration Register 20 */
  FR_PCR21_tag PCR21;                  /* Protocol Configuration Register 21 */
  FR_PCR22_tag PCR22;                  /* Protocol Configuration Register 22 */
  FR_PCR23_tag PCR23;                  /* Protocol Configuration Register 23 */
  FR_PCR24_tag PCR24;                  /* Protocol Configuration Register 24 */
  FR_PCR25_tag PCR25;                  /* Protocol Configuration Register 25 */
  FR_PCR26_tag PCR26;                  /* Protocol Configuration Register 26 */
  FR_PCR27_tag PCR27;                  /* Protocol Configuration Register 27 */
  FR_PCR28_tag PCR28;                  /* Protocol Configuration Register 28 */
  FR_PCR29_tag PCR29;                  /* Protocol Configuration Register 29 */
  FR_PCR30_tag PCR30;                  /* Protocol Configuration Register 30 */
  FR_STPWR_tag STPWR;                  /* StopWatch Count Register */
  FR_PEOER_tag PEOER;                  /* Protocol Event Output Enable and StopWatch Control Register */
  uint8_t FR_reserved1[2];
  FR_RFSDOR_tag RFSDOR;                /* Receive FIFO Start Data Offset Register */
  FR_RFSYMBADHR_tag RFSYMBADHR;        /* Receive FIFO System Memory Base Address High Register */
  FR_RFSYMBADLR_tag RFSYMBADLR;        /* Receive FIFO System Memory Base Address Low Register */
  FR_RFPTR_tag RFPTR;                  /* Receive FIFO Periodic Timer Register */
  FR_RFFLPCR_tag RFFLPCR;              /* Receive FIFO Fill Level and POP Count Register */
  FR_EEIFER_tag EEIFER;                /* ECC Error Interrupt Flag and Enable Register */
  FR_EERICR_tag EERICR;                /* ECC Error Report and Injection Control Register */
  FR_EERAR_tag EERAR;                  /* ECC Error Report Address Register */
  FR_EERDR_tag EERDR;                  /* ECC Error Report Data Register */
  FR_EERCR_tag EERCR;                  /* ECC Error Report Code Register */
  FR_EEIAR_tag EEIAR;                  /* ECC Error Injection Address Register */
  FR_EEIDR_tag EEIDR;                  /* ECC Error Injection Data Register */
  FR_EEICR_tag EEICR;                  /* ECC Error Injection Code Register */
  uint8_t FR_reserved2[1792];
  FR_MB_tag MB[128];
  uint8_t FR_reserved3[1024];
  FR_MBDOR_tag MBDOR[132];             /* Message Buffer Data Field Offset Register */
  FR_LEETR_tag LEETR[6];               /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: GPR ================================
   ============================================================================ */

typedef union GPR_CTL_union_tag {      /* GPR Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t EXTREGC:1;               /* This bit enables the external regulator control multiplexed function on PG[6] */
    vuint32_t DEST_ESC_CTRL2:1;        /* Enables the escalation of destructive reset source: SWT0 reset request. This bit will be reset on POR. */
    vuint32_t DEST_ESC_CTRL1:1;        /* Enables the escalation of destructive reset source: functional reset escalation. This bit will be reset on POR. */
    vuint32_t DEST_ESC_CTRL0:1;        /* Enables the escalation of destructive reset source: SSCM secured reset. This bit will be reset on POR. */
    vuint32_t _unused_20:5;
    vuint32_t CMP2_STDBY:1;
    vuint32_t CMP1_STDBY:1;
    vuint32_t CMP0_STDBY:1;
    vuint32_t CLKOUT1_STDBY:1;
    vuint32_t LPU_STOP_ACK_BYPASS:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t RTC_SXOSC_FREE_RUNNING:1; /* Enables seamless RTC operation across functional and destructive reset in the specific case when RTC is running on SXOSC. This Bit should be set after SXOSC is enabled by the software. */
    vuint32_t CMP_ACT_SAM:1;           /* Actual sample to the CMP */
    vuint32_t CMP_SAMP_SEL:1;          /* Sample select to the CMP */
    vuint32_t _unused_8:2;
    vuint32_t _unused_6:2;
    vuint32_t FR_BS:2;                 /* FlexRay byte swapper: Swaps the AHB write/read data at the boundary of FlexRay master */
    vuint32_t ENET_TX_BS:2;            /* ENET TX byte swapper: Swaps the AHB write/read data at the TX boundary of ENET master */
    vuint32_t ENET_RX_BS:2;            /* ENET RX byte swapper: Swaps the AHB write/read data at the RX boundary of ENET master */
  } B;
} GPR_CTL_tag;

typedef union GPR_STAT_union_tag {     /* GPR Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t FLASH_LP_ACK:1;          /* FLASH low power acknowledge status */
    vuint32_t _unused_2:8;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} GPR_STAT_tag;

typedef union GPR_CTL1_union_tag {     /* GPR Control Register1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t IVPR:24;                 /* Interrupt Vector Prefix Register Programming */
  } B;
} GPR_CTL1_tag;

typedef union GPR_SLEEP_union_tag {    /* GPR SLEEP Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t SRAM_0_1_2_SLEEP:1;      /* Enables the sleep mode for SRAM memory block 0, 1, 2. */
    vuint32_t SRAM_8_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 8. */
    vuint32_t SRAM_7_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 7. */
    vuint32_t SRAM_6_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 6. */
    vuint32_t SRAM_5_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 5. */
    vuint32_t SRAM_4_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 4. */
    vuint32_t SRAM_3_SLEEP:1;          /* Enables the sleep mode for SRAM memory block 3. */
  } B;
} GPR_SLEEP_tag;

struct GPR_tag {
  GPR_CTL_tag CTL;                     /* GPR Control Register */
  GPR_STAT_tag STAT;                   /* GPR Status Register */
  uint8_t GPR_reserved0[8];
  GPR_CTL1_tag CTL1;                   /* GPR Control Register1 */
  GPR_SLEEP_tag SLEEP;                 /* GPR SLEEP Register */
};


/* ============================================================================
   =============================== Module: HFInterface ========================
   ============================================================================ */

typedef union HFInterface_CCR_union_tag { /* Clock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t CLK_EN:1;                /* Clock Enable */
    vuint32_t CLK_SEL:1;               /* Clock Select */
    vuint32_t CLK_DIV:8;               /* Clock Divider */
  } B;
} HFInterface_CCR_tag;

typedef union HFInterface_SPDCR_union_tag { /* Short Pulse Detector Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t INVERT:1;
    vuint32_t _unused_24:6;
    vuint32_t MAX_VAL:8;               /* Maximum clock cycles */
    vuint32_t _unused_8:8;
    vuint32_t MIN_VAL:8;               /* Minimum clock cycles */
  } B;
} HFInterface_SPDCR_tag;

typedef union HFInterface_LPDCR_union_tag { /* Long Pulse Detector Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t INVERT:1;
    vuint32_t _unused_29:1;
    vuint32_t MAX_VAL:13;              /* Maximum high level value */
    vuint32_t _unused_13:3;
    vuint32_t MIN_VAL:13;              /* Minimum high level value */
  } B;
} HFInterface_LPDCR_tag;

typedef union HFInterface_LTDCR_union_tag { /* Low-level Timeout Detector Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t _unused_16:15;
    vuint32_t MAX_VAL:16;              /* Maximum value */
  } B;
} HFInterface_LTDCR_tag;

typedef union HFInterface_HTDCR_union_tag { /* High-level Timeout Detector Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;
    vuint32_t _unused_16:15;
    vuint32_t MAX_VAL:16;              /* Maximum value */
  } B;
} HFInterface_HTDCR_tag;

typedef union HFInterface_IER_union_tag { /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t ACK_INT_EN:1;
    vuint32_t INIT_INT_EN:1;
    vuint32_t EOF_INT_EN:1;
  } B;
} HFInterface_IER_tag;

typedef union HFInterface_ISR_union_tag { /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t ACK_INT_SR:1;
    vuint32_t INIT_INT_SR:1;
    vuint32_t EOF_INT_SR:1;
  } B;
} HFInterface_ISR_tag;

struct HFInterface_tag {
  HFInterface_CCR_tag CCR;             /* Clock Configuration Register */
  HFInterface_SPDCR_tag SPDCR;         /* Short Pulse Detector Configuration Register */
  HFInterface_LPDCR_tag LPDCR;         /* Long Pulse Detector Configuration Register */
  HFInterface_LTDCR_tag LTDCR;         /* Low-level Timeout Detector Configuration Register */
  HFInterface_HTDCR_tag HTDCR;         /* High-level Timeout Detector Configuration Register */
  HFInterface_IER_tag IER;             /* Interrupt Enable Register */
  HFInterface_ISR_tag ISR;             /* Interrupt Status Register */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t ADR:7;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t MDIS:1;
    vuint8_t IBIE:1;
    vuint8_t MSSL:1;
    vuint8_t TXRX:1;
    vuint8_t NOACK:1;
    vuint8_t RSTA:1;
    vuint8_t DMAEN:1;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t TCF:1;
    vuint8_t IAAS:1;
    vuint8_t IBB:1;
    vuint8_t IBAL:1;
    vuint8_t _unused_3:1;
    vuint8_t SRW:1;
    vuint8_t IBIF:1;
    vuint8_t RXAK:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t BIIE:1;
    vuint8_t BYTERXIE:1;
    vuint8_t _unused_0:6;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_3:5;
    vuint8_t BYTE_RX:1;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t IPG_DEBUG_EN:1;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: I2S ================================
   ============================================================================ */

typedef union I2S_TCSR_union_tag {     /* SAI Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t TE:1;                    /* Transmitter Enable */
    vuint32_t STOPE:1;                 /* Stop Enable */
    vuint32_t DBGE:1;                  /* Debug Enable */
    vuint32_t BCE:1;                   /* Bit Clock Enable */
    vuint32_t _unused_26:2;
    vuint32_t FR:1;                    /* FIFO Reset */
    vuint32_t SR:1;                    /* Software Reset */
    vuint32_t _unused_21:3;
    vuint32_t WSF:1;                   /* Word Start Flag */
    vuint32_t SEF:1;                   /* Sync Error Flag */
    vuint32_t FEF:1;                   /* FIFO Error Flag */
    vuint32_t FWF:1;                   /* FIFO Warning Flag */
    vuint32_t FRF:1;                   /* FIFO Request Flag */
    vuint32_t _unused_13:3;
    vuint32_t WSIE:1;                  /* Word Start Interrupt Enable */
    vuint32_t SEIE:1;                  /* Sync Error Interrupt Enable */
    vuint32_t FEIE:1;                  /* FIFO Error Interrupt Enable */
    vuint32_t FWIE:1;                  /* FIFO Warning Interrupt Enable */
    vuint32_t FRIE:1;                  /* FIFO Request Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t _unused_2:3;
    vuint32_t FWDE:1;                  /* FIFO Warning DMA Enable */
    vuint32_t FRDE:1;                  /* FIFO Request DMA Enable */
  } B;
} I2S_TCSR_tag;

typedef union I2S_TCR1_union_tag {     /* SAI Transmit Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TFW:3;                   /* Transmit FIFO Watermark */
  } B;
} I2S_TCR1_tag;

typedef union I2S_TCR2_union_tag {     /* SAI Transmit Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNC:2;                  /* Synchronous Mode */
    vuint32_t BCS:1;                   /* Bit Clock Swap */
    vuint32_t BCI:1;                   /* Bit Clock Input */
    vuint32_t MSEL:2;                  /* MCLK Select */
    vuint32_t BCP:1;                   /* Bit Clock Polarity */
    vuint32_t BCD:1;                   /* Bit Clock Direction */
    vuint32_t _unused_8:16;
    vuint32_t DIV:8;                   /* Bit Clock Divide */
  } B;
} I2S_TCR2_tag;

typedef union I2S_TCR3_union_tag {     /* SAI Transmit Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CFR:4;                   /* Channel FIFO Reset */
    vuint32_t _unused_20:4;
    vuint32_t TCE:4;                   /* Transmit Channel Enable */
    vuint32_t _unused_4:12;
    vuint32_t WDFL:4;                  /* Word Flag Configuration */
  } B;
} I2S_TCR3_tag;

typedef union I2S_TCR4_union_tag {     /* SAI Transmit Configuration 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t FCONT:1;                 /* FIFO Continue on Error */
    vuint32_t FCOMB:2;                 /* FIFO Combine Mode */
    vuint32_t FPACK:2;                 /* FIFO Packing Mode */
    vuint32_t _unused_20:4;
    vuint32_t FRSZ:4;                  /* Frame size */
    vuint32_t _unused_13:3;
    vuint32_t SYWD:5;                  /* Sync Width */
    vuint32_t _unused_5:3;
    vuint32_t MF:1;                    /* MSB First */
    vuint32_t FSE:1;                   /* Frame Sync Early */
    vuint32_t ONDEM:1;                 /* On Demand Mode */
    vuint32_t FSP:1;                   /* Frame Sync Polarity */
    vuint32_t FSD:1;                   /* Frame Sync Direction */
  } B;
} I2S_TCR4_tag;

typedef union I2S_TCR5_union_tag {     /* SAI Transmit Configuration 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t WNW:5;                   /* Word N Width */
    vuint32_t _unused_21:3;
    vuint32_t W0W:5;                   /* Word 0 Width */
    vuint32_t _unused_13:3;
    vuint32_t FBT:5;                   /* First Bit Shifted */
    vuint32_t _unused_0:8;
  } B;
} I2S_TCR5_tag;

typedef union I2S_TDR_union_tag {      /* SAI Transmit Data Register */
  vuint32_t R;
  struct {
    vuint32_t TDR:32;                  /* Transmit Data Register */
  } B;
} I2S_TDR_tag;

typedef union I2S_TFR_union_tag {      /* SAI Transmit FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t WCP:1;                   /* Write Channel Pointer */
    vuint32_t _unused_20:11;
    vuint32_t WFP:4;                   /* Write FIFO Pointer */
    vuint32_t _unused_4:12;
    vuint32_t RFP:4;                   /* Read FIFO Pointer */
  } B;
} I2S_TFR_tag;

typedef union I2S_TMR_union_tag {      /* SAI Transmit Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TWM:16;                  /* Transmit Word Mask */
  } B;
} I2S_TMR_tag;

typedef union I2S_RCSR_union_tag {     /* SAI Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t RE:1;                    /* Receiver Enable */
    vuint32_t STOPE:1;                 /* Stop Enable */
    vuint32_t DBGE:1;                  /* Debug Enable */
    vuint32_t BCE:1;                   /* Bit Clock Enable */
    vuint32_t _unused_26:2;
    vuint32_t FR:1;                    /* FIFO Reset */
    vuint32_t SR:1;                    /* Software Reset */
    vuint32_t _unused_21:3;
    vuint32_t WSF:1;                   /* Word Start Flag */
    vuint32_t SEF:1;                   /* Sync Error Flag */
    vuint32_t FEF:1;                   /* FIFO Error Flag */
    vuint32_t FWF:1;                   /* FIFO Warning Flag */
    vuint32_t FRF:1;                   /* FIFO Request Flag */
    vuint32_t _unused_13:3;
    vuint32_t WSIE:1;                  /* Word Start Interrupt Enable */
    vuint32_t SEIE:1;                  /* Sync Error Interrupt Enable */
    vuint32_t FEIE:1;                  /* FIFO Error Interrupt Enable */
    vuint32_t FWIE:1;                  /* FIFO Warning Interrupt Enable */
    vuint32_t FRIE:1;                  /* FIFO Request Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t _unused_2:3;
    vuint32_t FWDE:1;                  /* FIFO Warning DMA Enable */
    vuint32_t FRDE:1;                  /* FIFO Request DMA Enable */
  } B;
} I2S_RCSR_tag;

typedef union I2S_RCR1_union_tag {     /* SAI Receive Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t RFW:3;                   /* Receive FIFO Watermark */
  } B;
} I2S_RCR1_tag;

typedef union I2S_RCR2_union_tag {     /* SAI Receive Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SYNC:2;                  /* Synchronous Mode */
    vuint32_t BCS:1;                   /* Bit Clock Swap */
    vuint32_t BCI:1;                   /* Bit Clock Input */
    vuint32_t MSEL:2;                  /* MCLK Select */
    vuint32_t BCP:1;                   /* Bit Clock Polarity */
    vuint32_t BCD:1;                   /* Bit Clock Direction */
    vuint32_t _unused_8:16;
    vuint32_t DIV:8;                   /* Bit Clock Divide */
  } B;
} I2S_RCR2_tag;

typedef union I2S_RCR3_union_tag {     /* SAI Receive Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CFR:4;                   /* Channel FIFO Reset */
    vuint32_t _unused_20:4;
    vuint32_t RCE:4;                   /* Receive Channel Enable */
    vuint32_t _unused_4:12;
    vuint32_t WDFL:4;                  /* Word Flag Configuration */
  } B;
} I2S_RCR3_tag;

typedef union I2S_RCR4_union_tag {     /* SAI Receive Configuration 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t FCONT:1;                 /* FIFO Continue on Error */
    vuint32_t FCOMB:2;                 /* FIFO Combine Mode */
    vuint32_t FPACK:2;                 /* FIFO Packing Mode */
    vuint32_t _unused_20:4;
    vuint32_t FRSZ:4;                  /* Frame Size */
    vuint32_t _unused_13:3;
    vuint32_t SYWD:5;                  /* Sync Width */
    vuint32_t _unused_5:3;
    vuint32_t MF:1;                    /* MSB First */
    vuint32_t FSE:1;                   /* Frame Sync Early */
    vuint32_t ONDEM:1;                 /* On Demand Mode */
    vuint32_t FSP:1;                   /* Frame Sync Polarity */
    vuint32_t FSD:1;                   /* Frame Sync Direction */
  } B;
} I2S_RCR4_tag;

typedef union I2S_RCR5_union_tag {     /* SAI Receive Configuration 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t WNW:5;                   /* Word N Width */
    vuint32_t _unused_21:3;
    vuint32_t W0W:5;                   /* Word 0 Width */
    vuint32_t _unused_13:3;
    vuint32_t FBT:5;                   /* First Bit Shifted */
    vuint32_t _unused_0:8;
  } B;
} I2S_RCR5_tag;

typedef union I2S_RDR_union_tag {      /* SAI Receive Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDR:32;                  /* Receive Data Register */
  } B;
} I2S_RDR_tag;

typedef union I2S_RFR_union_tag {      /* SAI Receive FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t WFP:4;                   /* Write FIFO Pointer */
    vuint32_t RCP:1;                   /* Receive Channel Pointer */
    vuint32_t _unused_4:11;
    vuint32_t RFP:4;                   /* Read FIFO Pointer */
  } B;
} I2S_RFR_tag;

typedef union I2S_RMR_union_tag {      /* SAI Receive Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RWM:16;                  /* Receive Word Mask */
  } B;
} I2S_RMR_tag;

typedef union I2S_MCR_union_tag {      /* SAI MCLK Control Register */
  vuint32_t R;
  struct {
    vuint32_t DUF:1;                   /* Divider Update Flag */
    vuint32_t MOE:1;                   /* MCLK Output Enable */
    vuint32_t _unused_26:4;
    vuint32_t MICS:2;                  /* MCLK Input Clock Select */
    vuint32_t _unused_0:24;
  } B;
} I2S_MCR_tag;

typedef union I2S_MDR_union_tag {      /* SAI MCLK Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FRACT:9;                 /* MCLK Fraction */
    vuint32_t DIVIDE:12;               /* MCLK Divide */
  } B;
} I2S_MDR_tag;

struct I2S_tag {
  I2S_TCSR_tag TCSR;                   /* SAI Transmit Control Register */
  I2S_TCR1_tag TCR1;                   /* SAI Transmit Configuration 1 Register */
  I2S_TCR2_tag TCR2;                   /* SAI Transmit Configuration 2 Register */
  I2S_TCR3_tag TCR3;                   /* SAI Transmit Configuration 3 Register */
  I2S_TCR4_tag TCR4;                   /* SAI Transmit Configuration 4 Register */
  I2S_TCR5_tag TCR5;                   /* SAI Transmit Configuration 5 Register */
  uint8_t I2S_reserved0[8];
  I2S_TDR_tag TDR[4];                  /* SAI Transmit Data Register */
  uint8_t I2S_reserved1[16];
  I2S_TFR_tag TFR[4];                  /* SAI Transmit FIFO Register */
  uint8_t I2S_reserved2[16];
  I2S_TMR_tag TMR;                     /* SAI Transmit Mask Register */
  uint8_t I2S_reserved3[28];
  I2S_RCSR_tag RCSR;                   /* SAI Receive Control Register */
  I2S_RCR1_tag RCR1;                   /* SAI Receive Configuration 1 Register */
  I2S_RCR2_tag RCR2;                   /* SAI Receive Configuration 2 Register */
  I2S_RCR3_tag RCR3;                   /* SAI Receive Configuration 3 Register */
  I2S_RCR4_tag RCR4;                   /* SAI Receive Configuration 4 Register */
  I2S_RCR5_tag RCR5;                   /* SAI Receive Configuration 5 Register */
  uint8_t I2S_reserved4[8];
  I2S_RDR_tag RDR[4];                  /* SAI Receive Data Register */
  uint8_t I2S_reserved5[16];
  I2S_RFR_tag RFR[4];                  /* SAI Receive FIFO Register */
  uint8_t I2S_reserved6[16];
  I2S_RMR_tag RMR;                     /* SAI Receive Mask Register */
  uint8_t I2S_reserved7[28];
  I2S_MCR_tag MCR;                     /* SAI MCLK Control Register */
  I2S_MDR_tag MDR;                     /* SAI MCLK Divide Register */
};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

typedef union IGF_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t _unused_10:16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t FFM:3;                   /* Falling edge filter type selection */
    vuint32_t RFM:3;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR_tag;

typedef union IGF_MSR0_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR0_tag;

typedef union IGF_PRESR0_union_tag {   /* Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t FPRE:11;                 /* Filter prescaler */
  } B;
} IGF_PRESR0_tag;

typedef union IGF_RTHR0_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t RTH:5;                   /* Rising edge threshold */
  } B;
} IGF_RTHR0_tag;

typedef union IGF_FTHR_union_tag {     /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t FTH:5;                   /* Falling edge threshold */
  } B;
} IGF_FTHR_tag;

struct IGF_tag {
  IGF_MCR_tag MCR;                     /* Module Configuration Register */
  IGF_MSR0_tag MSR0;                   /* Module Status Register */
  uint8_t IGF_reserved0[8];
  IGF_PRESR0_tag PRESR0;               /* Prescaler Register */
  uint8_t IGF_reserved1[8];
  IGF_RTHR0_tag RTHR0;                 /* Rising edge Threshold Register */
  IGF_FTHR_tag FTHR;                   /* Falling edge Threshold Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_8:1;
    vuint32_t _unused_5:3;
    vuint32_t HVEN1:1;
    vuint32_t _unused_1:3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_MPROT_union_tag {   /* INTC Master Protection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t ID:2;
    vuint32_t _unused_1:3;
    vuint32_t MPROT:1;
  } B;
} INTC_MPROT_tag;

typedef union INTC_CPR0_union_tag {    /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t PRI:4;
  } B;
} INTC_CPR0_tag;

typedef union INTC_CPR1_union_tag {    /* INTC Current Priority Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t PRI:4;
  } B;
} INTC_CPR1_tag;

typedef union INTC_IACKR0_union_tag {  /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR0_tag;

typedef union INTC_IACKR1_union_tag {  /* INTC Interrupt Acknowledge Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR1_tag;

typedef union INTC_EOIR0_union_tag {   /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR0_tag;

typedef union INTC_EOIR1_union_tag {   /* INTC End Of Interrupt Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR1_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t _unused_13:1;
    vuint16_t _unused_12:1;
    vuint16_t _unused_9:3;
    vuint16_t SWTN:1;
    vuint16_t _unused_4:4;
    vuint16_t PRIN:4;
  } B;
} INTC_PSR_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  INTC_MPROT_tag MPROT;                /* INTC Master Protection Register */
  uint8_t INTC_reserved0[8];
  INTC_CPR0_tag CPR0;                  /* INTC Current Priority Register for Processor 0 */
  INTC_CPR1_tag CPR1;                  /* INTC Current Priority Register for Processor 1 */
  uint8_t INTC_reserved1[8];
  INTC_IACKR0_tag IACKR0;              /* INTC Interrupt Acknowledge Register for Processor 0 */
  INTC_IACKR1_tag IACKR1;              /* INTC Interrupt Acknowledge Register for Processor 1 */
  uint8_t INTC_reserved2[8];
  INTC_EOIR0_tag EOIR0;                /* INTC End Of Interrupt Register for Processor 0 */
  INTC_EOIR1_tag EOIR1;                /* INTC End Of Interrupt Register for Processor 1 */
  uint8_t INTC_reserved3[8];
  INTC_SSCIR_tag SSCIR[24];            /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved4[8];
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t JIN_IEN:1;
    vuint32_t _unused_1:15;
    vuint32_t JOUT_IEN:1;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t JIN_RDY:1;
    vuint32_t _unused_17:1;
    vuint32_t JIN_INT:1;
    vuint32_t _unused_3:13;
    vuint32_t JOUT_RDY:1;
    vuint32_t _unused_1:1;
    vuint32_t JOUT_INT:1;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t _unused_6:1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t _unused_4:1;
    vuint32_t TOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t _unused_10:2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t _unused_3:2;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t _unused_1:6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t RTO:4;
    vuint32_t _unused_7:1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t _unused_0:8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t _unused_6:2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t _unused_6:2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: LPU ================================
   ============================================================================ */

typedef union LPU_MCTL_union_tag {     /* LPU Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;           /* Target Chip Mode */
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;                  /* This field provides the key to change the target mode. Any write access to the register with a value different from the keys is always ignored. Read access will always return the inverted key */
  } B;
} LPU_MCTL_tag;

typedef union LPU_RUN_CF_union_tag {   /* LPU Run Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t CAN0_CONT:1;             /* CAN0 continuous operation across LPU modes. CAN CHI frequency will switch from FS80 to LPU_SYS_CLK which will require reconfiguration thus inhibiting continuous operation across LPU modes. */
    vuint32_t _unused_9:7;
    vuint32_t DIRECT_DRUN:1;           /* Transition to DRUN on LPU_STANDBY exit */
    vuint32_t SYS_CLK_SEL:1;           /* System clock selection in LPU RUN mode */
    vuint32_t LPU_SLEEP:1;             /* Core sleep request during LPU RUN */
    vuint32_t _unused_5:1;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_RUN */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_RUN */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC control during LPU_RUN */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_RUN */
  } B;
} LPU_RUN_CF_tag;

typedef union LPU_STOP_CF_union_tag {  /* LPU Stop Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_STOP */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_STOP */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC control during LPU_STOP */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_STOP */
  } B;
} LPU_STOP_CF_tag;

typedef union LPU_STANDBY_CF_union_tag { /* LPU Standby Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t SXOSC_ON:1;              /* SXOSC control during LPU_STANDBY */
    vuint32_t SIRC_ON:1;               /* SIRC control during LPU_STANDBY */
    vuint32_t _unused_2:1;
    vuint32_t FXOSC_ON:1;              /* FXOSC clock source control during LPU_STANDBY */
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during LPU_STANDBY */
  } B;
} LPU_STANDBY_CF_tag;

typedef union LPU_SR_union_tag {       /* LPU Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t PD2_PWR_STAT:1;          /* Ensures the main domain (power domain 2) is power gated completely. */
    vuint32_t SXOSC_STAT:1;            /* SXOSC clock source status */
    vuint32_t SIRC_STAT:1;             /* SIRC clock status */
    vuint32_t _unused_18:1;
    vuint32_t FXOSC_STAT:1;            /* FXOSC clock source status */
    vuint32_t FIRC_STAT:1;             /* FIRC clock status */
    vuint32_t CLK1_STOP:1;             /* FXOSC clock status during LPU mode */
    vuint32_t CLK0_STOP:1;             /* FIRC status during LPU mode */
    vuint32_t _unused_6:8;
    vuint32_t MTRANS:1;                /* LPU mode transition */
    vuint32_t _unused_4:1;
    vuint32_t CURRENT_MODE:4;          /* Current mode of the chip */
  } B;
} LPU_SR_tag;

typedef union LPU_ICR_union_tag {      /* LPU Interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t LPU_MRIG_E:1;            /* LPU mode request ignored interrupt enable */
    vuint32_t LPU_NEM_E:1;             /* LPU non-exist mode interrupt enable */
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_4:12;
    vuint32_t LPU_MRIG:1;              /* LPU mode request ignored */
    vuint32_t LPU_NEM:1;               /* LPU non-exist mode interrupt */
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} LPU_ICR_tag;

typedef union LPU_MDIS_union_tag {     /* Module Disable */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t eMIOS_0:1;
    vuint32_t CMP_2:1;
    vuint32_t CMP_1:1;
    vuint32_t CMP_0:1;
    vuint32_t MEMU_1:1;
    vuint32_t BCTU:1;
    vuint32_t CAN0:1;
    vuint32_t LIN_0:1;
    vuint32_t SPI_0:1;
    vuint32_t ADC_0:1;
  } B;
} LPU_MDIS_tag;

struct LPU_tag {
  LPU_MCTL_tag MCTL;                   /* LPU Mode Control Register */
  LPU_RUN_CF_tag RUN_CF;               /* LPU Run Configuration Register */
  LPU_STOP_CF_tag STOP_CF;             /* LPU Stop Configuration Register */
  LPU_STANDBY_CF_tag STANDBY_CF;       /* LPU Standby Configuration Register */
  LPU_SR_tag SR;                       /* LPU Status Register */
  LPU_ICR_tag ICR;                     /* LPU Interrupt control register */
  LPU_MDIS_tag MDIS;                   /* Module Disable */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_CLKOUT1_SC_union_tag { /* Clockout 1 Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELCTL:4;                /* CLKOUT1 Source Select */
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_CLKOUT1_SC_tag;

typedef union MC_CGM_CLKOUT1_DC_union_tag { /* CLKOUT1_DC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;                    /* CLKOUT1_DC enable */
    vuint32_t _unused_27:4;
    vuint32_t DIV:11;                  /* Divider */
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_CLKOUT1_DC_tag;

typedef union MC_CGM_AC5_SC_union_tag { /* Auxiliary Clock 5 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC5_SC_tag;

typedef union MC_CGM_AC5_SS_union_tag { /* Auxiliary Clock 5 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC5_SS_tag;

typedef union MC_CGM_SC_DC6_union_tag { /* System Clock Divider 6 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;                   /* Divider */
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC6_tag;

typedef union MC_CGM_AC8_SC_union_tag { /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC8_SC_tag;

typedef union MC_CGM_AC8_SS_union_tag { /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC8_SS_tag;

typedef union MC_CGM_AC9_SC_union_tag { /* Auxiliary Clock 9 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC9_SC_tag;

typedef union MC_CGM_AC9_SS_union_tag { /* Auxiliary Clock 9 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC9_SS_tag;

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC2_tag;

typedef union MC_CGM_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE2_tag;

typedef union MC_CGM_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS2_tag;

typedef union MC_CGM_DIV_UPD_ABRTD_union_tag { /* Divider Update Abort Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t DIV_UPD_ABRTD:1;
  } B;
} MC_CGM_DIV_UPD_ABRTD_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t HALT_ABORT_DIS:1;
    vuint32_t SYS_DIV_RATIO_CHNG:1;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_TYPE:1;          /* System Clock Divider Update Type */
    vuint32_t _unused_7:24;
    vuint32_t _unused_6:1;
    vuint32_t _unused_0:6;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;          /* System Clock Divider Update Status */
    vuint32_t _unused_7:24;
    vuint32_t _unused_6:1;
    vuint32_t _unused_0:6;
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_20:4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_SC_DC3_union_tag { /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_18:13;
    vuint32_t DIV:2;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC3_tag;

typedef union MC_CGM_SC_DC4_union_tag { /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_18:13;
    vuint32_t DIV:2;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC4_tag;

typedef union MC_CGM_SC_DC5_union_tag { /* System Clock Divider 5 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_19:12;
    vuint32_t DIV:3;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC5_tag;

typedef union MC_CGM_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SC_tag;

typedef union MC_CGM_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SS_tag;

typedef union MC_CGM_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC3_SC_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC6_SC_union_tag { /* Auxiliary Clock 6 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELCTL:4;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC6_SC_tag;

typedef union MC_CGM_AC6_SS_union_tag { /* Auxiliary Clock 6 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC6_SS_tag;

typedef union MC_CGM_AC6_DC0_union_tag { /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC6_DC0_tag;

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[384];
  MC_CGM_CLKOUT1_SC_tag CLKOUT1_SC;    /* Clockout 1 Select Register */
  uint8_t MC_CGM_reserved1[4];
  MC_CGM_CLKOUT1_DC_tag CLKOUT1_DC;    /* CLKOUT1_DC Configuration Register */
  uint8_t MC_CGM_reserved2[52];
  MC_CGM_AC5_SC_tag AC5_SC;            /* Auxiliary Clock 5 Select Control Register */
  MC_CGM_AC5_SS_tag AC5_SS;            /* Auxiliary Clock 5 Select Status Register */
  uint8_t MC_CGM_reserved3[56];
  MC_CGM_SC_DC6_tag SC_DC6;            /* System Clock Divider 6 Configuration Register */
  uint8_t MC_CGM_reserved4[124];
  MC_CGM_AC8_SC_tag AC8_SC;            /* Auxiliary Clock 8 Select Control Register */
  MC_CGM_AC8_SS_tag AC8_SS;            /* Auxiliary Clock 8 Select Status Register */
  uint8_t MC_CGM_reserved5[56];
  MC_CGM_AC9_SC_tag AC9_SC;            /* Auxiliary Clock 9 Select Control Register */
  MC_CGM_AC9_SS_tag AC9_SS;            /* Auxiliary Clock 9 Select Status Register */
  uint8_t MC_CGM_reserved6[1080];
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration Register */
  uint8_t MC_CGM_reserved7[3];
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change Register 1 */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End Register 1 */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start Register 1 */
  MC_CGM_PCS_DIVC2_tag PCS_DIVC2;      /* PCS Divider Change Register 2 */
  MC_CGM_PCS_DIVE2_tag PCS_DIVE2;      /* PCS Divider End Register 2 */
  MC_CGM_PCS_DIVS2_tag PCS_DIVS2;      /* PCS Divider Start Register 2 */
  uint8_t MC_CGM_reserved8[176];
  MC_CGM_DIV_UPD_ABRTD_tag DIV_UPD_ABRTD; /* Divider Update Abort Register */
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_reserved9[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status Register */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider 0 Configuration Register */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider 1 Configuration Register */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider 2 Configuration Register */
  MC_CGM_SC_DC3_tag SC_DC3;            /* System Clock Divider 3 Configuration Register */
  MC_CGM_SC_DC4_tag SC_DC4;            /* System Clock Divider 4 Configuration Register */
  MC_CGM_SC_DC5_tag SC_DC5;            /* System Clock Divider 5 Configuration Register */
  uint8_t MC_CGM_reserved10[64];
  MC_CGM_AC2_SC_tag AC2_SC;            /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_AC2_SS_tag AC2_SS;            /* Auxiliary Clock 2 Select Status Register */
  uint8_t MC_CGM_reserved11[24];
  MC_CGM_AC3_SC_tag AC3_SC;            /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_AC3_SS_tag AC3_SS;            /* Auxiliary Clock 3 Select Status Register */
  uint8_t MC_CGM_reserved12[88];
  MC_CGM_AC6_SC_tag AC6_SC;            /* Auxiliary Clock 6 Select Control Register */
  MC_CGM_AC6_SS_tag AC6_SS;            /* Auxiliary Clock 6 Select Status Register */
  MC_CGM_AC6_DC0_tag AC6_DC0;          /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_24:2;
    vuint32_t S_PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t S_MVR:1;
    vuint32_t _unused_18:2;
    vuint32_t S_FLA:2;
    vuint32_t _unused_9:7;
    vuint32_t S_SXOSC:1;               /* 32 KHz external oscillator status */
    vuint32_t S_SIRCON:1;              /* 128 KHz internal RC oscillator status */
    vuint32_t S_PLLON:1;               /* PLL status */
    vuint32_t S_FXOSC:1;               /* 8-40 MHz crystal oscillator status */
    vuint32_t S_FIRCON:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;           /* Target chip mode */
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_14:1;
    vuint32_t STANDBY0:1;              /* STANDBY0 mode enable */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t _unused_1:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t _unused_4:1;             /* This field is reserved and can be set to 1 by hardware during some mode transitions. The setting of this bit has no impact on the device. */
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t _unused_4:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t S_MRIG:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t _unused_24:4;
    vuint32_t MPH_BUSY:1;
    vuint32_t _unused_21:2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t CDP_PRPH_0_255:1;        /* Clock Disable Process Pending status for Peripherals 0...255 */
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t _unused_9:1;
    vuint32_t FLASH_SC:1;
    vuint32_t _unused_4:4;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32Khz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_STOP_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP_MC_tag;

typedef union MC_ME_STANDBY_MC_union_tag { /* STANDBY0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SXOSCON:1;               /* 32 KHz external oscillator control */
    vuint32_t SIRCON:1;
    vuint32_t PLLON:1;
    vuint32_t FXOSCON:1;
    vuint32_t FIRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STANDBY_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t S_IIC_1:1;
    vuint32_t S_IIC_0:1;
    vuint32_t _unused_29:1;
    vuint32_t S_FlexRay:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t _unused_26:2;
    vuint32_t S_ADC_1:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
    vuint32_t S_ADC_0:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_23:1;
    vuint32_t S_ACMP_2:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_ACMP_1:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_ACMP_0:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_16:4;
    vuint32_t S_ENET:1;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_13:2;
    vuint32_t S_SAI_2:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t S_SAI_1:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
    vuint32_t S_SAI_0:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_8:2;
    vuint32_t _unused_3:5;
    vuint32_t S_eMIOS_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t S_eMIOS_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t S_BCTU:1;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t S_LIN:14;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_12:6;
    vuint32_t S_DSPI:4;                /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    vuint32_t _unused_2:6;
    vuint32_t S_IIC:2;                 /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_30:1;
    vuint32_t S_WKPU:1;
    vuint32_t S_LPU_CTL:1;
    vuint32_t S_PIT_RTI_0:1;
    vuint32_t S_DMAMUX:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
    vuint32_t _unused_21:5;
    vuint32_t S_CRC:1;
    vuint32_t S_MEMU_0:1;
    vuint32_t S_JDC:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_14:2;
    vuint32_t S_FLEXCAN:8;
    vuint32_t _unused_4:2;
    vuint32_t _unused_2:2;
    vuint32_t S_LIN:2;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t S_MEMU_1:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t S_RTC_API:1;
    vuint32_t _unused_4:2;
    vuint32_t S_SPI:4;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t _unused_1:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STANDBY0:1;              /* Peripheral control during STANDBY0 */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_0:8;
  } B;
} MC_ME_LP_PC_tag;

    /* Note on PCTL registers: There are only some PCTL implemented         */
    /*  In order to make the PCTL easily addressable, these are defined     */
    /*  as an array (ie ME.PCTL[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-2, 10-12, 15, 20-25, */
    /*  28, 30-33, 40-43, 50-65, 70-77, 81-84, 90-91, 93, 96-99, 102, 105   */

typedef union MC_ME_PCTL_union_tag {   /* BCTU Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t S_CORE3:1;               /* Core3 Status */
    vuint32_t _unused_2:1;
    vuint32_t S_CORE1:1;
    vuint32_t _unused_0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL1_union_tag {  /* Core1 Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t STANDBY0:2;
    vuint16_t _unused_11:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t _unused_1:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL1_tag;

typedef union MC_ME_CCTL3_union_tag {  /* Core3 Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t STANDBY0:2;
    vuint16_t _unused_11:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t _unused_1:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL3_tag;

typedef union MC_ME_CADDR1_union_tag { /* CORE1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;                   /* Reset on Mode Change */
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR3_union_tag { /* CORE3 Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;                   /* Reset on Mode Change */
  } B;
} MC_ME_CADDR3_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN0 Mode Configuration Register */
  uint8_t MC_ME_reserved2[8];
  MC_ME_STOP_MC_tag STOP_MC;           /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved3[8];
  MC_ME_STANDBY_MC_tag STANDBY_MC;     /* STANDBY0 Mode Configuration Register */
  uint8_t MC_ME_reserved4[8];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  uint8_t MC_ME_reserved5[16];
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  MC_ME_PCTL_tag PCTL[106];            /* BCTU Peripheral Control Register */
  uint8_t MC_ME_reserved6[150];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  uint8_t MC_ME_reserved7[2];
  MC_ME_CCTL1_tag CCTL1;               /* Core1 Control Register */
  uint8_t MC_ME_reserved8[2];
  MC_ME_CCTL3_tag CCTL3;               /* Core3 Control Register */
  uint8_t MC_ME_reserved9[24];
  MC_ME_CADDR1_tag CADDR1;             /* CORE1 Address Register */
  uint8_t MC_ME_reserved10[4];
  MC_ME_CADDR3_tag CADDR3;             /* CORE3 Address Register */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PCONF0_union_tag { /* Power Domain #0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RST:1;
  } B;
} MC_PCU_PCONF0_tag;

typedef union MC_PCU_PCONF1_union_tag { /* Power Domain #1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_11:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RST:1;
  } B;
} MC_PCU_PCONF1_tag;

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t PD1:1;                   /* Power status for power domain 1 */
    vuint32_t PD0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  MC_PCU_PCONF0_tag PCONF0;            /* Power Domain #0 Configuration Register */
  MC_PCU_PCONF1_tag PCONF1;            /* Power Domain #1 Configuration Register */
  uint8_t MC_PCU_reserved0[56];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_9:1;
    vuint32_t F_SWT1_RES:1;            /* Flag for SWT1 Reset */
    vuint32_t F_SWT0_RES:1;            /* Flag for SWT0 (Flash Initialization Failure) Reset */
    vuint32_t F_SUF:1;                 /* Flag for SUF (STCU unrecoverable fault) */
    vuint32_t F_FUNC_ESC:1;            /* Flag for Functional Reset Escalation */
    vuint32_t F_SSCM_SEC:1;            /* Flag for SSCM Secure Reset Request */
    vuint32_t F_SOFT_DEST:1;           /* Flag for Software Generated Destructive Reset */
    vuint32_t F_HSM_DEST:1;            /* Flag for HSM Destructive Reset */
    vuint32_t _unused_1:1;
    vuint32_t F_POR:1;                 /* Flag for Power-On Reset */
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_DBRE_union_tag {  /* 'Destructive' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_9:1;
    vuint32_t BE_SWT1_RES:1;           /* Bidirectional Reset Enable for SWT1 Reset */
    vuint32_t BE_SWT0_RES:1;           /* Bidirectional Reset Enable for SWT0 (Flash Initialization Failure) Reset */
    vuint32_t BE_SUF:1;                /* Bidirectional Reset Enable for SUF (STCU unrecoverable fault) */
    vuint32_t BE_FUNC_ESC:1;           /* Bidirectional Reset Enable for Functional Reset Escalation */
    vuint32_t BE_SSCM_SEC:1;           /* Bidirectional Reset Enable for SSCM Secure Reset Request */
    vuint32_t BE_SOFT_DEST:1;          /* Bidirectional Reset Enable for Software Generated Destructive Reset */
    vuint32_t BE_HSM_DEST:1;           /* Bidirectional Reset Enable for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t BE_POR:1;                /* Bidirectional Power-On Reset */
  } B;
} MC_RGM_DBRE_tag;

typedef union MC_RGM_FES_union_tag {   /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t F_LVD_LV_PD2_cold:1;     /* Flag for PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t F_HVD_LV_cold:1;         /* Flag for High Voltage Detect */
    vuint32_t F_LVD_IO_A_HI:1;         /* Flag for Low-Voltage Detect IOs */
    vuint32_t F_Z2_DBG:1;              /* Flag for Z2 Debug Reset */
    vuint32_t _unused_11:1;
    vuint32_t F_Z4A_DBG:1;             /* Flag for Z4A Debug Reset */
    vuint32_t F_FCCU_SHORT:1;          /* Flag for FCCU Short Functional Reset */
    vuint32_t F_FCCU_LONG:1;           /* Flag for FCCU Long Functional Reset */
    vuint32_t F_CMU_OLR:1;             /* Flag for OSC Frequency less than RC */
    vuint32_t F_ST_DONE:1;             /* Flag for Selt Test Completed */
    vuint32_t F_JTAG_FUNC:1;           /* Flag for JTAG Functional Reset */
    vuint32_t F_NMI_WKPU:1;            /* Flag for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t F_SOFT_FUNC:1;           /* Flag for Software Generated Functional Reset */
    vuint32_t F_HSM_FUNC:1;            /* Flag for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t F_EXR:1;                 /* Flag for External Reset */
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t D_LVD_LV_PD2_cold:1;     /* Disable PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t D_HVD_LV_cold:1;         /* Disable High Voltage Detect */
    vuint32_t D_LVD_IO_A_HI:1;         /* Disable Low Voltage Detect IOs */
    vuint32_t D_Z2_DBG:1;              /* Disable Z2 Debug Rreset */
    vuint32_t _unused_11:1;
    vuint32_t D_Z4A_DBG:1;             /* Disable Z4A Debug Reset */
    vuint32_t D_FCCU_SHORT:1;          /* Disable FCCU Short Functional Reset */
    vuint32_t D_FCCU_LONG:1;           /* Disable FCCU Long Functional Reset */
    vuint32_t D_CMU_OLR:1;             /* Disable OSC Frequency less than RC In case OLR is configured as safe mode request, Exit from SAFE mode should be always done via any functional Reset to avoid any unpredictable behavior. */
    vuint32_t D_ST_DONE:1;             /* Disable Selt Test Completed */
    vuint32_t D_JTAG_FUNC:1;           /* Disable JTAG Functional Reset */
    vuint32_t D_NMI_WKPU:1;            /* Disable Non Maskable Interrupt from Wakeup Unit */
    vuint32_t D_SOFT_FUNC:1;           /* Disable Software Generated Functional Reset */
    vuint32_t D_HSM_FUNC:1;            /* Disable HSM Genrated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t D_EXR:1;                 /* Disable External Reset */
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FEAR_union_tag {  /* 'Functional' Event Reset DisableAlternate Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t AR_LVD_LV_PD2_cold:1;    /* Alternate Request for PD2 LVD at cold point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t AR_HVD_LV_cold:1;        /* Alternate Request for High Voltage Detect */
    vuint32_t AR_LVD_IO_A_HI:1;        /* Alternate Request for Low Voltage Detect IOs */
    vuint32_t AR_Z2_DBG:1;             /* Alternate Request for Z2 Debug Reset */
    vuint32_t _unused_11:1;
    vuint32_t AR_Z4A_DBG:1;            /* Alternate Request for Z4A Debug Reset */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t AR_CMU_OLR:1;            /* Alternate Request for OSC Frequency less than RC */
    vuint32_t _unused_6:1;
    vuint32_t AR_JTAG_FUNC:1;          /* Alternate Request for JTAG functional Reset */
    vuint32_t AR_NMI_WKPU:1;           /* Alternate Request for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t AR_EXR:1;                /* Flag for External reset */
  } B;
} MC_RGM_FEAR_tag;

typedef union MC_RGM_FBRE_union_tag {  /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t BE_LVD_LV_PD2_cold:1;    /* Bidirectional Reset Enable for PD2 LVD at Cold Point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t BE_HVD_LV_cold:1;        /* Bidirectional Reset Enable for High Voltage Detect */
    vuint32_t BE_LVD_IO_A_HI:1;        /* Bidirectional Reset Enable for Low Voltage Detect IOs */
    vuint32_t BE_Z2_DBG:1;             /* Bidirectional Reset Enable for Z2 debug reset */
    vuint32_t _unused_11:1;
    vuint32_t BE_Z4A_DBG:1;            /* Bidirectional Reset Enable for Z4A Debug Reset */
    vuint32_t BE_FCCU_SHORT:1;         /* Bidirectional Reset Enable for FCCU Short Functional Reset */
    vuint32_t BE_FCCU_LONG:1;          /* Bidirectional Reset Enable for FCCU Long Functional Reset */
    vuint32_t BE_CMU_OLR:1;            /* Bidirectional Reset Enable for OSC Frequency less than RC */
    vuint32_t BE_ST_DONE:1;            /* Bidirectional Reset Enable for Selt Test Completed */
    vuint32_t BE_JTAG_FUNC:1;          /* Bidirectional Reset Enable for JTAG Function */
    vuint32_t BE_NMI_WKPU:1;           /* Bidirectional Reset Enable for Non Maskable Interrupt from Wakeup Unit */
    vuint32_t BE_SOFT_FUNC:1;          /* Bidirectional Reset Enable for Software Generated Functional Reset */
    vuint32_t BE_HSM_FUNC:1;           /* Bidirectional Reset Enable for HSM Generated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t BE_EXR:1;                /* Flag for External Reset */
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* 'Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t SS_LVD_LV_PD2_cold:1;    /* Short Sequence for PD2 LVD at Cold Point */
    vuint32_t _unused_16:1;
    vuint32_t _unused_15:1;
    vuint32_t SS_HVD_LV_cold:1;        /* Short Sequence for High Voltage Detect IOs */
    vuint32_t SS_LVD_IO_A_HI:1;        /* Short Sequence for Low Voltage Detect IOs */
    vuint32_t SS_Z2_DBG:1;             /* Short Sequence for Z2 Debug Reset */
    vuint32_t _unused_11:1;
    vuint32_t SS_Z4A_DBG:1;            /* Short Sequence for Z4A Debug Reset */
    vuint32_t SS_FCCU_SHORT:1;         /* Short Sequence for FCCU Short Functional Reset */
    vuint32_t SS_FCCU_LONG:1;          /* Short Sequence for FCCU Long Functional Reset */
    vuint32_t SS_CMU_OLR:1;            /* Short Sequence for OSC Frequency less than RC */
    vuint32_t SS_ST_DONE:1;            /* Short Sequence for Selt Test Completed */
    vuint32_t SS_FUNC_JTAG:1;          /* Short Sequence for JTAG Functional Reset */
    vuint32_t SS_NMI_WKPU:1;           /* Short Sequence for Non Maskable Interrupt 3 Wakeup Unit */
    vuint32_t SS_SOFT_FUNC:1;          /* Short Sequence for Software Generated Functional Reset */
    vuint32_t SS_HSM_FUNC:1;           /* Short Sequence for HSM Genrated Functional Reset */
    vuint32_t _unused_1:1;
    vuint32_t SS_EXR:1;                /* Short Sequence for External Reset */
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_FRET_union_tag {  /* 'Functional' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t FRET:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* 'Destructive' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t DRET:4;
  } B;
} MC_RGM_DRET_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* 'Destructive' Event Status Register */
  uint8_t MC_RGM_reserved0[44];
  MC_RGM_DBRE_tag DBRE;                /* 'Destructive' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved1[716];
  MC_RGM_FES_tag FES;                  /* 'Functional' Event Status Register */
  uint8_t MC_RGM_reserved2[12];
  MC_RGM_FERD_tag FERD;                /* 'Functional' Event Reset Disable Register */
  uint8_t MC_RGM_reserved3[12];
  MC_RGM_FEAR_tag FEAR;                /* 'Functional' Event Reset DisableAlternate Request Status Register */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_FBRE_tag FBRE;                /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved5[12];
  MC_RGM_FESS_tag FESS;                /* 'Functional' Event Short Sequence Register */
  uint8_t MC_RGM_reserved6[704];
  MC_RGM_FRET_tag FRET;                /* 'Functional' Reset Escalation Threshold Register */
  uint8_t MC_RGM_reserved7[3];
  MC_RGM_DRET_tag DRET;                /* 'Destructive' Reset Escalation Threshold Register */
};


/* ============================================================================
   =============================== Module: MEMU_0 =============================
   ============================================================================ */

typedef union MEMU_0_CTRL_union_tag {  /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_0_CTRL_tag;

typedef union MEMU_0_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_0_ERR_FLAG_tag;

typedef union MEMU_0_DEBUG_union_tag { /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_0_DEBUG_tag;

typedef union MEMU_0_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_SYS_RAM_CERR_STS_tag;

typedef union MEMU_0_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_0_SYS_RAM_CERR_struct_tag {
  MEMU_0_SYS_RAM_CERR_STS_tag STS;     /* System RAM correctable error reporting table status register */
  MEMU_0_SYS_RAM_CERR_ADDR_tag ADDR;   /* System RAM correctable error reporting table address register */
} MEMU_0_SYS_RAM_CERR_tag;

typedef union MEMU_0_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_0_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_0_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_SYS_RAM_OFLW_tag;

typedef union MEMU_0_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_0_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_0_PERIPH_RAM_CERR_struct_tag {
  MEMU_0_PERIPH_RAM_CERR_STS_tag STS;  /* Peripheral RAM correctable error reporting table status register */
  MEMU_0_PERIPH_RAM_CERR_ADDR_tag ADDR; /* Peripheral RAM correctable error reporting table address register */
} MEMU_0_PERIPH_RAM_CERR_tag;

typedef union MEMU_0_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_0_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_0_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_PERIPH_RAM_OFLW0_tag;

typedef union MEMU_0_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_0_FLASH_CERR_STS_tag;

typedef union MEMU_0_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_FLASH_CERR_ADDR_tag;

typedef struct MEMU_0_FLASH_CERR_struct_tag {
  MEMU_0_FLASH_CERR_STS_tag STS;       /* Flash memory correctable error reporting table status register */
  MEMU_0_FLASH_CERR_ADDR_tag ADDR;     /* Flash memory correctable error reporting table address register */
} MEMU_0_FLASH_CERR_tag;

typedef union MEMU_0_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_0_FLASH_UNCERR_STS_tag;

typedef union MEMU_0_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_0_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_0_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_0_FLASH_OFLW0_tag;

struct MEMU_0_tag {
  MEMU_0_CTRL_tag CTRL;                /* Control register */
  MEMU_0_ERR_FLAG_tag ERR_FLAG;        /* Error flag register */
  uint8_t MEMU_0_reserved0[4];
  MEMU_0_DEBUG_tag DEBUG;              /* Debug register */
  uint8_t MEMU_0_reserved1[16];
  MEMU_0_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_0_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_0_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_0_SYS_RAM_OFLW_tag SYS_RAM_OFLW[1]; /* System RAM concurrent overflow register */
  uint8_t MEMU_0_reserved2[1444];
  MEMU_0_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_0_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_0_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_0_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_0_reserved3[1508];
  MEMU_0_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_0_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_0_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_0_FLASH_OFLW0_tag FLASH_OFLW0;  /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: MEMU_1 =============================
   ============================================================================ */

typedef union MEMU_1_CTRL_union_tag {  /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_1_CTRL_tag;

typedef union MEMU_1_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_1_ERR_FLAG_tag;

typedef union MEMU_1_DEBUG_union_tag { /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_1_DEBUG_tag;

typedef union MEMU_1_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_1_SYS_RAM_CERR_STS_tag;

typedef union MEMU_1_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_1_SYS_RAM_CERR_struct_tag {
  MEMU_1_SYS_RAM_CERR_STS_tag STS;     /* System RAM correctable error reporting table status register */
  MEMU_1_SYS_RAM_CERR_ADDR_tag ADDR;   /* System RAM correctable error reporting table address register */
} MEMU_1_SYS_RAM_CERR_tag;

typedef union MEMU_1_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_1_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_1_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_1_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_1_SYS_RAM_OFLW_tag;

typedef union MEMU_1_PERIPH_RAM_CERR_STS0_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_1_PERIPH_RAM_CERR_STS0_tag;

typedef union MEMU_1_PERIPH_RAM_CERR_ADDR0_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_PERIPH_RAM_CERR_ADDR0_tag;

typedef union MEMU_1_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_1_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_1_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_1_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_1_PERIPH_RAM_OFLW_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_1_PERIPH_RAM_OFLW_tag;

struct MEMU_1_tag {
  MEMU_1_CTRL_tag CTRL;                /* Control register */
  MEMU_1_ERR_FLAG_tag ERR_FLAG;        /* Error flag register */
  uint8_t MEMU_1_reserved0[4];
  MEMU_1_DEBUG_tag DEBUG;              /* Debug register */
  uint8_t MEMU_1_reserved1[16];
  MEMU_1_SYS_RAM_CERR_tag SYS_RAM_CERR[3];
  MEMU_1_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_1_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_1_SYS_RAM_OFLW_tag SYS_RAM_OFLW[1]; /* System RAM concurrent overflow register */
  uint8_t MEMU_1_reserved2[1500];
  MEMU_1_PERIPH_RAM_CERR_STS0_tag PERIPH_RAM_CERR_STS0; /* Peripheral RAM correctable error reporting table status register */
  MEMU_1_PERIPH_RAM_CERR_ADDR0_tag PERIPH_RAM_CERR_ADDR0; /* Peripheral RAM correctable error reporting table address register */
  MEMU_1_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_1_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_1_PERIPH_RAM_OFLW_tag PERIPH_RAM_OFLW[1]; /* Peripheral RAM concurrent overflow register */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t TME:1;
    vuint32_t _unused_3:26;
    vuint32_t LIFE:3;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t GRP:2;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t ATSL:1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t _unused_28:1;
    vuint32_t MSTR:4;
    vuint32_t _unused_21:3;
    vuint32_t RL4:1;
    vuint32_t RL3:1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_IAHB_BE0_union_tag { /* Bus Bridge Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t _unused_26:1;
    vuint32_t BRE_FLX:1;               /* Burst read enable (BRE) FLX */
    vuint32_t BWE_FLX:1;               /* Burst Write Enable */
    vuint32_t _unused_19:5;
    vuint32_t _unused_18:1;
    vuint32_t BRE_ENET:1;              /* Burst read enable (BRE) ENET */
    vuint32_t BWE_ENET:1;              /* Burst Write Enable ENET */
    vuint32_t _unused_11:5;
    vuint32_t _unused_10:1;
    vuint32_t BRE_DMA:1;               /* Burst read enable (BRE) DMA */
    vuint32_t BWE_DMA:1;               /* Burst write enable (BWE) DMA */
    vuint32_t _unused_0:8;
  } B;
} PCM_IAHB_BE0_tag;

typedef union PCM_IAHB_BE1_union_tag { /* Bus Bridge Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t PRE_PBRIDGE_A:1;         /* Pending read enable (PRE) PBRIDGE_A */
    vuint32_t BRE_PBRIDGE_A:1;         /* Burst read enable (BRE) PBRIDGE_A */
    vuint32_t BWE_PBRIDGE_A:1;         /* Burst Write Enable PBRIDGE_A */
    vuint32_t _unused_19:5;
    vuint32_t PRE_PBRIDGE_B:1;         /* Pending Read Enable PBRIDGE_B */
    vuint32_t BRE_PBRIDGE_B:1;         /* Burst read enable (BRE) PBRIDGE_B */
    vuint32_t BWE_PBRIDGE_B:1;         /* Burst Write Enable PBRIDGE_B */
    vuint32_t _unused_11:5;
    vuint32_t PRE_Z2_DATA:1;           /* Pending read enable (PRE) Z2_DATA */
    vuint32_t BRE_Z2_DATA:1;           /* Burst read enable (BRE) Z2_DATA */
    vuint32_t BWE_Z2_DATA:1;           /* Burst write enable (BWE) Z2_DATA */
    vuint32_t _unused_3:5;
    vuint32_t PRE_Z2_INST:1;           /* Pending read enable (PRE) Z2_INST */
    vuint32_t BRE_Z2_INST:1;           /* Burst read enable (BRE) Z2_INST */
    vuint32_t BWE_Z2_INST:1;           /* Burst write enable (BWE) Z2_INST */
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IPS_CGM_EN0_union_tag { /* IPS Clock Gating Module Enable 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t IPS_CGM_INTC:1;          /* IPS clock gating enable for INTC */
    vuint32_t _unused_17:3;
    vuint32_t IPS_CGM_SMPU_0:1;
    vuint32_t _unused_13:3;
    vuint32_t IPS_CGM_AXBS_0:1;        /* IPS clock gating enable for AXBS_0 */
    vuint32_t _unused_9:3;
    vuint32_t IPS_CGM_PRAM1:1;         /* IPS clock gating enable for PRAM1 */
    vuint32_t _unused_5:3;
    vuint32_t IPS_CGM_PRAM0:1;         /* IPS clock gating enable for PRAM0 */
    vuint32_t _unused_1:3;
    vuint32_t IPS_CGM_FLASH:1;         /* IPS clock gating enable for PFlash Controller */
  } B;
} PCM_IPS_CGM_EN0_tag;

struct PCM_tag {
  PCM_IAHB_BE0_tag IAHB_BE0;           /* Bus Bridge Configuration Register 0 */
  PCM_IAHB_BE1_tag IAHB_BE1;           /* Bus Bridge Configuration Register 1 */
  PCM_IPS_CGM_EN0_tag IPS_CGM_EN0;     /* IPS Clock Gating Module Enable 0 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t RWSC:5;
    vuint32_t _unused_7:1;
    vuint32_t P0_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P0_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P1_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P1_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t P2_WCFG:2;
    vuint32_t _unused_21:5;
    vuint32_t _unused_20:1;
    vuint32_t _unused_17:3;
    vuint32_t BAF_DIS:1;
    vuint32_t ARBM:4;                  /* Arbitration Mode. This 4-bit field controls the arbitration of concurrent flash access requests from the three AHB ports of the flash memory controller. In both fixed priority or round-robin modes, write requests are prioritized higher than read requests, and read requests are prioritized higher than speculative prefetch requests whenever multiple ports issue concurrent requests. This field is initialized by hardware reset. Specifying a reserved value in this field causes it to default to round-robin arbitration. */
    vuint32_t _unused_1:11;
    vuint32_t _unused_0:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t SAFE_CAL:1;
    vuint32_t _unused_5:3;
    vuint32_t IRMEN:1;
    vuint32_t _unused_1:3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t CRD8EN:1;
    vuint32_t CRD9EN:1;
    vuint32_t CRD10EN:1;
    vuint32_t CRD11EN:1;
    vuint32_t CRD12EN:1;
    vuint32_t CRD13EN:1;
    vuint32_t CRD14EN:1;
    vuint32_t CRD15EN:1;
    vuint32_t _unused_0:16;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCR4_union_tag { /* Platform Flash Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t P2_M15PFE:1;
    vuint32_t P2_M14PFE:1;
    vuint32_t P2_M13PFE:1;
    vuint32_t P2_M12PFE:1;
    vuint32_t P2_M11PFE:1;
    vuint32_t P2_M10PFE:1;
    vuint32_t P2_M9PFE:1;
    vuint32_t P2_M8PFE:1;
    vuint32_t P2_M7PFE:1;
    vuint32_t P2_M6PFE:1;
    vuint32_t P2_M5PFE:1;
    vuint32_t P2_M4PFE:1;
    vuint32_t P2_M3PFE:1;
    vuint32_t P2_M2PFE:1;
    vuint32_t P2_M1PFE:1;
    vuint32_t P2_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P2_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P2_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P2_PFLIM:2;
    vuint32_t P2_BFEN:1;
  } B;
} PFLASH_PFCR4_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t _unused_5:11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  PFLASH_PFCR4_tag PFCR4;              /* Platform Flash Configuration Register 4 */
  uint8_t PFLASH_reserved0[228];
  PFLASH_PFCRD_tag PFCRD[16];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t MDIS_RTI:1;              /* Module Disable - RTI section */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_RTI_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_RTI_LDVAL_tag;

typedef union PIT_RTI_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_RTI_CVAL_tag;

typedef union PIT_RTI_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable Bit */
  } B;
} PIT_RTI_TCTRL_tag;

typedef union PIT_RTI_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag. */
  } B;
} PIT_RTI_TFLG_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[236];
  PIT_RTI_LDVAL_tag RTI_LDVAL;         /* Timer Load Value Register */
  PIT_RTI_CVAL_tag RTI_CVAL;           /* Current Timer Value Register */
  PIT_RTI_TCTRL_tag RTI_TCTRL;         /* Timer Control Register */
  PIT_RTI_TFLG_tag RTI_TFLG;           /* Timer Flag Register */
  PIT_TIMER_tag TIMER[16];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLLCAL3_union_tag { /* PLL Calibration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t MFDEN:16;                /* Denominator of fractional loop division factor. */
    vuint32_t _unused_0:14;
  } B;
} PLLDIG_PLLCAL3_tag;

typedef union PLLDIG_PLLCR_union_tag { /* PLLDIG PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t LOLRE:1;                 /* Loss-of-lock reset enable. */
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLLCR_tag;

typedef union PLLDIG_PLLSR_union_tag { /* PLLDIG PLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t ENPHI1:1;                /* PLL PHI1 Output Enable */
    vuint32_t ENPHI:1;                 /* PLL PHI Output Enable */
    vuint32_t EXTPDF:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLLSR_tag;

typedef union PLLDIG_PLLDV_union_tag { /* PLLDIG PLL Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFDPHI1:6;               /* PHI1 reduced frequency divider. */
    vuint32_t _unused_22:3;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_15:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_11:1;
    vuint32_t _unused_8:3;
    vuint32_t MFD:8;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLLDV_tag;

typedef union PLLDIG_PLLFM_union_tag { /* PLLDIG PLL Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SSCGBYP:1;               /* Modulation enable. */
    vuint32_t _unused_29:1;
    vuint32_t _unused_26:3;
    vuint32_t STEPSIZE:10;             /* Modulation period. */
    vuint32_t _unused_11:5;
    vuint32_t STEPNO:11;               /* Increment step. */
  } B;
} PLLDIG_PLLFM_tag;

typedef union PLLDIG_PLLFD_union_tag { /* PLLDIG PLL Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SMDEN:1;                 /* Sigma Delta Modulation Enable */
    vuint32_t SDM2:1;                  /* Second Order Sigma Delta Modulation Select */
    vuint32_t SDM3:1;                  /* Third Order Sigma Delta Modulation Select */
    vuint32_t _unused_22:6;
    vuint32_t DTHRCTL:4;               /* Dither Control. */
    vuint32_t DTHDIS:2;                /* Dither Disable. */
    vuint32_t _unused_15:1;
    vuint32_t MFN:15;
  } B;
} PLLDIG_PLLFD_tag;

typedef union PLLDIG_PLLCAL1_union_tag { /* PLL Calibration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BYPCAL:1;                /* Bypass calibration block. */
    vuint32_t _unused_0:31;
  } B;
} PLLDIG_PLLCAL1_tag;

struct PLLDIG_tag {
  uint8_t PLLDIG_reserved0[24];
  PLLDIG_PLLCAL3_tag PLLCAL3;          /* PLL Calibration Register 3 */
  uint8_t PLLDIG_reserved1[4];
  PLLDIG_PLLCR_tag PLLCR;              /* PLLDIG PLL Control Register */
  PLLDIG_PLLSR_tag PLLSR;              /* PLLDIG PLL Status Register */
  PLLDIG_PLLDV_tag PLLDV;              /* PLLDIG PLL Divider Register */
  PLLDIG_PLLFM_tag PLLFM;              /* PLLDIG PLL Frequency Modulation Register */
  PLLDIG_PLLFD_tag PLLFD;              /* PLLDIG PLL Fractional Divide Register */
  uint8_t PLLDIG_reserved2[4];
  PLLDIG_PLLCAL1_tag PLLCAL1;          /* PLL Calibration Register 1 */
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

typedef union PMCDIG_RDCR_union_tag {  /* RAM Domain Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t MEM_SLEEP_EN:1;          /* Memory Sleep Enable */
    vuint32_t _unused_17:3;
    vuint32_t PAD_KEEP_EN:1;           /* PAD Keeper Enable */
    vuint32_t _unused_9:7;
    vuint32_t RD256_RET:1;             /* RAM Domain 256K Retention */
    vuint32_t _unused_5:3;
    vuint32_t RD128_RET:1;             /* RAM Domain 128K Retention */
    vuint32_t _unused_1:3;
    vuint32_t RD64_RET:1;              /* RAM Domain 64K Retention */
  } B;
} PMCDIG_RDCR_tag;

typedef union PMCDIG_SGSR_union_tag {  /* Supply Gauge Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t LP_STATUS:2;             /* Low Power Status */
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t LVD_FLASH:1;             /* LVD VDD_HV_ FLA Flag */
    vuint32_t LVD_IO_A_HI:1;           /* LVD IO Segment A High Flag */
    vuint32_t LVD_IO_A_LO:1;           /* LVD IO Segment A Low Flag */
    vuint32_t LVD_LV_PD0_hot:1;        /* LVD VDD_LV PD0 hot point Flag */
    vuint32_t LVD_LV_PD1_hot:1;        /* LVD VDD_LV PD1 hot point Flag */
    vuint32_t LVD_LV_PD2_COLD:1;       /* LVD_LV_PD2 Cold Point Flag */
    vuint32_t LVD_LV_PD2_HOT:1;        /* LVD LV_PD2 hot Point Flag */
    vuint32_t POR_LV:1;                /* Power On Reset Flag */
  } B;
} PMCDIG_SGSR_tag;

typedef union PMCDIG_MCR_union_tag {   /* MISC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_28:3;
    vuint32_t _unused_25:3;
    vuint32_t _unused_24:1;
    vuint32_t _unused_17:7;
    vuint32_t LP_ST_CHG_IN_PRGRS:1;    /* Low Power State Change in Progress */
    vuint32_t FLASH_LP_FAST_EXIT_DIS:1; /* Flash Low Power Fast Exit Disable */
    vuint32_t _unused_12:3;
    vuint32_t LVD_PD2_COLD_REE:1;      /* LVD_PD2 Cold Point Flag Reset Event Enable */
    vuint32_t HVD_REE:1;               /* HVD Reset Event Enable */
    vuint32_t _unused_9:1;
    vuint32_t LVD_IO_HI_REE:1;         /* LVD_IO_HI Reset Event Enable */
    vuint32_t _unused_3:5;
    vuint32_t _unused_0:3;
  } B;
} PMCDIG_MCR_tag;

struct PMCDIG_tag {
  PMCDIG_RDCR_tag RDCR;                /* RAM Domain Configuration Register */
  PMCDIG_SGSR_tag SGSR;                /* Supply Gauge Status Register */
  uint8_t PMCDIG_reserved0[8];
  PMCDIG_MCR_tag MCR;                  /* MISC Control Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_6:2;
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: RTC ================================
   ============================================================================ */

typedef union RTC_RTCSUPV_union_tag {  /* RTC Supervisor Control register */
  vuint32_t R;
  struct {
    vuint32_t SUPV:1;                  /* RTC Supervisor Bit. */
    vuint32_t _unused_0:31;            /* Reserved. */
  } B;
} RTC_RTCSUPV_tag;

typedef union RTC_RTCC_union_tag {     /* RTC Control register */
  vuint32_t R;
  struct {
    vuint32_t CNTEN:1;                 /* Counter Enable. */
    vuint32_t RTCIE:1;                 /* RTC Interrupt Enable. */
    vuint32_t FRZEN:1;                 /* Freeze Enable Bit. */
    vuint32_t ROVREN:1;                /* Counter Roll Over Wakeup/Interrupt Enable. */
    vuint32_t _unused_16:12;           /* Reserved. */
    vuint32_t APIEN:1;                 /* Autonomous Periodic Interrupt Enable. */
    vuint32_t APIIE:1;                 /* API Interrupt Enable. */
    vuint32_t CLKSEL:2;                /* Clock Select. */
    vuint32_t DIV512EN:1;              /* Divide by 512 enable. */
    vuint32_t DIV32EN:1;               /* Divide by 32 enable. */
    vuint32_t _unused_1:9;             /* Reserved. */
    vuint32_t TRIG_EN:1;               /* Trigger enable for Analog Comparator */
  } B;
} RTC_RTCC_tag;

typedef union RTC_RTCS_union_tag {     /* RTC Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;            /* Reserved. */
    vuint32_t RTCF:1;                  /* RTC Interrupt Flag. */
    vuint32_t _unused_19:10;           /* Reserved. */
    vuint32_t INV_RTC:1;               /* Invalid rtc write */
    vuint32_t INV_API:1;               /* Invalid APIVAL write */
    vuint32_t INV_ANL:1;               /* Invalid ANLCMP write */
    vuint32_t _unused_14:2;
    vuint32_t APIF:1;                  /* API Interrupt Flag. */
    vuint32_t _unused_11:2;            /* Reserved. */
    vuint32_t ROVRF:1;                 /* Counter Roll Over Interrupt Flag. */
    vuint32_t _unused_0:10;            /* Reserved. */
  } B;
} RTC_RTCS_tag;

typedef union RTC_RTCCNT_union_tag {   /* RTC Counter register */
  vuint32_t R;
  struct {
    vuint32_t RTCCNT:32;               /* RTC Counter Value. */
  } B;
} RTC_RTCCNT_tag;

typedef union RTC_APIVAL_union_tag {   /* API Compare Value register */
  vuint32_t R;
  struct {
    vuint32_t APIVAL:32;               /* API Compare Value. */
  } B;
} RTC_APIVAL_tag;

typedef union RTC_RTCVAL_union_tag {   /* RTC Compare Value register */
  vuint32_t R;
  struct {
    vuint32_t RTCVAL:32;               /* RTC Compare Value. */
  } B;
} RTC_RTCVAL_tag;

typedef union RTC_ANLCMP_CNT_union_tag { /* RTC Analogue comparator count register */
  vuint32_t R;
  struct {
    vuint32_t ANLCMP:32;               /* The trigger_en_out pulse will be generated (after the generation of wakeup_api signal) as per the number of API clocks programmed into this register. */
  } B;
} RTC_ANLCMP_CNT_tag;

struct RTC_tag {
  RTC_RTCSUPV_tag RTCSUPV;             /* RTC Supervisor Control register */
  RTC_RTCC_tag RTCC;                   /* RTC Control register */
  RTC_RTCS_tag RTCS;                   /* RTC Status register */
  RTC_RTCCNT_tag RTCCNT;               /* RTC Counter register */
  RTC_APIVAL_tag APIVAL;               /* API Compare Value register */
  RTC_RTCVAL_tag RTCVAL;               /* RTC Compare Value register */
  RTC_ANLCMP_CNT_tag ANLCMP_CNT;       /* RTC Analogue comparator count register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t ROZ:2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIRC ===============================
   ============================================================================ */

typedef union SIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_13:3;
    vuint32_t SIRCDIV:5;               /* The SIRC Divider bits select the clock divider . factor */
    vuint32_t _unused_5:3;
    vuint32_t SIRCS:1;                 /* Describes the SIRC clock status. */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} SIRC_CTL_tag;

struct SIRC_tag {
  SIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;              /* MCU Part Number */
    vuint32_t _unused_15:1;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t _unused_8:2;
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FLASH_SIZE_1:4;          /* Coarse granularity for flash memory size */
    vuint32_t FLASH_SIZE_2:4;          /* Fine granularity for flash memory size */
    vuint32_t _unused_16:7;
    vuint32_t PARTNUM:8;               /* ASCII character in MCU Part Number */
    vuint32_t _unused_0:8;
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_ISR0_union_tag {   /* SIUL2 Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag x */
    vuint32_t _unused_24:7;
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag x */
  } B;
} SIUL2_ISR0_tag;

typedef union SIUL2_IRER0_union_tag {  /* SIUL2 Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE31:1;
    vuint32_t _unused_24:7;
    vuint32_t EIRE23:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_IRER0_tag;

typedef union SIUL2_IRSR0_union_tag {  /* SIUL2 Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR31:1;
    vuint32_t _unused_24:7;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR0:1;
  } B;
} SIUL2_IRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE31:1;
    vuint32_t _unused_24:7;
    vuint32_t IREE23:1;
    vuint32_t IREE22:1;
    vuint32_t IREE21:1;
    vuint32_t IREE20:1;
    vuint32_t IREE19:1;
    vuint32_t IREE18:1;
    vuint32_t IREE17:1;
    vuint32_t IREE16:1;
    vuint32_t IREE15:1;
    vuint32_t IREE14:1;
    vuint32_t IREE13:1;
    vuint32_t IREE12:1;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE31:1;
    vuint32_t _unused_24:7;
    vuint32_t IFEE23:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE31:1;
    vuint32_t _unused_24:7;
    vuint32_t IFE23:1;
    vuint32_t IFE22:1;
    vuint32_t IFE21:1;
    vuint32_t IFE20:1;
    vuint32_t IFE19:1;
    vuint32_t IFE18:1;
    vuint32_t IFE17:1;
    vuint32_t IFE16:1;
    vuint32_t IFE15:1;
    vuint32_t IFE14:1;
    vuint32_t IFE13:1;
    vuint32_t IFE12:1;
    vuint32_t IFE11:1;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t IFE7:1;
    vuint32_t IFE6:1;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t SRC:2;                   /* Slew Rate Control */
    vuint32_t _unused_26:2;
    vuint32_t OBE:1;                   /* GPIO Output Buffer Enable */
    vuint32_t ODE:1;                   /* Open Drain Enable */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t APC:1;                   /* Analog Pad Control */
    vuint32_t _unused_21:1;
    vuint32_t _unused_20:1;
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t PUS:1;                   /* Pull Select */
    vuint32_t PUE:1;                   /* Pull Enable */
    vuint32_t _unused_8:8;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_IMCR_union_tag {   /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Invert */
    vuint32_t _unused_8:23;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_IMCR_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDO_4n:1;					     /* Pad Data Out */
    } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDI_4n:1;					     /* Pad Data In */
    } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;                 /* Mask Field */
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_ISR0_tag ISR0;                 /* SIUL2 Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_IRER0_tag IRER0;               /* SIUL2 Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_IRSR0_tag IRSR0;               /* SIUL2 Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[380];
  SIUL2_MSCR_tag MSCR[264];            /* SIUL2 Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved9[992];
  SIUL2_IMCR_tag IMCR[512];            /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[192];
  SIUL2_GPDO_tag GPDO[264];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved11[248];
  SIUL2_GPDI_tag GPDI[264];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved12[248];
  SIUL2_PGPDO_tag PGPDO[32];           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDI_tag PGPDI[32];           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_MPGPDO_tag MPGPDO[32];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CES0_union_tag {    /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;                 /* Master n error, where the bus master number matches the bit number */
    vuint32_t _unused_4:12;
    vuint32_t HRL:3;                   /* Hardware revision level */
    vuint32_t GVLD:1;                  /* Global Valid (global enable/disable for the SMPU) */
  } B;
} SMPU_CES0_tag;

typedef union SMPU_CES1_union_tag {    /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;                /* Master n error overrun, where the bus master number matches the bit number */
    vuint32_t _unused_4:12;
    vuint32_t NRGD:4;                  /* Number of region descriptors */
  } B;
} SMPU_CES1_tag;

typedef union SMPU_ERROR_ADR_union_tag { /* Error Address Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error address */
  } B;
} SMPU_ERROR_ADR_tag;

typedef union SMPU_ERROR_ADTL_union_tag { /* Error Attribute Detail Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t PID:8;
    vuint32_t _unused_10:14;
    vuint32_t EATTR:2;                 /* Error attributes */
    vuint32_t ERW:1;                   /* Error read/write */
    vuint32_t EMN:7;                   /* Error master number */
  } B;
} SMPU_ERROR_ADTL_tag;

typedef union SMPU_ERROR_ACDL_union_tag { /* Error Attribute Control Detail Register, Bus Master */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;                 /* Error access control detail */
    vuint32_t _unused_0:8;
  } B;
} SMPU_ERROR_ACDL_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_ADR_tag ADR;              /* Error Address Register, Bus Master */
  SMPU_ERROR_ADTL_tag ADTL;            /* Error Attribute Detail Register, Bus Master */
  SMPU_ERROR_ACDL_tag ACDL;            /* Error Attribute Control Detail Register, Bus Master */
  uint8_t ERROR_reserved0[4];
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:28;              /* Start address */
    vuint32_t _unused_0:4;
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:28;              /* End address */
    vuint32_t _unused_0:4;
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_FMT0_union_tag { /* Region Descriptor n, Word 2 Format 0 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;                   /* Bus master 0 permissions */
    vuint32_t M1P:2;                   /* Bus master 1 permissions */
    vuint32_t M2P:2;                   /* Bus master 2 permissions */
    vuint32_t M3P:2;                   /* Bus master 3 permissions */
    vuint32_t M4P:2;                   /* Bus master 4 permissions */
    vuint32_t M5P:2;                   /* Bus master 5 permissions */
    vuint32_t M6P:2;                   /* Bus master 6 permissions */
    vuint32_t M7P:2;                   /* Bus master 7 permissions */
    vuint32_t M8P:2;                   /* Bus master 8 permissions */
    vuint32_t M9P:2;                   /* Bus master 9 permissions */
    vuint32_t M10P:2;                  /* Bus master 10 permissions */
    vuint32_t M11P:2;                  /* Bus master 11 permissions */
    vuint32_t M12P:2;                  /* Bus master 12 permissions */
    vuint32_t M13P:2;                  /* Bus master 13 permissions */
    vuint32_t M14P:2;                  /* Bus master 14 permissions */
    vuint32_t M15P:2;                  /* Bus master 15 permissions */
  } B;
} SMPU_RGD_WORD2_FMT0_tag;

typedef union SMPU_RGD_WORD2_FMT1_union_tag { /* Region Descriptor n, Word 2 Format 1 */
  vuint32_t R;
  struct {
    vuint32_t M0S:2;                   /* Bus master 0 permission select */
    vuint32_t M1S:2;                   /* Bus master 1 permission select */
    vuint32_t M2S:2;                   /* Bus master 2 permission select */
    vuint32_t M3S:2;                   /* Bus master 3 permission select */
    vuint32_t M4S:2;                   /* Bus master 4 permission select */
    vuint32_t M5S:2;                   /* Bus master 5 permission select */
    vuint32_t M6S:2;                   /* Bus master 6 permission select */
    vuint32_t M7S:2;                   /* Bus master 7 permission select */
    vuint32_t M8S:2;                   /* Bus master 8 permission select */
    vuint32_t M9S:2;                   /* Bus master 9 permission select */
    vuint32_t M10S:2;                  /* Bus master 10 permission select */
    vuint32_t M11S:2;                  /* Bus master 11 permission select */
    vuint32_t M12S:2;                  /* Bus master 12 permission select */
    vuint32_t M13S:2;                  /* Bus master 13 permission select */
    vuint32_t M14S:2;                  /* Bus master 14 permission select */
    vuint32_t M15S:2;                  /* Bus master 15 permission select */
  } B;
} SMPU_RGD_WORD2_FMT1_tag;

typedef union SMPU_RGD_WORD2_union_tag {
  SMPU_RGD_WORD2_FMT0_tag FMT0;        /* Region Descriptor n, Word 2 Format 0 */
  SMPU_RGD_WORD2_FMT1_tag FMT1;        /* Region Descriptor n, Word 2 Format 1 */
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t ACCSET1:6;               /* Access controls, Set 1 */
    vuint32_t ACCSET2:6;               /* Access controls, Set 2 */
    vuint32_t ACCSET3:6;               /* Access controls, Set 3 */
    vuint32_t _unused_5:9;
    vuint32_t FMT:1;                   /* Region Descriptor Format */
    vuint32_t _unused_2:2;
    vuint32_t CI:1;                    /* Cache Inhibit */
    vuint32_t _unused_0:1;
  } B;
} SMPU_RGD_WORD3_tag;

typedef union SMPU_RGD_WORD4_union_tag { /* Region Descriptor n, Word 4 */
  vuint32_t R;
  struct {
    vuint32_t PID:8;                   /* Process Identifier */
    vuint32_t PID_MASK:8;              /* Process Identifier Mask */
    vuint32_t _unused_1:15;
    vuint32_t PIDEN:1;                 /* Region Descriptor PID Enable */
  } B;
} SMPU_RGD_WORD4_tag;

typedef union SMPU_RGD_WORD5_union_tag { /* Region Descriptor n, Word 5 */
  vuint32_t R;
  struct {
    vuint32_t MID:8;                   /* Master ID of RGDn owner */
    vuint32_t _unused_4:20;
    vuint32_t LCK:2;                   /* Region Descriptor Lock */
    vuint32_t _unused_1:1;
    vuint32_t VLD:1;                   /* Valid */
  } B;
} SMPU_RGD_WORD5_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
  SMPU_RGD_WORD4_tag WORD4;            /* Region Descriptor n, Word 4 */
  SMPU_RGD_WORD5_tag WORD5;            /* Region Descriptor n, Word 5 */
  uint8_t RGD_reserved0[40];
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CES0_tag CES0;                  /* Control/Error Status Register 0 */
  SMPU_CES1_tag CES1;                  /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[512];
  SMPU_RGD_tag RGD[16];
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_4:4;
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t FMSZ:5;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t _unused_22:1;
    vuint32_t _unused_0:22;
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[6];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t _unused_29:1;
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t _unused_22:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_20:1;
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t DDIF_DIRS:1;             /* DSI data received with active bits - DMA or Interrupt Request Select. */
    vuint32_t _unused_0:14;
  } B;
} SPI_RSER_tag;

typedef union SPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t _unused_22:2;            /* Always write the reset value to this field. */
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_tag;

typedef union SPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_PUSHR_union_tag {
  SPI_PUSHR_PUSHR_tag PUSHR;           /* PUSH TX FIFO Register In Master Mode */
  SPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

typedef union SPI_CTARE_union_tag {    /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t _unused_11:5;
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
  } B;
} SPI_CTARE_tag;

typedef union SPI_SREX_union_tag {     /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t _unused_12:2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t _unused_9:2;
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} SPI_SREX_tag;

typedef union SPI_TRIG_union_tag {     /* Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;                /* Trigger Register Enable */
    vuint32_t _unused_4:27;
    vuint32_t _unused_3:1;
    vuint32_t ASDR_WT:1;               /* ASDR Write Trigger Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t TRRE:1;                  /* Trigger Reception Enable */
  } B;
} SPI_TRIG_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  uint8_t SPI_reserved1[8];
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_PUSHR_tag PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[4];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved2[48];
  SPI_RXFR_tag RXFR[4];                /* Receive FIFO Registers */
  uint8_t SPI_reserved3[144];
  SPI_CTARE_tag CTARE[6];              /* Clock and Transfer Attributes Register Extended */
  uint8_t SPI_reserved4[8];
  SPI_SREX_tag SREX;                   /* Status Register Extended */
  SPI_TRIG_tag TRIG;                   /* Trigger Register */
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t _unused_13:1;
    vuint16_t _unused_12:1;
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t _unused_10:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t _unused_4:1;
    vuint16_t _unused_3:1;
    vuint16_t _unused_2:1;
    vuint16_t _unused_0:2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t _unused_5:1;
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t _unused_0:1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_DEBUGPORT_union_tag { /* SSCM Debug Status Port Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t _unused_8:1;
    vuint16_t _unused_3:5;
    vuint16_t DEBUG_MODE:3;
  } B;
} SSCM_DEBUGPORT_tag;

typedef union SSCM_UOPS_union_tag {    /* SSCM HSM and User Option Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t HSB:3;                   /* HSM Boot Configuration */
    vuint32_t HSE:1;                   /* HSM Enabled */
  } B;
} SSCM_UOPS_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_HSA_union_tag {     /* SSCM HSM Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t HADR:32;                 /* HSM Start Address */
  } B;
} SSCM_HSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_3:5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[4];
  SSCM_DEBUGPORT_tag DEBUGPORT;        /* SSCM Debug Status Port Register */
  uint8_t SSCM_reserved1[22];
  SSCM_UOPS_tag UOPS;                  /* SSCM HSM and User Option Status Register */
  uint8_t SSCM_reserved2[4];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved3[4];
  SSCM_HSA_tag HSA;                    /* SSCM HSM Start Address Register */
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_1:7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_2:6;
    vuint32_t _unused_1:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PTR:7;
    vuint32_t _unused_16:8;
    vuint32_t _unused_9:7;
    vuint32_t WRP:1;
    vuint32_t _unused_6:2;
    vuint32_t _unused_5:1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t _unused_18:1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t _unused_10:6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t _unused_5:3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t _unused_2:1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t _unused_2:1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_0:24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  uint8_t STCU2_reserved0[4];
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  uint8_t STCU2_reserved1[12];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  uint8_t STCU2_reserved2[24];
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved3[1408];
  STCU2_MB_CTRL_tag MB_CTRL[45];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_2:6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t _unused_11:13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;                   /* Interrupt Then Reset */
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: SXOSC ==============================
   ============================================================================ */

typedef union SXOSC_CTL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;                /* Oscillator start-up delay bypass */
    vuint32_t ALC:1;                   /* Auto Level Control */
    vuint32_t _unused_24:6;
    vuint32_t EOCV:8;                  /* End of Counter Value */
    vuint32_t M_OSC:1;                 /* SXOSC clock interrupt mask */
    vuint32_t _unused_13:2;
    vuint32_t OSCDIV:5;                /* The SXOSC Divider bits select the clock divider factor. */
    vuint32_t I_OSC:1;                 /* SXOSC clock interrupt */
    vuint32_t _unused_0:7;
  } B;
} SXOSC_CTL_tag;

struct SXOSC_tag {
  SXOSC_CTL_tag CTL;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDRSR5:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t LFPAR:24;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;
    vuint32_t NOVF0:1;
    vuint32_t _unused_24:6;
    vuint32_t _unused_22:2;
    vuint32_t _unused_16:6;
    vuint32_t NIF2:1;
    vuint32_t NOVF2:1;
    vuint32_t _unused_8:6;
    vuint32_t RIF:1;                   /* Reset Status Flag */
    vuint32_t ROVF:1;                  /* Reset Overrun Status Flag */
    vuint32_t _unused_0:6;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;
    vuint32_t NDSS0:2;
    vuint32_t NWRE0:1;
    vuint32_t _unused_27:1;
    vuint32_t NREE0:1;
    vuint32_t NFEE0:1;
    vuint32_t NFE0:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_20:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t NLOCK2:1;
    vuint32_t NDSS2:2;
    vuint32_t NWRE2:1;
    vuint32_t _unused_11:1;
    vuint32_t NREE2:1;
    vuint32_t NFEE2:1;
    vuint32_t _unused_8:1;
    vuint32_t RLOCK:1;
    vuint32_t RDSS:2;
    vuint32_t RWRE:1;
    vuint32_t _unused_3:1;
    vuint32_t RREE:1;
    vuint32_t RFEE:1;
    vuint32_t _unused_0:1;
  } B;
} WKPU_NCR_tag;

typedef union WKPU_WISR_union_tag {    /* Wakeup/Interrupt Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t EIF:32;
  } B;
} WKPU_WISR_tag;

typedef union WKPU_IRER_union_tag {    /* Interrupt Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t EIRE:32;
  } B;
} WKPU_IRER_tag;

typedef union WKPU_WRER_union_tag {    /* Wakeup Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WRE:32;
  } B;
} WKPU_WRER_tag;

typedef union WKPU_WIREER_union_tag {  /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IREE:32;
  } B;
} WKPU_WIREER_tag;

typedef union WKPU_WIFEER_union_tag {  /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFEEx:32;
  } B;
} WKPU_WIFEER_tag;

typedef union WKPU_WIFER_union_tag {   /* Wakeup/Interrupt Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFE:32;
  } B;
} WKPU_WIFER_tag;

typedef union WKPU_WIPDER_union_tag {  /* Wakeup/Interrupt Pulldown Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPUE:32;
  } B;
} WKPU_WIPDER_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
  uint8_t WKPU_reserved1[8];
  WKPU_WISR_tag WISR;                  /* Wakeup/Interrupt Status Flag Register */
  WKPU_IRER_tag IRER;                  /* Interrupt Request Enable Register */
  WKPU_WRER_tag WRER;                  /* Wakeup Request Enable Register */
  uint8_t WKPU_reserved2[8];
  WKPU_WIREER_tag WIREER;              /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  WKPU_WIFEER_tag WIFEER;              /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  WKPU_WIFER_tag WIFER;                /* Wakeup/Interrupt Filter Enable Register */
  WKPU_WIPDER_tag WIPDER;              /* Wakeup/Interrupt Pulldown Enable Register */
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

typedef union XOSC_CTL_union_tag {     /* XOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;
    vuint32_t OSCM:1;                  /* Crystal Oscillator Mode. */
    vuint32_t MON:1;
    vuint32_t _unused_24:5;
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t _unused_13:2;
    vuint32_t _unused_8:5;
    vuint32_t I_OSC:1;
    vuint32_t _unused_2:5;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} XOSC_CTL_tag;

struct XOSC_tag {
  XOSC_CTL_tag CTL;                    /* XOSC Control Register */
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */

typedef union eMIOS_MCR_union_tag {    /* eMIOS Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;            /* Reserved. */
    vuint32_t MDIS:1;                  /* Module Disable bit. */
    vuint32_t FRZ:1;                   /* Freeze bit. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable bit. */
    vuint32_t ETB:1;                   /* External Time Base bit */
    vuint32_t GPREN:1;                 /* Global Prescaler Enable bit. */
    vuint32_t _unused_20:6;            /* Reserved. */
    vuint32_t _unused_16:4;            /* Reserved. */
    vuint32_t GPRE:8;                  /* Global Prescaler bits. */
    vuint32_t _unused_0:8;             /* Reserved. */
  } B;
} eMIOS_MCR_tag;

typedef union eMIOS_GFLAG_union_tag {  /* eMIOS Global FLAG Register */
  vuint32_t R;
  struct {
    vuint32_t F31_F0:32;               /* Channel [n] mirrored FLAG bit. */
  } B;
} eMIOS_GFLAG_tag;

typedef union eMIOS_OUDIS_union_tag {  /* eMIOS Output Update Disable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t OU23_OU0:24;             /* Channel [n] Output Update Disable bit. */
  } B;
} eMIOS_OUDIS_tag;

typedef union eMIOS_UCDIS_union_tag {  /* eMIOS Disable Channel register */
  vuint32_t R;
  struct {
    vuint32_t CHDIS31_CHDIS0:32;       /* Enable Channel n bit. */
  } B;
} eMIOS_UCDIS_tag;

struct eMIOS_tag {
  eMIOS_MCR_tag MCR;                   /* eMIOS Module Configuration Register */
  eMIOS_GFLAG_tag GFLAG;               /* eMIOS Global FLAG Register */
  eMIOS_OUDIS_tag OUDIS;               /* eMIOS Output Update Disable register */
  eMIOS_UCDIS_tag UCDIS;               /* eMIOS Disable Channel register */
};


/* ============================================================================
   =============================== Module: eMIOS_UC ===========================
   ============================================================================ */

typedef union eMIOS_UC_UC_A_union_tag { /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_UC_UC_A_tag;

typedef union eMIOS_UC_UC_B_union_tag { /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_UC_UC_B_tag;

typedef union eMIOS_UC_UC_CNT_union_tag { /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved. */
    vuint32_t C:16;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_UC_UC_CNT_tag;

typedef union eMIOS_UC_UC_C_union_tag { /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t _unused_14:3;            /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_UC_UC_C_tag;

typedef union eMIOS_UC_UC_S_union_tag { /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t _unused_16:15;           /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t _unused_3:12;            /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_UC_UC_S_tag;

typedef union eMIOS_UC_UC_ALTA_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;            /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_UC_UC_ALTA_tag;

typedef union eMIOS_UC_UC_C2_union_tag { /* eMIOS UC Control 2 register n */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;           /* Reserved. */
    vuint32_t UCEXTPRE:4;              /* Extended Prescaler bits */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t UCPRECLK:1;              /* Prescaler Clock select bit. */
    vuint32_t _unused_0:14;            /* Reserved. */
  } B;
} eMIOS_UC_UC_C2_tag;

typedef struct eMIOS_UC_UC_struct_tag {
  eMIOS_UC_UC_A_tag A;                 /* eMIOS UC A register n */
  eMIOS_UC_UC_B_tag B;                 /* eMIOS UC B register n */
  eMIOS_UC_UC_CNT_tag CNT;             /* eMIOS CNT register n */
  eMIOS_UC_UC_C_tag C;                 /* eMIOS UC Control register n */
  eMIOS_UC_UC_S_tag S;                 /* eMIOS UC Status register n */
  eMIOS_UC_UC_ALTA_tag ALTA;           /* eMIOS Alternate Address register n */
  eMIOS_UC_UC_C2_tag C2;               /* eMIOS UC Control 2 register n */
  uint8_t UC_reserved0[4];
} eMIOS_UC_UC_tag;

struct eMIOS_UC_tag {
  uint8_t eMIOS_UC_reserved0[32];
  eMIOS_UC_UC_tag UC[32];
};

#define ADC_0 (*(volatile struct ADC_tag *) 0xFFE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define AXBS_0 (*(volatile struct AXBS_tag *) 0xFC004000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_0_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFBEC0000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFFEC4000UL)
#define CAN_3 (*(volatile struct CAN_tag *) 0xFBEC4000UL)
#define CAN_4 (*(volatile struct CAN_tag *) 0xFFEC8000UL)
#define CAN_5 (*(volatile struct CAN_tag *) 0xFBEC8000UL)
#define CAN_6 (*(volatile struct CAN_tag *) 0xFFECC000UL)
#define CAN_7 (*(volatile struct CAN_tag *) 0xFBECC000UL)
#define CMP_0 (*(volatile struct CMP_tag *) 0xFFCDC000UL)
#define CMP_1 (*(volatile struct CMP_tag *) 0xFFCE0000UL)
#define CMP_2 (*(volatile struct CMP_tag *) 0xFFCE4000UL)
#define CMU (*(volatile struct CMU_tag *) 0xFFFB0140UL)
#define CRC (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define DMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define ENET (*(volatile struct ENET_tag *) 0xFFCC4000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FIRC (*(volatile struct FIRC_tag *) 0xFFFB0000UL)
#define FR (*(volatile struct FR_tag *) 0xFFE50000UL)
#define GPR (*(volatile struct GPR_tag *) 0xFFF94000UL)
#define HFInterface_0 (*(volatile struct HFInterface_tag *) 0xFFC28000UL)
#define HFInterface_1 (*(volatile struct HFInterface_tag *) 0xFFC2C000UL)
#define HFInterface_2 (*(volatile struct HFInterface_tag *) 0xFBC2C000UL)
#define HFInterface_3 (*(volatile struct HFInterface_tag *) 0xFBC28000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFFE6C000UL)
#define I2C_3 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define I2S_0 (*(volatile struct I2S_tag *) 0xFFCB4000UL)
#define I2S_1 (*(volatile struct I2S_tag *) 0xFBCB4000UL)
#define I2S_2 (*(volatile struct I2S_tag *) 0xFFCB8000UL)
#define IGF_0 (*(volatile struct IGF_tag *) 0xFFC1C000UL)
#define IGF_1 (*(volatile struct IGF_tag *) 0xFFC18000UL)
#define IGF_2 (*(volatile struct IGF_tag *) 0xFBC1C000UL)
#define IGF_3 (*(volatile struct IGF_tag *) 0xFBC18000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_10 (*(volatile struct LINFlexD_tag *) 0xFFEA0000UL)
#define LINFlexD_11 (*(volatile struct LINFlexD_tag *) 0xFBEA0000UL)
#define LINFlexD_12 (*(volatile struct LINFlexD_tag *) 0xFFEA4000UL)
#define LINFlexD_13 (*(volatile struct LINFlexD_tag *) 0xFBEA4000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_4 (*(volatile struct LINFlexD_tag *) 0xFFE94000UL)
#define LINFlexD_5 (*(volatile struct LINFlexD_tag *) 0xFBE94000UL)
#define LINFlexD_6 (*(volatile struct LINFlexD_tag *) 0xFFE98000UL)
#define LINFlexD_7 (*(volatile struct LINFlexD_tag *) 0xFBE98000UL)
#define LINFlexD_8 (*(volatile struct LINFlexD_tag *) 0xFFE9C000UL)
#define LINFlexD_9 (*(volatile struct LINFlexD_tag *) 0xFBE9C000UL)
#define LPU (*(volatile struct LPU_tag *) 0xFFF9C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU_0 (*(volatile struct MEMU_0_tag *) 0xFFF50000UL)
#define MEMU_1 (*(volatile struct MEMU_1_tag *) 0xFFFEC000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0080UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0xFC024000UL)
#define RTC (*(volatile struct RTC_tag *) 0xFFFF0000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIRC (*(volatile struct SIRC_tag *) 0xFFFB00C0UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0xFFFCC000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFBF9C000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFFFD0000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0xFBFA0000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SXOSC (*(volatile struct SXOSC_tag *) 0xFFFB0100UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0040UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFC38000UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xFBC38000UL)
#define eMIOS_UC_0 (*(volatile struct eMIOS_UC_tag *) 0xFFC38000UL)
#define eMIOS_UC_1 (*(volatile struct eMIOS_UC_tag *) 0xFBC38000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR2        ADC_0.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR5        ADC_0.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_0_CWSELR6        ADC_0.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_0_CWSELR7        ADC_0.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR2        ADC_1.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR5        ADC_1.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_1_CWSELR6        ADC_1.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_1_CWSELR7        ADC_1.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_MPRB          AIPS_A.MPRB.R                 /* Master Privilege Register B */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRE         AIPS_A.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRF         AIPS_A.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRG         AIPS_A.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRH         AIPS_A.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_MPRB          AIPS_B.MPRB.R                 /* Master Privilege Register B */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRE         AIPS_B.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRF         AIPS_B.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRG         AIPS_B.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRH         AIPS_B.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AXBS */
#define AXBS_0_PRS0          AXBS_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS0          AXBS_0.PORT[0].CRS.R          /* Control Register */
#define AXBS_0_PRS1          AXBS_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS1          AXBS_0.PORT[1].CRS.R          /* Control Register */
#define AXBS_0_PRS2          AXBS_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS2          AXBS_0.PORT[2].CRS.R          /* Control Register */
#define AXBS_0_PRS3          AXBS_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS3          AXBS_0.PORT[3].CRS.R          /* Control Register */
#define AXBS_0_PRS4          AXBS_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS4          AXBS_0.PORT[4].CRS.R          /* Control Register */
#define AXBS_0_PRS5          AXBS_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS5          AXBS_0.PORT[5].CRS.R          /* Control Register */
#define AXBS_0_PRS6          AXBS_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS6          AXBS_0.PORT[6].CRS.R          /* Control Register */
#define AXBS_0_PRS7          AXBS_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS7          AXBS_0.PORT[7].CRS.R          /* Control Register */
#define AXBS_0_MGPCR0        AXBS_0.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR1        AXBS_0.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR2        AXBS_0.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR3        AXBS_0.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR4        AXBS_0.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR5        AXBS_0.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR6        AXBS_0.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR7        AXBS_0.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_32       BCTU.TRGCFG[32].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_33       BCTU.TRGCFG[33].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_34       BCTU.TRGCFG[34].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_35       BCTU.TRGCFG[35].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_36       BCTU.TRGCFG[36].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_37       BCTU.TRGCFG[37].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_38       BCTU.TRGCFG[38].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_39       BCTU.TRGCFG[39].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_40       BCTU.TRGCFG[40].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_41       BCTU.TRGCFG[41].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_42       BCTU.TRGCFG[42].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_43       BCTU.TRGCFG[43].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_44       BCTU.TRGCFG[44].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_45       BCTU.TRGCFG[45].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_46       BCTU.TRGCFG[46].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_47       BCTU.TRGCFG[47].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_48       BCTU.TRGCFG[48].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_49       BCTU.TRGCFG[49].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_50       BCTU.TRGCFG[50].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_51       BCTU.TRGCFG[51].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_52       BCTU.TRGCFG[52].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_53       BCTU.TRGCFG[53].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_54       BCTU.TRGCFG[54].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_55       BCTU.TRGCFG[55].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_56       BCTU.TRGCFG[56].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_57       BCTU.TRGCFG[57].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_58       BCTU.TRGCFG[58].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_59       BCTU.TRGCFG[59].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_60       BCTU.TRGCFG[60].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_61       BCTU.TRGCFG[61].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_62       BCTU.TRGCFG[62].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_63       BCTU.TRGCFG[63].R             /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR2         BCTU.SFTRGR2.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR3         BCTU.SFTRGR3.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADC0DR.R                 /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADC1DR.R                 /* ADC1 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].R            /* LIST Channel Address Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN_0 */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_CTRL1_PN       CAN_0.CTRL1_PN.R              /* Pretended Networking Control 1 Register */
#define CAN_0_CTRL2_PN       CAN_0.CTRL2_PN.R              /* Pretended Networking Control 2 Register */
#define CAN_0_WU_MTC         CAN_0.WU_MTC.R                /* Pretended Networking Wake Up Match Register */
#define CAN_0_FLT_ID1        CAN_0.FLT_ID1.R               /* Pretended Networking ID Filter 1 Register */
#define CAN_0_FLT_DLC        CAN_0.FLT_DLC.R               /* Pretended Networking DLC Filter Register */
#define CAN_0_PL1_LO         CAN_0.PL1_LO.R                /* Pretended Networking Payload Low Filter 1 Register */
#define CAN_0_PL1_HI         CAN_0.PL1_HI.R                /* Pretended Networking Payload High Filter 1 Register */
#define CAN_0_FLT_ID2_IDMASK CAN_0.FLT_ID2_IDMASK.R        /* Pretended Networking ID Filter 2 Register / ID Mask Register */
#define CAN_0_PL2_PLMASK_LO  CAN_0.PL2_PLMASK_LO.R         /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
#define CAN_0_PL2_PLMASK_HI  CAN_0.PL2_PLMASK_HI.R         /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
#define CAN_0_WMB0_CS        CAN_0.WMB[0].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB0_ID        CAN_0.WMB[0].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB0_D03       CAN_0.WMB[0].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB0_D47       CAN_0.WMB[0].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB1_CS        CAN_0.WMB[1].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB1_ID        CAN_0.WMB[1].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB1_D03       CAN_0.WMB[1].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB1_D47       CAN_0.WMB[1].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB2_CS        CAN_0.WMB[2].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB2_ID        CAN_0.WMB[2].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB2_D03       CAN_0.WMB[2].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB2_D47       CAN_0.WMB[2].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB3_CS        CAN_0.WMB[3].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB3_ID        CAN_0.WMB[3].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB3_D03       CAN_0.WMB[3].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB3_D47       CAN_0.WMB[3].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CBT            CAN_1.CBT.R                   /* CAN Bit Timing Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_FDCTRL         CAN_1.FDCTRL.R                /* CAN FD Control Register */
#define CAN_1_FDCBT          CAN_1.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_1_FDCRC          CAN_1.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CBT            CAN_2.CBT.R                   /* CAN Bit Timing Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_FDCTRL         CAN_2.FDCTRL.R                /* CAN FD Control Register */
#define CAN_2_FDCBT          CAN_2.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_2_FDCRC          CAN_2.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CBT            CAN_3.CBT.R                   /* CAN Bit Timing Register */
#define CAN_3_CS0            CAN_3.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_3_ID0            CAN_3.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_3_B0             CAN_3.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_3_H0             CAN_3.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_3_W0             CAN_3.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_3_CS1            CAN_3.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_3_ID1            CAN_3.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_3_B1             CAN_3.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_3_H1             CAN_3.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_3_W1             CAN_3.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_3_CS2            CAN_3.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_3_ID2            CAN_3.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_3_B2             CAN_3.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_3_H2             CAN_3.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_3_W2             CAN_3.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_3_CS3            CAN_3.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_3_ID3            CAN_3.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_3_B3             CAN_3.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_3_H3             CAN_3.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_3_W3             CAN_3.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_3_CS4            CAN_3.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_3_ID4            CAN_3.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_3_B4             CAN_3.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_3_H4             CAN_3.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_3_W4             CAN_3.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_3_CS5            CAN_3.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_3_ID5            CAN_3.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_3_B5             CAN_3.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_3_H5             CAN_3.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_3_W5             CAN_3.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_3_CS6            CAN_3.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_3_ID6            CAN_3.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_3_B6             CAN_3.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_3_H6             CAN_3.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_3_W6             CAN_3.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_3_CS7            CAN_3.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_3_ID7            CAN_3.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_3_B7             CAN_3.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_3_H7             CAN_3.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_3_W7             CAN_3.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_3_CS8            CAN_3.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_3_ID8            CAN_3.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_3_B8             CAN_3.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_3_H8             CAN_3.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_3_W8             CAN_3.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_3_CS9            CAN_3.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_3_ID9            CAN_3.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_3_B9             CAN_3.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_3_H9             CAN_3.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_3_W9             CAN_3.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_3_CS10           CAN_3.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_3_ID10           CAN_3.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_3_B10            CAN_3.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_3_H10            CAN_3.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_3_W10            CAN_3.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_3_CS11           CAN_3.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_3_ID11           CAN_3.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_3_B11            CAN_3.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_3_H11            CAN_3.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_3_W11            CAN_3.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_3_CS12           CAN_3.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_3_ID12           CAN_3.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_3_B12            CAN_3.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_3_H12            CAN_3.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_3_W12            CAN_3.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_3_CS13           CAN_3.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_3_ID13           CAN_3.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_3_B13            CAN_3.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_3_H13            CAN_3.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_3_W13            CAN_3.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_3_CS14           CAN_3.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_3_ID14           CAN_3.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_3_B14            CAN_3.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_3_H14            CAN_3.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_3_W14            CAN_3.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_3_CS15           CAN_3.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_3_ID15           CAN_3.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_3_B15            CAN_3.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_3_H15            CAN_3.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_3_W15            CAN_3.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_3_CS16           CAN_3.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_3_ID16           CAN_3.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_3_B16            CAN_3.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_3_H16            CAN_3.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_3_W16            CAN_3.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_3_CS17           CAN_3.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_3_ID17           CAN_3.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_3_B17            CAN_3.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_3_H17            CAN_3.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_3_W17            CAN_3.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_3_CS18           CAN_3.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_3_ID18           CAN_3.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_3_B18            CAN_3.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_3_H18            CAN_3.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_3_W18            CAN_3.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_3_CS19           CAN_3.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_3_ID19           CAN_3.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_3_B19            CAN_3.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_3_H19            CAN_3.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_3_W19            CAN_3.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_3_CS20           CAN_3.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_3_ID20           CAN_3.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_3_B20            CAN_3.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_3_H20            CAN_3.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_3_W20            CAN_3.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_3_CS21           CAN_3.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_3_ID21           CAN_3.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_3_B21            CAN_3.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_3_H21            CAN_3.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_3_W21            CAN_3.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_3_CS22           CAN_3.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_3_ID22           CAN_3.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_3_B22            CAN_3.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_3_H22            CAN_3.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_3_W22            CAN_3.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_3_CS23           CAN_3.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_3_ID23           CAN_3.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_3_B23            CAN_3.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_3_H23            CAN_3.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_3_W23            CAN_3.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_3_CS24           CAN_3.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_3_ID24           CAN_3.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_3_B24            CAN_3.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_3_H24            CAN_3.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_3_W24            CAN_3.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_3_CS25           CAN_3.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_3_ID25           CAN_3.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_3_B25            CAN_3.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_3_H25            CAN_3.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_3_W25            CAN_3.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_3_CS26           CAN_3.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_3_ID26           CAN_3.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_3_B26            CAN_3.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_3_H26            CAN_3.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_3_W26            CAN_3.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_3_CS27           CAN_3.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_3_ID27           CAN_3.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_3_B27            CAN_3.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_3_H27            CAN_3.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_3_W27            CAN_3.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_3_CS28           CAN_3.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_3_ID28           CAN_3.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_3_B28            CAN_3.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_3_H28            CAN_3.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_3_W28            CAN_3.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_3_CS29           CAN_3.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_3_ID29           CAN_3.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_3_B29            CAN_3.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_3_H29            CAN_3.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_3_W29            CAN_3.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_3_CS30           CAN_3.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_3_ID30           CAN_3.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_3_B30            CAN_3.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_3_H30            CAN_3.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_3_W30            CAN_3.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_3_CS31           CAN_3.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_3_ID31           CAN_3.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_3_B31            CAN_3.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_3_H31            CAN_3.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_3_W31            CAN_3.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_3_CS32           CAN_3.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_3_ID32           CAN_3.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_3_B32            CAN_3.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_3_H32            CAN_3.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_3_W32            CAN_3.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_3_CS33           CAN_3.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_3_ID33           CAN_3.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_3_B33            CAN_3.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_3_H33            CAN_3.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_3_W33            CAN_3.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_3_CS34           CAN_3.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_3_ID34           CAN_3.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_3_B34            CAN_3.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_3_H34            CAN_3.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_3_W34            CAN_3.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_3_CS35           CAN_3.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_3_ID35           CAN_3.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_3_B35            CAN_3.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_3_H35            CAN_3.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_3_W35            CAN_3.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_3_CS36           CAN_3.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_3_ID36           CAN_3.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_3_B36            CAN_3.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_3_H36            CAN_3.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_3_W36            CAN_3.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_3_CS37           CAN_3.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_3_ID37           CAN_3.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_3_B37            CAN_3.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_3_H37            CAN_3.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_3_W37            CAN_3.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_3_CS38           CAN_3.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_3_ID38           CAN_3.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_3_B38            CAN_3.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_3_H38            CAN_3.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_3_W38            CAN_3.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_3_CS39           CAN_3.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_3_ID39           CAN_3.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_3_B39            CAN_3.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_3_H39            CAN_3.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_3_W39            CAN_3.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_3_CS40           CAN_3.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_3_ID40           CAN_3.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_3_B40            CAN_3.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_3_H40            CAN_3.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_3_W40            CAN_3.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_3_CS41           CAN_3.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_3_ID41           CAN_3.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_3_B41            CAN_3.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_3_H41            CAN_3.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_3_W41            CAN_3.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_3_CS42           CAN_3.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_3_ID42           CAN_3.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_3_B42            CAN_3.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_3_H42            CAN_3.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_3_W42            CAN_3.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_3_CS43           CAN_3.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_3_ID43           CAN_3.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_3_B43            CAN_3.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_3_H43            CAN_3.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_3_W43            CAN_3.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_3_CS44           CAN_3.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_3_ID44           CAN_3.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_3_B44            CAN_3.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_3_H44            CAN_3.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_3_W44            CAN_3.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_3_CS45           CAN_3.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_3_ID45           CAN_3.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_3_B45            CAN_3.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_3_H45            CAN_3.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_3_W45            CAN_3.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_3_CS46           CAN_3.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_3_ID46           CAN_3.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_3_B46            CAN_3.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_3_H46            CAN_3.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_3_W46            CAN_3.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_3_CS47           CAN_3.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_3_ID47           CAN_3.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_3_B47            CAN_3.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_3_H47            CAN_3.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_3_W47            CAN_3.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_3_CS48           CAN_3.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_3_ID48           CAN_3.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_3_B48            CAN_3.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_3_H48            CAN_3.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_3_W48            CAN_3.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_3_CS49           CAN_3.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_3_ID49           CAN_3.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_3_B49            CAN_3.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_3_H49            CAN_3.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_3_W49            CAN_3.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_3_CS50           CAN_3.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_3_ID50           CAN_3.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_3_B50            CAN_3.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_3_H50            CAN_3.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_3_W50            CAN_3.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_3_CS51           CAN_3.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_3_ID51           CAN_3.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_3_B51            CAN_3.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_3_H51            CAN_3.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_3_W51            CAN_3.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_3_CS52           CAN_3.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_3_ID52           CAN_3.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_3_B52            CAN_3.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_3_H52            CAN_3.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_3_W52            CAN_3.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_3_CS53           CAN_3.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_3_ID53           CAN_3.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_3_B53            CAN_3.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_3_H53            CAN_3.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_3_W53            CAN_3.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_3_CS54           CAN_3.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_3_ID54           CAN_3.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_3_B54            CAN_3.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_3_H54            CAN_3.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_3_W54            CAN_3.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_3_CS55           CAN_3.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_3_ID55           CAN_3.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_3_B55            CAN_3.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_3_H55            CAN_3.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_3_W55            CAN_3.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_3_CS56           CAN_3.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_3_ID56           CAN_3.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_3_B56            CAN_3.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_3_H56            CAN_3.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_3_W56            CAN_3.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_3_CS57           CAN_3.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_3_ID57           CAN_3.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_3_B57            CAN_3.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_3_H57            CAN_3.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_3_W57            CAN_3.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_3_CS58           CAN_3.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_3_ID58           CAN_3.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_3_B58            CAN_3.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_3_H58            CAN_3.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_3_W58            CAN_3.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_3_CS59           CAN_3.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_3_ID59           CAN_3.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_3_B59            CAN_3.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_3_H59            CAN_3.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_3_W59            CAN_3.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_3_CS60           CAN_3.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_3_ID60           CAN_3.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_3_B60            CAN_3.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_3_H60            CAN_3.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_3_W60            CAN_3.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_3_CS61           CAN_3.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_3_ID61           CAN_3.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_3_B61            CAN_3.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_3_H61            CAN_3.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_3_W61            CAN_3.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_3_CS62           CAN_3.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_3_ID62           CAN_3.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_3_B62            CAN_3.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_3_H62            CAN_3.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_3_W62            CAN_3.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_3_CS63           CAN_3.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_3_ID63           CAN_3.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_3_B63            CAN_3.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_3_H63            CAN_3.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_3_W63            CAN_3.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_FDCTRL         CAN_3.FDCTRL.R                /* CAN FD Control Register */
#define CAN_3_FDCBT          CAN_3.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_3_FDCRC          CAN_3.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_4_MCR            CAN_4.MCR.R                   /* Module Configuration Register */
#define CAN_4_CTRL1          CAN_4.CTRL1.R                 /* Control 1 register */
#define CAN_4_TIMER          CAN_4.TIMER.R                 /* Free Running Timer */
#define CAN_4_RXMGMASK       CAN_4.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_4_RX14MASK       CAN_4.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_4_RX15MASK       CAN_4.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_4_ECR            CAN_4.ECR.R                   /* Error Counter */
#define CAN_4_ESR1           CAN_4.ESR1.R                  /* Error and Status 1 register */
#define CAN_4_IMASK2         CAN_4.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_4_IMASK1         CAN_4.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_4_IFLAG2         CAN_4.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_4_IFLAG1         CAN_4.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_4_CTRL2          CAN_4.CTRL2.R                 /* Control 2 register */
#define CAN_4_ESR2           CAN_4.ESR2.R                  /* Error and Status 2 register */
#define CAN_4_CRCR           CAN_4.CRCR.R                  /* CRC Register */
#define CAN_4_RXFGMASK       CAN_4.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_4_RXFIR          CAN_4.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_4_CBT            CAN_4.CBT.R                   /* CAN Bit Timing Register */
#define CAN_4_CS0            CAN_4.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_4_ID0            CAN_4.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_4_B0             CAN_4.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_4_H0             CAN_4.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_4_W0             CAN_4.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_4_CS1            CAN_4.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_4_ID1            CAN_4.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_4_B1             CAN_4.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_4_H1             CAN_4.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_4_W1             CAN_4.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_4_CS2            CAN_4.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_4_ID2            CAN_4.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_4_B2             CAN_4.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_4_H2             CAN_4.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_4_W2             CAN_4.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_4_CS3            CAN_4.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_4_ID3            CAN_4.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_4_B3             CAN_4.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_4_H3             CAN_4.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_4_W3             CAN_4.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_4_CS4            CAN_4.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_4_ID4            CAN_4.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_4_B4             CAN_4.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_4_H4             CAN_4.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_4_W4             CAN_4.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_4_CS5            CAN_4.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_4_ID5            CAN_4.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_4_B5             CAN_4.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_4_H5             CAN_4.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_4_W5             CAN_4.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_4_CS6            CAN_4.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_4_ID6            CAN_4.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_4_B6             CAN_4.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_4_H6             CAN_4.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_4_W6             CAN_4.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_4_CS7            CAN_4.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_4_ID7            CAN_4.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_4_B7             CAN_4.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_4_H7             CAN_4.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_4_W7             CAN_4.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_4_CS8            CAN_4.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_4_ID8            CAN_4.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_4_B8             CAN_4.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_4_H8             CAN_4.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_4_W8             CAN_4.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_4_CS9            CAN_4.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_4_ID9            CAN_4.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_4_B9             CAN_4.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_4_H9             CAN_4.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_4_W9             CAN_4.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_4_CS10           CAN_4.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_4_ID10           CAN_4.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_4_B10            CAN_4.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_4_H10            CAN_4.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_4_W10            CAN_4.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_4_CS11           CAN_4.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_4_ID11           CAN_4.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_4_B11            CAN_4.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_4_H11            CAN_4.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_4_W11            CAN_4.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_4_CS12           CAN_4.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_4_ID12           CAN_4.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_4_B12            CAN_4.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_4_H12            CAN_4.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_4_W12            CAN_4.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_4_CS13           CAN_4.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_4_ID13           CAN_4.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_4_B13            CAN_4.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_4_H13            CAN_4.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_4_W13            CAN_4.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_4_CS14           CAN_4.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_4_ID14           CAN_4.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_4_B14            CAN_4.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_4_H14            CAN_4.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_4_W14            CAN_4.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_4_CS15           CAN_4.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_4_ID15           CAN_4.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_4_B15            CAN_4.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_4_H15            CAN_4.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_4_W15            CAN_4.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_4_CS16           CAN_4.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_4_ID16           CAN_4.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_4_B16            CAN_4.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_4_H16            CAN_4.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_4_W16            CAN_4.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_4_CS17           CAN_4.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_4_ID17           CAN_4.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_4_B17            CAN_4.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_4_H17            CAN_4.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_4_W17            CAN_4.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_4_CS18           CAN_4.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_4_ID18           CAN_4.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_4_B18            CAN_4.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_4_H18            CAN_4.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_4_W18            CAN_4.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_4_CS19           CAN_4.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_4_ID19           CAN_4.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_4_B19            CAN_4.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_4_H19            CAN_4.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_4_W19            CAN_4.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_4_CS20           CAN_4.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_4_ID20           CAN_4.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_4_B20            CAN_4.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_4_H20            CAN_4.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_4_W20            CAN_4.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_4_CS21           CAN_4.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_4_ID21           CAN_4.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_4_B21            CAN_4.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_4_H21            CAN_4.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_4_W21            CAN_4.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_4_CS22           CAN_4.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_4_ID22           CAN_4.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_4_B22            CAN_4.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_4_H22            CAN_4.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_4_W22            CAN_4.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_4_CS23           CAN_4.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_4_ID23           CAN_4.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_4_B23            CAN_4.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_4_H23            CAN_4.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_4_W23            CAN_4.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_4_CS24           CAN_4.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_4_ID24           CAN_4.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_4_B24            CAN_4.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_4_H24            CAN_4.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_4_W24            CAN_4.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_4_CS25           CAN_4.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_4_ID25           CAN_4.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_4_B25            CAN_4.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_4_H25            CAN_4.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_4_W25            CAN_4.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_4_CS26           CAN_4.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_4_ID26           CAN_4.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_4_B26            CAN_4.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_4_H26            CAN_4.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_4_W26            CAN_4.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_4_CS27           CAN_4.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_4_ID27           CAN_4.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_4_B27            CAN_4.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_4_H27            CAN_4.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_4_W27            CAN_4.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_4_CS28           CAN_4.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_4_ID28           CAN_4.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_4_B28            CAN_4.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_4_H28            CAN_4.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_4_W28            CAN_4.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_4_CS29           CAN_4.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_4_ID29           CAN_4.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_4_B29            CAN_4.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_4_H29            CAN_4.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_4_W29            CAN_4.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_4_CS30           CAN_4.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_4_ID30           CAN_4.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_4_B30            CAN_4.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_4_H30            CAN_4.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_4_W30            CAN_4.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_4_CS31           CAN_4.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_4_ID31           CAN_4.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_4_B31            CAN_4.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_4_H31            CAN_4.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_4_W31            CAN_4.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_4_CS32           CAN_4.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_4_ID32           CAN_4.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_4_B32            CAN_4.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_4_H32            CAN_4.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_4_W32            CAN_4.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_4_CS33           CAN_4.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_4_ID33           CAN_4.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_4_B33            CAN_4.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_4_H33            CAN_4.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_4_W33            CAN_4.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_4_CS34           CAN_4.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_4_ID34           CAN_4.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_4_B34            CAN_4.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_4_H34            CAN_4.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_4_W34            CAN_4.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_4_CS35           CAN_4.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_4_ID35           CAN_4.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_4_B35            CAN_4.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_4_H35            CAN_4.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_4_W35            CAN_4.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_4_CS36           CAN_4.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_4_ID36           CAN_4.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_4_B36            CAN_4.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_4_H36            CAN_4.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_4_W36            CAN_4.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_4_CS37           CAN_4.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_4_ID37           CAN_4.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_4_B37            CAN_4.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_4_H37            CAN_4.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_4_W37            CAN_4.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_4_CS38           CAN_4.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_4_ID38           CAN_4.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_4_B38            CAN_4.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_4_H38            CAN_4.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_4_W38            CAN_4.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_4_CS39           CAN_4.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_4_ID39           CAN_4.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_4_B39            CAN_4.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_4_H39            CAN_4.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_4_W39            CAN_4.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_4_CS40           CAN_4.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_4_ID40           CAN_4.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_4_B40            CAN_4.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_4_H40            CAN_4.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_4_W40            CAN_4.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_4_CS41           CAN_4.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_4_ID41           CAN_4.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_4_B41            CAN_4.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_4_H41            CAN_4.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_4_W41            CAN_4.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_4_CS42           CAN_4.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_4_ID42           CAN_4.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_4_B42            CAN_4.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_4_H42            CAN_4.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_4_W42            CAN_4.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_4_CS43           CAN_4.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_4_ID43           CAN_4.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_4_B43            CAN_4.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_4_H43            CAN_4.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_4_W43            CAN_4.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_4_CS44           CAN_4.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_4_ID44           CAN_4.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_4_B44            CAN_4.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_4_H44            CAN_4.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_4_W44            CAN_4.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_4_CS45           CAN_4.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_4_ID45           CAN_4.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_4_B45            CAN_4.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_4_H45            CAN_4.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_4_W45            CAN_4.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_4_CS46           CAN_4.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_4_ID46           CAN_4.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_4_B46            CAN_4.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_4_H46            CAN_4.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_4_W46            CAN_4.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_4_CS47           CAN_4.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_4_ID47           CAN_4.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_4_B47            CAN_4.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_4_H47            CAN_4.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_4_W47            CAN_4.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_4_CS48           CAN_4.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_4_ID48           CAN_4.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_4_B48            CAN_4.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_4_H48            CAN_4.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_4_W48            CAN_4.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_4_CS49           CAN_4.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_4_ID49           CAN_4.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_4_B49            CAN_4.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_4_H49            CAN_4.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_4_W49            CAN_4.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_4_CS50           CAN_4.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_4_ID50           CAN_4.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_4_B50            CAN_4.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_4_H50            CAN_4.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_4_W50            CAN_4.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_4_CS51           CAN_4.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_4_ID51           CAN_4.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_4_B51            CAN_4.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_4_H51            CAN_4.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_4_W51            CAN_4.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_4_CS52           CAN_4.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_4_ID52           CAN_4.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_4_B52            CAN_4.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_4_H52            CAN_4.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_4_W52            CAN_4.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_4_CS53           CAN_4.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_4_ID53           CAN_4.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_4_B53            CAN_4.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_4_H53            CAN_4.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_4_W53            CAN_4.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_4_CS54           CAN_4.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_4_ID54           CAN_4.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_4_B54            CAN_4.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_4_H54            CAN_4.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_4_W54            CAN_4.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_4_CS55           CAN_4.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_4_ID55           CAN_4.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_4_B55            CAN_4.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_4_H55            CAN_4.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_4_W55            CAN_4.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_4_CS56           CAN_4.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_4_ID56           CAN_4.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_4_B56            CAN_4.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_4_H56            CAN_4.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_4_W56            CAN_4.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_4_CS57           CAN_4.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_4_ID57           CAN_4.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_4_B57            CAN_4.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_4_H57            CAN_4.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_4_W57            CAN_4.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_4_CS58           CAN_4.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_4_ID58           CAN_4.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_4_B58            CAN_4.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_4_H58            CAN_4.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_4_W58            CAN_4.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_4_CS59           CAN_4.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_4_ID59           CAN_4.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_4_B59            CAN_4.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_4_H59            CAN_4.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_4_W59            CAN_4.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_4_CS60           CAN_4.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_4_ID60           CAN_4.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_4_B60            CAN_4.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_4_H60            CAN_4.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_4_W60            CAN_4.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_4_CS61           CAN_4.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_4_ID61           CAN_4.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_4_B61            CAN_4.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_4_H61            CAN_4.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_4_W61            CAN_4.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_4_CS62           CAN_4.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_4_ID62           CAN_4.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_4_B62            CAN_4.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_4_H62            CAN_4.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_4_W62            CAN_4.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_4_CS63           CAN_4.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_4_ID63           CAN_4.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_4_B63            CAN_4.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_4_H63            CAN_4.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_4_W63            CAN_4.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_4_RXIMR0         CAN_4.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR1         CAN_4.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR2         CAN_4.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR3         CAN_4.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR4         CAN_4.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR5         CAN_4.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR6         CAN_4.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR7         CAN_4.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR8         CAN_4.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR9         CAN_4.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR10        CAN_4.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR11        CAN_4.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR12        CAN_4.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR13        CAN_4.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR14        CAN_4.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR15        CAN_4.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR16        CAN_4.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR17        CAN_4.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR18        CAN_4.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR19        CAN_4.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR20        CAN_4.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR21        CAN_4.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR22        CAN_4.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR23        CAN_4.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR24        CAN_4.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR25        CAN_4.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR26        CAN_4.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR27        CAN_4.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR28        CAN_4.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR29        CAN_4.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR30        CAN_4.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR31        CAN_4.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR32        CAN_4.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR33        CAN_4.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR34        CAN_4.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR35        CAN_4.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR36        CAN_4.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR37        CAN_4.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR38        CAN_4.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR39        CAN_4.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR40        CAN_4.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR41        CAN_4.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR42        CAN_4.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR43        CAN_4.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR44        CAN_4.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR45        CAN_4.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR46        CAN_4.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR47        CAN_4.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR48        CAN_4.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR49        CAN_4.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR50        CAN_4.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR51        CAN_4.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR52        CAN_4.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR53        CAN_4.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR54        CAN_4.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR55        CAN_4.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR56        CAN_4.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR57        CAN_4.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR58        CAN_4.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR59        CAN_4.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR60        CAN_4.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR61        CAN_4.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR62        CAN_4.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR63        CAN_4.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_4_FDCTRL         CAN_4.FDCTRL.R                /* CAN FD Control Register */
#define CAN_4_FDCBT          CAN_4.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_4_FDCRC          CAN_4.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_5_MCR            CAN_5.MCR.R                   /* Module Configuration Register */
#define CAN_5_CTRL1          CAN_5.CTRL1.R                 /* Control 1 register */
#define CAN_5_TIMER          CAN_5.TIMER.R                 /* Free Running Timer */
#define CAN_5_RXMGMASK       CAN_5.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_5_RX14MASK       CAN_5.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_5_RX15MASK       CAN_5.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_5_ECR            CAN_5.ECR.R                   /* Error Counter */
#define CAN_5_ESR1           CAN_5.ESR1.R                  /* Error and Status 1 register */
#define CAN_5_IMASK2         CAN_5.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_5_IMASK1         CAN_5.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_5_IFLAG2         CAN_5.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_5_IFLAG1         CAN_5.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_5_CTRL2          CAN_5.CTRL2.R                 /* Control 2 register */
#define CAN_5_ESR2           CAN_5.ESR2.R                  /* Error and Status 2 register */
#define CAN_5_CRCR           CAN_5.CRCR.R                  /* CRC Register */
#define CAN_5_RXFGMASK       CAN_5.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_5_RXFIR          CAN_5.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_5_CBT            CAN_5.CBT.R                   /* CAN Bit Timing Register */
#define CAN_5_CS0            CAN_5.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_5_ID0            CAN_5.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_5_B0             CAN_5.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_5_H0             CAN_5.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_5_W0             CAN_5.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_5_CS1            CAN_5.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_5_ID1            CAN_5.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_5_B1             CAN_5.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_5_H1             CAN_5.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_5_W1             CAN_5.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_5_CS2            CAN_5.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_5_ID2            CAN_5.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_5_B2             CAN_5.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_5_H2             CAN_5.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_5_W2             CAN_5.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_5_CS3            CAN_5.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_5_ID3            CAN_5.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_5_B3             CAN_5.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_5_H3             CAN_5.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_5_W3             CAN_5.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_5_CS4            CAN_5.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_5_ID4            CAN_5.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_5_B4             CAN_5.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_5_H4             CAN_5.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_5_W4             CAN_5.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_5_CS5            CAN_5.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_5_ID5            CAN_5.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_5_B5             CAN_5.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_5_H5             CAN_5.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_5_W5             CAN_5.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_5_CS6            CAN_5.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_5_ID6            CAN_5.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_5_B6             CAN_5.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_5_H6             CAN_5.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_5_W6             CAN_5.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_5_CS7            CAN_5.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_5_ID7            CAN_5.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_5_B7             CAN_5.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_5_H7             CAN_5.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_5_W7             CAN_5.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_5_CS8            CAN_5.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_5_ID8            CAN_5.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_5_B8             CAN_5.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_5_H8             CAN_5.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_5_W8             CAN_5.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_5_CS9            CAN_5.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_5_ID9            CAN_5.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_5_B9             CAN_5.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_5_H9             CAN_5.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_5_W9             CAN_5.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_5_CS10           CAN_5.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_5_ID10           CAN_5.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_5_B10            CAN_5.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_5_H10            CAN_5.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_5_W10            CAN_5.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_5_CS11           CAN_5.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_5_ID11           CAN_5.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_5_B11            CAN_5.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_5_H11            CAN_5.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_5_W11            CAN_5.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_5_CS12           CAN_5.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_5_ID12           CAN_5.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_5_B12            CAN_5.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_5_H12            CAN_5.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_5_W12            CAN_5.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_5_CS13           CAN_5.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_5_ID13           CAN_5.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_5_B13            CAN_5.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_5_H13            CAN_5.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_5_W13            CAN_5.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_5_CS14           CAN_5.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_5_ID14           CAN_5.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_5_B14            CAN_5.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_5_H14            CAN_5.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_5_W14            CAN_5.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_5_CS15           CAN_5.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_5_ID15           CAN_5.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_5_B15            CAN_5.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_5_H15            CAN_5.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_5_W15            CAN_5.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_5_CS16           CAN_5.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_5_ID16           CAN_5.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_5_B16            CAN_5.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_5_H16            CAN_5.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_5_W16            CAN_5.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_5_CS17           CAN_5.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_5_ID17           CAN_5.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_5_B17            CAN_5.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_5_H17            CAN_5.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_5_W17            CAN_5.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_5_CS18           CAN_5.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_5_ID18           CAN_5.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_5_B18            CAN_5.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_5_H18            CAN_5.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_5_W18            CAN_5.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_5_CS19           CAN_5.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_5_ID19           CAN_5.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_5_B19            CAN_5.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_5_H19            CAN_5.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_5_W19            CAN_5.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_5_CS20           CAN_5.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_5_ID20           CAN_5.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_5_B20            CAN_5.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_5_H20            CAN_5.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_5_W20            CAN_5.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_5_CS21           CAN_5.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_5_ID21           CAN_5.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_5_B21            CAN_5.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_5_H21            CAN_5.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_5_W21            CAN_5.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_5_CS22           CAN_5.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_5_ID22           CAN_5.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_5_B22            CAN_5.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_5_H22            CAN_5.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_5_W22            CAN_5.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_5_CS23           CAN_5.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_5_ID23           CAN_5.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_5_B23            CAN_5.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_5_H23            CAN_5.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_5_W23            CAN_5.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_5_CS24           CAN_5.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_5_ID24           CAN_5.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_5_B24            CAN_5.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_5_H24            CAN_5.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_5_W24            CAN_5.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_5_CS25           CAN_5.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_5_ID25           CAN_5.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_5_B25            CAN_5.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_5_H25            CAN_5.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_5_W25            CAN_5.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_5_CS26           CAN_5.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_5_ID26           CAN_5.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_5_B26            CAN_5.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_5_H26            CAN_5.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_5_W26            CAN_5.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_5_CS27           CAN_5.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_5_ID27           CAN_5.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_5_B27            CAN_5.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_5_H27            CAN_5.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_5_W27            CAN_5.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_5_CS28           CAN_5.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_5_ID28           CAN_5.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_5_B28            CAN_5.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_5_H28            CAN_5.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_5_W28            CAN_5.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_5_CS29           CAN_5.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_5_ID29           CAN_5.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_5_B29            CAN_5.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_5_H29            CAN_5.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_5_W29            CAN_5.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_5_CS30           CAN_5.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_5_ID30           CAN_5.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_5_B30            CAN_5.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_5_H30            CAN_5.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_5_W30            CAN_5.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_5_CS31           CAN_5.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_5_ID31           CAN_5.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_5_B31            CAN_5.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_5_H31            CAN_5.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_5_W31            CAN_5.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_5_CS32           CAN_5.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_5_ID32           CAN_5.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_5_B32            CAN_5.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_5_H32            CAN_5.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_5_W32            CAN_5.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_5_CS33           CAN_5.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_5_ID33           CAN_5.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_5_B33            CAN_5.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_5_H33            CAN_5.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_5_W33            CAN_5.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_5_CS34           CAN_5.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_5_ID34           CAN_5.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_5_B34            CAN_5.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_5_H34            CAN_5.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_5_W34            CAN_5.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_5_CS35           CAN_5.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_5_ID35           CAN_5.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_5_B35            CAN_5.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_5_H35            CAN_5.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_5_W35            CAN_5.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_5_CS36           CAN_5.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_5_ID36           CAN_5.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_5_B36            CAN_5.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_5_H36            CAN_5.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_5_W36            CAN_5.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_5_CS37           CAN_5.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_5_ID37           CAN_5.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_5_B37            CAN_5.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_5_H37            CAN_5.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_5_W37            CAN_5.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_5_CS38           CAN_5.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_5_ID38           CAN_5.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_5_B38            CAN_5.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_5_H38            CAN_5.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_5_W38            CAN_5.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_5_CS39           CAN_5.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_5_ID39           CAN_5.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_5_B39            CAN_5.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_5_H39            CAN_5.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_5_W39            CAN_5.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_5_CS40           CAN_5.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_5_ID40           CAN_5.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_5_B40            CAN_5.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_5_H40            CAN_5.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_5_W40            CAN_5.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_5_CS41           CAN_5.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_5_ID41           CAN_5.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_5_B41            CAN_5.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_5_H41            CAN_5.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_5_W41            CAN_5.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_5_CS42           CAN_5.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_5_ID42           CAN_5.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_5_B42            CAN_5.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_5_H42            CAN_5.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_5_W42            CAN_5.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_5_CS43           CAN_5.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_5_ID43           CAN_5.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_5_B43            CAN_5.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_5_H43            CAN_5.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_5_W43            CAN_5.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_5_CS44           CAN_5.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_5_ID44           CAN_5.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_5_B44            CAN_5.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_5_H44            CAN_5.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_5_W44            CAN_5.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_5_CS45           CAN_5.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_5_ID45           CAN_5.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_5_B45            CAN_5.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_5_H45            CAN_5.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_5_W45            CAN_5.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_5_CS46           CAN_5.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_5_ID46           CAN_5.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_5_B46            CAN_5.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_5_H46            CAN_5.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_5_W46            CAN_5.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_5_CS47           CAN_5.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_5_ID47           CAN_5.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_5_B47            CAN_5.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_5_H47            CAN_5.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_5_W47            CAN_5.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_5_CS48           CAN_5.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_5_ID48           CAN_5.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_5_B48            CAN_5.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_5_H48            CAN_5.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_5_W48            CAN_5.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_5_CS49           CAN_5.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_5_ID49           CAN_5.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_5_B49            CAN_5.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_5_H49            CAN_5.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_5_W49            CAN_5.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_5_CS50           CAN_5.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_5_ID50           CAN_5.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_5_B50            CAN_5.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_5_H50            CAN_5.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_5_W50            CAN_5.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_5_CS51           CAN_5.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_5_ID51           CAN_5.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_5_B51            CAN_5.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_5_H51            CAN_5.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_5_W51            CAN_5.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_5_CS52           CAN_5.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_5_ID52           CAN_5.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_5_B52            CAN_5.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_5_H52            CAN_5.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_5_W52            CAN_5.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_5_CS53           CAN_5.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_5_ID53           CAN_5.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_5_B53            CAN_5.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_5_H53            CAN_5.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_5_W53            CAN_5.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_5_CS54           CAN_5.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_5_ID54           CAN_5.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_5_B54            CAN_5.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_5_H54            CAN_5.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_5_W54            CAN_5.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_5_CS55           CAN_5.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_5_ID55           CAN_5.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_5_B55            CAN_5.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_5_H55            CAN_5.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_5_W55            CAN_5.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_5_CS56           CAN_5.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_5_ID56           CAN_5.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_5_B56            CAN_5.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_5_H56            CAN_5.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_5_W56            CAN_5.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_5_CS57           CAN_5.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_5_ID57           CAN_5.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_5_B57            CAN_5.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_5_H57            CAN_5.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_5_W57            CAN_5.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_5_CS58           CAN_5.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_5_ID58           CAN_5.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_5_B58            CAN_5.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_5_H58            CAN_5.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_5_W58            CAN_5.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_5_CS59           CAN_5.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_5_ID59           CAN_5.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_5_B59            CAN_5.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_5_H59            CAN_5.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_5_W59            CAN_5.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_5_CS60           CAN_5.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_5_ID60           CAN_5.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_5_B60            CAN_5.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_5_H60            CAN_5.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_5_W60            CAN_5.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_5_CS61           CAN_5.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_5_ID61           CAN_5.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_5_B61            CAN_5.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_5_H61            CAN_5.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_5_W61            CAN_5.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_5_CS62           CAN_5.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_5_ID62           CAN_5.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_5_B62            CAN_5.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_5_H62            CAN_5.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_5_W62            CAN_5.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_5_CS63           CAN_5.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_5_ID63           CAN_5.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_5_B63            CAN_5.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_5_H63            CAN_5.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_5_W63            CAN_5.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_5_RXIMR0         CAN_5.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR1         CAN_5.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR2         CAN_5.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR3         CAN_5.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR4         CAN_5.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR5         CAN_5.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR6         CAN_5.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR7         CAN_5.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR8         CAN_5.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR9         CAN_5.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR10        CAN_5.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR11        CAN_5.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR12        CAN_5.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR13        CAN_5.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR14        CAN_5.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR15        CAN_5.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR16        CAN_5.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR17        CAN_5.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR18        CAN_5.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR19        CAN_5.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR20        CAN_5.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR21        CAN_5.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR22        CAN_5.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR23        CAN_5.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR24        CAN_5.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR25        CAN_5.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR26        CAN_5.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR27        CAN_5.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR28        CAN_5.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR29        CAN_5.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR30        CAN_5.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR31        CAN_5.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR32        CAN_5.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR33        CAN_5.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR34        CAN_5.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR35        CAN_5.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR36        CAN_5.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR37        CAN_5.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR38        CAN_5.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR39        CAN_5.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR40        CAN_5.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR41        CAN_5.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR42        CAN_5.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR43        CAN_5.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR44        CAN_5.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR45        CAN_5.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR46        CAN_5.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR47        CAN_5.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR48        CAN_5.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR49        CAN_5.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR50        CAN_5.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR51        CAN_5.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR52        CAN_5.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR53        CAN_5.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR54        CAN_5.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR55        CAN_5.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR56        CAN_5.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR57        CAN_5.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR58        CAN_5.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR59        CAN_5.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR60        CAN_5.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR61        CAN_5.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR62        CAN_5.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR63        CAN_5.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_5_FDCTRL         CAN_5.FDCTRL.R                /* CAN FD Control Register */
#define CAN_5_FDCBT          CAN_5.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_5_FDCRC          CAN_5.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_6_MCR            CAN_6.MCR.R                   /* Module Configuration Register */
#define CAN_6_CTRL1          CAN_6.CTRL1.R                 /* Control 1 register */
#define CAN_6_TIMER          CAN_6.TIMER.R                 /* Free Running Timer */
#define CAN_6_RXMGMASK       CAN_6.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_6_RX14MASK       CAN_6.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_6_RX15MASK       CAN_6.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_6_ECR            CAN_6.ECR.R                   /* Error Counter */
#define CAN_6_ESR1           CAN_6.ESR1.R                  /* Error and Status 1 register */
#define CAN_6_IMASK2         CAN_6.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_6_IMASK1         CAN_6.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_6_IFLAG2         CAN_6.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_6_IFLAG1         CAN_6.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_6_CTRL2          CAN_6.CTRL2.R                 /* Control 2 register */
#define CAN_6_ESR2           CAN_6.ESR2.R                  /* Error and Status 2 register */
#define CAN_6_CRCR           CAN_6.CRCR.R                  /* CRC Register */
#define CAN_6_RXFGMASK       CAN_6.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_6_RXFIR          CAN_6.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_6_CBT            CAN_6.CBT.R                   /* CAN Bit Timing Register */
#define CAN_6_CS0            CAN_6.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_6_ID0            CAN_6.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_6_B0             CAN_6.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_6_H0             CAN_6.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_6_W0             CAN_6.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_6_CS1            CAN_6.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_6_ID1            CAN_6.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_6_B1             CAN_6.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_6_H1             CAN_6.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_6_W1             CAN_6.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_6_CS2            CAN_6.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_6_ID2            CAN_6.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_6_B2             CAN_6.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_6_H2             CAN_6.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_6_W2             CAN_6.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_6_CS3            CAN_6.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_6_ID3            CAN_6.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_6_B3             CAN_6.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_6_H3             CAN_6.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_6_W3             CAN_6.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_6_CS4            CAN_6.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_6_ID4            CAN_6.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_6_B4             CAN_6.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_6_H4             CAN_6.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_6_W4             CAN_6.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_6_CS5            CAN_6.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_6_ID5            CAN_6.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_6_B5             CAN_6.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_6_H5             CAN_6.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_6_W5             CAN_6.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_6_CS6            CAN_6.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_6_ID6            CAN_6.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_6_B6             CAN_6.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_6_H6             CAN_6.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_6_W6             CAN_6.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_6_CS7            CAN_6.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_6_ID7            CAN_6.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_6_B7             CAN_6.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_6_H7             CAN_6.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_6_W7             CAN_6.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_6_CS8            CAN_6.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_6_ID8            CAN_6.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_6_B8             CAN_6.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_6_H8             CAN_6.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_6_W8             CAN_6.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_6_CS9            CAN_6.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_6_ID9            CAN_6.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_6_B9             CAN_6.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_6_H9             CAN_6.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_6_W9             CAN_6.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_6_CS10           CAN_6.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_6_ID10           CAN_6.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_6_B10            CAN_6.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_6_H10            CAN_6.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_6_W10            CAN_6.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_6_CS11           CAN_6.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_6_ID11           CAN_6.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_6_B11            CAN_6.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_6_H11            CAN_6.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_6_W11            CAN_6.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_6_CS12           CAN_6.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_6_ID12           CAN_6.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_6_B12            CAN_6.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_6_H12            CAN_6.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_6_W12            CAN_6.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_6_CS13           CAN_6.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_6_ID13           CAN_6.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_6_B13            CAN_6.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_6_H13            CAN_6.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_6_W13            CAN_6.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_6_CS14           CAN_6.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_6_ID14           CAN_6.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_6_B14            CAN_6.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_6_H14            CAN_6.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_6_W14            CAN_6.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_6_CS15           CAN_6.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_6_ID15           CAN_6.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_6_B15            CAN_6.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_6_H15            CAN_6.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_6_W15            CAN_6.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_6_CS16           CAN_6.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_6_ID16           CAN_6.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_6_B16            CAN_6.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_6_H16            CAN_6.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_6_W16            CAN_6.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_6_CS17           CAN_6.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_6_ID17           CAN_6.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_6_B17            CAN_6.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_6_H17            CAN_6.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_6_W17            CAN_6.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_6_CS18           CAN_6.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_6_ID18           CAN_6.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_6_B18            CAN_6.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_6_H18            CAN_6.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_6_W18            CAN_6.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_6_CS19           CAN_6.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_6_ID19           CAN_6.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_6_B19            CAN_6.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_6_H19            CAN_6.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_6_W19            CAN_6.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_6_CS20           CAN_6.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_6_ID20           CAN_6.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_6_B20            CAN_6.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_6_H20            CAN_6.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_6_W20            CAN_6.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_6_CS21           CAN_6.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_6_ID21           CAN_6.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_6_B21            CAN_6.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_6_H21            CAN_6.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_6_W21            CAN_6.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_6_CS22           CAN_6.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_6_ID22           CAN_6.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_6_B22            CAN_6.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_6_H22            CAN_6.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_6_W22            CAN_6.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_6_CS23           CAN_6.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_6_ID23           CAN_6.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_6_B23            CAN_6.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_6_H23            CAN_6.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_6_W23            CAN_6.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_6_CS24           CAN_6.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_6_ID24           CAN_6.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_6_B24            CAN_6.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_6_H24            CAN_6.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_6_W24            CAN_6.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_6_CS25           CAN_6.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_6_ID25           CAN_6.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_6_B25            CAN_6.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_6_H25            CAN_6.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_6_W25            CAN_6.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_6_CS26           CAN_6.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_6_ID26           CAN_6.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_6_B26            CAN_6.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_6_H26            CAN_6.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_6_W26            CAN_6.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_6_CS27           CAN_6.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_6_ID27           CAN_6.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_6_B27            CAN_6.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_6_H27            CAN_6.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_6_W27            CAN_6.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_6_CS28           CAN_6.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_6_ID28           CAN_6.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_6_B28            CAN_6.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_6_H28            CAN_6.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_6_W28            CAN_6.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_6_CS29           CAN_6.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_6_ID29           CAN_6.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_6_B29            CAN_6.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_6_H29            CAN_6.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_6_W29            CAN_6.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_6_CS30           CAN_6.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_6_ID30           CAN_6.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_6_B30            CAN_6.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_6_H30            CAN_6.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_6_W30            CAN_6.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_6_CS31           CAN_6.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_6_ID31           CAN_6.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_6_B31            CAN_6.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_6_H31            CAN_6.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_6_W31            CAN_6.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_6_CS32           CAN_6.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_6_ID32           CAN_6.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_6_B32            CAN_6.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_6_H32            CAN_6.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_6_W32            CAN_6.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_6_CS33           CAN_6.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_6_ID33           CAN_6.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_6_B33            CAN_6.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_6_H33            CAN_6.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_6_W33            CAN_6.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_6_CS34           CAN_6.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_6_ID34           CAN_6.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_6_B34            CAN_6.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_6_H34            CAN_6.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_6_W34            CAN_6.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_6_CS35           CAN_6.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_6_ID35           CAN_6.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_6_B35            CAN_6.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_6_H35            CAN_6.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_6_W35            CAN_6.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_6_CS36           CAN_6.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_6_ID36           CAN_6.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_6_B36            CAN_6.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_6_H36            CAN_6.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_6_W36            CAN_6.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_6_CS37           CAN_6.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_6_ID37           CAN_6.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_6_B37            CAN_6.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_6_H37            CAN_6.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_6_W37            CAN_6.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_6_CS38           CAN_6.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_6_ID38           CAN_6.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_6_B38            CAN_6.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_6_H38            CAN_6.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_6_W38            CAN_6.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_6_CS39           CAN_6.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_6_ID39           CAN_6.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_6_B39            CAN_6.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_6_H39            CAN_6.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_6_W39            CAN_6.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_6_CS40           CAN_6.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_6_ID40           CAN_6.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_6_B40            CAN_6.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_6_H40            CAN_6.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_6_W40            CAN_6.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_6_CS41           CAN_6.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_6_ID41           CAN_6.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_6_B41            CAN_6.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_6_H41            CAN_6.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_6_W41            CAN_6.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_6_CS42           CAN_6.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_6_ID42           CAN_6.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_6_B42            CAN_6.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_6_H42            CAN_6.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_6_W42            CAN_6.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_6_CS43           CAN_6.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_6_ID43           CAN_6.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_6_B43            CAN_6.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_6_H43            CAN_6.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_6_W43            CAN_6.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_6_CS44           CAN_6.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_6_ID44           CAN_6.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_6_B44            CAN_6.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_6_H44            CAN_6.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_6_W44            CAN_6.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_6_CS45           CAN_6.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_6_ID45           CAN_6.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_6_B45            CAN_6.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_6_H45            CAN_6.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_6_W45            CAN_6.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_6_CS46           CAN_6.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_6_ID46           CAN_6.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_6_B46            CAN_6.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_6_H46            CAN_6.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_6_W46            CAN_6.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_6_CS47           CAN_6.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_6_ID47           CAN_6.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_6_B47            CAN_6.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_6_H47            CAN_6.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_6_W47            CAN_6.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_6_CS48           CAN_6.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_6_ID48           CAN_6.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_6_B48            CAN_6.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_6_H48            CAN_6.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_6_W48            CAN_6.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_6_CS49           CAN_6.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_6_ID49           CAN_6.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_6_B49            CAN_6.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_6_H49            CAN_6.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_6_W49            CAN_6.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_6_CS50           CAN_6.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_6_ID50           CAN_6.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_6_B50            CAN_6.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_6_H50            CAN_6.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_6_W50            CAN_6.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_6_CS51           CAN_6.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_6_ID51           CAN_6.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_6_B51            CAN_6.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_6_H51            CAN_6.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_6_W51            CAN_6.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_6_CS52           CAN_6.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_6_ID52           CAN_6.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_6_B52            CAN_6.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_6_H52            CAN_6.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_6_W52            CAN_6.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_6_CS53           CAN_6.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_6_ID53           CAN_6.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_6_B53            CAN_6.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_6_H53            CAN_6.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_6_W53            CAN_6.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_6_CS54           CAN_6.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_6_ID54           CAN_6.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_6_B54            CAN_6.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_6_H54            CAN_6.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_6_W54            CAN_6.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_6_CS55           CAN_6.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_6_ID55           CAN_6.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_6_B55            CAN_6.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_6_H55            CAN_6.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_6_W55            CAN_6.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_6_CS56           CAN_6.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_6_ID56           CAN_6.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_6_B56            CAN_6.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_6_H56            CAN_6.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_6_W56            CAN_6.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_6_CS57           CAN_6.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_6_ID57           CAN_6.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_6_B57            CAN_6.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_6_H57            CAN_6.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_6_W57            CAN_6.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_6_CS58           CAN_6.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_6_ID58           CAN_6.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_6_B58            CAN_6.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_6_H58            CAN_6.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_6_W58            CAN_6.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_6_CS59           CAN_6.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_6_ID59           CAN_6.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_6_B59            CAN_6.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_6_H59            CAN_6.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_6_W59            CAN_6.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_6_CS60           CAN_6.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_6_ID60           CAN_6.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_6_B60            CAN_6.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_6_H60            CAN_6.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_6_W60            CAN_6.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_6_CS61           CAN_6.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_6_ID61           CAN_6.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_6_B61            CAN_6.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_6_H61            CAN_6.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_6_W61            CAN_6.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_6_CS62           CAN_6.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_6_ID62           CAN_6.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_6_B62            CAN_6.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_6_H62            CAN_6.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_6_W62            CAN_6.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_6_CS63           CAN_6.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_6_ID63           CAN_6.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_6_B63            CAN_6.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_6_H63            CAN_6.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_6_W63            CAN_6.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_6_RXIMR0         CAN_6.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR1         CAN_6.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR2         CAN_6.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR3         CAN_6.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR4         CAN_6.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR5         CAN_6.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR6         CAN_6.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR7         CAN_6.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR8         CAN_6.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR9         CAN_6.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR10        CAN_6.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR11        CAN_6.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR12        CAN_6.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR13        CAN_6.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR14        CAN_6.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR15        CAN_6.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR16        CAN_6.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR17        CAN_6.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR18        CAN_6.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR19        CAN_6.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR20        CAN_6.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR21        CAN_6.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR22        CAN_6.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR23        CAN_6.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR24        CAN_6.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR25        CAN_6.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR26        CAN_6.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR27        CAN_6.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR28        CAN_6.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR29        CAN_6.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR30        CAN_6.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR31        CAN_6.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR32        CAN_6.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR33        CAN_6.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR34        CAN_6.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR35        CAN_6.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR36        CAN_6.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR37        CAN_6.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR38        CAN_6.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR39        CAN_6.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR40        CAN_6.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR41        CAN_6.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR42        CAN_6.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR43        CAN_6.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR44        CAN_6.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR45        CAN_6.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR46        CAN_6.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR47        CAN_6.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR48        CAN_6.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR49        CAN_6.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR50        CAN_6.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR51        CAN_6.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR52        CAN_6.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR53        CAN_6.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR54        CAN_6.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR55        CAN_6.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR56        CAN_6.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR57        CAN_6.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR58        CAN_6.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR59        CAN_6.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR60        CAN_6.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR61        CAN_6.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR62        CAN_6.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR63        CAN_6.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_6_FDCTRL         CAN_6.FDCTRL.R                /* CAN FD Control Register */
#define CAN_6_FDCBT          CAN_6.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_6_FDCRC          CAN_6.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_7_MCR            CAN_7.MCR.R                   /* Module Configuration Register */
#define CAN_7_CTRL1          CAN_7.CTRL1.R                 /* Control 1 register */
#define CAN_7_TIMER          CAN_7.TIMER.R                 /* Free Running Timer */
#define CAN_7_RXMGMASK       CAN_7.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_7_RX14MASK       CAN_7.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_7_RX15MASK       CAN_7.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_7_ECR            CAN_7.ECR.R                   /* Error Counter */
#define CAN_7_ESR1           CAN_7.ESR1.R                  /* Error and Status 1 register */
#define CAN_7_IMASK2         CAN_7.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_7_IMASK1         CAN_7.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_7_IFLAG2         CAN_7.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_7_IFLAG1         CAN_7.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_7_CTRL2          CAN_7.CTRL2.R                 /* Control 2 register */
#define CAN_7_ESR2           CAN_7.ESR2.R                  /* Error and Status 2 register */
#define CAN_7_CRCR           CAN_7.CRCR.R                  /* CRC Register */
#define CAN_7_RXFGMASK       CAN_7.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_7_RXFIR          CAN_7.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_7_CBT            CAN_7.CBT.R                   /* CAN Bit Timing Register */
#define CAN_7_CS0            CAN_7.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_7_ID0            CAN_7.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_7_B0             CAN_7.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_7_H0             CAN_7.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_7_W0             CAN_7.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_7_CS1            CAN_7.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_7_ID1            CAN_7.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_7_B1             CAN_7.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_7_H1             CAN_7.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_7_W1             CAN_7.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_7_CS2            CAN_7.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_7_ID2            CAN_7.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_7_B2             CAN_7.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_7_H2             CAN_7.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_7_W2             CAN_7.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_7_CS3            CAN_7.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_7_ID3            CAN_7.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_7_B3             CAN_7.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_7_H3             CAN_7.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_7_W3             CAN_7.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_7_CS4            CAN_7.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_7_ID4            CAN_7.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_7_B4             CAN_7.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_7_H4             CAN_7.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_7_W4             CAN_7.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_7_CS5            CAN_7.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_7_ID5            CAN_7.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_7_B5             CAN_7.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_7_H5             CAN_7.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_7_W5             CAN_7.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_7_CS6            CAN_7.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_7_ID6            CAN_7.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_7_B6             CAN_7.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_7_H6             CAN_7.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_7_W6             CAN_7.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_7_CS7            CAN_7.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_7_ID7            CAN_7.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_7_B7             CAN_7.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_7_H7             CAN_7.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_7_W7             CAN_7.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_7_CS8            CAN_7.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_7_ID8            CAN_7.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_7_B8             CAN_7.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_7_H8             CAN_7.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_7_W8             CAN_7.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_7_CS9            CAN_7.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_7_ID9            CAN_7.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_7_B9             CAN_7.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_7_H9             CAN_7.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_7_W9             CAN_7.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_7_CS10           CAN_7.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_7_ID10           CAN_7.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_7_B10            CAN_7.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_7_H10            CAN_7.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_7_W10            CAN_7.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_7_CS11           CAN_7.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_7_ID11           CAN_7.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_7_B11            CAN_7.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_7_H11            CAN_7.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_7_W11            CAN_7.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_7_CS12           CAN_7.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_7_ID12           CAN_7.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_7_B12            CAN_7.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_7_H12            CAN_7.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_7_W12            CAN_7.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_7_CS13           CAN_7.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_7_ID13           CAN_7.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_7_B13            CAN_7.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_7_H13            CAN_7.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_7_W13            CAN_7.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_7_CS14           CAN_7.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_7_ID14           CAN_7.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_7_B14            CAN_7.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_7_H14            CAN_7.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_7_W14            CAN_7.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_7_CS15           CAN_7.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_7_ID15           CAN_7.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_7_B15            CAN_7.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_7_H15            CAN_7.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_7_W15            CAN_7.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_7_CS16           CAN_7.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_7_ID16           CAN_7.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_7_B16            CAN_7.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_7_H16            CAN_7.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_7_W16            CAN_7.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_7_CS17           CAN_7.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_7_ID17           CAN_7.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_7_B17            CAN_7.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_7_H17            CAN_7.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_7_W17            CAN_7.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_7_CS18           CAN_7.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_7_ID18           CAN_7.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_7_B18            CAN_7.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_7_H18            CAN_7.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_7_W18            CAN_7.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_7_CS19           CAN_7.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_7_ID19           CAN_7.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_7_B19            CAN_7.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_7_H19            CAN_7.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_7_W19            CAN_7.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_7_CS20           CAN_7.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_7_ID20           CAN_7.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_7_B20            CAN_7.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_7_H20            CAN_7.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_7_W20            CAN_7.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_7_CS21           CAN_7.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_7_ID21           CAN_7.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_7_B21            CAN_7.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_7_H21            CAN_7.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_7_W21            CAN_7.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_7_CS22           CAN_7.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_7_ID22           CAN_7.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_7_B22            CAN_7.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_7_H22            CAN_7.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_7_W22            CAN_7.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_7_CS23           CAN_7.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_7_ID23           CAN_7.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_7_B23            CAN_7.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_7_H23            CAN_7.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_7_W23            CAN_7.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_7_CS24           CAN_7.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_7_ID24           CAN_7.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_7_B24            CAN_7.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_7_H24            CAN_7.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_7_W24            CAN_7.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_7_CS25           CAN_7.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_7_ID25           CAN_7.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_7_B25            CAN_7.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_7_H25            CAN_7.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_7_W25            CAN_7.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_7_CS26           CAN_7.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_7_ID26           CAN_7.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_7_B26            CAN_7.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_7_H26            CAN_7.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_7_W26            CAN_7.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_7_CS27           CAN_7.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_7_ID27           CAN_7.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_7_B27            CAN_7.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_7_H27            CAN_7.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_7_W27            CAN_7.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_7_CS28           CAN_7.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_7_ID28           CAN_7.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_7_B28            CAN_7.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_7_H28            CAN_7.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_7_W28            CAN_7.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_7_CS29           CAN_7.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_7_ID29           CAN_7.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_7_B29            CAN_7.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_7_H29            CAN_7.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_7_W29            CAN_7.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_7_CS30           CAN_7.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_7_ID30           CAN_7.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_7_B30            CAN_7.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_7_H30            CAN_7.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_7_W30            CAN_7.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_7_CS31           CAN_7.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_7_ID31           CAN_7.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_7_B31            CAN_7.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_7_H31            CAN_7.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_7_W31            CAN_7.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_7_CS32           CAN_7.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_7_ID32           CAN_7.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_7_B32            CAN_7.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_7_H32            CAN_7.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_7_W32            CAN_7.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_7_CS33           CAN_7.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_7_ID33           CAN_7.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_7_B33            CAN_7.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_7_H33            CAN_7.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_7_W33            CAN_7.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_7_CS34           CAN_7.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_7_ID34           CAN_7.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_7_B34            CAN_7.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_7_H34            CAN_7.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_7_W34            CAN_7.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_7_CS35           CAN_7.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_7_ID35           CAN_7.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_7_B35            CAN_7.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_7_H35            CAN_7.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_7_W35            CAN_7.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_7_CS36           CAN_7.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_7_ID36           CAN_7.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_7_B36            CAN_7.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_7_H36            CAN_7.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_7_W36            CAN_7.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_7_CS37           CAN_7.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_7_ID37           CAN_7.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_7_B37            CAN_7.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_7_H37            CAN_7.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_7_W37            CAN_7.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_7_CS38           CAN_7.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_7_ID38           CAN_7.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_7_B38            CAN_7.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_7_H38            CAN_7.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_7_W38            CAN_7.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_7_CS39           CAN_7.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_7_ID39           CAN_7.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_7_B39            CAN_7.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_7_H39            CAN_7.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_7_W39            CAN_7.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_7_CS40           CAN_7.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_7_ID40           CAN_7.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_7_B40            CAN_7.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_7_H40            CAN_7.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_7_W40            CAN_7.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_7_CS41           CAN_7.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_7_ID41           CAN_7.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_7_B41            CAN_7.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_7_H41            CAN_7.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_7_W41            CAN_7.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_7_CS42           CAN_7.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_7_ID42           CAN_7.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_7_B42            CAN_7.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_7_H42            CAN_7.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_7_W42            CAN_7.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_7_CS43           CAN_7.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_7_ID43           CAN_7.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_7_B43            CAN_7.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_7_H43            CAN_7.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_7_W43            CAN_7.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_7_CS44           CAN_7.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_7_ID44           CAN_7.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_7_B44            CAN_7.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_7_H44            CAN_7.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_7_W44            CAN_7.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_7_CS45           CAN_7.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_7_ID45           CAN_7.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_7_B45            CAN_7.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_7_H45            CAN_7.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_7_W45            CAN_7.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_7_CS46           CAN_7.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_7_ID46           CAN_7.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_7_B46            CAN_7.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_7_H46            CAN_7.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_7_W46            CAN_7.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_7_CS47           CAN_7.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_7_ID47           CAN_7.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_7_B47            CAN_7.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_7_H47            CAN_7.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_7_W47            CAN_7.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_7_CS48           CAN_7.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_7_ID48           CAN_7.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_7_B48            CAN_7.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_7_H48            CAN_7.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_7_W48            CAN_7.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_7_CS49           CAN_7.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_7_ID49           CAN_7.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_7_B49            CAN_7.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_7_H49            CAN_7.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_7_W49            CAN_7.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_7_CS50           CAN_7.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_7_ID50           CAN_7.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_7_B50            CAN_7.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_7_H50            CAN_7.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_7_W50            CAN_7.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_7_CS51           CAN_7.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_7_ID51           CAN_7.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_7_B51            CAN_7.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_7_H51            CAN_7.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_7_W51            CAN_7.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_7_CS52           CAN_7.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_7_ID52           CAN_7.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_7_B52            CAN_7.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_7_H52            CAN_7.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_7_W52            CAN_7.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_7_CS53           CAN_7.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_7_ID53           CAN_7.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_7_B53            CAN_7.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_7_H53            CAN_7.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_7_W53            CAN_7.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_7_CS54           CAN_7.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_7_ID54           CAN_7.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_7_B54            CAN_7.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_7_H54            CAN_7.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_7_W54            CAN_7.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_7_CS55           CAN_7.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_7_ID55           CAN_7.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_7_B55            CAN_7.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_7_H55            CAN_7.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_7_W55            CAN_7.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_7_CS56           CAN_7.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_7_ID56           CAN_7.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_7_B56            CAN_7.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_7_H56            CAN_7.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_7_W56            CAN_7.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_7_CS57           CAN_7.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_7_ID57           CAN_7.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_7_B57            CAN_7.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_7_H57            CAN_7.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_7_W57            CAN_7.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_7_CS58           CAN_7.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_7_ID58           CAN_7.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_7_B58            CAN_7.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_7_H58            CAN_7.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_7_W58            CAN_7.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_7_CS59           CAN_7.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_7_ID59           CAN_7.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_7_B59            CAN_7.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_7_H59            CAN_7.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_7_W59            CAN_7.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_7_CS60           CAN_7.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_7_ID60           CAN_7.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_7_B60            CAN_7.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_7_H60            CAN_7.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_7_W60            CAN_7.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_7_CS61           CAN_7.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_7_ID61           CAN_7.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_7_B61            CAN_7.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_7_H61            CAN_7.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_7_W61            CAN_7.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_7_CS62           CAN_7.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_7_ID62           CAN_7.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_7_B62            CAN_7.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_7_H62            CAN_7.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_7_W62            CAN_7.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_7_CS63           CAN_7.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_7_ID63           CAN_7.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_7_B63            CAN_7.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_7_H63            CAN_7.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_7_W63            CAN_7.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_7_RXIMR0         CAN_7.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR1         CAN_7.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR2         CAN_7.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR3         CAN_7.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR4         CAN_7.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR5         CAN_7.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR6         CAN_7.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR7         CAN_7.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR8         CAN_7.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR9         CAN_7.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_7_RXIMR10        CAN_7.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR11        CAN_7.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR12        CAN_7.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR13        CAN_7.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR14        CAN_7.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR15        CAN_7.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR16        CAN_7.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR17        CAN_7.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR18        CAN_7.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR19        CAN_7.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR20        CAN_7.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR21        CAN_7.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR22        CAN_7.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR23        CAN_7.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR24        CAN_7.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR25        CAN_7.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR26        CAN_7.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR27        CAN_7.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR28        CAN_7.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR29        CAN_7.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR30        CAN_7.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR31        CAN_7.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR32        CAN_7.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR33        CAN_7.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR34        CAN_7.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR35        CAN_7.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR36        CAN_7.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR37        CAN_7.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR38        CAN_7.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR39        CAN_7.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR40        CAN_7.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR41        CAN_7.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR42        CAN_7.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR43        CAN_7.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR44        CAN_7.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR45        CAN_7.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR46        CAN_7.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR47        CAN_7.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR48        CAN_7.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR49        CAN_7.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR50        CAN_7.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR51        CAN_7.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR52        CAN_7.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR53        CAN_7.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR54        CAN_7.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR55        CAN_7.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR56        CAN_7.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR57        CAN_7.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR58        CAN_7.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR59        CAN_7.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR60        CAN_7.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR61        CAN_7.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR62        CAN_7.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_7_RXIMR63        CAN_7.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_7_FDCTRL         CAN_7.FDCTRL.R                /* CAN FD Control Register */
#define CAN_7_FDCBT          CAN_7.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_7_FDCRC          CAN_7.FDCRC.R                 /* CAN FD CRC Register */

/* CMP */
#define CMP_0_C0             CMP_0.C0.R                    /* CMP Control Register 0 */
#define CMP_0_C1             CMP_0.C1.R                    /* CMP Control Register 1 */
#define CMP_0_C2             CMP_0.C2.R                    /* CMP Control Register 2 */

#define CMP_1_C0             CMP_1.C0.R                    /* CMP Control Register 0 */
#define CMP_1_C1             CMP_1.C1.R                    /* CMP Control Register 1 */
#define CMP_1_C2             CMP_1.C2.R                    /* CMP Control Register 2 */

#define CMP_2_C0             CMP_2.C0.R                    /* CMP Control Register 0 */
#define CMP_2_C1             CMP_2.C1.R                    /* CMP Control Register 1 */
#define CMP_2_C2             CMP_2.C2.R                    /* CMP Control Register 2 */

/* CMU */
#define CMU_CSR              CMU.CSR.R                     /* CMU Control Status Register */
#define CMU_FDR              CMU.FDR.R                     /* CMU Frequency Display Register */
#define CMU_HFREFR           CMU.HFREFR.R                  /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_LFREFR           CMU.LFREFR.R                  /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ISR              CMU.ISR.R                     /* CMU Interrupt Status Register */
#define CMU_MDR              CMU.MDR.R                     /* CMU Measurement Duration Register */

/* CRC */
#define CRC_CFG              CRC.CFG.R                     /* Configuration Register */
#define CRC_INP              CRC.INP.R                     /* Input Register */
#define CRC_CSTAT            CRC.CSTAT.R                   /* Current Status Register */
#define CRC_OUTP             CRC.OUTP.R                    /* Output Register */

/* DMA */
#define DMA_CR               DMA.CR.R                      /* Control Register */
#define DMA_ES               DMA.ES.R                      /* Error Status Register */
#define DMA_ERQ              DMA.ERQ.R                     /* Enable Request Register */
#define DMA_EEI              DMA.EEI.R                     /* Enable Error Interrupt Register */
#define DMA_SERQ             DMA.SERQ.R                    /* Set Enable Request Register */
#define DMA_CERQ             DMA.CERQ.R                    /* Clear Enable Request Register */
#define DMA_SEEI             DMA.SEEI.R                    /* Set Enable Error Interrupt Register */
#define DMA_CEEI             DMA.CEEI.R                    /* Clear Enable Error Interrupt Register */
#define DMA_CINT             DMA.CINT.R                    /* Clear Interrupt Request Register */
#define DMA_CERR             DMA.CERR.R                    /* Clear Error Register */
#define DMA_SSRT             DMA.SSRT.R                    /* Set START Bit Register */
#define DMA_CDNE             DMA.CDNE.R                    /* Clear DONE Status Bit Register */
#define DMA_INT              DMA.INT.R                     /* Interrupt Request Register */
#define DMA_ERR              DMA.ERR.R                     /* Error Register */
#define DMA_HRS              DMA.HRS.R                     /* Hardware Request Status Register */
#define DMA_DCHPRI0          DMA.DCHPRI[0].R               /* Channel n Priority Register */
#define DMA_DCHPRI1          DMA.DCHPRI[1].R               /* Channel n Priority Register */
#define DMA_DCHPRI2          DMA.DCHPRI[2].R               /* Channel n Priority Register */
#define DMA_DCHPRI3          DMA.DCHPRI[3].R               /* Channel n Priority Register */
#define DMA_DCHPRI4          DMA.DCHPRI[4].R               /* Channel n Priority Register */
#define DMA_DCHPRI5          DMA.DCHPRI[5].R               /* Channel n Priority Register */
#define DMA_DCHPRI6          DMA.DCHPRI[6].R               /* Channel n Priority Register */
#define DMA_DCHPRI7          DMA.DCHPRI[7].R               /* Channel n Priority Register */
#define DMA_DCHPRI8          DMA.DCHPRI[8].R               /* Channel n Priority Register */
#define DMA_DCHPRI9          DMA.DCHPRI[9].R               /* Channel n Priority Register */
#define DMA_DCHPRI10         DMA.DCHPRI[10].R              /* Channel n Priority Register */
#define DMA_DCHPRI11         DMA.DCHPRI[11].R              /* Channel n Priority Register */
#define DMA_DCHPRI12         DMA.DCHPRI[12].R              /* Channel n Priority Register */
#define DMA_DCHPRI13         DMA.DCHPRI[13].R              /* Channel n Priority Register */
#define DMA_DCHPRI14         DMA.DCHPRI[14].R              /* Channel n Priority Register */
#define DMA_DCHPRI15         DMA.DCHPRI[15].R              /* Channel n Priority Register */
#define DMA_DCHPRI16         DMA.DCHPRI[16].R              /* Channel n Priority Register */
#define DMA_DCHPRI17         DMA.DCHPRI[17].R              /* Channel n Priority Register */
#define DMA_DCHPRI18         DMA.DCHPRI[18].R              /* Channel n Priority Register */
#define DMA_DCHPRI19         DMA.DCHPRI[19].R              /* Channel n Priority Register */
#define DMA_DCHPRI20         DMA.DCHPRI[20].R              /* Channel n Priority Register */
#define DMA_DCHPRI21         DMA.DCHPRI[21].R              /* Channel n Priority Register */
#define DMA_DCHPRI22         DMA.DCHPRI[22].R              /* Channel n Priority Register */
#define DMA_DCHPRI23         DMA.DCHPRI[23].R              /* Channel n Priority Register */
#define DMA_DCHPRI24         DMA.DCHPRI[24].R              /* Channel n Priority Register */
#define DMA_DCHPRI25         DMA.DCHPRI[25].R              /* Channel n Priority Register */
#define DMA_DCHPRI26         DMA.DCHPRI[26].R              /* Channel n Priority Register */
#define DMA_DCHPRI27         DMA.DCHPRI[27].R              /* Channel n Priority Register */
#define DMA_DCHPRI28         DMA.DCHPRI[28].R              /* Channel n Priority Register */
#define DMA_DCHPRI29         DMA.DCHPRI[29].R              /* Channel n Priority Register */
#define DMA_DCHPRI30         DMA.DCHPRI[30].R              /* Channel n Priority Register */
#define DMA_DCHPRI31         DMA.DCHPRI[31].R              /* Channel n Priority Register */
#define DMA_DCHMID0          DMA.DCHMID[0].R               /* Channel n Master ID Register */
#define DMA_DCHMID1          DMA.DCHMID[1].R               /* Channel n Master ID Register */
#define DMA_DCHMID2          DMA.DCHMID[2].R               /* Channel n Master ID Register */
#define DMA_DCHMID3          DMA.DCHMID[3].R               /* Channel n Master ID Register */
#define DMA_DCHMID4          DMA.DCHMID[4].R               /* Channel n Master ID Register */
#define DMA_DCHMID5          DMA.DCHMID[5].R               /* Channel n Master ID Register */
#define DMA_DCHMID6          DMA.DCHMID[6].R               /* Channel n Master ID Register */
#define DMA_DCHMID7          DMA.DCHMID[7].R               /* Channel n Master ID Register */
#define DMA_DCHMID8          DMA.DCHMID[8].R               /* Channel n Master ID Register */
#define DMA_DCHMID9          DMA.DCHMID[9].R               /* Channel n Master ID Register */
#define DMA_DCHMID10         DMA.DCHMID[10].R              /* Channel n Master ID Register */
#define DMA_DCHMID11         DMA.DCHMID[11].R              /* Channel n Master ID Register */
#define DMA_DCHMID12         DMA.DCHMID[12].R              /* Channel n Master ID Register */
#define DMA_DCHMID13         DMA.DCHMID[13].R              /* Channel n Master ID Register */
#define DMA_DCHMID14         DMA.DCHMID[14].R              /* Channel n Master ID Register */
#define DMA_DCHMID15         DMA.DCHMID[15].R              /* Channel n Master ID Register */
#define DMA_DCHMID16         DMA.DCHMID[16].R              /* Channel n Master ID Register */
#define DMA_DCHMID17         DMA.DCHMID[17].R              /* Channel n Master ID Register */
#define DMA_DCHMID18         DMA.DCHMID[18].R              /* Channel n Master ID Register */
#define DMA_DCHMID19         DMA.DCHMID[19].R              /* Channel n Master ID Register */
#define DMA_DCHMID20         DMA.DCHMID[20].R              /* Channel n Master ID Register */
#define DMA_DCHMID21         DMA.DCHMID[21].R              /* Channel n Master ID Register */
#define DMA_DCHMID22         DMA.DCHMID[22].R              /* Channel n Master ID Register */
#define DMA_DCHMID23         DMA.DCHMID[23].R              /* Channel n Master ID Register */
#define DMA_DCHMID24         DMA.DCHMID[24].R              /* Channel n Master ID Register */
#define DMA_DCHMID25         DMA.DCHMID[25].R              /* Channel n Master ID Register */
#define DMA_DCHMID26         DMA.DCHMID[26].R              /* Channel n Master ID Register */
#define DMA_DCHMID27         DMA.DCHMID[27].R              /* Channel n Master ID Register */
#define DMA_DCHMID28         DMA.DCHMID[28].R              /* Channel n Master ID Register */
#define DMA_DCHMID29         DMA.DCHMID[29].R              /* Channel n Master ID Register */
#define DMA_DCHMID30         DMA.DCHMID[30].R              /* Channel n Master ID Register */
#define DMA_DCHMID31         DMA.DCHMID[31].R              /* Channel n Master ID Register */
#define DMA_TCD0_SADDR       DMA.TCD[0].SADDR.R            /* TCD Source Address */
#define DMA_TCD0_ATTR        DMA.TCD[0].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD0_SOFF        DMA.TCD[0].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD0_NBYTES_MLNO DMA.TCD[0].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD0_NBYTES_MLOFFNO DMA.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD0_NBYTES_MLOFFYES DMA.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD0_SLAST       DMA.TCD[0].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD0_DADDR       DMA.TCD[0].DADDR.R            /* TCD Destination Address */
#define DMA_TCD0_CITER_ELINKNO DMA.TCD[0].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_CITER_ELINKYES DMA.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_DOFF        DMA.TCD[0].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD0_DLASTSGA    DMA.TCD[0].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD0_BITER_ELINKNO DMA.TCD[0].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_BITER_ELINKYES DMA.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_CSR         DMA.TCD[0].CSR.R              /* TCD Control and Status */
#define DMA_TCD1_SADDR       DMA.TCD[1].SADDR.R            /* TCD Source Address */
#define DMA_TCD1_ATTR        DMA.TCD[1].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD1_SOFF        DMA.TCD[1].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD1_NBYTES_MLNO DMA.TCD[1].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD1_NBYTES_MLOFFNO DMA.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD1_NBYTES_MLOFFYES DMA.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD1_SLAST       DMA.TCD[1].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD1_DADDR       DMA.TCD[1].DADDR.R            /* TCD Destination Address */
#define DMA_TCD1_CITER_ELINKNO DMA.TCD[1].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_CITER_ELINKYES DMA.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_DOFF        DMA.TCD[1].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD1_DLASTSGA    DMA.TCD[1].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD1_BITER_ELINKNO DMA.TCD[1].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_BITER_ELINKYES DMA.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_CSR         DMA.TCD[1].CSR.R              /* TCD Control and Status */
#define DMA_TCD2_SADDR       DMA.TCD[2].SADDR.R            /* TCD Source Address */
#define DMA_TCD2_ATTR        DMA.TCD[2].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD2_SOFF        DMA.TCD[2].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD2_NBYTES_MLNO DMA.TCD[2].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD2_NBYTES_MLOFFNO DMA.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD2_NBYTES_MLOFFYES DMA.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD2_SLAST       DMA.TCD[2].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD2_DADDR       DMA.TCD[2].DADDR.R            /* TCD Destination Address */
#define DMA_TCD2_CITER_ELINKNO DMA.TCD[2].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_CITER_ELINKYES DMA.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_DOFF        DMA.TCD[2].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD2_DLASTSGA    DMA.TCD[2].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD2_BITER_ELINKNO DMA.TCD[2].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_BITER_ELINKYES DMA.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_CSR         DMA.TCD[2].CSR.R              /* TCD Control and Status */
#define DMA_TCD3_SADDR       DMA.TCD[3].SADDR.R            /* TCD Source Address */
#define DMA_TCD3_ATTR        DMA.TCD[3].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD3_SOFF        DMA.TCD[3].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD3_NBYTES_MLNO DMA.TCD[3].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD3_NBYTES_MLOFFNO DMA.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD3_NBYTES_MLOFFYES DMA.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD3_SLAST       DMA.TCD[3].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD3_DADDR       DMA.TCD[3].DADDR.R            /* TCD Destination Address */
#define DMA_TCD3_CITER_ELINKNO DMA.TCD[3].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_CITER_ELINKYES DMA.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_DOFF        DMA.TCD[3].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD3_DLASTSGA    DMA.TCD[3].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD3_BITER_ELINKNO DMA.TCD[3].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_BITER_ELINKYES DMA.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_CSR         DMA.TCD[3].CSR.R              /* TCD Control and Status */
#define DMA_TCD4_SADDR       DMA.TCD[4].SADDR.R            /* TCD Source Address */
#define DMA_TCD4_ATTR        DMA.TCD[4].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD4_SOFF        DMA.TCD[4].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD4_NBYTES_MLNO DMA.TCD[4].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD4_NBYTES_MLOFFNO DMA.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD4_NBYTES_MLOFFYES DMA.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD4_SLAST       DMA.TCD[4].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD4_DADDR       DMA.TCD[4].DADDR.R            /* TCD Destination Address */
#define DMA_TCD4_CITER_ELINKNO DMA.TCD[4].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_CITER_ELINKYES DMA.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_DOFF        DMA.TCD[4].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD4_DLASTSGA    DMA.TCD[4].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD4_BITER_ELINKNO DMA.TCD[4].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_BITER_ELINKYES DMA.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_CSR         DMA.TCD[4].CSR.R              /* TCD Control and Status */
#define DMA_TCD5_SADDR       DMA.TCD[5].SADDR.R            /* TCD Source Address */
#define DMA_TCD5_ATTR        DMA.TCD[5].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD5_SOFF        DMA.TCD[5].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD5_NBYTES_MLNO DMA.TCD[5].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD5_NBYTES_MLOFFNO DMA.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD5_NBYTES_MLOFFYES DMA.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD5_SLAST       DMA.TCD[5].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD5_DADDR       DMA.TCD[5].DADDR.R            /* TCD Destination Address */
#define DMA_TCD5_CITER_ELINKNO DMA.TCD[5].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_CITER_ELINKYES DMA.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_DOFF        DMA.TCD[5].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD5_DLASTSGA    DMA.TCD[5].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD5_BITER_ELINKNO DMA.TCD[5].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_BITER_ELINKYES DMA.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_CSR         DMA.TCD[5].CSR.R              /* TCD Control and Status */
#define DMA_TCD6_SADDR       DMA.TCD[6].SADDR.R            /* TCD Source Address */
#define DMA_TCD6_ATTR        DMA.TCD[6].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD6_SOFF        DMA.TCD[6].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD6_NBYTES_MLNO DMA.TCD[6].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD6_NBYTES_MLOFFNO DMA.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD6_NBYTES_MLOFFYES DMA.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD6_SLAST       DMA.TCD[6].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD6_DADDR       DMA.TCD[6].DADDR.R            /* TCD Destination Address */
#define DMA_TCD6_CITER_ELINKNO DMA.TCD[6].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_CITER_ELINKYES DMA.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_DOFF        DMA.TCD[6].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD6_DLASTSGA    DMA.TCD[6].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD6_BITER_ELINKNO DMA.TCD[6].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_BITER_ELINKYES DMA.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_CSR         DMA.TCD[6].CSR.R              /* TCD Control and Status */
#define DMA_TCD7_SADDR       DMA.TCD[7].SADDR.R            /* TCD Source Address */
#define DMA_TCD7_ATTR        DMA.TCD[7].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD7_SOFF        DMA.TCD[7].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD7_NBYTES_MLNO DMA.TCD[7].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD7_NBYTES_MLOFFNO DMA.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD7_NBYTES_MLOFFYES DMA.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD7_SLAST       DMA.TCD[7].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD7_DADDR       DMA.TCD[7].DADDR.R            /* TCD Destination Address */
#define DMA_TCD7_CITER_ELINKNO DMA.TCD[7].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_CITER_ELINKYES DMA.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_DOFF        DMA.TCD[7].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD7_DLASTSGA    DMA.TCD[7].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD7_BITER_ELINKNO DMA.TCD[7].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_BITER_ELINKYES DMA.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_CSR         DMA.TCD[7].CSR.R              /* TCD Control and Status */
#define DMA_TCD8_SADDR       DMA.TCD[8].SADDR.R            /* TCD Source Address */
#define DMA_TCD8_ATTR        DMA.TCD[8].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD8_SOFF        DMA.TCD[8].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD8_NBYTES_MLNO DMA.TCD[8].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD8_NBYTES_MLOFFNO DMA.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD8_NBYTES_MLOFFYES DMA.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD8_SLAST       DMA.TCD[8].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD8_DADDR       DMA.TCD[8].DADDR.R            /* TCD Destination Address */
#define DMA_TCD8_CITER_ELINKNO DMA.TCD[8].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_CITER_ELINKYES DMA.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_DOFF        DMA.TCD[8].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD8_DLASTSGA    DMA.TCD[8].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD8_BITER_ELINKNO DMA.TCD[8].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_BITER_ELINKYES DMA.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_CSR         DMA.TCD[8].CSR.R              /* TCD Control and Status */
#define DMA_TCD9_SADDR       DMA.TCD[9].SADDR.R            /* TCD Source Address */
#define DMA_TCD9_ATTR        DMA.TCD[9].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD9_SOFF        DMA.TCD[9].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD9_NBYTES_MLNO DMA.TCD[9].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD9_NBYTES_MLOFFNO DMA.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD9_NBYTES_MLOFFYES DMA.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD9_SLAST       DMA.TCD[9].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD9_DADDR       DMA.TCD[9].DADDR.R            /* TCD Destination Address */
#define DMA_TCD9_CITER_ELINKNO DMA.TCD[9].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_CITER_ELINKYES DMA.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_DOFF        DMA.TCD[9].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD9_DLASTSGA    DMA.TCD[9].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD9_BITER_ELINKNO DMA.TCD[9].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_BITER_ELINKYES DMA.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_CSR         DMA.TCD[9].CSR.R              /* TCD Control and Status */
#define DMA_TCD10_SADDR      DMA.TCD[10].SADDR.R           /* TCD Source Address */
#define DMA_TCD10_ATTR       DMA.TCD[10].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD10_SOFF       DMA.TCD[10].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD10_NBYTES_MLNO DMA.TCD[10].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD10_NBYTES_MLOFFNO DMA.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD10_NBYTES_MLOFFYES DMA.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD10_SLAST      DMA.TCD[10].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD10_DADDR      DMA.TCD[10].DADDR.R           /* TCD Destination Address */
#define DMA_TCD10_CITER_ELINKNO DMA.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_CITER_ELINKYES DMA.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_DOFF       DMA.TCD[10].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD10_DLASTSGA   DMA.TCD[10].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD10_BITER_ELINKNO DMA.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_BITER_ELINKYES DMA.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_CSR        DMA.TCD[10].CSR.R             /* TCD Control and Status */
#define DMA_TCD11_SADDR      DMA.TCD[11].SADDR.R           /* TCD Source Address */
#define DMA_TCD11_ATTR       DMA.TCD[11].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD11_SOFF       DMA.TCD[11].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD11_NBYTES_MLNO DMA.TCD[11].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD11_NBYTES_MLOFFNO DMA.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD11_NBYTES_MLOFFYES DMA.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD11_SLAST      DMA.TCD[11].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD11_DADDR      DMA.TCD[11].DADDR.R           /* TCD Destination Address */
#define DMA_TCD11_CITER_ELINKNO DMA.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_CITER_ELINKYES DMA.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_DOFF       DMA.TCD[11].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD11_DLASTSGA   DMA.TCD[11].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD11_BITER_ELINKNO DMA.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_BITER_ELINKYES DMA.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_CSR        DMA.TCD[11].CSR.R             /* TCD Control and Status */
#define DMA_TCD12_SADDR      DMA.TCD[12].SADDR.R           /* TCD Source Address */
#define DMA_TCD12_ATTR       DMA.TCD[12].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD12_SOFF       DMA.TCD[12].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD12_NBYTES_MLNO DMA.TCD[12].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD12_NBYTES_MLOFFNO DMA.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD12_NBYTES_MLOFFYES DMA.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD12_SLAST      DMA.TCD[12].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD12_DADDR      DMA.TCD[12].DADDR.R           /* TCD Destination Address */
#define DMA_TCD12_CITER_ELINKNO DMA.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_CITER_ELINKYES DMA.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_DOFF       DMA.TCD[12].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD12_DLASTSGA   DMA.TCD[12].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD12_BITER_ELINKNO DMA.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_BITER_ELINKYES DMA.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_CSR        DMA.TCD[12].CSR.R             /* TCD Control and Status */
#define DMA_TCD13_SADDR      DMA.TCD[13].SADDR.R           /* TCD Source Address */
#define DMA_TCD13_ATTR       DMA.TCD[13].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD13_SOFF       DMA.TCD[13].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD13_NBYTES_MLNO DMA.TCD[13].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD13_NBYTES_MLOFFNO DMA.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD13_NBYTES_MLOFFYES DMA.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD13_SLAST      DMA.TCD[13].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD13_DADDR      DMA.TCD[13].DADDR.R           /* TCD Destination Address */
#define DMA_TCD13_CITER_ELINKNO DMA.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_CITER_ELINKYES DMA.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_DOFF       DMA.TCD[13].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD13_DLASTSGA   DMA.TCD[13].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD13_BITER_ELINKNO DMA.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_BITER_ELINKYES DMA.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_CSR        DMA.TCD[13].CSR.R             /* TCD Control and Status */
#define DMA_TCD14_SADDR      DMA.TCD[14].SADDR.R           /* TCD Source Address */
#define DMA_TCD14_ATTR       DMA.TCD[14].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD14_SOFF       DMA.TCD[14].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD14_NBYTES_MLNO DMA.TCD[14].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD14_NBYTES_MLOFFNO DMA.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD14_NBYTES_MLOFFYES DMA.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD14_SLAST      DMA.TCD[14].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD14_DADDR      DMA.TCD[14].DADDR.R           /* TCD Destination Address */
#define DMA_TCD14_CITER_ELINKNO DMA.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_CITER_ELINKYES DMA.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_DOFF       DMA.TCD[14].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD14_DLASTSGA   DMA.TCD[14].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD14_BITER_ELINKNO DMA.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_BITER_ELINKYES DMA.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_CSR        DMA.TCD[14].CSR.R             /* TCD Control and Status */
#define DMA_TCD15_SADDR      DMA.TCD[15].SADDR.R           /* TCD Source Address */
#define DMA_TCD15_ATTR       DMA.TCD[