/**************************************************************************/
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This is a generic base template for all core exceptions, excluding     */
/* IVOR4 exceptions which have separate handler                           */
/*                                                                        */
/* This file starts in memory at the beginning of the                     */
/*".core_exceptions_table" section.                                       */
/**************************************************************************/

.globl VTABLE

.globl IVOR0_Vector
.globl IVOR1_Vector
.globl IVOR2_Vector
.globl IVOR3_Vector
.globl IVOR4_Vector
.globl IVOR5_Vector
.globl IVOR6_Vector
.globl IVOR7_Vector
.globl IVOR8_Vector
.globl IVOR9_Vector
.globl IVOR10_Vector
.globl IVOR11_Vector
.globl IVOR12_Vector
.globl IVOR13_Vector
.globl IVOR14_Vector
.globl IVOR15_Vector

.extern     IVOR4_Handler
#ifdef __GNUC__   /* GCC */
 .section    .core_exceptions_table, "axv"
 #define VEC_ALIGN .align 4
#endif
#ifdef __ghs__
  .section    .core_exceptions_table, axv
  .vle
  #define VEC_ALIGN .skip 0x0C
#endif
#ifdef __DCC__ /* Diab */
 .section ".core_exceptions_table",4,rx
  #define VEC_ALIGN .align 4
#endif

VEC_ALIGN;
VTABLE: /* -- Vector table start -- */
IVOR0_Vector:
           e_b   IVOR0_Vector /* self branch*/

VEC_ALIGN;
IVOR1_Vector:
           e_b   IVOR1_Vector /* self branch*/

VEC_ALIGN;
 IVOR2_Vector:
           e_b   IVOR2_Vector /* self branch*/

VEC_ALIGN;
IVOR3_Vector:
           e_b   IVOR3_Vector /* self branch*/

VEC_ALIGN;
IVOR4_Vector:
           e_b   IVOR4_Handler /*separate handler*/
VEC_ALIGN;
IVOR5_Vector:
           e_b   IVOR5_Vector /* self branch*/

VEC_ALIGN;
IVOR6_Vector:
           e_b   IVOR6_Vector /* self branch*/

VEC_ALIGN;
IVOR7_Vector:
           e_b   IVOR7_Vector /* self branch*/

VEC_ALIGN;
IVOR8_Vector:
           e_b   IVOR8_Vector /* self branch*/

VEC_ALIGN;
IVOR9_Vector:
            e_b   IVOR9_Vector /* self branch*/

VEC_ALIGN;
IVOR10_Vector:
            e_b   IVOR10_Vector /* self branch*/

VEC_ALIGN;
IVOR11_Vector:
            e_b   IVOR11_Vector /* self branch*/

VEC_ALIGN;
IVOR12_Vector:
            e_b   IVOR12_Vector /* self branch*/

VEC_ALIGN;
IVOR13_Vector:
            e_b   IVOR13_Vector /* self branch*/

VEC_ALIGN;
IVOR14_Vector:
            e_b   IVOR14_Vector /* self branch*/

VEC_ALIGN;
IVOR15_Vector:
            e_b   IVOR15_Vector /* self branch*/


