/**************************************************************************
 * FILE NAME: S32R372.h                      COPYRIGHT (c) Freescale 2016 *
 * REVISION:  1.0                                     All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the S32R372.                                                           *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1     M.Doidge   17-Mar-16    Initial Release based on RM/RDP        *
 *                                 Rev 1 Draft E                          *
 * 1.0     Lazarescu  08-Dec-16    Release based on RM/RDP Rev1           *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _S32R372_H_
#define _S32R372_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;                 /* Overwrite enable. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t NSTART:1;
    vuint32_t _unused_23:1;
    vuint32_t JTRGEN:1;                /* Injection external trigger enable. */
    vuint32_t JEDGE:1;                 /* Injection trigger edge selection. */
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t _unused_18:2;
    vuint32_t CTUEN:1;                 /* Crosstrigger Unit Enable. */
    vuint32_t _unused_16:1;
    vuint32_t STCL:1;                  /* Self Testing Configuration Lock. */
    vuint32_t _unused_9:6;
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t PWDN:1;                  /* Power-down enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
    vuint32_t _unused_25:6;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t JABORT:1;
    vuint32_t _unused_21:2;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t _unused_19:1;
    vuint32_t SELF_TEST_S:1;           /* This status bit signals that self test conversion is ongoing. */
    vuint32_t _unused_17:1;
    vuint32_t CTUSTART:1;              /* This status bit is used to signal that a CTU conversion is ongoing. */
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t _unused_6:3;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EOCTU:1;
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t ECH:1;                   /* End of chain conversion. */
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_5:10;
    vuint32_t MSKEOCTU:1;              /* Mask bit for EOCTU. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t WDG15H:1;
    vuint32_t WDG15L:1;
    vuint32_t WDG14H:1;
    vuint32_t WDG14L:1;
    vuint32_t WDG13H:1;
    vuint32_t WDG13L:1;
    vuint32_t WDG12H:1;
    vuint32_t WDG12L:1;
    vuint32_t WDG11H:1;
    vuint32_t WDG11L:1;
    vuint32_t WDG10H:1;
    vuint32_t WDG10L:1;
    vuint32_t WDG9H:1;
    vuint32_t WDG9L:1;
    vuint32_t WDG8H:1;
    vuint32_t WDG8L:1;
    vuint32_t WDG7H:1;
    vuint32_t WDG7L:1;
    vuint32_t WDG6H:1;
    vuint32_t WDG6L:1;
    vuint32_t WDG5H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKWDG15H:1;
    vuint32_t MSKWDG15L:1;
    vuint32_t MSKWDG14H:1;
    vuint32_t MSKWDG14L:1;
    vuint32_t MSKWDG13H:1;
    vuint32_t MSKWDG13L:1;
    vuint32_t MSKWDG12H:1;
    vuint32_t MSKWDG12L:1;
    vuint32_t MSKWDG11H:1;
    vuint32_t MSKWDG11L:1;
    vuint32_t MSKWDG10H:1;
    vuint32_t MSKWDG10L:1;
    vuint32_t MSKWDG9H:1;
    vuint32_t MSKWDG9L:1;
    vuint32_t MSKWDG8H:1;
    vuint32_t MSKWDG8L:1;
    vuint32_t MSKWDG7H:1;
    vuint32_t MSKWDG7L:1;
    vuint32_t MSKWDG6H:1;
    vuint32_t MSKWDG6L:1;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t DCLR:1;                  /* DMA Clear sequence enable. */
    vuint32_t DMAEN:1;                 /* DMA global enable. */
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_THRHLR0_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR0_tag;

typedef union ADC_THRHLR1_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR1_tag;

typedef union ADC_THRHLR2_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR2_tag;

typedef union ADC_THRHLR3_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR3_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t _unused_5:2;
    vuint32_t PREVAL1:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PRECONV:1;               /* Convert Presampled value */
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR1_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t PDED:8;
  } B;
} ADC_PDEDR_tag;

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
  } B;
} ADC_CDR_tag;

typedef union ADC_THRHLR4_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR4_tag;

typedef union ADC_THRHLR5_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR5_tag;

typedef union ADC_THRHLR6_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR6_tag;

typedef union ADC_THRHLR7_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR7_tag;

typedef union ADC_THRHLR8_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR8_tag;

typedef union ADC_THRHLR9_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR9_tag;

typedef union ADC_THRHLR10_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR10_tag;

typedef union ADC_THRHLR11_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR11_tag;

typedef union ADC_THRHLR12_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR12_tag;

typedef union ADC_THRHLR13_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR13_tag;

typedef union ADC_THRHLR14_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR14_tag;

typedef union ADC_THRHLR15_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR15_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_STCR1_union_tag {    /* Self Test Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP_C:8;
    vuint32_t _unused_16:8;
    vuint32_t INPSAMP_S:8;
    vuint32_t _unused_3:5;
    vuint32_t _unused_0:3;
  } B;
} ADC_STCR1_tag;

typedef union ADC_STCR2_union_tag {    /* Self Test Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MSKWDSERR:1;
    vuint32_t SERR:1;
    vuint32_t MSKWDTERR:1;             /* Interrupt enable (STSR[WDTERR] status bit) */
    vuint32_t _unused_24:1;
    vuint32_t MSKST_EOC:1;             /* Interrupt Enable bit for STSR2[ST_EOC] */
    vuint32_t _unused_19:4;
    vuint32_t MSKWDG_EOA_C:1;          /* Interrupt enable (WDG_EOA_C status bit) */
    vuint32_t _unused_17:1;
    vuint32_t MSKWDG_EOA_S:1;          /* Interrupt enable (WDG_EOA_S status bit) */
    vuint32_t MSKERR_C:1;              /* Interrupt enable (ERR_C status bit) */
    vuint32_t _unused_14:1;
    vuint32_t MSKERR_S2:1;             /* Interrupt enable (ERR_S2 status bit) */
    vuint32_t MSKERR_S1:1;             /* Interrupt enable (ERR_S1 status bit) */
    vuint32_t MSKERR_S0:1;             /* Interrupt enable (ERR_S0 status bit) */
    vuint32_t _unused_8:3;
    vuint32_t EN:1;                    /* Self testing channel enable. The TEST conversions are enabled. */
    vuint32_t _unused_5:2;
    vuint32_t FMA_WDSERR:1;            /* Fault mapping for the Watchdog Sequence error. */
    vuint32_t FMA_WDTERR:1;            /* Fault mapping for the Watchdog Timer error. */
    vuint32_t FMA_C:1;                 /* Fault mapping for self test algorithm C. */
    vuint32_t _unused_1:1;
    vuint32_t FMA_S:1;                 /* Fault mapping for the self test algorithm BGAP. */
  } B;
} ADC_STCR2_tag;

typedef union ADC_STCR3_union_tag {    /* Self Test Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t ALG:2;                   /* Algorithm scheduling. */
    vuint32_t _unused_5:3;
    vuint32_t MSTEP:5;
  } B;
} ADC_STCR3_tag;

typedef union ADC_STBRR_union_tag {    /* Self Test Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t WDT:3;
    vuint32_t _unused_8:8;
    vuint32_t BR:8;                    /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
  } B;
} ADC_STBRR_tag;

typedef union ADC_STSR1_union_tag {    /* Self Test Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t WDSERR:1;
    vuint32_t _unused_26:1;
    vuint32_t WDTERR:1;
    vuint32_t OVERWR:1;                /* Overwrite error. */
    vuint32_t ST_EOC:1;                /* Self Test EOC Bit. */
    vuint32_t _unused_19:4;
    vuint32_t WDG_EOA_C:1;
    vuint32_t _unused_17:1;
    vuint32_t WDG_EOA_S:1;
    vuint32_t ERR_C:1;
    vuint32_t _unused_14:1;
    vuint32_t ERR_S2:1;
    vuint32_t ERR_S1:1;
    vuint32_t ERR_S0:1;
    vuint32_t _unused_10:1;
    vuint32_t STEP_C:5;                /* Step of the algorithm C when an ERR_C has occurred. */
    vuint32_t _unused_0:5;
  } B;
} ADC_STSR1_tag;

typedef union ADC_STSR2_union_tag {    /* Self Test Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t OVFL:1;                  /* Overflow Bit */
    vuint32_t _unused_28:3;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S1 has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t DATA0:12;                /* Test channel converted data when the ERR_S1 has occurred. */
  } B;
} ADC_STSR2_tag;

typedef union ADC_STSR3_union_tag {    /* Self Test Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S2 has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t DATA0:12;                /* Test channel converted data when the ERR_S0 has occurred. */
  } B;
} ADC_STSR3_tag;

typedef union ADC_STSR4_union_tag {    /* Self Test Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_C has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t _unused_0:12;
  } B;
} ADC_STSR4_tag;

typedef union ADC_STDR1_union_tag {    /* Self Test Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t _unused_12:6;
    vuint32_t TCDATA:12;               /* Test channel converted data. */
  } B;
} ADC_STDR1_tag;

typedef union ADC_STDR2_union_tag {    /* Self Test Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FDATA:12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t _unused_12:6;
    vuint32_t IDATA:12;
  } B;
} ADC_STDR2_tag;

typedef union ADC_STAW0R_union_tag {   /* Self Test Analog Watchdog Register 0 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the algorithm S (step 0)) */
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm S) */
    vuint32_t _unused_28:2;
    vuint32_t THRH:12;                 /* High threshold value for Algorithm S step 0 */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for Algorithm S step 0 */
  } B;
} ADC_STAW0R_tag;

typedef union ADC_STAW1AR_union_tag {  /* Self Test Analog Watchdog Register 1A */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step1). */
    vuint32_t _unused_28:3;
    vuint32_t THRH:12;                 /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1AR_tag;

typedef union ADC_STAW1BR_union_tag {  /* Self Test Analog Watchdog Register 1B */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1BR_tag;

typedef union ADC_STAW2R_union_tag {   /* Self Test Analog Watchdog Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step2). */
    vuint32_t _unused_12:19;
    vuint32_t THRL:12;                 /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1[ERR_S2] status bit is set if STDR1[TCDATA] < THRL. */
  } B;
} ADC_STAW2R_tag;

typedef union ADC_STAW4R_union_tag {   /* Self Test Analog Watchdog Register 4 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the algorithm C) */
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm C). */
    vuint32_t _unused_28:2;
    vuint32_t THRH:12;                 /* High threshold value for step 0 of C algorithm. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for step 0 of C algorithm. */
  } B;
} ADC_STAW4R_tag;

typedef union ADC_STAW5R_union_tag {   /* Self Test Analog Watchdog Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for step N of C algorithm (N = 1 to CS-1). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for step 0 of C algorithm. */
  } B;
} ADC_STAW5R_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t OPMODE:3;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t _unused_24:3;
    vuint32_t _unused_16:8;
    vuint32_t C_T_BUSY:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t _unused_1:2;
    vuint32_t TEST_EN:1;               /* Enable the test. */
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t GAIN_USER:10;
    vuint32_t _unused_8:8;
    vuint32_t OFFSET_USER:8;
  } B;
} ADC_OFSGNUSR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  uint8_t ADC_reserved1[8];
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  uint8_t ADC_reserved2[8];
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved3[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  uint8_t ADC_reserved4[24];
  ADC_THRHLR0_tag THRHLR0;             /* Threshold Register */
  ADC_THRHLR1_tag THRHLR1;             /* Threshold Register */
  ADC_THRHLR2_tag THRHLR2;             /* Threshold Register */
  ADC_THRHLR3_tag THRHLR3;             /* Threshold Register */
  uint8_t ADC_reserved5[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  uint8_t ADC_reserved6[12];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  uint8_t ADC_reserved7[8];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  uint8_t ADC_reserved8[12];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  uint8_t ADC_reserved9[16];
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved10[52];
  ADC_CDR_tag CDR[16];                 /* Channel Data Register n (Precision Channels) */
  uint8_t ADC_reserved11[320];
  ADC_THRHLR4_tag THRHLR4;             /* Threshold Register */
  ADC_THRHLR5_tag THRHLR5;             /* Threshold Register */
  ADC_THRHLR6_tag THRHLR6;             /* Threshold Register */
  ADC_THRHLR7_tag THRHLR7;             /* Threshold Register */
  ADC_THRHLR8_tag THRHLR8;             /* Threshold Register */
  ADC_THRHLR9_tag THRHLR9;             /* Threshold Register */
  ADC_THRHLR10_tag THRHLR10;           /* Threshold Register */
  ADC_THRHLR11_tag THRHLR11;           /* Threshold Register */
  ADC_THRHLR12_tag THRHLR12;           /* Threshold Register */
  ADC_THRHLR13_tag THRHLR13;           /* Threshold Register */
  ADC_THRHLR14_tag THRHLR14;           /* Threshold Register */
  ADC_THRHLR15_tag THRHLR15;           /* Threshold Register */
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  uint8_t ADC_reserved12[40];
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  uint8_t ADC_reserved13[12];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  uint8_t ADC_reserved14[76];
  ADC_STCR1_tag STCR1;                 /* Self Test Configuration Register 1 */
  ADC_STCR2_tag STCR2;                 /* Self Test Configuration Register 2 */
  ADC_STCR3_tag STCR3;                 /* Self Test Configuration Register 3 */
  ADC_STBRR_tag STBRR;                 /* Self Test Baud Rate Register */
  ADC_STSR1_tag STSR1;                 /* Self Test Status Register 1 */
  ADC_STSR2_tag STSR2;                 /* Self Test Status Register 2 */
  ADC_STSR3_tag STSR3;                 /* Self Test Status Register 3 */
  ADC_STSR4_tag STSR4;                 /* Self Test Status Register 4 */
  uint8_t ADC_reserved15[16];
  ADC_STDR1_tag STDR1;                 /* Self Test Data Register 1 */
  ADC_STDR2_tag STDR2;                 /* Self Test Data Register 2 */
  uint8_t ADC_reserved16[8];
  ADC_STAW0R_tag STAW0R;               /* Self Test Analog Watchdog Register 0 */
  ADC_STAW1AR_tag STAW1AR;             /* Self Test Analog Watchdog Register 1A */
  ADC_STAW1BR_tag STAW1BR;             /* Self Test Analog Watchdog Register 1B */
  ADC_STAW2R_tag STAW2R;               /* Self Test Analog Watchdog Register 2 */
  uint8_t ADC_reserved17[4];
  ADC_STAW4R_tag STAW4R;               /* Self Test Analog Watchdog Register 4 */
  ADC_STAW5R_tag STAW5R;               /* Self Test Analog Watchdog Register 5 */
  uint8_t ADC_reserved18[4];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved19[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
};


/* ============================================================================
   =============================== Module: AFE ================================
   ============================================================================ */

typedef union AFE_OSCCTRL_union_tag {  /* Oscillator Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t _unused_16:4;
    vuint32_t _unused_15:1;
    vuint32_t IE:1;
    vuint32_t _unused_12:2;
    vuint32_t EN_EXT:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t ICAL:4;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} AFE_OSCCTRL_tag;

typedef union AFE_OSCSTS_union_tag {   /* Oscillator Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t _unused_1:1;
    vuint32_t STS:1;                   /* Oscillator status */
  } B;
} AFE_OSCSTS_tag;

typedef union AFE_OSCDLY_union_tag {   /* Oscillator Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EOCV:8;
  } B;
} AFE_OSCDLY_tag;

typedef union AFE_PLLCTRL1_union_tag { /* SDPLL Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t DCBIAS_HI_LIM:4;
    vuint32_t DCBIAS_LO_LIM:4;
    vuint32_t CLKGEN_EN:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_11:3;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t RST_B:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} AFE_PLLCTRL1_tag;

typedef union AFE_PLLCTRL2_union_tag { /* SDPLL Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FCAP_HI_LIM:6;
    vuint32_t _unused_22:2;
    vuint32_t FCAP_LO_LIM:6;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t START:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_PLLCTRL2_tag;

typedef union AFE_PLLCTRL3_union_tag { /* SDPLL Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t LW64:1;
    vuint32_t _unused_12:1;
    vuint32_t LORIE:1;
    vuint32_t CP_I_SEL:3;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t LCKHIIE:1;
    vuint32_t LCKLOIE:1;
  } B;
} AFE_PLLCTRL3_tag;

typedef union AFE_PLLCTRL8_union_tag { /* SDPLL Control Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t REFCLK_CNT:4;            /* Programmable reference clock count */
    vuint32_t _unused_11:1;
    vuint32_t FCLKBY2_CNT:11;          /* Programmable Fvco/2 clock count */
  } B;
} AFE_PLLCTRL8_tag;

typedef union AFE_PLLSTS_union_tag {   /* SDPLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t LCKLOSS:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t CALERR:1;
    vuint32_t LOR:1;
    vuint32_t LOCK:1;                  /* SDPLL lock indicator */
  } B;
} AFE_PLLSTS_tag;

typedef union AFE_VRFCTRL1_union_tag { /* VREF Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t _unused_16:6;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t _unused_5:2;
    vuint32_t _unused_4:1;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRFCTRL1_tag;

typedef union AFE_LVDSTS_union_tag {   /* Low Voltage Detect Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t BGOK:1;
    vuint32_t _unused_0:25;
  } B;
} AFE_LVDSTS_tag;

typedef union AFE_VRGCTRL5_union_tag { /* VREG5 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL5_tag;

typedef union AFE_VRGCTRL6_union_tag { /* VREG6 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL6_tag;

typedef union AFE_VRGCTRL7_union_tag { /* VREG7 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL7_tag;

typedef union AFE_VRGCTRL8_union_tag { /* VREG8 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL8_tag;

struct AFE_tag {
  AFE_OSCCTRL_tag OSCCTRL;             /* Oscillator Control Register */
  AFE_OSCSTS_tag OSCSTS;               /* Oscillator Status Register */
  AFE_OSCDLY_tag OSCDLY;               /* Oscillator Delay Register */
  AFE_PLLCTRL1_tag PLLCTRL1;           /* SDPLL Control Register 1 */
  AFE_PLLCTRL2_tag PLLCTRL2;           /* SDPLL Control Register 2 */
  AFE_PLLCTRL3_tag PLLCTRL3;           /* SDPLL Control Register 3 */
  uint8_t AFE_reserved0[16];
  AFE_PLLCTRL8_tag PLLCTRL8;           /* SDPLL Control Register 8 */
  AFE_PLLSTS_tag PLLSTS;               /* SDPLL Status Register */
  uint8_t AFE_reserved1[36];
  AFE_VRFCTRL1_tag VRFCTRL1;           /* VREF Control Register 1 */
  uint8_t AFE_reserved2[4];
  AFE_LVDSTS_tag LVDSTS;               /* Low Voltage Detect Status Register */
  uint8_t AFE_reserved3[16];
  AFE_VRGCTRL5_tag VRGCTRL5;           /* VREG5 Control Register */
  AFE_VRGCTRL6_tag VRGCTRL6;           /* VREG6 Control Register */
  AFE_VRGCTRL7_tag VRGCTRL7;           /* VREG7 Control Register */
  AFE_VRGCTRL8_tag VRGCTRL8;           /* VREG8 Control Register */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t _unused_27:1;
    vuint32_t MTR1:1;                  /* Master 1 trusted for read */
    vuint32_t MTW1:1;                  /* Master 1 trusted for writes */
    vuint32_t MPL1:1;                  /* Master 1 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t _unused_19:1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t _unused_15:1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t _unused_11:1;
    vuint32_t MTR5:1;                  /* Master 5 Trusted For Read */
    vuint32_t MTW5:1;                  /* Master 5 Trusted For Writes */
    vuint32_t MPL5:1;                  /* Master 5 Privilege Level */
    vuint32_t _unused_7:1;
    vuint32_t MTR6:1;                  /* Master 6 trusted for read */
    vuint32_t MTW6:1;                  /* Master 6 trusted for writes */
    vuint32_t MPL6:1;                  /* Master 6 privilege level */
    vuint32_t _unused_3:1;
    vuint32_t MTR7:1;                  /* Master 7 trusted for read */
    vuint32_t MTW7:1;                  /* Master 7 trusted for writes */
    vuint32_t MPL7:1;                  /* Master 7 privilege level */
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR8:1;                  /* Master 8 trusted for read */
    vuint32_t MTW8:1;                  /* Master 8 trusted for writes */
    vuint32_t MPL8:1;                  /* Master 8 privilege level */
    vuint32_t _unused_27:1;
    vuint32_t MTR9:1;                  /* Master 9 trusted for read */
    vuint32_t MTW9:1;                  /* Master 9 trusted for writes */
    vuint32_t MPL9:1;                  /* Master 9 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR10:1;                 /* Master 10 trusted for read */
    vuint32_t MTW10:1;                 /* Master 10 trusted for writes */
    vuint32_t MPL10:1;                 /* Master 10 privilege level */
    vuint32_t _unused_19:1;
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t MTR12:1;                 /* Master 12 trusted for read */
    vuint32_t MTW12:1;                 /* Master 12 trusted for writes */
    vuint32_t MPL12:1;                 /* Master 12 privilege level */
    vuint32_t _unused_11:1;
    vuint32_t MTR13:1;                 /* Master 13 trusted for read */
    vuint32_t MTW13:1;                 /* Master 13 trusted for writes */
    vuint32_t MPL13:1;                 /* Master 13 Privilege Level */
    vuint32_t _unused_7:1;
    vuint32_t MTR14:1;                 /* Master 14 trusted for read */
    vuint32_t MTW14:1;                 /* Master 14 Trusted For Writes */
    vuint32_t MP14:1;                  /* Master 14 privilege level */
    vuint32_t _unused_3:1;
    vuint32_t MTR15:1;                 /* Master 15 Trusted For Read */
    vuint32_t MTW15:1;                 /* Master 15 trusted for writes */
    vuint32_t MPL15:1;                 /* Master 15 privilege level */
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACR_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[248];
  AIPS_PACR_tag PACR[8];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[32];
  AIPS_OPACR_tag OPACR[32];            /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

typedef union AXBS_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} AXBS_PORT_PRS_tag;

typedef union AXBS_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t HLP:1;                   /* Halt Low Priority */
    vuint32_t _unused_24:6;
    vuint32_t HPE7:1;
    vuint32_t HPE6:1;
    vuint32_t HPE5:1;
    vuint32_t HPE4:1;
    vuint32_t HPE3:1;
    vuint32_t HPE2:1;
    vuint32_t HPE1:1;
    vuint32_t HPE0:1;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} AXBS_PORT_CRS_tag;

typedef struct AXBS_PORT_struct_tag {
  AXBS_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  AXBS_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} AXBS_PORT_tag;

struct AXBS_tag {
  AXBS_PORT_tag PORT[8];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t _unused_16:12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t _unused_12:1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t _unused_29:2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t _unused_30:1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t _unused_0:3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t _unused_19:11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t _unused_10:6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t _unused_7:1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t _unused_3:1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t _unused_26:1;
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t _unused_22:1;
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t _unused_10:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_22:4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t _unused_19:1;
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t _unused_0:1;
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t _unused_30:1;
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t _unused_15:1;
    vuint32_t PREXCEN:1;               /* Protocol Exception Enable */
    vuint32_t _unused_13:1;
    vuint32_t ISOCANFDEN:1;            /* ISO CAN FD Enable */
    vuint32_t EDFLTDIS:1;              /* Edge Filter Disable */
    vuint32_t _unused_0:11;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t ERJW:5;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_CBT_tag;

typedef union CAN_IMASK3_union_tag {   /* Interrupt Masks 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK3_tag;

typedef union CAN_IFLAG3_union_tag {   /* Interrupt Flags 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG3_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t _unused_23:1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
    vuint32_t _unused_20:11;
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t _unused_10:3;
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t _unused_0:7;
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t INJADDR:14;              /* Error Injection Address */
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_21:3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_13:3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_5:3;
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_19:5;
    vuint32_t SAID:3;
    vuint32_t _unused_14:2;
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
    vuint32_t _unused_29:2;
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t _unused_21:2;
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t _unused_13:2;
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t _unused_5:2;
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_4:12;
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
  } B;
} CAN_ERRSR_tag;

typedef union CAN_FDCTRL_union_tag {   /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t _unused_27:4;
    vuint32_t _unused_25:2;
    vuint32_t _unused_24:1;
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t _unused_21:1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_18:1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t _unused_13:1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_6:2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_FDCTRL_tag;

typedef union CAN_FDCBT_union_tag {    /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_19:1;
    vuint32_t FRJW:3;                  /* Fast Resync Jump Width */
    vuint32_t _unused_15:1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_8:2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_3:2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_FDCBT_tag;

typedef union CAN_FDCRC_union_tag {    /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_21:3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_FDCRC_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[24];
  CAN_IMASK3_tag IMASK3;               /* Interrupt Masks 3 Register */
  uint8_t CAN_reserved3[4];
  CAN_IFLAG3_tag IFLAG3;               /* Interrupt Flags 3 Register */
  uint8_t CAN_reserved4[8];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved5[1024];
  CAN_RXIMR_tag RXIMR[96];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved6[224];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
  uint8_t CAN_reserved7[256];
  CAN_FDCTRL_tag FDCTRL;               /* CAN FD Control Register */
  CAN_FDCBT_tag FDCBT;                 /* CAN FD Bit Timing Register */
  CAN_FDCRC_tag FDCRC;                 /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_10:13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_3:5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CHANNEL_CFG_union_tag { /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_6:18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CHANNEL_CFG_tag;

typedef union CRC_CHANNEL_INP_union_tag { /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_CHANNEL_INP_tag;

typedef union CRC_CHANNEL_CSTAT_union_tag { /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CHANNEL_CSTAT_tag;

typedef union CRC_CHANNEL_OUTP_union_tag { /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_CHANNEL_OUTP_tag;

typedef struct CRC_CHANNEL_struct_tag {
  CRC_CHANNEL_CFG_tag CFG;             /* Configuration Register */
  CRC_CHANNEL_INP_tag INP;             /* Input Register */
  CRC_CHANNEL_CSTAT_tag CSTAT;         /* Current Status Register */
  CRC_CHANNEL_OUTP_tag OUTP;           /* Output Register */
} CRC_CHANNEL_tag;

struct CRC_tag {
  CRC_CHANNEL_tag CHANNEL[3];
};


/* ============================================================================
   =============================== Module: CSE ================================
   ============================================================================ */

typedef union CSE_CR_union_tag {       /* CSE Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DIV:8;
    vuint32_t _unused_6:2;
    vuint32_t KBS:1;
    vuint32_t SFE:1;
    vuint32_t MDIS:1;
    vuint32_t SUS:1;
    vuint32_t DRE:1;
    vuint32_t CIE:1;
  } B;
} CSE_CR_tag;

typedef union CSE_SR_union_tag {       /* CSE Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t EX:1;
    vuint32_t IDB:1;
    vuint32_t EDB:1;
    vuint32_t RIN:1;
    vuint32_t BOK:1;
    vuint32_t BFN:1;
    vuint32_t BIN:1;
    vuint32_t SB:1;
    vuint32_t BSY:1;
  } B;
} CSE_SR_tag;

typedef union CSE_IR_union_tag {       /* CSE Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CIF:1;
  } B;
} CSE_IR_tag;

typedef union CSE_ECR_union_tag {      /* CSE Error Code Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EC:5;
  } B;
} CSE_ECR_tag;

typedef union CSE_CMD_union_tag {      /* CSE Command Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t CMD:5;
  } B;
} CSE_CMD_tag;

typedef union CSE_P_union_tag {        /* CSE Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t PARM:32;
  } B;
} CSE_P_tag;

struct CSE_tag {
  CSE_CR_tag CR;                       /* CSE Control Register */
  CSE_SR_tag SR;                       /* CSE Status Register */
  CSE_IR_tag IR;                       /* CSE Interrupt Register */
  CSE_ECR_tag ECR;                     /* CSE Error Code Register */
  uint8_t CSE_reserved0[16];
  CSE_CMD_tag CMD;                     /* CSE Command Register */
  CSE_P_tag P[5];                      /* CSE Parameter Register */
};


/* ============================================================================
   =============================== Module: CTE ================================
   ============================================================================ */

typedef union CTE_CNTRL_union_tag {    /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFS_PGEN:1;              /* Internal SW RFS Pulse Trigger. This bit is to be used in Slave mode only. */
    vuint32_t CTE_RST:1;               /* CTE synchronous Reset */
    vuint32_t MA_SL_ST:1;              /* master/slave select */
    vuint32_t eDMA_CTL:2;              /* eDMA trigger control */
    vuint32_t OPMOD_SL:2;              /* CTE FSM operation mode select. */
    vuint32_t RCS_DLY:4;               /* Radar Chirp Synchronization Delay Control */
    vuint32_t RFS_DLY:4;               /* Radar Frame Synchronization Delay Control */
    vuint32_t REP_CNT:16;              /* Timing Table Repetition Counter */
  } B;
} CTE_CNTRL_tag;

typedef union CTE_CNTRL1_union_tag {   /* CTE Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t CKSM_RST:1;              /* Checksum Reset */
    vuint32_t CHKSM_MD:1;              /* Checksum Mode */
    vuint32_t CTE_EN:1;                /* CTE Enable */
    vuint32_t TIMEMODE:1;              /* Time mode type */
    vuint32_t _unused_22:2;
    vuint32_t CLKDIV_4:3;              /* 4th Clock divider */
    vuint32_t CLKDIV_3:3;              /* 3rd Clock divider */
    vuint32_t _unused_14:2;
    vuint32_t CLKDIV_2:3;              /* 2nd Clock divider */
    vuint32_t CLKDIV_1:3;              /* 1st Clock divider */
    vuint32_t _unused_6:2;
    vuint32_t CTECK_DV:6;              /* CTE Clock divider */
  } B;
} CTE_CNTRL1_tag;

typedef union CTE_LUT_LSB_union_tag {  /* First Timing Table Register (LSB) */
  vuint32_t R;
  struct {
    vuint32_t SPT_EVT:4;               /* SPT Event */
    vuint32_t SPT_PHIV:1;              /* SPT phase invert. */
    vuint32_t _unused_26:1;
    vuint32_t _unused_24:2;            /* This field is reserved. */
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t RCV_OVF:1;               /* Receiver Overflow Mask */
    vuint32_t _unused_16:1;
    vuint32_t TIME_0:16;               /* Time instance */
  } B;
} CTE_LUT_LSB_tag;

typedef union CTE_LUT_MSB_union_tag {  /* First Timing Table Register (MSB) */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;            /* This field is reserved. */
    vuint32_t _unused_23:1;
    vuint32_t ETIME_AX:2;              /* ETimer Auxiliary */
    vuint32_t ACQ_WIN:1;               /* CTE Acquisition Window */
    vuint32_t RFS_DEF:2;               /* RFS definition */
    vuint32_t RCS_DEF:2;               /* RCS definition */
    vuint32_t CTE_TYP7:2;              /* CTE Pulses */
    vuint32_t CTE_TYP6:2;              /* CTE Pulses */
    vuint32_t CTE_TYP5:2;              /* CTE Pulses */
    vuint32_t CTE_TYP4:2;              /* CTE Pulses */
    vuint32_t CTE_TYP3:2;              /* CTE Pulses */
    vuint32_t CTE_TYP2:2;              /* CTE Pulses */
    vuint32_t CTE_TYP1:2;              /* CTE Pulses */
    vuint32_t CTE_TYP0:2;              /* CTE Pulses */
  } B;
} CTE_LUT_MSB_tag;

typedef struct CTE_LUT_struct_tag {
  CTE_LUT_LSB_tag LSB[32];             /* First Timing Table Register (LSB) */
  CTE_LUT_MSB_tag MSB[32];             /* First Timing Table Register (MSB) */
} CTE_LUT_tag;

typedef union CTE_SIGTYPE0_union_tag { /* Signal Type Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CTE_TYP7:2;              /* CTE pulse type */
    vuint32_t CTE_TYP6:2;              /* CTE pulse type */
    vuint32_t CTE_TYP5:2;              /* CTE pulse type */
    vuint32_t CTE_TYP4:2;              /* CTE pulse type */
    vuint32_t CTE_TYP3:2;              /* CTE pulse type */
    vuint32_t CTE_TYP2:2;              /* CTE pulse type */
    vuint32_t CTE_TYP1:2;              /* CTE pulse type */
    vuint32_t CTE_TYP0:2;              /* CTE pulse type */
    vuint32_t _unused_15:1;
    vuint32_t STP_EVT:4;               /* SPT event type */
    vuint32_t PH_INVT:1;               /* Phase invert type */
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;             /* This field is reserved. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t RCV_OVF:1;               /* Receive overflow mask type */
    vuint32_t _unused_0:1;
  } B;
} CTE_SIGTYPE0_tag;

typedef union CTE_SIGTYPE1_union_tag { /* Signal Type Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t ETIME_AUX:2;             /* Etime Aux Type */
    vuint32_t ACQ_WIN:1;               /* Acquisition Window Type */
    vuint32_t RFS:2;                   /* Radar Frame Synchronization */
    vuint32_t RCS:2;                   /* Radar Chirp Synchronization */
  } B;
} CTE_SIGTYPE1_tag;

typedef union CTE_INTEN_union_tag {    /* CTE Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t LST_EXEN:1;              /* Last Table Execution Enable */
    vuint32_t eDMA_TEN:1;              /* eDMA Trigger Interrupt Enable */
    vuint32_t RFS_EN:1;                /* RFS interrupt enable (rising edge) */
    vuint32_t RCS_EN:1;                /* RCS interrupt enable (rising edge) */
    vuint32_t _unused_5:1;
    vuint32_t AC_WD_EN:1;              /* Acquisition window (rising) */
    vuint32_t TT1_EDEN:1;              /* Timing table end (rising) */
    vuint32_t TT0_EDEN:1;              /* Timing table end (rising) */
    vuint32_t TT1_STEN:1;              /* Timing table start (rising) */
    vuint32_t TT0_STEN:1;              /* Timing table start (rising) */
  } B;
} CTE_INTEN_tag;

typedef union CTE_INTSTAT_union_tag {  /* CTE Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t LAST_EXC:1;              /* Last Execution */
    vuint32_t eDMA_TRG:1;              /* eDMA Trigger */
    vuint32_t RFS:1;                   /* Radar Frame Synchronization */
    vuint32_t RCS:1;                   /* Radar Chirp Synchronization */
    vuint32_t _unused_5:1;
    vuint32_t ACQ_WIN:1;               /* Acquisition window (rising) */
    vuint32_t TT1_END:1;               /* TT1 end */
    vuint32_t TT0_END:1;               /* TT0 end */
    vuint32_t TT1_STRT:1;              /* TT1 start */
    vuint32_t TT0_STRT:1;              /* TT0 start */
  } B;
} CTE_INTSTAT_tag;

typedef union CTE_RCVOFCNT_union_tag { /* Receiver Overflow Counter */
  vuint32_t R;
  struct {
    vuint32_t RCV_OVCT:32;             /* Receiver Overflow counter */
  } B;
} CTE_RCVOFCNT_tag;

typedef union CTE_CKSM_LSB_union_tag { /* LUT Checksum Register */
  vuint32_t R;
  struct {
    vuint32_t CHKS_LSB:32;             /* Checksum Result LSB */
  } B;
} CTE_CKSM_LSB_tag;

typedef union CTE_CKSM_MSB_union_tag { /* LUT Checksum Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t _unused_8:1;
    vuint32_t CHKS_MSB:8;              /* Checksum Result LSB */
  } B;
} CTE_CKSM_MSB_tag;

typedef union CTE_DBG_REG_union_tag {  /* Debug Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t FSM_ST:2;                /* OPMOD FSM state */
    vuint32_t SLV_ALGN:1;              /* RFS/RCS align status */
    vuint32_t CONT_ERR:1;              /* Timing Table contention error */
    vuint32_t LUT_SEL:1;               /* TT Select */
  } B;
} CTE_DBG_REG_tag;

typedef union CTE_LUT_DUR_union_tag {  /* TT0 Execution Duration Register */
  vuint32_t R;
  struct {
    vuint32_t TT0_DUR:32;              /* TT0 Duration */
  } B;
} CTE_LUT_DUR_tag;

typedef union CTE_LUT_DUR1_union_tag { /* TT1 Execution Duration Register */
  vuint32_t R;
  struct {
    vuint32_t TT1_DUR:32;              /* TT1_DURATION */
  } B;
} CTE_LUT_DUR1_tag;

typedef union CTE_CLKSEL_union_tag {   /* Clock Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t CLK_SEL9:2;              /* Clock Select */
    vuint32_t CLK_SEL8:2;              /* Clock Select */
    vuint32_t CLK_SEL7:2;              /* Clock Select */
    vuint32_t CLK_SEL6:2;              /* Clock Select */
    vuint32_t CLK_SEL5:2;              /* Clock Select */
    vuint32_t CLK_SEL4:2;              /* Clock Select */
    vuint32_t CLK_SEL3:2;              /* Clock Select */
    vuint32_t CLK_SEL2:2;              /* Clock Select */
    vuint32_t CLK_SEL1:2;              /* Clock Select. These bits are used to select one of the 4 available clock dividers for ctep1 when it is defined as clock type. */
    vuint32_t CLK_SEL0:2;              /* Clock Select */
  } B;
} CTE_CLKSEL_tag;

struct CTE_tag {
  CTE_CNTRL_tag CNTRL;                 /* Control Register */
  CTE_CNTRL1_tag CNTRL1;               /* CTE Control Register 1 */
  CTE_LUT_tag LUT[2];
  CTE_SIGTYPE0_tag SIGTYPE0[2];        /* Signal Type Register 0 */
  CTE_SIGTYPE1_tag SIGTYPE1[2];        /* Signal Type Register 1 */
  uint8_t CTE_reserved0[8];
  CTE_INTEN_tag INTEN;                 /* CTE Interrupt Enable Register */
  CTE_INTSTAT_tag INTSTAT;             /* CTE Interrupt Status Register */
  uint8_t CTE_reserved1[4];
  CTE_RCVOFCNT_tag RCVOFCNT;           /* Receiver Overflow Counter */
  uint8_t CTE_reserved2[64];
  CTE_CKSM_LSB_tag CKSM_LSB;           /* LUT Checksum Register */
  CTE_CKSM_MSB_tag CKSM_MSB;           /* LUT Checksum Register */
  CTE_DBG_REG_tag DBG_REG;             /* Debug Register */
  CTE_LUT_DUR_tag LUT_DUR;             /* TT0 Execution Duration Register */
  CTE_LUT_DUR1_tag LUT_DUR1;           /* TT1 Execution Duration Register */
  CTE_CLKSEL_tag CLKSEL;               /* Clock Select Register */
};


/* ============================================================================
   =============================== Module: CTU ================================
   ============================================================================ */

typedef union CTU_TGSISR_union_tag {   /* Trigger Generator Subunit Input Selection Register */
  vuint32_t R;
  struct {
    vuint32_t I15_FE:1;                /* Input 15 Falling Edge Enable. */
    vuint32_t I15_RE:1;                /* Input 15 Rising Edge Enable. */
    vuint32_t I14_FE:1;                /* Input 14 Falling Edge Enable. */
    vuint32_t I14_RE:1;                /* Input 14 Rising Edge Enable. */
    vuint32_t I13_FE:1;                /* Input 13 Falling Edge Enable. */
    vuint32_t I13_RE:1;                /* Input 13 Rising Edge Enable. */
    vuint32_t I12_FE:1;                /* Input 12 Falling Edge Enable. */
    vuint32_t I12_RE:1;                /* Input 12 Rising Edge Enable. */
    vuint32_t I11_FE:1;                /* Input 11 Falling Edge Enable. */
    vuint32_t I11_RE:1;                /* Input 11 Rising Edge Enable. */
    vuint32_t I10_FE:1;                /* Input 10 Falling Edge Enable. */
    vuint32_t I10_RE:1;                /* Input 10 Rising Edge Enable. */
    vuint32_t I9_FE:1;                 /* Input 9 Falling Edge Enable. */
    vuint32_t I9_RE:1;                 /* Input 9 Rising Edge Enable. */
    vuint32_t I8_FE:1;                 /* Input 8 Falling Edge Enable. */
    vuint32_t I8_RE:1;                 /* Input 8 Rising Edge Enable. */
    vuint32_t I7_FE:1;                 /* Input 7 Falling Edge Enable. */
    vuint32_t I7_RE:1;                 /* Input 7 Rising Edge Enable. */
    vuint32_t I6_FE:1;                 /* Input 6 Falling Edge Enable. */
    vuint32_t I6_RE:1;                 /* Input 6 Rising Edge Enable. */
    vuint32_t I5_FE:1;                 /* Input 5 Falling Edge Enable. */
    vuint32_t I5_RE:1;                 /* Input 5 Rising Edge Enable. */
    vuint32_t I4_FE:1;                 /* Input 4 Falling Edge Enable. */
    vuint32_t I4_RE:1;                 /* Input 4 Rising Edge Enable. */
    vuint32_t I3_FE:1;                 /* Input 3 Falling Edge Enable. */
    vuint32_t I3_RE:1;                 /* Input 3 Rising edge Enable */
    vuint32_t I2_FE:1;                 /* Input 2 Falling Edge Enable. */
    vuint32_t I2_RE:1;                 /* Input 2 Rising Edge Enable. */
    vuint32_t I1_FE:1;                 /* Input 1 Falling Edge Enable. */
    vuint32_t I1_RE:1;                 /* Input 1 Rising edge Enable */
    vuint32_t I0_FE:1;                 /* Input 0 Falling Edge Enable. */
    vuint32_t I0_RE:1;                 /* Input 0 Rising Edge Enable. */
  } B;
} CTU_TGSISR_tag;

typedef union CTU_TGSCR_union_tag {    /* Trigger Generator Subunit Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t ET_TM:1;
    vuint16_t PRES:2;
    vuint16_t MRS_SM:5;
    vuint16_t TGS_M:1;
  } B;
} CTU_TGSCR_tag;

typedef union CTU_TCR_union_tag {      /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;
  } B;
} CTU_TCR_tag;

typedef union CTU_TGSCCR_union_tag {   /* TGS Counter Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TGSCCV:16;
  } B;
} CTU_TGSCCR_tag;

typedef union CTU_TGSCRR_union_tag {   /* TGS Counter Reload Register */
  vuint16_t R;
  struct {
    vuint16_t TGSCRV:16;
  } B;
} CTU_TGSCRR_tag;

typedef union CTU_CLCR1_union_tag {    /* Commands List Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t T3_INDEX:5;
    vuint32_t _unused_21:3;
    vuint32_t T2_INDEX:5;
    vuint32_t _unused_13:3;
    vuint32_t T1_INDEX:5;
    vuint32_t _unused_5:3;
    vuint32_t T0_INDEX:5;
  } B;
} CTU_CLCR1_tag;

typedef union CTU_CLCR2_union_tag {    /* Commands List Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t T7_INDEX:5;
    vuint32_t _unused_21:3;
    vuint32_t T6_INDEX:5;
    vuint32_t _unused_13:3;
    vuint32_t T5_INDEX:5;
    vuint32_t _unused_5:3;
    vuint32_t T4_INDEX:5;
  } B;
} CTU_CLCR2_tag;

typedef union CTU_THCR1_union_tag {    /* Trigger Handler Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t T3_E:1;
    vuint32_t T3_ETE:1;
    vuint32_t T3_T4E:1;
    vuint32_t T3_T3E:1;
    vuint32_t T3_T2E:1;
    vuint32_t T3_T1E:1;
    vuint32_t T3_ADCE:1;
    vuint32_t _unused_23:1;
    vuint32_t T2_E:1;
    vuint32_t T2_ETE:1;
    vuint32_t T2_T4E:1;
    vuint32_t T2_T3E:1;
    vuint32_t T2_T2E:1;
    vuint32_t T2_T1E:1;
    vuint32_t T2_ADCE:1;
    vuint32_t _unused_15:1;
    vuint32_t T1_E:1;
    vuint32_t T1_ETE:1;
    vuint32_t T1_T4E:1;
    vuint32_t T1_T3E:1;
    vuint32_t T1_T2E:1;
    vuint32_t T1_T1E:1;
    vuint32_t T1_ADCE:1;
    vuint32_t _unused_7:1;
    vuint32_t T0_E:1;
    vuint32_t T0_ETE:1;
    vuint32_t T0_T4E:1;
    vuint32_t T0_T3E:1;
    vuint32_t T0_T2E:1;
    vuint32_t T0_T1E:1;
    vuint32_t T0_ADCE:1;
  } B;
} CTU_THCR1_tag;

typedef union CTU_THCR2_union_tag {    /* Trigger Handler Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t T7_E:1;
    vuint32_t T7_ETE:1;
    vuint32_t T7_T4E:1;
    vuint32_t T7_T3E:1;
    vuint32_t T7_T2E:1;
    vuint32_t T7_T1E:1;
    vuint32_t T7_ADCE:1;
    vuint32_t _unused_23:1;
    vuint32_t T6_E:1;
    vuint32_t T6_ETE:1;
    vuint32_t T6_T4E:1;
    vuint32_t T6_T3E:1;
    vuint32_t T6_T2E:1;
    vuint32_t T6_T1E:1;
    vuint32_t T6_ADCE:1;
    vuint32_t _unused_15:1;
    vuint32_t T5_E:1;
    vuint32_t T5_ETE:1;
    vuint32_t T5_T4E:1;
    vuint32_t T5_T3E:1;
    vuint32_t T5_T2E:1;
    vuint32_t T5_T1E:1;
    vuint32_t T5_ADCE:1;
    vuint32_t _unused_7:1;
    vuint32_t T4_E:1;
    vuint32_t T4_ETE:1;
    vuint32_t T4_T4E:1;
    vuint32_t T4_T3E:1;
    vuint32_t T4_T2E:1;
    vuint32_t T4_T1E:1;
    vuint32_t T4_ADCE:1;
  } B;
} CTU_THCR2_tag;

typedef union CTU_CHANNEL_CLR_A_union_tag { /* Commands List Register A for ADC single-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t CMS:1;
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t ST0:1;
    vuint16_t _unused_6:3;
    vuint16_t SU:1;                    /* ADC Port A / Port B selection. */
    vuint16_t _unused_4:1;
    vuint16_t CH:4;                    /* ADC Port channel number. */
  } B;
} CTU_CHANNEL_CLR_A_tag;

typedef union CTU_CHANNEL_CLR_B_union_tag { /* Command List Register B for ADC dual-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t CMS:1;
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t ST0:1;                   /* Sel-Test mode control 0. Must be 0 in this register format. */
    vuint16_t CH_B:4;                  /* ADC Port B channel number. */
    vuint16_t _unused_4:1;             /* Reserved. */
    vuint16_t CH_A:4;                  /* ADC Port A channel number. */
  } B;
} CTU_CHANNEL_CLR_B_tag;

typedef union CTU_CHANNEL_CLR_C_union_tag { /* Command List Register C for self-test commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t ST1:1;
    vuint16_t ST_CMS:1;
    vuint16_t ST_SU:1;
    vuint16_t _unused_10:1;
    vuint16_t ST0:1;
    vuint16_t ALG:2;
    vuint16_t BSIZE:7;
  } B;
} CTU_CHANNEL_CLR_C_tag;

typedef union CTU_CHANNEL_union_tag {
  CTU_CHANNEL_CLR_A_tag CLR_A;         /* Commands List Register A for ADC single-conversion mode commands */
  CTU_CHANNEL_CLR_B_tag CLR_B;         /* Command List Register B for ADC dual-conversion mode commands */
  CTU_CHANNEL_CLR_C_tag CLR_C;         /* Command List Register C for self-test commands */
} CTU_CHANNEL_tag;

typedef union CTU_FDCR_union_tag {     /* FIFO DMA Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t _unused_11:1;
    vuint16_t _unused_10:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t _unused_4:4;
    vuint16_t DE3:1;
    vuint16_t DE2:1;
    vuint16_t DE1:1;
    vuint16_t DE0:1;
  } B;
} CTU_FDCR_tag;

typedef union CTU_FCR_union_tag {      /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OR_EN3:1;
    vuint32_t OF_EN3:1;
    vuint32_t EMPTY_EN3:1;
    vuint32_t FULL_EN3:1;
    vuint32_t OR_EN2:1;
    vuint32_t OF_EN2:1;
    vuint32_t EMPTY_EN2:1;
    vuint32_t FULL_EN2:1;
    vuint32_t OR_EN1:1;
    vuint32_t OF_EN1:1;
    vuint32_t EMPTY_EN1:1;
    vuint32_t FULL_EN1:1;
    vuint32_t OR_EN0:1;
    vuint32_t OF_EN0:1;
    vuint32_t EMPTY_EN0:1;
    vuint32_t FULL_EN0:1;
  } B;
} CTU_FCR_tag;

typedef union CTU_FTH_union_tag {      /* FIFO Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TH3:8;
    vuint32_t TH2:8;
    vuint32_t TH1:8;
    vuint32_t TH0:8;
  } B;
} CTU_FTH_tag;

typedef union CTU_FST_union_tag {      /* FIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OR3:1;
    vuint32_t OF3:1;
    vuint32_t EMP3:1;
    vuint32_t FULL3:1;
    vuint32_t OR2:1;
    vuint32_t OF2:1;
    vuint32_t EMP2:1;
    vuint32_t FULL2:1;
    vuint32_t OR1:1;
    vuint32_t OF1:1;
    vuint32_t EMP1:1;
    vuint32_t FULL1:1;
    vuint32_t OR0:1;
    vuint32_t OF0:1;
    vuint32_t EMP0:1;
    vuint32_t FULL0:1;
  } B;
} CTU_FST_tag;

typedef union CTU_FR_union_tag {       /* FIFO Right Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t N_CH:4;
    vuint32_t _unused_12:4;
    vuint32_t DATA:12;
  } B;
} CTU_FR_tag;

typedef union CTU_FL_union_tag {       /* FIFO Signed Left Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t N_CH:4;
    vuint32_t _unused_15:1;
    vuint32_t LA_DATA:12;
    vuint32_t _unused_0:3;
  } B;
} CTU_FL_tag;

typedef union CTU_EFR_union_tag {      /* Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t LIST_BE:1;
    vuint16_t CS:1;
    vuint16_t ET_OE:1;
    vuint16_t ERRCMP:1;
    vuint16_t T4_OE:1;
    vuint16_t T3_OE:1;
    vuint16_t T2_OE:1;
    vuint16_t T1_OE:1;
    vuint16_t ADC_OE:1;
    vuint16_t TGS_OSM:1;
    vuint16_t MRS_O:1;
    vuint16_t ICE:1;
    vuint16_t SM_TO:1;
    vuint16_t MRS_RE:1;
  } B;
} CTU_EFR_tag;

typedef union CTU_IFR_union_tag {      /* Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t SERR_B:1;
    vuint16_t SERR_A:1;
    vuint16_t ADC_I:1;
    vuint16_t T7_I:1;
    vuint16_t T6_I:1;
    vuint16_t T5_I:1;
    vuint16_t T4_I:1;
    vuint16_t T3_I:1;
    vuint16_t T2_I:1;
    vuint16_t T1_I:1;
    vuint16_t T0_I:1;
    vuint16_t MRS_I:1;
  } B;
} CTU_IFR_tag;

typedef union CTU_IR_union_tag {       /* Interrupt/DMA Register */
  vuint16_t R;
  struct {
    vuint16_t T7_IE:1;
    vuint16_t T6_IE:1;
    vuint16_t T5_IE:1;
    vuint16_t T4_IE:1;
    vuint16_t T3_IE:1;
    vuint16_t T2_IE:1;
    vuint16_t T1_IE:1;
    vuint16_t T0_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t SAF_CNT_B_EN:1;          /* Enable the ADC Port B counter to check the conversion time. */
    vuint16_t SAF_CNT_A_EN:1;          /* Enable the ADC Port A counter to check the conversion time. */
    vuint16_t DMA_DE:1;
    vuint16_t MRS_DMAE:1;
    vuint16_t MRS_IE:1;
    vuint16_t IEE:1;
  } B;
} CTU_IR_tag;

typedef union CTU_COTR_union_tag {     /* Control ON Time Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t COTGT:8;
  } B;
} CTU_COTR_tag;

typedef union CTU_CR_union_tag {       /* Control Register */
  vuint16_t R;
  struct {
    vuint16_t T7_SG:1;
    vuint16_t T6_SG:1;
    vuint16_t T5_SG:1;
    vuint16_t T4_SG:1;
    vuint16_t T3_SG:1;
    vuint16_t T2_SG:1;
    vuint16_t T1_SG:1;
    vuint16_t T0_SG:1;
    vuint16_t CTU_ADC_R:1;
    vuint16_t CTU_ODIS:1;
    vuint16_t DFE:1;
    vuint16_t CGRE:1;
    vuint16_t FGRE:1;
    vuint16_t MRS_SG:1;
    vuint16_t GRE:1;
    vuint16_t TGSISR_RE:1;
  } B;
} CTU_CR_tag;

typedef union CTU_DFR_union_tag {      /* Digital Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t FILTER_N:8;
  } B;
} CTU_DFR_tag;

typedef union CTU_EXPAR_union_tag {    /* Expected Value A Register */
  vuint16_t R;
  struct {
    vuint16_t EXPA:16;                 /* This value is the expected number of system clock cycles needed by ADC Port A to complete a conversion. */
  } B;
} CTU_EXPAR_tag;

typedef union CTU_EXPBR_union_tag {    /* Expected Value B Register */
  vuint16_t R;
  struct {
    vuint16_t EXPB:16;                 /* This value is the expected number of system clock cycles needed by ADC Port B to complete a conversion. */
  } B;
} CTU_EXPBR_tag;

typedef union CTU_CNTRNGR_union_tag {  /* Counter Range Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t CNTRNG:8;
  } B;
} CTU_CNTRNGR_tag;

typedef union CTU_LISTCSR_union_tag {  /* List Control/Status Register */
  vuint32_t R;
  struct {
    vuint32_t LIST1_BLK:1;
    vuint32_t _unused_29:2;
    vuint32_t LIST1_ADDR:5;
    vuint32_t LIST0_BLK:1;
    vuint32_t _unused_21:2;
    vuint32_t LIST0_ADDR:5;            /* List Address 0. Indicates the command address being executed when LIST_BE flag in EFR register was set. */
    vuint32_t _unused_1:15;
    vuint32_t PAR_LIST:1;
  } B;
} CTU_LISTCSR_tag;

struct CTU_tag {
  CTU_TGSISR_tag TGSISR;               /* Trigger Generator Subunit Input Selection Register */
  CTU_TGSCR_tag TGSCR;                 /* Trigger Generator Subunit Control Register */
  CTU_TCR_tag TCR[8];                  /* Trigger Compare Register */
  CTU_TGSCCR_tag TGSCCR;               /* TGS Counter Compare Register */
  CTU_TGSCRR_tag TGSCRR;               /* TGS Counter Reload Register */
  uint8_t CTU_reserved0[2];
  CTU_CLCR1_tag CLCR1;                 /* Commands List Control Register 1 */
  CTU_CLCR2_tag CLCR2;                 /* Commands List Control Register 2 */
  CTU_THCR1_tag THCR1;                 /* Trigger Handler Control Register 1 */
  CTU_THCR2_tag THCR2;                 /* Trigger Handler Control Register 2 */
  CTU_CHANNEL_tag CHANNEL[24];
  uint8_t CTU_reserved1[16];
  CTU_FDCR_tag FDCR;                   /* FIFO DMA Control Register */
  uint8_t CTU_reserved2[2];
  CTU_FCR_tag FCR;                     /* FIFO Control Register */
  CTU_FTH_tag FTH;                     /* FIFO Threshold Register */
  uint8_t CTU_reserved3[4];
  CTU_FST_tag FST;                     /* FIFO Status Register */
  CTU_FR_tag FR[4];                    /* FIFO Right Aligned Data Register */
  uint8_t CTU_reserved4[16];
  CTU_FL_tag FL[4];                    /* FIFO Signed Left Aligned Data Register */
  uint8_t CTU_reserved5[16];
  CTU_EFR_tag EFR;                     /* Error Flag Register */
  CTU_IFR_tag IFR;                     /* Interrupt Flag Register */
  CTU_IR_tag IR;                       /* Interrupt/DMA Register */
  CTU_COTR_tag COTR;                   /* Control ON Time Register */
  CTU_CR_tag CR;                       /* Control Register */
  CTU_DFR_tag DFR;                     /* Digital Filter Register */
  CTU_EXPAR_tag EXPAR;                 /* Expected Value A Register */
  CTU_EXPBR_tag EXPBR;                 /* Expected Value B Register */
  CTU_CNTRNGR_tag CNTRNGR;             /* Counter Range Register */
  uint8_t CTU_reserved6[2];
  CTU_LISTCSR_tag LISTCSR;             /* List Control/Status Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t _unused_11:5;
    vuint32_t GRP1PRI:1;               /* Channel Group 1 Priority */
    vuint32_t _unused_9:1;
    vuint32_t GRP0PRI:1;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t _unused_0:1;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_18:13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_13:1;
    vuint32_t ERRCHN:5;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t DBE:1;                   /* Destination Bus Error */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEI_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t SERQ:5;                   /* Set Enable Request */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t CERQ:5;                   /* Clear Enable Request */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t SEEI:5;                   /* Set Enable Error Interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t CEEI:5;                   /* Clear Enable Error Interrupt */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t _unused_5:1;
    vuint8_t CINT:5;                   /* Clear Interrupt Request */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t _unused_5:1;
    vuint8_t CERR:5;                   /* Clear Error Indicator */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t _unused_5:1;
    vuint8_t SSRT:5;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t _unused_5:1;
    vuint8_t CDNE:5;                   /* Clear DONE Bit */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRS_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;                    /* Enable Master ID replication */
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t _unused_4:2;
    vuint8_t MID:4;                    /* Master ID */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;                  /* Source Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t CITER:15;                /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Minor Loop Link Channel Number */
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Link Channel Number */
    vuint16_t BITER:9;                 /* Starting major iteration count */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;                   /* Bandwidth Control */
    vuint16_t _unused_13:1;
    vuint16_t MAJORLINKCH:5;           /* Major Loop Link Channel Number */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t START:1;                 /* Channel Start */
  } B;
} DMA_TCD_CSR_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_BITER_tag BITER;
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  uint8_t DMA_reserved5[200];
  DMA_DCHPRI_tag DCHPRI[32];           /* Channel n Priority Register */
  uint8_t DMA_reserved6[32];
  DMA_DCHMID_tag DCHMID[32];           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3744];
  DMA_TCD_tag TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

typedef union DTS_ENABLE_union_tag {   /* Output Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t DTS_EN_B:1;
    vuint32_t DTS_EN:1;
  } B;
} DTS_ENABLE_tag;

typedef union DTS_STARTUP_union_tag {  /* Startup Register */
  vuint32_t R;
  struct {
    vuint32_t AD:32;
  } B;
} DTS_STARTUP_tag;

typedef union DTS_SEMAPHORE_union_tag { /* Semaphore Register */
  vuint32_t R;
  struct {
    vuint32_t ST:32;
  } B;
} DTS_SEMAPHORE_tag;

typedef union DTS_SEMAPHORE_B_union_tag { /* Semaphore Extension */
  vuint32_t R;
  struct {
    vuint32_t ST_B:32;
  } B;
} DTS_SEMAPHORE_B_tag;

struct DTS_tag {
  DTS_ENABLE_tag ENABLE;               /* Output Enable Register */
  DTS_STARTUP_tag STARTUP;             /* Startup Register */
  DTS_SEMAPHORE_tag SEMAPHORE;         /* Semaphore Register */
  DTS_SEMAPHORE_B_tag SEMAPHORE_B;     /* Semaphore Extension */
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
    vuint32_t _unused_0:31;
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:8;           /* Checkbit Mask */
    vuint32_t _unused_0:24;
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_WORD0_tag EICHD_WORD0[1];  /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag EICHD_WORD1[1];  /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag EICHD_WORD2[1];  /* Error Injection Channel Descriptor, Word2 */
};


/* ============================================================================
   =============================== Module: ETIMER =============================
   ============================================================================ */

typedef union ETIMER_CH_COMP1_union_tag { /* Channel n Compare Register 1 */
  vuint16_t R;
  struct {
    vuint16_t COMP1:16;
  } B;
} ETIMER_CH_COMP1_tag;

typedef union ETIMER_CH_COMP2_union_tag { /* Channel n Compare Register 2 */
  vuint16_t R;
  struct {
    vuint16_t COMP2:16;
  } B;
} ETIMER_CH_COMP2_tag;

typedef union ETIMER_CH_CAPT1_union_tag { /* Channel n Capture Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CAPT1:16;
  } B;
} ETIMER_CH_CAPT1_tag;

typedef union ETIMER_CH_CAPT2_union_tag { /* Channel n Capture Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CAPT2:16;
  } B;
} ETIMER_CH_CAPT2_tag;

typedef union ETIMER_CH_LOAD_union_tag { /* Channel n Load Register */
  vuint16_t R;
  struct {
    vuint16_t LOAD:16;
  } B;
} ETIMER_CH_LOAD_tag;

typedef union ETIMER_CH_HOLD_union_tag { /* Channel n Hold Register */
  vuint16_t R;
  struct {
    vuint16_t HOLD:16;
  } B;
} ETIMER_CH_HOLD_tag;

typedef union ETIMER_CH_CNTR_union_tag { /* Channel n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNTR:16;
  } B;
} ETIMER_CH_CNTR_tag;

typedef union ETIMER_CH_CTRL1_union_tag { /* Channel n Control Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CNTMODE:3;               /* Count mode */
    vuint16_t PRISRC:5;                /* Primary Count Source */
    vuint16_t ONCE:1;                  /* Count once */
    vuint16_t LENGTH:1;                /* Count Length */
    vuint16_t DIR:1;                   /* Count Direction */
    vuint16_t SECSRC:5;                /* Secondary Count Source */
  } B;
} ETIMER_CH_CTRL1_tag;

typedef union ETIMER_CH_CTRL2_union_tag { /* Channel n Control Register 2 */
  vuint16_t R;
  struct {
    vuint16_t OEN:1;                   /* Output Enable */
    vuint16_t RDNT:1;                  /* Redundant Channel Enable */
    vuint16_t INPUT:1;                 /* External input signal */
    vuint16_t VAL:1;                   /* Forced OFLAG Value */
    vuint16_t FORCE:1;                 /* Force the OFLAG output */
    vuint16_t COFRC:1;                 /* Co-channel OFLAG Force */
    vuint16_t COINIT:2;                /* Co-channel Initialization */
    vuint16_t SIPS:1;                  /* Secondary Source Input Polarity Select */
    vuint16_t PIPS:1;                  /* Primary Source Input Polarity Select */
    vuint16_t OPS:1;                   /* Output Polarity Select. */
    vuint16_t MSTR:1;                  /* Master Mode */
    vuint16_t OUTMODE:4;               /* Output Mode */
  } B;
} ETIMER_CH_CTRL2_tag;

typedef union ETIMER_CH_CTRL3_union_tag { /* Channel n Control Register 3 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t ROC:2;                   /* Reload on Capture */
    vuint16_t _unused_8:5;
    vuint16_t C2FCNT:3;                /* Capture 2 FIFO count */
    vuint16_t C1FCNT:3;                /* Capture 1 FIFO count */
    vuint16_t DBGEN:2;                 /* Debug Actions Enable */
  } B;
} ETIMER_CH_CTRL3_tag;

typedef union ETIMER_CH_STS_union_tag { /* Channel n Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t _unused_9:1;
    vuint16_t RCF:1;                   /* Redundant Channel Flag */
    vuint16_t ICF2:1;                  /* Input Capture 2 Flag */
    vuint16_t ICF1:1;                  /* Input Capture 1 Flag */
    vuint16_t IEHF:1;                  /* Input Edge High Flag */
    vuint16_t IELF:1;                  /* Input Edge Low Flag */
    vuint16_t TOF:1;                   /* Timer Overflow Flag */
    vuint16_t TCF2:1;                  /* Timer Compare 2 Flag */
    vuint16_t TCF1:1;                  /* Timer Compare 1 Flag */
    vuint16_t TCF:1;
  } B;
} ETIMER_CH_STS_tag;

typedef union ETIMER_CH_INTDMA_union_tag { /* Channel n Interrupt and DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t ICF2DE:1;                /* Input Capture 2 Flag DMA Enable */
    vuint16_t ICF1DE:1;                /* Input Capture 1 Flag DMA Enable */
    vuint16_t CMPLD2DE:1;              /* Comparator Load Register 2 Flag DMA Enable */
    vuint16_t CMPLD1DE:1;              /* Comparator Load Register 1 Flag DMA Enable */
    vuint16_t _unused_10:2;
    vuint16_t _unused_9:1;
    vuint16_t RCFIE:1;                 /* Redundant Channel Flag Interrupt Enable */
    vuint16_t ICF2IE:1;                /* Input Capture 2 Flag Interrupt Enable */
    vuint16_t ICF1IE:1;                /* Input Capture 1 Flag Interrupt Enable */
    vuint16_t IEHFIE:1;                /* Input Edge High Flag Interrupt Enable */
    vuint16_t IELFIE:1;                /* Input Edge Low Flag Interrupt Enable */
    vuint16_t TOFIE:1;                 /* Timer Overflow Flag Interrupt Enable */
    vuint16_t TCF2IE:1;                /* Timer Compare 2 Flag Interrupt Enable */
    vuint16_t TCF1IE:1;                /* Timer Compare 1 Flag Interrupt Enable */
    vuint16_t TCFIE:1;                 /* Timer Compare Flag Interrupt Enable */
  } B;
} ETIMER_CH_INTDMA_tag;

typedef union ETIMER_CH_CMPLD1_union_tag { /* Channel n Comparator Load Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD1:16;
  } B;
} ETIMER_CH_CMPLD1_tag;

typedef union ETIMER_CH_CMPLD2_union_tag { /* Channel n Comparator Load Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD2:16;
  } B;
} ETIMER_CH_CMPLD2_tag;

typedef union ETIMER_CH_CCCTRL_union_tag { /* Channel n Compare and Capture Control Register */
  vuint16_t R;
  struct {
    vuint16_t CLC2:3;                  /* Compare Load Control 2 */
    vuint16_t CLC1:3;                  /* Compare Load Control 1 */
    vuint16_t CMPMODE:2;               /* Compare Mode */
    vuint16_t CPT2MODE:2;              /* Capture 2 Mode Control */
    vuint16_t CPT1MODE:2;              /* Capture 1 Mode Control */
    vuint16_t CFWM:2;                  /* Capture FIFO Water Mark */
    vuint16_t ONESHOT:1;               /* One Shot Capture Mode */
    vuint16_t ARM:1;                   /* Arm Capture */
  } B;
} ETIMER_CH_CCCTRL_tag;

typedef union ETIMER_CH_FILT_union_tag { /* Channel n Input Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FILT_CNT:3;              /* Input Filter Sample Count */
    vuint16_t FILT_PER:8;              /* Input Filter Sample Period */
  } B;
} ETIMER_CH_FILT_tag;

typedef struct ETIMER_CH_struct_tag {
  ETIMER_CH_COMP1_tag COMP1;           /* Channel n Compare Register 1 */
  ETIMER_CH_COMP2_tag COMP2;           /* Channel n Compare Register 2 */
  ETIMER_CH_CAPT1_tag CAPT1;           /* Channel n Capture Register 1 */
  ETIMER_CH_CAPT2_tag CAPT2;           /* Channel n Capture Register 2 */
  ETIMER_CH_LOAD_tag LOAD;             /* Channel n Load Register */
  ETIMER_CH_HOLD_tag HOLD;             /* Channel n Hold Register */
  ETIMER_CH_CNTR_tag CNTR;             /* Channel n Counter Register */
  ETIMER_CH_CTRL1_tag CTRL1;           /* Channel n Control Register 1 */
  ETIMER_CH_CTRL2_tag CTRL2;           /* Channel n Control Register 2 */
  ETIMER_CH_CTRL3_tag CTRL3;           /* Channel n Control Register 3 */
  ETIMER_CH_STS_tag STS;               /* Channel n Status Register */
  ETIMER_CH_INTDMA_tag INTDMA;         /* Channel n Interrupt and DMA Enable Register */
  ETIMER_CH_CMPLD1_tag CMPLD1;         /* Channel n Comparator Load Register 1 */
  ETIMER_CH_CMPLD2_tag CMPLD2;         /* Channel n Comparator Load Register 2 */
  ETIMER_CH_CCCTRL_tag CCCTRL;         /* Channel n Compare and Capture Control Register */
  ETIMER_CH_FILT_tag FILT;             /* Channel n Input Filter Register */
} ETIMER_CH_tag;

typedef union ETIMER_ENBL_union_tag {  /* Channel Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t ENBL:8;                  /* Timer Channel Enable */
  } B;
} ETIMER_ENBL_tag;

typedef union ETIMER_DREQ0_union_tag { /* DMA Request 0 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ0_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ0:5;
  } B;
} ETIMER_DREQ0_tag;

typedef union ETIMER_DREQ1_union_tag { /* DMA Request 1 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ1_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ1:5;                 /* DMA Request Select */
  } B;
} ETIMER_DREQ1_tag;

struct ETIMER_tag {
  ETIMER_CH_tag CH[8];
  uint8_t ETIMER_reserved0[12];
  ETIMER_ENBL_tag ENBL;                /* Channel Enable Register */
  uint8_t ETIMER_reserved1[2];
  ETIMER_DREQ0_tag DREQ0;              /* DMA Request 0 Select Register */
  ETIMER_DREQ1_tag DREQ1;              /* DMA Request 1 Select Register */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_29:2;
    vuint32_t _unused_10:19;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t NVML:1;                  /* Nonvolatile Memory Configuration Loaded */
    vuint32_t OPS:2;
    vuint32_t _unused_5:1;
    vuint32_t OPR:5;                   /* Operation Run */
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;                /* Locked-Operation Control Key */
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t FCCU_SET_AFTER_RESET:1;  /* Fault-Output (EOUT) Activate */
    vuint32_t FCCU_SET_CLEAR:2;        /* Fault-Output (EOUT) Control */
    vuint32_t _unused_20:2;
    vuint32_t _unused_16:4;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t _unused_13:2;
    vuint32_t OD:1;
    vuint32_t _unused_11:1;
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC31:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC0:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC31:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC0:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS31:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS0:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE31:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE0:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE31:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE0:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timer Interval */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TO:3;                    /* Configuration-State Timer Interval */
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t EIN1:1;                  /* Error Input 1 */
    vuint32_t EIN0:1;                  /* Error Input 0 */
    vuint32_t _unused_2:2;
    vuint32_t EOUT1:1;
    vuint32_t EOUT0:1;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t PhysicErrorPin:2;        /* Fault Output (EOUT) States */
    vuint32_t ESTAT:1;                 /* Fault State */
    vuint32_t STATUS:3;                /* FCCU State */
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t _unused_1:2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;                   /* Fault Status 3 */
    vuint32_t _unused_28:2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;                   /* Fault Status 2 */
    vuint32_t _unused_20:2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;                   /* Fault Status 1 */
    vuint32_t _unused_12:2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;                   /* Fault Status 0 */
    vuint32_t _unused_4:2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t TRANSKEY:9;              /* Transient Configuration Lock */
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t PERMNTKEY:9;             /* Permanent Configuration Lock */
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_16:14;
    vuint32_t _unused_14:2;
    vuint32_t DELTA_T:14;              /* Bistable Minimum Fault-Output (EOUT) Faulty Interval */
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN30:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN29:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN28:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN27:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN26:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN25:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN24:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN23:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN22:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN21:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN20:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN19:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN18:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN17:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN16:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN15:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN14:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN13:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN12:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN11:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN10:1;              /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN9:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN8:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN7:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN6:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN5:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN4:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN3:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN2:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN1:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
    vuint32_t EOUTEN0:1;               /* Bistable Fault-Output (EOUT) Mode Signaling Enable x */
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[4];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[32];
  FCCU_NCFS_CFG_tag NCFS_CFG[8];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[20];
  FCCU_NCF_S_tag NCF_S[4];             /* Noncritical Fault Status */
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[4];             /* Noncritical Fault Enable */
  FCCU_NCF_TOE_tag NCF_TOE[4];         /* Noncritical Fault Timeout Enable */
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timer Interval */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved3[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Configuration Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Configuration Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[4]; /* IRQ Alarm Enable */
  FCCU_NMI_EN_tag NMI_EN[4];           /* NMI Enable */
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[4]; /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
};


/* ============================================================================
   =============================== Module: FlexPWM ============================
   ============================================================================ */

typedef union FlexPWM_SUB_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FlexPWM_SUB_CNT_tag;

typedef union FlexPWM_SUB_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FlexPWM_SUB_INIT_tag;

typedef union FlexPWM_SUB_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t DBGEN:1;                 /* Debug Enable */
    vuint16_t _unused_14:1;
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
  } B;
} FlexPWM_SUB_CTRL2_tag;

typedef union FlexPWM_SUB_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t LDFQ:4;                  /* Load Frequency */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t _unused_7:1;
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t _unused_1:1;
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
  } B;
} FlexPWM_SUB_CTRL1_tag;

typedef union FlexPWM_SUB_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FlexPWM_SUB_VAL0_tag;

typedef union FlexPWM_SUB_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FlexPWM_SUB_VAL1_tag;

typedef union FlexPWM_SUB_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FlexPWM_SUB_VAL2_tag;

typedef union FlexPWM_SUB_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FlexPWM_SUB_VAL3_tag;

typedef union FlexPWM_SUB_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;
  } B;
} FlexPWM_SUB_VAL4_tag;

typedef union FlexPWM_SUB_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;
  } B;
} FlexPWM_SUB_VAL5_tag;

typedef union FlexPWM_SUB_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t _unused_14:1;
    vuint16_t PWMX_IN:1;
    vuint16_t _unused_11:2;
    vuint16_t POLA:1;
    vuint16_t POLB:1;
    vuint16_t POLX:1;
    vuint16_t _unused_6:2;
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
  } B;
} FlexPWM_SUB_OCTRL_tag;

typedef union FlexPWM_SUB_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t RUF:1;
    vuint16_t REF:1;
    vuint16_t RF:1;
    vuint16_t _unused_8:4;
    vuint16_t CFX1:1;
    vuint16_t CFX0:1;
    vuint16_t CMPF:6;
  } B;
} FlexPWM_SUB_STS_tag;

typedef union FlexPWM_SUB_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t REIE:1;
    vuint16_t RIE:1;
    vuint16_t _unused_8:4;
    vuint16_t CX1IE:1;
    vuint16_t CX0IE:1;
    vuint16_t CMPIE:6;
  } B;
} FlexPWM_SUB_INTEN_tag;

typedef union FlexPWM_SUB_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t VALDE:1;
    vuint16_t FAND:1;
    vuint16_t CAPTDE:2;
    vuint16_t _unused_2:4;
    vuint16_t CX1DE:1;
    vuint16_t CX0DE:1;
  } B;
} FlexPWM_SUB_DMAEN_tag;

typedef union FlexPWM_SUB_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_6:10;
    vuint16_t OUT_TRIG_EN:6;
  } B;
} FlexPWM_SUB_TCTRL_tag;

typedef union FlexPWM_SUB_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t DISX:4;
    vuint16_t DISB:4;
    vuint16_t DISA:4;
  } B;
} FlexPWM_SUB_DISMAP_tag;

typedef union FlexPWM_SUB_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t DTCNT0:11;
  } B;
} FlexPWM_SUB_DTCNT0_tag;

typedef union FlexPWM_SUB_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t DTCNT1:11;
  } B;
} FlexPWM_SUB_DTCNT1_tag;

typedef union FlexPWM_SUB_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t CX1CNT:3;
    vuint16_t CX0CNT:3;
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t EDGCNTX_EN:1;
    vuint16_t INPSELX:1;
    vuint16_t EDGX1:2;
    vuint16_t EDGX0:2;
    vuint16_t ONESHOTX:1;
    vuint16_t ARMX:1;
  } B;
} FlexPWM_SUB_CAPTCTRLX_tag;

typedef union FlexPWM_SUB_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCNTX:8;
    vuint16_t EDGCMPX:8;
  } B;
} FlexPWM_SUB_CAPTCMPX_tag;

typedef union FlexPWM_SUB_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;
  } B;
} FlexPWM_SUB_CVAL0_tag;

typedef union FlexPWM_SUB_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_3:13;
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
  } B;
} FlexPWM_SUB_CVAL0CYC_tag;

typedef union FlexPWM_SUB_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;
  } B;
} FlexPWM_SUB_CVAL1_tag;

typedef union FlexPWM_SUB_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_3:13;
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
  } B;
} FlexPWM_SUB_CVAL1CYC_tag;

typedef struct FlexPWM_SUB_struct_tag {
  FlexPWM_SUB_CNT_tag CNT;             /* Submodule n Counter Register */
  FlexPWM_SUB_INIT_tag INIT;           /* Submodule n Initial Count Register */
  FlexPWM_SUB_CTRL2_tag CTRL2;         /* Submodule n Control 2 Register */
  FlexPWM_SUB_CTRL1_tag CTRL1;         /* Submodule n Control 1 Register */
  FlexPWM_SUB_VAL0_tag VAL0;           /* Submodule n Value Register 0 */
  FlexPWM_SUB_VAL1_tag VAL1;           /* Submodule n Value Register 1 */
  FlexPWM_SUB_VAL2_tag VAL2;           /* Submodule n Value Register 2 */
  FlexPWM_SUB_VAL3_tag VAL3;           /* Submodule n Value Register 3 */
  FlexPWM_SUB_VAL4_tag VAL4;           /* Submodule n Value Register 4 */
  FlexPWM_SUB_VAL5_tag VAL5;           /* Submodule n Value Register 5 */
  uint8_t SUB_reserved0[4];
  FlexPWM_SUB_OCTRL_tag OCTRL;         /* Submodule n Output Control Register */
  FlexPWM_SUB_STS_tag STS;             /* Submodule n Status Register */
  FlexPWM_SUB_INTEN_tag INTEN;         /* Submodule n Interrupt Enable Register */
  FlexPWM_SUB_DMAEN_tag DMAEN;         /* Submodule n DMA Enable Register */
  FlexPWM_SUB_TCTRL_tag TCTRL;         /* Submodule n Output Trigger Control Register */
  FlexPWM_SUB_DISMAP_tag DISMAP;       /* Submodule n Fault Disable Mapping Register */
  FlexPWM_SUB_DTCNT0_tag DTCNT0;       /* Submodule n Deadtime Count Register 0 */
  FlexPWM_SUB_DTCNT1_tag DTCNT1;       /* Submodule n Deadtime Count Register 1 */
  uint8_t SUB_reserved1[8];
  FlexPWM_SUB_CAPTCTRLX_tag CAPTCTRLX; /* Submodule n Capture Control X Register */
  FlexPWM_SUB_CAPTCMPX_tag CAPTCMPX;   /* Submodule n Capture Compare X Register */
  FlexPWM_SUB_CVAL0_tag CVAL0;         /* Submodule n Capture Value 0 Register */
  FlexPWM_SUB_CVAL0CYC_tag CVAL0CYC;   /* Submodule n Capture Value 0 Cycle Register */
  FlexPWM_SUB_CVAL1_tag CVAL1;         /* Submodule n Capture Value 1 Register */
  FlexPWM_SUB_CVAL1CYC_tag CVAL1CYC;   /* Submodule n Capture Value 1 Cycle Register */
  uint8_t SUB_reserved2[20];
} FlexPWM_SUB_tag;

typedef union FlexPWM_OUTEN_union_tag { /* Output Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t PWMA_EN:4;
    vuint16_t PWMB_EN:4;
    vuint16_t PWMX_EN:4;
  } B;
} FlexPWM_OUTEN_tag;

typedef union FlexPWM_MASK_union_tag { /* Mask Register */
  vuint16_t R;
  struct {
    vuint16_t UPDATE_MASK:4;           /* Update Mask */
    vuint16_t MASKA:4;
    vuint16_t MASKB:4;
    vuint16_t MASKX:4;
  } B;
} FlexPWM_MASK_tag;

typedef union FlexPWM_SWCOUT_union_tag { /* Software Controlled Output Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t OUT23_3:1;
    vuint16_t OUT45_3:1;
    vuint16_t OUT23_2:1;
    vuint16_t OUT45_2:1;
    vuint16_t OUT23_1:1;
    vuint16_t OUT45_1:1;
    vuint16_t OUT23_0:1;
    vuint16_t OUT45_0:1;
  } B;
} FlexPWM_SWCOUT_tag;

typedef union FlexPWM_DTSRCSEL_union_tag { /* Deadtime Source Select Register */
  vuint16_t R;
  struct {
    vuint16_t SEL23_3:2;
    vuint16_t SEL45_3:2;
    vuint16_t SEL23_2:2;
    vuint16_t SEL45_2:2;
    vuint16_t SEL23_1:2;
    vuint16_t SEL45_1:2;
    vuint16_t SEL23_0:2;
    vuint16_t SEL45_0:2;
  } B;
} FlexPWM_DTSRCSEL_tag;

typedef union FlexPWM_MCTRL_union_tag { /* Master Control Register */
  vuint16_t R;
  struct {
    vuint16_t IPOL:4;                  /* Current Polarity */
    vuint16_t RUN:4;                   /* Run */
    vuint16_t CLDOK:4;                 /* Clear Load Okay */
    vuint16_t LDOK:4;                  /* Load Okay */
  } B;
} FlexPWM_MCTRL_tag;

typedef union FlexPWM_FCTRL_union_tag { /* Fault Control Register */
  vuint16_t R;
  struct {
    vuint16_t FLVL:4;
    vuint16_t FAUTO:4;
    vuint16_t FSAFE:4;
    vuint16_t FIE:4;
  } B;
} FlexPWM_FCTRL_tag;

typedef union FlexPWM_FSTS_union_tag { /* Fault Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_13:3;
    vuint16_t FTEST:1;
    vuint16_t FFPIN:4;
    vuint16_t FFULL:4;
    vuint16_t FFLAG:4;
  } B;
} FlexPWM_FSTS_tag;

typedef union FlexPWM_FFILT_union_tag { /* Fault Filter Register */
  vuint16_t R;
  struct {
    vuint16_t GSTR:1;
    vuint16_t _unused_11:4;
    vuint16_t FILT_CNT:3;
    vuint16_t FILT_PER:8;
  } B;
} FlexPWM_FFILT_tag;

typedef union FlexPWM_FCTRL2_union_tag { /* Fault Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t NOCOMB:4;                /* No combinational path from fault inputs to PWM outputs */
  } B;
} FlexPWM_FCTRL2_tag;

struct FlexPWM_tag {
  FlexPWM_SUB_tag SUB[4];
  FlexPWM_OUTEN_tag OUTEN;             /* Output Enable Register */
  FlexPWM_MASK_tag MASK;               /* Mask Register */
  FlexPWM_SWCOUT_tag SWCOUT;           /* Software Controlled Output Register */
  FlexPWM_DTSRCSEL_tag DTSRCSEL;       /* Deadtime Source Select Register */
  FlexPWM_MCTRL_tag MCTRL;             /* Master Control Register */
  uint8_t FlexPWM_reserved0[2];
  FlexPWM_FCTRL_tag FCTRL;             /* Fault Control Register */
  FlexPWM_FSTS_tag FSTS;               /* Fault Status Register */
  FlexPWM_FFILT_tag FFILT;             /* Fault Filter Register */
  FlexPWM_FCTRL2_tag FCTRL2;           /* Fault Control 2 Register */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t ADR:7;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t MDIS:1;
    vuint8_t IBIE:1;
    vuint8_t MSSL:1;
    vuint8_t TXRX:1;
    vuint8_t NOACK:1;
    vuint8_t RSTA:1;
    vuint8_t DMAEN:1;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t TCF:1;
    vuint8_t IAAS:1;
    vuint8_t IBB:1;
    vuint8_t _unused_3:2;
    vuint8_t SRW:1;
    vuint8_t IBIF:1;
    vuint8_t RXAK:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t BIIE:1;
    vuint8_t _unused_6:1;
    vuint8_t _unused_0:6;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t IPG_DEBUG_EN:1;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t HVEN2:1;
    vuint32_t _unused_5:3;
    vuint32_t HVEN1:1;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_CPR1_union_tag {    /* INTC Current Priority Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PRI:5;
  } B;
} INTC_CPR1_tag;

typedef union INTC_CPR2_union_tag {    /* INTC Current Priority Register for Processor 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PRI:5;
  } B;
} INTC_CPR2_tag;

typedef union INTC_IACKR1_union_tag {  /* INTC Interrupt Acknowledge Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR1_tag;

typedef union INTC_IACKR2_union_tag {  /* INTC Interrupt Acknowledge Register for Processor 2 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR2_tag;

typedef union INTC_EOIR1_union_tag {   /* INTC End Of Interrupt Register for Processor 1 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR1_tag;

typedef union INTC_EOIR2_union_tag {   /* INTC End Of Interrupt Register for Processor 2 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR2_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t PRC_SELN2:1;
    vuint16_t _unused_12:1;
    vuint16_t _unused_9:3;
    vuint16_t SWTN:1;
    vuint16_t _unused_5:3;
    vuint16_t PRIN:5;
  } B;
} INTC_PSR_tag;

typedef union INTC_MMRC1_union_tag {   /* INTC Monitor Mode Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t MM:2;
  } B;
} INTC_MMRC1_tag;

typedef union INTC_HIPRIC1_union_tag { /* INTC HIPRI Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t IRQ:10;
  } B;
} INTC_HIPRIC1_tag;

typedef union INTC_LATC1_union_tag {   /* INTC LAT Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t LAT:24;
  } B;
} INTC_LATC1_tag;

typedef union INTC_TIMERC1_union_tag { /* INTC Timer Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TIMER:24;
  } B;
} INTC_TIMERC1_tag;

typedef union INTC_MMRC2_union_tag {   /* INTC Monitor Mode Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t MM:2;
  } B;
} INTC_MMRC2_tag;

typedef union INTC_HIPRIC2_union_tag { /* INTC HIPRI Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t IRQ:10;
  } B;
} INTC_HIPRIC2_tag;

typedef union INTC_LATC2_union_tag {   /* INTC LAT Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t LAT:24;
  } B;
} INTC_LATC2_tag;

typedef union INTC_TIMERC2_union_tag { /* INTC Timer Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TIMER:24;
  } B;
} INTC_TIMERC2_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  uint8_t INTC_reserved0[16];
  INTC_CPR1_tag CPR1;                  /* INTC Current Priority Register for Processor 1 */
  INTC_CPR2_tag CPR2;                  /* INTC Current Priority Register for Processor 2 */
  uint8_t INTC_reserved1[8];
  INTC_IACKR1_tag IACKR1;              /* INTC Interrupt Acknowledge Register for Processor 1 */
  INTC_IACKR2_tag IACKR2;              /* INTC Interrupt Acknowledge Register for Processor 2 */
  uint8_t INTC_reserved2[8];
  INTC_EOIR1_tag EOIR1;                /* INTC End Of Interrupt Register for Processor 1 */
  INTC_EOIR2_tag EOIR2;                /* INTC End Of Interrupt Register for Processor 2 */
  uint8_t INTC_reserved3[4];
  INTC_SSCIR_tag SSCIR[16];            /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved4[16];
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
  uint8_t INTC_reserved5[2004];
  INTC_MMRC1_tag MMRC1;                /* INTC Monitor Mode Register 1 */
  INTC_HIPRIC1_tag HIPRIC1[3];         /* INTC HIPRI Register */
  uint8_t INTC_reserved6[4];
  INTC_LATC1_tag LATC1[3];             /* INTC LAT Register */
  uint8_t INTC_reserved7[4];
  INTC_TIMERC1_tag TIMERC1[3];         /* INTC Timer Register */
  uint8_t INTC_reserved8[4];
  INTC_MMRC2_tag MMRC2;                /* INTC Monitor Mode Register 2 */
  INTC_HIPRIC2_tag HIPRIC2[3];         /* INTC HIPRI Register */
  uint8_t INTC_reserved9[4];
  INTC_LATC2_tag LATC2[3];             /* INTC LAT Register */
  uint8_t INTC_reserved10[4];
  INTC_TIMERC2_tag TIMERC2[3];         /* INTC Timer Register */
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

typedef union IRCOSC_CTL_union_tag {   /* IRCOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t USER_TRIM:5;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_6:2;
    vuint32_t _unused_5:1;
    vuint32_t _unused_0:5;
  } B;
} IRCOSC_CTL_tag;

struct IRCOSC_tag {
  IRCOSC_CTL_tag CTL;                  /* IRCOSC Control Register */
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

typedef union JTAGM_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRESET:1;
    vuint32_t _unused_24:7;
    vuint32_t _unused_14:10;
    vuint32_t inter_jtag_frame_timer:6;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t IIE:1;
    vuint32_t TCKSEL:3;
    vuint32_t jtagm_JCOMP:1;
    vuint32_t DTM:1;
  } B;
} JTAGM_MCR_tag;

typedef union JTAGM_SR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_24:6;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t JTAGEN:1;
    vuint32_t _unused_20:1;
    vuint32_t JTAGSAFE:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t TOOL:1;
    vuint32_t _unused_14:2;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t Nexus_err:1;
    vuint32_t Idle:1;
    vuint32_t NR:1;
    vuint32_t _unused_0:8;
  } B;
} JTAGM_SR_tag;

typedef union JTAGM_DOR0_union_tag {   /* Data Out Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TMS_HIGH:32;
  } B;
} JTAGM_DOR0_tag;

typedef union JTAGM_DOR1_union_tag {   /* Data Out Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TMS_LOW:28;
    vuint32_t _unused_0:4;
  } B;
} JTAGM_DOR1_tag;

typedef union JTAGM_DOR2_union_tag {   /* Data Out Register 2 */
  vuint32_t R;
  struct {
    vuint32_t TDI_HIGH:32;
  } B;
} JTAGM_DOR2_tag;

typedef union JTAGM_DOR3_union_tag {   /* Data Out Register 3 */
  vuint32_t R;
  struct {
    vuint32_t TDI_LOW:28;
    vuint32_t _unused_0:4;
  } B;
} JTAGM_DOR3_tag;

typedef union JTAGM_DIR0_union_tag {   /* Data Input Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TDO_LOW:32;
  } B;
} JTAGM_DIR0_tag;

typedef union JTAGM_DIR1_union_tag {   /* Data Input Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TDO_HIGH:28;
    vuint32_t _unused_0:4;
  } B;
} JTAGM_DIR1_tag;

struct JTAGM_tag {
  JTAGM_MCR_tag MCR;                   /* Module Configuration Register */
  JTAGM_SR_tag SR;                     /* Status Register */
  JTAGM_DOR0_tag DOR0;                 /* Data Out Register 0 */
  JTAGM_DOR1_tag DOR1;                 /* Data Out Register 1 */
  JTAGM_DOR2_tag DOR2;                 /* Data Out Register 2 */
  JTAGM_DOR3_tag DOR3;                 /* Data Out Register 3 */
  uint8_t JTAGM_reserved0[4];
  JTAGM_DIR0_tag DIR0;                 /* Data Input Register 0 */
  JTAGM_DIR1_tag DIR1;                 /* Data Input Register 1 */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t _unused_6:1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t _unused_4:1;
    vuint32_t TOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t _unused_10:2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t _unused_3:2;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t _unused_1:6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t RTO:4;
    vuint32_t _unused_7:1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t _unused_0:8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t _unused_6:2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_13:3;
    vuint32_t DFL:3;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t _unused_6:2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: MCB ================================
   ============================================================================ */

typedef union MCB_NPC_SPECIAL_ENABLE_union_tag { /* NPC Special Enable Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t NPC_NAL_FIFO_EXTENSION_MODE:2; /* NPC NAL FIFO EXTENSION MODE */
    vuint32_t WATER_MARK:4;            /* WATER MARK LEVEL */
    vuint32_t FIFO_DEPTH:4;            /* NAL FIFO DEPTH */
    vuint32_t _unused_1:7;             /* RESERVED */
    vuint32_t DISABLE_SPECIAL_ENABLE:1; /* Disable special enable functionality of NPC auxiliary ports */
  } B;
} MCB_NPC_SPECIAL_ENABLE_tag;

typedef union MCB_AFE_LVD_MASK_union_tag { /* AFE LVD Mask */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_9:1;
    vuint32_t AFE_LVD8_MASK:1;         /* Mask LVD on level shifter logic */
    vuint32_t AFE_LVD7_MASK:1;         /* Mask LVD on AFE SDPLL digital circuitry */
    vuint32_t AFE_LVD6_MASK:1;         /* Mask LVD on AFE SDPLL analog circuitry */
    vuint32_t AFE_LVD5_MASK:1;         /* Mask LVD on AFE OSC circuitry */
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t AFE_REF_LVD_MASK:1;      /* Mask LVD on VDD_HV_RAW */
  } B;
} MCB_AFE_LVD_MASK_tag;

typedef union MCB_MISC1_union_tag {    /* Miscellaneous 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;           /* RESERVED */
    vuint32_t SIN_END_BYP:1;           /* single ended bypass */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t _unused_10:4;            /* Reserved */
    vuint32_t _unused_7:3;
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t OUT_CTE:1;
    vuint32_t IN_CTE:1;
    vuint32_t _unused_2:2;             /* RESERVED */
    vuint32_t _unused_0:2;
  } B;
} MCB_MISC1_tag;

typedef union MCB_MISC2_union_tag {    /* Miscellaneous 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t NXMC_2_FIFO_EN:1;        /* Enable signal for NXMC_2 FIFO */
    vuint32_t _unused_8:3;             /* Reserved */
    vuint32_t SPT_NEXUS_THROTTLE_CONTROL:6; /* SPT NEXUS THROTTLE CONTROL */
    vuint32_t RCCU_DMA_STATUS:1;       /* RCCU DMA STATUS */
    vuint32_t _unused_0:1;
  } B;
} MCB_MISC2_tag;

typedef union MCB_MISC3_union_tag {    /* Miscellaneous 3 Register */
  vuint32_t R;
  struct {
    vuint32_t POR_REN:30;              /* Power retention */
    vuint32_t _unused_0:2;
  } B;
} MCB_MISC3_tag;

typedef union MCB_NEX_FIFO_STATUS_union_tag { /* Nexus Trace Fifo Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t NAL_NPC_FIFO_OFLOW:1;    /* Overflow status of NAL_NPC Extended fifo */
    vuint32_t NXMC_2_FIFO_OFLOW:1;     /* Overflow status of NXMC_2_FIFO */
  } B;
} MCB_NEX_FIFO_STATUS_tag;

typedef union MCB_CLKOUT_SEL_union_tag { /* CLKOUT Source Select */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t CGM_SINK_SEL_3:4;
    vuint32_t CGM_SINK_SEL2:4;
    vuint32_t CGM_SINK_SEL_1:4;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t CLKOUT0:4;               /* Clock Out */
    vuint32_t CLKOUT1:4;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} MCB_CLKOUT_SEL_tag;

struct MCB_tag {
  uint8_t MCB_reserved0[8];
  MCB_NPC_SPECIAL_ENABLE_tag NPC_SPECIAL_ENABLE; /* NPC Special Enable Control */
  MCB_AFE_LVD_MASK_tag AFE_LVD_MASK;   /* AFE LVD Mask */
  MCB_MISC1_tag MISC1;                 /* Miscellaneous 1 register */
  MCB_MISC2_tag MISC2;                 /* Miscellaneous 2 Register */
  MCB_MISC3_tag MISC3;                 /* Miscellaneous 3 Register */
  uint8_t MCB_reserved1[36];
  MCB_NEX_FIFO_STATUS_tag NEX_FIFO_STATUS; /* Nexus Trace Fifo Status Register */
  uint8_t MCB_reserved2[16356];
  MCB_CLKOUT_SEL_tag CLKOUT_SEL;       /* CLKOUT Source Select */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC2_tag;

typedef union MC_CGM_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE2_tag;

typedef union MC_CGM_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS2_tag;

typedef union MC_CGM_PCS_DIVC3_union_tag { /* PCS Divider Change Register 3 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC3_tag;

typedef union MC_CGM_PCS_DIVE3_union_tag { /* PCS Divider End Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE3_tag;

typedef union MC_CGM_PCS_DIVS3_union_tag { /* PCS Divider Start Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS3_tag;

typedef union MC_CGM_PCS_DIVC4_union_tag { /* PCS Divider Change Register 4 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC4_tag;

typedef union MC_CGM_PCS_DIVE4_union_tag { /* PCS Divider End Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE4_tag;

typedef union MC_CGM_PCS_DIVS4_union_tag { /* PCS Divider Start Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS4_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t SYS_DIV_RATIO_CHNG:1;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_TYPE:1;          /* System Clock Divider Update Type */
    vuint32_t _unused_16:15;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;          /* System Clock Divider Update Status */
    vuint32_t _unused_16:15;
    vuint32_t _unused_15:1;
    vuint32_t AUX14_UPD_STAT:1;        /* Auxiliary Clock 14 Divider Update Status */
    vuint32_t AUX13_UPD_STAT:1;        /* Auxiliary Clock 13 Divider Update Status */
    vuint32_t AUX12_UPD_STAT:1;        /* Auxiliary Clock 12 Divider Update Status */
    vuint32_t _unused_10:2;
    vuint32_t AUX9_UPD_STAT:1;         /* Auxiliary Clock 9 Divider Update Status */
    vuint32_t _unused_8:1;
    vuint32_t AUX7_UPD_STAT:1;         /* Auxiliary Clock 7 Divider Update Status */
    vuint32_t _unused_3:4;
    vuint32_t AUX2_UPD_STAT:1;         /* Auxiliary Clock 2 Divider Update Status */
    vuint32_t _unused_1:1;
    vuint32_t AUX0_UPD_STAT:1;         /* Auxiliary Clock 0 Divider Update Status */
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_20:4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t _unused_20:1;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_SC_DC3_union_tag { /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC3_tag;

typedef union MC_CGM_SC_DC4_union_tag { /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_SC_DC4_tag;

typedef union MC_CGM_AC0_SC_union_tag { /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC0_SC_tag;

typedef union MC_CGM_AC0_SS_union_tag { /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC0_SS_tag;

typedef union MC_CGM_AC0_DC0_union_tag { /* Auxiliary Clock 0 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC0_DC0_tag;

typedef union MC_CGM_AC0_DC2_union_tag { /* Auxiliary Clock 0 Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC0_DC2_tag;

typedef union MC_CGM_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SC_tag;

typedef union MC_CGM_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC2_SS_tag;

typedef union MC_CGM_AC2_DC0_union_tag { /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC2_DC0_tag;

typedef union MC_CGM_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC3_SC_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC4_SC_tag;

typedef union MC_CGM_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC4_SS_tag;

typedef union MC_CGM_AC7_SC_union_tag { /* Auxiliary Clock 7 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC7_SC_tag;

typedef union MC_CGM_AC7_SS_union_tag { /* Auxiliary Clock 7 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC7_SS_tag;

typedef union MC_CGM_AC7_DC0_union_tag { /* Auxiliary Clock 7 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC7_DC0_tag;

typedef union MC_CGM_AC9_DC0_union_tag { /* Auxiliary Clock 9 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC9_DC0_tag;

typedef union MC_CGM_AC12_SC_union_tag { /* Auxiliary Clock 12 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC12_SC_tag;

typedef union MC_CGM_AC12_SS_union_tag { /* Auxiliary Clock 12 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC12_SS_tag;

typedef union MC_CGM_AC12_DC0_union_tag { /* Auxiliary Clock 12 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC12_DC0_tag;

typedef union MC_CGM_AC13_SC_union_tag { /* Auxiliary Clock 13 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC13_SC_tag;

typedef union MC_CGM_AC13_SS_union_tag { /* Auxiliary Clock 13 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} MC_CGM_AC13_SS_tag;

typedef union MC_CGM_AC13_DC0_union_tag { /* Auxiliary Clock 13 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC13_DC0_tag;

typedef union MC_CGM_AC14_DC0_union_tag { /* Auxiliary Clock 14 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} MC_CGM_AC14_DC0_tag;

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1792];
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration Register */
  uint8_t MC_CGM_reserved1[3];
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change Register 1 */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End Register 1 */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start Register 1 */
  MC_CGM_PCS_DIVC2_tag PCS_DIVC2;      /* PCS Divider Change Register 2 */
  MC_CGM_PCS_DIVE2_tag PCS_DIVE2;      /* PCS Divider End Register 2 */
  MC_CGM_PCS_DIVS2_tag PCS_DIVS2;      /* PCS Divider Start Register 2 */
  MC_CGM_PCS_DIVC3_tag PCS_DIVC3;      /* PCS Divider Change Register 3 */
  MC_CGM_PCS_DIVE3_tag PCS_DIVE3;      /* PCS Divider End Register 3 */
  MC_CGM_PCS_DIVS3_tag PCS_DIVS3;      /* PCS Divider Start Register 3 */
  MC_CGM_PCS_DIVC4_tag PCS_DIVC4;      /* PCS Divider Change Register 4 */
  MC_CGM_PCS_DIVE4_tag PCS_DIVE4;      /* PCS Divider End Register 4 */
  MC_CGM_PCS_DIVS4_tag PCS_DIVS4;      /* PCS Divider Start Register 4 */
  uint8_t MC_CGM_reserved2[156];
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type Register */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger Register */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status Register */
  uint8_t MC_CGM_reserved3[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status Register */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider 0 Configuration Register */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider 1 Configuration Register */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider 2 Configuration Register */
  MC_CGM_SC_DC3_tag SC_DC3;            /* System Clock Divider 3 Configuration Register */
  MC_CGM_SC_DC4_tag SC_DC4;            /* System Clock Divider 4 Configuration Register */
  uint8_t MC_CGM_reserved4[4];
  MC_CGM_AC0_SC_tag AC0_SC;            /* Auxiliary Clock 0 Select Control Register */
  MC_CGM_AC0_SS_tag AC0_SS;            /* Auxiliary Clock 0 Select Status Register */
  MC_CGM_AC0_DC0_tag AC0_DC0;          /* Auxiliary Clock 0 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved5[4];
  MC_CGM_AC0_DC2_tag AC0_DC2;          /* Auxiliary Clock 0 Divider 2 Configuration Register */
  uint8_t MC_CGM_reserved6[44];
  MC_CGM_AC2_SC_tag AC2_SC;            /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_AC2_SS_tag AC2_SS;            /* Auxiliary Clock 2 Select Status Register */
  MC_CGM_AC2_DC0_tag AC2_DC0;          /* Auxiliary Clock 2 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved7[20];
  MC_CGM_AC3_SC_tag AC3_SC;            /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_AC3_SS_tag AC3_SS;            /* Auxiliary Clock 3 Select Status Register */
  uint8_t MC_CGM_reserved8[24];
  MC_CGM_AC4_SC_tag AC4_SC;            /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_AC4_SS_tag AC4_SS;            /* Auxiliary Clock 4 Select Status Register */
  uint8_t MC_CGM_reserved9[88];
  MC_CGM_AC7_SC_tag AC7_SC;            /* Auxiliary Clock 7 Select Control Register */
  MC_CGM_AC7_SS_tag AC7_SS;            /* Auxiliary Clock 7 Select Status Register */
  MC_CGM_AC7_DC0_tag AC7_DC0;          /* Auxiliary Clock 7 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved10[60];
  MC_CGM_AC9_DC0_tag AC9_DC0;          /* Auxiliary Clock 9 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved11[84];
  MC_CGM_AC12_SC_tag AC12_SC;          /* Auxiliary Clock 12 Select Control Register */
  MC_CGM_AC12_SS_tag AC12_SS;          /* Auxiliary Clock 12 Select Status Register */
  MC_CGM_AC12_DC0_tag AC12_DC0;        /* Auxiliary Clock 12 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved12[20];
  MC_CGM_AC13_SC_tag AC13_SC;          /* Auxiliary Clock 13 Select Control Register */
  MC_CGM_AC13_SS_tag AC13_SS;          /* Auxiliary Clock 13 Select Status Register */
  MC_CGM_AC13_DC0_tag AC13_DC0;        /* Auxiliary Clock 13 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved13[28];
  MC_CGM_AC14_DC0_tag AC14_DC0;        /* Auxiliary Clock 14 Divider 0 Configuration Register */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_24:2;
    vuint32_t S_PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t S_MVR:1;
    vuint32_t _unused_18:2;
    vuint32_t S_FLA:2;
    vuint32_t _unused_9:7;
    vuint32_t S_SDPLL:1;
    vuint32_t S_PLL1:1;
    vuint32_t S_PLL0:1;
    vuint32_t S_XOSC:1;
    vuint32_t S_IRC:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_11:4;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t I_ICONF_CU:1;
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t M_ICONF_CU:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t S_MRIG:1;
    vuint32_t _unused_4:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t _unused_24:4;
    vuint32_t MPH_BUSY:1;
    vuint32_t _unused_21:2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t _unused_15:1;
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t CDP_PRPH_224_255:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_TEST_MC_union_tag { /* TEST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_TEST_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN0 3 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_HALT0_MC_union_tag { /* HALT0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_HALT0_MC_tag;

typedef union MC_ME_STOP0_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t _unused_16:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP0_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t S_PIT_RTC_1:1;
    vuint32_t S_PIT_RTC_0:1;
    vuint32_t _unused_13:17;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_0:9;
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t _unused_28:1;
    vuint32_t _unused_24:4;
    vuint32_t _unused_23:1;
    vuint32_t _unused_18:5;
    vuint32_t S_DTS:1;
    vuint32_t _unused_7:10;
    vuint32_t S_CRC_0:1;
    vuint32_t _unused_5:1;
    vuint32_t S_DMAMUX_0:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t _unused_28:1;
    vuint32_t S_LIN_1:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_16:10;
    vuint32_t S_FLEXCAN_0:1;
    vuint32_t _unused_14:1;
    vuint32_t S_FLEXCAN_2:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_0:12;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t S_SAR_ADC_1:1;
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_16:12;
    vuint32_t _unused_15:1;
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;
    vuint32_t _unused_9:2;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t S_IIC_1:1;
    vuint32_t _unused_5:1;
    vuint32_t S_IIC_2:1;
    vuint32_t _unused_3:1;
    vuint32_t S_SPI_1:1;
    vuint32_t _unused_0:2;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_PS4_union_tag {    /* Peripheral Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t S_CRC_1:1;
    vuint32_t _unused_19:1;
    vuint32_t S_DMAMUX_1:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_14:2;
    vuint32_t _unused_13:1;
    vuint32_t _unused_10:3;
    vuint32_t S_ETIMER_1:1;
    vuint32_t _unused_0:9;
  } B;
} MC_ME_PS4_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t S_RADAR_CTE:1;
    vuint32_t S_SPT:1;
    vuint32_t _unused_24:3;
    vuint32_t _unused_23:1;
    vuint32_t _unused_0:23;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t S_DSPI_2:1;
    vuint32_t _unused_0:17;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_PS7_union_tag {    /* Peripheral Status Register 7 */
  vuint32_t R;
  struct {
    vuint32_t S_FlexPWM_0:1;
    vuint32_t _unused_28:3;
    vuint32_t S_CTU_0:1;
    vuint32_t _unused_24:3;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_16:5;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t S_SAR_ADC_0:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_0:11;
  } B;
} MC_ME_PS7_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t _unused_0:8;
  } B;
} MC_ME_LP_PC_tag;

typedef union MC_ME_PCTL30_union_tag { /* PIT_RTC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL30_tag;

typedef union MC_ME_PCTL31_union_tag { /* PIT_RTC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL31_tag;

typedef union MC_ME_PCTL36_union_tag { /* DMAMUX_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL36_tag;

typedef union MC_ME_PCTL38_union_tag { /* CRC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL38_tag;

typedef union MC_ME_PCTL45_union_tag { /* JTAGM Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL45_tag;

typedef union MC_ME_PCTL49_union_tag { /* DTS Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL49_tag;

typedef union MC_ME_PCTL61_union_tag { /* MIPI Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL61_tag;

typedef union MC_ME_PCTL77_union_tag { /* FLEXCAN_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL77_tag;

typedef union MC_ME_PCTL79_union_tag { /* FLEXCAN_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL79_tag;

typedef union MC_ME_PCTL91_union_tag { /* LINFlex_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL91_tag;

typedef union MC_ME_PCTL98_union_tag { /* SPI_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL98_tag;

typedef union MC_ME_PCTL100_union_tag { /* IIC_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL100_tag;

typedef union MC_ME_PCTL102_union_tag { /* IIC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL102_tag;

typedef union MC_ME_PCTL126_union_tag { /* SAR_ADC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL126_tag;

typedef union MC_ME_PCTL137_union_tag { /* ETIMER_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL137_tag;

typedef union MC_ME_PCTL146_union_tag { /* DMAMUX_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL146_tag;

typedef union MC_ME_PCTL148_union_tag { /* CRC_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL148_tag;

typedef union MC_ME_PCTL187_union_tag { /* SPT Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL187_tag;

typedef union MC_ME_PCTL188_union_tag { /* RADAR_CTE Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL188_tag;

typedef union MC_ME_PCTL209_union_tag { /* SPI_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL209_tag;

typedef union MC_ME_PCTL237_union_tag { /* SAR_ADC_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL237_tag;

typedef union MC_ME_PCTL251_union_tag { /* CTU_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL251_tag;

typedef union MC_ME_PCTL255_union_tag { /* FlexPWM_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL255_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t S_CORE3:1;
    vuint32_t S_CORE2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL2_union_tag {  /* Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL2_tag;

typedef union MC_ME_CCTL3_union_tag {  /* Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL3_tag;

typedef union MC_ME_CADDR2_union_tag { /* Core Control Registers */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR2_tag;

typedef union MC_ME_CADDR3_union_tag { /* Core Control Registers */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR3_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  MC_ME_TEST_MC_tag TEST_MC;           /* TEST Mode Configuration Register */
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN0 3 Mode Configuration Register */
  MC_ME_HALT0_MC_tag HALT0_MC;         /* HALT0 Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_STOP0_MC_tag STOP0_MC;         /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved2[20];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  MC_ME_PS4_tag PS4;                   /* Peripheral Status Register 4 */
  MC_ME_PS5_tag PS5;                   /* Peripheral Status Register 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status Register 6 */
  MC_ME_PS7_tag PS7;                   /* Peripheral Status Register 7 */
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  uint8_t MC_ME_reserved3[30];
  MC_ME_PCTL30_tag PCTL30;             /* PIT_RTC_0 Peripheral Control Register */
  MC_ME_PCTL31_tag PCTL31;             /* PIT_RTC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved4[4];
  MC_ME_PCTL36_tag PCTL36;             /* DMAMUX_0 Peripheral Control Register */
  uint8_t MC_ME_reserved5[1];
  MC_ME_PCTL38_tag PCTL38;             /* CRC_0 Peripheral Control Register */
  uint8_t MC_ME_reserved6[6];
  MC_ME_PCTL45_tag PCTL45;             /* JTAGM Peripheral Control Register */
  uint8_t MC_ME_reserved7[3];
  MC_ME_PCTL49_tag PCTL49;             /* DTS Peripheral Control Register */
  uint8_t MC_ME_reserved8[11];
  MC_ME_PCTL61_tag PCTL61;             /* MIPI Peripheral Control Register */
  uint8_t MC_ME_reserved9[15];
  MC_ME_PCTL77_tag PCTL77;             /* FLEXCAN_2 Peripheral Control Register */
  uint8_t MC_ME_reserved10[1];
  MC_ME_PCTL79_tag PCTL79;             /* FLEXCAN_0 Peripheral Control Register */
  uint8_t MC_ME_reserved11[11];
  MC_ME_PCTL91_tag PCTL91;             /* LINFlex_1 Peripheral Control Register */
  uint8_t MC_ME_reserved12[6];
  MC_ME_PCTL98_tag PCTL98;             /* SPI_1 Peripheral Control Register */
  uint8_t MC_ME_reserved13[1];
  MC_ME_PCTL100_tag PCTL100;           /* IIC_2 Peripheral Control Register */
  uint8_t MC_ME_reserved14[1];
  MC_ME_PCTL102_tag PCTL102;           /* IIC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved15[23];
  MC_ME_PCTL126_tag PCTL126;           /* SAR_ADC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved16[10];
  MC_ME_PCTL137_tag PCTL137;           /* ETIMER_1 Peripheral Control Register */
  uint8_t MC_ME_reserved17[8];
  MC_ME_PCTL146_tag PCTL146;           /* DMAMUX_1 Peripheral Control Register */
  uint8_t MC_ME_reserved18[1];
  MC_ME_PCTL148_tag PCTL148;           /* CRC_1 Peripheral Control Register */
  uint8_t MC_ME_reserved19[38];
  MC_ME_PCTL187_tag PCTL187;           /* SPT Peripheral Control Register */
  MC_ME_PCTL188_tag PCTL188;           /* RADAR_CTE Peripheral Control Register */
  uint8_t MC_ME_reserved20[20];
  MC_ME_PCTL209_tag PCTL209;           /* SPI_2 Peripheral Control Register */
  uint8_t MC_ME_reserved21[27];
  MC_ME_PCTL237_tag PCTL237;           /* SAR_ADC_0 Peripheral Control Register */
  uint8_t MC_ME_reserved22[13];
  MC_ME_PCTL251_tag PCTL251;           /* CTU_0 Peripheral Control Register */
  uint8_t MC_ME_reserved23[3];
  MC_ME_PCTL255_tag PCTL255;           /* FlexPWM_0 Peripheral Control Register */
  MC_ME_CS_tag CS;                     /* Core Status Register */
  uint8_t MC_ME_reserved24[4];
  MC_ME_CCTL2_tag CCTL2;               /* Core Control Register */
  MC_ME_CCTL3_tag CCTL3;               /* Core Control Register */
  uint8_t MC_ME_reserved25[28];
  MC_ME_CADDR2_tag CADDR2;             /* Core Control Registers */
  MC_ME_CADDR3_tag CADDR3;             /* Core Control Registers */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t _unused_0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

typedef union MEMU_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_CTRL_tag;

typedef union MEMU_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_ERR_FLAG_tag;

typedef union MEMU_DEBUG_union_tag {   /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_DEBUG_tag;

typedef union MEMU_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_SYS_RAM_CERR_STS_tag;

typedef union MEMU_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_SYS_RAM_CERR_struct_tag {
  MEMU_SYS_RAM_CERR_STS_tag STS;       /* System RAM correctable error reporting table status register */
  MEMU_SYS_RAM_CERR_ADDR_tag ADDR;     /* System RAM correctable error reporting table address register */
} MEMU_SYS_RAM_CERR_tag;

typedef union MEMU_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_SYS_RAM_OFLW_tag;

typedef union MEMU_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_PERIPH_RAM_CERR_struct_tag {
  MEMU_PERIPH_RAM_CERR_STS_tag STS;    /* Peripheral RAM correctable error reporting table status register */
  MEMU_PERIPH_RAM_CERR_ADDR_tag ADDR;  /* Peripheral RAM correctable error reporting table address register */
} MEMU_PERIPH_RAM_CERR_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_PERIPH_RAM_OFLW0_tag;

typedef union MEMU_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_FLASH_CERR_STS_tag;

typedef union MEMU_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_CERR_ADDR_tag;

typedef struct MEMU_FLASH_CERR_struct_tag {
  MEMU_FLASH_CERR_STS_tag STS;         /* Flash memory correctable error reporting table status register */
  MEMU_FLASH_CERR_ADDR_tag ADDR;       /* Flash memory correctable error reporting table address register */
} MEMU_FLASH_CERR_tag;

typedef union MEMU_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_FLASH_UNCERR_STS_tag;

typedef union MEMU_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_FLASH_OFLW0_tag;

struct MEMU_tag {
  MEMU_CTRL_tag CTRL;                  /* Control register */
  MEMU_ERR_FLAG_tag ERR_FLAG;          /* Error flag register */
  uint8_t MEMU_reserved0[4];
  MEMU_DEBUG_tag DEBUG;                /* Debug register */
  uint8_t MEMU_reserved1[16];
  MEMU_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_SYS_RAM_OFLW_tag SYS_RAM_OFLW[2]; /* System RAM concurrent overflow register */
  uint8_t MEMU_reserved2[1440];
  MEMU_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_reserved3[1508];
  MEMU_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_FLASH_OFLW0_tag FLASH_OFLW0;    /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: MIPICSI2 ===========================
   ============================================================================ */

typedef union MIPICSI2_CONC_union_tag { /* RX Controller Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;            /* Reserved */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t NULANE:1;                /* Number of active lanes being used to receive MIPICSI2 data */
  } B;
} MIPICSI2_CONC_tag;

typedef union MIPICSI2_PHYC_union_tag { /* PHY Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;            /* Reserved */
    vuint32_t RTERM_SEL:1;             /* Voltage Level selection for HS termination */
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t PDRX:1;                  /* Power Down Receiver */
    vuint32_t _unused_0:1;             /* Reserved */
  } B;
} MIPICSI2_PHYC_tag;

typedef union MIPICSI2_CLKCS_union_tag { /* Clock Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;           /* Reserved */
    vuint32_t HSSETL:6;                /* Clock Lane Program RX HS Settle */
    vuint32_t CULPMA:1;                /* Clock Lane ULPS mark Active State */
    vuint32_t CULPSA:1;                /* Clock Lane ULPS Active */
    vuint32_t CSTOP:1;                 /* Clock Lane Stop State */
    vuint32_t ULPSC:1;                 /* Clock Lane ULPS */
    vuint32_t HSRA:1;                  /* High Speed Clock Receive Active */
  } B;
} MIPICSI2_CLKCS_tag;

typedef union MIPICSI2_LAN0CS_union_tag { /* D-PHY Lane 0 Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;           /* Reserved */
    vuint32_t D0HSET:6;                /* Data lane 0 Program RX HS Settle time */
    vuint32_t D0ULMA:1;                /* Data Lane 0 ULPS Mark Active */
    vuint32_t D0ULPA:1;                /* Data lane 0 ULPS Active */
    vuint32_t D0STOP:1;                /* Data Lane 0 Stop State */
    vuint32_t _unused_2:1;
    vuint32_t RXACTH:1;                /* D-PHY Data lane 0 RX active High Speed data */
    vuint32_t RXVALH:1;                /* Data Lane 0 RX Valid HS */
  } B;
} MIPICSI2_LAN0CS_tag;

typedef union MIPICSI2_LAN1CS_union_tag { /* D-PHY Data LANE 1 Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;           /* Reserved */
    vuint32_t D1HSET:6;                /* D_PHY Data Lane 1 PRG HS Settle time */
    vuint32_t D1ULMA:1;                /* D_PHY Data Lane 1 ULPS Mark active */
    vuint32_t D1ULPA:1;                /* D-PHY Data Lane 1 ULPS Active */
    vuint32_t D1STOP:1;                /* D-PHY Data Lane 1 Stop */
    vuint32_t _unused_2:1;
    vuint32_t RXACTH:1;                /* D-PHY Data lane 1 Active HS */
    vuint32_t RXVALH:1;                /* D-PHY Data lane 1 Receive Valid High speed */
  } B;
} MIPICSI2_LAN1CS_tag;

typedef union MIPICSI2_RESCS_union_tag { /* External Resistor Configuration Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;            /* Reserved */
    vuint32_t CALOUT:2;                /* Calibrator output */
    vuint32_t CALCOM:1;                /* Calibration Complete */
    vuint32_t RCALI:2;                 /* Resistor Calibration Input */
    vuint32_t _unused_1:2;
    vuint32_t NOCAL:1;                 /* No Calibration */
  } B;
} MIPICSI2_RESCS_tag;

typedef union MIPICSI2_SR_union_tag {  /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t SOFRST:1;                /* Software reset */
    vuint32_t _unused_12:19;           /* Reserved */
    vuint32_t GNSPR:1;                 /* Generic Short Packet Received */
    vuint32_t _unused_0:11;            /* Reserved */
  } B;
} MIPICSI2_SR_tag;

typedef union MIPICSI2_DATAID_union_tag { /* DataID Report Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t DATIDF:6;                /* Data ID Field */
  } B;
} MIPICSI2_DATAID_tag;

typedef union MIPICSI2_ERRPPREG_union_tag { /* Protocol and Packet Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t INVID:1;                 /* Invalid ID */
    vuint32_t CRCERR:1;                /* CRC Error */
    vuint32_t ERFDAT:1;                /* Frame data error */
    vuint32_t ERFSYN:1;                /* Frame synchronization error */
    vuint32_t ECCTWO:1;                /* ECC Two Bit Error */
    vuint32_t ECCONE:1;                /* ECC one bit error */
  } B;
} MIPICSI2_ERRPPREG_tag;

typedef union MIPICSI2_ERRPOS_union_tag { /* Error Position */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;            /* Reserved */
    vuint32_t ERRPOS:5;                /* Error Position */
  } B;
} MIPICSI2_ERRPOS_tag;

typedef union MIPICSI2_ERPPINTEN_union_tag { /* Protocol Packet Error Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;            /* Reserved */
    vuint32_t GSPIE:1;                 /* Generic Short Packet Interrupt Enable */
    vuint32_t INIDIE:1;                /* Invalid ID Error Interrupt Enable */
    vuint32_t CRCEIE:1;                /* CRC Error Interrupt Enable */
    vuint32_t ERFDIE:1;                /* Error Frame Data Interrupt Enable */
    vuint32_t ERFSIE:1;                /* Frame Synchronization Error Interrupt Enable */
    vuint32_t ECCTIE:1;                /* ECC Two Interrupt Enable */
    vuint32_t ECCOIE:1;                /* ECC One Interrupt Enable */
  } B;
} MIPICSI2_ERPPINTEN_tag;

typedef union MIPICSI2_ERRPHY_union_tag { /* PHY Error Report Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;           /* Reserved */
    vuint32_t _unused_15:5;            /* Reserved */
    vuint32_t _unused_10:5;            /* Reserved */
    vuint32_t ERCTRL1:1;               /* Control Error on lane 1 */
    vuint32_t ERSYES1:1;               /* Synchronization error in Escape mode on lane 1 */
    vuint32_t ERRESC1:1;               /* Escape Mode Entry Error on lane 1 */
    vuint32_t NOSYN1:1;                /* No Synchronization Error Lane 1 */
    vuint32_t ERRSYN1:1;               /* Error in the synchronization pattern detected by PHY in lane1 */
    vuint32_t ERCTRL0:1;               /* Control Error on lane 0 */
    vuint32_t ERSYES0:1;               /* Synchronization error in Escape mode on lane 0 */
    vuint32_t ERRESC0:1;               /* Escape Mode Entry Error on lane 0 */
    vuint32_t NOSYN0:1;                /* No Synchronization Error Lane 0 on HS entry */
    vuint32_t ERRSY0:1;                /* Error in the synchronization pattern detected by PHY in lane0 */
  } B;
} MIPICSI2_ERRPHY_tag;

typedef union MIPICSI2_ERPHYIE_union_tag { /* Phy Error Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;           /* Reserved */
    vuint32_t _unused_17:3;            /* Reserved */
    vuint32_t _unused_15:2;            /* Reserved */
    vuint32_t _unused_10:5;            /* Reserved */
    vuint32_t ERCLIE1:1;
    vuint32_t ERSYIE1:1;
    vuint32_t ESERIE1:1;
    vuint32_t NOSIE1:1;
    vuint32_t ERSIE1:1;
    vuint32_t ERCLIE0:1;
    vuint32_t ERSYIE0:1;
    vuint32_t ESERIE0:1;
    vuint32_t NOSIE0:1;
    vuint32_t ERSIE0:1;
  } B;
} MIPICSI2_ERPHYIE_tag;

typedef union MIPICSI2_RXEN_union_tag { /* RX Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Reserved */
    vuint32_t RXEN:1;                  /* Receive enable */
  } B;
} MIPICSI2_RXEN_tag;

typedef union MIPICSI2_GNSP_union_tag { /* Generic Short Packet Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;           /* Reserved */
    vuint32_t DATAID:6;                /* Data type */
    vuint32_t DATA:16;                 /* Data field of a generic short packet */
  } B;
} MIPICSI2_GNSP_tag;

typedef union MIPICSI2_INVID_union_tag { /* Invalid ID Report Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t INVID:6;                 /* Invalid ID */
  } B;
} MIPICSI2_INVID_tag;

typedef union MIPICSI2_LINLEN_union_tag { /* LINE LENGTH */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved */
    vuint32_t LINLEN:16;               /* LINE LENGTH */
  } B;
} MIPICSI2_LINLEN_tag;

typedef union MIPICSI2_EXPCTDL_union_tag { /* Expected Number of Lines */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;           /* Reserved */
    vuint32_t EXPLINES:16;             /* Expected Number Of Lines In a Frame */
  } B;
} MIPICSI2_EXPCTDL_tag;

typedef union MIPICSI2_INTREN_union_tag { /* Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;            /* Reserved */
    vuint32_t LINCNTIE:1;              /* Line Count Error Interrupt Enable */
    vuint32_t LINLENIE:1;              /* Line Length Error Interrupt Enable */
    vuint32_t FRMENDIE:1;              /* Frame End Detection Interrupt Enable */
    vuint32_t FRMSRTIE:1;              /* Frame Start Detected Interrupt Enable */
  } B;
} MIPICSI2_INTREN_tag;

typedef union MIPICSI2_INTRS_union_tag { /* Interrupt Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;            /* Reserved */
    vuint32_t LINCNTERR:1;             /* Line Count Error Indication */
    vuint32_t LINLENERR:1;             /* Line Length Error Indication */
    vuint32_t FRMEND:1;                /* Frame End Indication */
    vuint32_t FRMSTR:1;                /* Frame Start Indication */
  } B;
} MIPICSI2_INTRS_tag;

struct MIPICSI2_tag {
  MIPICSI2_CONC_tag CONC;              /* RX Controller Configuration Register */
  MIPICSI2_PHYC_tag PHYC;              /* PHY Configuration Register */
  MIPICSI2_CLKCS_tag CLKCS;            /* Clock Configuration Status Register */
  MIPICSI2_LAN0CS_tag LAN0CS;          /* D-PHY Lane 0 Configuration Status Register */
  MIPICSI2_LAN1CS_tag LAN1CS;          /* D-PHY Data LANE 1 Configuration Status Register */
  uint8_t MIPICSI2_reserved0[12];
  MIPICSI2_RESCS_tag RESCS;            /* External Resistor Configuration Status Register */
  uint8_t MIPICSI2_reserved1[4];
  MIPICSI2_SR_tag SR;                  /* Status Register */
  MIPICSI2_DATAID_tag DATAID;          /* DataID Report Register */
  uint8_t MIPICSI2_reserved2[4];
  MIPICSI2_ERRPPREG_tag ERRPPREG;      /* Protocol and Packet Error Register */
  MIPICSI2_ERRPOS_tag ERRPOS;          /* Error Position */
  MIPICSI2_ERPPINTEN_tag ERPPINTEN;    /* Protocol Packet Error Interrupt Enable */
  uint8_t MIPICSI2_reserved3[4];
  MIPICSI2_ERRPHY_tag ERRPHY;          /* PHY Error Report Register */
  MIPICSI2_ERPHYIE_tag ERPHYIE;        /* Phy Error Interrupt Enable Register */
  MIPICSI2_RXEN_tag RXEN;              /* RX Enable Register */
  MIPICSI2_GNSP_tag GNSP;              /* Generic Short Packet Data Register */
  MIPICSI2_INVID_tag INVID;            /* Invalid ID Report Register */
  MIPICSI2_LINLEN_tag LINLEN;          /* LINE LENGTH */
  MIPICSI2_EXPCTDL_tag EXPCTDL;        /* Expected Number of Lines */
  MIPICSI2_INTREN_tag INTREN;          /* Interrupt Enable */
  MIPICSI2_INTRS_tag INTRS;            /* Interrupt Status */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t TME:1;
    vuint32_t _unused_3:26;
    vuint32_t LIFE:3;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t GRP:2;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t _unused_30:1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t _unused_28:1;
    vuint32_t MSTR:4;
    vuint32_t _unused_21:3;
    vuint32_t RL4:1;
    vuint32_t RL3:1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_IAHB_BE1_union_tag { /* IAHB Burst Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t _unused_24:3;
    vuint32_t _unused_19:5;
    vuint32_t PRE_DMA:1;
    vuint32_t BRE_DMA:1;
    vuint32_t BWE_DMA:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_D2I:1;
    vuint32_t BRE_D2I:1;
    vuint32_t BWE_D2I:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_I2D:1;
    vuint32_t BRE_I2D:1;
    vuint32_t BWE_I2D:1;
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE3_union_tag { /* IAHB Burst Enable 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PRE_AIPS1:1;
    vuint32_t BRE_AIPS1:1;
    vuint32_t BWE_AIPS1:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_AIPS0:1;
    vuint32_t BRE_AIPS0:1;
    vuint32_t BWE_AIPS0:1;
  } B;
} PCM_IAHB_BE3_tag;

typedef union PCM_IAHB_BE4_union_tag { /* IAHB Burst Enable 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t PRE_PRAM3:1;
    vuint32_t BRE_PRAM3:1;
    vuint32_t BWE_PRAM3:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_PRAM2:1;
    vuint32_t BRE_PRAM2:1;
    vuint32_t BWE_PRAM2:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_PRAM1:1;
    vuint32_t BRE_PRAM1:1;
    vuint32_t BWE_PRAM1:1;
  } B;
} PCM_IAHB_BE4_tag;

typedef union PCM_IAHB_BE5_union_tag { /* IAHB Burst Enable 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t PRE_Z7B:1;
    vuint32_t BRE_Z7B:1;
    vuint32_t BWE_Z7B:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_Z7A:1;
    vuint32_t BRE_Z7A:1;
    vuint32_t BWE_Z7A:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_SPT:1;
    vuint32_t BRE_SPT:1;
    vuint32_t BWE_SPT:1;
  } B;
} PCM_IAHB_BE5_tag;

struct PCM_tag {
  uint8_t PCM_reserved0[4];
  PCM_IAHB_BE1_tag IAHB_BE1;           /* IAHB Burst Enable 1 Register */
  uint8_t PCM_reserved1[4];
  PCM_IAHB_BE3_tag IAHB_BE3;           /* IAHB Burst Enable 3 Register */
  PCM_IAHB_BE4_tag IAHB_BE4;           /* IAHB Burst Enable 4 Register */
  PCM_IAHB_BE5_tag IAHB_BE5;           /* IAHB Burst Enable 5 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t RWSC:5;
    vuint32_t _unused_7:1;
    vuint32_t P0_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P0_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P1_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P1_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t P2_WCFG:2;
    vuint32_t _unused_21:5;
    vuint32_t _unused_20:1;
    vuint32_t _unused_17:3;
    vuint32_t BFEN_LK:1;
    vuint32_t ARBM:4;
    vuint32_t _unused_1:11;
    vuint32_t _unused_0:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t SAFE_CAL:1;
    vuint32_t _unused_5:3;
    vuint32_t IRMEN:1;
    vuint32_t _unused_1:3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t _unused_0:24;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCR4_union_tag { /* Platform Flash Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t P2_M15PFE:1;
    vuint32_t P2_M14PFE:1;
    vuint32_t P2_M13PFE:1;
    vuint32_t P2_M12PFE:1;
    vuint32_t P2_M11PFE:1;
    vuint32_t P2_M10PFE:1;
    vuint32_t P2_M9PFE:1;
    vuint32_t P2_M8PFE:1;
    vuint32_t P2_M7PFE:1;
    vuint32_t P2_M6PFE:1;
    vuint32_t P2_M5PFE:1;
    vuint32_t P2_M4PFE:1;
    vuint32_t P2_M3PFE:1;
    vuint32_t P2_M2PFE:1;
    vuint32_t P2_M1PFE:1;
    vuint32_t P2_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P2_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P2_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P2_PFLIM:2;
    vuint32_t P2_BFEN:1;
  } B;
} PFLASH_PFCR4_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t _unused_5:11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  PFLASH_PFCR4_tag PFCR4;              /* Platform Flash Configuration Register 4 */
  uint8_t PFLASH_reserved0[228];
  PFLASH_PFCRD_tag PFCRD[8];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t _unused_2:1;
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[220];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint8_t PIT_reserved1[24];
  PIT_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLL0CR_union_tag { /* PLLDIG PLL0 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL0CR_tag;

typedef union PLLDIG_PLL0SR_union_tag { /* PLLDIG PLL0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL0SR_tag;

typedef union PLLDIG_PLL0DV_union_tag { /* PLLDIG PLL0 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFDPHI1:4;               /* PHI1 reduced frequency divider. */
    vuint32_t _unused_22:5;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_15:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_7:5;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL0DV_tag;

typedef union PLLDIG_PLL1CR_union_tag { /* PLLDIG PLL1 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL1CR_tag;

typedef union PLLDIG_PLL1SR_union_tag { /* PLLDIG PLL1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL1SR_tag;

typedef union PLLDIG_PLL1DV_union_tag { /* PLLDIG PLL1 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_11:5;
    vuint32_t _unused_7:4;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL1DV_tag;

typedef union PLLDIG_PLL1FM_union_tag { /* PLLDIG PLL1 Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MODEN:1;                 /* Modulation enable. */
    vuint32_t MODSEL:1;                /* Modulation selection. */
    vuint32_t MODPRD:13;               /* Modulation period. */
    vuint32_t _unused_15:1;
    vuint32_t INCSTP:15;               /* Increment step. */
  } B;
} PLLDIG_PLL1FM_tag;

typedef union PLLDIG_PLL1FD_union_tag { /* PLLDIG PLL1 Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FDEN:1;                  /* Fractional Divide Enable */
    vuint32_t _unused_18:12;
    vuint32_t _unused_16:2;            /* Reserved. */
    vuint32_t _unused_12:4;
    vuint32_t FRCDIV:12;
  } B;
} PLLDIG_PLL1FD_tag;

struct PLLDIG_tag {
  PLLDIG_PLL0CR_tag PLL0CR;            /* PLLDIG PLL0 Control Register */
  PLLDIG_PLL0SR_tag PLL0SR;            /* PLLDIG PLL0 Status Register */
  PLLDIG_PLL0DV_tag PLL0DV;            /* PLLDIG PLL0 Divider Register */
  uint8_t PLLDIG_reserved0[20];
  PLLDIG_PLL1CR_tag PLL1CR;            /* PLLDIG PLL1 Control Register */
  PLLDIG_PLL1SR_tag PLL1SR;            /* PLLDIG PLL1 Status Register */
  PLLDIG_PLL1DV_tag PLL1DV;            /* PLLDIG PLL1 Divider Register */
  PLLDIG_PLL1FM_tag PLL1FM;            /* PLLDIG PLL1 Frequency Modulation Register */
  PLLDIG_PLL1FD_tag PLL1FD;            /* PLLDIG PLL1 Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

typedef union PMC_SMPS_CNTRL_union_tag { /* SMPS Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t PMC_SMPS_GI:4;           /* SMPS Overshoot Current Trimming */
    vuint32_t _unused_10:1;
    vuint32_t PMC_SMPS_ENILIM:1;       /* SMPS Inductor Current Limitation Enable */
    vuint32_t PMC_SMPS_ENCOR:1;        /* SMPS Hysteretic Correction Enable */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t PMC_SMPS_GD_SLOPE:2;     /* SMPS gate driver strength */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t PMC_SMPS_SS:2;           /* SMPS spread spectrum control */
    vuint32_t PMC_SMPS_EN:1;           /* SMPS controller enable */
  } B;
} PMC_SMPS_CNTRL_tag;

typedef union PMC_STTW_union_tag {     /* LVD Self Test Time Window Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;           /* Reserved */
    vuint32_t STTW:12;                 /* Self Test Time Window. */
  } B;
} PMC_STTW_tag;

typedef union PMC_SELF_TEST_UM_VD_REG_union_tag { /* Voltage Detect User Mode Test Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;           /* Reserved */
    vuint32_t ST_RESULT:1;             /* ST_RESULT. Self Test result status. */
    vuint32_t ST_DONE:1;               /* Self Test Done status. */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t ST_MODE:2;               /* Self Test mode bits for testing of LVDs and HVDs. */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t VD_ST_CTRL:4;            /* Voltage Detect Self Test Control */
  } B;
} PMC_SELF_TEST_UM_VD_REG_tag;

typedef union PMC_AFE_INTR_ENA_union_tag { /* AFE Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IE_EN:1;
    vuint32_t _unused_9:22;            /* Reserved */
    vuint32_t _unused_8:1;
    vuint32_t AFE_INT_EN_VREG8:1;
    vuint32_t AFE_INT_EN_VREG7:1;      /* AFE-7 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG6:1;      /* AFE-6 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG5:1;      /* AFE-5 Interrupt Enable/Disable Control */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} PMC_AFE_INTR_ENA_tag;

typedef union PMC_AFE_INTR_STATUS_union_tag { /* AFE Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;            /* Reserved */
    vuint32_t _unused_8:1;
    vuint32_t AFE_INT_STATUS_VREG8:1;
    vuint32_t AFE_INT_STATUS_VREG7:1;  /* AFE7-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG6:1;  /* AFE6-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG5:1;  /* AFE5-Interrupt Status */
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} PMC_AFE_INTR_STATUS_tag;

typedef union PMC_FIR_union_tag {      /* FCCU Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;            /* Reserved */
    vuint32_t STEST_FAULT:1;           /* A write to this bit sends a FCCU fault (single cycle) for LVD SELF TEST. This is self Clearing bit. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t HVD_FAULT:1;             /* High Voltage Detect Fault injection. */
    vuint32_t LVD_FAULT:1;             /* Low Voltage Detect Fault injection. */
  } B;
} PMC_FIR_tag;

typedef union PMC_PMCCR_union_tag {    /* PMC Control Register */
  vuint32_t R;
  struct {
    vuint32_t PMC_ENABLE:1;            /* PMC Enable Control */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t _unused_9:21;            /* Reserved */
    vuint32_t LVD_MIPI_ENABLE:1;
    vuint32_t LVD_PMC_ENABLE:1;
    vuint32_t LVD_IO_ENABLE:1;
    vuint32_t _unused_5:1;
    vuint32_t LVD_FLASH_ENABLE:1;
    vuint32_t HVD_ADC_ENABLE:1;
    vuint32_t LVD_ADC_ENABLE:1;
    vuint32_t HVD_CORE_INT_ENABLE:1;
    vuint32_t LVD_CORE_INT_ENABLE_AND_LVD_PLL_ENABLE:1; /* LVD Core and LVD_PLL Enable Disable control */
  } B;
} PMC_PMCCR_tag;

typedef union PMC_TS_IER_union_tag {   /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TS_EN:1;                 /* Temperature Sensor interrupts Enable */
    vuint32_t _unused_6:25;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TS1_2IE:1;               /* Temperature Sensor 1 input 2 Interrupt Enable. */
    vuint32_t TS1_0IE:1;               /* Temperature Sensor 1 input 0 Interrupt Enable. */
    vuint32_t _unused_2:1;
    vuint32_t TS0_2IE:1;               /* Temperature Sensor 0 input 2 Interrupt Enable. */
    vuint32_t TS0_0IE:1;               /* Temperature Sensor 0 input 0 Interrupt Enable. */
  } B;
} PMC_TS_IER_tag;

typedef union PMC_ESR_TD_union_tag {   /* Temperature Event Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_ESR_TD_tag;

typedef union PMC_REE_TD_union_tag {   /* Temperature Reset Event Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_REE_TD_tag;

typedef union PMC_RES_TD_union_tag {   /* Temperature Reset Event Selection register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;               /* TEMP1_2 Reset Event Select */
    vuint32_t TEMP1_0:1;               /* TEMP1_0 Reset Event Select */
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;               /* TEMP0_2 Reset Event Select */
    vuint32_t TEMP0_0:1;               /* TEMP0_0 Reset Event Select */
  } B;
} PMC_RES_TD_tag;

typedef union PMC_CTL_TD_union_tag {   /* Temperature detector configuration register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t TS1_TRIM_ADJ:5;
    vuint32_t TS1_DOUT_EN:1;
    vuint32_t TS1_AOUT_EN:1;
    vuint32_t _unused_7:1;
    vuint32_t TS0_TRIM_ADJ:5;
    vuint32_t TS0_DOUT_EN:1;
    vuint32_t TS0_AOUT_EN:1;
  } B;
} PMC_CTL_TD_tag;

typedef union PMC_TS_FIR_union_tag {   /* Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Reserved */
    vuint32_t TSNS_FAULT:1;            /* Temperature Sensor Fault injection. */
  } B;
} PMC_TS_FIR_tag;

struct PMC_tag {
  uint8_t PMC_reserved0[100];
  PMC_SMPS_CNTRL_tag SMPS_CNTRL;       /* SMPS Control Register */
  PMC_STTW_tag STTW;                   /* LVD Self Test Time Window Register */
  PMC_SELF_TEST_UM_VD_REG_tag SELF_TEST_UM_VD_REG; /* Voltage Detect User Mode Test Register */
  uint8_t PMC_reserved1[8];
  PMC_AFE_INTR_ENA_tag AFE_INTR_ENA;   /* AFE Interrupt Enable Register */
  uint8_t PMC_reserved2[4];
  PMC_AFE_INTR_STATUS_tag AFE_INTR_STATUS; /* AFE Interrupt Status Register */
  uint8_t PMC_reserved3[8];
  PMC_FIR_tag FIR;                     /* FCCU Fault Injection Register */
  uint8_t PMC_reserved4[4];
  PMC_PMCCR_tag PMCCR;                 /* PMC Control Register */
  PMC_TS_IER_tag TS_IER;               /* Interrupt Enable Register */
  PMC_ESR_TD_tag ESR_TD;               /* Temperature Event Status register */
  PMC_REE_TD_tag REE_TD;               /* Temperature Reset Event Enable register */
  PMC_RES_TD_tag RES_TD;               /* Temperature Reset Event Selection register */
  PMC_CTL_TD_tag CTL_TD;               /* Temperature detector configuration register */
  uint8_t PMC_reserved5[8];
  PMC_TS_FIR_tag TS_FIR;               /* Fault Injection Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

typedef union PRAMC_PRCR2_union_tag {  /* Platform RAM Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR2_tag;

typedef union PRAMC_PRCR3_union_tag {  /* Platform RAM Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR3_tag;

typedef union PRAMC_PRCR4_union_tag {  /* Platform RAM Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR4_tag;

typedef union PRAMC_PRCR5_union_tag {  /* Platform RAM Configuration Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR5_tag;

typedef union PRAMC_PRCR6_union_tag {  /* Platform RAM Configuration Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t PRI:2;                   /* AHB port arbitration mode. */
    vuint32_t P1_BO_DIS:1;             /* Port p1 read burst optimization disable. */
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR6_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
  PRAMC_PRCR2_tag PRCR2;               /* Platform RAM Configuration Register 2 */
  PRAMC_PRCR3_tag PRCR3;               /* Platform RAM Configuration Register 3 */
  PRAMC_PRCR4_tag PRCR4;               /* Platform RAM Configuration Register 4 */
  PRAMC_PRCR5_tag PRCR5;               /* Platform RAM Configuration Register 5 */
  PRAMC_PRCR6_tag PRCR6;               /* Platform RAM Configuration Register 6 */
};


/* ============================================================================
   =============================== Module: PRAM_XBAR ==========================
   ============================================================================ */

typedef union PRAM_XBAR_PRS0_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS0_tag;

typedef union PRAM_XBAR_CRS0_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS0_tag;

typedef union PRAM_XBAR_PRS1_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS1_tag;

typedef union PRAM_XBAR_CRS1_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS1_tag;

typedef union PRAM_XBAR_PRS2_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS2_tag;

typedef union PRAM_XBAR_CRS2_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS2_tag;

typedef union PRAM_XBAR_PRS3_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS3_tag;

typedef union PRAM_XBAR_CRS3_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS3_tag;

typedef union PRAM_XBAR_PRS4_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS4_tag;

typedef union PRAM_XBAR_CRS4_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS4_tag;

typedef union PRAM_XBAR_PRS7_union_tag { /* Priority Register Slave 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_PRS7_tag;

typedef union PRAM_XBAR_CRS7_union_tag { /* Control Register 7 */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;                  /* Locks the slave port's CRSn and PRSn registers to be read-only. After set, only a hardware reset clears it. */
    vuint32_t _unused_20:11;
    vuint32_t _unused_16:4;
    vuint32_t _unused_10:6;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CRS7_tag;

struct PRAM_XBAR_tag {
  PRAM_XBAR_PRS0_tag PRS0;             /* Priority Register Slave */
  uint8_t PRAM_XBAR_reserved0[12];
  PRAM_XBAR_CRS0_tag CRS0;             /* Control Register */
  uint8_t PRAM_XBAR_reserved1[236];
  PRAM_XBAR_PRS1_tag PRS1;             /* Priority Register Slave */
  uint8_t PRAM_XBAR_reserved2[12];
  PRAM_XBAR_CRS1_tag CRS1;             /* Control Register */
  uint8_t PRAM_XBAR_reserved3[236];
  PRAM_XBAR_PRS2_tag PRS2;             /* Priority Register Slave */
  uint8_t PRAM_XBAR_reserved4[12];
  PRAM_XBAR_CRS2_tag CRS2;             /* Control Register */
  uint8_t PRAM_XBAR_reserved5[236];
  PRAM_XBAR_PRS3_tag PRS3;             /* Priority Register Slave */
  uint8_t PRAM_XBAR_reserved6[12];
  PRAM_XBAR_CRS3_tag CRS3;             /* Control Register */
  uint8_t PRAM_XBAR_reserved7[236];
  PRAM_XBAR_PRS4_tag PRS4;             /* Priority Register Slave */
  uint8_t PRAM_XBAR_reserved8[12];
  PRAM_XBAR_CRS4_tag CRS4;             /* Control Register */
  uint8_t PRAM_XBAR_reserved9[748];
  PRAM_XBAR_PRS7_tag PRS7;             /* Priority Register Slave 7 */
  uint8_t PRAM_XBAR_reserved10[12];
  PRAM_XBAR_CRS7_tag CRS7;             /* Control Register 7 */
};


/* ============================================================================
   =============================== Module: RGM ================================
   ============================================================================ */

typedef union RGM_DES_union_tag {      /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t F_LVD_MIPI:1;            /* LVD on MIPI voltage */
    vuint32_t _unused_27:1;
    vuint32_t F_AFE_LVD6:1;
    vuint32_t F_AFE_LVD8:1;
    vuint32_t F_AFE_LVD7:1;
    vuint32_t F_TSR_DEST:1;
    vuint32_t F_AFE_LVD5:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t F_AFE_LVD0:1;
    vuint32_t F_LVD_PMC:1;
    vuint32_t F_LVD_IO:1;
    vuint32_t F_LVD_PLL:1;
    vuint32_t F_LVD_FLASH:1;
    vuint32_t F_HVD_ADC:1;
    vuint32_t F_LVD_ADC:1;
    vuint32_t F_HVD_CORE:1;
    vuint32_t F_LVD_CORE:1;
    vuint32_t F_EDR:1;
    vuint32_t _unused_7:1;
    vuint32_t F_SSSR:1;                /* Flag for SSCM Secure reset */
    vuint32_t F_STCU_SUF:1;
    vuint32_t F_FFRR:1;
    vuint32_t F_SOFT_DEST:1;
    vuint32_t _unused_1:2;
    vuint32_t F_POR:1;
  } B;
} RGM_DES_tag;

typedef union RGM_DERD_union_tag {     /* 'Destructive' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t D_LVD_MIPI:1;            /* Disable LVD on MIPI voltage 'destructive' reset */
    vuint32_t _unused_27:1;
    vuint32_t D_AFE_LVD6:1;
    vuint32_t D_AFE_LVD8:1;
    vuint32_t D_AFE_LVD7:1;
    vuint32_t D_TSR_DEST:1;
    vuint32_t D_AFE_LVD5:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t D_AFE_LVD0:1;
    vuint32_t D_LVD_PMC:1;
    vuint32_t D_LVD_IO:1;
    vuint32_t D_LVD_PLL:1;
    vuint32_t D_LVD_FLASH:1;
    vuint32_t D_HVD_ADC:1;
    vuint32_t D_LVD_ADC:1;
    vuint32_t D_HVD_CORE:1;
    vuint32_t D_LVD_CORE:1;
    vuint32_t D_EDR:1;
    vuint32_t _unused_7:1;
    vuint32_t D_SSSR:1;
    vuint32_t D_STCU_SUF:1;
    vuint32_t D_FFRR:1;
    vuint32_t D_SOFT_DEST:1;
    vuint32_t _unused_1:2;
    vuint32_t D_POR:1;
  } B;
} RGM_DERD_tag;

typedef union RGM_DEAR_union_tag {     /* 'Destructive' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t AR_TSR_DEST:1;
    vuint32_t _unused_0:23;
  } B;
} RGM_DEAR_tag;

typedef union RGM_FES_union_tag {      /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t F_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t F_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t F_EXR:1;
  } B;
} RGM_FES_tag;

typedef union RGM_FERD_union_tag {     /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t D_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t D_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t D_FCCU_SOFT:1;
    vuint32_t D_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t D_SOFT_FUNC:1;
    vuint32_t D_ST_DONE:1;
    vuint32_t _unused_0:2;
  } B;
} RGM_FERD_tag;

typedef union RGM_FEAR_union_tag {     /* 'Functional' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t AR_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t AR_JTAG_FUNC:1;
    vuint32_t _unused_1:9;
    vuint32_t _unused_0:1;
  } B;
} RGM_FEAR_tag;

typedef union RGM_FBRE_union_tag {     /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t BE_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t BE_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t BE_EXR:1;
  } B;
} RGM_FBRE_tag;

typedef union RGM_FESS_union_tag {     /* 'Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t SS_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t SS_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t SS_EXR:1;
  } B;
} RGM_FESS_tag;

typedef union RGM_FRET_union_tag {     /* 'Functional' Event Short Sequence Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t FRET:4;
  } B;
} RGM_FRET_tag;

typedef union RGM_DRET_union_tag {     /* Destructive Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t DRET:4;
  } B;
} RGM_DRET_tag;

struct RGM_tag {
  RGM_DES_tag DES;                     /* 'Destructive' Event Status Register */
  uint8_t RGM_reserved0[12];
  RGM_DERD_tag DERD;                   /* 'Destructive' Event Reset Disable Register */
  uint8_t RGM_reserved1[12];
  RGM_DEAR_tag DEAR;                   /* 'Destructive' Event Alternate Request Register */
  uint8_t RGM_reserved2[732];
  RGM_FES_tag FES;                     /* 'Functional' Event Status Register */
  uint8_t RGM_reserved3[12];
  RGM_FERD_tag FERD;                   /* 'Functional' Event Reset Disable Register */
  uint8_t RGM_reserved4[12];
  RGM_FEAR_tag FEAR;                   /* 'Functional' Event Alternate Request Register */
  uint8_t RGM_reserved5[12];
  RGM_FBRE_tag FBRE;                   /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t RGM_reserved6[12];
  RGM_FESS_tag FESS;                   /* 'Functional' Event Short Sequence Register */
  uint8_t RGM_reserved7[704];
  RGM_FRET_tag FRET;                   /* 'Functional' Event Short Sequence Register */
  uint8_t RGM_reserved8[3];
  RGM_DRET_tag DRET;                   /* Destructive Reset Escalation Threshold Register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t ROZ:2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:12;              /* MCU Part Number */
    vuint32_t _unused_14:6;
    vuint32_t Pkg:2;                   /* Package details */
    vuint32_t _unused_8:4;
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t CANFD:1;                 /* CANFD */
    vuint32_t Product_Family:8;        /* Product Family Number */
    vuint32_t Performance:8;           /* Performance of device, see */
    vuint32_t Configuration:8;         /* Configuration of device, see */
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* SIUL2 DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF30:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF29:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF28:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF27:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF26:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF25:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF24:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag x */
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* SIUL2 DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE31:1;
    vuint32_t EIRE30:1;
    vuint32_t EIRE29:1;
    vuint32_t EIRE28:1;
    vuint32_t EIRE27:1;
    vuint32_t EIRE26:1;
    vuint32_t EIRE25:1;
    vuint32_t EIRE24:1;
    vuint32_t EIRE23:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* SIUL2 DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR31:1;
    vuint32_t DIRSR30:1;
    vuint32_t DIRSR29:1;
    vuint32_t DIRSR28:1;
    vuint32_t DIRSR27:1;
    vuint32_t DIRSR26:1;
    vuint32_t DIRSR25:1;
    vuint32_t DIRSR24:1;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR0:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE31:1;
    vuint32_t IREE30:1;
    vuint32_t IREE29:1;
    vuint32_t IREE28:1;
    vuint32_t IREE27:1;
    vuint32_t IREE26:1;
    vuint32_t IREE25:1;
    vuint32_t IREE24:1;
    vuint32_t IREE23:1;
    vuint32_t IREE22:1;
    vuint32_t IREE21:1;
    vuint32_t IREE20:1;
    vuint32_t IREE19:1;
    vuint32_t IREE18:1;
    vuint32_t IREE17:1;
    vuint32_t IREE16:1;
    vuint32_t IREE15:1;
    vuint32_t IREE14:1;
    vuint32_t IREE13:1;
    vuint32_t IREE12:1;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE31:1;
    vuint32_t IFEE30:1;
    vuint32_t IFEE29:1;
    vuint32_t IFEE28:1;
    vuint32_t IFEE27:1;
    vuint32_t IFEE26:1;
    vuint32_t IFEE25:1;
    vuint32_t IFEE24:1;
    vuint32_t IFEE23:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE31:1;
    vuint32_t IFE30:1;
    vuint32_t IFE29:1;
    vuint32_t IFE28:1;
    vuint32_t IFE27:1;
    vuint32_t IFE26:1;
    vuint32_t IFE25:1;
    vuint32_t IFE24:1;
    vuint32_t IFE23:1;
    vuint32_t IFE22:1;
    vuint32_t IFE21:1;
    vuint32_t IFE20:1;
    vuint32_t IFE19:1;
    vuint32_t IFE18:1;
    vuint32_t IFE17:1;
    vuint32_t IFE16:1;
    vuint32_t IFE15:1;
    vuint32_t IFE14:1;
    vuint32_t IFE13:1;
    vuint32_t IFE12:1;
    vuint32_t IFE11:1;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t IFE7:1;
    vuint32_t IFE6:1;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t SRC:2;                   /* Slew Rate Control */
    vuint32_t _unused_26:2;
    vuint32_t OBE:1;                   /* GPIO Output Buffer Enable */
    vuint32_t ODE:1;                   /* Open Drain Enable To enable open drain both OBE and ODE bits need to be set. */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t APC:1;                   /* Analog Pad Control */
    vuint32_t _unused_20:2;
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t PUS:1;                   /* Pull Select */
    vuint32_t PUE:1;                   /* Pull Enable */
    vuint32_t INV:1;                   /* Invert */
    vuint32_t _unused_8:7;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_IMCR_union_tag {   /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Invert */
    vuint32_t _unused_15:16;
    vuint32_t _unused_8:7;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_IMCR_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t PDO_4n:1;                /* Pad Data Out */
    vuint32_t _unused_17:7;
    vuint32_t PDO_4n1:1;               /* Pad Data Out */
    vuint32_t _unused_9:7;
    vuint32_t PDO_4n2:1;               /* Pad Data Out */
    vuint32_t _unused_1:7;
    vuint32_t PDO_4n3:1;               /* Pad Data Out */
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t PDI_4n:1;                /* Pad Data In */
    vuint32_t _unused_17:7;
    vuint32_t PDI_4n1:1;               /* Pad Data In */
    vuint32_t _unused_9:7;
    vuint32_t PDI_4n2:1;               /* Pad Data In */
    vuint32_t _unused_1:7;
    vuint32_t PDI_4n3:1;               /* Pad Data In */
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;                 /* Mask Field */
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* SIUL2 DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* SIUL2 DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* SIUL2 DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[380];
  SIUL2_MSCR_tag MSCR[199];            /* SIUL2 Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved9[1252];
  SIUL2_IMCR_tag IMCR[94];             /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[1864];
  SIUL2_GPDO_tag GPDO[50];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved11[312];
  SIUL2_GPDI_tag GPDI[50];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved12[312];
  SIUL2_PGPDO_tag PGPDO[13];           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved13[38];
  SIUL2_PGPDI_tag PGPDI[13];           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved14[38];
  SIUL2_MPGPDO_tag MPGPDO[13];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CESR0_union_tag {   /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;                 /* Master n error, where the bus master number matches the bit number */
    vuint32_t _unused_15:1;
    vuint32_t _unused_4:11;
    vuint32_t HRL:3;                   /* Hardware revision level */
    vuint32_t GVLD:1;                  /* Global Valid (global enable/disable for the SMPU) */
  } B;
} SMPU_CESR0_tag;

typedef union SMPU_CESR1_union_tag {   /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;                /* Master n error overrun, where the bus master number matches the bit number */
    vuint32_t _unused_15:1;
    vuint32_t _unused_4:11;
    vuint32_t NRGD:4;                  /* Number of region descriptors */
  } B;
} SMPU_CESR1_tag;

typedef union SMPU_ERROR_EAR_union_tag { /* Error Address Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error address */
  } B;
} SMPU_ERROR_EAR_tag;

typedef union SMPU_ERROR_EDR_union_tag { /* Error Detail Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;                 /* Error access control detail */
    vuint32_t _unused_7:1;
    vuint32_t EATTR:2;                 /* Error attributes */
    vuint32_t ERW:1;                   /* Error read/write */
    vuint32_t EMN:4;                   /* Error master number */
  } B;
} SMPU_ERROR_EDR_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_EAR_tag EAR;              /* Error Address Register, Bus Master n */
  SMPU_ERROR_EDR_tag EDR;              /* Error Detail Register, Bus Master n */
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:32;              /* Start address */
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:32;              /* End address */
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_union_tag { /* Region Descriptor n, Word 2 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;                   /* Bus master 0 permissions */
    vuint32_t M1P:2;                   /* Bus master 1 permissions */
    vuint32_t M2P:2;                   /* Bus master 2 permissions */
    vuint32_t M3P:2;                   /* Bus master 3 permissions */
    vuint32_t M4P:2;                   /* Bus master 4 permissions */
    vuint32_t M5P:2;                   /* Bus master 5 permissions */
    vuint32_t M6P:2;                   /* Bus master 6 permissions */
    vuint32_t M7P:2;                   /* Bus master 7 permissions */
    vuint32_t M8P:2;                   /* Bus master 8 permissions */
    vuint32_t M9P:2;                   /* Bus master 9 permissions */
    vuint32_t M10P:2;                  /* Bus master 10 permissions */
    vuint32_t M11P:2;                  /* Bus master 11 permissions */
    vuint32_t M12P:2;                  /* Bus master 12 permissions */
    vuint32_t M13P:2;                  /* Bus master 13 permissions */
    vuint32_t M14P:2;                  /* Bus master 14 permissions */
    vuint32_t M15P:2;                  /* Bus master 15 permissions */
  } B;
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t RO:1;                    /* Read-Only */
    vuint32_t _unused_2:1;
    vuint32_t CI:1;                    /* Cache Inhibit */
    vuint32_t VLD:1;                   /* Valid */
  } B;
} SMPU_RGD_WORD3_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;            /* Region Descriptor n, Word 2 */
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CESR0_tag CESR0;                /* Control/Error Status Register 0 */
  SMPU_CESR1_tag CESR1;                /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[640];
  SMPU_RGD_tag RGD[16];
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t PCSIS:8;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_3:5;
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;            /* Always write the reset value to this field. */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t _unused_22:1;
    vuint32_t _unused_0:22;
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[8];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[1]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t _unused_29:1;
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t _unused_24:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_20:1;
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t _unused_18:1;
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t _unused_16:1;
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t _unused_30:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t _unused_23:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t _unused_18:1;            /* Always write the reset value to this field. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t _unused_15:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_14:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_0:14;
  } B;
} SPI_RSER_tag;

typedef union SPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t PCS:8;                   /* PCS */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_tag;

typedef union SPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_PUSHR_union_tag {
  SPI_PUSHR_PUSHR_tag PUSHR;           /* PUSH TX FIFO Register In Master Mode */
  SPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_PUSHR_tag PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[5];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved1[44];
  SPI_RXFR_tag RXFR[5];                /* Receive FIFO Registers */
};


/* ============================================================================
   =============================== Module: SPT ================================
   ============================================================================ */

typedef union SPT_GBL_CTRL_union_tag { /* SPT Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t _unused_4:1;
    vuint32_t AHB_BYTE_SWAP:1;         /* Bit to control data byte swapping on the AHB interface. */
    vuint32_t PG_ST_CTRL:1;            /* Program start control */
    vuint32_t ACQ_EN:1;                /* Acquisition Enable. */
    vuint32_t SPT_EN:1;                /* SPT Enable */
  } B;
} SPT_GBL_CTRL_tag;

typedef union SPT_ACQ_GBL_CTRL_0_union_tag { /* Acquisition Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_H_SEL:2;              /* Channel H Select */
    vuint32_t CH_G_SEL:2;              /* Channel G Select */
    vuint32_t CH_F_SEL:2;              /* Channel F Select */
    vuint32_t CH_E_SEL:2;              /* Channel E Select */
    vuint32_t CH_D_SEL:2;              /* Channel D Select */
    vuint32_t CH_C_SEL:2;              /* Channel C Select */
    vuint32_t CH_B_SEL:2;              /* Channel B Select */
    vuint32_t CH_A_SEL:2;              /* Channel A Select */
    vuint32_t CSI_ADC_SEL:1;           /* CSI Select */
    vuint32_t INF_CHRPS:1;             /* Infinite Chirps in a Frame */
    vuint32_t INF_SMPLS:1;             /* Infinite Samples in a Chirp */
    vuint32_t _unused_12:1;
    vuint32_t _unused_0:12;
  } B;
} SPT_ACQ_GBL_CTRL_0_tag;

typedef union SPT_ACQ_GBL_CTRL_1_union_tag { /* Acquisition Global Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t NUM_SMPL:16;             /* Number of Samples in a Chirp */
    vuint32_t NUM_CHRP:16;             /* Number of chirps in a frame */
  } B;
} SPT_ACQ_GBL_CTRL_1_tag;

typedef union SPT_ACQ_CTRL0_union_tag { /* Acquisition Control 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_A_DC:15;              /* Channel A Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_B_DC:15;              /* Channel B Offset Compensation value */
  } B;
} SPT_ACQ_CTRL0_tag;

typedef union SPT_ACQ_CTRL1_union_tag { /* Acquisition Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_C_DC:15;              /* Channel C Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_D_DC:15;              /* Channel D Offset Compensation value */
  } B;
} SPT_ACQ_CTRL1_tag;

typedef union SPT_ACQ_CTRL2_union_tag { /* Acquisition Control 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_E_DC:15;              /* Channel E Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_F_DC:15;              /* Channel F Offset Compensation value */
  } B;
} SPT_ACQ_CTRL2_tag;

typedef union SPT_ACQ_CTRL3_union_tag { /* Acquisition Control 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_G_DC:15;              /* Channel G Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_H_DC:15;              /* Channel H Offset Compensation value */
  } B;
} SPT_ACQ_CTRL3_tag;

typedef union SPT_SDMA_CTRL0_union_tag { /* SDMA Control 0 Register */
  vuint32_t R;
  struct {
    vuint32_t SDMA_START_ADDR:29;      /* SDMA Start Address */
    vuint32_t _unused_0:3;
  } B;
} SPT_SDMA_CTRL0_tag;

typedef union SPT_SDMA_CTRL1_union_tag { /* SDMA Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SDMA_BUF_LEN:16;         /* SDMA Buffer Length */
    vuint32_t HMASTER_ENC_DIS:1;       /* AHB Master ID generation disable */
    vuint32_t _unused_14:1;
    vuint32_t DATA_ORG_CFG:2;          /* Data Organization Configuration */
    vuint32_t TRF_MOD:1;               /* Transfer Mode */
    vuint32_t LINE_LEN:11;             /* Line Length */
  } B;
} SPT_SDMA_CTRL1_tag;

typedef union SPT_ACQ_STATUS_A0_union_tag { /* Acquisition Status Register A0 */
  vuint32_t R;
  struct {
    vuint32_t CH_A_SUM:32;             /* Channel A Sum */
  } B;
} SPT_ACQ_STATUS_A0_tag;

typedef union SPT_ACQ_STATUS_A1_union_tag { /* Acquisition Status Register A1 */
  vuint32_t R;
  struct {
    vuint32_t CH_A_MAX:16;             /* Channel A Maximum */
    vuint32_t CH_A_MIN:16;             /* Channel A Minimum */
  } B;
} SPT_ACQ_STATUS_A1_tag;

typedef union SPT_ACQ_STATUS_A2_union_tag { /* Acquisition Status Register A2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_A_BT:16;              /* Channel A Bit Toggle */
  } B;
} SPT_ACQ_STATUS_A2_tag;

typedef union SPT_ACQ_STATUS_B0_union_tag { /* Acquisition Status Register B0 */
  vuint32_t R;
  struct {
    vuint32_t CH_B_SUM:32;             /* Channel B Sum */
  } B;
} SPT_ACQ_STATUS_B0_tag;

typedef union SPT_ACQ_STATUS_B1_union_tag { /* Acquisition Status Register B1 */
  vuint32_t R;
  struct {
    vuint32_t CH_B_MAX:16;             /* Channel B Maximum */
    vuint32_t CH_B_MIN:16;             /* Channel B Minimum */
  } B;
} SPT_ACQ_STATUS_B1_tag;

typedef union SPT_ACQ_STATUS_B2_union_tag { /* Acquisition Status Register B2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_B_BT:16;              /* Channel B Bit Toggle */
  } B;
} SPT_ACQ_STATUS_B2_tag;

typedef union SPT_ACQ_STATUS_C0_union_tag { /* Acquisition Status Register C0 */
  vuint32_t R;
  struct {
    vuint32_t CH_C_SUM:32;             /* Channel C Sum */
  } B;
} SPT_ACQ_STATUS_C0_tag;

typedef union SPT_ACQ_STATUS_C1_union_tag { /* Acquisition Status Register C1 */
  vuint32_t R;
  struct {
    vuint32_t CH_C_MAX:16;             /* Channel C Maximum */
    vuint32_t CH_C_MIN:16;             /* Channel C Minimum */
  } B;
} SPT_ACQ_STATUS_C1_tag;

typedef union SPT_ACQ_STATUS_C2_union_tag { /* Acquisition Status Register C2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_C_BT:16;              /* Channel C Bit Toggle */
  } B;
} SPT_ACQ_STATUS_C2_tag;

typedef union SPT_ACQ_STATUS_D0_union_tag { /* Acquisition Status Register D0 */
  vuint32_t R;
  struct {
    vuint32_t CH_D_SUM:32;             /* Channel D Sum */
  } B;
} SPT_ACQ_STATUS_D0_tag;

typedef union SPT_ACQ_STATUS_D1_union_tag { /* Acquisition Status Register D1 */
  vuint32_t R;
  struct {
    vuint32_t CH_D_MAX:16;             /* Channel D Maximum */
    vuint32_t CH_D_MIN:16;             /* Channel D Minimum */
  } B;
} SPT_ACQ_STATUS_D1_tag;

typedef union SPT_ACQ_STATUS_D2_union_tag { /* Acquisition Status Register D2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_D_BT:16;              /* Channel D Bit Toggle */
  } B;
} SPT_ACQ_STATUS_D2_tag;

typedef union SPT_ACQ_STATUS_E0_union_tag { /* Acquisition Status Register E0 */
  vuint32_t R;
  struct {
    vuint32_t CH_E_SUM:32;             /* Channel E Sum */
  } B;
} SPT_ACQ_STATUS_E0_tag;

typedef union SPT_ACQ_STATUS_E1_union_tag { /* Acquisition Status Register E1 */
  vuint32_t R;
  struct {
    vuint32_t CH_E_MAX:16;             /* Channel E Maximum */
    vuint32_t CH_E_MIN:16;             /* Channel E Minimum */
  } B;
} SPT_ACQ_STATUS_E1_tag;

typedef union SPT_ACQ_STATUS_E2_union_tag { /* Acquisition Status Register E2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_E_BT:16;              /* Channel E Bit Toggle */
  } B;
} SPT_ACQ_STATUS_E2_tag;

typedef union SPT_ACQ_STATUS_F0_union_tag { /* Acquisition Status Register F0 */
  vuint32_t R;
  struct {
    vuint32_t CH_F_SUM:32;             /* Channel F Sum */
  } B;
} SPT_ACQ_STATUS_F0_tag;

typedef union SPT_ACQ_STATUS_F1_union_tag { /* Acquisition Status Register F1 */
  vuint32_t R;
  struct {
    vuint32_t CH_F_MAX:16;             /* Channel F Maximum */
    vuint32_t CH_F_MIN:16;             /* Channel F Minimum */
  } B;
} SPT_ACQ_STATUS_F1_tag;

typedef union SPT_ACQ_STATUS_F2_union_tag { /* Acquisition Status Register F2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_F_BT:16;              /* Channel F Bit Toggle */
  } B;
} SPT_ACQ_STATUS_F2_tag;

typedef union SPT_ACQ_STATUS_G0_union_tag { /* Acquisition Status Register G0 */
  vuint32_t R;
  struct {
    vuint32_t CH_G_SUM:32;             /* Channel G Sum */
  } B;
} SPT_ACQ_STATUS_G0_tag;

typedef union SPT_ACQ_STATUS_G1_union_tag { /* Acquisition Status Register G1 */
  vuint32_t R;
  struct {
    vuint32_t CH_G_MAX:16;             /* Channel G Maximum */
    vuint32_t CH_G_MIN:16;             /* Channel G Minimum */
  } B;
} SPT_ACQ_STATUS_G1_tag;

typedef union SPT_ACQ_STATUS_G2_union_tag { /* Acquisition Status Register G2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_G_BT:16;              /* Channel G Bit Toggle */
  } B;
} SPT_ACQ_STATUS_G2_tag;

typedef union SPT_ACQ_STATUS_H0_union_tag { /* Acquisition Status Register H0 */
  vuint32_t R;
  struct {
    vuint32_t CH_H_SUM:32;             /* Channel H Sum */
  } B;
} SPT_ACQ_STATUS_H0_tag;

typedef union SPT_ACQ_STATUS_H1_union_tag { /* Acquisition Status Register H1 */
  vuint32_t R;
  struct {
    vuint32_t CH_H_MAX:16;             /* Channel H Maximum */
    vuint32_t CH_H_MIN:16;             /* Channel H Minimum */
  } B;
} SPT_ACQ_STATUS_H1_tag;

typedef union SPT_ACQ_STATUS_H2_union_tag { /* Acquisition Status Register H2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_H_BT:16;              /* Channel H Bit Toggle */
  } B;
} SPT_ACQ_STATUS_H2_tag;

typedef union SPT_ACQ_CSI_CTRL_union_tag { /* Acquisition MIPICSI2 control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t REAL_DATA_MUX:2;         /* Configures the sequence of data when channel 5 is on */
    vuint32_t CALIB_ON:1;              /* Enables the fifth channel */
    vuint32_t DATA_MODE:1;             /* Defines the type of data. */
    vuint32_t INPUT_MODE:1;            /* Input Mode select */
  } B;
} SPT_ACQ_CSI_CTRL_tag;

typedef union SPT_SDMA_BYP_CTRL0_union_tag { /* Bypass SDMA Control 0 */
  vuint32_t R;
  struct {
    vuint32_t SDMA_START_ADDR_BYP:29;  /* Bypass SDMA Start Address */
    vuint32_t _unused_0:3;
  } B;
} SPT_SDMA_BYP_CTRL0_tag;

typedef union SPT_SDMA_BYP_CTRL1_union_tag { /* Bypass SDMA Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SDMA_BUF_LEN_BYP:16;     /* Bypass SDMA Buffer Length */
    vuint32_t _unused_11:5;
    vuint32_t LINE_LEN_BYP:11;         /* Line Length Bypass */
  } B;
} SPT_SDMA_BYP_CTRL1_tag;

typedef union SPT_ACQ_BYP_CTRL_union_tag { /* Acquisition Bypass Control Register */
  vuint32_t R;
  struct {
    vuint32_t NUM_SMPL_BYP:16;         /* Number of Samples in a Chirp */
    vuint32_t _unused_0:16;            /* reserved */
  } B;
} SPT_ACQ_BYP_CTRL_tag;

typedef union SPT_CS_PG_ST_ADDR_union_tag { /* Program Start Addr Register */
  vuint32_t R;
  struct {
    vuint32_t PG_ST_ADDR:32;           /* Program start address */
  } B;
} SPT_CS_PG_ST_ADDR_tag;

typedef union SPT_CS_MODE_CTRL_union_tag { /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t CSDMA_BRST_SZ:2;         /* Command Sequencer DMA Burst Size */
    vuint32_t ERROR_EN:1;              /* Error Enable */
    vuint32_t PREFETCH:1;              /* Early Pre-fetch Enable */
    vuint32_t BKPT3_RE:1;              /* Breakpoint 3 remains enabled */
    vuint32_t BKPT3_EN:1;              /* Breakpoint 3 enabled */
    vuint32_t BKPT2_RE:1;              /* Breakpoint 2 remains enabled */
    vuint32_t BKPT2_EN:1;              /* Breakpoint 2 enabled */
    vuint32_t BKPT1_RE:1;              /* Breakpoint 1 remains enabled */
    vuint32_t BKPT1_EN:1;              /* Breakpoint 1 enabled */
    vuint32_t BKPT0_RE:1;              /* Breakpoint 0 remains enabled */
    vuint32_t BKPT0_EN:1;              /* Breakpoint 0 enabled */
    vuint32_t CS_SYS_DEBUG:1;          /* System debug enable */
    vuint32_t CS_BKPT_DEBUG:1;         /* Breakpoint debug enable */
    vuint32_t CS_IMM_DEBUG:1;          /* IMM DEBUG enable */
    vuint32_t DEBUG_MD:2;              /* DEBUG MODE control */
    vuint32_t ASYNCSTOP:1;             /* Asynchronous STOP bit */
    vuint32_t STOP:1;                  /* STOP bit */
  } B;
} SPT_CS_MODE_CTRL_tag;

typedef union SPT_CS_WD_COUNT_union_tag { /* Watchdog Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t WD_COUNT:24;             /* Watchdog timer count */
  } B;
} SPT_CS_WD_COUNT_tag;

typedef union SPT_CS_BKPT0_ADDR_union_tag { /* Breakpoint0 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT0:32;                /* Breakpoint 0 address */
  } B;
} SPT_CS_BKPT0_ADDR_tag;

typedef union SPT_CS_BKPT1_ADDR_union_tag { /* Breakpoint1 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT1:32;                /* Breakpoint 1 address */
  } B;
} SPT_CS_BKPT1_ADDR_tag;

typedef union SPT_CS_BKPT2_ADDR_union_tag { /* Breakpoint2 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT2:32;                /* Breakpoint 2 address */
  } B;
} SPT_CS_BKPT2_ADDR_tag;

typedef union SPT_CS_BKPT3_ADDR_union_tag { /* Breakpoint3 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT3:32;                /* Breakpoint 3 address */
  } B;
} SPT_CS_BKPT3_ADDR_tag;

typedef union SPT_CS_JAM_INST0_union_tag { /* Jamming Instruction0 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_127_96:32;      /* Jamming instruction bits 127:96 */
  } B;
} SPT_CS_JAM_INST0_tag;

typedef union SPT_CS_JAM_INST1_union_tag { /* Jamming Instruction1 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_95_64:32;       /* Jamming instruction bits 95:64 */
  } B;
} SPT_CS_JAM_INST1_tag;

typedef union SPT_CS_JAM_INST2_union_tag { /* Jamming Instruction2 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_63_32:32;       /* Jamming instruction bits 63:32 */
  } B;
} SPT_CS_JAM_INST2_tag;

typedef union SPT_CS_JAM_INST3_union_tag { /* Jamming Instruction3 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_31_0:32;        /* Jamming instruction bits 31:0 */
  } B;
} SPT_CS_JAM_INST3_tag;

typedef union SPT_CS_CURR_INST_ADDR_union_tag { /* Current Instruction Addr Register */
  vuint32_t R;
  struct {
    vuint32_t CURRENT_INST_ADDR:32;    /* Current instruction pointer */
  } B;
} SPT_CS_CURR_INST_ADDR_tag;

typedef union SPT_CS_CURR_INST0_union_tag { /* Current Instruction0 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_127_96:32;     /* Current instruction bits 127:96 */
  } B;
} SPT_CS_CURR_INST0_tag;

typedef union SPT_CS_CURR_INST1_union_tag { /* Current Instruction1 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_95_64:32;      /* Current instruction bits 95:64 */
  } B;
} SPT_CS_CURR_INST1_tag;

typedef union SPT_CS_CURR_INST2_union_tag { /* Current Instruction2 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_63_32:32;      /* Current instruction bits 63:32 */
  } B;
} SPT_CS_CURR_INST2_tag;

typedef union SPT_CS_CURR_INST3_union_tag { /* Current Instruction3 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_31_0:32;       /* Current instruction bits 31:0 */
  } B;
} SPT_CS_CURR_INST3_tag;

typedef union SPT_CS_LOOPCNTR01_union_tag { /* Loop Counter 0 and 1 Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP_CNTR1:16;           /* Loop count of counter 1 */
    vuint32_t LOOP_CNTR0:16;           /* Loop count of counter 0 */
  } B;
} SPT_CS_LOOPCNTR01_tag;

typedef union SPT_CS_LOOPCNTR23_union_tag { /* Loop Counter 2 and 3 Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP_CNTR3:16;           /* Loop count of counter 3 */
    vuint32_t LOOP_CNTR2:16;           /* Loop count of counter 2 */
  } B;
} SPT_CS_LOOPCNTR23_tag;

typedef union SPT_CS_ERR_INST_ADDR_union_tag { /* Error Instruction Addr Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_INST_ADDR:32;      /* Error instruction pointer */
  } B;
} SPT_CS_ERR_INST_ADDR_tag;

typedef union SPT_CS_ERR_INST0_union_tag { /* Error Instruction 0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_127_96:32;      /* Error instruction bits 127:96 */
  } B;
} SPT_CS_ERR_INST0_tag;

typedef union SPT_CS_ERR_INST1_union_tag { /* Error Instruction 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_95_64:32;       /* Error instruction bits 95:64 */
  } B;
} SPT_CS_ERR_INST1_tag;

typedef union SPT_CS_ERR_INST2_union_tag { /* Error Instruction 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_63_32:32;       /* Error instruction bits 63:32 */
  } B;
} SPT_CS_ERR_INST2_tag;

typedef union SPT_CS_ERR_INST3_union_tag { /* Error Instruction 3 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_31_0:32;        /* Error instruction bits 31:0 */
  } B;
} SPT_CS_ERR_INST3_tag;

typedef union SPT_CS_STATUS0_union_tag { /* General Status 0 Register */
  vuint32_t R;
  struct {
    vuint32_t WD_ZERO:1;               /* Watchdog timer reached zero */
    vuint32_t _unused_17:14;
    vuint32_t BKPT3_OCC:1;             /* 'Breakpoint 3 hit' indication */
    vuint32_t BKPT2_OCC:1;             /* 'Breakpoint 2 hit' indication */
    vuint32_t BKPT1_OCC:1;             /* 'Breakpoint 1 hit' indication */
    vuint32_t BKPT0_OCC:1;             /* 'Breakpoint 0 hit' indication */
    vuint32_t JAM_OVR:1;               /* Jamming mode instruction completion indication */
    vuint32_t STEP_JUMP_OVR:1;         /* STEP JUMP mode break indication */
    vuint32_t STEP_ONCE_OVR:1;         /* STEP ONCE mode instruction completion indication */
    vuint32_t MD_JAM:1;                /* INSTRUCTION JAMMING mode indicator */
    vuint32_t MD_STEP_JUMP:1;          /* STEP JUMP mode indicator */
    vuint32_t MD_STEP_ONCE:1;          /* STEP ONCE mode indicator */
    vuint32_t MD_HALT:1;               /* HALT MODE indicator */
    vuint32_t PS_RUN:1;                /* RUN state indicator */
    vuint32_t PS_ASYNCSTOP:1;          /* ASYNCSTOP state indicator */
    vuint32_t PS_STOP:1;               /* STOP state indicator */
    vuint32_t PS_DEBUG:1;              /* DEBUG state indicator */
    vuint32_t PS_WAIT:1;               /* WAIT state indicator */
    vuint32_t PS_START:1;              /* START state indicator */
  } B;
} SPT_CS_STATUS0_tag;

typedef union SPT_CS_STATUS1_union_tag { /* General Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t JAM_ILL_JUMP:1;          /* Illegal JUMP in jamming mode */
    vuint32_t JAM_ILL_NEXT:1;          /* Illegal NEXT in jamming mode */
    vuint32_t JAM_ILL_LOOP:1;          /* Illegal LOOP in jamming mode */
    vuint32_t JAM_ILL_SYNC:1;          /* Illegal SYNC in jamming mode */
    vuint32_t JAM_ILL_OPCODE:1;        /* Illegal opcode in jamming mode */
    vuint32_t ILL_ADD:1;               /* Illegal ADD */
    vuint32_t ILL_GET:1;               /* Illegal GET */
    vuint32_t ILL_SET:1;               /* Illegal SET */
    vuint32_t ILL_NEXT:1;              /* Illegal NEXT */
    vuint32_t ILL_0CNTLOOP:1;          /* Illegal loop count error */
    vuint32_t ILL_LOOP:1;              /* illegal LOOP */
    vuint32_t ILL_OPCODE:1;            /* Illegal opcode */
  } B;
} SPT_CS_STATUS1_tag;

typedef union SPT_CS_STATUS2_union_tag { /* General Status2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t WD_WAITREG_TR:2;         /* Event trigger type for WATCHDOG timer */
    vuint32_t WD_WAITREG_RFS:1;        /* Watchdog waits for cte_rfs or csi_vsync signal */
    vuint32_t WD_WAITREG_RCS:1;        /* Watchdog waits for cte_rcs or csi_hsync signal */
    vuint32_t WD_WAITREG_CTE:4;        /* Watchdog waits for CTE */
    vuint32_t WAITREG_TR:2;            /* Event trigger type */
    vuint32_t WAITREG_PXD:1;           /* WAIT status for 'pdma transfer done' signal */
    vuint32_t WAITREG_FAD:1;           /* WAIT status for 'frame acquisition done' signal */
    vuint32_t WAITREG_CAD:1;           /* WAIT status for 'chirp acquisition done' signal */
    vuint32_t WAITREG_RFS:1;           /* WAIT status for cte_rfs */
    vuint32_t WAITREG_RCS:1;           /* WAIT status for cte_rcs */
    vuint32_t WAITREG_CTE:4;           /* WAIT status for CTE event */
    vuint32_t WAITREG_SW:8;            /* WAIT status for SW-enforced event */
  } B;
} SPT_CS_STATUS2_tag;

typedef union SPT_CS_STATUS3_union_tag { /* General Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CS_DMA_ON:1;             /* Command sequencer DMA ON */
    vuint32_t PROC_STATE:4;            /* Processing state */
    vuint32_t LOOP_DEPTH:3;            /* Loop depth */
  } B;
} SPT_CS_STATUS3_tag;

typedef union SPT_CS_EVTREG1_union_tag { /* EVT1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVTREG1:8;               /* EVT1 register */
  } B;
} SPT_CS_EVTREG1_tag;

typedef union SPT_CS_EVTREG2_union_tag { /* EVT2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVTREG2:8;               /* EVT2 register */
  } B;
} SPT_CS_EVTREG2_tag;

typedef union SPT_CS_SW_EVTREG_union_tag { /* SW Event Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t SW_EVTREG:8;             /* SW event trigger */
  } B;
} SPT_CS_SW_EVTREG_tag;

typedef union SPT_CORE1_VER_EVT_union_tag { /* Core 1 Version Register Events */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PDMA_TRANS_DONE_EVT1:1;  /* Event for PDMA transfer done for CPU core 1 */
    vuint32_t ACQ_FRM_DONE_EVT1:1;     /* Event for acquisition frame done for CPU core 1 */
    vuint32_t ACQ_WIN_DONE_EVT1:1;     /* Event for acquisition window finished for CPU core 1 */
    vuint32_t EVTREG1:8;               /* EVT1 register */
  } B;
} SPT_CORE1_VER_EVT_tag;

typedef union SPT_CORE2_VER_EVT_union_tag { /* Core 2 Version Register Events */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PDMA_TRANS_DONE_EVT2:1;  /* Event for PDMA transfer done for CPU core 2 */
    vuint32_t ACQ_FRM_DONE_EVT2:1;     /* Event for acquisition frame done for CPU core 2 */
    vuint32_t ACQ_WIN_DONE_EVT2:1;     /* Event for acquisition window finished for CPU core 2 */
    vuint32_t EVTREG2:8;               /* EVT2 register */
  } B;
} SPT_CORE2_VER_EVT_tag;

typedef union SPT_EVENT_RST_CTRL_union_tag { /* SPT Event Reset Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE_RST:1;
    vuint32_t FRM_ACQ_DONE_RST:1;
    vuint32_t CHRP_ACQ_DONE_RST:1;
  } B;
} SPT_EVENT_RST_CTRL_tag;

typedef union SPT_PDMA_LFSR_LOAD_VAL_HIGH_union_tag { /* LFSR Load High Value */
  vuint32_t R;
  struct {
    vuint32_t PDMA_LFSR_LOAD_VAL_HIGH:32; /* LFSR High value [63:32] for compression */
  } B;
} SPT_PDMA_LFSR_LOAD_VAL_HIGH_tag;

typedef union SPT_PDMA_LFSR_LOAD_VAL_LOW_union_tag { /* LFSR Load Low Value */
  vuint32_t R;
  struct {
    vuint32_t PDMA_LFSR_LOAD_VAL_LOW:32; /* LFSR Low Value [31:0] for compression */
  } B;
} SPT_PDMA_LFSR_LOAD_VAL_LOW_tag;

typedef union SPT_PDMA_CONTROL_union_tag { /* PDMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t PDMA_COUNT_CS_PRIORITY:16; /* PDMA Count register for Command sequencer to get priority */
    vuint32_t _unused_4:12;
    vuint32_t PDMA_MAX_BURST_SIZE:2;   /* Maximum AHB burst size */
    vuint32_t _unused_1:1;
    vuint32_t PDMA_LFSR_LOAD_EN:1;     /* LFSR load enable bit */
  } B;
} SPT_PDMA_CONTROL_tag;

typedef union SPT_PDMA_TRANSFER_COUNT_STATUS_union_tag { /* PDMA Transfer Count Status */
  vuint32_t R;
  struct {
    vuint32_t AGGR_DATA_COUNT:16;      /* Aggregation Data Count */
    vuint32_t TRANSFER_COUNT:16;       /* Number of words transferred via PDMA */
  } B;
} SPT_PDMA_TRANSFER_COUNT_STATUS_tag;

typedef union SPT_PDMA_FMTB_EXP_ADDR_STATUS_union_tag { /* PDMA formatB Exponent Address status Register */
  vuint32_t R;
  struct {
    vuint32_t EXPN_ADDR:32;            /* Exponent Address */
  } B;
} SPT_PDMA_FMTB_EXP_ADDR_STATUS_tag;

typedef union SPT_MEM_ERR_INJECT_CTRL_union_tag { /* Memory Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TR_PAR_ERR_INJ:4;        /* Twiddle RAM parity error Injection */
    vuint32_t OR_PAR_ERR_INJ:4;        /* Operand RAM parity error Injection */
  } B;
} SPT_MEM_ERR_INJECT_CTRL_tag;

typedef union SPT_MEM_ERR_STATUS_union_tag { /* Memory Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t OR_MOD_PAR_ERR:1;        /* Operand RAM module parity error */
    vuint32_t OR_DMA_PAR_ERR:1;        /* Operand RAM DMA parity error */
    vuint32_t OR_2_ACC_CONTN:1;        /* Operand RAM two access contention */
    vuint32_t OR_3_ACC_CONTN:1;        /* Operand RAM three access contention */
    vuint32_t _unused_16:12;
    vuint32_t TR_PAR_ERR:1;            /* Twiddle RAM parity error */
    vuint32_t _unused_2:13;
    vuint32_t WR_LCK_VIOL:1;           /* Work register lock violation */
    vuint32_t _unused_0:1;
  } B;
} SPT_MEM_ERR_STATUS_tag;

typedef union SPT_MEM_ERR_INT_EN_union_tag { /* Memory Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t OR_MOD_PAR_IE:1;         /* Operand RAM module parity interrupt enable */
    vuint32_t OR_DMA_PAR_IE:1;         /* Operand RAM DMA parity interrupt enable */
    vuint32_t OR_2_ACC_IE:1;           /* Operand RAM two access contention interrupt enable */
    vuint32_t OR_3_ACC_IE:1;           /* Operand RAM three access contention interrupt enable */
    vuint32_t _unused_16:12;
    vuint32_t TR_PAR_IE:1;             /* Twiddle RAM parity error interrupt enable */
    vuint32_t _unused_2:13;
    vuint32_t WR_LCK_IE:1;             /* Work register lock interrupt enable */
    vuint32_t _unused_0:1;
  } B;
} SPT_MEM_ERR_INT_EN_tag;

typedef union SPT_DMA_ERR_STATUS_union_tag { /* DMA Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t INCMPLT_SMPL_RCVD:1;     /* Incomplete sample received */
    vuint32_t LINE_LEN_EXCD_BYP_ERR:1; /* Bypass SDMA line length exceeded */
    vuint32_t LINE_LEN_EXCD_ERR:1;     /* Line Length Exceeded */
    vuint32_t SDMA_WR_ERR_BYP:1;       /* Bypass SDMA write error */
    vuint32_t SDMA_RD_ERR_BYP:1;       /* Bypass SDMA read error */
    vuint32_t CS_AHB_ERR:1;            /* Command Sequencer AHB error Response */
    vuint32_t SDMA_AHB_ERR:1;          /* SDMA AHB Error Response */
    vuint32_t PDMA_AHB_ERR:1;          /* PDMA AHB Error */
    vuint32_t SDMA_RD_ERR:1;           /* SDMA Read Error */
    vuint32_t SDMA_WR_ERR:1;           /* SDMA Write Error */
    vuint32_t DMA_COMMAND_ERR:1;
    vuint32_t ILLEGAL_COMMAND_ERR:1;
    vuint32_t _unused_0:1;
  } B;
} SPT_DMA_ERR_STATUS_tag;

typedef union SPT_DMA_ERR_INT_EN_union_tag { /* Interrupt Enable for DMA_ERROR_STATUS */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t LINE_LEN_EXCD_BYP_IE:1;  /* Bypass SDMA line length exceeded interrupt */
    vuint32_t LINE_LEN_EXCD_IE:1;      /* Line length exceeded interrupt */
    vuint32_t SDMA_WR_ERR_BYP_IE:1;    /* Bypass SDMA write error interrupt */
    vuint32_t SDMA_RD_ERR_BYP_IE:1;    /* Bypass SDMA read error interrupt */
    vuint32_t CS_AHB_ERR_IE:1;         /* Command Sequencer AHB Interrupt Enable */
    vuint32_t SDMA_AHB_ERR_IE:1;       /* SDMA AHB Error Interrupt Enable */
    vuint32_t PDMA_AHB_ERR_IE:1;       /* Interrupt Enable for PDMA AHB Error */
    vuint32_t SDMA_RD_ERR_IE:1;        /* SDMA Read Error Interrupt Enable */
    vuint32_t SDMA_WR_ERR_IE:1;        /* SDMA Write Error Interrupt Enable */
    vuint32_t DMA_COMMAND_ERR_IE:1;
    vuint32_t ILLEGAL_COMMAND_ERR_IE:1;
    vuint32_t _unused_0:1;             /* Interrupt Enable bit */
  } B;
} SPT_DMA_ERR_INT_EN_tag;

typedef union SPT_GBL_STATUS_union_tag { /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE:1;       /* PDMA transfer done */
    vuint32_t FRM_ACQ_DONE:1;          /* Frame Acquisition Done */
    vuint32_t CHRP_ACQ_DONE:1;         /* Chirp Acquisition Done */
  } B;
} SPT_GBL_STATUS_tag;

typedef union SPT_GBL_STATUS_IE_union_tag { /* Global Status Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE_IE:1;    /* PDMA transfer done interrupt enable */
    vuint32_t FRM_ACQ_DONE_IE:1;       /* Frame Acquisition Done Interrupt Enable */
    vuint32_t CHRP_ACQ_DONE_IE:1;      /* Chirp Acquisition Done Interrupt Enable */
  } B;
} SPT_GBL_STATUS_IE_tag;

typedef union SPT_HW_ACC_ERR_STATUS_union_tag { /* Hardware Accelerator Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t FFT_RDX2_RND_ERR:1;      /* FFT Radix2 Round Error */
    vuint32_t FFT_OPR_ADDR_ERR:1;      /* Operand Address Error */
    vuint32_t FFT_MULT_COEF2_ERR:1;    /* FFT MULT Co-efficient 2 Error */
    vuint32_t FFT_MULT_COEF1_ERR:1;    /* FFT MULT Co-efficient 1 Error */
    vuint32_t FFT_TW_OVS_ERR:1;        /* FFT Twiddle Oversampling Error */
    vuint32_t FFT_QE_VL_OVS_ERR:1;     /* Quadrature Extension Vector Length Oversampling Error */
    vuint32_t FFT_RDX4_RND_ERR:1;      /* FFT Radix4 Round Error */
    vuint32_t FFT_WIN_RND_ERR:1;       /* FFT Window Round Error */
    vuint32_t MAXS_IP_CMD_ERR:1;       /* MAXS input command error */
    vuint32_t _unused_20:3;
    vuint32_t COPY_IP_CMD_ERR:1;       /* COPY input command error */
    vuint32_t _unused_16:3;
    vuint32_t FFT_ILL_SHFTVAL:1;       /* FFT Illegal Shift Value error */
    vuint32_t _unused_11:4;
    vuint32_t HST_DESTADDR_NOT_MULTOF8_ERR:1; /* Destination address not multiple of 8 error */
    vuint32_t HST_SRCADDR_NOT_MULTOF8_ERR:1; /* Source address not multiple of 8 error */
    vuint32_t HST_SRC_NOT_OR_ERR:1;    /* Source not Operand RAM error */
    vuint32_t HST_VECLEN_NOT_MULTOF8_ERR:1; /* Vector length not multiple of 8 error */
    vuint32_t HST_INVALID_WR_ACCESS_ERR:1; /* HIST work register access error */
    vuint32_t _unused_4:2;
    vuint32_t VMT_SHFT_OVF_ERR:1;      /* VMT Shift Overflow Error */
    vuint32_t VMT_CON_RL_ERR:1;        /* VMT Conjugate with Real Type Error */
    vuint32_t VMT_SS_CB_ERR:1;         /* VMT Sum Scale with Conjugate/Bypass Error */
    vuint32_t VMT_DVS_ERR:1;           /* VMT Dual vector sum error */
  } B;
} SPT_HW_ACC_ERR_STATUS_tag;

typedef union SPT_HW_ACC_ERR_IE_union_tag { /* Hardware Accelerator Error Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FFT_RDX2_RND_IE:1;       /* FFT Radix2 Round Error Interrupt Enable */
    vuint32_t FFT_OPR_ADDR_IE:1;       /* Operand Address Interrupt Enable */
    vuint32_t FFT_MULT_COEF2_IE:1;     /* FFT MULT Co-efficient 2 Interrupt Enable */
    vuint32_t FFT_MULT_COEF1_IE:1;     /* FFT MULT Co-efficient 1 Interrupt Enable */
    vuint32_t FFT_TW_OVS_IE:1;         /* FFT Twiddle Oversampling Interrupt Enable */
    vuint32_t FFT_QE_VL_OVS_IE:1;      /* Quadrature Extension Vector Length Oversampling Interrupt Enable */
    vuint32_t FFT_RDX4_RND_IE:1;       /* FFT Radix4 Round Error Interrupt Enable */
    vuint32_t FFT_WIN_RND_IE:1;        /* FFT Window Round Interrupt Enable */
    vuint32_t MAXS_IP_CMD_IE:1;        /* MAXS input command interrupt enable */
    vuint32_t _unused_20:3;
    vuint32_t COPY_IP_CMD_IE:1;        /* COPY input command interrupt enable */
    vuint32_t _unused_16:3;
    vuint32_t FFT_ILL_SHFTVAL_IE:1;    /* FFT Illegal Shift Value Error */
    vuint32_t _unused_11:4;
    vuint32_t HST_DESTADDR_NOT_MULTOF8_ERR_IE:1; /* Destination address not multiple of 8 error interrupt enable */
    vuint32_t HST_SRCADDR_NOT_MULTOF8_ERR_IE:1; /* Source address not multiple of 8 error interrupt enable */
    vuint32_t HST_SRC_NOT_OR_ERR_IE:1; /* Source not Operand RAM error interrupt enable */
    vuint32_t HST_VECLEN_NOT_MULTOF8_ERR_IE:1; /* Vector length not multiple of 8 error interrupt enable */
    vuint32_t HST_INVALID_WR_ACCESS_ERR_IE:1; /* HIST work register access error interrupt enable */
    vuint32_t _unused_4:2;
    vuint32_t VMT_SHFT_OVF_IE:1;       /* VMT Shift Overflow Interrupt Enable. */
    vuint32_t VMT_CON_RL_IE:1;         /* VMT Conjugate with Real Type Interrupt Enable */
    vuint32_t VMT_SS_CB_IE:1;          /* VMT Sum Scale with Conjugate/Bypass Interrupt Enable */
    vuint32_t VMT_DVS_IE:1;            /* VMT Dual vector sum Interrupt Enable */
  } B;
} SPT_HW_ACC_ERR_IE_tag;

typedef union SPT_HIST_OVF_STATUS0_union_tag { /* HIST Overflow Status0 Register */
  vuint32_t R;
  struct {
    vuint32_t B31_OVF:1;               /* Bin 31 overflow */
    vuint32_t B30_OVF:1;               /* Bin 30 overflow */
    vuint32_t B29_OVF:1;               /* Bin 29 overflow */
    vuint32_t B28_OVF:1;               /* Bin 28 overflow */
    vuint32_t B27_OVF:1;               /* Bin 27 overflow */
    vuint32_t B26_OVF:1;               /* Bin 26 overflow */
    vuint32_t B25_OVF:1;               /* Bin 25 overflow */
    vuint32_t B24_OVF:1;               /* Bin 24 overflow */
    vuint32_t B23_OVF:1;               /* Bin 23 overflow */
    vuint32_t B22_OVF:1;               /* Bin 22 overflow */
    vuint32_t B21_OVF:1;               /* Bin 21 overflow */
    vuint32_t B20_OVF:1;               /* Bin 20 overflow */
    vuint32_t B19_OVF:1;               /* Bin 19 overflow */
    vuint32_t B18_OVF:1;               /* Bin 18 overflow */
    vuint32_t B17_OVF:1;               /* Bin 17 overflow */
    vuint32_t B16_OVF:1;               /* Bin 16 overflow */
    vuint32_t B15_OVF:1;               /* Bin 15 overflow */
    vuint32_t B14_OVF:1;               /* Bin 14 overflow */
    vuint32_t B13_OVF:1;               /* Bin 13 overflow */
    vuint32_t B12_OVF:1;               /* Bin 12 overflow */
    vuint32_t B11_OVF:1;               /* Bin 11 overflow */
    vuint32_t B10_OVF:1;               /* Bin 10 overflow */
    vuint32_t B9_OVF:1;                /* Bin 9 overflow */
    vuint32_t B8_OVF:1;                /* Bin 8 overflow */
    vuint32_t B7_OVF:1;                /* Bin 7 overflow */
    vuint32_t B6_OVF:1;                /* Bin 6 overflow */
    vuint32_t B5_OVF:1;                /* Bin 5 overflow */
    vuint32_t B4_OVF:1;                /* Bin 4 overflow */
    vuint32_t B3_OVF:1;                /* Bin 3 overflow */
    vuint32_t B2_OVF:1;                /* Bin 2 overflow */
    vuint32_t B1_OVF:1;                /* Bin 1 overflow */
    vuint32_t B0_OVF:1;                /* Bin 0 overflow */
  } B;
} SPT_HIST_OVF_STATUS0_tag;

typedef union SPT_HIST_OVF_STATUS1_union_tag { /* HIST Overflow Status1 Register */
  vuint32_t R;
  struct {
    vuint32_t B63_OVF:1;               /* Bin 63 overflow */
    vuint32_t B62_OVF:1;               /* Bin 62 overflow */
    vuint32_t B61_OVF:1;               /* Bin 61 overflow */
    vuint32_t B60_OVF:1;               /* Bin 60 overflow */
    vuint32_t B59_OVF:1;               /* Bin 59 overflow */
    vuint32_t B58_OVF:1;               /* Bin 58 overflow */
    vuint32_t B57_OVF:1;               /* Bin 57 overflow */
    vuint32_t B56_OVF:1;               /* Bin 56 overflow */
    vuint32_t B55_OVF:1;               /* Bin 55 overflow */
    vuint32_t B54_OVF:1;               /* Bin 54 overflow */
    vuint32_t B53_OVF:1;               /* Bin 53 overflow */
    vuint32_t B52_OVF:1;               /* Bin 52 overflow */
    vuint32_t B51_OVF:1;               /* Bin 51 overflow */
    vuint32_t B50_OVF:1;               /* Bin 50 overflow */
    vuint32_t B49_OVF:1;               /* Bin 49 overflow */
    vuint32_t B48_OVF:1;               /* Bin 48 overflow */
    vuint32_t B47_OVF:1;               /* Bin 47 overflow */
    vuint32_t B46_OVF:1;               /* Bin 46 overflow */
    vuint32_t B45_OVF:1;               /* Bin 45 overflow */
    vuint32_t B44_OVF:1;               /* Bin 44 overflow */
    vuint32_t B43_OVF:1;               /* Bin 43 overflow */
    vuint32_t B42_OVF:1;               /* Bin 42 overflow */
    vuint32_t B41_OVF:1;               /* Bin 41 overflow */
    vuint32_t B40_OVF:1;               /* Bin 40 overflow */
    vuint32_t B39_OVF:1;               /* Bin 39 overflow */
    vuint32_t B38_OVF:1;               /* Bin 38 overflow */
    vuint32_t B37_OVF:1;               /* Bin 37 overflow */
    vuint32_t B36_OVF:1;               /* Bin 36 overflow */
    vuint32_t B35_OVF:1;               /* Bin 35 overflow */
    vuint32_t B34_OVF:1;               /* Bin 34 overflow */
    vuint32_t B33_OVF:1;               /* Bin 33 overflow */
    vuint32_t B32_OVF:1;               /* Bin 32 overflow */
  } B;
} SPT_HIST_OVF_STATUS1_tag;

typedef union SPT_HIST_OVF_IE_union_tag { /* HIST Overflow Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t OVF_IE:1;                /* HIST overflow interrupt enable */
  } B;
} SPT_HIST_OVF_IE_tag;

typedef union SPT_CS_INTEN0_union_tag { /* Interrupt Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WD_ZERO_INTEN:1;         /* Watchdog reached zero interrupt enable */
    vuint32_t _unused_17:14;
    vuint32_t BKPT3_OCC_INTEN:1;       /* BKPT3 interrupt enable */
    vuint32_t BKPT2_OCC_INTEN:1;       /* BKPT2 interrupt enable */
    vuint32_t BKPT1_OCC_INTEN:1;       /* BKPT1 interrupt enable */
    vuint32_t BKPT0_OCC_INTEN:1;       /* BKPT0 interrupt enable */
    vuint32_t JAM_OVR_INTEN:1;         /* Jamming instruction over interrupt enable */
    vuint32_t STEP_JUMP_OVR_INTEN:1;   /* 'Breakpoint hit in STEP JUMP mode' interrupt enable */
    vuint32_t STEP_ONCE_OVR_INTEN:1;   /* STEP ONCE mode instruction over interrupt enable */
    vuint32_t MD_JAM_INTEN:1;          /* Interrupt enable for instruction jamming mode */
    vuint32_t MD_STEP_JUMP_INTEN:1;    /* Interrupt enable for STEP JUMP mode */
    vuint32_t MD_STEP_ONCE_INTEN:1;    /* Interrupt enable for STEP ONCE mode */
    vuint32_t MD_HALT_INTEN:1;         /* Interrupt enable for HALT mode */
    vuint32_t PS_RUN_INTEN:1;          /* Interrupt enable for RUN state */
    vuint32_t PS_ASYNCSTOP_INTEN:1;    /* Interrupt enable for ASYNCSTOP state */
    vuint32_t PS_STOP_INTEN:1;         /* Interrupt enable for STOP state */
    vuint32_t PS_DEBUG_INTEN:1;        /* Interrupt enable for DEBUG state */
    vuint32_t PS_WAIT_INTEN:1;         /* Interrupt enable for WAIT state */
    vuint32_t PS_START_INTEN:1;        /* Interrupt enable for START state */
  } B;
} SPT_CS_INTEN0_tag;

typedef union SPT_CS_INTEN1_union_tag { /* Interrupt Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t JAM_ILL_JUMP_INTEN:1;    /* Illegal JUMP in jamming mode interrupt enable */
    vuint32_t JAM_ILL_NEXT_INTEN:1;    /* Illegal NEXT in jamming mode interrupt enable */
    vuint32_t JAM_ILL_LOOP_INTEN:1;    /* Illegal LOOP in jamming mode interrupt enable */
    vuint32_t JAM_ILL_SYNC_INTEN:1;    /* Illegal SYNC in jamming mode interrupt enable */
    vuint32_t JAM_ILL_OPCODE_INTEN:1;  /* Illegal Opcode in jamming mode interrupt enable */
    vuint32_t ILL_ADD_INTEN:1;         /* Illegal ADD interrupt enable */
    vuint32_t ILL_GET_INTEN:1;         /* Illegal GET interrupt enable */
    vuint32_t ILL_SET_INTEN:1;         /* Illegal SET interrupt enable */
    vuint32_t ILL_NEXT_INTEN:1;        /* Illegal NEXT interrupt enable */
    vuint32_t ILL_0CNTLOOP_INTEN:1;    /* Illegal loop count error interrupt */
    vuint32_t ILL_LOOP_INTEN:1;        /* Illegal LOOP interrupt enable */
    vuint32_t ILL_OPCODE_INTEN:1;      /* Illegal Opcode interrupt enable */
  } B;
} SPT_CS_INTEN1_tag;

typedef union SPT_CS_EVT1_INTEN_union_tag { /* EVT1 Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVT1_INTEN:8;            /* EVT interrupt enable for CPU core 1 */
  } B;
} SPT_CS_EVT1_INTEN_tag;

typedef union SPT_CS_EVT2_INTEN_union_tag { /* EVT2 Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVT2_INTEN:8;            /* EVT interrupt enable for CPU core 2 */
  } B;
} SPT_CS_EVT2_INTEN_tag;

typedef union SPT_WR_0_15_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR15_ACC_CTRL:1;         /* Work register 15 access control */
    vuint32_t WR15_LCK:1;              /* Work register 15 lock */
    vuint32_t WR14_ACC_CTRL:1;         /* Work register 14 access control */
    vuint32_t WR14_LCK:1;              /* Work register 14 lock */
    vuint32_t WR13_ACC_CTRL:1;         /* Work register 13 access control */
    vuint32_t WR13_LCK:1;              /* Work register 13 lock */
    vuint32_t WR12_ACC_CTRL:1;         /* Work register 12 access control */
    vuint32_t WR12_LCK:1;              /* Work register 12 lock */
    vuint32_t WR11_ACC_CTRL:1;         /* Work register 11 access control */
    vuint32_t WR11_LCK:1;              /* Work register 11 lock */
    vuint32_t WR10_ACC_CTRL:1;         /* Work register 10 access control */
    vuint32_t WR10_LCK:1;              /* Work register 10 lock */
    vuint32_t WR9_ACC_CTRL:1;          /* Work register 9 access control */
    vuint32_t WR9_LCK:1;               /* Work register 9 lock */
    vuint32_t WR8_ACC_CTRL:1;          /* Work register 8 access control */
    vuint32_t WR8_LCK:1;               /* Work register 8 lock */
    vuint32_t WR7_ACC_CTRL:1;          /* Work register 7 access control */
    vuint32_t WR7_LCK:1;               /* Work register 7 lock */
    vuint32_t WR6_ACC_CTRL:1;          /* Work register 6 access control */
    vuint32_t WR6_LCK:1;               /* Work register 6 lock */
    vuint32_t WR5_ACC_CTRL:1;          /* Work register 5 access control */
    vuint32_t WR5_LCK:1;               /* Work register 5 lock */
    vuint32_t WR4_ACC_CTRL:1;          /* Work register 4 access control */
    vuint32_t WR4_LCK:1;               /* Work register 4 lock */
    vuint32_t WR3_ACC_CTRL:1;          /* Work register 3 access control */
    vuint32_t WR3_LCK:1;               /* Work register 3 lock */
    vuint32_t WR2_ACC_CTRL:1;          /* Work register 2 access control */
    vuint32_t WR2_LCK:1;               /* Work register 2 lock */
    vuint32_t WR1_ACC_CTRL:1;          /* Work register 1 access control */
    vuint32_t WR1_LCK:1;               /* Work register 1 lock */
    vuint32_t WR0_ACC_CTRL:1;          /* Work register 0 access control */
    vuint32_t WR0_LCK:1;               /* Work register 0 lock */
  } B;
} SPT_WR_0_15_CTRL_REG_tag;

typedef union SPT_WR_16_31_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR31_ACC_CTRL:1;         /* Work register 31 access control */
    vuint32_t WR31_LCK:1;              /* Work register 31 lock */
    vuint32_t WR30_ACC_CTRL:1;         /* Work register 30 access control */
    vuint32_t WR30_LCK:1;              /* Work register 30 lock */
    vuint32_t WR29_ACC_CTRL:1;         /* Work register 29 access control */
    vuint32_t WR29_LCK:1;              /* Work register 29 lock */
    vuint32_t WR28_ACC_CTRL:1;         /* Work register 28 access control */
    vuint32_t WR28_LCK:1;              /* Work register 28 lock */
    vuint32_t WR27_ACC_CTRL:1;         /* Work register 27 access control */
    vuint32_t WR27_LCK:1;              /* Work register 27 lock */
    vuint32_t WR26_ACC_CTRL:1;         /* Work register 26 access control */
    vuint32_t WR26_LCK:1;              /* Work register 26 lock */
    vuint32_t WR25_ACC_CTRL:1;         /* Work register 25 access control */
    vuint32_t WR25_LCK:1;              /* Work register 25 lock */
    vuint32_t WR24_ACC_CTRL:1;         /* Work register 24 access control */
    vuint32_t WR24_LCK:1;              /* Work register 24 lock */
    vuint32_t WR23_ACC_CTRL:1;         /* Work register 23 access control */
    vuint32_t WR23_LCK:1;              /* Work register 23 lock */
    vuint32_t WR22_ACC_CTRL:1;         /* Work register 22 access control */
    vuint32_t WR22_LCK:1;              /* Work register 22 lock */
    vuint32_t WR21_ACC_CTRL:1;         /* Work register 21 access control */
    vuint32_t WR21_LCK:1;              /* Work register 21 lock */
    vuint32_t WR20_ACC_CTRL:1;         /* Work register 20 access control */
    vuint32_t WR20_LCK:1;              /* Work register 20 lock */
    vuint32_t WR19_ACC_CTRL:1;         /* Work register 19 access control */
    vuint32_t WR19_LCK:1;              /* Work register 19 lock */
    vuint32_t WR18_ACC_CTRL:1;         /* Work register 18 access control */
    vuint32_t WR18_LCK:1;              /* Work register 18 lock */
    vuint32_t WR17_ACC_CTRL:1;         /* Work register 1 access control */
    vuint32_t WR17_LCK:1;              /* Work register 17 lock */
    vuint32_t WR16_ACC_CTRL:1;         /* Work register 15 access control */
    vuint32_t WR16_LCK:1;              /* Work register 15 lock */
  } B;
} SPT_WR_16_31_CTRL_REG_tag;

typedef union SPT_WR_32_47_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR47_ACC_CTRL:1;         /* Work register 47 access control */
    vuint32_t WR47_LCK:1;              /* Work register 31 lock */
    vuint32_t WR46_ACC_CTRL:1;         /* Work register 46 access control */
    vuint32_t WR46_LCK:1;              /* Work register 46 lock */
    vuint32_t WR45_ACC_CTRL:1;         /* Work register 45 access control */
    vuint32_t WR45_LCK:1;              /* Work register 45 lock */
    vuint32_t WR44_ACC_CTRL:1;         /* Work register 44 access control */
    vuint32_t WR44_LCK:1;              /* Work register 44 lock */
    vuint32_t WR43_ACC_CTRL:1;         /* Work register 43 access control */
    vuint32_t WR43_LCK:1;              /* Work register 43 lock */
    vuint32_t WR42_ACC_CTRL:1;         /* Work register 42 access control */
    vuint32_t WR42_LCK:1;              /* Work register 42 lock */
    vuint32_t WR41_ACC_CTRL:1;         /* Work register 41 access control */
    vuint32_t WR41_LCK:1;              /* Work register 41 lock */
    vuint32_t WR40_ACC_CTRL:1;         /* Work register 40 access control */
    vuint32_t WR40_LCK:1;              /* Work register 40 lock */
    vuint32_t WR39_ACC_CTRL:1;         /* Work register 39 access control */
    vuint32_t WR39_LCK:1;              /* Work register 39 lock */
    vuint32_t WR38_ACC_CTRL:1;         /* Work register 38 access control */
    vuint32_t WR38_LCK:1;              /* Work register 38 lock */
    vuint32_t WR37_ACC_CTRL:1;         /* Work register 37 access control */
    vuint32_t WR37_LCK:1;              /* Work register 37 lock */
    vuint32_t WR36_ACC_CTRL:1;         /* Work register 36 access control */
    vuint32_t WR36_LCK:1;              /* Work register 36 lock */
    vuint32_t WR35_ACC_CTRL:1;         /* Work register 35 access control */
    vuint32_t WR35_LCK:1;              /* Work register 35 lock */
    vuint32_t WR34_ACC_CTRL:1;         /* Work register 34 access control */
    vuint32_t WR34_LCK:1;              /* Work register 34 lock */
    vuint32_t WR33_ACC_CTRL:1;         /* Work register 33 access control */
    vuint32_t WR33_LCK:1;              /* Work register 33 lock */
    vuint32_t WR32_ACC_CTRL:1;         /* Work register 32 access control */
    vuint32_t WR32_LCK:1;              /* Work register 32 lock */
  } B;
} SPT_WR_32_47_CTRL_REG_tag;

typedef union SPT_WR_R0_RE_union_tag { /* Work Register R0 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R0:24;              /* Real part of Work Register R0 */
  } B;
} SPT_WR_R0_RE_tag;

typedef union SPT_WR_R0_IM_union_tag { /* Work Register R0 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R0:24;                /* Imaginary part of Work Register R0 */
  } B;
} SPT_WR_R0_IM_tag;

typedef union SPT_WR_R1_RE_union_tag { /* Work Register R1 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R1:24;              /* Real part of Work Register R1 */
  } B;
} SPT_WR_R1_RE_tag;

typedef union SPT_WR_R1_IM_union_tag { /* Work Register R1 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R1:24;                /* Imaginary part of Work Register R1 */
  } B;
} SPT_WR_R1_IM_tag;

typedef union SPT_WR_R2_RE_union_tag { /* Work Register R0 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R2:24;              /* Real part of Work Register R2 */
  } B;
} SPT_WR_R2_RE_tag;

typedef union SPT_WR_R2_IM_union_tag { /* Work Register R2 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R2:24;                /* Imaginary part of Work Register R2 */
  } B;
} SPT_WR_R2_IM_tag;

typedef union SPT_WR_R3_RE_union_tag { /* Work Register R3 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R3:24;              /* Real part of Work Register R3 */
  } B;
} SPT_WR_R3_RE_tag;

typedef union SPT_WR_R3_IM_union_tag { /* Work Register R3 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R3:24;                /* Imaginary part of Work Register R3 */
  } B;
} SPT_WR_R3_IM_tag;

typedef union SPT_WR_R4_RE_union_tag { /* Work Register R4 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R4:24;              /* Real part of Work Register R4 */
  } B;
} SPT_WR_R4_RE_tag;

typedef union SPT_WR_R4_IM_union_tag { /* Work Register R4 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R4:24;                /* Imaginary part of Work Register R4 */
  } B;
} SPT_WR_R4_IM_tag;

typedef union SPT_WR_R5_RE_union_tag { /* Work Register R5 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R5:24;              /* Real part of Work Register R5 */
  } B;
} SPT_WR_R5_RE_tag;

typedef union SPT_WR_R5_IM_union_tag { /* Work Register R5 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R5:24;                /* Imaginary part of Work Register R5 */
  } B;
} SPT_WR_R5_IM_tag;

typedef union SPT_WR_R6_RE_union_tag { /* Work Register R6 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R6:24;              /* Real part of Work Register R6 */
  } B;
} SPT_WR_R6_RE_tag;

typedef union SPT_WR_R6_IM_union_tag { /* Work Register R6 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R6:24;                /* Imaginary part of Work Register R6 */
  } B;
} SPT_WR_R6_IM_tag;

typedef union SPT_WR_R7_RE_union_tag { /* Work Register R7 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R7:24;              /* Real part of Work Register R7 */
  } B;
} SPT_WR_R7_RE_tag;

typedef union SPT_WR_R7_IM_union_tag { /* Work Register R7 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R7:24;                /* Imaginary part of Work Register R7 */
  } B;
} SPT_WR_R7_IM_tag;

typedef union SPT_WR_R8_RE_union_tag { /* Work Register R8 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R8:24;              /* Real part of Work Register R8 */
  } B;
} SPT_WR_R8_RE_tag;

typedef union SPT_WR_R8_IM_union_tag { /* Work Register R8 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R8:24;                /* Imaginary part of Work Register R8 */
  } B;
} SPT_WR_R8_IM_tag;

typedef union SPT_WR_R9_RE_union_tag { /* Work Register R9 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R9:24;              /* Real part of Work Register R9 */
  } B;
} SPT_WR_R9_RE_tag;

typedef union SPT_WR_R9_IM_union_tag { /* Work Register R9 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R9:24;                /* Imaginary part of Work Register R9 */
  } B;
} SPT_WR_R9_IM_tag;

typedef union SPT_WR_R10_RE_union_tag { /* Work Register R10 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R10:24;             /* Real part of Work Register R10 */
  } B;
} SPT_WR_R10_RE_tag;

typedef union SPT_WR_R10_IM_union_tag { /* Work Register R10 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R10:24;               /* Imaginary part of Work Register R10 */
  } B;
} SPT_WR_R10_IM_tag;

typedef union SPT_WR_R11_RE_union_tag { /* Work Register R11 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R11:24;             /* Real part of Work Register R11 */
  } B;
} SPT_WR_R11_RE_tag;

typedef union SPT_WR_R11_IM_union_tag { /* Work Register R11 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R11:24;               /* Imaginary part of Work Register R11 */
  } B;
} SPT_WR_R11_IM_tag;

typedef union SPT_WR_R12_RE_union_tag { /* Work Register R12 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R12:24;             /* Real part of Work Register R12 */
  } B;
} SPT_WR_R12_RE_tag;

typedef union SPT_WR_R12_IM_union_tag { /* Work Register R12 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R12:24;               /* Imaginary part of Work Register R12 */
  } B;
} SPT_WR_R12_IM_tag;

typedef union SPT_WR_R13_RE_union_tag { /* Work Register R13 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R13:24;             /* Real part of Work Register R13 */
  } B;
} SPT_WR_R13_RE_tag;

typedef union SPT_WR_R13_IM_union_tag { /* Work Register R13 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R13:24;               /* Imaginary part of Work Register R13 */
  } B;
} SPT_WR_R13_IM_tag;

typedef union SPT_WR_R14_RE_union_tag { /* Work Register R14 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R14:24;             /* Real part of Work Register R14 */
  } B;
} SPT_WR_R14_RE_tag;

typedef union SPT_WR_R14_IM_union_tag { /* Work Register R14 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R14:24;               /* Imaginary part of Work Register R14 */
  } B;
} SPT_WR_R14_IM_tag;

typedef union SPT_WR_R15_RE_union_tag { /* Work Register R15 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R15:24;             /* Real part of Work Register R15 */
  } B;
} SPT_WR_R15_RE_tag;

typedef union SPT_WR_R15_IM_union_tag { /* Work Register R15 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R15:24;               /* Imaginary part of Work Register R15 */
  } B;
} SPT_WR_R15_IM_tag;

typedef union SPT_WR_R16_RE_union_tag { /* Work Register R16 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R16:24;             /* Real part of Work Register R16 */
  } B;
} SPT_WR_R16_RE_tag;

typedef union SPT_WR_R16_IM_union_tag { /* Work Register R16 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R16:24;               /* Imaginary part of Work Register R16 */
  } B;
} SPT_WR_R16_IM_tag;

typedef union SPT_WR_R17_RE_union_tag { /* Work Register R17 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R17:24;             /* Real part of Work Register R17 */
  } B;
} SPT_WR_R17_RE_tag;

typedef union SPT_WR_R17_IM_union_tag { /* Work Register R17 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R17:24;               /* Imaginary part of Work Register R17 */
  } B;
} SPT_WR_R17_IM_tag;

typedef union SPT_WR_R18_RE_union_tag { /* Work Register R18 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R18:24;             /* Real part of Work Register R18 */
  } B;
} SPT_WR_R18_RE_tag;

typedef union SPT_WR_R18_IM_union_tag { /* Work Register R18 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R18:24;               /* Imaginary part of Work Register R18 */
  } B;
} SPT_WR_R18_IM_tag;

typedef union SPT_WR_R19_RE_union_tag { /* Work Register R19 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R19:24;             /* Real part of Work Register R19 */
  } B;
} SPT_WR_R19_RE_tag;

typedef union SPT_WR_R19_IM_union_tag { /* Work Register R19 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R19:24;               /* Imaginary part of Work Register R19 */
  } B;
} SPT_WR_R19_IM_tag;

typedef union SPT_WR_R20_RE_union_tag { /* Work Register R20 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R20:24;             /* Real part of Work Register R20 */
  } B;
} SPT_WR_R20_RE_tag;

typedef union SPT_WR_R20_IM_union_tag { /* Work Register R20 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R20:24;               /* Imaginary part of Work Register R20 */
  } B;
} SPT_WR_R20_IM_tag;

typedef union SPT_WR_R21_RE_union_tag { /* Work Register R21 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R21:24;             /* Real part of Work Register R21 */
  } B;
} SPT_WR_R21_RE_tag;

typedef union SPT_WR_R21_IM_union_tag { /* Work Register R21 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R21:24;               /* Imaginary part of Work Register R21 */
  } B;
} SPT_WR_R21_IM_tag;

typedef union SPT_WR_R22_RE_union_tag { /* Work Register R22 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R22:24;             /* Real part of Work Register R22 */
  } B;
} SPT_WR_R22_RE_tag;

typedef union SPT_WR_R22_IM_union_tag { /* Work Register R22 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R22:24;               /* Imaginary part of Work Register R22 */
  } B;
} SPT_WR_R22_IM_tag;

typedef union SPT_WR_R23_RE_union_tag { /* Work Register R23 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R23:24;             /* Real part of Work Register R23 */
  } B;
} SPT_WR_R23_RE_tag;

typedef union SPT_WR_R23_IM_union_tag { /* Work Register R23 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R23:24;               /* Imaginary part of Work Register R23 */
  } B;
} SPT_WR_R23_IM_tag;

typedef union SPT_WR_R24_RE_union_tag { /* Work Register R24 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R24:24;             /* Real part of Work Register R24 */
  } B;
} SPT_WR_R24_RE_tag;

typedef union SPT_WR_R24_IM_union_tag { /* Work Register R24 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R24:24;               /* Imaginary part of Work Register R24 */
  } B;
} SPT_WR_R24_IM_tag;

typedef union SPT_WR_R25_RE_union_tag { /* Work Register R25 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R25:24;             /* Real part of Work Register R25 */
  } B;
} SPT_WR_R25_RE_tag;

typedef union SPT_WR_R25_IM_union_tag { /* Work Register R25 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R25:24;               /* Imaginary part of Work Register R25 */
  } B;
} SPT_WR_R25_IM_tag;

typedef union SPT_WR_R26_RE_union_tag { /* Work Register R26 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R26:24;             /* Real part of Work Register R26 */
  } B;
} SPT_WR_R26_RE_tag;

typedef union SPT_WR_R26_IM_union_tag { /* Work Register R26 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R26:24;               /* Imaginary part of Work Register R26 */
  } B;
} SPT_WR_R26_IM_tag;

typedef union SPT_WR_R27_RE_union_tag { /* Work Register R27 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R27:24;             /* Real part of Work Register R27 */
  } B;
} SPT_WR_R27_RE_tag;

typedef union SPT_WR_R27_IM_union_tag { /* Work Register R27 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R27:24;               /* Imaginary part of Work Register R27 */
  } B;
} SPT_WR_R27_IM_tag;

typedef union SPT_WR_R28_RE_union_tag { /* Work Register R28 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R28:24;             /* Real part of Work Register R28 */
  } B;
} SPT_WR_R28_RE_tag;

typedef union SPT_WR_R28_IM_union_tag { /* Work Register R28 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R28:24;               /* Imaginary part of Work Register R28 */
  } B;
} SPT_WR_R28_IM_tag;

typedef union SPT_WR_R29_RE_union_tag { /* Work Register R29 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R29:24;             /* Real part of Work Register R29 */
  } B;
} SPT_WR_R29_RE_tag;

typedef union SPT_WR_R29_IM_union_tag { /* Work Register R29 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R29:24;               /* Imaginary part of Work Register R29 */
  } B;
} SPT_WR_R29_IM_tag;

typedef union SPT_WR_R30_RE_union_tag { /* Work Register R30 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R30:24;             /* Real part of Work Register R30 */
  } B;
} SPT_WR_R30_RE_tag;

typedef union SPT_WR_R30_IM_union_tag { /* Work Register R30 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R30:24;               /* Imaginary part of Work Register R30 */
  } B;
} SPT_WR_R30_IM_tag;

typedef union SPT_WR_R31_RE_union_tag { /* Work Register R31 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R31:24;             /* Real part of Work Register R31 */
  } B;
} SPT_WR_R31_RE_tag;

typedef union SPT_WR_R31_IM_union_tag { /* Work Register R31 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R31:24;               /* Imaginary part of Work Register R31 */
  } B;
} SPT_WR_R31_IM_tag;

typedef union SPT_WR_R32_RE_union_tag { /* Work Register R32 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R32:24;             /* Real part of Work Register R32 */
  } B;
} SPT_WR_R32_RE_tag;

typedef union SPT_WR_R32_IM_union_tag { /* Work Register R32 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R32:24;               /* Imaginary part of Work Register R32 */
  } B;
} SPT_WR_R32_IM_tag;

typedef union SPT_WR_R33_RE_union_tag { /* Work Register R33 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R33:24;             /* Real part of Work Register R33 */
  } B;
} SPT_WR_R33_RE_tag;

typedef union SPT_WR_R33_IM_union_tag { /* Work Register R33 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R33:24;               /* Imaginary part of Work Register R33 */
  } B;
} SPT_WR_R33_IM_tag;

typedef union SPT_WR_R34_RE_union_tag { /* Work Register R34 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R34:24;             /* Real part of Work Register R34 */
  } B;
} SPT_WR_R34_RE_tag;

typedef union SPT_WR_R34_IM_union_tag { /* Work Register R34 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R34:24;               /* Imaginary part of Work Register R34 */
  } B;
} SPT_WR_R34_IM_tag;

typedef union SPT_WR_R35_RE_union_tag { /* Work Register R35 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R35:24;             /* Real part of Work Register R35 */
  } B;
} SPT_WR_R35_RE_tag;

typedef union SPT_WR_R35_IM_union_tag { /* Work Register R35 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R35:24;               /* Imaginary part of Work Register R35 */
  } B;
} SPT_WR_R35_IM_tag;

typedef union SPT_WR_R36_RE_union_tag { /* Work Register R36 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R36:24;             /* Real part of Work Register R36 */
  } B;
} SPT_WR_R36_RE_tag;

typedef union SPT_WR_R36_IM_union_tag { /* Work Register R36 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R36:24;               /* Imaginary part of Work Register R36 */
  } B;
} SPT_WR_R36_IM_tag;

typedef union SPT_WR_R37_RE_union_tag { /* Work Register R37 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R37:24;             /* Real part of Work Register R37 */
  } B;
} SPT_WR_R37_RE_tag;

typedef union SPT_WR_R37_IM_union_tag { /* Work Register R37 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R37:24;               /* Imaginary part of Work Register R37 */
  } B;
} SPT_WR_R37_IM_tag;

typedef union SPT_WR_R38_RE_union_tag { /* Work Register R38 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R38:24;             /* Real part of Work Register R38 */
  } B;
} SPT_WR_R38_RE_tag;

typedef union SPT_WR_R38_IM_union_tag { /* Work Register R38 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R38:24;               /* Imaginary part of Work Register R38 */
  } B;
} SPT_WR_R38_IM_tag;

typedef union SPT_WR_R39_RE_union_tag { /* Work Register R39 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R39:24;             /* Real part of Work Register R39 */
  } B;
} SPT_WR_R39_RE_tag;

typedef union SPT_WR_R39_IM_union_tag { /* Work Register R39 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R39:24;               /* Imaginary part of Work Register R39 */
  } B;
} SPT_WR_R39_IM_tag;

typedef union SPT_WR_R40_RE_union_tag { /* Work Register R40 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R40:24;             /* Real part of Work Register R40 */
  } B;
} SPT_WR_R40_RE_tag;

typedef union SPT_WR_R40_IM_union_tag { /* Work Register R40 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R40:24;               /* Imaginary part of Work Register R40 */
  } B;
} SPT_WR_R40_IM_tag;

typedef union SPT_WR_R41_RE_union_tag { /* Work Register R41 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R41:24;             /* Real part of Work Register R41 */
  } B;
} SPT_WR_R41_RE_tag;

typedef union SPT_WR_R41_IM_union_tag { /* Work Register R41 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R41:24;               /* Imaginary part of Work Register R41 */
  } B;
} SPT_WR_R41_IM_tag;

typedef union SPT_WR_R42_RE_union_tag { /* Work Register R42 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R42:24;             /* Real part of Work Register R42 */
  } B;
} SPT_WR_R42_RE_tag;

typedef union SPT_WR_R42_IM_union_tag { /* Work Register R42 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R42:24;               /* Imaginary part of Work Register R42 */
  } B;
} SPT_WR_R42_IM_tag;

typedef union SPT_WR_R43_RE_union_tag { /* Work Register R43 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R43:24;             /* Real part of Work Register R43 */
  } B;
} SPT_WR_R43_RE_tag;

typedef union SPT_WR_R43_IM_union_tag { /* Work Register R43 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R43:24;               /* Imaginary part of Work Register R43 */
  } B;
} SPT_WR_R43_IM_tag;

typedef union SPT_WR_R44_RE_union_tag { /* Work Register R44 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R44:24;             /* Real part of Work Register R44 */
  } B;
} SPT_WR_R44_RE_tag;

typedef union SPT_WR_R44_IM_union_tag { /* Work Register R44 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R44:24;               /* Imaginary part of Work Register R44 */
  } B;
} SPT_WR_R44_IM_tag;

typedef union SPT_WR_R45_RE_union_tag { /* Work Register R45 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R45:24;             /* Real part of Work Register R45 */
  } B;
} SPT_WR_R45_RE_tag;

typedef union SPT_WR_R45_IM_union_tag { /* Work Register R45 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R45:24;               /* Imaginary part of Work Register R45 */
  } B;
} SPT_WR_R45_IM_tag;

typedef union SPT_WR_R46_RE_union_tag { /* Work Register R46 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R46:24;             /* Real part of Work Register R46 */
  } B;
} SPT_WR_R46_RE_tag;

typedef union SPT_WR_R46_IM_union_tag { /* Work Register R46 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R46:24;               /* Imaginary part of Work Register R46 */
  } B;
} SPT_WR_R46_IM_tag;

typedef union SPT_WR_R47_RE_union_tag { /* Work Register R47 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R47:24;             /* Real part of Work Register R47 */
  } B;
} SPT_WR_R47_RE_tag;

typedef union SPT_WR_R47_IM_union_tag { /* Work Register R47 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R47:24;               /* Imaginary part of Work Register R47 */
  } B;
} SPT_WR_R47_IM_tag;

struct SPT_tag {
  SPT_GBL_CTRL_tag GBL_CTRL;           /* SPT Global Control Register */
  SPT_ACQ_GBL_CTRL_0_tag ACQ_GBL_CTRL_0; /* Acquisition Global Control Register */
  SPT_ACQ_GBL_CTRL_1_tag ACQ_GBL_CTRL_1; /* Acquisition Global Control Register 1 */
  uint8_t SPT_reserved0[4];
  SPT_ACQ_CTRL0_tag ACQ_CTRL0;         /* Acquisition Control 0 Register */
  SPT_ACQ_CTRL1_tag ACQ_CTRL1;         /* Acquisition Control 1 Register */
  SPT_ACQ_CTRL2_tag ACQ_CTRL2;         /* Acquisition Control 2 Register */
  SPT_ACQ_CTRL3_tag ACQ_CTRL3;         /* Acquisition Control 3 Register */
  SPT_SDMA_CTRL0_tag SDMA_CTRL0;       /* SDMA Control 0 Register */
  SPT_SDMA_CTRL1_tag SDMA_CTRL1;       /* SDMA Control 1 Register */
  uint8_t SPT_reserved1[28];
  SPT_ACQ_STATUS_A0_tag ACQ_STATUS_A0; /* Acquisition Status Register A0 */
  SPT_ACQ_STATUS_A1_tag ACQ_STATUS_A1; /* Acquisition Status Register A1 */
  SPT_ACQ_STATUS_A2_tag ACQ_STATUS_A2; /* Acquisition Status Register A2 */
  SPT_ACQ_STATUS_B0_tag ACQ_STATUS_B0; /* Acquisition Status Register B0 */
  SPT_ACQ_STATUS_B1_tag ACQ_STATUS_B1; /* Acquisition Status Register B1 */
  SPT_ACQ_STATUS_B2_tag ACQ_STATUS_B2; /* Acquisition Status Register B2 */
  SPT_ACQ_STATUS_C0_tag ACQ_STATUS_C0; /* Acquisition Status Register C0 */
  SPT_ACQ_STATUS_C1_tag ACQ_STATUS_C1; /* Acquisition Status Register C1 */
  SPT_ACQ_STATUS_C2_tag ACQ_STATUS_C2; /* Acquisition Status Register C2 */
  SPT_ACQ_STATUS_D0_tag ACQ_STATUS_D0; /* Acquisition Status Register D0 */
  SPT_ACQ_STATUS_D1_tag ACQ_STATUS_D1; /* Acquisition Status Register D1 */
  SPT_ACQ_STATUS_D2_tag ACQ_STATUS_D2; /* Acquisition Status Register D2 */
  SPT_ACQ_STATUS_E0_tag ACQ_STATUS_E0; /* Acquisition Status Register E0 */
  SPT_ACQ_STATUS_E1_tag ACQ_STATUS_E1; /* Acquisition Status Register E1 */
  SPT_ACQ_STATUS_E2_tag ACQ_STATUS_E2; /* Acquisition Status Register E2 */
  SPT_ACQ_STATUS_F0_tag ACQ_STATUS_F0; /* Acquisition Status Register F0 */
  SPT_ACQ_STATUS_F1_tag ACQ_STATUS_F1; /* Acquisition Status Register F1 */
  SPT_ACQ_STATUS_F2_tag ACQ_STATUS_F2; /* Acquisition Status Register F2 */
  SPT_ACQ_STATUS_G0_tag ACQ_STATUS_G0; /* Acquisition Status Register G0 */
  SPT_ACQ_STATUS_G1_tag ACQ_STATUS_G1; /* Acquisition Status Register G1 */
  SPT_ACQ_STATUS_G2_tag ACQ_STATUS_G2; /* Acquisition Status Register G2 */
  SPT_ACQ_STATUS_H0_tag ACQ_STATUS_H0; /* Acquisition Status Register H0 */
  SPT_ACQ_STATUS_H1_tag ACQ_STATUS_H1; /* Acquisition Status Register H1 */
  SPT_ACQ_STATUS_H2_tag ACQ_STATUS_H2; /* Acquisition Status Register H2 */
  SPT_ACQ_CSI_CTRL_tag ACQ_CSI_CTRL;   /* Acquisition MIPICSI2 control register */
  SPT_SDMA_BYP_CTRL0_tag SDMA_BYP_CTRL0; /* Bypass SDMA Control 0 */
  SPT_SDMA_BYP_CTRL1_tag SDMA_BYP_CTRL1; /* Bypass SDMA Control 1 Register */
  SPT_ACQ_BYP_CTRL_tag ACQ_BYP_CTRL;   /* Acquisition Bypass Control Register */
  uint8_t SPT_reserved2[12];
  SPT_CS_PG_ST_ADDR_tag CS_PG_ST_ADDR; /* Program Start Addr Register */
  SPT_CS_MODE_CTRL_tag CS_MODE_CTRL;   /* Mode Control Register */
  SPT_CS_WD_COUNT_tag CS_WD_COUNT;     /* Watchdog Counter Register */
  SPT_CS_BKPT0_ADDR_tag CS_BKPT0_ADDR; /* Breakpoint0 Addr Register */
  SPT_CS_BKPT1_ADDR_tag CS_BKPT1_ADDR; /* Breakpoint1 Addr Register */
  SPT_CS_BKPT2_ADDR_tag CS_BKPT2_ADDR; /* Breakpoint2 Addr Register */
  SPT_CS_BKPT3_ADDR_tag CS_BKPT3_ADDR; /* Breakpoint3 Addr Register */
  SPT_CS_JAM_INST0_tag CS_JAM_INST0;   /* Jamming Instruction0 Register */
  SPT_CS_JAM_INST1_tag CS_JAM_INST1;   /* Jamming Instruction1 Register */
  SPT_CS_JAM_INST2_tag CS_JAM_INST2;   /* Jamming Instruction2 Register */
  SPT_CS_JAM_INST3_tag CS_JAM_INST3;   /* Jamming Instruction3 Register */
  SPT_CS_CURR_INST_ADDR_tag CS_CURR_INST_ADDR; /* Current Instruction Addr Register */
  SPT_CS_CURR_INST0_tag CS_CURR_INST0; /* Current Instruction0 Register */
  SPT_CS_CURR_INST1_tag CS_CURR_INST1; /* Current Instruction1 Register */
  SPT_CS_CURR_INST2_tag CS_CURR_INST2; /* Current Instruction2 Register */
  SPT_CS_CURR_INST3_tag CS_CURR_INST3; /* Current Instruction3 Register */
  SPT_CS_LOOPCNTR01_tag CS_LOOPCNTR01; /* Loop Counter 0 and 1 Register */
  SPT_CS_LOOPCNTR23_tag CS_LOOPCNTR23; /* Loop Counter 2 and 3 Register */
  SPT_CS_ERR_INST_ADDR_tag CS_ERR_INST_ADDR; /* Error Instruction Addr Register */
  SPT_CS_ERR_INST0_tag CS_ERR_INST0;   /* Error Instruction 0 Register */
  SPT_CS_ERR_INST1_tag CS_ERR_INST1;   /* Error Instruction 1 Register */
  SPT_CS_ERR_INST2_tag CS_ERR_INST2;   /* Error Instruction 2 Register */
  SPT_CS_ERR_INST3_tag CS_ERR_INST3;   /* Error Instruction 3 Register */
  SPT_CS_STATUS0_tag CS_STATUS0;       /* General Status 0 Register */
  SPT_CS_STATUS1_tag CS_STATUS1;       /* General Status 1 Register */
  SPT_CS_STATUS2_tag CS_STATUS2;       /* General Status2 Register */
  SPT_CS_STATUS3_tag CS_STATUS3;       /* General Status 3 Register */
  SPT_CS_EVTREG1_tag CS_EVTREG1;       /* EVT1 Status Register */
  SPT_CS_EVTREG2_tag CS_EVTREG2;       /* EVT2 Status Register */
  SPT_CS_SW_EVTREG_tag CS_SW_EVTREG;   /* SW Event Trigger Register */
  SPT_CORE1_VER_EVT_tag CORE1_VER_EVT; /* Core 1 Version Register Events */
  SPT_CORE2_VER_EVT_tag CORE2_VER_EVT; /* Core 2 Version Register Events */
  SPT_EVENT_RST_CTRL_tag EVENT_RST_CTRL; /* SPT Event Reset Control Register */
  uint8_t SPT_reserved3[60];
  SPT_PDMA_LFSR_LOAD_VAL_HIGH_tag PDMA_LFSR_LOAD_VAL_HIGH; /* LFSR Load High Value */
  SPT_PDMA_LFSR_LOAD_VAL_LOW_tag PDMA_LFSR_LOAD_VAL_LOW; /* LFSR Load Low Value */
  SPT_PDMA_CONTROL_tag PDMA_CONTROL;   /* PDMA Control Register */
  uint8_t SPT_reserved4[52];
  SPT_PDMA_TRANSFER_COUNT_STATUS_tag PDMA_TRANSFER_COUNT_STATUS; /* PDMA Transfer Count Status */
  SPT_PDMA_FMTB_EXP_ADDR_STATUS_tag PDMA_FMTB_EXP_ADDR_STATUS; /* PDMA formatB Exponent Address status Register */
  uint8_t SPT_reserved5[52];
  SPT_MEM_ERR_INJECT_CTRL_tag MEM_ERR_INJECT_CTRL; /* Memory Error Injection Register */
  SPT_MEM_ERR_STATUS_tag MEM_ERR_STATUS; /* Memory Error Status Register */
  SPT_MEM_ERR_INT_EN_tag MEM_ERR_INT_EN; /* Memory Interrupt Enable register */
  SPT_DMA_ERR_STATUS_tag DMA_ERR_STATUS; /* DMA Error Status Register */
  SPT_DMA_ERR_INT_EN_tag DMA_ERR_INT_EN; /* Interrupt Enable for DMA_ERROR_STATUS */
  SPT_GBL_STATUS_tag GBL_STATUS;       /* Global Status Register */
  SPT_GBL_STATUS_IE_tag GBL_STATUS_IE; /* Global Status Interrupt Enable Register */
  SPT_HW_ACC_ERR_STATUS_tag HW_ACC_ERR_STATUS; /* Hardware Accelerator Error Status Register */
  SPT_HW_ACC_ERR_IE_tag HW_ACC_ERR_IE; /* Hardware Accelerator Error Interrupt Enable Register */
  SPT_HIST_OVF_STATUS0_tag HIST_OVF_STATUS0; /* HIST Overflow Status0 Register */
  SPT_HIST_OVF_STATUS1_tag HIST_OVF_STATUS1; /* HIST Overflow Status1 Register */
  SPT_HIST_OVF_IE_tag HIST_OVF_IE;     /* HIST Overflow Interrupt Enable Register */
  SPT_CS_INTEN0_tag CS_INTEN0;         /* Interrupt Enable Register 0 */
  SPT_CS_INTEN1_tag CS_INTEN1;         /* Interrupt Enable Register 1 */
  SPT_CS_EVT1_INTEN_tag CS_EVT1_INTEN; /* EVT1 Interrupt Enable Register */
  SPT_CS_EVT2_INTEN_tag CS_EVT2_INTEN; /* EVT2 Interrupt Enable Register */
  uint8_t SPT_reserved6[4];
  SPT_WR_0_15_CTRL_REG_tag WR_0_15_CTRL_REG;
  SPT_WR_16_31_CTRL_REG_tag WR_16_31_CTRL_REG;
  SPT_WR_32_47_CTRL_REG_tag WR_32_47_CTRL_REG;
  uint8_t SPT_reserved7[4];
  SPT_WR_R0_RE_tag WR_R0_RE;           /* Work Register R0 Real */
  SPT_WR_R0_IM_tag WR_R0_IM;           /* Work Register R0 Imaginary */
  SPT_WR_R1_RE_tag WR_R1_RE;           /* Work Register R1 Real */
  SPT_WR_R1_IM_tag WR_R1_IM;           /* Work Register R1 Imaginary */
  SPT_WR_R2_RE_tag WR_R2_RE;           /* Work Register R0 Real */
  SPT_WR_R2_IM_tag WR_R2_IM;           /* Work Register R2 Imaginary */
  SPT_WR_R3_RE_tag WR_R3_RE;           /* Work Register R3 Real */
  SPT_WR_R3_IM_tag WR_R3_IM;           /* Work Register R3 Imaginary */
  SPT_WR_R4_RE_tag WR_R4_RE;           /* Work Register R4 Real */
  SPT_WR_R4_IM_tag WR_R4_IM;           /* Work Register R4 Imaginary */
  SPT_WR_R5_RE_tag WR_R5_RE;           /* Work Register R5 Real */
  SPT_WR_R5_IM_tag WR_R5_IM;           /* Work Register R5 Imaginary */
  SPT_WR_R6_RE_tag WR_R6_RE;           /* Work Register R6 Real */
  SPT_WR_R6_IM_tag WR_R6_IM;           /* Work Register R6 Imaginary */
  SPT_WR_R7_RE_tag WR_R7_RE;           /* Work Register R7 Real */
  SPT_WR_R7_IM_tag WR_R7_IM;           /* Work Register R7 Imaginary */
  SPT_WR_R8_RE_tag WR_R8_RE;           /* Work Register R8 Real */
  SPT_WR_R8_IM_tag WR_R8_IM;           /* Work Register R8 Imaginary */
  SPT_WR_R9_RE_tag WR_R9_RE;           /* Work Register R9 Real */
  SPT_WR_R9_IM_tag WR_R9_IM;           /* Work Register R9 Imaginary */
  SPT_WR_R10_RE_tag WR_R10_RE;         /* Work Register R10 Real */
  SPT_WR_R10_IM_tag WR_R10_IM;         /* Work Register R10 Imaginary */
  SPT_WR_R11_RE_tag WR_R11_RE;         /* Work Register R11 Real */
  SPT_WR_R11_IM_tag WR_R11_IM;         /* Work Register R11 Imaginary */
  SPT_WR_R12_RE_tag WR_R12_RE;         /* Work Register R12 Real */
  SPT_WR_R12_IM_tag WR_R12_IM;         /* Work Register R12 Imaginary */
  SPT_WR_R13_RE_tag WR_R13_RE;         /* Work Register R13 Real */
  SPT_WR_R13_IM_tag WR_R13_IM;         /* Work Register R13 Imaginary */
  SPT_WR_R14_RE_tag WR_R14_RE;         /* Work Register R14 Real */
  SPT_WR_R14_IM_tag WR_R14_IM;         /* Work Register R14 Imaginary */
  SPT_WR_R15_RE_tag WR_R15_RE;         /* Work Register R15 Real */
  SPT_WR_R15_IM_tag WR_R15_IM;         /* Work Register R15 Imaginary */
  SPT_WR_R16_RE_tag WR_R16_RE;         /* Work Register R16 Real */
  SPT_WR_R16_IM_tag WR_R16_IM;         /* Work Register R16 Imaginary */
  SPT_WR_R17_RE_tag WR_R17_RE;         /* Work Register R17 Real */
  SPT_WR_R17_IM_tag WR_R17_IM;         /* Work Register R17 Imaginary */
  SPT_WR_R18_RE_tag WR_R18_RE;         /* Work Register R18 Real */
  SPT_WR_R18_IM_tag WR_R18_IM;         /* Work Register R18 Imaginary */
  SPT_WR_R19_RE_tag WR_R19_RE;         /* Work Register R19 Real */
  SPT_WR_R19_IM_tag WR_R19_IM;         /* Work Register R19 Imaginary */
  SPT_WR_R20_RE_tag WR_R20_RE;         /* Work Register R20 Real */
  SPT_WR_R20_IM_tag WR_R20_IM;         /* Work Register R20 Imaginary */
  SPT_WR_R21_RE_tag WR_R21_RE;         /* Work Register R21 Real */
  SPT_WR_R21_IM_tag WR_R21_IM;         /* Work Register R21 Imaginary */
  SPT_WR_R22_RE_tag WR_R22_RE;         /* Work Register R22 Real */
  SPT_WR_R22_IM_tag WR_R22_IM;         /* Work Register R22 Imaginary */
  SPT_WR_R23_RE_tag WR_R23_RE;         /* Work Register R23 Real */
  SPT_WR_R23_IM_tag WR_R23_IM;         /* Work Register R23 Imaginary */
  SPT_WR_R24_RE_tag WR_R24_RE;         /* Work Register R24 Real */
  SPT_WR_R24_IM_tag WR_R24_IM;         /* Work Register R24 Imaginary */
  SPT_WR_R25_RE_tag WR_R25_RE;         /* Work Register R25 Real */
  SPT_WR_R25_IM_tag WR_R25_IM;         /* Work Register R25 Imaginary */
  SPT_WR_R26_RE_tag WR_R26_RE;         /* Work Register R26 Real */
  SPT_WR_R26_IM_tag WR_R26_IM;         /* Work Register R26 Imaginary */
  SPT_WR_R27_RE_tag WR_R27_RE;         /* Work Register R27 Real */
  SPT_WR_R27_IM_tag WR_R27_IM;         /* Work Register R27 Imaginary */
  SPT_WR_R28_RE_tag WR_R28_RE;         /* Work Register R28 Real */
  SPT_WR_R28_IM_tag WR_R28_IM;         /* Work Register R28 Imaginary */
  SPT_WR_R29_RE_tag WR_R29_RE;         /* Work Register R29 Real */
  SPT_WR_R29_IM_tag WR_R29_IM;         /* Work Register R29 Imaginary */
  SPT_WR_R30_RE_tag WR_R30_RE;         /* Work Register R30 Real */
  SPT_WR_R30_IM_tag WR_R30_IM;         /* Work Register R30 Imaginary */
  SPT_WR_R31_RE_tag WR_R31_RE;         /* Work Register R31 Real */
  SPT_WR_R31_IM_tag WR_R31_IM;         /* Work Register R31 Imaginary */
  SPT_WR_R32_RE_tag WR_R32_RE;         /* Work Register R32 Real */
  SPT_WR_R32_IM_tag WR_R32_IM;         /* Work Register R32 Imaginary */
  SPT_WR_R33_RE_tag WR_R33_RE;         /* Work Register R33 Real */
  SPT_WR_R33_IM_tag WR_R33_IM;         /* Work Register R33 Imaginary */
  SPT_WR_R34_RE_tag WR_R34_RE;         /* Work Register R34 Real */
  SPT_WR_R34_IM_tag WR_R34_IM;         /* Work Register R34 Imaginary */
  SPT_WR_R35_RE_tag WR_R35_RE;         /* Work Register R35 Real */
  SPT_WR_R35_IM_tag WR_R35_IM;         /* Work Register R35 Imaginary */
  SPT_WR_R36_RE_tag WR_R36_RE;         /* Work Register R36 Real */
  SPT_WR_R36_IM_tag WR_R36_IM;         /* Work Register R36 Imaginary */
  SPT_WR_R37_RE_tag WR_R37_RE;         /* Work Register R37 Real */
  SPT_WR_R37_IM_tag WR_R37_IM;         /* Work Register R37 Imaginary */
  SPT_WR_R38_RE_tag WR_R38_RE;         /* Work Register R38 Real */
  SPT_WR_R38_IM_tag WR_R38_IM;         /* Work Register R38 Imaginary */
  SPT_WR_R39_RE_tag WR_R39_RE;         /* Work Register R39 Real */
  SPT_WR_R39_IM_tag WR_R39_IM;         /* Work Register R39 Imaginary */
  SPT_WR_R40_RE_tag WR_R40_RE;         /* Work Register R40 Real */
  SPT_WR_R40_IM_tag WR_R40_IM;         /* Work Register R40 Imaginary */
  SPT_WR_R41_RE_tag WR_R41_RE;         /* Work Register R41 Real */
  SPT_WR_R41_IM_tag WR_R41_IM;         /* Work Register R41 Imaginary */
  SPT_WR_R42_RE_tag WR_R42_RE;         /* Work Register R42 Real */
  SPT_WR_R42_IM_tag WR_R42_IM;         /* Work Register R42 Imaginary */
  SPT_WR_R43_RE_tag WR_R43_RE;         /* Work Register R43 Real */
  SPT_WR_R43_IM_tag WR_R43_IM;         /* Work Register R43 Imaginary */
  SPT_WR_R44_RE_tag WR_R44_RE;         /* Work Register R44 Real */
  SPT_WR_R44_IM_tag WR_R44_IM;         /* Work Register R44 Imaginary */
  SPT_WR_R45_RE_tag WR_R45_RE;         /* Work Register R45 Real */
  SPT_WR_R45_IM_tag WR_R45_IM;         /* Work Register R45 Imaginary */
  SPT_WR_R46_RE_tag WR_R46_RE;         /* Work Register R46 Real */
  SPT_WR_R46_IM_tag WR_R46_IM;         /* Work Register R46 Imaginary */
  SPT_WR_R47_RE_tag WR_R47_RE;         /* Work Register R47 Real */
  SPT_WR_R47_IM_tag WR_R47_IM;         /* Work Register R47 Imaginary */
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t CERS:1;                  /* Configuration Error for Safe DCF Clients */
    vuint16_t NXEN1:1;                 /* Processor 1 Nexus enable status */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t _unused_10:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t _unused_4:1;
    vuint16_t _unused_3:1;
    vuint16_t _unused_2:1;
    vuint16_t _unused_0:2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t IVLD:1;                  /* Instruction flash memory Valid */
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t _unused_0:1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_ERROR_union_tag {   /* SSCM Error Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_2:14;
    vuint16_t PAE:1;                   /* Peripheral Bus Abort Enable. */
    vuint16_t RAE:1;                   /* Register Bus Abort Enable. */
  } B;
} SSCM_ERROR_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_3:5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[2];
  SSCM_ERROR_tag ERROR;                /* SSCM Error Configuration Register */
  uint8_t SSCM_reserved1[32];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved2[8];
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t _unused_1:7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t _unused_2:6;
    vuint32_t _unused_1:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PTR:7;
    vuint32_t LB_DELAY:8;
    vuint32_t _unused_9:7;
    vuint32_t WRP:1;
    vuint32_t _unused_6:2;
    vuint32_t CRCEN:1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t PLLODF:6;
    vuint32_t _unused_19:5;
    vuint32_t PLLIDF:3;
    vuint32_t _unused_7:9;
    vuint32_t PLLLDF:7;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_CRCE_union_tag {   /* STCU2 CRC Expected Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCE:32;
  } B;
} STCU2_CRCE_tag;

typedef union STCU2_CRCR_union_tag {   /* STCU2 CRC Read Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCR:32;
  } B;
} STCU2_CRCR_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t CRCSSW:1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t _unused_10:6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t _unused_5:3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t CRCS:1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t CRCSUFM:1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBS7:1;
    vuint32_t LBS6:1;
    vuint32_t LBS5:1;
    vuint32_t LBS4:1;
    vuint32_t LBS3:1;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBE7:1;
    vuint32_t LBE6:1;
    vuint32_t LBE5:1;
    vuint32_t LBE4:1;
    vuint32_t LBE3:1;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBSSW7:1;
    vuint32_t LBSSW6:1;
    vuint32_t LBSSW5:1;
    vuint32_t LBSSW4:1;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBESW7:1;
    vuint32_t LBESW6:1;
    vuint32_t LBESW5:1;
    vuint32_t LBESW4:1;
    vuint32_t LBESW3:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBRMSW_union_tag { /* STCU2 On-Line LBIST Reset Management */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBRMSW7:1;
    vuint32_t LBRMSW6:1;
    vuint32_t LBRMSW5:1;
    vuint32_t LBRMSW4:1;
    vuint32_t LBRMSW3:1;
    vuint32_t LBRMSW2:1;
    vuint32_t LBRMSW1:1;
    vuint32_t LBRMSW0:1;
  } B;
} STCU2_LBRMSW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBUFM7:1;
    vuint32_t LBUFM6:1;
    vuint32_t LBUFM5:1;
    vuint32_t LBUFM4:1;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS63:1;
    vuint32_t MBS62:1;
    vuint32_t MBS61:1;
    vuint32_t MBS60:1;
    vuint32_t MBS59:1;
    vuint32_t MBS58:1;
    vuint32_t MBS57:1;
    vuint32_t MBS56:1;
    vuint32_t MBS55:1;
    vuint32_t MBS54:1;
    vuint32_t MBS53:1;
    vuint32_t MBS52:1;
    vuint32_t MBS51:1;
    vuint32_t MBS50:1;
    vuint32_t MBS49:1;
    vuint32_t MBS48:1;
    vuint32_t MBS47:1;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MBS64:1;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE63:1;
    vuint32_t MBE62:1;
    vuint32_t MBE61:1;
    vuint32_t MBE60:1;
    vuint32_t MBE59:1;
    vuint32_t MBE58:1;
    vuint32_t MBE57:1;
    vuint32_t MBE56:1;
    vuint32_t MBE55:1;
    vuint32_t MBE54:1;
    vuint32_t MBE53:1;
    vuint32_t MBE52:1;
    vuint32_t MBE51:1;
    vuint32_t MBE50:1;
    vuint32_t MBE49:1;
    vuint32_t MBE48:1;
    vuint32_t MBE47:1;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MBE64:1;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW63:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MBSSW64:1;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW63:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MBESW64:1;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM63:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MBUFM64:1;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_CTRL_union_tag { /* STCU2 LBIST Control */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_21:3;
    vuint32_t _unused_20:1;
    vuint32_t _unused_19:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t _unused_7:1;
    vuint32_t PFT:1;
    vuint32_t CWS:6;
  } B;
} STCU2_LB_CTRL_tag;

typedef union STCU2_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_PCS_tag;

typedef union STCU2_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREL_tag;

typedef union STCU2_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREH_tag;

typedef union STCU2_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRL_tag;

typedef union STCU2_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRH_tag;

typedef union STCU2_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISRELSW_tag;

typedef union STCU2_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISREHSW_tag;

typedef union STCU2_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRLSW_tag;

typedef union STCU2_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_CTRL_tag CTRL;              /* STCU2 LBIST Control */
  STCU2_LB_PCS_tag PCS;                /* STCU2 LBIST PC Stop Register */
  uint8_t LB_reserved0[8];
  STCU2_LB_MISREL_tag MISREL;          /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREH_tag MISREH;          /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRL_tag MISRRL;          /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRH_tag MISRRH;          /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_MISRELSW_tag MISRELSW;      /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREHSW_tag MISREHSW;      /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRLSW_tag MISRRLSW;      /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRHSW_tag MISRRHSW;      /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved1[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_0:24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Granularity */
  uint8_t STCU2_reserved0[4];
  STCU2_CRCE_tag CRCE;                 /* STCU2 CRC Expected Status Register */
  STCU2_CRCR_tag CRCR;                 /* STCU2 CRC Read Status Register */
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  STCU2_LBRMSW_tag LBRMSW;             /* STCU2 On-Line LBIST Reset Management */
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved1[128];
  STCU2_LB_tag LB[8];
  uint8_t STCU2_reserved2[768];
  STCU2_MB_CTRL_tag MB_CTRL[65];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_2:6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t _unused_11:13;
    vuint32_t SMD:2;                   /* Service Mode */
    vuint32_t RIA:1;                   /* Reset on Invalid Access */
    vuint32_t WND:1;                   /* Window Mode */
    vuint32_t ITR:1;                   /* Interrupt Then Reset */
    vuint32_t HLK:1;                   /* Hard Lock */
    vuint32_t SLK:1;                   /* Soft Lock */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t STP:1;                   /* Stop Mode Control */
    vuint32_t FRZ:1;                   /* Debug Mode Control */
    vuint32_t WEN:1;                   /* Watchdog Enabled */
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Watchdog Count */
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t LFPAR:32;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[4];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;
    vuint32_t NOVF0:1;
    vuint32_t _unused_24:6;
    vuint32_t NIF1:1;
    vuint32_t NOVF1:1;
    vuint32_t _unused_16:6;
    vuint32_t NIF2:1;
    vuint32_t NOVF2:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_6:2;
    vuint32_t _unused_0:6;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;
    vuint32_t NDSS0:2;
    vuint32_t NWRE0:1;
    vuint32_t _unused_27:1;
    vuint32_t NREE0:1;
    vuint32_t NFEE0:1;
    vuint32_t NFE0:1;
    vuint32_t NLOCK1:1;
    vuint32_t NDSS1:2;
    vuint32_t NWRE1:1;
    vuint32_t _unused_19:1;
    vuint32_t NREE1:1;
    vuint32_t NFEE1:1;
    vuint32_t NFE1:1;
    vuint32_t NLOCK2:1;
    vuint32_t NDSS2:2;
    vuint32_t NWRE2:1;
    vuint32_t _unused_11:1;
    vuint32_t NREE2:1;
    vuint32_t NFEE2:1;
    vuint32_t NFE2:1;
    vuint32_t _unused_0:8;
  } B;
} WKPU_NCR_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

typedef union XBIC_MCR_union_tag {     /* XBIC Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t SE0:1;
    vuint32_t SE1:1;
    vuint32_t SE2:1;
    vuint32_t SE3:1;
    vuint32_t SE4:1;
    vuint32_t SE5:1;
    vuint32_t SE6:1;
    vuint32_t SE7:1;
    vuint32_t ME0:1;
    vuint32_t ME1:1;
    vuint32_t ME2:1;
    vuint32_t ME3:1;
    vuint32_t ME4:1;
    vuint32_t ME5:1;
    vuint32_t ME6:1;
    vuint32_t ME7:1;
    vuint32_t _unused_0:16;
  } B;
} XBIC_MCR_tag;

typedef union XBIC_EIR_union_tag {     /* XBIC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t EIE:1;
    vuint32_t _unused_15:16;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_EIR_tag;

typedef union XBIC_ESR_union_tag {     /* XBIC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t DPSE0:1;
    vuint32_t DPSE1:1;
    vuint32_t DPSE2:1;
    vuint32_t DPSE3:1;
    vuint32_t DPSE4:1;
    vuint32_t DPSE5:1;
    vuint32_t DPSE6:1;
    vuint32_t DPSE7:1;
    vuint32_t DPME0:1;
    vuint32_t DPME1:1;
    vuint32_t DPME2:1;
    vuint32_t DPME3:1;
    vuint32_t DPME4:1;
    vuint32_t DPME5:1;
    vuint32_t DPME6:1;
    vuint32_t DPME7:1;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_ESR_tag;

typedef union XBIC_EAR_union_tag {     /* XBIC Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} XBIC_EAR_tag;

struct XBIC_tag {
  XBIC_MCR_tag MCR;                    /* XBIC Module Control Register */
  XBIC_EIR_tag EIR;                    /* XBIC Error Injection Register */
  XBIC_ESR_tag ESR;                    /* XBIC Error Status Register */
  XBIC_EAR_tag EAR;                    /* XBIC Error Address Register */
};

#define SRAM0_START 0x40000000UL
#define ADC_0 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFFE04000UL)
#define AFE (*(volatile struct AFE_tag *) 0xFBF0C000UL)
#define AIPS_0 (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_1 (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define AXBS_0 (*(volatile struct AXBS_tag *) 0xFC004000UL)
#define AXBS_1 (*(volatile struct AXBS_tag *) 0xFC008000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEC0000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFBEC0000UL)
#define CMU_0 (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_10 (*(volatile struct CMU_tag *) 0xFBFB0480UL)
#define CMU_11 (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_12 (*(volatile struct CMU_tag *) 0xFBFB0500UL)
#define CMU_2 (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_3 (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_4 (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_6 (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_7 (*(volatile struct CMU_tag *) 0xFBFB03C0UL)
#define CMU_8 (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_9 (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define CSE (*(volatile struct CSE_tag *) 0xFC074000UL)
#define CTE (*(volatile struct CTE_tag *) 0xFFD0C000UL)
#define CTU (*(volatile struct CTU_tag *) 0xFBC10000UL)
#define DMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFBF6C000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define EIM (*(volatile struct EIM_tag *) 0xFC07C000UL)
#define ETIMER_1 (*(volatile struct ETIMER_tag *) 0xFFC24000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FlexPWM_0 (*(volatile struct FlexPWM_tag *) 0xFBC00000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define MCB (*(volatile struct MCB_tag *) 0xFFC0C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define MIPICSI2 (*(volatile struct MIPICSI2_tag *) 0xFBF08000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAM_XBAR (*(volatile struct PRAM_XBAR_tag *) 0xFC00C000UL)
#define RGM (*(volatile struct RGM_tag *) 0xFFFA8000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFFE74000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFBE70000UL)
#define SPT (*(volatile struct SPT_tag *) 0xFFD10000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFC078000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBIC_0 (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XBIC_1 (*(volatile struct XBIC_tag *) 0xFC01C000UL)
#define XBIC_2 (*(volatile struct XBIC_tag *) 0xFC024000UL)
#define XBIC_4 (*(volatile struct XBIC_tag *) 0xFC044000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_THRHLR6        ADC_0.THRHLR6.R               /* Threshold Register */
#define ADC_0_THRHLR7        ADC_0.THRHLR7.R               /* Threshold Register */
#define ADC_0_THRHLR8        ADC_0.THRHLR8.R               /* Threshold Register */
#define ADC_0_THRHLR9        ADC_0.THRHLR9.R               /* Threshold Register */
#define ADC_0_THRHLR10       ADC_0.THRHLR10.R              /* Threshold Register */
#define ADC_0_THRHLR11       ADC_0.THRHLR11.R              /* Threshold Register */
#define ADC_0_THRHLR12       ADC_0.THRHLR12.R              /* Threshold Register */
#define ADC_0_THRHLR13       ADC_0.THRHLR13.R              /* Threshold Register */
#define ADC_0_THRHLR14       ADC_0.THRHLR14.R              /* Threshold Register */
#define ADC_0_THRHLR15       ADC_0.THRHLR15.R              /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_THRHLR6        ADC_1.THRHLR6.R               /* Threshold Register */
#define ADC_1_THRHLR7        ADC_1.THRHLR7.R               /* Threshold Register */
#define ADC_1_THRHLR8        ADC_1.THRHLR8.R               /* Threshold Register */
#define ADC_1_THRHLR9        ADC_1.THRHLR9.R               /* Threshold Register */
#define ADC_1_THRHLR10       ADC_1.THRHLR10.R              /* Threshold Register */
#define ADC_1_THRHLR11       ADC_1.THRHLR11.R              /* Threshold Register */
#define ADC_1_THRHLR12       ADC_1.THRHLR12.R              /* Threshold Register */
#define ADC_1_THRHLR13       ADC_1.THRHLR13.R              /* Threshold Register */
#define ADC_1_THRHLR14       ADC_1.THRHLR14.R              /* Threshold Register */
#define ADC_1_THRHLR15       ADC_1.THRHLR15.R              /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

/* AFE */
#define AFE_OSCCTRL          AFE.OSCCTRL.R                 /* Oscillator Control Register */
#define AFE_OSCSTS           AFE.OSCSTS.R                  /* Oscillator Status Register */
#define AFE_OSCDLY           AFE.OSCDLY.R                  /* Oscillator Delay Register */
#define AFE_PLLCTRL1         AFE.PLLCTRL1.R                /* SDPLL Control Register 1 */
#define AFE_PLLCTRL2         AFE.PLLCTRL2.R                /* SDPLL Control Register 2 */
#define AFE_PLLCTRL3         AFE.PLLCTRL3.R                /* SDPLL Control Register 3 */
#define AFE_PLLCTRL8         AFE.PLLCTRL8.R                /* SDPLL Control Register 8 */
#define AFE_PLLSTS           AFE.PLLSTS.R                  /* SDPLL Status Register */
#define AFE_VRFCTRL1         AFE.VRFCTRL1.R                /* VREF Control Register 1 */
#define AFE_LVDSTS           AFE.LVDSTS.R                  /* Low Voltage Detect Status Register */
#define AFE_VRGCTRL5         AFE.VRGCTRL5.R                /* VREG5 Control Register */
#define AFE_VRGCTRL6         AFE.VRGCTRL6.R                /* VREG6 Control Register */
#define AFE_VRGCTRL7         AFE.VRGCTRL7.R                /* VREG7 Control Register */
#define AFE_VRGCTRL8         AFE.VRGCTRL8.R                /* VREG8 Control Register */

/* AIPS */
#define AIPS_0_MPRA          AIPS_0.MPRA.R                 /* Master Privilege Register A */
#define AIPS_0_MPRB          AIPS_0.MPRB.R                 /* Master Privilege Register B */
#define AIPS_0_PACRA         AIPS_0.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRB         AIPS_0.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRC         AIPS_0.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRD         AIPS_0.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_0_PACR_Reserved AIPS_0.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRF         AIPS_0.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRG         AIPS_0.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRH         AIPS_0.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_0_OPACRA        AIPS_0.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRB        AIPS_0.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRC        AIPS_0.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRD        AIPS_0.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRE        AIPS_0.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRF        AIPS_0.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRG        AIPS_0.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRH        AIPS_0.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRI        AIPS_0.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRJ        AIPS_0.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRK        AIPS_0.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRL        AIPS_0.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRM        AIPS_0.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRN        AIPS_0.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRO        AIPS_0.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRP        AIPS_0.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRQ        AIPS_0.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRR        AIPS_0.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRS        AIPS_0.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRT        AIPS_0.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRU        AIPS_0.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRV        AIPS_0.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRW        AIPS_0.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRX        AIPS_0.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRY        AIPS_0.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRZ        AIPS_0.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAA       AIPS_0.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAB       AIPS_0.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAC       AIPS_0.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAD       AIPS_0.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAE       AIPS_0.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAF       AIPS_0.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

#define AIPS_1_MPRA          AIPS_1.MPRA.R                 /* Master Privilege Register A */
#define AIPS_1_MPRB          AIPS_1.MPRB.R                 /* Master Privilege Register B */
#define AIPS_1_PACRA         AIPS_1.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRB         AIPS_1.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRC         AIPS_1.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRD         AIPS_1.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_1_PACR_Reserved AIPS_1.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRF         AIPS_1.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRG         AIPS_1.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRH         AIPS_1.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_1_OPACRA        AIPS_1.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRB        AIPS_1.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRC        AIPS_1.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRD        AIPS_1.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRE        AIPS_1.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRF        AIPS_1.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRG        AIPS_1.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRH        AIPS_1.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRI        AIPS_1.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRJ        AIPS_1.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRK        AIPS_1.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRL        AIPS_1.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRM        AIPS_1.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRN        AIPS_1.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRO        AIPS_1.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRP        AIPS_1.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRQ        AIPS_1.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRR        AIPS_1.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRS        AIPS_1.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRT        AIPS_1.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRU        AIPS_1.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRV        AIPS_1.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRW        AIPS_1.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRX        AIPS_1.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRY        AIPS_1.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRZ        AIPS_1.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAA       AIPS_1.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAB       AIPS_1.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAC       AIPS_1.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAD       AIPS_1.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAE       AIPS_1.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAF       AIPS_1.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AXBS */
#define AXBS_0_PRS0          AXBS_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS0          AXBS_0.PORT[0].CRS.R          /* Control Register */
#define AXBS_0_PRS1          AXBS_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS1          AXBS_0.PORT[1].CRS.R          /* Control Register */
#define AXBS_0_PRS2          AXBS_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS2          AXBS_0.PORT[2].CRS.R          /* Control Register */
#define AXBS_0_PRS3          AXBS_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS3          AXBS_0.PORT[3].CRS.R          /* Control Register */
#define AXBS_0_PRS4          AXBS_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS4          AXBS_0.PORT[4].CRS.R          /* Control Register */
#define AXBS_0_PRS5          AXBS_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS5          AXBS_0.PORT[5].CRS.R          /* Control Register */
#define AXBS_0_PRS6          AXBS_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS6          AXBS_0.PORT[6].CRS.R          /* Control Register */
#define AXBS_0_PRS7          AXBS_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS7          AXBS_0.PORT[7].CRS.R          /* Control Register */

#define AXBS_1_PRS0          AXBS_1.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS0          AXBS_1.PORT[0].CRS.R          /* Control Register */
#define AXBS_1_PRS1          AXBS_1.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS1          AXBS_1.PORT[1].CRS.R          /* Control Register */
#define AXBS_1_PRS2          AXBS_1.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS2          AXBS_1.PORT[2].CRS.R          /* Control Register */
#define AXBS_1_PRS3          AXBS_1.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS3          AXBS_1.PORT[3].CRS.R          /* Control Register */
#define AXBS_1_PRS4          AXBS_1.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS4          AXBS_1.PORT[4].CRS.R          /* Control Register */
#define AXBS_1_PRS5          AXBS_1.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS5          AXBS_1.PORT[5].CRS.R          /* Control Register */
#define AXBS_1_PRS6          AXBS_1.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS6          AXBS_1.PORT[6].CRS.R          /* Control Register */
#define AXBS_1_PRS7          AXBS_1.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS7          AXBS_1.PORT[7].CRS.R          /* Control Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_IMASK3         CAN_0.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_0_IFLAG3         CAN_0.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR64        CAN_0.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR65        CAN_0.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR66        CAN_0.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR67        CAN_0.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR68        CAN_0.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR69        CAN_0.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR70        CAN_0.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR71        CAN_0.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR72        CAN_0.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR73        CAN_0.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR74        CAN_0.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR75        CAN_0.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR76        CAN_0.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR77        CAN_0.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR78        CAN_0.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR79        CAN_0.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR80        CAN_0.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR81        CAN_0.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR82        CAN_0.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR83        CAN_0.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR84        CAN_0.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR85        CAN_0.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR86        CAN_0.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR87        CAN_0.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR88        CAN_0.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR89        CAN_0.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR90        CAN_0.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR91        CAN_0.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR92        CAN_0.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR93        CAN_0.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR94        CAN_0.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR95        CAN_0.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CBT            CAN_2.CBT.R                   /* CAN Bit Timing Register */
#define CAN_2_IMASK3         CAN_2.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_2_IFLAG3         CAN_2.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR64        CAN_2.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR65        CAN_2.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR66        CAN_2.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR67        CAN_2.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR68        CAN_2.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR69        CAN_2.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR70        CAN_2.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR71        CAN_2.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR72        CAN_2.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR73        CAN_2.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR74        CAN_2.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR75        CAN_2.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR76        CAN_2.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR77        CAN_2.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR78        CAN_2.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR79        CAN_2.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR80        CAN_2.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR81        CAN_2.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR82        CAN_2.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR83        CAN_2.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR84        CAN_2.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR85        CAN_2.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR86        CAN_2.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR87        CAN_2.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR88        CAN_2.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR89        CAN_2.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR90        CAN_2.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR91        CAN_2.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR92        CAN_2.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR93        CAN_2.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR94        CAN_2.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR95        CAN_2.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */
#define CAN_2_FDCTRL         CAN_2.FDCTRL.R                /* CAN FD Control Register */
#define CAN_2_FDCBT          CAN_2.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_2_FDCRC          CAN_2.FDCRC.R                 /* CAN FD CRC Register */

/* CMU */
#define CMU_0_CSR            CMU_0.CSR.R                   /* CMU Control Status Register */
#define CMU_0_FDR            CMU_0.FDR.R                   /* CMU Frequency Display Register */
#define CMU_0_HFREFR         CMU_0.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_0_LFREFR         CMU_0.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_0_ISR            CMU_0.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_0_MDR            CMU_0.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_10_CSR           CMU_10.CSR.R                  /* CMU Control Status Register */
#define CMU_10_FDR           CMU_10.FDR.R                  /* CMU Frequency Display Register */
#define CMU_10_HFREFR        CMU_10.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_10_LFREFR        CMU_10.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_10_ISR           CMU_10.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_10_MDR           CMU_10.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_11_CSR           CMU_11.CSR.R                  /* CMU Control Status Register */
#define CMU_11_FDR           CMU_11.FDR.R                  /* CMU Frequency Display Register */
#define CMU_11_HFREFR        CMU_11.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_11_LFREFR        CMU_11.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_11_ISR           CMU_11.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_11_MDR           CMU_11.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_12_CSR           CMU_12.CSR.R                  /* CMU Control Status Register */
#define CMU_12_FDR           CMU_12.FDR.R                  /* CMU Frequency Display Register */
#define CMU_12_HFREFR        CMU_12.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_12_LFREFR        CMU_12.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_12_ISR           CMU_12.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_12_MDR           CMU_12.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_2_CSR            CMU_2.CSR.R                   /* CMU Control Status Register */
#define CMU_2_FDR            CMU_2.FDR.R                   /* CMU Frequency Display Register */
#define CMU_2_HFREFR         CMU_2.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_2_LFREFR         CMU_2.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_2_ISR            CMU_2.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_2_MDR            CMU_2.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_3_CSR            CMU_3.CSR.R                   /* CMU Control Status Register */
#define CMU_3_FDR            CMU_3.FDR.R                   /* CMU Frequency Display Register */
#define CMU_3_HFREFR         CMU_3.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_3_LFREFR         CMU_3.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_3_ISR            CMU_3.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_3_MDR            CMU_3.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_4_CSR            CMU_4.CSR.R                   /* CMU Control Status Register */
#define CMU_4_FDR            CMU_4.FDR.R                   /* CMU Frequency Display Register */
#define CMU_4_HFREFR         CMU_4.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_4_LFREFR         CMU_4.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_4_ISR            CMU_4.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_4_MDR            CMU_4.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_6_CSR            CMU_6.CSR.R                   /* CMU Control Status Register */
#define CMU_6_FDR            CMU_6.FDR.R                   /* CMU Frequency Display Register */
#define CMU_6_HFREFR         CMU_6.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_6_LFREFR         CMU_6.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_6_ISR            CMU_6.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_6_MDR            CMU_6.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_7_CSR            CMU_7.CSR.R                   /* CMU Control Status Register */
#define CMU_7_FDR            CMU_7.FDR.R                   /* CMU Frequency Display Register */
#define CMU_7_HFREFR         CMU_7.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_7_LFREFR         CMU_7.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_7_ISR            CMU_7.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_7_MDR            CMU_7.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_8_CSR            CMU_8.CSR.R                   /* CMU Control Status Register */
#define CMU_8_FDR            CMU_8.FDR.R                   /* CMU Frequency Display Register */
#define CMU_8_HFREFR         CMU_8.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_8_LFREFR         CMU_8.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_8_ISR            CMU_8.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_8_MDR            CMU_8.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_9_CSR            CMU_9.CSR.R                   /* CMU Control Status Register */
#define CMU_9_FDR            CMU_9.FDR.R                   /* CMU Frequency Display Register */
#define CMU_9_HFREFR         CMU_9.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_9_LFREFR         CMU_9.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_9_ISR            CMU_9.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_9_MDR            CMU_9.MDR.R                   /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG1           CRC_0.CHANNEL[0].CFG.R        /* Configuration Register */
#define CRC_0_INP1           CRC_0.CHANNEL[0].INP.R        /* Input Register */
#define CRC_0_CSTAT1         CRC_0.CHANNEL[0].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP1          CRC_0.CHANNEL[0].OUTP.R       /* Output Register */
#define CRC_0_CFG2           CRC_0.CHANNEL[1].CFG.R        /* Configuration Register */
#define CRC_0_INP2           CRC_0.CHANNEL[1].INP.R        /* Input Register */
#define CRC_0_CSTAT2         CRC_0.CHANNEL[1].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP2          CRC_0.CHANNEL[1].OUTP.R       /* Output Register */
#define CRC_0_CFG3           CRC_0.CHANNEL[2].CFG.R        /* Configuration Register */
#define CRC_0_INP3           CRC_0.CHANNEL[2].INP.R        /* Input Register */
#define CRC_0_CSTAT3         CRC_0.CHANNEL[2].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP3          CRC_0.CHANNEL[2].OUTP.R       /* Output Register */

#define CRC_1_CFG1           CRC_1.CHANNEL[0].CFG.R        /* Configuration Register */
#define CRC_1_INP1           CRC_1.CHANNEL[0].INP.R        /* Input Register */
#define CRC_1_CSTAT1         CRC_1.CHANNEL[0].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP1          CRC_1.CHANNEL[0].OUTP.R       /* Output Register */
#define CRC_1_CFG2           CRC_1.CHANNEL[1].CFG.R        /* Configuration Register */
#define CRC_1_INP2           CRC_1.CHANNEL[1].INP.R        /* Input Register */
#define CRC_1_CSTAT2         CRC_1.CHANNEL[1].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP2          CRC_1.CHANNEL[1].OUTP.R       /* Output Register */
#define CRC_1_CFG3           CRC_1.CHANNEL[2].CFG.R        /* Configuration Register */
#define CRC_1_INP3           CRC_1.CHANNEL[2].INP.R        /* Input Register */
#define CRC_1_CSTAT3         CRC_1.CHANNEL[2].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP3          CRC_1.CHANNEL[2].OUTP.R       /* Output Register */

/* CSE */
#define CSE_CR               CSE.CR.R                      /* CSE Control Register */
#define CSE_SR               CSE.SR.R                      /* CSE Status Register */
#define CSE_IR               CSE.IR.R                      /* CSE Interrupt Register */
#define CSE_ECR              CSE.ECR.R                     /* CSE Error Code Register */
#define CSE_CMD              CSE.CMD.R                     /* CSE Command Register */
#define CSE_P1               CSE.P[0].R                    /* CSE Parameter Register */
#define CSE_P2               CSE.P[1].R                    /* CSE Parameter Register */
#define CSE_P3               CSE.P[2].R                    /* CSE Parameter Register */
#define CSE_P4               CSE.P[3].R                    /* CSE Parameter Register */
#define CSE_P5               CSE.P[4].R                    /* CSE Parameter Register */

/* CTE */
#define CTE_CNTRL            CTE.CNTRL.R                   /* Control Register */
#define CTE_CNTRL1           CTE.CNTRL1.R                  /* CTE Control Register 1 */
#define CTE_LUT0_LSB0        CTE.LUT[0].LSB[0].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB1        CTE.LUT[0].LSB[1].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB2        CTE.LUT[0].LSB[2].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB3        CTE.LUT[0].LSB[3].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB4        CTE.LUT[0].LSB[4].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB5        CTE.LUT[0].LSB[5].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB6        CTE.LUT[0].LSB[6].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB7        CTE.LUT[0].LSB[7].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB8        CTE.LUT[0].LSB[8].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB9        CTE.LUT[0].LSB[9].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB10       CTE.LUT[0].LSB[10].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB11       CTE.LUT[0].LSB[11].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB12       CTE.LUT[0].LSB[12].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB13       CTE.LUT[0].LSB[13].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB14       CTE.LUT[0].LSB[14].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB15       CTE.LUT[0].LSB[15].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB16       CTE.LUT[0].LSB[16].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB17       CTE.LUT[0].LSB[17].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB18       CTE.LUT[0].LSB[18].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB19       CTE.LUT[0].LSB[19].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB20       CTE.LUT[0].LSB[20].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB21       CTE.LUT[0].LSB[21].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB22       CTE.LUT[0].LSB[22].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB23       CTE.LUT[0].LSB[23].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB24       CTE.LUT[0].LSB[24].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB25       CTE.LUT[0].LSB[25].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB26       CTE.LUT[0].LSB[26].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB27       CTE.LUT[0].LSB[27].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB28       CTE.LUT[0].LSB[28].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB29       CTE.LUT[0].LSB[29].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB30       CTE.LUT[0].LSB[30].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB31       CTE.LUT[0].LSB[31].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_MSB0        CTE.LUT[0].MSB[0].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB1        CTE.LUT[0].MSB[1].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB2        CTE.LUT[0].MSB[2].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB3        CTE.LUT[0].MSB[3].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB4        CTE.LUT[0].MSB[4].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB5        CTE.LUT[0].MSB[5].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB6        CTE.LUT[0].MSB[6].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB7        CTE.LUT[0].MSB[7].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB8        CTE.LUT[0].MSB[8].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB9        CTE.LUT[0].MSB[9].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB10       CTE.LUT[0].MSB[10].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB11       CTE.LUT[0].MSB[11].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB12       CTE.LUT[0].MSB[12].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB13       CTE.LUT[0].MSB[13].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB14       CTE.LUT[0].MSB[14].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB15       CTE.LUT[0].MSB[15].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB16       CTE.LUT[0].MSB[16].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB17       CTE.LUT[0].MSB[17].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB18       CTE.LUT[0].MSB[18].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB19       CTE.LUT[0].MSB[19].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB20       CTE.LUT[0].MSB[20].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB21       CTE.LUT[0].MSB[21].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB22       CTE.LUT[0].MSB[22].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB23       CTE.LUT[0].MSB[23].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB24       CTE.LUT[0].MSB[24].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB25       CTE.LUT[0].MSB[25].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB26       CTE.LUT[0].MSB[26].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB27       CTE.LUT[0].MSB[27].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB28       CTE.LUT[0].MSB[28].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB29       CTE.LUT[0].MSB[29].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB30       CTE.LUT[0].MSB[30].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB31       CTE.LUT[0].MSB[31].R          /* First Timing Table Register (MSB) */
#define CTE_LUT1_LSB0        CTE.LUT[1].LSB[0].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB1        CTE.LUT[1].LSB[1].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB2        CTE.LUT[1].LSB[2].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB3        CTE.LUT[1].LSB[3].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB4        CTE.LUT[1].LSB[4].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB5        CTE.LUT[1].LSB[5].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB6        CTE.LUT[1].LSB[6].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB7        CTE.LUT[1].LSB[7].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB8        CTE.LUT[1].LSB[8].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB9        CTE.LUT[1].LSB[9].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB10       CTE.LUT[1].LSB[10].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB11       CTE.LUT[1].LSB[11].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB12       CTE.LUT[1].LSB[12].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB13       CTE.LUT[1].LSB[13].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB14       CTE.LUT[1].LSB[14].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB15       CTE.LUT[1].LSB[15].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB16       CTE.LUT[1].LSB[16].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB17       CTE.LUT[1].LSB[17].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB18       CTE.LUT[1].LSB[18].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB19       CTE.LUT[1].LSB[19].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB20       CTE.LUT[1].LSB[20].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB21       CTE.LUT[1].LSB[21].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB22       CTE.LUT[1].LSB[22].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB23       CTE.LUT[1].LSB[23].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB24       CTE.LUT[1].LSB[24].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB25       CTE.LUT[1].LSB[25].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB26       CTE.LUT[1].LSB[26].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB27       CTE.LUT[1].LSB[27].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB28       CTE.LUT[1].LSB[28].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB29       CTE.LUT[1].LSB[29].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB30       CTE.LUT[1].LSB[30].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB31       CTE.LUT[1].LSB[31].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_MSB0        CTE.LUT[1].MSB[0].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB1        CTE.LUT[1].MSB[1].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB2        CTE.LUT[1].MSB[2].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB3        CTE.LUT[1].MSB[3].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB4        CTE.LUT[1].MSB[4].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB5        CTE.LUT[1].MSB[5].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB6        CTE.LUT[1].MSB[6].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB7        CTE.LUT[1].MSB[7].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB8        CTE.LUT[1].MSB[8].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB9        CTE.LUT[1].MSB[9].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB10       CTE.LUT[1].MSB[10].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB11       CTE.LUT[1].MSB[11].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB12       CTE.LUT[1].MSB[12].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB13       CTE.LUT[1].MSB[13].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB14       CTE.LUT[1].MSB[14].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB15       CTE.LUT[1].MSB[15].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB16       CTE.LUT[1].MSB[16].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB17       CTE.LUT[1].MSB[17].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB18       CTE.LUT[1].MSB[18].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB19       CTE.LUT[1].MSB[19].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB20       CTE.LUT[1].MSB[20].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB21       CTE.LUT[1].MSB[21].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB22       CTE.LUT[1].MSB[22].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB23       CTE.LUT[1].MSB[23].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB24       CTE.LUT[1].MSB[24].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB25       CTE.LUT[1].MSB[25].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB26       CTE.LUT[1].MSB[26].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB27       CTE.LUT[1].MSB[27].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB28       CTE.LUT[1].MSB[28].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB29       CTE.LUT[1].MSB[29].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB30       CTE.LUT[1].MSB[30].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB31       CTE.LUT[1].MSB[31].R          /* Second Timing Table Register (MSB) */
#define CTE_SIGTYPE00        CTE.SIGTYPE0[0].R             /* Signal Type Register 0 */
#define CTE_SIGTYPE01        CTE.SIGTYPE0[1].R             /* Signal Type Register 0 */
#define CTE_SIGTYPE10        CTE.SIGTYPE1[0].R             /* Signal Type Register 1 */
#define CTE_SIGTYPE11        CTE.SIGTYPE1[1].R             /* Signal Type Register 1 */
#define CTE_INTEN            CTE.INTEN.R                   /* CTE Interrupt Enable Register */
#define CTE_INTSTAT          CTE.INTSTAT.R                 /* CTE Interrupt Status Register */
#define CTE_RCVOFCNT         CTE.RCVOFCNT.R                /* Receiver Overflow Counter */
#define CTE_CKSM_LSB         CTE.CKSM_LSB.R                /* LUT Checksum Register */
#define CTE_CKSM_MSB         CTE.CKSM_MSB.R                /* LUT Checksum Register */
#define CTE_DBG_REG          CTE.DBG_REG.R                 /* Debug Register */
#define CTE_LUT_DUR          CTE.LUT_DUR.R                 /* TT0 Execution Duration Register */
#define CTE_LUT_DUR1         CTE.LUT_DUR1.R                /* TT1 Execution Duration Register */
#define CTE_CLKSEL           CTE.CLKSEL.R                  /* Clock Select Register */

/* CTU */
#define CTU_TGSISR           CTU.TGSISR.R                  /* Trigger Generator Subunit Input Selection Register */
#define CTU_TGSCR            CTU.TGSCR.R                   /* Trigger Generator Subunit Control Register */
#define CTU_T0CR             CTU.TCR[0].R                  /* Trigger Compare Register */
#define CTU_T1CR             CTU.TCR[1].R                  /* Trigger Compare Register */
#define CTU_T2CR             CTU.TCR[2].R                  /* Trigger Compare Register */
#define CTU_T3CR             CTU.TCR[3].R                  /* Trigger Compare Register */
#define CTU_T4CR             CTU.TCR[4].R                  /* Trigger Compare Register */
#define CTU_T5CR             CTU.TCR[5].R                  /* Trigger Compare Register */
#define CTU_T6CR             CTU.TCR[6].R                  /* Trigger Compare Register */
#define CTU_T7CR             CTU.TCR[7].R                  /* Trigger Compare Register */
#define CTU_TGSCCR           CTU.TGSCCR.R                  /* TGS Counter Compare Register */
#define CTU_TGSCRR           CTU.TGSCRR.R                  /* TGS Counter Reload Register */
#define CTU_CLCR1            CTU.CLCR1.R                   /* Commands List Control Register 1 */
#define CTU_CLCR2            CTU.CLCR2.R                   /* Commands List Control Register 2 */
#define CTU_THCR1            CTU.THCR1.R                   /* Trigger Handler Control Register 1 */
#define CTU_THCR2            CTU.THCR2.R                   /* Trigger Handler Control Register 2 */
#define CTU_CLR_A_1          CTU.CHANNEL[0].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_1          CTU.CHANNEL[0].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_1          CTU.CHANNEL[0].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_2          CTU.CHANNEL[1].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_2          CTU.CHANNEL[1].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_2          CTU.CHANNEL[1].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_3          CTU.CHANNEL[2].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_3          CTU.CHANNEL[2].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_3          CTU.CHANNEL[2].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_4          CTU.CHANNEL[3].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_4          CTU.CHANNEL[3].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_4          CTU.CHANNEL[3].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_5          CTU.CHANNEL[4].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_5          CTU.CHANNEL[4].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_5          CTU.CHANNEL[4].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_6          CTU.CHANNEL[5].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_6          CTU.CHANNEL[5].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_6          CTU.CHANNEL[5].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_7          CTU.CHANNEL[6].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_7          CTU.CHANNEL[6].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_7          CTU.CHANNEL[6].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_8          CTU.CHANNEL[7].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_8          CTU.CHANNEL[7].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_8          CTU.CHANNEL[7].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_9          CTU.CHANNEL[8].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_9          CTU.CHANNEL[8].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_9          CTU.CHANNEL[8].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_10         CTU.CHANNEL[9].CLR_A.R        /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_10         CTU.CHANNEL[9].CLR_B.R        /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_10         CTU.CHANNEL[9].CLR_C.R        /* Command List Register C for self-test commands */
#define CTU_CLR_A_11         CTU.CHANNEL[10].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_11         CTU.CHANNEL[10].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_11         CTU.CHANNEL[10].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_12         CTU.CHANNEL[11].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_12         CTU.CHANNEL[11].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_12         CTU.CHANNEL[11].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_13         CTU.CHANNEL[12].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_13         CTU.CHANNEL[12].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_13         CTU.CHANNEL[12].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_14         CTU.CHANNEL[13].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_14         CTU.CHANNEL[13].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_14         CTU.CHANNEL[13].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_15         CTU.CHANNEL[14].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_15         CTU.CHANNEL[14].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_15         CTU.CHANNEL[14].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_16         CTU.CHANNEL[15].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_16         CTU.CHANNEL[15].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_16         CTU.CHANNEL[15].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_17         CTU.CHANNEL[16].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_17         CTU.CHANNEL[16].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_17         CTU.CHANNEL[16].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_18         CTU.CHANNEL[17].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_18         CTU.CHANNEL[17].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_18         CTU.CHANNEL[17].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_19         CTU.CHANNEL[18].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_19         CTU.CHANNEL[18].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_19         CTU.CHANNEL[18].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_20         CTU.CHANNEL[19].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_20         CTU.CHANNEL[19].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_20         CTU.CHANNEL[19].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_21         CTU.CHANNEL[20].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_21         CTU.CHANNEL[20].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_21         CTU.CHANNEL[20].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_22         CTU.CHANNEL[21].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_22         CTU.CHANNEL[21].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_22         CTU.CHANNEL[21].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_23         CTU.CHANNEL[22].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_23         CTU.CHANNEL[22].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_23         CTU.CHANNEL[22].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_CLR_A_24         CTU.CHANNEL[23].CLR_A.R       /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_CLR_B_24         CTU.CHANNEL[23].CLR_B.R       /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_CLR_C_24         CTU.CHANNEL[23].CLR_C.R       /* Command List Register C for self-test commands */
#define CTU_FDCR             CTU.FDCR.R                    /* FIFO DMA Control Register */
#define CTU_FCR              CTU.FCR.R                     /* FIFO Control Register */
#define CTU_FTH              CTU.FTH.R                     /* FIFO Threshold Register */
#define CTU_FST              CTU.FST.R                     /* FIFO Status Register */
#define CTU_FR0              CTU.FR[0].R                   /* FIFO Right Aligned Data Register */
#define CTU_FR1              CTU.FR[1].R                   /* FIFO Right Aligned Data Register */
#define CTU_FR2              CTU.FR[2].R                   /* FIFO Right Aligned Data Register */
#define CTU_FR3              CTU.FR[3].R                   /* FIFO Right Aligned Data Register */
#define CTU_FL0              CTU.FL[0].R                   /* FIFO Signed Left Aligned Data Register */
#define CTU_FL1              CTU.FL[1].R                   /* FIFO Signed Left Aligned Data Register */
#define CTU_FL2              CTU.FL[2].R                   /* FIFO Signed Left Aligned Data Register */
#define CTU_FL3              CTU.FL[3].R                   /* FIFO Signed Left Aligned Data Register */
#define CTU_EFR              CTU.EFR.R                     /* Error Flag Register */
#define CTU_IFR              CTU.IFR.R                     /* Interrupt Flag Register */
#define CTU_IR               CTU.IR.R                      /* Interrupt/DMA Register */
#define CTU_COTR             CTU.COTR.R                    /* Control ON Time Register */
#define CTU_CR               CTU.CR.R                      /* Control Register */
#define CTU_DFR              CTU.DFR.R                     /* Digital Filter Register */
#define CTU_EXPAR            CTU.EXPAR.R                   /* Expected Value A Register */
#define CTU_EXPBR            CTU.EXPBR.R                   /* Expected Value B Register */
#define CTU_CNTRNGR          CTU.CNTRNGR.R                 /* Counter Range Register */
#define CTU_LISTCSR          CTU.LISTCSR.R                 /* List Control/Status Register */

/* DMA */
#define DMA_CR               DMA.CR.R                      /* Control Register */
#define DMA_ES               DMA.ES.R                      /* Error Status Register */
#define DMA_ERQ              DMA.ERQ.R                     /* Enable Request Register */
#define DMA_EEI              DMA.EEI.R                     /* Enable Error Interrupt Register */
#define DMA_SERQ             DMA.SERQ.R                    /* Set Enable Request Register */
#define DMA_CERQ             DMA.CERQ.R                    /* Clear Enable Request Register */
#define DMA_SEEI             DMA.SEEI.R                    /* Set Enable Error Interrupt Register */
#define DMA_CEEI             DMA.CEEI.R                    /* Clear Enable Error Interrupt Register */
#define DMA_CINT             DMA.CINT.R                    /* Clear Interrupt Request Register */
#define DMA_CERR             DMA.CERR.R                    /* Clear Error Register */
#define DMA_SSRT             DMA.SSRT.R                    /* Set START Bit Register */
#define DMA_CDNE             DMA.CDNE.R                    /* Clear DONE Status Bit Register */
#define DMA_INT              DMA.INT.R                     /* Interrupt Request Register */
#define DMA_ERR              DMA.ERR.R                     /* Error Register */
#define DMA_HRS              DMA.HRS.R                     /* Hardware Request Status Register */
#define DMA_DCHPRI0          DMA.DCHPRI[0].R               /* Channel n Priority Register */
#define DMA_DCHPRI1          DMA.DCHPRI[1].R               /* Channel n Priority Register */
#define DMA_DCHPRI2          DMA.DCHPRI[2].R               /* Channel n Priority Register */
#define DMA_DCHPRI3          DMA.DCHPRI[3].R               /* Channel n Priority Register */
#define DMA_DCHPRI4          DMA.DCHPRI[4].R               /* Channel n Priority Register */
#define DMA_DCHPRI5          DMA.DCHPRI[5].R               /* Channel n Priority Register */
#define DMA_DCHPRI6          DMA.DCHPRI[6].R               /* Channel n Priority Register */
#define DMA_DCHPRI7          DMA.DCHPRI[7].R               /* Channel n Priority Register */
#define DMA_DCHPRI8          DMA.DCHPRI[8].R               /* Channel n Priority Register */
#define DMA_DCHPRI9          DMA.DCHPRI[9].R               /* Channel n Priority Register */
#define DMA_DCHPRI10         DMA.DCHPRI[10].R              /* Channel n Priority Register */
#define DMA_DCHPRI11         DMA.DCHPRI[11].R              /* Channel n Priority Register */
#define DMA_DCHPRI12         DMA.DCHPRI[12].R              /* Channel n Priority Register */
#define DMA_DCHPRI13         DMA.DCHPRI[13].R              /* Channel n Priority Register */
#define DMA_DCHPRI14         DMA.DCHPRI[14].R              /* Channel n Priority Register */
#define DMA_DCHPRI15         DMA.DCHPRI[15].R              /* Channel n Priority Register */
#define DMA_DCHPRI16         DMA.DCHPRI[16].R              /* Channel n Priority Register */
#define DMA_DCHPRI17         DMA.DCHPRI[17].R              /* Channel n Priority Register */
#define DMA_DCHPRI18         DMA.DCHPRI[18].R              /* Channel n Priority Register */
#define DMA_DCHPRI19         DMA.DCHPRI[19].R              /* Channel n Priority Register */
#define DMA_DCHPRI20         DMA.DCHPRI[20].R              /* Channel n Priority Register */
#define DMA_DCHPRI21         DMA.DCHPRI[21].R              /* Channel n Priority Register */
#define DMA_DCHPRI22         DMA.DCHPRI[22].R              /* Channel n Priority Register */
#define DMA_DCHPRI23         DMA.DCHPRI[23].R              /* Channel n Priority Register */
#define DMA_DCHPRI24         DMA.DCHPRI[24].R              /* Channel n Priority Register */
#define DMA_DCHPRI25         DMA.DCHPRI[25].R              /* Channel n Priority Register */
#define DMA_DCHPRI26         DMA.DCHPRI[26].R              /* Channel n Priority Register */
#define DMA_DCHPRI27         DMA.DCHPRI[27].R              /* Channel n Priority Register */
#define DMA_DCHPRI28         DMA.DCHPRI[28].R              /* Channel n Priority Register */
#define DMA_DCHPRI29         DMA.DCHPRI[29].R              /* Channel n Priority Register */
#define DMA_DCHPRI30         DMA.DCHPRI[30].R              /* Channel n Priority Register */
#define DMA_DCHPRI31         DMA.DCHPRI[31].R              /* Channel n Priority Register */
#define DMA_DCHMID0          DMA.DCHMID[0].R               /* Channel n Master ID Register */
#define DMA_DCHMID1          DMA.DCHMID[1].R               /* Channel n Master ID Register */
#define DMA_DCHMID2          DMA.DCHMID[2].R               /* Channel n Master ID Register */
#define DMA_DCHMID3          DMA.DCHMID[3].R               /* Channel n Master ID Register */
#define DMA_DCHMID4          DMA.DCHMID[4].R               /* Channel n Master ID Register */
#define DMA_DCHMID5          DMA.DCHMID[5].R               /* Channel n Master ID Register */
#define DMA_DCHMID6          DMA.DCHMID[6].R               /* Channel n Master ID Register */
#define DMA_DCHMID7          DMA.DCHMID[7].R               /* Channel n Master ID Register */
#define DMA_DCHMID8          DMA.DCHMID[8].R               /* Channel n Master ID Register */
#define DMA_DCHMID9          DMA.DCHMID[9].R               /* Channel n Master ID Register */
#define DMA_DCHMID10         DMA.DCHMID[10].R              /* Channel n Master ID Register */
#define DMA_DCHMID11         DMA.DCHMID[11].R              /* Channel n Master ID Register */
#define DMA_DCHMID12         DMA.DCHMID[12].R              /* Channel n Master ID Register */
#define DMA_DCHMID13         DMA.DCHMID[13].R              /* Channel n Master ID Register */
#define DMA_DCHMID14         DMA.DCHMID[14].R              /* Channel n Master ID Register */
#define DMA_DCHMID15         DMA.DCHMID[15].R              /* Channel n Master ID Register */
#define DMA_DCHMID16         DMA.DCHMID[16].R              /* Channel n Master ID Register */
#define DMA_DCHMID17         DMA.DCHMID[17].R              /* Channel n Master ID Register */
#define DMA_DCHMID18         DMA.DCHMID[18].R              /* Channel n Master ID Register */
#define DMA_DCHMID19         DMA.DCHMID[19].R              /* Channel n Master ID Register */
#define DMA_DCHMID20         DMA.DCHMID[20].R              /* Channel n Master ID Register */
#define DMA_DCHMID21         DMA.DCHMID[21].R              /* Channel n Master ID Register */
#define DMA_DCHMID22         DMA.DCHMID[22].R              /* Channel n Master ID Register */
#define DMA_DCHMID23         DMA.DCHMID[23].R              /* Channel n Master ID Register */
#define DMA_DCHMID24         DMA.DCHMID[24].R              /* Channel n Master ID Register */
#define DMA_DCHMID25         DMA.DCHMID[25].R              /* Channel n Master ID Register */
#define DMA_DCHMID26         DMA.DCHMID[26].R              /* Channel n Master ID Register */
#define DMA_DCHMID27         DMA.DCHMID[27].R              /* Channel n Master ID Register */
#define DMA_DCHMID28         DMA.DCHMID[28].R              /* Channel n Master ID Register */
#define DMA_DCHMID29         DMA.DCHMID[29].R              /* Channel n Master ID Register */
#define DMA_DCHMID30         DMA.DCHMID[30].R              /* Channel n Master ID Register */
#define DMA_DCHMID31         DMA.DCHMID[31].R              /* Channel n Master ID Register */
#define DMA_TCD0_SADDR       DMA.TCD[0].SADDR.R            /* TCD Source Address */
#define DMA_TCD0_ATTR        DMA.TCD[0].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD0_SOFF        DMA.TCD[0].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD0_NBYTES_MLNO DMA.TCD[0].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD0_NBYTES_MLOFFNO DMA.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD0_NBYTES_MLOFFYES DMA.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD0_SLAST       DMA.TCD[0].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD0_DADDR       DMA.TCD[0].DADDR.R            /* TCD Destination Address */
#define DMA_TCD0_CITER_ELINKNO DMA.TCD[0].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_CITER_ELINKYES DMA.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_DOFF        DMA.TCD[0].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD0_DLASTSGA    DMA.TCD[0].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD0_BITER_ELINKNO DMA.TCD[0].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_BITER_ELINKYES DMA.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_CSR         DMA.TCD[0].CSR.R              /* TCD Control and Status */
#define DMA_TCD1_SADDR       DMA.TCD[1].SADDR.R            /* TCD Source Address */
#define DMA_TCD1_ATTR        DMA.TCD[1].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD1_SOFF        DMA.TCD[1].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD1_NBYTES_MLNO DMA.TCD[1].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD1_NBYTES_MLOFFNO DMA.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD1_NBYTES_MLOFFYES DMA.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD1_SLAST       DMA.TCD[1].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD1_DADDR       DMA.TCD[1].DADDR.R            /* TCD Destination Address */
#define DMA_TCD1_CITER_ELINKNO DMA.TCD[1].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_CITER_ELINKYES DMA.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_DOFF        DMA.TCD[1].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD1_DLASTSGA    DMA.TCD[1].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD1_BITER_ELINKNO DMA.TCD[1].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_BITER_ELINKYES DMA.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_CSR         DMA.TCD[1].CSR.R              /* TCD Control and Status */
#define DMA_TCD2_SADDR       DMA.TCD[2].SADDR.R            /* TCD Source Address */
#define DMA_TCD2_ATTR        DMA.TCD[2].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD2_SOFF        DMA.TCD[2].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD2_NBYTES_MLNO DMA.TCD[2].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD2_NBYTES_MLOFFNO DMA.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD2_NBYTES_MLOFFYES DMA.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD2_SLAST       DMA.TCD[2].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD2_DADDR       DMA.TCD[2].DADDR.R            /* TCD Destination Address */
#define DMA_TCD2_CITER_ELINKNO DMA.TCD[2].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_CITER_ELINKYES DMA.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_DOFF        DMA.TCD[2].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD2_DLASTSGA    DMA.TCD[2].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD2_BITER_ELINKNO DMA.TCD[2].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_BITER_ELINKYES DMA.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_CSR         DMA.TCD[2].CSR.R              /* TCD Control and Status */
#define DMA_TCD3_SADDR       DMA.TCD[3].SADDR.R            /* TCD Source Address */
#define DMA_TCD3_ATTR        DMA.TCD[3].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD3_SOFF        DMA.TCD[3].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD3_NBYTES_MLNO DMA.TCD[3].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD3_NBYTES_MLOFFNO DMA.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD3_NBYTES_MLOFFYES DMA.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD3_SLAST       DMA.TCD[3].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD3_DADDR       DMA.TCD[3].DADDR.R            /* TCD Destination Address */
#define DMA_TCD3_CITER_ELINKNO DMA.TCD[3].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_CITER_ELINKYES DMA.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_DOFF        DMA.TCD[3].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD3_DLASTSGA    DMA.TCD[3].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD3_BITER_ELINKNO DMA.TCD[3].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_BITER_ELINKYES DMA.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_CSR         DMA.TCD[3].CSR.R              /* TCD Control and Status */
#define DMA_TCD4_SADDR       DMA.TCD[4].SADDR.R            /* TCD Source Address */
#define DMA_TCD4_ATTR        DMA.TCD[4].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD4_SOFF        DMA.TCD[4].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD4_NBYTES_MLNO DMA.TCD[4].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD4_NBYTES_MLOFFNO DMA.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD4_NBYTES_MLOFFYES DMA.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD4_SLAST       DMA.TCD[4].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD4_DADDR       DMA.TCD[4].DADDR.R            /* TCD Destination Address */
#define DMA_TCD4_CITER_ELINKNO DMA.TCD[4].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_CITER_ELINKYES DMA.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_DOFF        DMA.TCD[4].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD4_DLASTSGA    DMA.TCD[4].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD4_BITER_ELINKNO DMA.TCD[4].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_BITER_ELINKYES DMA.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_CSR         DMA.TCD[4].CSR.R              /* TCD Control and Status */
#define DMA_TCD5_SADDR       DMA.TCD[5].SADDR.R            /* TCD Source Address */
#define DMA_TCD5_ATTR        DMA.TCD[5].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD5_SOFF        DMA.TCD[5].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD5_NBYTES_MLNO DMA.TCD[5].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD5_NBYTES_MLOFFNO DMA.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD5_NBYTES_MLOFFYES DMA.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD5_SLAST       DMA.TCD[5].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD5_DADDR       DMA.TCD[5].DADDR.R            /* TCD Destination Address */
#define DMA_TCD5_CITER_ELINKNO DMA.TCD[5].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_CITER_ELINKYES DMA.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_DOFF        DMA.TCD[5].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD5_DLASTSGA    DMA.TCD[5].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD5_BITER_ELINKNO DMA.TCD[5].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_BITER_ELINKYES DMA.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_CSR         DMA.TCD[5].CSR.R              /* TCD Control and Status */
#define DMA_TCD6_SADDR       DMA.TCD[6].SADDR.R            /* TCD Source Address */
#define DMA_TCD6_ATTR        DMA.TCD[6].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD6_SOFF        DMA.TCD[6].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD6_NBYTES_MLNO DMA.TCD[6].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD6_NBYTES_MLOFFNO DMA.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD6_NBYTES_MLOFFYES DMA.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD6_SLAST       DMA.TCD[6].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD6_DADDR       DMA.TCD[6].DADDR.R            /* TCD Destination Address */
#define DMA_TCD6_CITER_ELINKNO DMA.TCD[6].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_CITER_ELINKYES DMA.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_DOFF        DMA.TCD[6].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD6_DLASTSGA    DMA.TCD[6].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD6_BITER_ELINKNO DMA.TCD[6].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_BITER_ELINKYES DMA.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_CSR         DMA.TCD[6].CSR.R              /* TCD Control and Status */
#define DMA_TCD7_SADDR       DMA.TCD[7].SADDR.R            /* TCD Source Address */
#define DMA_TCD7_ATTR        DMA.TCD[7].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD7_SOFF        DMA.TCD[7].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD7_NBYTES_MLNO DMA.TCD[7].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD7_NBYTES_MLOFFNO DMA.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD7_NBYTES_MLOFFYES DMA.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD7_SLAST       DMA.TCD[7].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD7_DADDR       DMA.TCD[7].DADDR.R            /* TCD Destination Address */
#define DMA_TCD7_CITER_ELINKNO DMA.TCD[7].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_CITER_ELINKYES DMA.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_DOFF        DMA.TCD[7].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD7_DLASTSGA    DMA.TCD[7].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD7_BITER_ELINKNO DMA.TCD[7].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_BITER_ELINKYES DMA.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_CSR         DMA.TCD[7].CSR.R              /* TCD Control and Status */
#define DMA_TCD8_SADDR       DMA.TCD[8].SADDR.R            /* TCD Source Address */
#define DMA_TCD8_ATTR        DMA.TCD[8].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD8_SOFF        DMA.TCD[8].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD8_NBYTES_MLNO DMA.TCD[8].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD8_NBYTES_MLOFFNO DMA.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD8_NBYTES_MLOFFYES DMA.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD8_SLAST       DMA.TCD[8].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD8_DADDR       DMA.TCD[8].DADDR.R            /* TCD Destination Address */
#define DMA_TCD8_CITER_ELINKNO DMA.TCD[8].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_CITER_ELINKYES DMA.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_DOFF        DMA.TCD[8].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD8_DLASTSGA    DMA.TCD[8].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD8_BITER_ELINKNO DMA.TCD[8].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_BITER_ELINKYES DMA.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_CSR         DMA.TCD[8].CSR.R              /* TCD Control and Status */
#define DMA_TCD9_SADDR       DMA.TCD[9].SADDR.R            /* TCD Source Address */
#define DMA_TCD9_ATTR        DMA.TCD[9].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD9_SOFF        DMA.TCD[9].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD9_NBYTES_MLNO DMA.TCD[9].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD9_NBYTES_MLOFFNO DMA.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD9_NBYTES_MLOFFYES DMA.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD9_SLAST       DMA.TCD[9].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD9_DADDR       DMA.TCD[9].DADDR.R            /* TCD Destination Address */
#define DMA_TCD9_CITER_ELINKNO DMA.TCD[9].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_CITER_ELINKYES DMA.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_DOFF        DMA.TCD[9].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD9_DLASTSGA    DMA.TCD[9].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD9_BITER_ELINKNO DMA.TCD[9].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_BITER_ELINKYES DMA.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_CSR         DMA.TCD[9].CSR.R              /* TCD Control and Status */
#define DMA_TCD10_SADDR      DMA.TCD[10].SADDR.R           /* TCD Source Address */
#define DMA_TCD10_ATTR       DMA.TCD[10].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD10_SOFF       DMA.TCD[10].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD10_NBYTES_MLNO DMA.TCD[10].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD10_NBYTES_MLOFFNO DMA.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD10_NBYTES_MLOFFYES DMA.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD10_SLAST      DMA.TCD[10].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD10_DADDR      DMA.TCD[10].DADDR.R           /* TCD Destination Address */
#define DMA_TCD10_CITER_ELINKNO DMA.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_CITER_ELINKYES DMA.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_DOFF       DMA.TCD[10].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD10_DLASTSGA   DMA.TCD[10].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD10_BITER_ELINKNO DMA.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_BITER_ELINKYES DMA.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_CSR        DMA.TCD[10].CSR.R             /* TCD Control and Status */
#define DMA_TCD11_SADDR      DMA.TCD[11].SADDR.R           /* TCD Source Address */
#define DMA_TCD11_ATTR       DMA.TCD[11].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD11_SOFF       DMA.TCD[11].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD11_NBYTES_MLNO DMA.TCD[11].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD11_NBYTES_MLOFFNO DMA.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD11_NBYTES_MLOFFYES DMA.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD11_SLAST      DMA.TCD[11].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD11_DADDR      DMA.TCD[11].DADDR.R           /* TCD Destination Address */
#define DMA_TCD11_CITER_ELINKNO DMA.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_CITER_ELINKYES DMA.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_DOFF       DMA.TCD[11].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD11_DLASTSGA   DMA.TCD[11].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD11_BITER_ELINKNO DMA.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_BITER_ELINKYES DMA.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_CSR        DMA.TCD[11].CSR.R             /* TCD Control and Status */
#define DMA_TCD12_SADDR      DMA.TCD[12].SADDR.R           /* TCD Source Address */
#define DMA_TCD12_ATTR       DMA.TCD[12].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD12_SOFF       DMA.TCD[12].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD12_NBYTES_MLNO DMA.TCD[12].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD12_NBYTES_MLOFFNO DMA.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD12_NBYTES_MLOFFYES DMA.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD12_SLAST      DMA.TCD[12].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD12_DADDR      DMA.TCD[12].DADDR.R           /* TCD Destination Address */
#define DMA_TCD12_CITER_ELINKNO DMA.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_CITER_ELINKYES DMA.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_DOFF       DMA.TCD[12].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD12_DLASTSGA   DMA.TCD[12].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD12_BITER_ELINKNO DMA.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_BITER_ELINKYES DMA.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_CSR        DMA.TCD[12].CSR.R             /* TCD Control and Status */
#define DMA_TCD13_SADDR      DMA.TCD[13].SADDR.R           /* TCD Source Address */
#define DMA_TCD13_ATTR       DMA.TCD[13].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD13_SOFF       DMA.TCD[13].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD13_NBYTES_MLNO DMA.TCD[13].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD13_NBYTES_MLOFFNO DMA.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD13_NBYTES_MLOFFYES DMA.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD13_SLAST      DMA.TCD[13].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD13_DADDR      DMA.TCD[13].DADDR.R           /* TCD Destination Address */
#define DMA_TCD13_CITER_ELINKNO DMA.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_CITER_ELINKYES DMA.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_DOFF       DMA.TCD[13].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD13_DLASTSGA   DMA.TCD[13].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD13_BITER_ELINKNO DMA.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_BITER_ELINKYES DMA.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_CSR        DMA.TCD[13].CSR.R             /* TCD Control and Status */
#define DMA_TCD14_SADDR      DMA.TCD[14].SADDR.R           /* TCD Source Address */
#define DMA_TCD14_ATTR       DMA.TCD[14].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD14_SOFF       DMA.TCD[14].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD14_NBYTES_MLNO DMA.TCD[14].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD14_NBYTES_MLOFFNO DMA.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD14_NBYTES_MLOFFYES DMA.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD14_SLAST      DMA.TCD[14].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD14_DADDR      DMA.TCD[14].DADDR.R           /* TCD Destination Address */
#define DMA_TCD14_CITER_ELINKNO DMA.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_CITER_ELINKYES DMA.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_DOFF       DMA.TCD[14].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD14_DLASTSGA   DMA.TCD[14].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD14_BITER_ELINKNO DMA.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_BITER_ELINKYES DMA.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_CSR        DMA.TCD[14].CSR.R             /* TCD Control and Status */
#define DMA_TCD15_SADDR      DMA.TCD[15].SADDR.R           /* TCD Source Address */
#define DMA_TCD15_ATTR       DMA.TCD[15].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD15_SOFF       DMA.TCD[15].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD15_NBYTES_MLNO DMA.TCD[15].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD15_NBYTES_MLOFFNO DMA.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD15_NBYTES_MLOFFYES DMA.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD15_SLAST      DMA.TCD[15].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD15_DADDR      DMA.TCD[15].DADDR.R           /* TCD Destination Address */
#define DMA_TCD15_CITER_ELINKNO DMA.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD15_CITER_ELINKYES DMA.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD15_DOFF       DMA.TCD[15].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD15_DLASTSGA   DMA.TCD[15].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD15_BITER_ELINKNO DMA.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD15_BITER_ELINKYES DMA.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD15_CSR        DMA.TCD[15].CSR.R             /* TCD Control and Status */
#define DMA_TCD16_SADDR      DMA.TCD[16].SADDR.R           /* TCD Source Address */
#define DMA_TCD16_ATTR       DMA.TCD[16].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD16_SOFF       DMA.TCD[16].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD16_NBYTES_MLNO DMA.TCD[16].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD16_NBYTES_MLOFFNO DMA.TCD[16].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD16_NBYTES_MLOFFYES DMA.TCD[16].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD16_SLAST      DMA.TCD[16].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD16_DADDR      DMA.TCD[16].DADDR.R           /* TCD Destination Address */
#define DMA_TCD16_CITER_ELINKNO DMA.TCD[16].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD16_CITER_ELINKYES DMA.TCD[16].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD16_DOFF       DMA.TCD[16].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD16_DLASTSGA   DMA.TCD[16].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD16_BITER_ELINKNO DMA.TCD[16].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD16_BITER_ELINKYES DMA.TCD[16].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD16_CSR        DMA.TCD[16].CSR.R             /* TCD Control and Status */
#define DMA_TCD17_SADDR      DMA.TCD[17].SADDR.R           /* TCD Source Address */
#define DMA_TCD17_ATTR       DMA.TCD[17].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD17_SOFF       DMA.TCD[17].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD17_NBYTES_MLNO DMA.TCD[17].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD17_NBYTES_MLOFFNO DMA.TCD[17].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD17_NBYTES_MLOFFYES DMA.TCD[17].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD17_SLAST      DMA.TCD[17].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD17_DADDR      DMA.TCD[17].DADDR.R           /* TCD Destination Address */
#define DMA_TCD17_CITER_ELINKNO DMA.TCD[17].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD17_CITER_ELINKYES DMA.TCD[17].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD17_DOFF       DMA.TCD[17].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD17_DLASTSGA   DMA.TCD[17].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD17_BITER_ELINKNO DMA.TCD[17].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD17_BITER_ELINKYES DMA.TCD[17].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD17_CSR        DMA.TCD[17].CSR.R             /* TCD Control and Status */
#define DMA_TCD18_SADDR      DMA.TCD[18].SADDR.R           /* TCD Source Address */
#define DMA_TCD18_ATTR       DMA.TCD[18].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD18_SOFF       DMA.TCD[18].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD18_NBYTES_MLNO DMA.TCD[18].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD18_NBYTES_MLOFFNO DMA.TCD[18].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD18_NBYTES_MLOFFYES DMA.TCD[18].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD18_SLAST      DMA.TCD[18].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD18_DADDR      DMA.TCD[18].DADDR.R           /* TCD Destination Address */
#define DMA_TCD18_CITER_ELINKNO DMA.TCD[18].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD18_CITER_ELINKYES DMA.TCD[18].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD18_DOFF       DMA.TCD[18].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD18_DLASTSGA   DMA.TCD[18].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD18_BITER_ELINKNO DMA.TCD[18].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD18_BITER_ELINKYES DMA.TCD[18].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD18_CSR        DMA.TCD[18].CSR.R             /* TCD Control and Status */
#define DMA_TCD19_SADDR      DMA.TCD[19].SADDR.R           /* TCD Source Address */
#define DMA_TCD19_ATTR       DMA.TCD[19].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD19_SOFF       DMA.TCD[19].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD19_NBYTES_MLNO DMA.TCD[19].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD19_NBYTES_MLOFFNO DMA.TCD[19].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD19_NBYTES_MLOFFYES DMA.TCD[19].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD19_SLAST      DMA.TCD[19].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD19_DADDR      DMA.TCD[19].DADDR.R           /* TCD Destination Address */
#define DMA_TCD19_CITER_ELINKNO DMA.TCD[19].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD19_CITER_ELINKYES DMA.TCD[19].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD19_DOFF       DMA.TCD[19].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD19_DLASTSGA   DMA.TCD[19].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD19_BITER_ELINKNO DMA.TCD[19].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD19_BITER_ELINKYES DMA.TCD[19].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD19_CSR        DMA.TCD[19].CSR.R             /* TCD Control and Status */
#define DMA_TCD20_SADDR      DMA.TCD[20].SADDR.R           /* TCD Source Address */
#define DMA_TCD20_ATTR       DMA.TCD[20].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD20_SOFF       DMA.TCD[20].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD20_NBYTES_MLNO DMA.TCD[20].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD20_NBYTES_MLOFFNO DMA.TCD[20].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD20_NBYTES_MLOFFYES DMA.TCD[20].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD20_SLAST      DMA.TCD[20].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD20_DADDR      DMA.TCD[20].DADDR.R           /* TCD Destination Address */
#define DMA_TCD20_CITER_ELINKNO DMA.TCD[20].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD20_CITER_ELINKYES DMA.TCD[20].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD20_DOFF       DMA.TCD[20].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD20_DLASTSGA   DMA.TCD[20].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD20_BITER_ELINKNO DMA.TCD[20].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD20_BITER_ELINKYES DMA.TCD[20].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD20_CSR        DMA.TCD[20].CSR.R             /* TCD Control and Status */
#define DMA_TCD21_SADDR      DMA.TCD[21].SADDR.R           /* TCD Source Address */
#define DMA_TCD21_ATTR       DMA.TCD[21].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD21_SOFF       DMA.TCD[21].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD21_NBYTES_MLNO DMA.TCD[21].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD21_NBYTES_MLOFFNO DMA.TCD[21].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD21_NBYTES_MLOFFYES DMA.TCD[21].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD21_SLAST      DMA.TCD[21].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD21_DADDR      DMA.TCD[21].DADDR.R           /* TCD Destination Address */
#define DMA_TCD21_CITER_ELINKNO DMA.TCD[21].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD21_CITER_ELINKYES DMA.TCD[21].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD21_DOFF       DMA.TCD[21].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD21_DLASTSGA   DMA.TCD[21].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD21_BITER_ELINKNO DMA.TCD[21].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD21_BITER_ELINKYES DMA.TCD[21].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD21_CSR        DMA.TCD[21].CSR.R             /* TCD Control and Status */
#define DMA_TCD22_SADDR      DMA.TCD[22].SADDR.R           /* TCD Source Address */
#define DMA_TCD22_ATTR       DMA.TCD[22].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD22_SOFF       DMA.TCD[22].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD22_NBYTES_MLNO DMA.TCD[22].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD22_NBYTES_MLOFFNO DMA.TCD[22].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD22_NBYTES_MLOFFYES DMA.TCD[22].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD22_SLAST      DMA.TCD[22].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD22_DADDR      DMA.TCD[22].DADDR.R           /* TCD Destination Address */
#define DMA_TCD22_CITER_ELINKNO DMA.TCD[22].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD22_CITER_ELINKYES DMA.TCD[22].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD22_DOFF       DMA.TCD[22].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD22_DLASTSGA   DMA.TCD[22].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD22_BITER_ELINKNO DMA.TCD[22].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD22_BITER_ELINKYES DMA.TCD[22].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD22_CSR        DMA.TCD[22].CSR.R             /* TCD Control and Status */
#define DMA_TCD23_SADDR      DMA.TCD[23].SADDR.R           /* TCD Source Address */
#define DMA_TCD23_ATTR       DMA.TCD[23].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD23_SOFF       DMA.TCD[23].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD23_NBYTES_MLNO DMA.TCD[23].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD23_NBYTES_MLOFFNO DMA.TCD[23].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD23_NBYTES_MLOFFYES DMA.TCD[23].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD23_SLAST      DMA.TCD[23].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD23_DADDR      DMA.TCD[23].DADDR.R           /* TCD Destination Address */
#define DMA_TCD23_CITER_ELINKNO DMA.TCD[23].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD23_CITER_ELINKYES DMA.TCD[23].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD23_DOFF       DMA.TCD[23].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD23_DLASTSGA   DMA.TCD[23].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD23_BITER_ELINKNO DMA.TCD[23].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD23_BITER_ELINKYES DMA.TCD[23].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD23_CSR        DMA.TCD[23].CSR.R             /* TCD Control and Status */
#define DMA_TCD24_SADDR      DMA.TCD[24].SADDR.R           /* TCD Source Address */
#define DMA_TCD24_ATTR       DMA.TCD[24].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD24_SOFF       DMA.TCD[24].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD24_NBYTES_MLNO DMA.TCD[24].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD24_NBYTES_MLOFFNO DMA.TCD[24].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD24_NBYTES_MLOFFYES DMA.TCD[24].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD24_SLAST      DMA.TCD[24].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD24_DADDR      DMA.TCD[24].DADDR.R           /* TCD Destination Address */
#define DMA_TCD24_CITER_ELINKNO DMA.TCD[24].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD24_CITER_ELINKYES DMA.TCD[24].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD24_DOFF       DMA.TCD[24].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD24_DLASTSGA   DMA.TCD[24].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD24_BITER_ELINKNO DMA.TCD[24].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD24_BITER_ELINKYES DMA.TCD[24].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD24_CSR        DMA.TCD[24].CSR.R             /* TCD Control and Status */
#define DMA_TCD25_SADDR      DMA.TCD[25].SADDR.R           /* TCD Source Address */
#define DMA_TCD25_ATTR       DMA.TCD[25].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD25_SOFF       DMA.TCD[25].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD25_NBYTES_MLNO DMA.TCD[25].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD25_NBYTES_MLOFFNO DMA.TCD[25].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD25_NBYTES_MLOFFYES DMA.TCD[25].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD25_SLAST      DMA.TCD[25].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD25_DADDR      DMA.TCD[25].DADDR.R           /* TCD Destination Address */
#define DMA_TCD25_CITER_ELINKNO DMA.TCD[25].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD25_CITER_ELINKYES DMA.TCD[25].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD25_DOFF       DMA.TCD[25].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD25_DLASTSGA   DMA.TCD[25].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD25_BITER_ELINKNO DMA.TCD[25].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD25_BITER_ELINKYES DMA.TCD[25].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD25_CSR        DMA.TCD[25].CSR.R             /* TCD Control and Status */
#define DMA_TCD26_SADDR      DMA.TCD[26].SADDR.R           /* TCD Source Address */
#define DMA_TCD26_ATTR       DMA.TCD[26].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD26_SOFF       DMA.TCD[26].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD26_NBYTES_MLNO DMA.TCD[26].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD26_NBYTES_MLOFFNO DMA.TCD[26].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD26_NBYTES_MLOFFYES DMA.TCD[26].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD26_SLAST      DMA.TCD[26].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD26_DADDR      DMA.TCD[26].DADDR.R           /* TCD Destination Address */
#define DMA_TCD26_CITER_ELINKNO DMA.TCD[26].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD26_CITER_ELINKYES DMA.TCD[26].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD26_DOFF       DMA.TCD[26].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD26_DLASTSGA   DMA.TCD[26].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD26_BITER_ELINKNO DMA.TCD[26].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD26_BITER_ELINKYES DMA.TCD[26].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD26_CSR        DMA.TCD[26].CSR.R             /* TCD Control and Status */
#define DMA_TCD27_SADDR      DMA.TCD[27].SADDR.R           /* TCD Source Address */
#define DMA_TCD27_ATTR       DMA.TCD[27].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD27_SOFF       DMA.TCD[27].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD27_NBYTES_MLNO DMA.TCD[27].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD27_NBYTES_MLOFFNO DMA.TCD[27].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD27_NBYTES_MLOFFYES DMA.TCD[27].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD27_SLAST      DMA.TCD[27].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD27_DADDR      DMA.TCD[27].DADDR.R           /* TCD Destination Address */
#define DMA_TCD27_CITER_ELINKNO DMA.TCD[27].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD27_CITER_ELINKYES DMA.TCD[27].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD27_DOFF       DMA.TCD[27].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD27_DLASTSGA   DMA.TCD[27].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD27_BITER_ELINKNO DMA.TCD[27].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD27_BITER_ELINKYES DMA.TCD[27].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD27_CSR        DMA.TCD[27].CSR.R             /* TCD Control and Status */
#define DMA_TCD28_SADDR      DMA.TCD[28].SADDR.R           /* TCD Source Address */
#define DMA_TCD28_ATTR       DMA.TCD[28].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD28_SOFF       DMA.TCD[28].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD28_NBYTES_MLNO DMA.TCD[28].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD28_NBYTES_MLOFFNO DMA.TCD[28].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD28_NBYTES_MLOFFYES DMA.TCD[28].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD28_SLAST      DMA.TCD[28].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD28_DADDR      DMA.TCD[28].DADDR.R           /* TCD Destination Address */
#define DMA_TCD28_CITER_ELINKNO DMA.TCD[28].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD28_CITER_ELINKYES DMA.TCD[28].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD28_DOFF       DMA.TCD[28].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD28_DLASTSGA   DMA.TCD[28].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD28_BITER_ELINKNO DMA.TCD[28].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD28_BITER_ELINKYES DMA.TCD[28].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD28_CSR        DMA.TCD[28].CSR.R             /* TCD Control and Status */
#define DMA_TCD29_SADDR      DMA.TCD[29].SADDR.R           /* TCD Source Address */
#define DMA_TCD29_ATTR       DMA.TCD[29].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD29_SOFF       DMA.TCD[29].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD29_NBYTES_MLNO DMA.TCD[29].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD29_NBYTES_MLOFFNO DMA.TCD[29].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD29_NBYTES_MLOFFYES DMA.TCD[29].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD29_SLAST      DMA.TCD[29].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD29_DADDR      DMA.TCD[29].DADDR.R           /* TCD Destination Address */
#define DMA_TCD29_CITER_ELINKNO DMA.TCD[29].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD29_CITER_ELINKYES DMA.TCD[29].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD29_DOFF       DMA.TCD[29].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD29_DLASTSGA   DMA.TCD[29].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD29_BITER_ELINKNO DMA.TCD[29].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD29_BITER_ELINKYES DMA.TCD[29].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD29_CSR        DMA.TCD[29].CSR.R             /* TCD Control and Status */
#define DMA_TCD30_SADDR      DMA.TCD[30].SADDR.R           /* TCD Source Address */
#define DMA_TCD30_ATTR       DMA.TCD[30].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD30_SOFF       DMA.TCD[30].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD30_NBYTES_MLNO DMA.TCD[30].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD30_NBYTES_MLOFFNO DMA.TCD[30].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD30_NBYTES_MLOFFYES DMA.TCD[30].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD30_SLAST      DMA.TCD[30].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD30_DADDR      DMA.TCD[30].DADDR.R           /* TCD Destination Address */
#define DMA_TCD30_CITER_ELINKNO DMA.TCD[30].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD30_CITER_ELINKYES DMA.TCD[30].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD30_DOFF       DMA.TCD[30].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD30_DLASTSGA   DMA.TCD[30].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD30_BITER_ELINKNO DMA.TCD[30].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD30_BITER_ELINKYES DMA.TCD[30].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD30_CSR        DMA.TCD[30].CSR.R             /* TCD Control and Status */
#define DMA_TCD31_SADDR      DMA.TCD[31].SADDR.R           /* TCD Source Address */
#define DMA_TCD31_ATTR       DMA.TCD[31].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD31_SOFF       DMA.TCD[31].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD31_NBYTES_MLNO DMA.TCD[31].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD31_NBYTES_MLOFFNO DMA.TCD[31].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_TCD31_NBYTES_MLOFFYES DMA.TCD[31].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_TCD31_SLAST      DMA.TCD[31].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD31_DADDR      DMA.TCD[31].DADDR.R           /* TCD Destination Address */
#define DMA_TCD31_CITER_ELINKNO DMA.TCD[31].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD31_CITER_ELINKYES DMA.TCD[31].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD31_DOFF       DMA.TCD[31].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD31_DLASTSGA   DMA.TCD[31].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD31_BITER_ELINKNO DMA.TCD[31].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD31_BITER_ELINKYES DMA.TCD[31].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD31_CSR        DMA.TCD[31].CSR.R             /* TCD Control and Status */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* EIM */
#define EIM_EIMCR            EIM.EIMCR.R                   /* Error Injection Module Configuration Register */
#define EIM_EICHEN           EIM.EICHEN.R                  /* Error Injection Channel Enable register */
#define EIM_EICHD0_WORD0     EIM.EICHD_WORD0[0].R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD0_WORD1     EIM.EICHD_WORD1[0].R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD0_WORD2     EIM.EICHD_WORD2[0].R          /* Error Injection Channel Descriptor, Word2 */

/* ETIMER */
#define ETIMER_1_CH0_COMP1   ETIMER_1.CH[0].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH0_COMP2   ETIMER_1.CH[0].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH0_CAPT1   ETIMER_1.CH[0].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH0_CAPT2   ETIMER_1.CH[0].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH0_LOAD    ETIMER_1.CH[0].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH0_HOLD    ETIMER_1.CH[0].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH0_CNTR    ETIMER_1.CH[0].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH0_CTRL1   ETIMER_1.CH[0].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH0_CTRL2   ETIMER_1.CH[0].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH0_CTRL3   ETIMER_1.CH[0].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH0_STS     ETIMER_1.CH[0].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH0_INTDMA  ETIMER_1.CH[0].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH0_CMPLD1  ETIMER_1.CH[0].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH0_CMPLD2  ETIMER_1.CH[0].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH0_CCCTRL  ETIMER_1.CH[0].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH0_FILT    ETIMER_1.CH[0].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH1_COMP1   ETIMER_1.CH[1].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH1_COMP2   ETIMER_1.CH[1].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH1_CAPT1   ETIMER_1.CH[1].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH1_CAPT2   ETIMER_1.CH[1].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH1_LOAD    ETIMER_1.CH[1].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH1_HOLD    ETIMER_1.CH[1].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH1_CNTR    ETIMER_1.CH[1].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH1_CTRL1   ETIMER_1.CH[1].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH1_CTRL2   ETIMER_1.CH[1].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH1_CTRL3   ETIMER_1.CH[1].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH1_STS     ETIMER_1.CH[1].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH1_INTDMA  ETIMER_1.CH[1].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH1_CMPLD1  ETIMER_1.CH[1].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH1_CMPLD2  ETIMER_1.CH[1].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH1_CCCTRL  ETIMER_1.CH[1].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH1_FILT    ETIMER_1.CH[1].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH2_COMP1   ETIMER_1.CH[2].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH2_COMP2   ETIMER_1.CH[2].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH2_CAPT1   ETIMER_1.CH[2].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH2_CAPT2   ETIMER_1.CH[2].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH2_LOAD    ETIMER_1.CH[2].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH2_HOLD    ETIMER_1.CH[2].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH2_CNTR    ETIMER_1.CH[2].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH2_CTRL1   ETIMER_1.CH[2].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH2_CTRL2   ETIMER_1.CH[2].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH2_CTRL3   ETIMER_1.CH[2].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH2_STS     ETIMER_1.CH[2].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH2_INTDMA  ETIMER_1.CH[2].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH2_CMPLD1  ETIMER_1.CH[2].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH2_CMPLD2  ETIMER_1.CH[2].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH2_CCCTRL  ETIMER_1.CH[2].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH2_FILT    ETIMER_1.CH[2].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH3_COMP1   ETIMER_1.CH[3].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH3_COMP2   ETIMER_1.CH[3].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH3_CAPT1   ETIMER_1.CH[3].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH3_CAPT2   ETIMER_1.CH[3].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH3_LOAD    ETIMER_1.CH[3].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH3_HOLD    ETIMER_1.CH[3].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH3_CNTR    ETIMER_1.CH[3].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH3_CTRL1   ETIMER_1.CH[3].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH3_CTRL2   ETIMER_1.CH[3].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH3_CTRL3   ETIMER_1.CH[3].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH3_STS     ETIMER_1.CH[3].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH3_INTDMA  ETIMER_1.CH[3].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH3_CMPLD1  ETIMER_1.CH[3].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH3_CMPLD2  ETIMER_1.CH[3].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH3_CCCTRL  ETIMER_1.CH[3].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH3_FILT    ETIMER_1.CH[3].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH4_COMP1   ETIMER_1.CH[4].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH4_COMP2   ETIMER_1.CH[4].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH4_CAPT1   ETIMER_1.CH[4].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH4_CAPT2   ETIMER_1.CH[4].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH4_LOAD    ETIMER_1.CH[4].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH4_HOLD    ETIMER_1.CH[4].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH4_CNTR    ETIMER_1.CH[4].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH4_CTRL1   ETIMER_1.CH[4].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH4_CTRL2   ETIMER_1.CH[4].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH4_CTRL3   ETIMER_1.CH[4].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH4_STS     ETIMER_1.CH[4].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH4_INTDMA  ETIMER_1.CH[4].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH4_CMPLD1  ETIMER_1.CH[4].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH4_CMPLD2  ETIMER_1.CH[4].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH4_CCCTRL  ETIMER_1.CH[4].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH4_FILT    ETIMER_1.CH[4].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH5_COMP1   ETIMER_1.CH[5].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH5_COMP2   ETIMER_1.CH[5].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH5_CAPT1   ETIMER_1.CH[5].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH5_CAPT2   ETIMER_1.CH[5].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH5_LOAD    ETIMER_1.CH[5].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH5_HOLD    ETIMER_1.CH[5].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH5_CNTR    ETIMER_1.CH[5].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH5_CTRL1   ETIMER_1.CH[5].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH5_CTRL2   ETIMER_1.CH[5].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH5_CTRL3   ETIMER_1.CH[5].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH5_STS     ETIMER_1.CH[5].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH5_INTDMA  ETIMER_1.CH[5].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH5_CMPLD1  ETIMER_1.CH[5].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH5_CMPLD2  ETIMER_1.CH[5].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH5_CCCTRL  ETIMER_1.CH[5].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH5_FILT    ETIMER_1.CH[5].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH6_COMP1   ETIMER_1.CH[6].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH6_COMP2   ETIMER_1.CH[6].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH6_CAPT1   ETIMER_1.CH[6].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH6_CAPT2   ETIMER_1.CH[6].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH6_LOAD    ETIMER_1.CH[6].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH6_HOLD    ETIMER_1.CH[6].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH6_CNTR    ETIMER_1.CH[6].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH6_CTRL1   ETIMER_1.CH[6].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH6_CTRL2   ETIMER_1.CH[6].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH6_CTRL3   ETIMER_1.CH[6].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH6_STS     ETIMER_1.CH[6].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH6_INTDMA  ETIMER_1.CH[6].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH6_CMPLD1  ETIMER_1.CH[6].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH6_CMPLD2  ETIMER_1.CH[6].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH6_CCCTRL  ETIMER_1.CH[6].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH6_FILT    ETIMER_1.CH[6].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH7_COMP1   ETIMER_1.CH[7].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH7_COMP2   ETIMER_1.CH[7].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH7_CAPT1   ETIMER_1.CH[7].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH7_CAPT2   ETIMER_1.CH[7].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH7_LOAD    ETIMER_1.CH[7].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH7_HOLD    ETIMER_1.CH[7].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH7_CNTR    ETIMER_1.CH[7].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH7_CTRL1   ETIMER_1.CH[7].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH7_CTRL2   ETIMER_1.CH[7].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH7_CTRL3   ETIMER_1.CH[7].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH7_STS     ETIMER_1.CH[7].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH7_INTDMA  ETIMER_1.CH[7].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH7_CMPLD1  ETIMER_1.CH[7].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH7_CMPLD2  ETIMER_1.CH[7].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH7_CCCTRL  ETIMER_1.CH[7].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH7_FILT    ETIMER_1.CH[7].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_ENBL        ETIMER_1.ENBL.R               /* Channel Enable Register */
#define ETIMER_1_DREQ0       ETIMER_1.DREQ0.R              /* DMA Request 0 Select Register */
#define ETIMER_1_DREQ1       ETIMER_1.DREQ1.R              /* DMA Request 1 Select Register */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* Control Key */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* Noncritical Fault Configuration */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* Noncritical Fault Configuration */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* Noncritical Fault Configuration */
#define FCCU_NCF_CFG3        FCCU.NCF_CFG[3].R             /* Noncritical Fault Configuration */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG5       FCCU.NCFS_CFG[5].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG6       FCCU.NCFS_CFG[6].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG7       FCCU.NCFS_CFG[7].R            /* Noncritical Fault State Configuration */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* Noncritical Fault Status */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* Noncritical Fault Status */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* Noncritical Fault Status */
#define FCCU_NCF_S3          FCCU.NCF_S[3].R               /* Noncritical Fault Status */
#define FCCU_NCFK            FCCU.NCFK.R                   /* Noncritical Fault Key */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* Noncritical Fault Enable */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* Noncritical Fault Enable */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* Noncritical Fault Enable */
#define FCCU_NCF_E3          FCCU.NCF_E[3].R               /* Noncritical Fault Enable */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TOE3        FCCU.NCF_TOE[3].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* Noncritical Fault Timeout */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* Configuration-State Timer Interval */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control */
#define FCCU_STAT            FCCU.STAT.R                   /* Status */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status */
#define FCCU_NCFF            FCCU.NCFF.R                   /* Noncritical Fault Fake */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR */
#define FCCU_MCS             FCCU.MCS.R                    /* Mode Controller Status */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Configuration Lock */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Configuration Lock */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable */
#define FCCU_IRQ_ALARM_EN3   FCCU.IRQ_ALARM_EN[3].R        /* IRQ Alarm Enable */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable */
#define FCCU_NMI_EN3         FCCU.NMI_EN[3].R              /* NMI Enable */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* Bistable Fault-Output (EOUT) Mode Signaling Enable */
#define FCCU_EOUT_SIG_EN3    FCCU.EOUT_SIG_EN[3].R         /* Bistable Fault-Output (EOUT) Mode Signaling Enable */

/* FlexPWM */
#define FlexPWM_0_SUB0_CNT   FlexPWM_0.SUB[0].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB0_INIT  FlexPWM_0.SUB[0].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB0_CTRL2 FlexPWM_0.SUB[0].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB0_CTRL1 FlexPWM_0.SUB[0].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB0_VAL0  FlexPWM_0.SUB[0].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB0_VAL1  FlexPWM_0.SUB[0].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB0_VAL2  FlexPWM_0.SUB[0].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB0_VAL3  FlexPWM_0.SUB[0].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB0_VAL4  FlexPWM_0.SUB[0].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB0_VAL5  FlexPWM_0.SUB[0].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB0_OCTRL FlexPWM_0.SUB[0].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB0_STS   FlexPWM_0.SUB[0].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB0_INTEN FlexPWM_0.SUB[0].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB0_DMAEN FlexPWM_0.SUB[0].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB0_TCTRL FlexPWM_0.SUB[0].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB0_DISMAP FlexPWM_0.SUB[0].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB0_DTCNT0 FlexPWM_0.SUB[0].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB0_DTCNT1 FlexPWM_0.SUB[0].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB0_CAPTCTRLX FlexPWM_0.SUB[0].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB0_CAPTCMPX FlexPWM_0.SUB[0].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB0_CVAL0 FlexPWM_0.SUB[0].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB0_CVAL0CYC FlexPWM_0.SUB[0].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB0_CVAL1 FlexPWM_0.SUB[0].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB0_CVAL1CYC FlexPWM_0.SUB[0].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB1_CNT   FlexPWM_0.SUB[1].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB1_INIT  FlexPWM_0.SUB[1].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB1_CTRL2 FlexPWM_0.SUB[1].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB1_CTRL1 FlexPWM_0.SUB[1].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB1_VAL0  FlexPWM_0.SUB[1].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB1_VAL1  FlexPWM_0.SUB[1].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB1_VAL2  FlexPWM_0.SUB[1].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB1_VAL3  FlexPWM_0.SUB[1].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB1_VAL4  FlexPWM_0.SUB[1].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB1_VAL5  FlexPWM_0.SUB[1].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB1_OCTRL FlexPWM_0.SUB[1].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB1_STS   FlexPWM_0.SUB[1].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB1_INTEN FlexPWM_0.SUB[1].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB1_DMAEN FlexPWM_0.SUB[1].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB1_TCTRL FlexPWM_0.SUB[1].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB1_DISMAP FlexPWM_0.SUB[1].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB1_DTCNT0 FlexPWM_0.SUB[1].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB1_DTCNT1 FlexPWM_0.SUB[1].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB1_CAPTCTRLX FlexPWM_0.SUB[1].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB1_CAPTCMPX FlexPWM_0.SUB[1].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB1_CVAL0 FlexPWM_0.SUB[1].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB1_CVAL0CYC FlexPWM_0.SUB[1].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB1_CVAL1 FlexPWM_0.SUB[1].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB1_CVAL1CYC FlexPWM_0.SUB[1].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB2_CNT   FlexPWM_0.SUB[2].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB2_INIT  FlexPWM_0.SUB[2].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB2_CTRL2 FlexPWM_0.SUB[2].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB2_CTRL1 FlexPWM_0.SUB[2].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB2_VAL0  FlexPWM_0.SUB[2].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB2_VAL1  FlexPWM_0.SUB[2].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB2_VAL2  FlexPWM_0.SUB[2].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB2_VAL3  FlexPWM_0.SUB[2].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB2_VAL4  FlexPWM_0.SUB[2].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB2_VAL5  FlexPWM_0.SUB[2].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB2_OCTRL FlexPWM_0.SUB[2].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB2_STS   FlexPWM_0.SUB[2].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB2_INTEN FlexPWM_0.SUB[2].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB2_DMAEN FlexPWM_0.SUB[2].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB2_TCTRL FlexPWM_0.SUB[2].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB2_DISMAP FlexPWM_0.SUB[2].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB2_DTCNT0 FlexPWM_0.SUB[2].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB2_DTCNT1 FlexPWM_0.SUB[2].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB2_CAPTCTRLX FlexPWM_0.SUB[2].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB2_CAPTCMPX FlexPWM_0.SUB[2].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB2_CVAL0 FlexPWM_0.SUB[2].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB2_CVAL0CYC FlexPWM_0.SUB[2].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB2_CVAL1 FlexPWM_0.SUB[2].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB2_CVAL1CYC FlexPWM_0.SUB[2].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB3_CNT   FlexPWM_0.SUB[3].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB3_INIT  FlexPWM_0.SUB[3].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB3_CTRL2 FlexPWM_0.SUB[3].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB3_CTRL1 FlexPWM_0.SUB[3].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB3_VAL0  FlexPWM_0.SUB[3].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB3_VAL1  FlexPWM_0.SUB[3].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB3_VAL2  FlexPWM_0.SUB[3].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB3_VAL3  FlexPWM_0.SUB[3].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB3_VAL4  FlexPWM_0.SUB[3].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB3_VAL5  FlexPWM_0.SUB[3].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB3_OCTRL FlexPWM_0.SUB[3].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB3_STS   FlexPWM_0.SUB[3].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB3_INTEN FlexPWM_0.SUB[3].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB3_DMAEN FlexPWM_0.SUB[3].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB3_TCTRL FlexPWM_0.SUB[3].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB3_DISMAP FlexPWM_0.SUB[3].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB3_DTCNT0 FlexPWM_0.SUB[3].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB3_DTCNT1 FlexPWM_0.SUB[3].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB3_CAPTCTRLX FlexPWM_0.SUB[3].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB3_CAPTCMPX FlexPWM_0.SUB[3].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB3_CVAL0 FlexPWM_0.SUB[3].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB3_CVAL0CYC FlexPWM_0.SUB[3].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB3_CVAL1 FlexPWM_0.SUB[3].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB3_CVAL1CYC FlexPWM_0.SUB[3].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_OUTEN      FlexPWM_0.OUTEN.R             /* Output Enable Register */
#define FlexPWM_0_MASK       FlexPWM_0.MASK.R              /* Mask Register */
#define FlexPWM_0_SWCOUT     FlexPWM_0.SWCOUT.R            /* Software Controlled Output Register */
#define FlexPWM_0_DTSRCSEL   FlexPWM_0.DTSRCSEL.R          /* Deadtime Source Select Register */
#define FlexPWM_0_MCTRL      FlexPWM_0.MCTRL.R             /* Master Control Register */
#define FlexPWM_0_FCTRL      FlexPWM_0.FCTRL.R             /* Fault Control Register */
#define FlexPWM_0_FSTS       FlexPWM_0.FSTS.R              /* Fault Status Register */
#define FlexPWM_0_FFILT      FlexPWM_0.FFILT.R             /* Fault Filter Register */
#define FlexPWM_0_FCTRL2     FlexPWM_0.FCTRL2.R            /* Fault Control 2 Register */

/* I2C */
#define I2C_1_IBAD           I2C_1.IBAD.R                  /* I2C Bus Address Register */
#define I2C_1_IBFD           I2C_1.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_1_IBCR           I2C_1.IBCR.R                  /* I2C Bus Control Register */
#define I2C_1_IBSR           I2C_1.IBSR.R                  /* I2C Bus Status Register */
#define I2C_1_IBDR           I2C_1.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_1_IBIC           I2C_1.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_1_IBDBG          I2C_1.IBDBG.R                 /* I2C Bus Debug Register */

#define I2C_2_IBAD           I2C_2.IBAD.R                  /* I2C Bus Address Register */
#define I2C_2_IBFD           I2C_2.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_2_IBCR           I2C_2.IBCR.R                  /* I2C Bus Control Register */
#define I2C_2_IBSR           I2C_2.IBSR.R                  /* I2C Bus Status Register */
#define I2C_2_IBDR           I2C_2.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_2_IBIC           I2C_2.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_2_IBDBG          I2C_2.IBDBG.R                 /* I2C Bus Debug Register */

/* INTC */
#define INTC_BCR             INTC.BCR.R                    /* INTC Block Configuration Register */
#define INTC_CPR1            INTC.CPR1.R                   /* INTC Current Priority Register for Processor 1 */
#define INTC_CPR2            INTC.CPR2.R                   /* INTC Current Priority Register for Processor 2 */
#define INTC_IACKR1          INTC.IACKR1.R                 /* INTC Interrupt Acknowledge Register for Processor 1 */
#define INTC_IACKR2          INTC.IACKR2.R                 /* INTC Interrupt Acknowledge Register for Processor 2 */
#define INTC_EOIR1           INTC.EOIR1.R                  /* INTC End Of Interrupt Register for Processor 1 */
#define INTC_EOIR2           INTC.EOIR2.R                  /* INTC End Of Interrupt Register for Processor 2 */
#define INTC_SSCIR0          INTC.SSCIR[0].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR1          INTC.SSCIR[1].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR2          INTC.SSCIR[2].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR3          INTC.SSCIR[3].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR4          INTC.SSCIR[4].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR5          INTC.SSCIR[5].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR6          INTC.SSCIR[6].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR7          INTC.SSCIR[7].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR8          INTC.SSCIR[8].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR9          INTC.SSCIR[9].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR10         INTC.SSCIR[10].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR11         INTC.SSCIR[11].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR12         INTC.SSCIR[12].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR13         INTC.SSCIR[13].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR14         INTC.SSCIR[14].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR15         INTC.SSCIR[15].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_PSR0            INTC.PSR[0].R                 /* INTC Priority Select Register */
#define INTC_PSR1            INTC.PSR[1].R                 /* INTC Priority Select Register */
#define INTC_PSR2            INTC.PSR[2].R                 /* INTC Priority Select Register */
#define INTC_PSR3            INTC.PSR[3].R                 /* INTC Priority Select Register */
#define INTC_PSR4            INTC.PSR[4].R                 /* INTC Priority Select Register */
#define INTC_PSR5            INTC.PSR[5].R                 /* INTC Priority Select Register */
#define INTC_PSR6            INTC.PSR[6].R                 /* INTC Priority Select Register */
#define INTC_PSR7            INTC.PSR[7].R                 /* INTC Priority Select Register */
#define INTC_PSR8            INTC.PSR[8].R                 /* INTC Priority Select Register */
#define INTC_PSR9            INTC.PSR[9].R                 /* INTC Priority Select Register */
#define INTC_PSR10           INTC.PSR[10].R                /* INTC Priority Select Register */
#define INTC_PSR11           INTC.PSR[11].R                /* INTC Priority Select Register */
#define INTC_PSR12           INTC.PSR[12].R                /* INTC Priority Select Register */
#define INTC_PSR13           INTC.PSR[13].R                /* INTC Priority Select Register */
#define INTC_PSR14           INTC.PSR[14].R                /* INTC Priority Select Register */
#define INTC_PSR15           INTC.PSR[15].R                /* INTC Priority Select Register */
#define INTC_PSR16           INTC.PSR[16].R                /* INTC Priority Select Register */
#define INTC_PSR17           INTC.PSR[17].R                /* INTC Priority Select Register */
#define INTC_PSR18           INTC.PSR[18].R                /* INTC Priority Select Register */
#define INTC_PSR19           INTC.PSR[19].R                /* INTC Priority Select Register */
#define INTC_PSR20           INTC.PSR[20].R                /* INTC Priority Select Register */
#define INTC_PSR21           INTC.PSR[21].R                /* INTC Priority Select Register */
#define INTC_PSR22           INTC.PSR[22].R                /* INTC Priority Select Register */
#define INTC_PSR23           INTC.PSR[23].R                /* INTC Priority Select Register */
#define INTC_PSR24           INTC.PSR[24].R                /* INTC Priority Select Register */
#define INTC_PSR25           INTC.PSR[25].R                /* INTC Priority Select Register */
#define INTC_PSR26           INTC.PSR[26].R                /* INTC Priority Select Register */
#define INTC_PSR27           INTC.PSR[27].R                /* INTC Priority Select Register */
#define INTC_PSR28           INTC.PSR[28].R                /* INTC Priority Select Register */
#define INTC_PSR29           INTC.PSR[29].R                /* INTC Priority Select Register */
#define INTC_PSR30           INTC.PSR[30].R                /* INTC Priority Select Register */
#define INTC_PSR31           INTC.PSR[31].R                /* INTC Priority Select Register */
#define INTC_PSR32           INTC.PSR[32].R                /* INTC Priority Select Register */
#define INTC_PSR33           INTC.PSR[33].R                /* INTC Priority Select Register */
#define INTC_PSR34           INTC.PSR[34].R                /* INTC Priority Select Register */
#define INTC_PSR35           INTC.PSR[35].R                /* INTC Priority Select Register */
#define INTC_PSR36           INTC.PSR[36].R                /* INTC Priority Select Register */
#define INTC_PSR37           INTC.PSR[37].R                /* INTC Priority Select Register */
#define INTC_PSR38           INTC.PSR[38].R                /* INTC Priority Select Register */
#define INTC_PSR39           INTC.PSR[39].R                /* INTC Priority Select Register */
#define INTC_PSR40           INTC.PSR[40].R                /* INTC Priority Select Register */
#define INTC_PSR41           INTC.PSR[41].R                /* INTC Priority Select Register */
#define INTC_PSR42           INTC.PSR[42].R                /* INTC Priority Select Register */
#define INTC_PSR43           INTC.PSR[43].R                /* INTC Priority Select Register */
#define INTC_PSR44           INTC.PSR[44].R                /* INTC Priority Select Register */
#define INTC_PSR45           INTC.PSR[45].R                /* INTC Priority Select Register */
#define INTC_PSR46           INTC.PSR[46].R                /* INTC Priority Select Register */
#define INTC_PSR47           INTC.PSR[47].R                /* INTC Priority Select Register */
#define INTC_PSR48           INTC.PSR[48].R                /* INTC Priority Select Register */
#define INTC_PSR49           INTC.PSR[49].R                /* INTC Priority Select Register */
#define INTC_PSR50           INTC.PSR[50].R                /* INTC Priority Select Register */
#define INTC_PSR51           INTC.PSR[51].R                /* INTC Priority Select Register */
#define INTC_PSR52           INTC.PSR[52].R                /* INTC Priority Select Register */
#define INTC_PSR53           INTC.PSR[53].R                /* INTC Priority Select Register */
#define INTC_PSR54           INTC.PSR[54].R                /* INTC Priority Select Register */
#define INTC_PSR55           INTC.PSR[55].R                /* INTC Priority Select Register */
#define INTC_PSR56           INTC.PSR[56].R                /* INTC Priority Select Register */
#define INTC_PSR57           INTC.PSR[57].R                /* INTC Priority Select Register */
#define INTC_PSR58           INTC.PSR[58].R                /* INTC Priority Select Register */
#define INTC_PSR59           INTC.PSR[59].R                /* INTC Priority Select Register */
#define INTC_PSR60           INTC.PSR[60].R                /* INTC Priority Select Register */
#define INTC_PSR61           INTC.PSR[61].R                /* INTC Priority Select Register */
#define INTC_PSR62           INTC.PSR[62].R                /* INTC Priority Select Register */
#define INTC_PSR63           INTC.PSR[63].R                /* INTC Priority Select Register */
#define INTC_PSR64           INTC.PSR[64].R                /* INTC Priority Select Register */
#define INTC_PSR65           INTC.PSR[65].R                /* INTC Priority Select Register */
#define INTC_PSR66           INTC.PSR[66].R                /* INTC Priority Select Register */
#define INTC_PSR67           INTC.PSR[67].R                /* INTC Priority Select Register */
#define INTC_PSR68           INTC.PSR[68].R                /* INTC Priority Select Register */
#define INTC_PSR69           INTC.PSR[69].R                /* INTC Priority Select Register */
#define INTC_PSR70           INTC.PSR[70].R                /* INTC Priority Select Register */
#define INTC_PSR71           INTC.PSR[71].R                /* INTC Priority Select Register */
#define INTC_PSR72           INTC.PSR[72].R                /* INTC Priority Select Register */
#define INTC_PSR73           INTC.PSR[73].R                /* INTC Priority Select Register */
#define INTC_PSR74           INTC.PSR[74].R                /* INTC Priority Select Register */
#define INTC_PSR75           INTC.PSR[75].R                /* INTC Priority Select Register */
#define INTC_PSR76           INTC.PSR[76].R                /* INTC Priority Select Register */
#define INTC_PSR77           INTC.PSR[77].R                /* INTC Priority Select Register */
#define INTC_PSR78           INTC.PSR[78].R                /* INTC Priority Select Register */
#define INTC_PSR79           INTC.PSR[79].R                /* INTC Priority Select Register */
#define INTC_PSR80           INTC.PSR[80].R                /* INTC Priority Select Register */
#define INTC_PSR81           INTC.PSR[81].R                /* INTC Priority Select Register */
#define INTC_PSR82           INTC.PSR[82].R                /* INTC Priority Select Register */
#define INTC_PSR83           INTC.PSR[83].R                /* INTC Priority Select Register */
#define INTC_PSR84           INTC.PSR[84].R                /* INTC Priority Select Register */
#define INTC_PSR85           INTC.PSR[85].R                /* INTC Priority Select Register */
#define INTC_PSR86           INTC.PSR[86].R                /* INTC Priority Select Register */
#define INTC_PSR87           INTC.PSR[87].R                /* INTC Priority Select Register */
#define INTC_PSR88           INTC.PSR[88].R                /* INTC Priority Select Register */
#define INTC_PSR89           INTC.PSR[89].R                /* INTC Priority Select Register */
#define INTC_PSR90           INTC.PSR[90].R                /* INTC Priority Select Register */
#define INTC_PSR91           INTC.PSR[91].R                /* INTC Priority Select Register */
#define INTC_PSR92           INTC.PSR[92].R                /* INTC Priority Select Register */
#define INTC_PSR93           INTC.PSR[93].R                /* INTC Priority Select Register */
#define INTC_PSR94           INTC.PSR[94].R                /* INTC Priority Select Register */
#define INTC_PSR95           INTC.PSR[95].R                /* INTC Priority Select Register */
#define INTC_PSR96           INTC.PSR[96].R                /* INTC Priority Select Register */
#define INTC_PSR97           INTC.PSR[97].R                /* INTC Priority Select Register */
#define INTC_PSR98           INTC.PSR[98].R                /* INTC Priority Select Register */
#define INTC_PSR99           INTC.PSR[99].R                /* INTC Priority Select Register */
#define INTC_PSR100          INTC.PSR[100].R               /* INTC Priority Select Register */
#define INTC_PSR101          INTC.PSR[101].R               /* INTC Priority Select Register */
#define INTC_PSR102          INTC.PSR[102].R               /* INTC Priority Select Register */
#define INTC_PSR103          INTC.PSR[103].R               /* INTC Priority Select Register */
#define INTC_PSR104          INTC.PSR[104].R               /* INTC Priority Select Register */
#define INTC_PSR105          INTC.PSR[105].R               /* INTC Priority Select Register */
#define INTC_PSR106          INTC.PSR[106].R               /* INTC Priority Select Register */
#define INTC_PSR107          INTC.PSR[107].R               /* INTC Priority Select Register */
#define INTC_PSR108          INTC.PSR[108].R               /* INTC Priority Select Register */
#define INTC_PSR109          INTC.PSR[109].R               /* INTC Priority Select Register */
#define INTC_PSR110          INTC.PSR[110].R               /* INTC Priority Select Register */
#define INTC_PSR111          INTC.PSR[111].R               /* INTC Priority Select Register */
#define INTC_PSR112          INTC.PSR[112].R               /* INTC Priority Select Register */
#define INTC_PSR113          INTC.PSR[113].R               /* INTC Priority Select Register */
#define INTC_PSR114          INTC.PSR[114].R               /* INTC Priority Select Register */
#define INTC_PSR115          INTC.PSR[115].R               /* INTC Priority Select Register */
#define INTC_PSR116          INTC.PSR[116].R               /* INTC Priority Select Register */
#define INTC_PSR117          INTC.PSR[117].R               /* INTC Priority Select Register */
#define INTC_PSR118          INTC.PSR[118].R               /* INTC Priority Select Register */
#define INTC_PSR119          INTC.PSR[119].R               /* INTC Priority Select Register */
#define INTC_PSR120          INTC.PSR[120].R               /* INTC Priority Select Register */
#define INTC_PSR121          INTC.PSR[121].R               /* INTC Priority Select Register */
#define INTC_PSR122          INTC.PSR[122].R               /* INTC Priority Select Register */
#define INTC_PSR123          INTC.PSR[123].R               /* INTC Priority Select Register */
#define INTC_PSR124          INTC.PSR[124].R               /* INTC Priority Select Register */
#define INTC_PSR125          INTC.PSR[125].R               /* INTC Priority Select Register */
#define INTC_PSR126          INTC.PSR[126].R               /* INTC Priority Select Register */
#define INTC_PSR127          INTC.PSR[127].R               /* INTC Priority Select Register */
#define INTC_PSR128          INTC.PSR[128].R               /* INTC Priority Select Register */
#define INTC_PSR129          INTC.PSR[129].R               /* INTC Priority Select Register */
#define INTC_PSR130          INTC.PSR[130].R               /* INTC Priority Select Register */
#define INTC_PSR131          INTC.PSR[131].R               /* INTC Priority Select Register */
#define INTC_PSR132          INTC.PSR[132].R               /* INTC Priority Select Register */
#define INTC_PSR133          INTC.PSR[133].R               /* INTC Priority Select Register */
#define INTC_PSR134          INTC.PSR[134].R               /* INTC Priority Select Register */
#define INTC_PSR135          INTC.PSR[135].R               /* INTC Priority Select Register */
#define INTC_PSR136          INTC.PSR[136].R               /* INTC Priority Select Register */
#define INTC_PSR137          INTC.PSR[137].R               /* INTC Priority Select Register */
#define INTC_PSR138          INTC.PSR[138].R               /* INTC Priority Select Register */
#define INTC_PSR139          INTC.PSR[139].R               /* INTC Priority Select Register */
#define INTC_PSR140          INTC.PSR[140].R               /* INTC Priority Select Register */
#define INTC_PSR141          INTC.PSR[141].R               /* INTC Priority Select Register */
#define INTC_PSR142          INTC.PSR[142].R               /* INTC Priority Select Register */
#define INTC_PSR143          INTC.PSR[143].R               /* INTC Priority Select Register */
#define INTC_PSR144          INTC.PSR[144].R               /* INTC Priority Select Register */
#define INTC_PSR145          INTC.PSR[145].R               /* INTC Priority Select Register */
#define INTC_PSR146          INTC.PSR[146].R               /* INTC Priority Select Register */
#define INTC_PSR147          INTC.PSR[147].R               /* INTC Priority Select Register */
#define INTC_PSR148          INTC.PSR[148].R               /* INTC Priority Select Register */
#define INTC_PSR149          INTC.PSR[149].R               /* INTC Priority Select Register */
#define INTC_PSR150          INTC.PSR[150].R               /* INTC Priority Select Register */
#define INTC_PSR151          INTC.PSR[151].R               /* INTC Priority Select Register */
#define INTC_PSR152          INTC.PSR[152].R               /* INTC Priority Select Register */
#define INTC_PSR153          INTC.PSR[153].R               /* INTC Priority Select Register */
#define INTC_PSR154          INTC.PSR[154].R               /* INTC Priority Select Register */
#define INTC_PSR155          INTC.PSR[155].R               /* INTC Priority Select Register */
#define INTC_PSR156          INTC.PSR[156].R               /* INTC Priority Select Register */
#define INTC_PSR157          INTC.PSR[157].R               /* INTC Priority Select Register */
#define INTC_PSR158          INTC.PSR[158].R               /* INTC Priority Select Register */
#define INTC_PSR159          INTC.PSR[159].R               /* INTC Priority Select Register */
#define INTC_PSR160          INTC.PSR[160].R               /* INTC Priority Select Register */
#define INTC_PSR161          INTC.PSR[161].R               /* INTC Priority Select Register */
#define INTC_PSR162          INTC.PSR[162].R               /* INTC Priority Select Register */
#define INTC_PSR163          INTC.PSR[163].R               /* INTC Priority Select Register */
#define INTC_PSR164          INTC.PSR[164].R               /* INTC Priority Select Register */
#define INTC_PSR165          INTC.PSR[165].R               /* INTC Priority Select Register */
#define INTC_PSR166          INTC.PSR[166].R               /* INTC Priority Select Register */
#define INTC_PSR167          INTC.PSR[167].R               /* INTC Priority Select Register */
#define INTC_PSR168          INTC.PSR[168].R               /* INTC Priority Select Register */
#define INTC_PSR169          INTC.PSR[169].R               /* INTC Priority Select Register */
#define INTC_PSR170          INTC.PSR[170].R               /* INTC Priority Select Register */
#define INTC_PSR171          INTC.PSR[171].R               /* INTC Priority Select Register */
#define INTC_PSR172          INTC.PSR[172].R               /* INTC Priority Select Register */
#define INTC_PSR173          INTC.PSR[173].R               /* INTC Priority Select Register */
#define INTC_PSR174          INTC.PSR[174].R               /* INTC Priority Select Register */
#define INTC_PSR175          INTC.PSR[175].R               /* INTC Priority Select Register */
#define INTC_PSR176          INTC.PSR[176].R               /* INTC Priority Select Register */
#define INTC_PSR177          INTC.PSR[177].R               /* INTC Priority Select Register */
#define INTC_PSR178          INTC.PSR[178].R               /* INTC Priority Select Register */
#define INTC_PSR179          INTC.PSR[179].R               /* INTC Priority Select Register */
#define INTC_PSR180          INTC.PSR[180].R               /* INTC Priority Select Register */
#define INTC_PSR181          INTC.PSR[181].R               /* INTC Priority Select Register */
#define INTC_PSR182          INTC.PSR[182].R               /* INTC Priority Select Register */
#define INTC_PSR183          INTC.PSR[183].R               /* INTC Priority Select Register */
#define INTC_PSR184          INTC.PSR[184].R               /* INTC Priority Select Register */
#define INTC_PSR185          INTC.PSR[185].R               /* INTC Priority Select Register */
#define INTC_PSR186          INTC.PSR[186].R               /* INTC Priority Select Register */
#define INTC_PSR187          INTC.PSR[187].R               /* INTC Priority Select Register */
#define INTC_PSR188          INTC.PSR[188].R               /* INTC Priority Select Register */
#define INTC_PSR189          INTC.PSR[189].R               /* INTC Priority Select Register */
#define INTC_PSR190          INTC.PSR[190].R               /* INTC Priority Select Register */
#define INTC_PSR191          INTC.PSR[191].R               /* INTC Priority Select Register */
#define INTC_PSR192          INTC.PSR[192].R               /* INTC Priority Select Register */
#define INTC_PSR193          INTC.PSR[193].R               /* INTC Priority Select Register */
#define INTC_PSR194          INTC.PSR[194].R               /* INTC Priority Select Register */
#define INTC_PSR195          INTC.PSR[195].R               /* INTC Priority Select Register */
#define INTC_PSR196          INTC.PSR[196].R               /* INTC Priority Select Register */
#define INTC_PSR197          INTC.PSR[197].R               /* INTC Priority Select Register */
#define INTC_PSR198          INTC.PSR[198].R               /* INTC Priority Select Register */
#define INTC_PSR199          INTC.PSR[199].R               /* INTC Priority Select Register */
#define INTC_PSR200          INTC.PSR[200].R               /* INTC Priority Select Register */
#define INTC_PSR201          INTC.PSR[201].R               /* INTC Priority Select Register */
#define INTC_PSR202          INTC.PSR[202].R               /* INTC Priority Select Register */
#define INTC_PSR203          INTC.PSR[203].R               /* INTC Priority Select Register */
#define INTC_PSR204          INTC.PSR[204].R               /* INTC Priority Select Register */
#define INTC_PSR205          INTC.PSR[205].R               /* INTC Priority Select Register */
#define INTC_PSR206          INTC.PSR[206].R               /* INTC Priority Select Register */
#define INTC_PSR207          INTC.PSR[207].R               /* INTC Priority Select Register */
#define INTC_PSR208          INTC.PSR[208].R               /* INTC Priority Select Register */
#define INTC_PSR209          INTC.PSR[209].R               /* INTC Priority Select Register */
#define INTC_PSR210          INTC.PSR[210].R               /* INTC Priority Select Register */
#define INTC_PSR211          INTC.PSR[211].R               /* INTC Priority Select Register */
#define INTC_PSR212          INTC.PSR[212].R               /* INTC Priority Select Register */
#define INTC_PSR213          INTC.PSR[213].R               /* INTC Priority Select Register */
#define INTC_PSR214          INTC.PSR[214].R               /* INTC Priority Select Register */
#define INTC_PSR215          INTC.PSR[215].R               /* INTC Priority Select Register */
#define INTC_PSR216          INTC.PSR[216].R               /* INTC Priority Select Register */
#define INTC_PSR217          INTC.PSR[217].R               /* INTC Priority Select Register */
#define INTC_PSR218          INTC.PSR[218].R               /* INTC Priority Select Register */
#define INTC_PSR219          INTC.PSR[219].R               /* INTC Priority Select Register */
#define INTC_PSR220          INTC.PSR[220].R               /* INTC Priority Select Register */
#define INTC_PSR221          INTC.PSR[221].R               /* INTC Priority Select Register */
#define INTC_PSR222          INTC.PSR[222].R               /* INTC Priority Select Register */
#define INTC_PSR223          INTC.PSR[223].R               /* INTC Priority Select Register */
#define INTC_PSR224          INTC.PSR[224].R               /* INTC Priority Select Register */
#define INTC_PSR225          INTC.PSR[225].R               /* INTC Priority Select Register */
#define INTC_PSR226          INTC.PSR[226].R               /* INTC Priority Select Register */
#define INTC_PSR227          INTC.PSR[227].R               /* INTC Priority Select Register */
#define INTC_PSR228          INTC.PSR[228].R               /* INTC Priority Select Register */
#define INTC_PSR229          INTC.PSR[229].R               /* INTC Priority Select Register */
#define INTC_PSR230          INTC.PSR[230].R               /* INTC Priority Select Register */
#define INTC_PSR231          INTC.PSR[231].R               /* INTC Priority Select Register */
#define INTC_PSR232          INTC.PSR[232].R               /* INTC Priority Select Register */
#define INTC_PSR233          INTC.PSR[233].R               /* INTC Priority Select Register */
#define INTC_PSR234          INTC.PSR[234].R               /* INTC Priority Select Register */
#define INTC_PSR235          INTC.PSR[235].R               /* INTC Priority Select Register */
#define INTC_PSR236          INTC.PSR[236].R               /* INTC Priority Select Register */
#define INTC_PSR237          INTC.PSR[237].R               /* INTC Priority Select Register */
#define INTC_PSR238          INTC.PSR[238].R               /* INTC Priority Select Register */
#define INTC_PSR239          INTC.PSR[239].R               /* INTC Priority Select Register */
#define INTC_PSR240          INTC.PSR[240].R               /* INTC Priority Select Register */
#define INTC_PSR241          INTC.PSR[241].R               /* INTC Priority Select Register */
#define INTC_PSR242          INTC.PSR[242].R               /* INTC Priority Select Register */
#define INTC_PSR243          INTC.PSR[243].R               /* INTC Priority Select Register */
#define INTC_PSR244          INTC.PSR[244].R               /* INTC Priority Select Register */
#define INTC_PSR245          INTC.PSR[245].R               /* INTC Priority Select Register */
#define INTC_PSR246          INTC.PSR[246].R               /* INTC Priority Select Register */
#define INTC_PSR247          INTC.PSR[247].R               /* INTC Priority Select Register */
#define INTC_PSR248          INTC.PSR[248].R               /* INTC Priority Select Register */
#define INTC_PSR249          INTC.PSR[249].R               /* INTC Priority Select Register */
#define INTC_PSR250          INTC.PSR[250].R               /* INTC Priority Select Register */
#define INTC_PSR251          INTC.PSR[251].R               /* INTC Priority Select Register */
#define INTC_PSR252          INTC.PSR[252].R               /* INTC Priority Select Register */
#define INTC_PSR253          INTC.PSR[253].R               /* INTC Priority Select Register */
#define INTC_PSR254          INTC.PSR[254].R               /* INTC Priority Select Register */
#define INTC_PSR255          INTC.PSR[255].R               /* INTC Priority Select Register */
#define INTC_PSR256          INTC.PSR[256].R               /* INTC Priority Select Register */
#define INTC_PSR257          INTC.PSR[257].R               /* INTC Priority Select Register */
#define INTC_PSR258          INTC.PSR[258].R               /* INTC Priority Select Register */
#define INTC_PSR259          INTC.PSR[259].R               /* INTC Priority Select Register */
#define INTC_PSR260          INTC.PSR[260].R               /* INTC Priority Select Register */
#define INTC_PSR261          INTC.PSR[261].R               /* INTC Priority Select Register */
#define INTC_PSR262          INTC.PSR[262].R               /* INTC Priority Select Register */
#define INTC_PSR263          INTC.PSR[263].R               /* INTC Priority Select Register */
#define INTC_PSR264          INTC.PSR[264].R               /* INTC Priority Select Register */
#define INTC_PSR265          INTC.PSR[265].R               /* INTC Priority Select Register */
#define INTC_PSR266          INTC.PSR[266].R               /* INTC Priority Select Register */
#define INTC_PSR267          INTC.PSR[267].R               /* INTC Priority Select Register */
#define INTC_PSR268          INTC.PSR[268].R               /* INTC Priority Select Register */
#define INTC_PSR269          INTC.PSR[269].R               /* INTC Priority Select Register */
#define INTC_PSR270          INTC.PSR[270].R               /* INTC Priority Select Register */
#define INTC_PSR271          INTC.PSR[271].R               /* INTC Priority Select Register */
#define INTC_PSR272          INTC.PSR[272].R               /* INTC Priority Select Register */
#define INTC_PSR273          INTC.PSR[273].R               /* INTC Priority Select Register */
#define INTC_PSR274          INTC.PSR[274].R               /* INTC Priority Select Register */
#define INTC_PSR275          INTC.PSR[275].R               /* INTC Priority Select Register */
#define INTC_PSR276          INTC.PSR[276].R               /* INTC Priority Select Register */
#define INTC_PSR277          INTC.PSR[277].R               /* INTC Priority Select Register */
#define INTC_PSR278          INTC.PSR[278].R               /* INTC Priority Select Register */
#define INTC_PSR279          INTC.PSR[279].R               /* INTC Priority Select Register */
#define INTC_PSR280          INTC.PSR[280].R               /* INTC Priority Select Register */
#define INTC_PSR281          INTC.PSR[281].R               /* INTC Priority Select Register */
#define INTC_PSR282          INTC.PSR[282].R               /* INTC Priority Select Register */
#define INTC_PSR283          INTC.PSR[283].R               /* INTC Priority Select Register */
#define INTC_PSR284          INTC.PSR[284].R               /* INTC Priority Select Register */
#define INTC_PSR285          INTC.PSR[285].R               /* INTC Priority Select Register */
#define INTC_PSR286          INTC.PSR[286].R               /* INTC Priority Select Register */
#define INTC_PSR287          INTC.PSR[287].R               /* INTC Priority Select Register */
#define INTC_PSR288          INTC.PSR[288].R               /* INTC Priority Select Register */
#define INTC_PSR289          INTC.PSR[289].R               /* INTC Priority Select Register */
#define INTC_PSR290          INTC.PSR[290].R               /* INTC Priority Select Register */
#define INTC_PSR291          INTC.PSR[291].R               /* INTC Priority Select Register */
#define INTC_PSR292          INTC.PSR[292].R               /* INTC Priority Select Register */
#define INTC_PSR293          INTC.PSR[293].R               /* INTC Priority Select Register */
#define INTC_PSR294          INTC.PSR[294].R               /* INTC Priority Select Register */
#define INTC_PSR295          INTC.PSR[295].R               /* INTC Priority Select Register */
#define INTC_PSR296          INTC.PSR[296].R               /* INTC Priority Select Register */
#define INTC_PSR297          INTC.PSR[297].R               /* INTC Priority Select Register */
#define INTC_PSR298          INTC.PSR[298].R               /* INTC Priority Select Register */
#define INTC_PSR299          INTC.PSR[299].R               /* INTC Priority Select Register */
#define INTC_PSR300          INTC.PSR[300].R               /* INTC Priority Select Register */
#define INTC_PSR301          INTC.PSR[301].R               /* INTC Priority Select Register */
#define INTC_PSR302          INTC.PSR[302].R               /* INTC Priority Select Register */
#define INTC_PSR303          INTC.PSR[303].R               /* INTC Priority Select Register */
#define INTC_PSR304          INTC.PSR[304].R               /* INTC Priority Select Register */
#define INTC_PSR305          INTC.PSR[305].R               /* INTC Priority Select Register */
#define INTC_PSR306          INTC.PSR[306].R               /* INTC Priority Select Register */
#define INTC_PSR307          INTC.PSR[307].R               /* INTC Priority Select Register */
#define INTC_PSR308          INTC.PSR[308].R               /* INTC Priority Select Register */
#define INTC_PSR309          INTC.PSR[309].R               /* INTC Priority Select Register */
#define INTC_PSR310          INTC.PSR[310].R               /* INTC Priority Select Register */
#define INTC_PSR311          INTC.PSR[311].R               /* INTC Priority Select Register */
#define INTC_PSR312          INTC.PSR[312].R               /* INTC Priority Select Register */
#define INTC_PSR313          INTC.PSR[313].R               /* INTC Priority Select Register */
#define INTC_PSR314          INTC.PSR[314].R               /* INTC Priority Select Register */
#define INTC_PSR315          INTC.PSR[315].R               /* INTC Priority Select Register */
#define INTC_PSR316          INTC.PSR[316].R               /* INTC Priority Select Register */
#define INTC_PSR317          INTC.PSR[317].R               /* INTC Priority Select Register */
#define INTC_PSR318          INTC.PSR[318].R               /* INTC Priority Select Register */
#define INTC_PSR319          INTC.PSR[319].R               /* INTC Priority Select Register */
#define INTC_PSR320          INTC.PSR[320].R               /* INTC Priority Select Register */
#define INTC_PSR321          INTC.PSR[321].R               /* INTC Priority Select Register */
#define INTC_PSR322          INTC.PSR[322].R               /* INTC Priority Select Register */
#define INTC_PSR323          INTC.PSR[323].R               /* INTC Priority Select Register */
#define INTC_PSR324          INTC.PSR[324].R               /* INTC Priority Select Register */
#define INTC_PSR325          INTC.PSR[325].R               /* INTC Priority Select Register */
#define INTC_PSR326          INTC.PSR[326].R               /* INTC Priority Select Register */
#define INTC_PSR327          INTC.PSR[327].R               /* INTC Priority Select Register */
#define INTC_PSR328          INTC.PSR[328].R               /* INTC Priority Select Register */
#define INTC_PSR329          INTC.PSR[329].R               /* INTC Priority Select Register */
#define INTC_PSR330          INTC.PSR[330].R               /* INTC Priority Select Register */
#define INTC_PSR331          INTC.PSR[331].R               /* INTC Priority Select Register */
#define INTC_PSR332          INTC.PSR[332].R               /* INTC Priority Select Register */
#define INTC_PSR333          INTC.PSR[333].R               /* INTC Priority Select Register */
#define INTC_PSR334          INTC.PSR[334].R               /* INTC Priority Select Register */
#define INTC_PSR335          INTC.PSR[335].R               /* INTC Priority Select Register */
#define INTC_PSR336          INTC.PSR[336].R               /* INTC Priority Select Register */
#define INTC_PSR337          INTC.PSR[337].R               /* INTC Priority Select Register */
#define INTC_PSR338          INTC.PSR[338].R               /* INTC Priority Select Register */
#define INTC_PSR339          INTC.PSR[339].R               /* INTC Priority Select Register */
#define INTC_PSR340          INTC.PSR[340].R               /* INTC Priority Select Register */
#define INTC_PSR341          INTC.PSR[341].R               /* INTC Priority Select Register */
#define INTC_PSR342          INTC.PSR[342].R               /* INTC Priority Select Register */
#define INTC_PSR343          INTC.PSR[343].R               /* INTC Priority Select Register */
#define INTC_PSR344          INTC.PSR[344].R               /* INTC Priority Select Register */
#define INTC_PSR345          INTC.PSR[345].R               /* INTC Priority Select Register */
#define INTC_PSR346          INTC.PSR[346].R               /* INTC Priority Select Register */
#define INTC_PSR347          INTC.PSR[347].R               /* INTC Priority Select Register */
#define INTC_PSR348          INTC.PSR[348].R               /* INTC Priority Select Register */
#define INTC_PSR349          INTC.PSR[349].R               /* INTC Priority Select Register */
#define INTC_PSR350          INTC.PSR[350].R               /* INTC Priority Select Register */
#define INTC_PSR351          INTC.PSR[351].R               /* INTC Priority Select Register */
#define INTC_PSR352          INTC.PSR[352].R               /* INTC Priority Select Register */
#define INTC_PSR353          INTC.PSR[353].R               /* INTC Priority Select Register */
#define INTC_PSR354          INTC.PSR[354].R               /* INTC Priority Select Register */
#define INTC_PSR355          INTC.PSR[355].R               /* INTC Priority Select Register */
#define INTC_PSR356          INTC.PSR[356].R               /* INTC Priority Select Register */
#define INTC_PSR357          INTC.PSR[357].R               /* INTC Priority Select Register */
#define INTC_PSR358          INTC.PSR[358].R               /* INTC Priority Select Register */
#define INTC_PSR359          INTC.PSR[359].R               /* INTC Priority Select Register */
#define INTC_PSR360          INTC.PSR[360].R               /* INTC Priority Select Register */
#define INTC_PSR361          INTC.PSR[361].R               /* INTC Priority Select Register */
#define INTC_PSR362          INTC.PSR[362].R               /* INTC Priority Select Register */
#define INTC_PSR363          INTC.PSR[363].R               /* INTC Priority Select Register */
#define INTC_PSR364          INTC.PSR[364].R               /* INTC Priority Select Register */
#define INTC_PSR365          INTC.PSR[365].R               /* INTC Priority Select Register */
#define INTC_PSR366          INTC.PSR[366].R               /* INTC Priority Select Register */
#define INTC_PSR367          INTC.PSR[367].R               /* INTC Priority Select Register */
#define INTC_PSR368          INTC.PSR[368].R               /* INTC Priority Select Register */
#define INTC_PSR369          INTC.PSR[369].R               /* INTC Priority Select Register */
#define INTC_PSR370          INTC.PSR[370].R               /* INTC Priority Select Register */
#define INTC_PSR371          INTC.PSR[371].R               /* INTC Priority Select Register */
#define INTC_PSR372          INTC.PSR[372].R               /* INTC Priority Select Register */
#define INTC_PSR373          INTC.PSR[373].R               /* INTC Priority Select Register */
#define INTC_PSR374          INTC.PSR[374].R               /* INTC Priority Select Register */
#define INTC_PSR375          INTC.PSR[375].R               /* INTC Priority Select Register */
#define INTC_PSR376          INTC.PSR[376].R               /* INTC Priority Select Register */
#define INTC_PSR377          INTC.PSR[377].R               /* INTC Priority Select Register */
#define INTC_PSR378          INTC.PSR[378].R               /* INTC Priority Select Register */
#define INTC_PSR379          INTC.PSR[379].R               /* INTC Priority Select Register */
#define INTC_PSR380          INTC.PSR[380].R               /* INTC Priority Select Register */
#define INTC_PSR381          INTC.PSR[381].R               /* INTC Priority Select Register */
#define INTC_PSR382          INTC.PSR[382].R               /* INTC Priority Select Register */
#define INTC_PSR383          INTC.PSR[383].R               /* INTC Priority Select Register */
#define INTC_PSR384          INTC.PSR[384].R               /* INTC Priority Select Register */
#define INTC_PSR385          INTC.PSR[385].R               /* INTC Priority Select Register */
#define INTC_PSR386          INTC.PSR[386].R               /* INTC Priority Select Register */
#define INTC_PSR387          INTC.PSR[387].R               /* INTC Priority Select Register */
#define INTC_PSR388          INTC.PSR[388].R               /* INTC Priority Select Register */
#define INTC_PSR389          INTC.PSR[389].R               /* INTC Priority Select Register */
#define INTC_PSR390          INTC.PSR[390].R               /* INTC Priority Select Register */
#define INTC_PSR391          INTC.PSR[391].R               /* INTC Priority Select Register */
#define INTC_PSR392          INTC.PSR[392].R               /* INTC Priority Select Register */
#define INTC_PSR393          INTC.PSR[393].R               /* INTC Priority Select Register */
#define INTC_PSR394          INTC.PSR[394].R               /* INTC Priority Select Register */
#define INTC_PSR395          INTC.PSR[395].R               /* INTC Priority Select Register */
#define INTC_PSR396          INTC.PSR[396].R               /* INTC Priority Select Register */
#define INTC_PSR397          INTC.PSR[397].R               /* INTC Priority Select Register */
#define INTC_PSR398          INTC.PSR[398].R               /* INTC Priority Select Register */
#define INTC_PSR399          INTC.PSR[399].R               /* INTC Priority Select Register */
#define INTC_PSR400          INTC.PSR[400].R               /* INTC Priority Select Register */
#define INTC_PSR401          INTC.PSR[401].R               /* INTC Priority Select Register */
#define INTC_PSR402          INTC.PSR[402].R               /* INTC Priority Select Register */
#define INTC_PSR403          INTC.PSR[403].R               /* INTC Priority Select Register */
#define INTC_PSR404          INTC.PSR[404].R               /* INTC Priority Select Register */
#define INTC_PSR405          INTC.PSR[405].R               /* INTC Priority Select Register */
#define INTC_PSR406          INTC.PSR[406].R               /* INTC Priority Select Register */
#define INTC_PSR407          INTC.PSR[407].R               /* INTC Priority Select Register */
#define INTC_PSR408          INTC.PSR[408].R               /* INTC Priority Select Register */
#define INTC_PSR409          INTC.PSR[409].R               /* INTC Priority Select Register */
#define INTC_PSR410          INTC.PSR[410].R               /* INTC Priority Select Register */
#define INTC_PSR411          INTC.PSR[411].R               /* INTC Priority Select Register */
#define INTC_PSR412          INTC.PSR[412].R               /* INTC Priority Select Register */
#define INTC_PSR413          INTC.PSR[413].R               /* INTC Priority Select Register */
#define INTC_PSR414          INTC.PSR[414].R               /* INTC Priority Select Register */
#define INTC_PSR415          INTC.PSR[415].R               /* INTC Priority Select Register */
#define INTC_PSR416          INTC.PSR[416].R               /* INTC Priority Select Register */
#define INTC_PSR417          INTC.PSR[417].R               /* INTC Priority Select Register */
#define INTC_PSR418          INTC.PSR[418].R               /* INTC Priority Select Register */
#define INTC_PSR419          INTC.PSR[419].R               /* INTC Priority Select Register */
#define INTC_PSR420          INTC.PSR[420].R               /* INTC Priority Select Register */
#define INTC_PSR421          INTC.PSR[421].R               /* INTC Priority Select Register */
#define INTC_PSR422          INTC.PSR[422].R               /* INTC Priority Select Register */
#define INTC_PSR423          INTC.PSR[423].R               /* INTC Priority Select Register */
#define INTC_PSR424          INTC.PSR[424].R               /* INTC Priority Select Register */
#define INTC_PSR425          INTC.PSR[425].R               /* INTC Priority Select Register */
#define INTC_PSR426          INTC.PSR[426].R               /* INTC Priority Select Register */
#define INTC_PSR427          INTC.PSR[427].R               /* INTC Priority Select Register */
#define INTC_PSR428          INTC.PSR[428].R               /* INTC Priority Select Register */
#define INTC_PSR429          INTC.PSR[429].R               /* INTC Priority Select Register */
#define INTC_PSR430          INTC.PSR[430].R               /* INTC Priority Select Register */
#define INTC_PSR431          INTC.PSR[431].R               /* INTC Priority Select Register */
#define INTC_PSR432          INTC.PSR[432].R               /* INTC Priority Select Register */
#define INTC_PSR433          INTC.PSR[433].R               /* INTC Priority Select Register */
#define INTC_PSR434          INTC.PSR[434].R               /* INTC Priority Select Register */
#define INTC_PSR435          INTC.PSR[435].R               /* INTC Priority Select Register */
#define INTC_PSR436          INTC.PSR[436].R               /* INTC Priority Select Register */
#define INTC_PSR437          INTC.PSR[437].R               /* INTC Priority Select Register */
#define INTC_PSR438          INTC.PSR[438].R               /* INTC Priority Select Register */
#define INTC_PSR439          INTC.PSR[439].R               /* INTC Priority Select Register */
#define INTC_PSR440          INTC.PSR[440].R               /* INTC Priority Select Register */
#define INTC_PSR441          INTC.PSR[441].R               /* INTC Priority Select Register */
#define INTC_PSR442          INTC.PSR[442].R               /* INTC Priority Select Register */
#define INTC_PSR443          INTC.PSR[443].R               /* INTC Priority Select Register */
#define INTC_PSR444          INTC.PSR[444].R               /* INTC Priority Select Register */
#define INTC_PSR445          INTC.PSR[445].R               /* INTC Priority Select Register */
#define INTC_PSR446          INTC.PSR[446].R               /* INTC Priority Select Register */
#define INTC_PSR447          INTC.PSR[447].R               /* INTC Priority Select Register */
#define INTC_PSR448          INTC.PSR[448].R               /* INTC Priority Select Register */
#define INTC_PSR449          INTC.PSR[449].R               /* INTC Priority Select Register */
#define INTC_PSR450          INTC.PSR[450].R               /* INTC Priority Select Register */
#define INTC_PSR451          INTC.PSR[451].R               /* INTC Priority Select Register */
#define INTC_PSR452          INTC.PSR[452].R               /* INTC Priority Select Register */
#define INTC_PSR453          INTC.PSR[453].R               /* INTC Priority Select Register */
#define INTC_PSR454          INTC.PSR[454].R               /* INTC Priority Select Register */
#define INTC_PSR455          INTC.PSR[455].R               /* INTC Priority Select Register */
#define INTC_PSR456          INTC.PSR[456].R               /* INTC Priority Select Register */
#define INTC_PSR457          INTC.PSR[457].R               /* INTC Priority Select Register */
#define INTC_PSR458          INTC.PSR[458].R               /* INTC Priority Select Register */
#define INTC_PSR459          INTC.PSR[459].R               /* INTC Priority Select Register */
#define INTC_PSR460          INTC.PSR[460].R               /* INTC Priority Select Register */
#define INTC_PSR461          INTC.PSR[461].R               /* INTC Priority Select Register */
#define INTC_PSR462          INTC.PSR[462].R               /* INTC Priority Select Register */
#define INTC_PSR463          INTC.PSR[463].R               /* INTC Priority Select Register */
#define INTC_PSR464          INTC.PSR[464].R               /* INTC Priority Select Register */
#define INTC_PSR465          INTC.PSR[465].R               /* INTC Priority Select Register */
#define INTC_PSR466          INTC.PSR[466].R               /* INTC Priority Select Register */
#define INTC_PSR467          INTC.PSR[467].R               /* INTC Priority Select Register */
#define INTC_PSR468          INTC.PSR[468].R               /* INTC Priority Select Register */
#define INTC_PSR469          INTC.PSR[469].R               /* INTC Priority Select Register */
#define INTC_PSR470          INTC.PSR[470].R               /* INTC Priority Select Register */
#define INTC_PSR471          INTC.PSR[471].R               /* INTC Priority Select Register */
#define INTC_PSR472          INTC.PSR[472].R               /* INTC Priority Select Register */
#define INTC_PSR473          INTC.PSR[473].R               /* INTC Priority Select Register */
#define INTC_PSR474          INTC.PSR[474].R               /* INTC Priority Select Register */
#define INTC_PSR475          INTC.PSR[475].R               /* INTC Priority Select Register */
#define INTC_PSR476          INTC.PSR[476].R               /* INTC Priority Select Register */
#define INTC_PSR477          INTC.PSR[477].R               /* INTC Priority Select Register */
#define INTC_PSR478          INTC.PSR[478].R               /* INTC Priority Select Register */
#define INTC_PSR479          INTC.PSR[479].R               /* INTC Priority Select Register */
#define INTC_PSR480          INTC.PSR[480].R               /* INTC Priority Select Register */
#define INTC_PSR481          INTC.PSR[481].R               /* INTC Priority Select Register */
#define INTC_PSR482          INTC.PSR[482].R               /* INTC Priority Select Register */
#define INTC_PSR483          INTC.PSR[483].R               /* INTC Priority Select Register */
#define INTC_PSR484          INTC.PSR[484].R               /* INTC Priority Select Register */
#define INTC_PSR485          INTC.PSR[485].R               /* INTC Priority Select Register */
#define INTC_PSR486          INTC.PSR[486].R               /* INTC Priority Select Register */
#define INTC_PSR487          INTC.PSR[487].R               /* INTC Priority Select Register */
#define INTC_PSR488          INTC.PSR[488].R               /* INTC Priority Select Register */
#define INTC_PSR489          INTC.PSR[489].R               /* INTC Priority Select Register */
#define INTC_PSR490          INTC.PSR[490].R               /* INTC Priority Select Register */
#define INTC_PSR491          INTC.PSR[491].R               /* INTC Priority Select Register */
#define INTC_PSR492          INTC.PSR[492].R               /* INTC Priority Select Register */
#define INTC_PSR493          INTC.PSR[493].R               /* INTC Priority Select Register */
#define INTC_PSR494          INTC.PSR[494].R               /* INTC Priority Select Register */
#define INTC_PSR495          INTC.PSR[495].R               /* INTC Priority Select Register */
#define INTC_PSR496          INTC.PSR[496].R               /* INTC Priority Select Register */
#define INTC_PSR497          INTC.PSR[497].R               /* INTC Priority Select Register */
#define INTC_PSR498          INTC.PSR[498].R               /* INTC Priority Select Register */
#define INTC_PSR499          INTC.PSR[499].R               /* INTC Priority Select Register */
#define INTC_PSR500          INTC.PSR[500].R               /* INTC Priority Select Register */
#define INTC_PSR501          INTC.PSR[501].R               /* INTC Priority Select Register */
#define INTC_PSR502          INTC.PSR[502].R               /* INTC Priority Select Register */
#define INTC_PSR503          INTC.PSR[503].R               /* INTC Priority Select Register */
#define INTC_PSR504          INTC.PSR[504].R               /* INTC Priority Select Register */
#define INTC_PSR505          INTC.PSR[505].R               /* INTC Priority Select Register */
#define INTC_PSR506          INTC.PSR[506].R               /* INTC Priority Select Register */
#define INTC_PSR507          INTC.PSR[507].R               /* INTC Priority Select Register */
#define INTC_PSR508          INTC.PSR[508].R               /* INTC Priority Select Register */
#define INTC_PSR509          INTC.PSR[509].R               /* INTC Priority Select Register */
#define INTC_PSR510          INTC.PSR[510].R               /* INTC Priority Select Register */
#define INTC_PSR511          INTC.PSR[511].R               /* INTC Priority Select Register */
#define INTC_PSR512          INTC.PSR[512].R               /* INTC Priority Select Register */
#define INTC_PSR513          INTC.PSR[513].R               /* INTC Priority Select Register */
#define INTC_PSR514          INTC.PSR[514].R               /* INTC Priority Select Register */
#define INTC_PSR515          INTC.PSR[515].R               /* INTC Priority Select Register */
#define INTC_PSR516          INTC.PSR[516].R               /* INTC Priority Select Register */
#define INTC_PSR517          INTC.PSR[517].R               /* INTC Priority Select Register */
#define INTC_PSR518          INTC.PSR[518].R               /* INTC Priority Select Register */
#define INTC_PSR519          INTC.PSR[519].R               /* INTC Priority Select Register */
#define INTC_PSR520          INTC.PSR[520].R               /* INTC Priority Select Register */
#define INTC_PSR521          INTC.PSR[521].R               /* INTC Priority Select Register */
#define INTC_PSR522          INTC.PSR[522].R               /* INTC Priority Select Register */
#define INTC_PSR523          INTC.PSR[523].R               /* INTC Priority Select Register */
#define INTC_PSR524          INTC.PSR[524].R               /* INTC Priority Select Register */
#define INTC_PSR525          INTC.PSR[525].R               /* INTC Priority Select Register */
#define INTC_PSR526          INTC.PSR[526].R               /* INTC Priority Select Register */
#define INTC_PSR527          INTC.PSR[527].R               /* INTC Priority Select Register */
#define INTC_PSR528          INTC.PSR[528].R               /* INTC Priority Select Register */
#define INTC_PSR529          INTC.PSR[529].R               /* INTC Priority Select Register */
#define INTC_PSR530          INTC.PSR[530].R               /* INTC Priority Select Register */
#define INTC_PSR531          INTC.PSR[531].R               /* INTC Priority Select Register */
#define INTC_PSR532          INTC.PSR[532].R               /* INTC Priority Select Register */
#define INTC_PSR533          INTC.PSR[533].R               /* INTC Priority Select Register */
#define INTC_PSR534          INTC.PSR[534].R               /* INTC Priority Select Register */
#define INTC_PSR535          INTC.PSR[535].R               /* INTC Priority Select Register */
#define INTC_PSR536          INTC.PSR[536].R               /* INTC Priority Select Register */
#define INTC_PSR537          INTC.PSR[537].R               /* INTC Priority Select Register */
#define INTC_PSR538          INTC.PSR[538].R               /* INTC Priority Select Register */
#define INTC_PSR539          INTC.PSR[539].R               /* INTC Priority Select Register */
#define INTC_PSR540          INTC.PSR[540].R               /* INTC Priority Select Register */
#define INTC_PSR541          INTC.PSR[541].R               /* INTC Priority Select Register */
#define INTC_PSR542          INTC.PSR[542].R               /* INTC Priority Select Register */
#define INTC_PSR543          INTC.PSR[543].R               /* INTC Priority Select Register */
#define INTC_PSR544          INTC.PSR[544].R               /* INTC Priority Select Register */
#define INTC_PSR545          INTC.PSR[545].R               /* INTC Priority Select Register */
#define INTC_PSR546          INTC.PSR[546].R               /* INTC Priority Select Register */
#define INTC_PSR547          INTC.PSR[547].R               /* INTC Priority Select Register */
#define INTC_PSR548          INTC.PSR[548].R               /* INTC Priority Select Register */
#define INTC_PSR549          INTC.PSR[549].R               /* INTC Priority Select Register */
#define INTC_PSR550          INTC.PSR[550].R               /* INTC Priority Select Register */
#define INTC_PSR551          INTC.PSR[551].R               /* INTC Priority Select Register */
#define INTC_PSR552          INTC.PSR[552].R               /* INTC Priority Select Register */
#define INTC_PSR553          INTC.PSR[553].R               /* INTC Priority Select Register */
#define INTC_PSR554          INTC.PSR[554].R               /* INTC Priority Select Register */
#define INTC_PSR555          INTC.PSR[555].R               /* INTC Priority Select Register */
#define INTC_PSR556          INTC.PSR[556].R               /* INTC Priority Select Register */
#define INTC_PSR557          INTC.PSR[557].R               /* INTC Priority Select Register */
#define INTC_PSR558          INTC.PSR[558].R               /* INTC Priority Select Register */
#define INTC_PSR559          INTC.PSR[559].R               /* INTC Priority Select Register */
#define INTC_PSR560          INTC.PSR[560].R               /* INTC Priority Select Register */
#define INTC_PSR561          INTC.PSR[561].R               /* INTC Priority Select Register */
#define INTC_PSR562          INTC.PSR[562].R               /* INTC Priority Select Register */
#define INTC_PSR563          INTC.PSR[563].R               /* INTC Priority Select Register */
#define INTC_PSR564          INTC.PSR[564].R               /* INTC Priority Select Register */
#define INTC_PSR565          INTC.PSR[565].R               /* INTC Priority Select Register */
#define INTC_PSR566          INTC.PSR[566].R               /* INTC Priority Select Register */
#define INTC_PSR567          INTC.PSR[567].R               /* INTC Priority Select Register */
#define INTC_PSR568          INTC.PSR[568].R               /* INTC Priority Select Register */
#define INTC_PSR569          INTC.PSR[569].R               /* INTC Priority Select Register */
#define INTC_PSR570          INTC.PSR[570].R               /* INTC Priority Select Register */
#define INTC_PSR571          INTC.PSR[571].R               /* INTC Priority Select Register */
#define INTC_PSR572          INTC.PSR[572].R               /* INTC Priority Select Register */
#define INTC_PSR573          INTC.PSR[573].R               /* INTC Priority Select Register */
#define INTC_PSR574          INTC.PSR[574].R               /* INTC Priority Select Register */
#define INTC_PSR575          INTC.PSR[575].R               /* INTC Priority Select Register */
#define INTC_PSR576          INTC.PSR[576].R               /* INTC Priority Select Register */
#define INTC_PSR577          INTC.PSR[577].R               /* INTC Priority Select Register */
#define INTC_PSR578          INTC.PSR[578].R               /* INTC Priority Select Register */
#define INTC_PSR579          INTC.PSR[579].R               /* INTC Priority Select Register */
#define INTC_PSR580          INTC.PSR[580].R               /* INTC Priority Select Register */
#define INTC_PSR581          INTC.PSR[581].R               /* INTC Priority Select Register */
#define INTC_PSR582          INTC.PSR[582].R               /* INTC Priority Select Register */
#define INTC_PSR583          INTC.PSR[583].R               /* INTC Priority Select Register */
#define INTC_PSR584          INTC.PSR[584].R               /* INTC Priority Select Register */
#define INTC_PSR585          INTC.PSR[585].R               /* INTC Priority Select Register */
#define INTC_PSR586          INTC.PSR[586].R               /* INTC Priority Select Register */
#define INTC_PSR587          INTC.PSR[587].R               /* INTC Priority Select Register */
#define INTC_PSR588          INTC.PSR[588].R               /* INTC Priority Select Register */
#define INTC_PSR589          INTC.PSR[589].R               /* INTC Priority Select Register */
#define INTC_PSR590          INTC.PSR[590].R               /* INTC Priority Select Register */
#define INTC_PSR591          INTC.PSR[591].R               /* INTC Priority Select Register */
#define INTC_PSR592          INTC.PSR[592].R               /* INTC Priority Select Register */
#define INTC_PSR593          INTC.PSR[593].R               /* INTC Priority Select Register */
#define INTC_PSR594          INTC.PSR[594].R               /* INTC Priority Select Register */
#define INTC_PSR595          INTC.PSR[595].R               /* INTC Priority Select Register */
#define INTC_PSR596          INTC.PSR[596].R               /* INTC Priority Select Register */
#define INTC_PSR597          INTC.PSR[597].R               /* INTC Priority Select Register */
#define INTC_PSR598          INTC.PSR[598].R               /* INTC Priority Select Register */
#define INTC_PSR599          INTC.PSR[599].R               /* INTC Priority Select Register */
#define INTC_PSR600          INTC.PSR[600].R               /* INTC Priority Select Register */
#define INTC_PSR601          INTC.PSR[601].R               /* INTC Priority Select Register */
#define INTC_PSR602          INTC.PSR[602].R               /* INTC Priority Select Register */
#define INTC_PSR603          INTC.PSR[603].R               /* INTC Priority Select Register */
#define INTC_PSR604          INTC.PSR[604].R               /* INTC Priority Select Register */
#define INTC_PSR605          INTC.PSR[605].R               /* INTC Priority Select Register */
#define INTC_PSR606          INTC.PSR[606].R               /* INTC Priority Select Register */
#define INTC_PSR607          INTC.PSR[607].R               /* INTC Priority Select Register */
#define INTC_PSR608          INTC.PSR[608].R               /* INTC Priority Select Register */
#define INTC_PSR609          INTC.PSR[609].R               /* INTC Priority Select Register */
#define INTC_PSR610          INTC.PSR[610].R               /* INTC Priority Select Register */
#define INTC_PSR611          INTC.PSR[611].R               /* INTC Priority Select Register */
#define INTC_PSR612          INTC.PSR[612].R               /* INTC Priority Select Register */
#define INTC_PSR613          INTC.PSR[613].R               /* INTC Priority Select Register */
#define INTC_PSR614          INTC.PSR[614].R               /* INTC Priority Select Register */
#define INTC_PSR615          INTC.PSR[615].R               /* INTC Priority Select Register */
#define INTC_PSR616          INTC.PSR[616].R               /* INTC Priority Select Register */
#define INTC_PSR617          INTC.PSR[617].R               /* INTC Priority Select Register */
#define INTC_PSR618          INTC.PSR[618].R               /* INTC Priority Select Register */
#define INTC_PSR619          INTC.PSR[619].R               /* INTC Priority Select Register */
#define INTC_PSR620          INTC.PSR[620].R               /* INTC Priority Select Register */
#define INTC_PSR621          INTC.PSR[621].R               /* INTC Priority Select Register */
#define INTC_PSR622          INTC.PSR[622].R               /* INTC Priority Select Register */
#define INTC_PSR623          INTC.PSR[623].R               /* INTC Priority Select Register */
#define INTC_PSR624          INTC.PSR[624].R               /* INTC Priority Select Register */
#define INTC_PSR625          INTC.PSR[625].R               /* INTC Priority Select Register */
#define INTC_PSR626          INTC.PSR[626].R               /* INTC Priority Select Register */
#define INTC_PSR627          INTC.PSR[627].R               /* INTC Priority Select Register */
#define INTC_PSR628          INTC.PSR[628].R               /* INTC Priority Select Register */
#define INTC_PSR629          INTC.PSR[629].R               /* INTC Priority Select Register */
#define INTC_PSR630          INTC.PSR[630].R               /* INTC Priority Select Register */
#define INTC_PSR631          INTC.PSR[631].R               /* INTC Priority Select Register */
#define INTC_PSR632          INTC.PSR[632].R               /* INTC Priority Select Register */
#define INTC_PSR633          INTC.PSR[633].R               /* INTC Priority Select Register */
#define INTC_PSR634          INTC.PSR[634].R               /* INTC Priority Select Register */
#define INTC_PSR635          INTC.PSR[635].R               /* INTC Priority Select Register */
#define INTC_PSR636          INTC.PSR[636].R               /* INTC Priority Select Register */
#define INTC_PSR637          INTC.PSR[637].R               /* INTC Priority Select Register */
#define INTC_PSR638          INTC.PSR[638].R               /* INTC Priority Select Register */
#define INTC_PSR639          INTC.PSR[639].R               /* INTC Priority Select Register */
#define INTC_PSR640          INTC.PSR[640].R               /* INTC Priority Select Register */
#define INTC_PSR641          INTC.PSR[641].R               /* INTC Priority Select Register */
#define INTC_PSR642          INTC.PSR[642].R               /* INTC Priority Select Register */
#define INTC_PSR643          INTC.PSR[643].R               /* INTC Priority Select Register */
#define INTC_PSR644          INTC.PSR[644].R               /* INTC Priority Select Register */
#define INTC_PSR645          INTC.PSR[645].R               /* INTC Priority Select Register */
#define INTC_PSR646          INTC.PSR[646].R               /* INTC Priority Select Register */
#define INTC_PSR647          INTC.PSR[647].R               /* INTC Priority Select Register */
#define INTC_PSR648          INTC.PSR[648].R               /* INTC Priority Select Register */
#define INTC_PSR649          INTC.PSR[649].R               /* INTC Priority Select Register */
#define INTC_PSR650          INTC.PSR[650].R               /* INTC Priority Select Register */
#define INTC_PSR651          INTC.PSR[651].R               /* INTC Priority Select Register */
#define INTC_PSR652          INTC.PSR[652].R               /* INTC Priority Select Register */
#define INTC_PSR653          INTC.PSR[653].R               /* INTC Priority Select Register */
#define INTC_PSR654          INTC.PSR[654].R               /* INTC Priority Select Register */
#define INTC_PSR655          INTC.PSR[655].R               /* INTC Priority Select Register */
#define INTC_PSR656          INTC.PSR[656].R               /* INTC Priority Select Register */
#define INTC_PSR657          INTC.PSR[657].R               /* INTC Priority Select Register */
#define INTC_PSR658          INTC.PSR[658].R               /* INTC Priority Select Register */
#define INTC_PSR659          INTC.PSR[659].R               /* INTC Priority Select Register */
#define INTC_PSR660          INTC.PSR[660].R               /* INTC Priority Select Register */
#define INTC_PSR661          INTC.PSR[661].R               /* INTC Priority Select Register */
#define INTC_PSR662          INTC.PSR[662].R               /* INTC Priority Select Register */
#define INTC_PSR663          INTC.PSR[663].R               /* INTC Priority Select Register */
#define INTC_PSR664          INTC.PSR[664].R               /* INTC Priority Select Register */
#define INTC_PSR665          INTC.PSR[665].R               /* INTC Priority Select Register */
#define INTC_PSR666          INTC.PSR[666].R               /* INTC Priority Select Register */
#define INTC_PSR667          INTC.PSR[667].R               /* INTC Priority Select Register */
#define INTC_PSR668          INTC.PSR[668].R               /* INTC Priority Select Register */
#define INTC_PSR669          INTC.PSR[669].R               /* INTC Priority Select Register */
#define INTC_PSR670          INTC.PSR[670].R               /* INTC Priority Select Register */
#define INTC_PSR671          INTC.PSR[671].R               /* INTC Priority Select Register */
#define INTC_PSR672          INTC.PSR[672].R               /* INTC Priority Select Register */
#define INTC_PSR673          INTC.PSR[673].R               /* INTC Priority Select Register */
#define INTC_PSR674          INTC.PSR[674].R               /* INTC Priority Select Register */
#define INTC_PSR675          INTC.PSR[675].R               /* INTC Priority Select Register */
#define INTC_PSR676          INTC.PSR[676].R               /* INTC Priority Select Register */
#define INTC_PSR677          INTC.PSR[677].R               /* INTC Priority Select Register */
#define INTC_PSR678          INTC.PSR[678].R               /* INTC Priority Select Register */
#define INTC_PSR679          INTC.PSR[679].R               /* INTC Priority Select Register */
#define INTC_PSR680          INTC.PSR[680].R               /* INTC Priority Select Register */
#define INTC_PSR681          INTC.PSR[681].R               /* INTC Priority Select Register */
#define INTC_PSR682          INTC.PSR[682].R               /* INTC Priority Select Register */
#define INTC_PSR683          INTC.PSR[683].R               /* INTC Priority Select Register */
#define INTC_PSR684          INTC.PSR[684].R               /* INTC Priority Select Register */
#define INTC_PSR685          INTC.PSR[685].R               /* INTC Priority Select Register */
#define INTC_PSR686          INTC.PSR[686].R               /* INTC Priority Select Register */
#define INTC_PSR687          INTC.PSR[687].R               /* INTC Priority Select Register */
#define INTC_PSR688          INTC.PSR[688].R               /* INTC Priority Select Register */
#define INTC_PSR689          INTC.PSR[689].R               /* INTC Priority Select Register */
#define INTC_PSR690          INTC.PSR[690].R               /* INTC Priority Select Register */
#define INTC_PSR691          INTC.PSR[691].R               /* INTC Priority Select Register */
#define INTC_PSR692          INTC.PSR[692].R               /* INTC Priority Select Register */
#define INTC_PSR693          INTC.PSR[693].R               /* INTC Priority Select Register */
#define INTC_PSR694          INTC.PSR[694].R               /* INTC Priority Select Register */
#define INTC_PSR695          INTC.PSR[695].R               /* INTC Priority Select Register */
#define INTC_PSR696          INTC.PSR[696].R               /* INTC Priority Select Register */
#define INTC_PSR697          INTC.PSR[697].R               /* INTC Priority Select Register */
#define INTC_PSR698          INTC.PSR[698].R               /* INTC Priority Select Register */
#define INTC_PSR699          INTC.PSR[699].R               /* INTC Priority Select Register */
#define INTC_PSR700          INTC.PSR[700].R               /* INTC Priority Select Register */
#define INTC_PSR701          INTC.PSR[701].R               /* INTC Priority Select Register */
#define INTC_PSR702          INTC.PSR[702].R               /* INTC Priority Select Register */
#define INTC_PSR703          INTC.PSR[703].R               /* INTC Priority Select Register */
#define INTC_PSR704          INTC.PSR[704].R               /* INTC Priority Select Register */
#define INTC_PSR705          INTC.PSR[705].R               /* INTC Priority Select Register */
#define INTC_PSR706          INTC.PSR[706].R               /* INTC Priority Select Register */
#define INTC_PSR707          INTC.PSR[707].R               /* INTC Priority Select Register */
#define INTC_PSR708          INTC.PSR[708].R               /* INTC Priority Select Register */
#define INTC_PSR709          INTC.PSR[709].R               /* INTC Priority Select Register */
#define INTC_PSR710          INTC.PSR[710].R               /* INTC Priority Select Register */
#define INTC_PSR711          INTC.PSR[711].R               /* INTC Priority Select Register */
#define INTC_PSR712          INTC.PSR[712].R               /* INTC Priority Select Register */
#define INTC_PSR713          INTC.PSR[713].R               /* INTC Priority Select Register */
#define INTC_PSR714          INTC.PSR[714].R               /* INTC Priority Select Register */
#define INTC_PSR715          INTC.PSR[715].R               /* INTC Priority Select Register */
#define INTC_PSR716          INTC.PSR[716].R               /* INTC Priority Select Register */
#define INTC_PSR717          INTC.PSR[717].R               /* INTC Priority Select Register */
#define INTC_PSR718          INTC.PSR[718].R               /* INTC Priority Select Register */
#define INTC_PSR719          INTC.PSR[719].R               /* INTC Priority Select Register */
#define INTC_PSR720          INTC.PSR[720].R               /* INTC Priority Select Register */
#define INTC_PSR721          INTC.PSR[721].R               /* INTC Priority Select Register */
#define INTC_PSR722          INTC.PSR[722].R               /* INTC Priority Select Register */
#define INTC_PSR723          INTC.PSR[723].R               /* INTC Priority Select Register */
#define INTC_PSR724          INTC.PSR[724].R               /* INTC Priority Select Register */
#define INTC_PSR725          INTC.PSR[725].R               /* INTC Priority Select Register */
#define INTC_PSR726          INTC.PSR[726].R               /* INTC Priority Select Register */
#define INTC_PSR727          INTC.PSR[727].R               /* INTC Priority Select Register */
#define INTC_PSR728          INTC.PSR[728].R               /* INTC Priority Select Register */
#define INTC_PSR729          INTC.PSR[729].R               /* INTC Priority Select Register */
#define INTC_PSR730          INTC.PSR[730].R               /* INTC Priority Select Register */
#define INTC_PSR731          INTC.PSR[731].R               /* INTC Priority Select Register */
#define INTC_PSR732          INTC.PSR[732].R               /* INTC Priority Select Register */
#define INTC_PSR733          INTC.PSR[733].R               /* INTC Priority Select Register */
#define INTC_PSR734          INTC.PSR[734].R               /* INTC Priority Select Register */
#define INTC_PSR735          INTC.PSR[735].R               /* INTC Priority Select Register */
#define INTC_PSR736          INTC.PSR[736].R               /* INTC Priority Select Register */
#define INTC_PSR737          INTC.PSR[737].R               /* INTC Priority Select Register */
#define INTC_PSR738          INTC.PSR[738].R               /* INTC Priority Select Register */
#define INTC_PSR739          INTC.PSR[739].R               /* INTC Priority Select Register */
#define INTC_PSR740          INTC.PSR[740].R               /* INTC Priority Select Register */
#define INTC_PSR741          INTC.PSR[741].R               /* INTC Priority Select Register */
#define INTC_PSR742          INTC.PSR[742].R               /* INTC Priority Select Register */
#define INTC_PSR743          INTC.PSR[743].R               /* INTC Priority Select Register */
#define INTC_PSR744          INTC.PSR[744].R               /* INTC Priority Select Register */
#define INTC_PSR745          INTC.PSR[745].R               /* INTC Priority Select Register */
#define INTC_PSR746          INTC.PSR[746].R               /* INTC Priority Select Register */
#define INTC_PSR747          INTC.PSR[747].R               /* INTC Priority Select Register */
#define INTC_PSR748          INTC.PSR[748].R               /* INTC Priority Select Register */
#define INTC_PSR749          INTC.PSR[749].R               /* INTC Priority Select Register */
#define INTC_PSR750          INTC.PSR[750].R               /* INTC Priority Select Register */
#define INTC_PSR751          INTC.PSR[751].R               /* INTC Priority Select Register */
#define INTC_PSR752          INTC.PSR[752].R               /* INTC Priority Select Register */
#define INTC_PSR753          INTC.PSR[753].R               /* INTC Priority Select Register */
#define INTC_PSR754          INTC.PSR[754].R               /* INTC Priority Select Register */
#define INTC_PSR755          INTC.PSR[755].R               /* INTC Priority Select Register */
#define INTC_PSR756          INTC.PSR[756].R               /* INTC Priority Select Register */
#define INTC_PSR757          INTC.PSR[757].R               /* INTC Priority Select Register */
#define INTC_PSR758          INTC.PSR[758].R               /* INTC Priority Select Register */
#define INTC_PSR759          INTC.PSR[759].R               /* INTC Priority Select Register */
#define INTC_PSR760          INTC.PSR[760].R               /* INTC Priority Select Register */
#define INTC_PSR761          INTC.PSR[761].R               /* INTC Priority Select Register */
#define INTC_PSR762          INTC.PSR[762].R               /* INTC Priority Select Register */
#define INTC_PSR763          INTC.PSR[763].R               /* INTC Priority Select Register */
#define INTC_PSR764          INTC.PSR[764].R               /* INTC Priority Select Register */
#define INTC_PSR765          INTC.PSR[765].R               /* INTC Priority Select Register */
#define INTC_PSR766          INTC.PSR[766].R               /* INTC Priority Select Register */
#define INTC_PSR767          INTC.PSR[767].R               /* INTC Priority Select Register */
#define INTC_PSR768          INTC.PSR[768].R               /* INTC Priority Select Register */
#define INTC_PSR769          INTC.PSR[769].R               /* INTC Priority Select Register */
#define INTC_PSR770          INTC.PSR[770].R               /* INTC Priority Select Register */
#define INTC_PSR771          INTC.PSR[771].R               /* INTC Priority Select Register */
#define INTC_PSR772          INTC.PSR[772].R               /* INTC Priority Select Register */
#define INTC_PSR773          INTC.PSR[773].R               /* INTC Priority Select Register */
#define INTC_PSR774          INTC.PSR[774].R               /* INTC Priority Select Register */
#define INTC_PSR775          INTC.PSR[775].R               /* INTC Priority Select Register */
#define INTC_PSR776          INTC.PSR[776].R               /* INTC Priority Select Register */
#define INTC_PSR777          INTC.PSR[777].R               /* INTC Priority Select Register */
#define INTC_PSR778          INTC.PSR[778].R               /* INTC Priority Select Register */
#define INTC_PSR779          INTC.PSR[779].R               /* INTC Priority Select Register */
#define INTC_PSR780          INTC.PSR[780].R               /* INTC Priority Select Register */
#define INTC_PSR781          INTC.PSR[781].R               /* INTC Priority Select Register */
#define INTC_PSR782          INTC.PSR[782].R               /* INTC Priority Select Register */
#define INTC_PSR783          INTC.PSR[783].R               /* INTC Priority Select Register */
#define INTC_PSR784          INTC.PSR[784].R               /* INTC Priority Select Register */
#define INTC_PSR785          INTC.PSR[785].R               /* INTC Priority Select Register */
#define INTC_PSR786          INTC.PSR[786].R               /* INTC Priority Select Register */
#define INTC_PSR787          INTC.PSR[787].R               /* INTC Priority Select Register */
#define INTC_PSR788          INTC.PSR[788].R               /* INTC Priority Select Register */
#define INTC_PSR789          INTC.PSR[789].R               /* INTC Priority Select Register */
#define INTC_PSR790          INTC.PSR[790].R               /* INTC Priority Select Register */
#define INTC_PSR791          INTC.PSR[791].R               /* INTC Priority Select Register */
#define INTC_PSR792          INTC.PSR[792].R               /* INTC Priority Select Register */
#define INTC_PSR793          INTC.PSR[793].R               /* INTC Priority Select Register */
#define INTC_PSR794          INTC.PSR[794].R               /* INTC Priority Select Register */
#define INTC_PSR795          INTC.PSR[795].R               /* INTC Priority Select Register */
#define INTC_PSR796          INTC.PSR[796].R               /* INTC Priority Select Register */
#define INTC_PSR797          INTC.PSR[797].R               /* INTC Priority Select Register */
#define INTC_PSR798          INTC.PSR[798].R               /* INTC Priority Select Register */
#define INTC_PSR799          INTC.PSR[799].R               /* INTC Priority Select Register */
#define INTC_PSR800          INTC.PSR[800].R               /* INTC Priority Select Register */
#define INTC_PSR801          INTC.PSR[801].R               /* INTC Priority Select Register */
#define INTC_PSR802          INTC.PSR[802].R               /* INTC Priority Select Register */
#define INTC_PSR803          INTC.PSR[803].R               /* INTC Priority Select Register */
#define INTC_PSR804          INTC.PSR[804].R               /* INTC Priority Select Register */
#define INTC_PSR805          INTC.PSR[805].R               /* INTC Priority Select Register */
#define INTC_PSR806          INTC.PSR[806].R               /* INTC Priority Select Register */
#define INTC_PSR807          INTC.PSR[807].R               /* INTC Priority Select Register */
#define INTC_PSR808          INTC.PSR[808].R               /* INTC Priority Select Register */
#define INTC_PSR809          INTC.PSR[809].R               /* INTC Priority Select Register */
#define INTC_PSR810          INTC.PSR[810].R               /* INTC Priority Select Register */
#define INTC_PSR811          INTC.PSR[811].R               /* INTC Priority Select Register */
#define INTC_PSR812          INTC.PSR[812].R               /* INTC Priority Select Register */
#define INTC_PSR813          INTC.PSR[813].R               /* INTC Priority Select Register */
#define INTC_PSR814          INTC.PSR[814].R               /* INTC Priority Select Register */
#define INTC_PSR815          INTC.PSR[815].R               /* INTC Priority Select Register */
#define INTC_PSR816          INTC.PSR[816].R               /* INTC Priority Select Register */
#define INTC_PSR817          INTC.PSR[817].R               /* INTC Priority Select Register */
#define INTC_PSR818          INTC.PSR[818].R               /* INTC Priority Select Register */
#define INTC_PSR819          INTC.PSR[819].R               /* INTC Priority Select Register */
#define INTC_PSR820          INTC.PSR[820].R               /* INTC Priority Select Register */
#define INTC_PSR821          INTC.PSR[821].R               /* INTC Priority Select Register */
#define INTC_PSR822          INTC.PSR[822].R               /* INTC Priority Select Register */
#define INTC_PSR823          INTC.PSR[823].R               /* INTC Priority Select Register */
#define INTC_PSR824          INTC.PSR[824].R               /* INTC Priority Select Register */
#define INTC_PSR825          INTC.PSR[825].R               /* INTC Priority Select Register */
#define INTC_PSR826          INTC.PSR[826].R               /* INTC Priority Select Register */
#define INTC_PSR827          INTC.PSR[827].R               /* INTC Priority Select Register */
#define INTC_PSR828          INTC.PSR[828].R               /* INTC Priority Select Register */
#define INTC_PSR829          INTC.PSR[829].R               /* INTC Priority Select Register */
#define INTC_PSR830          INTC.PSR[830].R               /* INTC Priority Select Register */
#define INTC_PSR831          INTC.PSR[831].R               /* INTC Priority Select Register */
#define INTC_PSR832          INTC.PSR[832].R               /* INTC Priority Select Register */
#define INTC_PSR833          INTC.PSR[833].R               /* INTC Priority Select Register */
#define INTC_PSR834          INTC.PSR[834].R               /* INTC Priority Select Register */
#define INTC_PSR835          INTC.PSR[835].R               /* INTC Priority Select Register */
#define INTC_PSR836          INTC.PSR[836].R               /* INTC Priority Select Register */
#define INTC_PSR837          INTC.PSR[837].R               /* INTC Priority Select Register */
#define INTC_PSR838          INTC.PSR[838].R               /* INTC Priority Select Register */
#define INTC_PSR839          INTC.PSR[839].R               /* INTC Priority Select Register */
#define INTC_PSR840          INTC.PSR[840].R               /* INTC Priority Select Register */
#define INTC_PSR841          INTC.PSR[841].R               /* INTC Priority Select Register */
#define INTC_PSR842          INTC.PSR[842].R               /* INTC Priority Select Register */
#define INTC_PSR843          INTC.PSR[843].R               /* INTC Priority Select Register */
#define INTC_PSR844          INTC.PSR[844].R               /* INTC Priority Select Register */
#define INTC_PSR845          INTC.PSR[845].R               /* INTC Priority Select Register */
#define INTC_PSR846          INTC.PSR[846].R               /* INTC Priority Select Register */
#define INTC_PSR847          INTC.PSR[847].R               /* INTC Priority Select Register */
#define INTC_PSR848          INTC.PSR[848].R               /* INTC Priority Select Register */
#define INTC_PSR849          INTC.PSR[849].R               /* INTC Priority Select Register */
#define INTC_PSR850          INTC.PSR[850].R               /* INTC Priority Select Register */
#define INTC_PSR851          INTC.PSR[851].R               /* INTC Priority Select Register */
#define INTC_PSR852          INTC.PSR[852].R               /* INTC Priority Select Register */
#define INTC_PSR853          INTC.PSR[853].R               /* INTC Priority Select Register */
#define INTC_PSR854          INTC.PSR[854].R               /* INTC Priority Select Register */
#define INTC_PSR855          INTC.PSR[855].R               /* INTC Priority Select Register */
#define INTC_PSR856          INTC.PSR[856].R               /* INTC Priority Select Register */
#define INTC_PSR857          INTC.PSR[857].R               /* INTC Priority Select Register */
#define INTC_PSR858          INTC.PSR[858].R               /* INTC Priority Select Register */
#define INTC_PSR859          INTC.PSR[859].R               /* INTC Priority Select Register */
#define INTC_PSR860          INTC.PSR[860].R               /* INTC Priority Select Register */
#define INTC_PSR861          INTC.PSR[861].R               /* INTC Priority Select Register */
#define INTC_PSR862          INTC.PSR[862].R               /* INTC Priority Select Register */
#define INTC_PSR863          INTC.PSR[863].R               /* INTC Priority Select Register */
#define INTC_PSR864          INTC.PSR[864].R               /* INTC Priority Select Register */
#define INTC_PSR865          INTC.PSR[865].R               /* INTC Priority Select Register */
#define INTC_PSR866          INTC.PSR[866].R               /* INTC Priority Select Register */
#define INTC_PSR867          INTC.PSR[867].R               /* INTC Priority Select Register */
#define INTC_PSR868          INTC.PSR[868].R               /* INTC Priority Select Register */
#define INTC_PSR869          INTC.PSR[869].R               /* INTC Priority Select Register */
#define INTC_PSR870          INTC.PSR[870].R               /* INTC Priority Select Register */
#define INTC_PSR871          INTC.PSR[871].R               /* INTC Priority Select Register */
#define INTC_PSR872          INTC.PSR[872].R               /* INTC Priority Select Register */
#define INTC_PSR873          INTC.PSR[873].R               /* INTC Priority Select Register */
#define INTC_PSR874          INTC.PSR[874].R               /* INTC Priority Select Register */
#define INTC_PSR875          INTC.PSR[875].R               /* INTC Priority Select Register */
#define INTC_PSR876          INTC.PSR[876].R               /* INTC Priority Select Register */
#define INTC_PSR877          INTC.PSR[877].R               /* INTC Priority Select Register */
#define INTC_PSR878          INTC.PSR[878].R               /* INTC Priority Select Register */
#define INTC_PSR879          INTC.PSR[879].R               /* INTC Priority Select Register */
#define INTC_PSR880          INTC.PSR[880].R               /* INTC Priority Select Register */
#define INTC_PSR881          INTC.PSR[881].R               /* INTC Priority Select Register */
#define INTC_PSR882          INTC.PSR[882].R               /* INTC Priority Select Register */
#define INTC_PSR883          INTC.PSR[883].R               /* INTC Priority Select Register */
#define INTC_PSR884          INTC.PSR[884].R               /* INTC Priority Select Register */
#define INTC_PSR885          INTC.PSR[885].R               /* INTC Priority Select Register */
#define INTC_PSR886          INTC.PSR[886].R               /* INTC Priority Select Register */
#define INTC_PSR887          INTC.PSR[887].R               /* INTC Priority Select Register */
#define INTC_PSR888          INTC.PSR[888].R               /* INTC Priority Select Register */
#define INTC_PSR889          INTC.PSR[889].R               /* INTC Priority Select Register */
#define INTC_PSR890          INTC.PSR[890].R               /* INTC Priority Select Register */
#define INTC_PSR891          INTC.PSR[891].R               /* INTC Priority Select Register */
#define INTC_PSR892          INTC.PSR[892].R               /* INTC Priority Select Register */
#define INTC_PSR893          INTC.PSR[893].R               /* INTC Priority Select Register */
#define INTC_PSR894          INTC.PSR[894].R               /* INTC Priority Select Register */
#define INTC_PSR895          INTC.PSR[895].R               /* INTC Priority Select Register */
#define INTC_PSR896          INTC.PSR[896].R               /* INTC Priority Select Register */
#define INTC_PSR897          INTC.PSR[897].R               /* INTC Priority Select Register */
#define INTC_PSR898          INTC.PSR[898].R               /* INTC Priority Select Register */
#define INTC_PSR899          INTC.PSR[899].R               /* INTC Priority Select Register */
#define INTC_PSR900          INTC.PSR[900].R               /* INTC Priority Select Register */
#define INTC_PSR901          INTC.PSR[901].R               /* INTC Priority Select Register */
#define INTC_PSR902          INTC.PSR[902].R               /* INTC Priority Select Register */
#define INTC_PSR903          INTC.PSR[903].R               /* INTC Priority Select Register */
#define INTC_PSR904          INTC.PSR[904].R               /* INTC Priority Select Register */
#define INTC_PSR905          INTC.PSR[905].R               /* INTC Priority Select Register */
#define INTC_PSR906          INTC.PSR[906].R               /* INTC Priority Select Register */
#define INTC_PSR907          INTC.PSR[907].R               /* INTC Priority Select Register */
#define INTC_PSR908          INTC.PSR[908].R               /* INTC Priority Select Register */
#define INTC_PSR909          INTC.PSR[909].R               /* INTC Priority Select Register */
#define INTC_PSR910          INTC.PSR[910].R               /* INTC Priority Select Register */
#define INTC_PSR911          INTC.PSR[911].R               /* INTC Priority Select Register */
#define INTC_PSR912          INTC.PSR[912].R               /* INTC Priority Select Register */
#define INTC_PSR913          INTC.PSR[913].R               /* INTC Priority Select Register */
#define INTC_PSR914          INTC.PSR[914].R               /* INTC Priority Select Register */
#define INTC_PSR915          INTC.PSR[915].R               /* INTC Priority Select Register */
#define INTC_PSR916          INTC.PSR[916].R               /* INTC Priority Select Register */
#define INTC_PSR917          INTC.PSR[917].R               /* INTC Priority Select Register */
#define INTC_PSR918          INTC.PSR[918].R               /* INTC Priority Select Register */
#define INTC_PSR919          INTC.PSR[919].R               /* INTC Priority Select Register */
#define INTC_PSR920          INTC.PSR[920].R               /* INTC Priority Select Register */
#define INTC_PSR921          INTC.PSR[921].R               /* INTC Priority Select Register */
#define INTC_PSR922          INTC.PSR[922].R               /* INTC Priority Select Register */
#define INTC_PSR923          INTC.PSR[923].R               /* INTC Priority Select Register */
#define INTC_PSR924          INTC.PSR[924].R               /* INTC Priority Select Register */
#define INTC_PSR925          INTC.PSR[925].R               /* INTC Priority Select Register */
#define INTC_PSR926          INTC.PSR[926].R               /* INTC Priority Select Register */
#define INTC_PSR927          INTC.PSR[927].R               /* INTC Priority Select Register */
#define INTC_PSR928          INTC.PSR[928].R               /* INTC Priority Select Register */
#define INTC_PSR929          INTC.PSR[929].R               /* INTC Priority Select Register */
#define INTC_PSR930          INTC.PSR[930].R               /* INTC Priority Select Register */
#define INTC_PSR931          INTC.PSR[931].R               /* INTC Priority Select Register */
#define INTC_PSR932          INTC.PSR[932].R               /* INTC Priority Select Register */
#define INTC_PSR933          INTC.PSR[933].R               /* INTC Priority Select Register */
#define INTC_PSR934          INTC.PSR[934].R               /* INTC Priority Select Register */
#define INTC_PSR935          INTC.PSR[935].R               /* INTC Priority Select Register */
#define INTC_PSR936          INTC.PSR[936].R               /* INTC Priority Select Register */
#define INTC_PSR937          INTC.PSR[937].R               /* INTC Priority Select Register */
#define INTC_PSR938          INTC.PSR[938].R               /* INTC Priority Select Register */
#define INTC_PSR939          INTC.PSR[939].R               /* INTC Priority Select Register */
#define INTC_PSR940          INTC.PSR[940].R               /* INTC Priority Select Register */
#define INTC_PSR941          INTC.PSR[941].R               /* INTC Priority Select Register */
#define INTC_PSR942          INTC.PSR[942].R               /* INTC Priority Select Register */
#define INTC_PSR943          INTC.PSR[943].R               /* INTC Priority Select Register */
#define INTC_PSR944          INTC.PSR[944].R               /* INTC Priority Select Register */
#define INTC_PSR945          INTC.PSR[945].R               /* INTC Priority Select Register */
#define INTC_PSR946          INTC.PSR[946].R               /* INTC Priority Select Register */
#define INTC_PSR947          INTC.PSR[947].R               /* INTC Priority Select Register */
#define INTC_PSR948          INTC.PSR[948].R               /* INTC Priority Select Register */
#define INTC_PSR949          INTC.PSR[949].R               /* INTC Priority Select Register */
#define INTC_PSR950          INTC.PSR[950].R               /* INTC Priority Select Register */
#define INTC_PSR951          INTC.PSR[951].R               /* INTC Priority Select Register */
#define INTC_PSR952          INTC.PSR[952].R               /* INTC Priority Select Register */
#define INTC_PSR953          INTC.PSR[953].R               /* INTC Priority Select Register */
#define INTC_PSR954          INTC.PSR[954].R               /* INTC Priority Select Register */
#define INTC_PSR955          INTC.PSR[955].R               /* INTC Priority Select Register */
#define INTC_PSR956          INTC.PSR[956].R               /* INTC Priority Select Register */
#define INTC_PSR957          INTC.PSR[957].R               /* INTC Priority Select Register */
#define INTC_PSR958          INTC.PSR[958].R               /* INTC Priority Select Register */
#define INTC_PSR959          INTC.PSR[959].R               /* INTC Priority Select Register */
#define INTC_PSR960          INTC.PSR[960].R               /* INTC Priority Select Register */
#define INTC_PSR961          INTC.PSR[961].R               /* INTC Priority Select Register */
#define INTC_PSR962          INTC.PSR[962].R               /* INTC Priority Select Register */
#define INTC_PSR963          INTC.PSR[963].R               /* INTC Priority Select Register */
#define INTC_PSR964          INTC.PSR[964].R               /* INTC Priority Select Register */
#define INTC_PSR965          INTC.PSR[965].R               /* INTC Priority Select Register */
#define INTC_PSR966          INTC.PSR[966].R               /* INTC Priority Select Register */
#define INTC_PSR967          INTC.PSR[967].R               /* INTC Priority Select Register */
#define INTC_PSR968          INTC.PSR[968].R               /* INTC Priority Select Register */
#define INTC_PSR969          INTC.PSR[969].R               /* INTC Priority Select Register */
#define INTC_PSR970          INTC.PSR[970].R               /* INTC Priority Select Register */
#define INTC_PSR971          INTC.PSR[971].R               /* INTC Priority Select Register */
#define INTC_PSR972          INTC.PSR[972].R               /* INTC Priority Select Register */
#define INTC_PSR973          INTC.PSR[973].R               /* INTC Priority Select Register */
#define INTC_PSR974          INTC.PSR[974].R               /* INTC Priority Select Register */
#define INTC_PSR975          INTC.PSR[975].R               /* INTC Priority Select Register */
#define INTC_PSR976          INTC.PSR[976].R               /* INTC Priority Select Register */
#define INTC_PSR977          INTC.PSR[977].R               /* INTC Priority Select Register */
#define INTC_PSR978          INTC.PSR[978].R               /* INTC Priority Select Register */
#define INTC_PSR979          INTC.PSR[979].R               /* INTC Priority Select Register */
#define INTC_PSR980          INTC.PSR[980].R               /* INTC Priority Select Register */
#define INTC_PSR981          INTC.PSR[981].R               /* INTC Priority Select Register */
#define INTC_PSR982          INTC.PSR[982].R               /* INTC Priority Select Register */
#define INTC_PSR983          INTC.PSR[983].R               /* INTC Priority Select Register */
#define INTC_PSR984          INTC.PSR[984].R               /* INTC Priority Select Register */
#define INTC_PSR985          INTC.PSR[985].R               /* INTC Priority Select Register */
#define INTC_PSR986          INTC.PSR[986].R               /* INTC Priority Select Register */
#define INTC_PSR987          INTC.PSR[987].R               /* INTC Priority Select Register */
#define INTC_PSR988          INTC.PSR[988].R               /* INTC Priority Select Register */
#define INTC_PSR989          INTC.PSR[989].R               /* INTC Priority Select Register */
#define INTC_PSR990          INTC.PSR[990].R               /* INTC Priority Select Register */
#define INTC_PSR991          INTC.PSR[991].R               /* INTC Priority Select Register */
#define INTC_PSR992          INTC.PSR[992].R               /* INTC Priority Select Register */
#define INTC_PSR993          INTC.PSR[993].R               /* INTC Priority Select Register */
#define INTC_PSR994          INTC.PSR[994].R               /* INTC Priority Select Register */
#define INTC_PSR995          INTC.PSR[995].R               /* INTC Priority Select Register */
#define INTC_PSR996          INTC.PSR[996].R               /* INTC Priority Select Register */
#define INTC_PSR997          INTC.PSR[997].R               /* INTC Priority Select Register */
#define INTC_PSR998          INTC.PSR[998].R               /* INTC Priority Select Register */
#define INTC_PSR999          INTC.PSR[999].R               /* INTC Priority Select Register */
#define INTC_PSR1000         INTC.PSR[1000].R              /* INTC Priority Select Register */
#define INTC_PSR1001         INTC.PSR[1001].R              /* INTC Priority Select Register */
#define INTC_PSR1002         INTC.PSR[1002].R              /* INTC Priority Select Register */
#define INTC_PSR1003         INTC.PSR[1003].R              /* INTC Priority Select Register */
#define INTC_PSR1004         INTC.PSR[1004].R              /* INTC Priority Select Register */
#define INTC_PSR1005         INTC.PSR[1005].R              /* INTC Priority Select Register */
#define INTC_PSR1006         INTC.PSR[1006].R              /* INTC Priority Select Register */
#define INTC_PSR1007         INTC.PSR[1007].R              /* INTC Priority Select Register */
#define INTC_PSR1008         INTC.PSR[1008].R              /* INTC Priority Select Register */
#define INTC_PSR1009         INTC.PSR[1009].R              /* INTC Priority Select Register */
#define INTC_PSR1010         INTC.PSR[1010].R              /* INTC Priority Select Register */
#define INTC_PSR1011         INTC.PSR[1011].R              /* INTC Priority Select Register */
#define INTC_PSR1012         INTC.PSR[1012].R              /* INTC Priority Select Register */
#define INTC_PSR1013         INTC.PSR[1013].R              /* INTC Priority Select Register */
#define INTC_PSR1014         INTC.PSR[1014].R              /* INTC Priority Select Register */
#define INTC_PSR1015         INTC.PSR[1015].R              /* INTC Priority Select Register */
#define INTC_PSR1016         INTC.PSR[1016].R              /* INTC Priority Select Register */
#define INTC_PSR1017         INTC.PSR[1017].R              /* INTC Priority Select Register */
#define INTC_PSR1018         INTC.PSR[1018].R              /* INTC Priority Select Register */
#define INTC_PSR1019         INTC.PSR[1019].R              /* INTC Priority Select Register */
#define INTC_PSR1020         INTC.PSR[1020].R              /* INTC Priority Select Register */
#define INTC_PSR1021         INTC.PSR[1021].R              /* INTC Priority Select Register */
#define INTC_PSR1022         INTC.PSR[1022].R              /* INTC Priority Select Register */
#define INTC_PSR1023         INTC.PSR[1023].R              /* INTC Priority Select Register */
#define INTC_MMRC1           INTC.MMRC1.R                  /* INTC Monitor Mode Register 1 */
#define INTC_HIPRI0C1        INTC.HIPRIC1[0].R             /* INTC HIPRI Register */
#define INTC_HIPRI1C1        INTC.HIPRIC1[1].R             /* INTC HIPRI Register */
#define INTC_HIPRI2C1        INTC.HIPRIC1[2].R             /* INTC HIPRI Register */
#define INTC_LAT0C1          INTC.LATC1[0].R               /* INTC LAT Register */
#define INTC_LAT1C1          INTC.LATC1[1].R               /* INTC LAT Register */
#define INTC_LAT2C1          INTC.LATC1[2].R               /* INTC LAT Register */
#define INTC_TIMER0C1        INTC.TIMERC1[0].R             /* INTC Timer Register */
#define INTC_TIMER1C1        INTC.TIMERC1[1].R             /* INTC Timer Register */
#define INTC_TIMER2C1        INTC.TIMERC1[2].R             /* INTC Timer Register */
#define INTC_MMRC2           INTC.MMRC2.R                  /* INTC Monitor Mode Register 2 */
#define INTC_HIPRI0C2        INTC.HIPRIC2[0].R             /* INTC HIPRI Register */
#define INTC_HIPRI1C2        INTC.HIPRIC2[1].R             /* INTC HIPRI Register */
#define INTC_HIPRI2C2        INTC.HIPRIC2[2].R             /* INTC HIPRI Register */
#define INTC_LAT0C2          INTC.LATC2[0].R               /* INTC LAT Register */
#define INTC_LAT1C2          INTC.LATC2[1].R               /* INTC LAT Register */
#define INTC_LAT2C2          INTC.LATC2[2].R               /* INTC LAT Register */
#define INTC_TIMER0C2        INTC.TIMERC2[0].R             /* INTC Timer Register */
#define INTC_TIMER1C2        INTC.TIMERC2[1].R             /* INTC Timer Register */
#define INTC_TIMER2C2        INTC.TIMERC2[2].R             /* INTC Timer Register */

/* IRCOSC */
#define IRCOSC_CTL           IRCOSC.CTL.R                  /* IRCOSC Control Register */

/* JTAGM */
#define JTAGM_MCR            JTAGM.MCR.R                   /* Module Configuration Register */
#define JTAGM_SR             JTAGM.SR.R                    /* Status Register */
#define JTAGM_DOR0           JTAGM.DOR0.R                  /* Data Out Register 0 */
#define JTAGM_DOR1           JTAGM.DOR1.R                  /* Data Out Register 1 */
#define JTAGM_DOR2           JTAGM.DOR2.R                  /* Data Out Register 2 */
#define JTAGM_DOR3           JTAGM.DOR3.R                  /* Data Out Register 3 */
#define JTAGM_DIR0           JTAGM.DIR0.R                  /* Data Input Register 0 */
#define JTAGM_DIR1           JTAGM.DIR1.R                  /* Data Input Register 1 */

/* LINFlexD */
#define LINFlexD_1_LINCR1    LINFlexD_1.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_1_LINIER    LINFlexD_1.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_1_LINSR     LINFlexD_1.LINSR.R            /* LIN Status Register */
#define LINFlexD_1_LINESR    LINFlexD_1.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_1_UARTCR    LINFlexD_1.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_1_UARTSR    LINFlexD_1.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_1_LINTCSR   LINFlexD_1.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_1_LINOCR    LINFlexD_1.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_1_LINTOCR   LINFlexD_1.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_1_LINFBRR   LINFlexD_1.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_1_LINIBRR   LINFlexD_1.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_1_LINCFR    LINFlexD_1.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_1_LINCR2    LINFlexD_1.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_1_BIDR      LINFlexD_1.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_1_BDRL      LINFlexD_1.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_1_BDRM      LINFlexD_1.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_1_IFER      LINFlexD_1.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_1_IFMI      LINFlexD_1.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_1_IFMR      LINFlexD_1.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_1_IFCR0     LINFlexD_1.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR1     LINFlexD_1.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR2     LINFlexD_1.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR3     LINFlexD_1.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR4     LINFlexD_1.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR5     LINFlexD_1.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR6     LINFlexD_1.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR7     LINFlexD_1.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR8     LINFlexD_1.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR9     LINFlexD_1.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR10    LINFlexD_1.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR11    LINFlexD_1.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR12    LINFlexD_1.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR13    LINFlexD_1.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR14    LINFlexD_1.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR15    LINFlexD_1.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_1_GCR       LINFlexD_1.GCR.R              /* Global Control Register */
#define LINFlexD_1_UARTPTO   LINFlexD_1.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_1_UARTCTO   LINFlexD_1.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_1_DMATXE    LINFlexD_1.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_1_DMARXE    LINFlexD_1.DMARXE.R           /* DMA Rx Enable Register */

/* MCB */
#define MCB_NPC_SPECIAL_ENABLE MCB.NPC_SPECIAL_ENABLE.R    /* NPC Special Enable Control */
#define MCB_AFE_LVD_MASK     MCB.AFE_LVD_MASK.R            /* AFE LVD Mask */
#define MCB_MISC1            MCB.MISC1.R                   /* Miscellaneous 1 register */
#define MCB_MISC2            MCB.MISC2.R                   /* Miscellaneous 2 Register */
#define MCB_MISC3            MCB.MISC3.R                   /* Miscellaneous 3 Register */
#define MCB_NEX_FIFO_STATUS  MCB.NEX_FIFO_STATUS.R         /* Nexus Trace Fifo Status Register */
#define MCB_CLKOUT_SEL       MCB.CLKOUT_SEL.R              /* CLKOUT Source Select */

/* MC_CGM */
#define MC_CGM_PCS_SDUR      MC_CGM.PCS_SDUR.R             /* PCS Switch Duration Register */
#define MC_CGM_PCS_DIVC1     MC_CGM.PCS_DIVC1.R            /* PCS Divider Change Register 1 */
#define MC_CGM_PCS_DIVE1     MC_CGM.PCS_DIVE1.R            /* PCS Divider End Register 1 */
#define MC_CGM_PCS_DIVS1     MC_CGM.PCS_DIVS1.R            /* PCS Divider Start Register 1 */
#define MC_CGM_PCS_DIVC2     MC_CGM.PCS_DIVC2.R            /* PCS Divider Change Register 2 */
#define MC_CGM_PCS_DIVE2     MC_CGM.PCS_DIVE2.R            /* PCS Divider End Register 2 */
#define MC_CGM_PCS_DIVS2     MC_CGM.PCS_DIVS2.R            /* PCS Divider Start Register 2 */
#define MC_CGM_PCS_DIVC3     MC_CGM.PCS_DIVC3.R            /* PCS Divider Change Register 3 */
#define MC_CGM_PCS_DIVE3     MC_CGM.PCS_DIVE3.R            /* PCS Divider End Register 3 */
#define MC_CGM_PCS_DIVS3     MC_CGM.PCS_DIVS3.R            /* PCS Divider Start Register 3 */
#define MC_CGM_PCS_DIVC4     MC_CGM.PCS_DIVC4.R            /* PCS Divider Change Register 4 */
#define MC_CGM_PCS_DIVE4     MC_CGM.PCS_DIVE4.R            /* PCS Divider End Register 4 */
#define MC_CGM_PCS_DIVS4     MC_CGM.PCS_DIVS4.R            /* PCS Divider Start Register 4 */
#define MC_CGM_SC_DIV_RC     MC_CGM.SC_DIV_RC.R            /* System Clock Divider Ratio Change Register */
#define MC_CGM_DIV_UPD_TYPE  MC_CGM.DIV_UPD_TYPE.R         /* Divider Update Type Register */
#define MC_CGM_DIV_UPD_TRIG  MC_CGM.DIV_UPD_TRIG.R         /* Divider Update Trigger Register */
#define MC_CGM_DIV_UPD_STAT  MC_CGM.DIV_UPD_STAT.R         /* Divider Update Status Register */
#define MC_CGM_SC_SS         MC_CGM.SC_SS.R                /* System Clock Select Status Register */
#define MC_CGM_SC_DC0        MC_CGM.SC_DC0.R               /* System Clock Divider 0 Configuration Register */
#define MC_CGM_SC_DC1        MC_CGM.SC_DC1.R               /* System Clock Divider 1 Configuration Register */
#define MC_CGM_SC_DC2        MC_CGM.SC_DC2.R               /* System Clock Divider 2 Configuration Register */
#define MC_CGM_SC_DC3        MC_CGM.SC_DC3.R               /* System Clock Divider 3 Configuration Register */
#define MC_CGM_SC_DC4        MC_CGM.SC_DC4.R               /* System Clock Divider 4 Configuration Register */
#define MC_CGM_AC0_SC        MC_CGM.AC0_SC.R               /* Auxiliary Clock 0 Select Control Register */
#define MC_CGM_AC0_SS        MC_CGM.AC0_SS.R               /* Auxiliary Clock 0 Select Status Register */
#define MC_CGM_AC0_DC0       MC_CGM.AC0_DC0.R              /* Auxiliary Clock 0 Divider 0 Configuration Register */
#define MC_CGM_AC0_DC2       MC_CGM.AC0_DC2.R              /* Auxiliary Clock 0 Divider 2 Configuration Register */
#define MC_CGM_AC2_SC        MC_CGM.AC2_SC.R               /* Auxiliary Clock 2 Select Control Register */
#define MC_CGM_AC2_SS        MC_CGM.AC2_SS.R               /* Auxiliary Clock 2 Select Status Register */
#define MC_CGM_AC2_DC0       MC_CGM.AC2_DC0.R              /* Auxiliary Clock 2 Divider 0 Configuration Register */
#define MC_CGM_AC3_SC        MC_CGM.AC3_SC.R               /* Auxiliary Clock 3 Select Control Register */
#define MC_CGM_AC3_SS        MC_CGM.AC3_SS.R               /* Auxiliary Clock 3 Select Status Register */
#define MC_CGM_AC4_SC        MC_CGM.AC4_SC.R               /* Auxiliary Clock 4 Select Control Register */
#define MC_CGM_AC4_SS        MC_CGM.AC4_SS.R               /* Auxiliary Clock 4 Select Status Register */
#define MC_CGM_AC7_SC        MC_CGM.AC7_SC.R               /* Auxiliary Clock 7 Select Control Register */
#define MC_CGM_AC7_SS        MC_CGM.AC7_SS.R               /* Auxiliary Clock 7 Select Status Register */
#define MC_CGM_AC7_DC0       MC_CGM.AC7_DC0.R              /* Auxiliary Clock 7 Divider 0 Configuration Register */
#define MC_CGM_AC9_DC0       MC_CGM.AC9_DC0.R              /* Auxiliary Clock 9 Divider 0 Configuration Register */
#define MC_CGM_AC12_SC       MC_CGM.AC12_SC.R              /* Auxiliary Clock 12 Select Control Register */
#define MC_CGM_AC12_SS       MC_CGM.AC12_SS.R              /* Auxiliary Clock 12 Select Status Register */
#define MC_CGM_AC12_DC0      MC_CGM.AC12_DC0.R             /* Auxiliary Clock 12 Divider 0 Configuration Register */
#define MC_CGM_AC13_SC       MC_CGM.AC13_SC.R              /* Auxiliary Clock 13 Select Control Register */
#define MC_CGM_AC13_SS       MC_CGM.AC13_SS.R              /* Auxiliary Clock 13 Select Status Register */
#define MC_CGM_AC13_DC0      MC_CGM.AC13_DC0.R             /* Auxiliary Clock 13 Divider 0 Configuration Register */
#define MC_CGM_AC14_DC0      MC_CGM.AC14_DC0.R             /* Auxiliary Clock 14 Divider 0 Configuration Register */

/* MC_ME */
#define MC_ME_GS             MC_ME.GS.R                    /* Global Status Register */
#define MC_ME_MCTL           MC_ME.MCTL.R                  /* Mode Control Register */
#define MC_ME_ME             MC_ME.ME.R                    /* Mode Enable Register */
#define MC_ME_IS             MC_ME.IS.R                    /* Interrupt Status Register */
#define MC_ME_IM             MC_ME.IM.R                    /* Interrupt Mask Register */
#define MC_ME_IMTS           MC_ME.IMTS.R                  /* Invalid Mode Transition Status Register */
#define MC_ME_DMTS           MC_ME.DMTS.R                  /* Debug Mode Transition Status Register */
#define MC_ME_RESET_MC       MC_ME.RESET_MC.R              /* RESET Mode Configuration Register */
#define MC_ME_TEST_MC        MC_ME.TEST_MC.R               /* TEST Mode Configuration Register */
#define MC_ME_SAFE_MC        MC_ME.SAFE_MC.R               /* SAFE Mode Configuration Register */
#define MC_ME_DRUN_MC        MC_ME.DRUN_MC.R               /* DRUN Mode Configuration Register */
#define MC_ME_RUN0_MC        MC_ME.RUN_MC[0].R             /* RUN0 3 Mode Configuration Register */
#define MC_ME_RUN1_MC        MC_ME.RUN_MC[1].R             /* RUN0 3 Mode Configuration Register */
#define MC_ME_RUN2_MC        MC_ME.RUN_MC[2].R             /* RUN0 3 Mode Configuration Register */
#define MC_ME_RUN3_MC        MC_ME.RUN_MC[3].R             /* RUN0 3 Mode Configuration Register */
#define MC_ME_HALT0_MC       MC_ME.HALT0_MC.R              /* HALT0 Mode Configuration Register */
#define MC_ME_STOP0_MC       MC_ME.STOP0_MC.R              /* STOP0 Mode Configuration Register */
#define MC_ME_PS0            MC_ME.PS0.R                   /* Peripheral Status Register 0 */
#define MC_ME_PS1            MC_ME.PS1.R                   /* Peripheral Status Register 1 */
#define MC_ME_PS2            MC_ME.PS2.R                   /* Peripheral Status Register 2 */
#define MC_ME_PS3            MC_ME.PS3.R                   /* Peripheral Status Register 3 */
#define MC_ME_PS4            MC_ME.PS4.R                   /* Peripheral Status Register 4 */
#define MC_ME_PS5            MC_ME.PS5.R                   /* Peripheral Status Register 5 */
#define MC_ME_PS6            MC_ME.PS6.R                   /* Peripheral Status Register 6 */
#define MC_ME_PS7            MC_ME.PS7.R                   /* Peripheral Status Register 7 */
#define MC_ME_RUN_PC0        MC_ME.RUN_PC[0].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC1        MC_ME.RUN_PC[1].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC2        MC_ME.RUN_PC[2].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC3        MC_ME.RUN_PC[3].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC4        MC_ME.RUN_PC[4].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC5        MC_ME.RUN_PC[5].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC6        MC_ME.RUN_PC[6].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC7        MC_ME.RUN_PC[7].R             /* Run Peripheral Configuration Register */
#define MC_ME_LP_PC0         MC_ME.LP_PC[0].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC1         MC_ME.LP_PC[1].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC2         MC_ME.LP_PC[2].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC3         MC_ME.LP_PC[3].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC4         MC_ME.LP_PC[4].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC5         MC_ME.LP_PC[5].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC6         MC_ME.LP_PC[6].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC7         MC_ME.LP_PC[7].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_PCTL30         MC_ME.PCTL30.R                /* PIT_RTC_0 Peripheral Control Register */
#define MC_ME_PCTL31         MC_ME.PCTL31.R                /* PIT_RTC_1 Peripheral Control Register */
#define MC_ME_PCTL36         MC_ME.PCTL36.R                /* DMAMUX_0 Peripheral Control Register */
#define MC_ME_PCTL38         MC_ME.PCTL38.R                /* CRC_0 Peripheral Control Register */
#define MC_ME_PCTL45         MC_ME.PCTL45.R                /* JTAGM Peripheral Control Register */
#define MC_ME_PCTL49         MC_ME.PCTL49.R                /* DTS Peripheral Control Register */
#define MC_ME_PCTL61         MC_ME.PCTL61.R                /* MIPI Peripheral Control Register */
#define MC_ME_PCTL77         MC_ME.PCTL77.R                /* FLEXCAN_2 Peripheral Control Register */
#define MC_ME_PCTL79         MC_ME.PCTL79.R                /* FLEXCAN_0 Peripheral Control Register */
#define MC_ME_PCTL91         MC_ME.PCTL91.R                /* LINFlex_1 Peripheral Control Register */
#define MC_ME_PCTL98         MC_ME.PCTL98.R                /* SPI_1 Peripheral Control Register */
#define MC_ME_PCTL100        MC_ME.PCTL100.R               /* IIC_2 Peripheral Control Register */
#define MC_ME_PCTL102        MC_ME.PCTL102.R               /* IIC_1 Peripheral Control Register */
#define MC_ME_PCTL126        MC_ME.PCTL126.R               /* SAR_ADC_1 Peripheral Control Register */
#define MC_ME_PCTL137        MC_ME.PCTL137.R               /* ETIMER_1 Peripheral Control Register */
#define MC_ME_PCTL146        MC_ME.PCTL146.R               /* DMAMUX_1 Peripheral Control Register */
#define MC_ME_PCTL148        MC_ME.PCTL148.R               /* CRC_1 Peripheral Control Register */
#define MC_ME_PCTL187        MC_ME.PCTL187.R               /* SPT Peripheral Control Register */
#define MC_ME_PCTL188        MC_ME.PCTL188.R               /* RADAR_CTE Peripheral Control Register */
#define MC_ME_PCTL209        MC_ME.PCTL209.R               /* SPI_2 Peripheral Control Register */
#define MC_ME_PCTL237        MC_ME.PCTL237.R               /* SAR_ADC_0 Peripheral Control Register */
#define MC_ME_PCTL251        MC_ME.PCTL251.R               /* CTU_0 Peripheral Control Register */
#define MC_ME_PCTL255        MC_ME.PCTL255.R               /* FlexPWM_0 Peripheral Control Register */
#define MC_ME_CS             MC_ME.CS.R                    /* Core Status Register */
#define MC_ME_CCTL2          MC_ME.CCTL2.R                 /* Core Control Register */
#define MC_ME_CCTL3          MC_ME.CCTL3.R                 /* Core Control Register */
#define MC_ME_CADDR2         MC_ME.CADDR2.R                /* Core Control Registers */
#define MC_ME_CADDR3         MC_ME.CADDR3.R                /* Core Control Registers */

/* MC_PCU */
#define MC_PCU_PSTAT         MC_PCU.PSTAT.R                /* Power Domain Status Register */

/* MEMU */
#define MEMU_CTRL            MEMU.CTRL.R                   /* Control register */
#define MEMU_ERR_FLAG        MEMU.ERR_FLAG.R               /* Error flag register */
#define MEMU_DEBUG           MEMU.DEBUG.R                  /* Debug register */
#define MEMU_SYS_RAM_CERR_STS0 MEMU.SYS_RAM_CERR[0].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR0 MEMU.SYS_RAM_CERR[0].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS1 MEMU.SYS_RAM_CERR[1].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR1 MEMU.SYS_RAM_CERR[1].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS2 MEMU.SYS_RAM_CERR[2].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR2 MEMU.SYS_RAM_CERR[2].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS3 MEMU.SYS_RAM_CERR[3].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR3 MEMU.SYS_RAM_CERR[3].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS4 MEMU.SYS_RAM_CERR[4].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR4 MEMU.SYS_RAM_CERR[4].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS5 MEMU.SYS_RAM_CERR[5].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR5 MEMU.SYS_RAM_CERR[5].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS6 MEMU.SYS_RAM_CERR[6].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR6 MEMU.SYS_RAM_CERR[6].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS7 MEMU.SYS_RAM_CERR[7].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR7 MEMU.SYS_RAM_CERR[7].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS8 MEMU.SYS_RAM_CERR[8].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR8 MEMU.SYS_RAM_CERR[8].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS9 MEMU.SYS_RAM_CERR[9].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR9 MEMU.SYS_RAM_CERR[9].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_UNCERR_STS MEMU.SYS_RAM_UNCERR_STS.R  /* System RAM uncorrectable error reporting table status register */
#define MEMU_SYS_RAM_UNCERR_ADDR MEMU.SYS_RAM_UNCERR_ADDR.R /* System RAM uncorrectable error reporting table address register */
#define MEMU_SYS_RAM_OFLW0   MEMU.SYS_RAM_OFLW[0].R        /* System RAM concurrent overflow register */
#define MEMU_SYS_RAM_OFLW1   MEMU.SYS_RAM_OFLW[1].R        /* System RAM concurrent overflow register */
#define MEMU_PERIPH_RAM_CERR_STS0 MEMU.PERIPH_RAM_CERR[0].STS.R /* Peripheral RAM correctable error reporting table status register */
#define MEMU_PERIPH_RAM_CERR_ADDR0 MEMU.PERIPH_RAM_CERR[0].ADDR.R /* Peripheral RAM correctable error reporting table address register */
#define MEMU_PERIPH_RAM_CERR_STS1 MEMU.PERIPH_RAM_CERR[1].STS.R /* Peripheral RAM correctable error reporting table status register */
#define MEMU_PERIPH_RAM_CERR_ADDR1 MEMU.PERIPH_RAM_CERR[1].ADDR.R /* Peripheral RAM correctable error reporting table address register */
#define MEMU_PERIPH_RAM_UNCERR_STS MEMU.PERIPH_RAM_UNCERR_STS.R /* Peripheral RAM uncorrectable error reporting table status register */
#define MEMU_PERIPH_RAM_UNCERR_ADDR MEMU.PERIPH_RAM_UNCERR_ADDR.R /* Peripheral RAM uncorrectable error reporting table address register */
#define MEMU_PERIPH_RAM_OFLW0 MEMU.PERIPH_RAM_OFLW0.R      /* Peripheral RAM concurrent overflow register */
#define MEMU_FLASH_CERR_STS0 MEMU.FLASH_CERR[0].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR0 MEMU.FLASH_CERR[0].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS1 MEMU.FLASH_CERR[1].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR1 MEMU.FLASH_CERR[1].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS2 MEMU.FLASH_CERR[2].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR2 MEMU.FLASH_CERR[2].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS3 MEMU.FLASH_CERR[3].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR3 MEMU.FLASH_CERR[3].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS4 MEMU.FLASH_CERR[4].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR4 MEMU.FLASH_CERR[4].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS5 MEMU.FLASH_CERR[5].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR5 MEMU.FLASH_CERR[5].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS6 MEMU.FLASH_CERR[6].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR6 MEMU.FLASH_CERR[6].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS7 MEMU.FLASH_CERR[7].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR7 MEMU.FLASH_CERR[7].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS8 MEMU.FLASH_CERR[8].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR8 MEMU.FLASH_CERR[8].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS9 MEMU.FLASH_CERR[9].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR9 MEMU.FLASH_CERR[9].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS10 MEMU.FLASH_CERR[10].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR10 MEMU.FLASH_CERR[10].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS11 MEMU.FLASH_CERR[11].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR11 MEMU.FLASH_CERR[11].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS12 MEMU.FLASH_CERR[12].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR12 MEMU.FLASH_CERR[12].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS13 MEMU.FLASH_CERR[13].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR13 MEMU.FLASH_CERR[13].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS14 MEMU.FLASH_CERR[14].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR14 MEMU.FLASH_CERR[14].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS15 MEMU.FLASH_CERR[15].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR15 MEMU.FLASH_CERR[15].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS16 MEMU.FLASH_CERR[16].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR16 MEMU.FLASH_CERR[16].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS17 MEMU.FLASH_CERR[17].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR17 MEMU.FLASH_CERR[17].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS18 MEMU.FLASH_CERR[18].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR18 MEMU.FLASH_CERR[18].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS19 MEMU.FLASH_CERR[19].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR19 MEMU.FLASH_CERR[19].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_UNCERR_STS MEMU.FLASH_UNCERR_STS.R      /* Flash memory uncorrectable error reporting table status register */
#define MEMU_FLASH_UNCERR_ADDR MEMU.FLASH_UNCERR_ADDR.R    /* Flash memory uncorrectable error reporting table address register */
#define MEMU_FLASH_OFLW0     MEMU.FLASH_OFLW0.R            /* Flash memory concurrent overflow register */

/* MIPICSI2 */
#define MIPICSI2_CONC        MIPICSI2.CONC.R               /* RX Controller Configuration Register */
#define MIPICSI2_PHYC        MIPICSI2.PHYC.R               /* PHY Configuration Register */
#define MIPICSI2_CLKCS       MIPICSI2.CLKCS.R              /* Clock Configuration Status Register */
#define MIPICSI2_LAN0CS      MIPICSI2.LAN0CS.R             /* D-PHY Lane 0 Configuration Status Register */
#define MIPICSI2_LAN1CS      MIPICSI2.LAN1CS.R             /* D-PHY Data LANE 1 Configuration Status Register */
#define MIPICSI2_RESCS       MIPICSI2.RESCS.R              /* External Resistor Configuration Status Register */
#define MIPICSI2_SR          MIPICSI2.SR.R                 /* Status Register */
#define MIPICSI2_DATAID      MIPICSI2.DATAID.R             /* DataID Report Register */
#define MIPICSI2_ERRPPREG    MIPICSI2.ERRPPREG.R           /* Protocol and Packet Error Register */
#define MIPICSI2_ERRPOS      MIPICSI2.ERRPOS.R             /* Error Position */
#define MIPICSI2_ERPPINTEN   MIPICSI2.ERPPINTEN.R          /* Protocol Packet Error Interrupt Enable */
#define MIPICSI2_ERRPHY      MIPICSI2.ERRPHY.R             /* PHY Error Report Register */
#define MIPICSI2_ERPHYIE     MIPICSI2.ERPHYIE.R            /* Phy Error Interrupt Enable Register */
#define MIPICSI2_RXEN        MIPICSI2.RXEN.R               /* RX Enable Register */
#define MIPICSI2_GNSP        MIPICSI2.GNSP.R               /* Generic Short Packet Data Register */
#define MIPICSI2_INVID       MIPICSI2.INVID.R              /* Invalid ID Report Register */
#define MIPICSI2_LINLEN      MIPICSI2.LINLEN.R             /* LINE LENGTH */
#define MIPICSI2_EXPCTDL     MIPICSI2.EXPCTDL.R            /* Expected Number of Lines */
#define MIPICSI2_INTREN      MIPICSI2.INTREN.R             /* Interrupt Enable */
#define MIPICSI2_INTRS       MIPICSI2.INTRS.R              /* Interrupt Status */

/* PASS */
#define PASS_LCSTAT          PASS.LCSTAT.R                 /* Life Cycle Status Register */
#define PASS_CHSEL           PASS.CHSEL.R                  /* Challenge Selector Register */
#define PASS_CSTAT           PASS.CSTAT.R                  /* Challenge Status Register */
#define PASS_CIN0            PASS.CIN[0].R                 /* Challenge Input Register */
#define PASS_CIN1            PASS.CIN[1].R                 /* Challenge Input Register */
#define PASS_CIN2            PASS.CIN[2].R                 /* Challenge Input Register */
#define PASS_CIN3            PASS.CIN[3].R                 /* Challenge Input Register */
#define PASS_CIN4            PASS.CIN[4].R                 /* Challenge Input Register */
#define PASS_CIN5            PASS.CIN[5].R                 /* Challenge Input Register */
#define PASS_CIN6            PASS.CIN[6].R                 /* Challenge Input Register */
#define PASS_CIN7            PASS.CIN[7].R                 /* Challenge Input Register */
#define PASS_LOCK0_PG0       PASS.PG[0].LOCK0.R            /* Password Group n - Lock 0 Status Register */
#define PASS_LOCK1_PG0       PASS.PG[0].LOCK1.R            /* Password Group n - Lock 1 Status Register */
#define PASS_LOCK2_PG0       PASS.PG[0].LOCK2.R            /* Password Group n - Lock 2 Status Register */
#define PASS_LOCK3_PG0       PASS.PG[0].LOCK3.R            /* Password Group n - Lock 3 Status Register */
#define PASS_LOCK0_PG1       PASS.PG[1].LOCK0.R            /* Password Group n - Lock 0 Status Register */
#define PASS_LOCK1_PG1       PASS.PG[1].LOCK1.R            /* Password Group n - Lock 1 Status Register */
#define PASS_LOCK2_PG1       PASS.PG[1].LOCK2.R            /* Password Group n - Lock 2 Status Register */
#define PASS_LOCK3_PG1       PASS.PG[1].LOCK3.R            /* Password Group n - Lock 3 Status Register */
#define PASS_LOCK0_PG2       PASS.PG[2].LOCK0.R            /* Password Group n - Lock 0 Status Register */
#define PASS_LOCK1_PG2       PASS.PG[2].LOCK1.R            /* Password Group n - Lock 1 Status Register */
#define PASS_LOCK2_PG2       PASS.PG[2].LOCK2.R            /* Password Group n - Lock 2 Status Register */
#define PASS_LOCK3_PG2       PASS.PG[2].LOCK3.R            /* Password Group n - Lock 3 Status Register */
#define PASS_LOCK0_PG3       PASS.PG[3].LOCK0.R            /* Password Group n - Lock 0 Status Register */
#define PASS_LOCK1_PG3       PASS.PG[3].LOCK1.R            /* Password Group n - Lock 1 Status Register */
#define PASS_LOCK2_PG3       PASS.PG[3].LOCK2.R            /* Password Group n - Lock 2 Status Register */
#define PASS_LOCK3_PG3       PASS.PG[3].LOCK3.R            /* Password Group n - Lock 3 Status Register */

/* PCM */
#define PCM_IAHB_BE1         PCM.IAHB_BE1.R                /* IAHB Burst Enable 1 Register */
#define PCM_IAHB_BE3         PCM.IAHB_BE3.R                /* IAHB Burst Enable 3 Register */
#define PCM_IAHB_BE4         PCM.IAHB_BE4.R                /* IAHB Burst Enable 4 Register */
#define PCM_IAHB_BE5         PCM.IAHB_BE5.R                /* IAHB Burst Enable 5 Register */

/* PFLASH */
#define PFLASH_PFCR1         PFLASH.PFCR1.R                /* Platform Flash Configuration Register 1 */
#define PFLASH_PFCR2         PFLASH.PFCR2.R                /* Platform Flash Configuration Register 2 */
#define PFLASH_PFCR3         PFLASH.PFCR3.R                /* Platform Flash Configuration Register 3 */
#define PFLASH_PFAPR         PFLASH.PFAPR.R                /* Platform Flash Access Protection Register */
#define PFLASH_PFCRCR        PFLASH.PFCRCR.R               /* Platform Flash Remap Control Register */
#define PFLASH_PFCRDE        PFLASH.PFCRDE.R               /* Platform Flash Remap Descriptor Enable Register */
#define PFLASH_PFCR4         PFLASH.PFCR4.R                /* Platform Flash Configuration Register 4 */
#define PFLASH_PFCRD0_Word0  PFLASH.PFCRD[0].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD0_Word1  PFLASH.PFCRD[0].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD0_Word2  PFLASH.PFCRD[0].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD1_Word0  PFLASH.PFCRD[1].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD1_Word1  PFLASH.PFCRD[1].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD1_Word2  PFLASH.PFCRD[1].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD2_Word0  PFLASH.PFCRD[2].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD2_Word1  PFLASH.PFCRD[2].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD2_Word2  PFLASH.PFCRD[2].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD3_Word0  PFLASH.PFCRD[3].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD3_Word1  PFLASH.PFCRD[3].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD3_Word2  PFLASH.PFCRD[3].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD4_Word0  PFLASH.PFCRD[4].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD4_Word1  PFLASH.PFCRD[4].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD4_Word2  PFLASH.PFCRD[4].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD5_Word0  PFLASH.PFCRD[5].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD5_Word1  PFLASH.PFCRD[5].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD5_Word2  PFLASH.PFCRD[5].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD6_Word0  PFLASH.PFCRD[6].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD6_Word1  PFLASH.PFCRD[6].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD6_Word2  PFLASH.PFCRD[6].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD7_Word0  PFLASH.PFCRD[7].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD7_Word1  PFLASH.PFCRD[7].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD7_Word2  PFLASH.PFCRD[7].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */

/* PIT */
#define PIT_0_MCR            PIT_0.MCR.R                   /* PIT Module Control Register */
#define PIT_0_LTMR64H        PIT_0.LTMR64H.R               /* PIT Upper Lifetime Timer Register */
#define PIT_0_LTMR64L        PIT_0.LTMR64L.R               /* PIT Lower Lifetime Timer Register */
#define PIT_0_LDVAL0         PIT_0.TIMER[0].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL0          PIT_0.TIMER[0].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL0         PIT_0.TIMER[0].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG0          PIT_0.TIMER[0].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL1         PIT_0.TIMER[1].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL1          PIT_0.TIMER[1].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL1         PIT_0.TIMER[1].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG1          PIT_0.TIMER[1].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL2         PIT_0.TIMER[2].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL2          PIT_0.TIMER[2].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL2         PIT_0.TIMER[2].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG2          PIT_0.TIMER[2].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL3         PIT_0.TIMER[3].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL3          PIT_0.TIMER[3].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL3         PIT_0.TIMER[3].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG3          PIT_0.TIMER[3].TFLG.R         /* Timer Flag Register */

#define PIT_1_MCR            PIT_1.MCR.R                   /* PIT Module Control Register */
#define PIT_1_LTMR64H        PIT_1.LTMR64H.R               /* PIT Upper Lifetime Timer Register */
#define PIT_1_LTMR64L        PIT_1.LTMR64L.R               /* PIT Lower Lifetime Timer Register */
#define PIT_1_LDVAL0         PIT_1.TIMER[0].LDVAL.R        /* Timer Load Value Register */
#define PIT_1_CVAL0          PIT_1.TIMER[0].CVAL.R         /* Current Timer Value Register */
#define PIT_1_TCTRL0         PIT_1.TIMER[0].TCTRL.R        /* Timer Control Register */
#define PIT_1_TFLG0          PIT_1.TIMER[0].TFLG.R         /* Timer Flag Register */
#define PIT_1_LDVAL1         PIT_1.TIMER[1].LDVAL.R        /* Timer Load Value Register */
#define PIT_1_CVAL1          PIT_1.TIMER[1].CVAL.R         /* Current Timer Value Register */
#define PIT_1_TCTRL1         PIT_1.TIMER[1].TCTRL.R        /* Timer Control Register */
#define PIT_1_TFLG1          PIT_1.TIMER[1].TFLG.R         /* Timer Flag Register */
#define PIT_1_LDVAL2         PIT_1.TIMER[2].LDVAL.R        /* Timer Load Value Register */
#define PIT_1_CVAL2          PIT_1.TIMER[2].CVAL.R         /* Current Timer Value Register */
#define PIT_1_TCTRL2         PIT_1.TIMER[2].TCTRL.R        /* Timer Control Register */
#define PIT_1_TFLG2          PIT_1.TIMER[2].TFLG.R         /* Timer Flag Register */
#define PIT_1_LDVAL3         PIT_1.TIMER[3].LDVAL.R        /* Timer Load Value Register */
#define PIT_1_CVAL3          PIT_1.TIMER[3].CVAL.R         /* Current Timer Value Register */
#define PIT_1_TCTRL3         PIT_1.TIMER[3].TCTRL.R        /* Timer Control Register */
#define PIT_1_TFLG3          PIT_1.TIMER[3].TFLG.R         /* Timer Flag Register */

/* PLLDIG */
#define PLLDIG_PLL0CR        PLLDIG.PLL0CR.R               /* PLLDIG PLL0 Control Register */
#define PLLDIG_PLL0SR        PLLDIG.PLL0SR.R               /* PLLDIG PLL0 Status Register */
#define PLLDIG_PLL0DV        PLLDIG.PLL0DV.R               /* PLLDIG PLL0 Divider Register */
#define PLLDIG_PLL1CR        PLLDIG.PLL1CR.R               /* PLLDIG PLL1 Control Register */
#define PLLDIG_PLL1SR        PLLDIG.PLL1SR.R               /* PLLDIG PLL1 Status Register */
#define PLLDIG_PLL1DV        PLLDIG.PLL1DV.R               /* PLLDIG PLL1 Divider Register */
#define PLLDIG_PLL1FM        PLLDIG.PLL1FM.R               /* PLLDIG PLL1 Frequency Modulation Register */
#define PLLDIG_PLL1FD        PLLDIG.PLL1FD.R               /* PLLDIG PLL1 Fractional Divide Register */

/* PMC */
#define PMC_SMPS_CNTRL       PMC.SMPS_CNTRL.R              /* SMPS Control Register */
#define PMC_STTW             PMC.STTW.R                    /* LVD Self Test Time Window Register */
#define PMC_SELF_TEST_UM_VD_REG PMC.SELF_TEST_UM_VD_REG.R  /* Voltage Detect User Mode Test Register */
#define PMC_AFE_INTR_ENA     PMC.AFE_INTR_ENA.R            /* AFE Interrupt Enable Register */
#define PMC_AFE_INTR_STATUS  PMC.AFE_INTR_STATUS.R         /* AFE Interrupt Status Register */
#define PMC_FIR              PMC.FIR.R                     /* FCCU Fault Injection Register */
#define PMC_PMCCR            PMC.PMCCR.R                   /* PMC Control Register */
#define PMC_TS_IER           PMC.TS_IER.R                  /* Interrupt Enable Register */
#define PMC_ESR_TD           PMC.ESR_TD.R                  /* Temperature Event Status register */
#define PMC_REE_TD           PMC.REE_TD.R                  /* Temperature Reset Event Enable register */
#define PMC_RES_TD           PMC.RES_TD.R                  /* Temperature Reset Event Selection register */
#define PMC_CTL_TD           PMC.CTL_TD.R                  /* Temperature detector configuration register */
#define PMC_TS_FIR           PMC.TS_FIR.R                  /* Fault Injection Register */

/* PRAMC */
#define PRAMC_PRCR1          PRAMC.PRCR1.R                 /* Platform RAM Configuration Register 1 */
#define PRAMC_PRCR2          PRAMC.PRCR2.R                 /* Platform RAM Configuration Register 2 */
#define PRAMC_PRCR3          PRAMC.PRCR3.R                 /* Platform RAM Configuration Register 3 */
#define PRAMC_PRCR4          PRAMC.PRCR4.R                 /* Platform RAM Configuration Register 4 */
#define PRAMC_PRCR5          PRAMC.PRCR5.R                 /* Platform RAM Configuration Register 5 */
#define PRAMC_PRCR6          PRAMC.PRCR6.R                 /* Platform RAM Configuration Register 6 */

/* PRAM_XBAR */
#define PRAM_XBAR_PRS0       PRAM_XBAR.PRS0.R              /* Priority Register Slave */
#define PRAM_XBAR_CRS0       PRAM_XBAR.CRS0.R              /* Control Register */
#define PRAM_XBAR_PRS1       PRAM_XBAR.PRS1.R              /* Priority Register Slave */
#define PRAM_XBAR_CRS1       PRAM_XBAR.CRS1.R              /* Control Register */
#define PRAM_XBAR_PRS2       PRAM_XBAR.PRS2.R              /* Priority Register Slave */
#define PRAM_XBAR_CRS2       PRAM_XBAR.CRS2.R              /* Control Register */
#define PRAM_XBAR_PRS3       PRAM_XBAR.PRS3.R              /* Priority Register Slave */
#define PRAM_XBAR_CRS3       PRAM_XBAR.CRS3.R              /* Control Register */
#define PRAM_XBAR_PRS4       PRAM_XBAR.PRS4.R              /* Priority Register Slave */
#define PRAM_XBAR_CRS4       PRAM_XBAR.CRS4.R              /* Control Register */
#define PRAM_XBAR_PRS7       PRAM_XBAR.PRS7.R              /* Priority Register Slave 7 */
#define PRAM_XBAR_CRS7       PRAM_XBAR.CRS7.R              /* Control Register 7 */

/* RGM */
#define RGM_DES              RGM.DES.R                     /* 'Destructive' Event Status Register */
#define RGM_DERD             RGM.DERD.R                    /* 'Destructive' Event Reset Disable Register */
#define RGM_DEAR             RGM.DEAR.R                    /* 'Destructive' Event Alternate Request Register */
#define RGM_FES              RGM.FES.R                     /* 'Functional' Event Status Register */
#define RGM_FERD             RGM.FERD.R                    /* 'Functional' Event Reset Disable Register */
#define RGM_FEAR             RGM.FEAR.R                    /* 'Functional' Event Alternate Request Register */
#define RGM_FBRE             RGM.FBRE.R                    /* 'Functional' Bidirectional Reset Enable Register */
#define RGM_FESS             RGM.FESS.R                    /* 'Functional' Event Short Sequence Register */
#define RGM_FRET             RGM.FRET.R                    /* 'Functional' Event Short Sequence Register */
#define RGM_DRET             RGM.DRET.R                    /* Destructive Reset Escalation Threshold Register */

/* SEMA42 */
#define SEMA42_GATE0         SEMA42.GATE[0].R              /* Gate Register */
#define SEMA42_GATE1         SEMA42.GATE[1].R              /* Gate Register */
#define SEMA42_GATE2         SEMA42.GATE[2].R              /* Gate Register */
#define SEMA42_GATE3         SEMA42.GATE[3].R              /* Gate Register */
#define SEMA42_GATE4         SEMA42.GATE[4].R              /* Gate Register */
#define SEMA42_GATE5         SEMA42.GATE[5].R              /* Gate Register */
#define SEMA42_GATE6         SEMA42.GATE[6].R              /* Gate Register */
#define SEMA42_GATE7         SEMA42.GATE[7].R              /* Gate Register */
#define SEMA42_GATE8         SEMA42.GATE[8].R              /* Gate Register */
#define SEMA42_GATE9         SEMA42.GATE[9].R              /* Gate Register */
#define SEMA42_GATE10        SEMA42.GATE[10].R             /* Gate Register */
#define SEMA42_GATE11        SEMA42.GATE[11].R             /* Gate Register */
#define SEMA42_GATE12        SEMA42.GATE[12].R             /* Gate Register */
#define SEMA42_GATE13        SEMA42.GATE[13].R             /* Gate Register */
#define SEMA42_GATE14        SEMA42.GATE[14].R             /* Gate Register */
#define SEMA42_GATE15        SEMA42.GATE[15].R             /* Gate Register */
#define SEMA42_RSTGT_R       SEMA42.RSTGT.R.R              /* Reset Gate Read */
#define SEMA42_RSTGT_W       SEMA42.RSTGT.W.R              /* Reset Gate Write */

/* SIUL2 */
#define SIUL2_MIDR1          SIUL2.MIDR1.R                 /* SIUL2 MCU ID Register #1 */
#define SIUL2_MIDR2          SIUL2.MIDR2.R                 /* SIUL2 MCU ID Register #2 */
#define SIUL2_DISR0          SIUL2.DISR0.R                 /* SIUL2 DMA/Interrupt Status Flag Register0 */
#define SIUL2_DIRER0         SIUL2.DIRER0.R                /* SIUL2 DMA/Interrupt Request Enable Register0 */
#define SIUL2_DIRSR0         SIUL2.DIRSR0.R                /* SIUL2 DMA/Interrupt Request Select Register0 */
#define SIUL2_IREER0         SIUL2.IREER0.R                /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
#define SIUL2_IFEER0         SIUL2.IFEER0.R                /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
#define SIUL2_IFER0          SIUL2.IFER0.R                 /* SIUL2 Interrupt Filter Enable Register 0 */
#define SIUL2_IFMCR0         SIUL2.IFMCR[0].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR1         SIUL2.IFMCR[1].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR2         SIUL2.IFMCR[2].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR3         SIUL2.IFMCR[3].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR4         SIUL2.IFMCR[4].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR5         SIUL2.IFMCR[5].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR6         SIUL2.IFMCR[6].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR7         SIUL2.IFMCR[7].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR8         SIUL2.IFMCR[8].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR9         SIUL2.IFMCR[9].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR10        SIUL2.IFMCR[10].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR11        SIUL2.IFMCR[11].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR12        SIUL2.IFMCR[12].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR13        SIUL2.IFMCR[13].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR14        SIUL2.IFMCR[14].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR15        SIUL2.IFMCR[15].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR16        SIUL2.IFMCR[16].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR17        SIUL2.IFMCR[17].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR18        SIUL2.IFMCR[18].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR19        SIUL2.IFMCR[19].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR20        SIUL2.IFMCR[20].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR21        SIUL2.IFMCR[21].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR22        SIUL2.IFMCR[22].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR23        SIUL2.IFMCR[23].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR24        SIUL2.IFMCR[24].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR25        SIUL2.IFMCR[25].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR26        SIUL2.IFMCR[26].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR27        SIUL2.IFMCR[27].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR28        SIUL2.IFMCR[28].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR29        SIUL2.IFMCR[29].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR30        SIUL2.IFMCR[30].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR31        SIUL2.IFMCR[31].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFCPR          SIUL2.IFCPR.R                 /* SIUL2 Interrupt Filter Clock Prescaler Register */
#define SIUL2_MSCR0          SIUL2.MSCR[0].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR1          SIUL2.MSCR[1].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR2          SIUL2.MSCR[2].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR3          SIUL2.MSCR[3].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR4          SIUL2.MSCR[4].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR5          SIUL2.MSCR[5].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR6          SIUL2.MSCR[6].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR7          SIUL2.MSCR[7].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR8          SIUL2.MSCR[8].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR9          SIUL2.MSCR[9].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR10         SIUL2.MSCR[10].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR11         SIUL2.MSCR[11].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR12         SIUL2.MSCR[12].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR13         SIUL2.MSCR[13].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR14         SIUL2.MSCR[14].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR15         SIUL2.MSCR[15].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR16         SIUL2.MSCR[16].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR17         SIUL2.MSCR[17].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR18         SIUL2.MSCR[18].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR19         SIUL2.MSCR[19].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR20         SIUL2.MSCR[20].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR21         SIUL2.MSCR[21].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR22         SIUL2.MSCR[22].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR23         SIUL2.MSCR[23].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR24         SIUL2.MSCR[24].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR25         SIUL2.MSCR[25].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR26         SIUL2.MSCR[26].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR27         SIUL2.MSCR[27].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR28         SIUL2.MSCR[28].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR29         SIUL2.MSCR[29].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR30         SIUL2.MSCR[30].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR31         SIUL2.MSCR[31].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR32         SIUL2.MSCR[32].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR33         SIUL2.MSCR[33].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR34         SIUL2.MSCR[34].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR35         SIUL2.MSCR[35].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR36         SIUL2.MSCR[36].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR37         SIUL2.MSCR[37].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR38         SIUL2.MSCR[38].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR39         SIUL2.MSCR[39].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR40         SIUL2.MSCR[40].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR41         SIUL2.MSCR[41].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR42         SIUL2.MSCR[42].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR43         SIUL2.MSCR[43].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR44         SIUL2.MSCR[44].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR45         SIUL2.MSCR[45].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR46         SIUL2.MSCR[46].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR47         SIUL2.MSCR[47].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR48         SIUL2.MSCR[48].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR49         SIUL2.MSCR[49].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR50         SIUL2.MSCR[50].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR51         SIUL2.MSCR[51].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR52         SIUL2.MSCR[52].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR53         SIUL2.MSCR[53].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR54         SIUL2.MSCR[54].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR55         SIUL2.MSCR[55].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR56         SIUL2.MSCR[56].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR57         SIUL2.MSCR[57].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR58         SIUL2.MSCR[58].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR59         SIUL2.MSCR[59].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR60         SIUL2.MSCR[60].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR61         SIUL2.MSCR[61].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR62         SIUL2.MSCR[62].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR63         SIUL2.MSCR[63].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR64         SIUL2.MSCR[64].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR65         SIUL2.MSCR[65].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR66         SIUL2.MSCR[66].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR67         SIUL2.MSCR[67].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR68         SIUL2.MSCR[68].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR69         SIUL2.MSCR[69].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR70         SIUL2.MSCR[70].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR71         SIUL2.MSCR[71].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR72         SIUL2.MSCR[72].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR73         SIUL2.MSCR[73].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR74         SIUL2.MSCR[74].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR75         SIUL2.MSCR[75].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR76         SIUL2.MSCR[76].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR77         SIUL2.MSCR[77].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR78         SIUL2.MSCR[78].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR79         SIUL2.MSCR[79].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR80         SIUL2.MSCR[80].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR81         SIUL2.MSCR[81].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR82         SIUL2.MSCR[82].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR83         SIUL2.MSCR[83].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR84         SIUL2.MSCR[84].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR85         SIUL2.MSCR[85].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR86         SIUL2.MSCR[86].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR87         SIUL2.MSCR[87].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR88         SIUL2.MSCR[88].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR89         SIUL2.MSCR[89].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR90         SIUL2.MSCR[90].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR91         SIUL2.MSCR[91].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR92         SIUL2.MSCR[92].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR93         SIUL2.MSCR[93].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR94         SIUL2.MSCR[94].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR95         SIUL2.MSCR[95].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR96         SIUL2.MSCR[96].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR97         SIUL2.MSCR[97].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR98         SIUL2.MSCR[98].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR99         SIUL2.MSCR[99].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR100        SIUL2.MSCR[100].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR101        SIUL2.MSCR[101].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR102        SIUL2.MSCR[102].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR103        SIUL2.MSCR[103].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR104        SIUL2.MSCR[104].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR105        SIUL2.MSCR[105].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR106        SIUL2.MSCR[106].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR107        SIUL2.MSCR[107].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR108        SIUL2.MSCR[108].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR109        SIUL2.MSCR[109].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR110        SIUL2.MSCR[110].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR111        SIUL2.MSCR[111].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR112        SIUL2.MSCR[112].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR113        SIUL2.MSCR[113].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR114        SIUL2.MSCR[114].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR115        SIUL2.MSCR[115].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR116        SIUL2.MSCR[116].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR117        SIUL2.MSCR[117].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR118        SIUL2.MSCR[118].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR119        SIUL2.MSCR[119].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR120        SIUL2.MSCR[120].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR121        SIUL2.MSCR[121].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR122        SIUL2.MSCR[122].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR123        SIUL2.MSCR[123].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR124        SIUL2.MSCR[124].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR125        SIUL2.MSCR[125].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR126        SIUL2.MSCR[126].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR127        SIUL2.MSCR[127].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR128        SIUL2.MSCR[128].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR129        SIUL2.MSCR[129].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR130        SIUL2.MSCR[130].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR131        SIUL2.MSCR[131].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR132        SIUL2.MSCR[132].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR133        SIUL2.MSCR[133].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR134        SIUL2.MSCR[134].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR135        SIUL2.MSCR[135].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR136        SIUL2.MSCR[136].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR137        SIUL2.MSCR[137].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR138        SIUL2.MSCR[138].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR139        SIUL2.MSCR[139].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR140        SIUL2.MSCR[140].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR141        SIUL2.MSCR[141].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR142        SIUL2.MSCR[142].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR143        SIUL2.MSCR[143].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR144        SIUL2.MSCR[144].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR145        SIUL2.MSCR[145].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR146        SIUL2.MSCR[146].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR147        SIUL2.MSCR[147].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR148        SIUL2.MSCR[148].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR149        SIUL2.MSCR[149].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR150        SIUL2.MSCR[150].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR151        SIUL2.MSCR[151].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR152        SIUL2.MSCR[152].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR153        SIUL2.MSCR[153].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR154        SIUL2.MSCR[154].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR155        SIUL2.MSCR[155].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR156        SIUL2.MSCR[156].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR157        SIUL2.MSCR[157].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR158        SIUL2.MSCR[158].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR159        SIUL2.MSCR[159].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR160        SIUL2.MSCR[160].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR161        SIUL2.MSCR[161].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR162        SIUL2.MSCR[162].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR163        SIUL2.MSCR[163].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR164        SIUL2.MSCR[164].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR165        SIUL2.MSCR[165].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR166        SIUL2.MSCR[166].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR167        SIUL2.MSCR[167].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR168        SIUL2.MSCR[168].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR169        SIUL2.MSCR[169].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR170        SIUL2.MSCR[170].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR171        SIUL2.MSCR[171].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR172        SIUL2.MSCR[172].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR173        SIUL2.MSCR[173].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR174        SIUL2.MSCR[174].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR175        SIUL2.MSCR[175].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR176        SIUL2.MSCR[176].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR177        SIUL2.MSCR[177].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR178        SIUL2.MSCR[178].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR179        SIUL2.MSCR[179].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR180        SIUL2.MSCR[180].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR181        SIUL2.MSCR[181].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR182        SIUL2.MSCR[182].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR183        SIUL2.MSCR[183].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR184        SIUL2.MSCR[184].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR185        SIUL2.MSCR[185].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR186        SIUL2.MSCR[186].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR187        SIUL2.MSCR[187].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR188        SIUL2.MSCR[188].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR189        SIUL2.MSCR[189].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR190        SIUL2.MSCR[190].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR191        SIUL2.MSCR[191].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR192        SIUL2.MSCR[192].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR193        SIUL2.MSCR[193].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR194        SIUL2.MSCR[194].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR195        SIUL2.MSCR[195].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR196        SIUL2.MSCR[196].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR197        SIUL2.MSCR[197].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR198        SIUL2.MSCR[198].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_IMCR0          SIUL2.IMCR[0].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR1          SIUL2.IMCR[1].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR2          SIUL2.IMCR[2].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR3          SIUL2.IMCR[3].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR4          SIUL2.IMCR[4].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR5          SIUL2.IMCR[5].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR6          SIUL2.IMCR[6].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR7          SIUL2.IMCR[7].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR8          SIUL2.IMCR[8].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR9          SIUL2.IMCR[9].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR10         SIUL2.IMCR[10].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR11         SIUL2.IMCR[11].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR12         SIUL2.IMCR[12].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR13         SIUL2.IMCR[13].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR14         SIUL2.IMCR[14].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR15         SIUL2.IMCR[15].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR16         SIUL2.IMCR[16].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR17         SIUL2.IMCR[17].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR18         SIUL2.IMCR[18].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR19         SIUL2.IMCR[19].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR20         SIUL2.IMCR[20].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR21         SIUL2.IMCR[21].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR22         SIUL2.IMCR[22].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR23         SIUL2.IMCR[23].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR24         SIUL2.IMCR[24].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR25         SIUL2.IMCR[25].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR26         SIUL2.IMCR[26].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR27         SIUL2.IMCR[27].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR28         SIUL2.IMCR[28].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR29         SIUL2.IMCR[29].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR30         SIUL2.IMCR[30].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR31         SIUL2.IMCR[31].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR32         SIUL2.IMCR[32].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR33         SIUL2.IMCR[33].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR34         SIUL2.IMCR[34].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR35         SIUL2.IMCR[35].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR36         SIUL2.IMCR[36].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR37         SIUL2.IMCR[37].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR38         SIUL2.IMCR[38].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR39         SIUL2.IMCR[39].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR40         SIUL2.IMCR[40].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR41         SIUL2.IMCR[41].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR42         SIUL2.IMCR[42].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR43         SIUL2.IMCR[43].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR44         SIUL2.IMCR[44].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR45         SIUL2.IMCR[45].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR46         SIUL2.IMCR[46].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR47         SIUL2.IMCR[47].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR48         SIUL2.IMCR[48].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR49         SIUL2.IMCR[49].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR50         SIUL2.IMCR[50].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR51         SIUL2.IMCR[51].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR52         SIUL2.IMCR[52].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR53         SIUL2.IMCR[53].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR54         SIUL2.IMCR[54].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR55         SIUL2.IMCR[55].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR56         SIUL2.IMCR[56].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR57         SIUL2.IMCR[57].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR58         SIUL2.IMCR[58].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR59         SIUL2.IMCR[59].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR60         SIUL2.IMCR[60].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR61         SIUL2.IMCR[61].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR62         SIUL2.IMCR[62].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR63         SIUL2.IMCR[63].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR64         SIUL2.IMCR[64].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR65         SIUL2.IMCR[65].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR66         SIUL2.IMCR[66].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR67         SIUL2.IMCR[67].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR68         SIUL2.IMCR[68].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR69         SIUL2.IMCR[69].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR70         SIUL2.IMCR[70].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR71         SIUL2.IMCR[71].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR72         SIUL2.IMCR[72].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR73         SIUL2.IMCR[73].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR74         SIUL2.IMCR[74].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR75         SIUL2.IMCR[75].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR76         SIUL2.IMCR[76].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR77         SIUL2.IMCR[77].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR78         SIUL2.IMCR[78].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR79         SIUL2.IMCR[79].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR80         SIUL2.IMCR[80].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR81         SIUL2.IMCR[81].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR82         SIUL2.IMCR[82].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR83         SIUL2.IMCR[83].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR84         SIUL2.IMCR[84].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR85         SIUL2.IMCR[85].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR86         SIUL2.IMCR[86].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR87         SIUL2.IMCR[87].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR88         SIUL2.IMCR[88].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR89         SIUL2.IMCR[89].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR90         SIUL2.IMCR[90].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR91         SIUL2.IMCR[91].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR92         SIUL2.IMCR[92].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR93         SIUL2.IMCR[93].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_GPDO0_3        SIUL2.GPDO[0].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO4_7        SIUL2.GPDO[1].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO8_11       SIUL2.GPDO[2].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO12_15      SIUL2.GPDO[3].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO16_19      SIUL2.GPDO[4].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO20_23      SIUL2.GPDO[5].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO24_27      SIUL2.GPDO[6].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO28_31      SIUL2.GPDO[7].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO32_35      SIUL2.GPDO[8].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO36_39      SIUL2.GPDO[9].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO40_43      SIUL2.GPDO[10].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO44_47      SIUL2.GPDO[11].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO48_51      SIUL2.GPDO[12].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO52_55      SIUL2.GPDO[13].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO56_59      SIUL2.GPDO[14].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO60_63      SIUL2.GPDO[15].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO64_67      SIUL2.GPDO[16].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO68_71      SIUL2.GPDO[17].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO72_75      SIUL2.GPDO[18].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO76_79      SIUL2.GPDO[19].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO80_83      SIUL2.GPDO[20].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO84_87      SIUL2.GPDO[21].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO88_91      SIUL2.GPDO[22].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO92_95      SIUL2.GPDO[23].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO96_99      SIUL2.GPDO[24].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO100_103    SIUL2.GPDO[25].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO104_107    SIUL2.GPDO[26].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO108_111    SIUL2.GPDO[27].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO112_115    SIUL2.GPDO[28].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO116_119    SIUL2.GPDO[29].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO120_123    SIUL2.GPDO[30].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO124_127    SIUL2.GPDO[31].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO128_131    SIUL2.GPDO[32].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO132_135    SIUL2.GPDO[33].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO136_139    SIUL2.GPDO[34].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO140_143    SIUL2.GPDO[35].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO144_147    SIUL2.GPDO[36].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO148_151    SIUL2.GPDO[37].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO152_155    SIUL2.GPDO[38].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO156_159    SIUL2.GPDO[39].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO160_163    SIUL2.GPDO[40].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO164_167    SIUL2.GPDO[41].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO168_171    SIUL2.GPDO[42].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO172_175    SIUL2.GPDO[43].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO176_179    SIUL2.GPDO[44].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO180_183    SIUL2.GPDO[45].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO184_187    SIUL2.GPDO[46].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO188_191    SIUL2.GPDO[47].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO192_195    SIUL2.GPDO[48].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO           SIUL2.GPDO[49].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDI0_3        SIUL2.GPDI[0].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI4_7        SIUL2.GPDI[1].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI8_11       SIUL2.GPDI[2].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI12_15      SIUL2.GPDI[3].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI16_19      SIUL2.GPDI[4].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI20_23      SIUL2.GPDI[5].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI24_27      SIUL2.GPDI[6].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI28_31      SIUL2.GPDI[7].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI32_35      SIUL2.GPDI[8].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI36_39      SIUL2.GPDI[9].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI40_43      SIUL2.GPDI[10].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI44_47      SIUL2.GPDI[11].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI48_51      SIUL2.GPDI[12].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI52_55      SIUL2.GPDI[13].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI56_59      SIUL2.GPDI[14].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI60_63      SIUL2.GPDI[15].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI64_67      SIUL2.GPDI[16].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI68_71      SIUL2.GPDI[17].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI72_75      SIUL2.GPDI[18].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI76_79      SIUL2.GPDI[19].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI80_83      SIUL2.GPDI[20].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI84_87      SIUL2.GPDI[21].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI88_91      SIUL2.GPDI[22].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI92_95      SIUL2.GPDI[23].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI96_99      SIUL2.GPDI[24].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI100_103    SIUL2.GPDI[25].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI104_107    SIUL2.GPDI[26].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI108_111    SIUL2.GPDI[27].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI112_115    SIUL2.GPDI[28].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI116_119    SIUL2.GPDI[29].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI120_123    SIUL2.GPDI[30].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI124_127    SIUL2.GPDI[31].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI128_131    SIUL2.GPDI[32].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI132_135    SIUL2.GPDI[33].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI136_139    SIUL2.GPDI[34].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI140_143    SIUL2.GPDI[35].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI144_147    SIUL2.GPDI[36].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI148_151    SIUL2.GPDI[37].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI152_155    SIUL2.GPDI[38].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI156_159    SIUL2.GPDI[39].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI160_163    SIUL2.GPDI[40].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI164_167    SIUL2.GPDI[41].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI168_171    SIUL2.GPDI[42].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI172_175    SIUL2.GPDI[43].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI176_179    SIUL2.GPDI[44].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI180_183    SIUL2.GPDI[45].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI184_187    SIUL2.GPDI[46].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI188_191    SIUL2.GPDI[47].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI192_195    SIUL2.GPDI[48].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI           SIUL2.GPDI[49].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_PGPDO0         SIUL2.PGPDO[0].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO1         SIUL2.PGPDO[1].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO2         SIUL2.PGPDO[2].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO3         SIUL2.PGPDO[3].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO4         SIUL2.PGPDO[4].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO5         SIUL2.PGPDO[5].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO6         SIUL2.PGPDO[6].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO7         SIUL2.PGPDO[7].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO8         SIUL2.PGPDO[8].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO9         SIUL2.PGPDO[9].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO10        SIUL2.PGPDO[10].R             /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO11        SIUL2.PGPDO[11].R             /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO12        SIUL2.PGPDO[12].R             /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDI0         SIUL2.PGPDI[0].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI1         SIUL2.PGPDI[1].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI2         SIUL2.PGPDI[2].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI3         SIUL2.PGPDI[3].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI4         SIUL2.PGPDI[4].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI5         SIUL2.PGPDI[5].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI6         SIUL2.PGPDI[6].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI7         SIUL2.PGPDI[7].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI8         SIUL2.PGPDI[8].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI9         SIUL2.PGPDI[9].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI10        SIUL2.PGPDI[10].R             /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI11        SIUL2.PGPDI[11].R             /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI12        SIUL2.PGPDI[12].R             /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_MPGPDO0        SIUL2.MPGPDO[0].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO1        SIUL2.MPGPDO[1].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO2        SIUL2.MPGPDO[2].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO3        SIUL2.MPGPDO[3].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO4        SIUL2.MPGPDO[4].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO5        SIUL2.MPGPDO[5].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO6        SIUL2.MPGPDO[6].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO7        SIUL2.MPGPDO[7].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO8        SIUL2.MPGPDO[8].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO9        SIUL2.MPGPDO[9].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO10       SIUL2.MPGPDO[10].R            /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO11       SIUL2.MPGPDO[11].R            /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO12       SIUL2.MPGPDO[12].R            /* SIUL2 Masked Parallel GPIO Pad Data Out Register */

/* SMPU */
#define SMPU_0_CESR0         SMPU_0.CESR0.R                /* Control/Error Status Register 0 */
#define SMPU_0_CESR1         SMPU_0.CESR1.R                /* Control/Error Status Register 1 */
#define SMPU_0_EAR0          SMPU_0.ERROR[0].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR0          SMPU_0.ERROR[0].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR1          SMPU_0.ERROR[1].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR1          SMPU_0.ERROR[1].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR2          SMPU_0.ERROR[2].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR2          SMPU_0.ERROR[2].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR3          SMPU_0.ERROR[3].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR3          SMPU_0.ERROR[3].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR4          SMPU_0.ERROR[4].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR4          SMPU_0.ERROR[4].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR5          SMPU_0.ERROR[5].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR5          SMPU_0.ERROR[5].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR6          SMPU_0.ERROR[6].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR6          SMPU_0.ERROR[6].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR7          SMPU_0.ERROR[7].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR7          SMPU_0.ERROR[7].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR8          SMPU_0.ERROR[8].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR8          SMPU_0.ERROR[8].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR9          SMPU_0.ERROR[9].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR9          SMPU_0.ERROR[9].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR10         SMPU_0.ERROR[10].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR10         SMPU_0.ERROR[10].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR11         SMPU_0.ERROR[11].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR11         SMPU_0.ERROR[11].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR12         SMPU_0.ERROR[12].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR12         SMPU_0.ERROR[12].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR13         SMPU_0.ERROR[13].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR13         SMPU_0.ERROR[13].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR14         SMPU_0.ERROR[14].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR14         SMPU_0.ERROR[14].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR15         SMPU_0.ERROR[15].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR15         SMPU_0.ERROR[15].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_RGD0_WORD0    SMPU_0.RGD[0].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD0_WORD1    SMPU_0.RGD[0].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD0_WORD2    SMPU_0.RGD[0].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD0_WORD3    SMPU_0.RGD[0].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD1_WORD0    SMPU_0.RGD[1].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD1_WORD1    SMPU_0.RGD[1].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD1_WORD2    SMPU_0.RGD[1].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD1_WORD3    SMPU_0.RGD[1].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD2_WORD0    SMPU_0.RGD[2].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD2_WORD1    SMPU_0.RGD[2].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD2_WORD2    SMPU_0.RGD[2].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD2_WORD3    SMPU_0.RGD[2].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD3_WORD0    SMPU_0.RGD[3].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD3_WORD1    SMPU_0.RGD[3].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD3_WORD2    SMPU_0.RGD[3].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD3_WORD3    SMPU_0.RGD[3].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD4_WORD0    SMPU_0.RGD[4].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD4_WORD1    SMPU_0.RGD[4].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD4_WORD2    SMPU_0.RGD[4].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD4_WORD3    SMPU_0.RGD[4].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD5_WORD0    SMPU_0.RGD[5].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD5_WORD1    SMPU_0.RGD[5].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD5_WORD2    SMPU_0.RGD[5].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD5_WORD3    SMPU_0.RGD[5].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD6_WORD0    SMPU_0.RGD[6].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD6_WORD1    SMPU_0.RGD[6].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD6_WORD2    SMPU_0.RGD[6].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD6_WORD3    SMPU_0.RGD[6].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD7_WORD0    SMPU_0.RGD[7].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD7_WORD1    SMPU_0.RGD[7].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD7_WORD2    SMPU_0.RGD[7].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD7_WORD3    SMPU_0.RGD[7].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD8_WORD0    SMPU_0.RGD[8].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD8_WORD1    SMPU_0.RGD[8].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD8_WORD2    SMPU_0.RGD[8].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD8_WORD3    SMPU_0.RGD[8].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD9_WORD0    SMPU_0.RGD[9].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD9_WORD1    SMPU_0.RGD[9].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD9_WORD2    SMPU_0.RGD[9].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD9_WORD3    SMPU_0.RGD[9].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD10_WORD0   SMPU_0.RGD[10].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD10_WORD1   SMPU_0.RGD[10].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD10_WORD2   SMPU_0.RGD[10].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD10_WORD3   SMPU_0.RGD[10].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD11_WORD0   SMPU_0.RGD[11].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD11_WORD1   SMPU_0.RGD[11].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD11_WORD2   SMPU_0.RGD[11].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD11_WORD3   SMPU_0.RGD[11].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD12_WORD0   SMPU_0.RGD[12].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD12_WORD1   SMPU_0.RGD[12].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD12_WORD2   SMPU_0.RGD[12].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD12_WORD3   SMPU_0.RGD[12].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD13_WORD0   SMPU_0.RGD[13].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD13_WORD1   SMPU_0.RGD[13].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD13_WORD2   SMPU_0.RGD[13].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD13_WORD3   SMPU_0.RGD[13].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD14_WORD0   SMPU_0.RGD[14].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD14_WORD1   SMPU_0.RGD[14].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD14_WORD2   SMPU_0.RGD[14].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD14_WORD3   SMPU_0.RGD[14].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD15_WORD0   SMPU_0.RGD[15].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD15_WORD1   SMPU_0.RGD[15].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD15_WORD2   SMPU_0.RGD[15].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD15_WORD3   SMPU_0.RGD[15].WORD3.R        /* Region Descriptor n, Word 3 */

#define SMPU_1_CESR0         SMPU_1.CESR0.R                /* Control/Error Status Register 0 */
#define SMPU_1_CESR1         SMPU_1.CESR1.R                /* Control/Error Status Register 1 */
#define SMPU_1_EAR0          SMPU_1.ERROR[0].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR0          SMPU_1.ERROR[0].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR1          SMPU_1.ERROR[1].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR1          SMPU_1.ERROR[1].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR2          SMPU_1.ERROR[2].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR2          SMPU_1.ERROR[2].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR3          SMPU_1.ERROR[3].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR3          SMPU_1.ERROR[3].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR4          SMPU_1.ERROR[4].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR4          SMPU_1.ERROR[4].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR5          SMPU_1.ERROR[5].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR5          SMPU_1.ERROR[5].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR6          SMPU_1.ERROR[6].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR6          SMPU_1.ERROR[6].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR7          SMPU_1.ERROR[7].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR7          SMPU_1.ERROR[7].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR8          SMPU_1.ERROR[8].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR8          SMPU_1.ERROR[8].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR9          SMPU_1.ERROR[9].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_1_EDR9          SMPU_1.ERROR[9].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR10         SMPU_1.ERROR[10].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR10         SMPU_1.ERROR[10].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR11         SMPU_1.ERROR[11].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR11         SMPU_1.ERROR[11].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR12         SMPU_1.ERROR[12].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR12         SMPU_1.ERROR[12].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR13         SMPU_1.ERROR[13].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR13         SMPU_1.ERROR[13].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR14         SMPU_1.ERROR[14].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR14         SMPU_1.ERROR[14].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_EAR15         SMPU_1.ERROR[15].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_1_EDR15         SMPU_1.ERROR[15].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_1_RGD0_WORD0    SMPU_1.RGD[0].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD0_WORD1    SMPU_1.RGD[0].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD0_WORD2    SMPU_1.RGD[0].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD0_WORD3    SMPU_1.RGD[0].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD1_WORD0    SMPU_1.RGD[1].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD1_WORD1    SMPU_1.RGD[1].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD1_WORD2    SMPU_1.RGD[1].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD1_WORD3    SMPU_1.RGD[1].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD2_WORD0    SMPU_1.RGD[2].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD2_WORD1    SMPU_1.RGD[2].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD2_WORD2    SMPU_1.RGD[2].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD2_WORD3    SMPU_1.RGD[2].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD3_WORD0    SMPU_1.RGD[3].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD3_WORD1    SMPU_1.RGD[3].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD3_WORD2    SMPU_1.RGD[3].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD3_WORD3    SMPU_1.RGD[3].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD4_WORD0    SMPU_1.RGD[4].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD4_WORD1    SMPU_1.RGD[4].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD4_WORD2    SMPU_1.RGD[4].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD4_WORD3    SMPU_1.RGD[4].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD5_WORD0    SMPU_1.RGD[5].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD5_WORD1    SMPU_1.RGD[5].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD5_WORD2    SMPU_1.RGD[5].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD5_WORD3    SMPU_1.RGD[5].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD6_WORD0    SMPU_1.RGD[6].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD6_WORD1    SMPU_1.RGD[6].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD6_WORD2    SMPU_1.RGD[6].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD6_WORD3    SMPU_1.RGD[6].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD7_WORD0    SMPU_1.RGD[7].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD7_WORD1    SMPU_1.RGD[7].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD7_WORD2    SMPU_1.RGD[7].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD7_WORD3    SMPU_1.RGD[7].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD8_WORD0    SMPU_1.RGD[8].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD8_WORD1    SMPU_1.RGD[8].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD8_WORD2    SMPU_1.RGD[8].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD8_WORD3    SMPU_1.RGD[8].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD9_WORD0    SMPU_1.RGD[9].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD9_WORD1    SMPU_1.RGD[9].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD9_WORD2    SMPU_1.RGD[9].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD9_WORD3    SMPU_1.RGD[9].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD10_WORD0   SMPU_1.RGD[10].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD10_WORD1   SMPU_1.RGD[10].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD10_WORD2   SMPU_1.RGD[10].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD10_WORD3   SMPU_1.RGD[10].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD11_WORD0   SMPU_1.RGD[11].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD11_WORD1   SMPU_1.RGD[11].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD11_WORD2   SMPU_1.RGD[11].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD11_WORD3   SMPU_1.RGD[11].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD12_WORD0   SMPU_1.RGD[12].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD12_WORD1   SMPU_1.RGD[12].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD12_WORD2   SMPU_1.RGD[12].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD12_WORD3   SMPU_1.RGD[12].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD13_WORD0   SMPU_1.RGD[13].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD13_WORD1   SMPU_1.RGD[13].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD13_WORD2   SMPU_1.RGD[13].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD13_WORD3   SMPU_1.RGD[13].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD14_WORD0   SMPU_1.RGD[14].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD14_WORD1   SMPU_1.RGD[14].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD14_WORD2   SMPU_1.RGD[14].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD14_WORD3   SMPU_1.RGD[14].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_1_RGD15_WORD0   SMPU_1.RGD[15].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_1_RGD15_WORD1   SMPU_1.RGD[15].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_1_RGD15_WORD2   SMPU_1.RGD[15].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_1_RGD15_WORD3   SMPU_1.RGD[15].WORD3.R        /* Region Descriptor n, Word 3 */

/* SPI */
#define SPI_1_MCR            SPI_1.MCR.R                   /* Module Configuration Register */
#define SPI_1_TCR            SPI_1.TCR.R                   /* Transfer Count Register */
#define SPI_1_CTAR0          SPI_1.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR1          SPI_1.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR2          SPI_1.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR3          SPI_1.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR4          SPI_1.MODE.CTAR[4].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR5          SPI_1.MODE.CTAR[5].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR6          SPI_1.MODE.CTAR[6].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR7          SPI_1.MODE.CTAR[7].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR0_SLAVE    SPI_1.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_1_SR             SPI_1.SR.R                    /* Status Register */
#define SPI_1_RSER           SPI_1.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_1_PUSHR          SPI_1.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_1_PUSHR_SLAVE    SPI_1.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_1_POPR           SPI_1.POPR.R                  /* POP RX FIFO Register */
#define SPI_1_TXFR0          SPI_1.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR1          SPI_1.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR2          SPI_1.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR3          SPI_1.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR4          SPI_1.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_1_RXFR0          SPI_1.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_1_RXFR1          SPI_1.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_1_RXFR2          SPI_1.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_1_RXFR3          SPI_1.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_1_RXFR4          SPI_1.RXFR[4].R               /* Receive FIFO Registers */

#define SPI_2_MCR            SPI_2.MCR.R                   /* Module Configuration Register */
#define SPI_2_TCR            SPI_2.TCR.R                   /* Transfer Count Register */
#define SPI_2_CTAR0          SPI_2.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR1          SPI_2.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR2          SPI_2.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR3          SPI_2.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR4          SPI_2.MODE.CTAR[4].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR5          SPI_2.MODE.CTAR[5].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR6          SPI_2.MODE.CTAR[6].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR7          SPI_2.MODE.CTAR[7].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR0_SLAVE    SPI_2.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_2_SR             SPI_2.SR.R                    /* Status Register */
#define SPI_2_RSER           SPI_2.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_2_PUSHR          SPI_2.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_2_PUSHR_SLAVE    SPI_2.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_2_POPR           SPI_2.POPR.R                  /* POP RX FIFO Register */
#define SPI_2_TXFR0          SPI_2.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR1          SPI_2.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR2          SPI_2.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR3          SPI_2.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR4          SPI_2.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_2_RXFR0          SPI_2.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_2_RXFR1          SPI_2.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_2_RXFR2          SPI_2.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_2_RXFR3          SPI_2.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_2_RXFR4          SPI_2.RXFR[4].R               /* Receive FIFO Registers */

/* SPT */
#define SPT_GBL_CTRL         SPT.GBL_CTRL.R                /* SPT Global Control Register */
#define SPT_ACQ_GBL_CTRL_0   SPT.ACQ_GBL_CTRL_0.R          /* Acquisition Global Control Register */
#define SPT_ACQ_GBL_CTRL_1   SPT.ACQ_GBL_CTRL_1.R          /* Acquisition Global Control Register 1 */
#define SPT_ACQ_CTRL0        SPT.ACQ_CTRL0.R               /* Acquisition Control 0 Register */
#define SPT_ACQ_CTRL1        SPT.ACQ_CTRL1.R               /* Acquisition Control 1 Register */
#define SPT_ACQ_CTRL2        SPT.ACQ_CTRL2.R               /* Acquisition Control 2 Register */
#define SPT_ACQ_CTRL3        SPT.ACQ_CTRL3.R               /* Acquisition Control 3 Register */
#define SPT_SDMA_CTRL0       SPT.SDMA_CTRL0.R              /* SDMA Control 0 Register */
#define SPT_SDMA_CTRL1       SPT.SDMA_CTRL1.R              /* SDMA Control 1 Register */
#define SPT_ACQ_STATUS_A0    SPT.ACQ_STATUS_A0.R           /* Acquisition Status Register A0 */
#define SPT_ACQ_STATUS_A1    SPT.ACQ_STATUS_A1.R           /* Acquisition Status Register A1 */
#define SPT_ACQ_STATUS_A2    SPT.ACQ_STATUS_A2.R           /* Acquisition Status Register A2 */
#define SPT_ACQ_STATUS_B0    SPT.ACQ_STATUS_B0.R           /* Acquisition Status Register B0 */
#define SPT_ACQ_STATUS_B1    SPT.ACQ_STATUS_B1.R           /* Acquisition Status Register B1 */
#define SPT_ACQ_STATUS_B2    SPT.ACQ_STATUS_B2.R           /* Acquisition Status Register B2 */
#define SPT_ACQ_STATUS_C0    SPT.ACQ_STATUS_C0.R           /* Acquisition Status Register C0 */
#define SPT_ACQ_STATUS_C1    SPT.ACQ_STATUS_C1.R           /* Acquisition Status Register C1 */
#define SPT_ACQ_STATUS_C2    SPT.ACQ_STATUS_C2.R           /* Acquisition Status Register C2 */
#define SPT_ACQ_STATUS_D0    SPT.ACQ_STATUS_D0.R           /* Acquisition Status Register D0 */
#define SPT_ACQ_STATUS_D1    SPT.ACQ_STATUS_D1.R           /* Acquisition Status Register D1 */
#define SPT_ACQ_STATUS_D2    SPT.ACQ_STATUS_D2.R           /* Acquisition Status Register D2 */
#define SPT_ACQ_STATUS_E0    SPT.ACQ_STATUS_E0.R           /* Acquisition Status Register E0 */
#define SPT_ACQ_STATUS_E1    SPT.ACQ_STATUS_E1.R           /* Acquisition Status Register E1 */
#define SPT_ACQ_STATUS_E2    SPT.ACQ_STATUS_E2.R           /* Acquisition Status Register E2 */
#define SPT_ACQ_STATUS_F0    SPT.ACQ_STATUS_F0.R           /* Acquisition Status Register F0 */
#define SPT_ACQ_STATUS_F1    SPT.ACQ_STATUS_F1.R           /* Acquisition Status Register F1 */
#define SPT_ACQ_STATUS_F2    SPT.ACQ_STATUS_F2.R           /* Acquisition Status Register F2 */
#define SPT_ACQ_STATUS_G0    SPT.ACQ_STATUS_G0.R           /* Acquisition Status Register G0 */
#define SPT_ACQ_STATUS_G1    SPT.ACQ_STATUS_G1.R           /* Acquisition Status Register G1 */
#define SPT_ACQ_STATUS_G2    SPT.ACQ_STATUS_G2.R           /* Acquisition Status Register G2 */
#define SPT_ACQ_STATUS_H0    SPT.ACQ_STATUS_H0.R           /* Acquisition Status Register H0 */
#define SPT_ACQ_STATUS_H1    SPT.ACQ_STATUS_H1.R           /* Acquisition Status Register H1 */
#define SPT_ACQ_STATUS_H2    SPT.ACQ_STATUS_H2.R           /* Acquisition Status Register H2 */
#define SPT_ACQ_CSI_CTRL     SPT.ACQ_CSI_CTRL.R            /* Acquisition MIPICSI2 control register */
#define SPT_SDMA_BYP_CTRL0   SPT.SDMA_BYP_CTRL0.R          /* Bypass SDMA Control 0 */
#define SPT_SDMA_BYP_CTRL1   SPT.SDMA_BYP_CTRL1.R          /* Bypass SDMA Control 1 Register */
#define SPT_ACQ_BYP_CTRL     SPT.ACQ_BYP_CTRL.R            /* Acquisition Bypass Control Register */
#define SPT_CS_PG_ST_ADDR    SPT.CS_PG_ST_ADDR.R           /* Program Start Addr Register */
#define SPT_CS_MODE_CTRL     SPT.CS_MODE_CTRL.R            /* Mode Control Register */
#define SPT_CS_WD_COUNT      SPT.CS_WD_COUNT.R             /* Watchdog Counter Register */
#define SPT_CS_BKPT0_ADDR    SPT.CS_BKPT0_ADDR.R           /* Breakpoint0 Addr Register */
#define SPT_CS_BKPT1_ADDR    SPT.CS_BKPT1_ADDR.R           /* Breakpoint1 Addr Register */
#define SPT_CS_BKPT2_ADDR    SPT.CS_BKPT2_ADDR.R           /* Breakpoint2 Addr Register */
#define SPT_CS_BKPT3_ADDR    SPT.CS_BKPT3_ADDR.R           /* Breakpoint3 Addr Register */
#define SPT_CS_JAM_INST0     SPT.CS_JAM_INST0.R            /* Jamming Instruction0 Register */
#define SPT_CS_JAM_INST1     SPT.CS_JAM_INST1.R            /* Jamming Instruction1 Register */
#define SPT_CS_JAM_INST2     SPT.CS_JAM_INST2.R            /* Jamming Instruction2 Register */
#define SPT_CS_JAM_INST3     SPT.CS_JAM_INST3.R            /* Jamming Instruction3 Register */
#define SPT_CS_CURR_INST_ADDR SPT.CS_CURR_INST_ADDR.R      /* Current Instruction Addr Register */
#define SPT_CS_CURR_INST0    SPT.CS_CURR_INST0.R           /* Current Instruction0 Register */
#define SPT_CS_CURR_INST1    SPT.CS_CURR_INST1.R           /* Current Instruction1 Register */
#define SPT_CS_CURR_INST2    SPT.CS_CURR_INST2.R           /* Current Instruction2 Register */
#define SPT_CS_CURR_INST3    SPT.CS_CURR_INST3.R           /* Current Instruction3 Register */
#define SPT_CS_LOOPCNTR01    SPT.CS_LOOPCNTR01.R           /* Loop Counter 0 and 1 Register */
#define SPT_CS_LOOPCNTR23    SPT.CS_LOOPCNTR23.R           /* Loop Counter 2 and 3 Register */
#define SPT_CS_ERR_INST_ADDR SPT.CS_ERR_INST_ADDR.R        /* Error Instruction Addr Register */
#define SPT_CS_ERR_INST0     SPT.CS_ERR_INST0.R            /* Error Instruction 0 Register */
#define SPT_CS_ERR_INST1     SPT.CS_ERR_INST1.R            /* Error Instruction 1 Register */
#define SPT_CS_ERR_INST2     SPT.CS_ERR_INST2.R            /* Error Instruction 2 Register */
#define SPT_CS_ERR_INST3     SPT.CS_ERR_INST3.R            /* Error Instruction 3 Register */
#define SPT_CS_STATUS0       SPT.CS_STATUS0.R              /* General Status 0 Register */
#define SPT_CS_STATUS1       SPT.CS_STATUS1.R              /* General Status 1 Register */
#define SPT_CS_STATUS2       SPT.CS_STATUS2.R              /* General Status2 Register */
#define SPT_CS_STATUS3       SPT.CS_STATUS3.R              /* General Status 3 Register */
#define SPT_CS_EVTREG1       SPT.CS_EVTREG1.R              /* EVT1 Status Register */
#define SPT_CS_EVTREG2       SPT.CS_EVTREG2.R              /* EVT2 Status Register */
#define SPT_CS_SW_EVTREG     SPT.CS_SW_EVTREG.R            /* SW Event Trigger Register */
#define SPT_CORE1_VER_EVT    SPT.CORE1_VER_EVT.R           /* Core 1 Version Register Events */
#define SPT_CORE2_VER_EVT    SPT.CORE2_VER_EVT.R           /* Core 2 Version Register Events */
#define SPT_EVENT_RST_CTRL   SPT.EVENT_RST_CTRL.R          /* SPT Event Reset Control Register */
#define SPT_PDMA_LFSR_LOAD_VAL_HIGH SPT.PDMA_LFSR_LOAD_VAL_HIGH.R /* LFSR Load High Value */
#define SPT_PDMA_LFSR_LOAD_VAL_LOW SPT.PDMA_LFSR_LOAD_VAL_LOW.R /* LFSR Load Low Value */
#define SPT_PDMA_CONTROL     SPT.PDMA_CONTROL.R            /* PDMA Control Register */
#define SPT_PDMA_TRANSFER_COUNT_STATUS SPT.PDMA_TRANSFER_COUNT_STATUS.R /* PDMA Transfer Count Status */
#define SPT_PDMA_FMTB_EXP_ADDR_STATUS SPT.PDMA_FMTB_EXP_ADDR_STATUS.R /* PDMA formatB Exponent Address status Register */
#define SPT_MEM_ERR_INJECT_CTRL SPT.MEM_ERR_INJECT_CTRL.R  /* Memory Error Injection Register */
#define SPT_MEM_ERR_STATUS   SPT.MEM_ERR_STATUS.R          /* Memory Error Status Register */
#define SPT_MEM_ERR_INT_EN   SPT.MEM_ERR_INT_EN.R          /* Memory Interrupt Enable register */
#define SPT_DMA_ERR_STATUS   SPT.DMA_ERR_STATUS.R          /* DMA Error Status Register */
#define SPT_DMA_ERR_INT_EN   SPT.DMA_ERR_INT_EN.R          /* Interrupt Enable for DMA_ERROR_STATUS */
#define SPT_GBL_STATUS       SPT.GBL_STATUS.R              /* Global Status Register */
#define SPT_GBL_STATUS_IE    SPT.GBL_STATUS_IE.R           /* Global Status Interrupt Enable Register */
#define SPT_HW_ACC_ERR_STATUS SPT.HW_ACC_ERR_STATUS.R      /* Hardware Accelerator Error Status Register */
#define SPT_HW_ACC_ERR_IE    SPT.HW_ACC_ERR_IE.R           /* Hardware Accelerator Error Interrupt Enable Register */
#define SPT_HIST_OVF_STATUS0 SPT.HIST_OVF_STATUS0.R        /* HIST Overflow Status0 Register */
#define SPT_HIST_OVF_STATUS1 SPT.HIST_OVF_STATUS1.R        /* HIST Overflow Status1 Register */
#define SPT_HIST_OVF_IE      SPT.HIST_OVF_IE.R             /* HIST Overflow Interrupt Enable Register */
#define SPT_CS_INTEN0        SPT.CS_INTEN0.R               /* Interrupt Enable Register 0 */
#define SPT_CS_INTEN1        SPT.CS_INTEN1.R               /* Interrupt Enable Register 1 */
#define SPT_CS_EVT1_INTEN    SPT.CS_EVT1_INTEN.R           /* EVT1 Interrupt Enable Register */
#define SPT_CS_EVT2_INTEN    SPT.CS_EVT2_INTEN.R           /* EVT2 Interrupt Enable Register */
#define SPT_WR_0_15_CTRL_REG SPT.WR_0_15_CTRL_REG.R        /*  */
#define SPT_WR_16_31_CTRL_REG SPT.WR_16_31_CTRL_REG.R      /*  */
#define SPT_WR_32_47_CTRL_REG SPT.WR_32_47_CTRL_REG.R      /*  */
#define SPT_WR_R0_RE         SPT.WR_R0_RE.R                /* Work Register R0 Real */
#define SPT_WR_R0_IM         SPT.WR_R0_IM.R                /* Work Register R0 Imaginary */
#define SPT_WR_R1_RE         SPT.WR_R1_RE.R                /* Work Register R1 Real */
#define SPT_WR_R1_IM         SPT.WR_R1_IM.R                /* Work Register R1 Imaginary */
#define SPT_WR_R2_RE         SPT.WR_R2_RE.R                /* Work Register R0 Real */
#define SPT_WR_R2_IM         SPT.WR_R2_IM.R                /* Work Register R2 Imaginary */
#define SPT_WR_R3_RE         SPT.WR_R3_RE.R                /* Work Register R3 Real */
#define SPT_WR_R3_IM         SPT.WR_R3_IM.R                /* Work Register R3 Imaginary */
#define SPT_WR_R4_RE         SPT.WR_R4_RE.R                /* Work Register R4 Real */
#define SPT_WR_R4_IM         SPT.WR_R4_IM.R                /* Work Register R4 Imaginary */
#define SPT_WR_R5_RE         SPT.WR_R5_RE.R                /* Work Register R5 Real */
#define SPT_WR_R5_IM         SPT.WR_R5_IM.R                /* Work Register R5 Imaginary */
#define SPT_WR_R6_RE         SPT.WR_R6_RE.R                /* Work Register R6 Real */
#define SPT_WR_R6_IM         SPT.WR_R6_IM.R                /* Work Register R6 Imaginary */
#define SPT_WR_R7_RE         SPT.WR_R7_RE.R                /* Work Register R7 Real */
#define SPT_WR_R7_IM         SPT.WR_R7_IM.R                /* Work Register R7 Imaginary */
#define SPT_WR_R8_RE         SPT.WR_R8_RE.R                /* Work Register R8 Real */
#define SPT_WR_R8_IM         SPT.WR_R8_IM.R                /* Work Register R8 Imaginary */
#define SPT_WR_R9_RE         SPT.WR_R9_RE.R                /* Work Register R9 Real */
#define SPT_WR_R9_IM         SPT.WR_R9_IM.R                /* Work Register R9 Imaginary */
#define SPT_WR_R10_RE        SPT.WR_R10_RE.R               /* Work Register R10 Real */
#define SPT_WR_R10_IM        SPT.WR_R10_IM.R               /* Work Register R10 Imaginary */
#define SPT_WR_R11_RE        SPT.WR_R11_RE.R               /* Work Register R11 Real */
#define SPT_WR_R11_IM        SPT.WR_R11_IM.R               /* Work Register R11 Imaginary */
#define SPT_WR_R12_RE        SPT.WR_R12_RE.R               /* Work Register R12 Real */
#define SPT_WR_R12_IM        SPT.WR_R12_IM.R               /* Work Register R12 Imaginary */
#define SPT_WR_R13_RE        SPT.WR_R13_RE.R               /* Work Register R13 Real */
#define SPT_WR_R13_IM        SPT.WR_R13_IM.R               /* Work Register R13 Imaginary */
#define SPT_WR_R14_RE        SPT.WR_R14_RE.R               /* Work Register R14 Real */
#define SPT_WR_R14_IM        SPT.WR_R14_IM.R               /* Work Register R14 Imaginary */
#define SPT_WR_R15_RE        SPT.WR_R15_RE.R               /* Work Register R15 Real */
#define SPT_WR_R15_IM        SPT.WR_R15_IM.R               /* Work Register R15 Imaginary */
#define SPT_WR_R16_RE        SPT.WR_R16_RE.R               /* Work Register R16 Real */
#define SPT_WR_R16_IM        SPT.WR_R16_IM.R               /* Work Register R16 Imaginary */
#define SPT_WR_R17_RE        SPT.WR_R17_RE.R               /* Work Register R17 Real */
#define SPT_WR_R17_IM        SPT.WR_R17_IM.R               /* Work Register R17 Imaginary */
#define SPT_WR_R18_RE        SPT.WR_R18_RE.R               /* Work Register R18 Real */
#define SPT_WR_R18_IM        SPT.WR_R18_IM.R               /* Work Register R18 Imaginary */
#define SPT_WR_R19_RE        SPT.WR_R19_RE.R               /* Work Register R19 Real */
#define SPT_WR_R19_IM        SPT.WR_R19_IM.R               /* Work Register R19 Imaginary */
#define SPT_WR_R20_RE        SPT.WR_R20_RE.R               /* Work Register R20 Real */
#define SPT_WR_R20_IM        SPT.WR_R20_IM.R               /* Work Register R20 Imaginary */
#define SPT_WR_R21_RE        SPT.WR_R21_RE.R               /* Work Register R21 Real */
#define SPT_WR_R21_IM        SPT.WR_R21_IM.R               /* Work Register R21 Imaginary */
#define SPT_WR_R22_RE        SPT.WR_R22_RE.R               /* Work Register R22 Real */
#define SPT_WR_R22_IM        SPT.WR_R22_IM.R               /* Work Register R22 Imaginary */
#define SPT_WR_R23_RE        SPT.WR_R23_RE.R               /* Work Register R23 Real */
#define SPT_WR_R23_IM        SPT.WR_R23_IM.R               /* Work Register R23 Imaginary */
#define SPT_WR_R24_RE        SPT.WR_R24_RE.R               /* Work Register R24 Real */
#define SPT_WR_R24_IM        SPT.WR_R24_IM.R               /* Work Register R24 Imaginary */
#define SPT_WR_R25_RE        SPT.WR_R25_RE.R               /* Work Register R25 Real */
#define SPT_WR_R25_IM        SPT.WR_R25_IM.R               /* Work Register R25 Imaginary */
#define SPT_WR_R26_RE        SPT.WR_R26_RE.R               /* Work Register R26 Real */
#define SPT_WR_R26_IM        SPT.WR_R26_IM.R               /* Work Register R26 Imaginary */
#define SPT_WR_R27_RE        SPT.WR_R27_RE.R               /* Work Register R27 Real */
#define SPT_WR_R27_IM        SPT.WR_R27_IM.R               /* Work Register R27 Imaginary */
#define SPT_WR_R28_RE        SPT.WR_R28_RE.R               /* Work Register R28 Real */
#define SPT_WR_R28_IM        SPT.WR_R28_IM.R               /* Work Register R28 Imaginary */
#define SPT_WR_R29_RE        SPT.WR_R29_RE.R               /* Work Register R29 Real */
#define SPT_WR_R29_IM        SPT.WR_R29_IM.R               /* Work Register R29 Imaginary */
#define SPT_WR_R30_RE        SPT.WR_R30_RE.R               /* Work Register R30 Real */
#define SPT_WR_R30_IM        SPT.WR_R30_IM.R               /* Work Register R30 Imaginary */
#define SPT_WR_R31_RE        SPT.WR_R31_RE.R               /* Work Register R31 Real */
#define SPT_WR_R31_IM        SPT.WR_R31_IM.R               /* Work Register R31 Imaginary */
#define SPT_WR_R32_RE        SPT.WR_R32_RE.R               /* Work Register R32 Real */
#define SPT_WR_R32_IM        SPT.WR_R32_IM.R               /* Work Register R32 Imaginary */
#define SPT_WR_R33_RE        SPT.WR_R33_RE.R               /* Work Register R33 Real */
#define SPT_WR_R33_IM        SPT.WR_R33_IM.R               /* Work Register R33 Imaginary */
#define SPT_WR_R34_RE        SPT.WR_R34_RE.R               /* Work Register R34 Real */
#define SPT_WR_R34_IM        SPT.WR_R34_IM.R               /* Work Register R34 Imaginary */
#define SPT_WR_R35_RE        SPT.WR_R35_RE.R               /* Work Register R35 Real */
#define SPT_WR_R35_IM        SPT.WR_R35_IM.R               /* Work Register R35 Imaginary */
#define SPT_WR_R36_RE        SPT.WR_R36_RE.R               /* Work Register R36 Real */
#define SPT_WR_R36_IM        SPT.WR_R36_IM.R               /* Work Register R36 Imaginary */
#define SPT_WR_R37_RE        SPT.WR_R37_RE.R               /* Work Register R37 Real */
#define SPT_WR_R37_IM        SPT.WR_R37_IM.R               /* Work Register R37 Imaginary */
#define SPT_WR_R38_RE        SPT.WR_R38_RE.R               /* Work Register R38 Real */
#define SPT_WR_R38_IM        SPT.WR_R38_IM.R               /* Work Register R38 Imaginary */
#define SPT_WR_R39_RE        SPT.WR_R39_RE.R               /* Work Register R39 Real */
#define SPT_WR_R39_IM        SPT.WR_R39_IM.R               /* Work Register R39 Imaginary */
#define SPT_WR_R40_RE        SPT.WR_R40_RE.R               /* Work Register R40 Real */
#define SPT_WR_R40_IM        SPT.WR_R40_IM.R               /* Work Register R40 Imaginary */
#define SPT_WR_R41_RE        SPT.WR_R41_RE.R               /* Work Register R41 Real */
#define SPT_WR_R41_IM        SPT.WR_R41_IM.R               /* Work Register R41 Imaginary */
#define SPT_WR_R42_RE        SPT.WR_R42_RE.R               /* Work Register R42 Real */
#define SPT_WR_R42_IM        SPT.WR_R42_IM.R               /* Work Register R42 Imaginary */
#define SPT_WR_R43_RE        SPT.WR_R43_RE.R               /* Work Register R43 Real */
#define SPT_WR_R43_IM        SPT.WR_R43_IM.R               /* Work Register R43 Imaginary */
#define SPT_WR_R44_RE        SPT.WR_R44_RE.R               /* Work Register R44 Real */
#define SPT_WR_R44_IM        SPT.WR_R44_IM.R               /* Work Register R44 Imaginary */
#define SPT_WR_R45_RE        SPT.WR_R45_RE.R               /* Work Register R45 Real */
#define SPT_WR_R45_IM        SPT.WR_R45_IM.R               /* Work Register R45 Imaginary */
#define SPT_WR_R46_RE        SPT.WR_R46_RE.R               /* Work Register R46 Real */
#define SPT_WR_R46_IM        SPT.WR_R46_IM.R               /* Work Register R46 Imaginary */
#define SPT_WR_R47_RE        SPT.WR_R47_RE.R               /* Work Register R47 Real */
#define SPT_WR_R47_IM        SPT.WR_R47_IM.R               /* Work Register R47 Imaginary */

/* SSCM */
#define SSCM_STATUS          SSCM.STATUS.R                 /* SSCM System Status */
#define SSCM_MEMCONFIG       SSCM.MEMCONFIG.R              /* SSCM System Memory and ID Register */
#define SSCM_ERROR           SSCM.ERROR.R                  /* SSCM Error Configuration Register */
#define SSCM_PSA             SSCM.PSA.R                    /* Processor Start Address Register */
#define SSCM_LCSTAT          SSCM.LCSTAT.R                 /* Life Cycle Status Register */

/* STCU2 */
#define STCU2_RUN            STCU2.RUN.R                   /* STCU2 Run Register */
#define STCU2_RUNSW          STCU2.RUNSW.R                 /* STCU2 Run Software Register */
#define STCU2_SKC            STCU2.SKC.R                   /* STCU2 SK Code Register */
#define STCU2_CFG            STCU2.CFG.R                   /* STCU2 Configuration Register */
#define STCU2_PLL_CFG        STCU2.PLL_CFG.R               /* STCU2 PLL Configuration Register */
#define STCU2_WDG            STCU2.WDG.R                   /* STCU2 Watchdog Granularity */
#define STCU2_CRCE           STCU2.CRCE.R                  /* STCU2 CRC Expected Status Register */
#define STCU2_CRCR           STCU2.CRCR.R                  /* STCU2 CRC Read Status Register */
#define STCU2_ERR_STAT       STCU2.ERR_STAT.R              /* STCU2 Error Register */
#define STCU2_ERR_FM         STCU2.ERR_FM.R                /* STCU2 Error FM Register */
#define STCU2_LBS            STCU2.LBS.R                   /* STCU2 Off-Line LBIST Status Register */
#define STCU2_LBE            STCU2.LBE.R                   /* STCU2 Off-Line LBIST End Flag Register */
#define STCU2_LBSSW          STCU2.LBSSW.R                 /* STCU2 On-Line LBIST Status Register */
#define STCU2_LBESW          STCU2.LBESW.R                 /* STCU2 On-Line LBIST End Flag Register */
#define STCU2_LBRMSW         STCU2.LBRMSW.R                /* STCU2 On-Line LBIST Reset Management */
#define STCU2_LBUFM          STCU2.LBUFM.R                 /* STCU2 LBIST Unrecoverable FM Register */
#define STCU2_MBSL           STCU2.MBSL.R                  /* STCU2 Off-Line MBIST Status Low Register */
#define STCU2_MBSM           STCU2.MBSM.R                  /* STCU2 Off-Line MBIST Status Medium Register */
#define STCU2_MBSH           STCU2.MBSH.R                  /* STCU2 Off-Line MBIST Status High Register */
#define STCU2_MBEL           STCU2.MBEL.R                  /* STCU2 Off-Line MBIST End Flag Low Register */
#define STCU2_MBEM           STCU2.MBEM.R                  /* STCU2 Off-Line MBIST End Flag Medium Register */
#define STCU2_MBEH           STCU2.MBEH.R                  /* STCU2 Off-Line MBIST End Flag High Register */
#define STCU2_MBSLSW         STCU2.MBSLSW.R                /* STCU2 On-Line MBIST Status Low Register */
#define STCU2_MBSMSW         STCU2.MBSMSW.R                /* STCU2 On-Line MBIST Status Medium Register */
#define STCU2_MBSHSW         STCU2.MBSHSW.R                /* STCU2 On-Line MBIST Status High Register */
#define STCU2_MBELSW         STCU2.MBELSW.R                /* STCU2 On-Line MBIST End Flag Low Register */
#define STCU2_MBEMSW         STCU2.MBEMSW.R                /* STCU2 On-Line MBIST End Flag Medium Register */
#define STCU2_MBEHSW         STCU2.MBEHSW.R                /* STCU2 On-Line MBIST End Flag High Register */
#define STCU2_MBUFML         STCU2.MBUFML.R                /* STCU2 MBIST Unrecoverable FM Low Register */
#define STCU2_MBUFMM         STCU2.MBUFMM.R                /* STCU2 MBIST Unrecoverable FM Medium Register */
#define STCU2_MBUFMH         STCU2.MBUFMH.R                /* STCU2 MBIST Unrecoverable FM High Register */
#define STCU2_LB_CTRL0       STCU2.LB[0].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS0        STCU2.LB[0].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL0     STCU2.LB[0].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH0     STCU2.LB[0].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL0     STCU2.LB[0].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH0     STCU2.LB[0].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW0   STCU2.LB[0].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW0   STCU2.LB[0].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW0   STCU2.LB[0].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW0   STCU2.LB[0].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL1       STCU2.LB[1].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS1        STCU2.LB[1].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL1     STCU2.LB[1].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH1     STCU2.LB[1].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL1     STCU2.LB[1].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH1     STCU2.LB[1].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW1   STCU2.LB[1].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW1   STCU2.LB[1].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW1   STCU2.LB[1].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW1   STCU2.LB[1].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL2       STCU2.LB[2].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS2        STCU2.LB[2].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL2     STCU2.LB[2].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH2     STCU2.LB[2].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL2     STCU2.LB[2].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH2     STCU2.LB[2].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW2   STCU2.LB[2].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW2   STCU2.LB[2].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW2   STCU2.LB[2].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW2   STCU2.LB[2].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL3       STCU2.LB[3].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS3        STCU2.LB[3].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL3     STCU2.LB[3].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH3     STCU2.LB[3].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL3     STCU2.LB[3].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH3     STCU2.LB[3].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW3   STCU2.LB[3].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW3   STCU2.LB[3].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW3   STCU2.LB[3].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW3   STCU2.LB[3].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL4       STCU2.LB[4].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS4        STCU2.LB[4].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL4     STCU2.LB[4].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH4     STCU2.LB[4].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL4     STCU2.LB[4].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH4     STCU2.LB[4].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW4   STCU2.LB[4].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW4   STCU2.LB[4].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW4   STCU2.LB[4].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW4   STCU2.LB[4].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL5       STCU2.LB[5].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS5        STCU2.LB[5].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL5     STCU2.LB[5].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH5     STCU2.LB[5].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL5     STCU2.LB[5].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH5     STCU2.LB[5].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW5   STCU2.LB[5].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW5   STCU2.LB[5].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW5   STCU2.LB[5].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW5   STCU2.LB[5].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL6       STCU2.LB[6].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS6        STCU2.LB[6].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL6     STCU2.LB[6].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH6     STCU2.LB[6].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL6     STCU2.LB[6].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH6     STCU2.LB[6].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW6   STCU2.LB[6].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW6   STCU2.LB[6].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW6   STCU2.LB[6].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW6   STCU2.LB[6].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_LB_CTRL7       STCU2.LB[7].CTRL.R            /* STCU2 LBIST Control */
#define STCU2_LB_PCS7        STCU2.LB[7].PCS.R             /* STCU2 LBIST PC Stop Register */
#define STCU2_LB_MISREL7     STCU2.LB[7].MISREL.R          /* STCU2 Off-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREH7     STCU2.LB[7].MISREH.R          /* STCU2 Off-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRL7     STCU2.LB[7].MISRRL.R          /* STCU2 Off-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRH7     STCU2.LB[7].MISRRH.R          /* STCU2 Off-Line LBIST MISR Read High Register */
#define STCU2_LB_MISRELSW7   STCU2.LB[7].MISRELSW.R        /* STCU2 On-Line LBIST MISR Expected Low Register */
#define STCU2_LB_MISREHSW7   STCU2.LB[7].MISREHSW.R        /* STCU2 On-Line LBIST MISR Expected High Register */
#define STCU2_LB_MISRRLSW7   STCU2.LB[7].MISRRLSW.R        /* STCU2 On-Line LBIST MISR Read Low Register */
#define STCU2_LB_MISRRHSW7   STCU2.LB[7].MISRRHSW.R        /* STCU2 On-Line LBIST MISR Read High Register */
#define STCU2_MB_CTRL0       STCU2.MB_CTRL[0].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL1       STCU2.MB_CTRL[1].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL2       STCU2.MB_CTRL[2].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL3       STCU2.MB_CTRL[3].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL4       STCU2.MB_CTRL[4].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL5       STCU2.MB_CTRL[5].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL6       STCU2.MB_CTRL[6].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL7       STCU2.MB_CTRL[7].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL8       STCU2.MB_CTRL[8].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL9       STCU2.MB_CTRL[9].R            /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL10      STCU2.MB_CTRL[10].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL11      STCU2.MB_CTRL[11].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL12      STCU2.MB_CTRL[12].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL13      STCU2.MB_CTRL[13].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL14      STCU2.MB_CTRL[14].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL15      STCU2.MB_CTRL[15].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL16      STCU2.MB_CTRL[16].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL17      STCU2.MB_CTRL[17].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL18      STCU2.MB_CTRL[18].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL19      STCU2.MB_CTRL[19].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL20      STCU2.MB_CTRL[20].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL21      STCU2.MB_CTRL[21].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL22      STCU2.MB_CTRL[22].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL23      STCU2.MB_CTRL[23].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL24      STCU2.MB_CTRL[24].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL25      STCU2.MB_CTRL[25].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL26      STCU2.MB_CTRL[26].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL27      STCU2.MB_CTRL[27].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL28      STCU2.MB_CTRL[28].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL29      STCU2.MB_CTRL[29].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL30      STCU2.MB_CTRL[30].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL31      STCU2.MB_CTRL[31].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL32      STCU2.MB_CTRL[32].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL33      STCU2.MB_CTRL[33].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL34      STCU2.MB_CTRL[34].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL35      STCU2.MB_CTRL[35].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL36      STCU2.MB_CTRL[36].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL37      STCU2.MB_CTRL[37].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL38      STCU2.MB_CTRL[38].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL39      STCU2.MB_CTRL[39].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL40      STCU2.MB_CTRL[40].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL41      STCU2.MB_CTRL[41].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL42      STCU2.MB_CTRL[42].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL43      STCU2.MB_CTRL[43].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL44      STCU2.MB_CTRL[44].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL45      STCU2.MB_CTRL[45].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL46      STCU2.MB_CTRL[46].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL47      STCU2.MB_CTRL[47].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL48      STCU2.MB_CTRL[48].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL49      STCU2.MB_CTRL[49].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL50      STCU2.MB_CTRL[50].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL51      STCU2.MB_CTRL[51].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL52      STCU2.MB_CTRL[52].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL53      STCU2.MB_CTRL[53].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL54      STCU2.MB_CTRL[54].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL55      STCU2.MB_CTRL[55].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL56      STCU2.MB_CTRL[56].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL57      STCU2.MB_CTRL[57].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL58      STCU2.MB_CTRL[58].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL59      STCU2.MB_CTRL[59].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL60      STCU2.MB_CTRL[60].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL61      STCU2.MB_CTRL[61].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL62      STCU2.MB_CTRL[62].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL63      STCU2.MB_CTRL[63].R           /* STCU2 MBIST Control Register */
#define STCU2_MB_CTRL64      STCU2.MB_CTRL[64].R           /* STCU2 MBIST Control Register */

/* STM */
#define STM_1_CR             STM_1.CR.R                    /* STM Control Register */
#define STM_1_CNT            STM_1.CNT.R                   /* STM Count Register */
#define STM_1_CCR0           STM_1.CHANNEL[0].CCR.R        /* STM Channel Control Register */
#define STM_1_CIR0           STM_1.CHANNEL[0].CIR.R        /* STM Channel Interrupt Register */
#define STM_1_CMP0           STM_1.CHANNEL[0].CMP.R        /* STM Channel Compare Register */
#define STM_1_CCR1           STM_1.CHANNEL[1].CCR.R        /* STM Channel Control Register */
#define STM_1_CIR1           STM_1.CHANNEL[1].CIR.R        /* STM Channel Interrupt Register */
#define STM_1_CMP1           STM_1.CHANNEL[1].CMP.R        /* STM Channel Compare Register */
#define STM_1_CCR2           STM_1.CHANNEL[2].CCR.R        /* STM Channel Control Register */
#define STM_1_CIR2           STM_1.CHANNEL[2].CIR.R        /* STM Channel Interrupt Register */
#define STM_1_CMP2           STM_1.CHANNEL[2].CMP.R        /* STM Channel Compare Register */
#define STM_1_CCR3           STM_1.CHANNEL[3].CCR.R        /* STM Channel Control Register */
#define STM_1_CIR3           STM_1.CHANNEL[3].CIR.R        /* STM Channel Interrupt Register */
#define STM_1_CMP3           STM_1.CHANNEL[3].CMP.R        /* STM Channel Compare Register */

#define STM_2_CR             STM_2.CR.R                    /* STM Control Register */
#define STM_2_CNT            STM_2.CNT.R                   /* STM Count Register */
#define STM_2_CCR0           STM_2.CHANNEL[0].CCR.R        /* STM Channel Control Register */
#define STM_2_CIR0           STM_2.CHANNEL[0].CIR.R        /* STM Channel Interrupt Register */
#define STM_2_CMP0           STM_2.CHANNEL[0].CMP.R        /* STM Channel Compare Register */
#define STM_2_CCR1           STM_2.CHANNEL[1].CCR.R        /* STM Channel Control Register */
#define STM_2_CIR1           STM_2.CHANNEL[1].CIR.R        /* STM Channel Interrupt Register */
#define STM_2_CMP1           STM_2.CHANNEL[1].CMP.R        /* STM Channel Compare Register */
#define STM_2_CCR2           STM_2.CHANNEL[2].CCR.R        /* STM Channel Control Register */
#define STM_2_CIR2           STM_2.CHANNEL[2].CIR.R        /* STM Channel Interrupt Register */
#define STM_2_CMP2           STM_2.CHANNEL[2].CMP.R        /* STM Channel Compare Register */
#define STM_2_CCR3           STM_2.CHANNEL[3].CCR.R        /* STM Channel Control Register */
#define STM_2_CIR3           STM_2.CHANNEL[3].CIR.R        /* STM Channel Interrupt Register */
#define STM_2_CMP3           STM_2.CHANNEL[3].CMP.R        /* STM Channel Compare Register */

/* SWT */
#define SWT_1_CR             SWT_1.CR.R                    /* SWT Control Register */
#define SWT_1_IR             SWT_1.IR.R                    /* SWT Interrupt Register */
#define SWT_1_TO             SWT_1.TO.R                    /* SWT Time-out Register */
#define SWT_1_WN             SWT_1.WN.R                    /* SWT Window Register */
#define SWT_1_SR             SWT_1.SR.R                    /* SWT Service Register */
#define SWT_1_CO             SWT_1.CO.R                    /* SWT Counter Output Register */
#define SWT_1_SK             SWT_1.SK.R                    /* SWT Service Key Register */

#define SWT_2_CR             SWT_2.CR.R                    /* SWT Control Register */
#define SWT_2_IR             SWT_2.IR.R                    /* SWT Interrupt Register */
#define SWT_2_TO             SWT_2.TO.R                    /* SWT Time-out Register */
#define SWT_2_WN             SWT_2.WN.R                    /* SWT Window Register */
#define SWT_2_SR             SWT_2.SR.R                    /* SWT Service Register */
#define SWT_2_CO             SWT_2.CO.R                    /* SWT Counter Output Register */
#define SWT_2_SK             SWT_2.SK.R                    /* SWT Service Key Register */

/* TDM */
#define TDM_TDRSR            TDM.TDRSR.R                   /* TDR Status Register */
#define TDM_LFPAR            TDM.LFPAR.R                   /* Last Flash Programmed Address Register */
#define TDM_DBA              TDM.DBA.R                     /* Diary Base Address */
#define TDM_STO_KEY0         TDM.STO_KEY[0].R              /* Software Tamper Override Key Region */
#define TDM_STO_KEY1         TDM.STO_KEY[1].R              /* Software Tamper Override Key Region */
#define TDM_STO_KEY2         TDM.STO_KEY[2].R              /* Software Tamper Override Key Region */
#define TDM_STO_KEY3         TDM.STO_KEY[3].R              /* Software Tamper Override Key Region */

/* WKPU */
#define WKPU_NSR             WKPU.NSR.R                    /* NMI Status Flag Register */
#define WKPU_NCR             WKPU.NCR.R                    /* NMI Configuration Register */

/* XBIC */
#define XBIC_0_MCR           XBIC_0.MCR.R                  /* XBIC Module Control Register */
#define XBIC_0_EIR           XBIC_0.EIR.R                  /* XBIC Error Injection Register */
#define XBIC_0_ESR           XBIC_0.ESR.R                  /* XBIC Error Status Register */
#define XBIC_0_EAR           XBIC_0.EAR.R                  /* XBIC Error Address Register */

#define XBIC_1_MCR           XBIC_1.MCR.R                  /* XBIC Module Control Register */
#define XBIC_1_EIR           XBIC_1.EIR.R                  /* XBIC Error Injection Register */
#define XBIC_1_ESR           XBIC_1.ESR.R                  /* XBIC Error Status Register */
#define XBIC_1_EAR           XBIC_1.EAR.R                  /* XBIC Error Address Register */

#define XBIC_2_MCR           XBIC_2.MCR.R                  /* XBIC Module Control Register */
#define XBIC_2_EIR           XBIC_2.EIR.R                  /* XBIC Error Injection Register */
#define XBIC_2_ESR           XBIC_2.ESR.R                  /* XBIC Error Status Register */
#define XBIC_2_EAR           XBIC_2.EAR.R                  /* XBIC Error Address Register */

#define XBIC_4_MCR           XBIC_4.MCR.R                  /* XBIC Module Control Register */
#define XBIC_4_EIR           XBIC_4.EIR.R                  /* XBIC Error Injection Register */
#define XBIC_4_ESR           XBIC_4.ESR.R                  /* XBIC Error Status Register */
#define XBIC_4_EAR           XBIC_4.EAR.R                  /* XBIC Error Address Register */

#ifdef __MWERKS__
#pragma pop
#endif
#ifdef __ghs__
#pragma ghs endnowarning
#endif
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif
#ifdef  __cplusplus
}
#endif
#endif /* ifdef _S32R372_H */
