/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import java.util.function.Function;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ValidationExampleUtil {
    private static final String PLUGIN_ID = "com.nxp.s32ds.ext.cdt.examples.core";

    private ValidationExampleUtil() {
    }

    public static IProject toProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IPath rename(IPath path, String from, String to) {
        IPath result = path;
        if (path.segments().length >= 2) {
            String lastSegment = path.lastSegment().replace(from, to);
            String pathToProject = String.valueOf(to) + '/' + lastSegment;
            result = new Path(pathToProject);
        } else {
            result = new Path(to);
        }
        return result;
    }

    public static Function<String, String> replaceAllQuoted(String regex, String replacement) {
        return str -> str.replaceAll(regex, Matcher.quoteReplacement(replacement));
    }

    public static IStatus error(String message, Throwable cause) {
        return new Status(4, PLUGIN_ID, message, cause);
    }

    public static IStatus error(String message) {
        return new Status(4, PLUGIN_ID, message);
    }
}

