/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.util.stream.Stream;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.internal.ui.view.EmbSysRegUi;
import org.eclipse.cdt.embsysregview.internal.ui.view.EmbSysRegViewer;
import org.eclipse.cdt.embsysregview.internal.utils.GUIUtils;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.embsysregview.properties.IProjectPropertyChangeListener;
import org.eclipse.cdt.embsysregview.properties.ProjectProperties;
import org.eclipse.cdt.embsysregview.properties.PropertiesDialog;
import org.eclipse.cdt.embsysregview.properties.PropertyPageEmbSys;
import org.eclipse.cdt.embsysregview.properties.SettingsUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.ViewPart;

public class EmbSysRegView
extends ViewPart
implements DsfSession.SessionEndedListener {
    public static final String ID = "org.eclipse.cdt.embsysregview.views.EmbSysRegView";
    protected EmbSysRegViewer m_viewer;
    private IProject selectedProject;
    private Object previousSelection;
    private IDebugContextListener fDebugContextListener;
    private ISelectionListener projectSelectionListener = (part, selection) -> {
        if (part.getClass() != ((Object)((Object)this)).getClass() && selection instanceof IStructuredSelection) {
            this.handleWorkbenchSelection((IStructuredSelection)selection);
        }
    };
    private IProjectPropertyChangeListener projectPropertiesChangeListener = event -> {
        if (event.getProperties() == null) {
            return;
        }
        IProject nowProject = event.getProject();
        if (this.selectedProject == nowProject) {
            this.selectedProject = null;
            this.setSelectedProject(nowProject);
        }
    };
    private IPropertyChangeListener preferencesChangeListener = event -> {
        if (this.selectedProject != null) {
            this.m_viewer.updateView(this.selectedProject);
        }
    };
    private PerspectiveAdapter perspectiveChangeListener = new PerspectiveAdapter(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
            super.perspectiveActivated(page, perspectiveDescriptor);
            EmbSysRegView.this.detectCurrentSelectionInWorkbench();
        }
    };
    private Composite m_parentControl;
    private boolean m_initialized;
    private Action fFilterAction;
    private Action fProjectProperiesPanelAction;

    public void createPartControl(Composite parent) {
        this.m_parentControl = parent;
        ProjectProperties.getInstance().addPropertyChangeListener(this.projectPropertiesChangeListener);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesChangeListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.perspectiveChangeListener);
        this.initializeSelectionHandling();
        this.initializeViewer();
        IActionBars bars = this.getViewSite().getActionBars();
        this.fFilterAction = new Action(){

            public void run() {
            }
        };
        this.fFilterAction.setText(Messages.EmbSysRegView_3);
        this.fFilterAction.setToolTipText(Messages.EmbSysRegView_4);
        this.fFilterAction.setImageDescriptor(EmbSysRegUi.getToolbarImage());
        this.fFilterAction.setChecked(false);
        this.fProjectProperiesPanelAction = new Action(){

            public void run() {
                if (EmbSysRegView.this.selectedProject != null) {
                    EmbSysRegView.PropertiesPanelOn(EmbSysRegView.this.selectedProject);
                }
            }
        };
        this.fProjectProperiesPanelAction.setText(Messages.EmbSysRegView_5);
        this.fProjectProperiesPanelAction.setToolTipText(Messages.EmbSysRegView_6);
        this.fProjectProperiesPanelAction.setImageDescriptor(EmbSysRegUi.getButtonImage());
        bars.getToolBarManager().add((IAction)this.fFilterAction);
        bars.getToolBarManager().add((IAction)this.fProjectProperiesPanelAction);
        bars.updateActionBars();
        this.setupContextListener();
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
        this.m_initialized = true;
    }

    private void setupContextListener() {
        IDebugContextManager contextManager = DebugUITools.getDebugContextManager();
        IDebugContextService contextService = contextManager.getContextService(this.getSite().getWorkbenchWindow());
        this.fDebugContextListener = new IDebugContextListener(){

            public void debugContextChanged(DebugContextEvent event) {
                if ((event.getFlags() & 1) != 0) {
                    ISelection s = event.getContext();
                    EmbSysRegView.this.setDebugContext(s);
                }
            }
        };
        contextService.addDebugContextListener(this.fDebugContextListener);
        this.setDebugContext(contextService.getActiveContext());
    }

    private void setDebugContext(ISelection activeContext) {
        if (activeContext instanceof IStructuredSelection && !activeContext.isEmpty()) {
            this.handleWorkbenchSelection((IStructuredSelection)activeContext);
        } else {
            this.scanByPartsSelection();
        }
    }

    protected EmbSysRegViewer createViewer(Composite parent) {
        return this.m_viewer != null ? this.m_viewer : new EmbSysRegViewer(this, parent, RegSet.byId(this.getSite().getId()));
    }

    protected void initializeViewer() {
        this.setViewer(this.createViewer(this.m_parentControl));
    }

    protected void setViewer(EmbSysRegViewer viewer) {
        this.m_viewer = viewer;
        if (this.m_viewer != null) {
            this.getSite().setSelectionProvider(this.m_viewer.getViewer());
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    private static void PropertiesPanelOn(IProject project) {
        PropertyPageEmbSys page = new PropertyPageEmbSys(project);
        page.setTitle("EmbSysRegisterView");
        PreferenceManager mgr = new PreferenceManager();
        mgr.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)page));
        Shell shell = GUIUtils.getShell();
        String title = "Properties for " + project.getName();
        new PropertiesDialog(title, shell, mgr, (IPreferencePage)page){
            {
                this.create();
                this.setMessage(iPreferencePage.getTitle());
                this.open();
            }
        };
    }

    private void initializeSelectionHandling() {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.projectSelectionListener);
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener(this.projectSelectionListener);
        ProjectProperties.getInstance().removePropertyChangeListener(this.projectPropertiesChangeListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesChangeListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.perspectiveChangeListener);
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public void setFocus() {
        if (this.m_viewer != null) {
            this.m_viewer.setFocus();
        }
    }

    protected synchronized void updateView() {
        if (this.m_viewer != null) {
            this.m_viewer.updateView(this.selectedProject);
        }
    }

    private IProject getIProject(Object obj) {
        ILaunch launch;
        if (obj instanceof IProject) {
            return (IProject)obj;
        }
        if (obj instanceof PlatformObject) {
            ICProject cProject;
            PlatformObject platformObject = (PlatformObject)obj;
            ICElement element = (ICElement)platformObject.getAdapter(ICElement.class);
            if (element != null && (cProject = element.getCProject()) != null) {
                return cProject.getProject();
            }
            IResource resource = (IResource)platformObject.getAdapter(IResource.class);
            if (resource != null) {
                return resource.getProject();
            }
        }
        if ((launch = this.getILaunch(obj)) != null) {
            return EmbSysRegView.getProjectFromLaunch(launch);
        }
        return this.selectedProject;
    }

    protected static IProject getProjectFromLaunch(ILaunch launch) {
        try {
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            return launchConfiguration != null ? Utils.getProjectByName(launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null)) : null;
        }
        catch (CoreException e) {
            Activator.log(2, e.getMessage(), e);
            return null;
        }
    }

    protected IStatus setSelectedProject(IProject project) {
        this.fProjectProperiesPanelAction.setEnabled(project == null || SettingsUtils.checkProject(project).isOK());
        GUIUtils.exec(() -> {
            IStatus iStatus = this.m_viewer.saveState(this.selectedProject);
        });
        if (project != this.selectedProject && project != null) {
            this.selectedProject = project;
            GUIUtils.exec(this::updateView);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static ISelection getSelectionFromService() {
        ISelectionService service;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (service = activeWindow.getSelectionService()) != null) {
            ISelection selection = service.getSelection("org.eclipse.debug.ui.DebugView");
            if (selection == null) {
                selection = service.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
            }
            return selection;
        }
        return null;
    }

    private boolean handleWorkbenchSelection(IStructuredSelection selection) {
        boolean result = false;
        if (!selection.isEmpty()) {
            Object obj = selection.toArray()[0];
            if (obj != null && obj.equals(this.previousSelection)) {
                return true;
            }
            IProject project = this.getIProject(obj);
            if (project == null || !project.isAccessible()) {
                this.cleanViewOnInvalidProjectSelection();
                return false;
            }
            result = this.setSelectedProject(project).isOK();
            ILaunch launch = this.getILaunch(obj);
            if (launch != null) {
                this.previousSelection = obj;
            } else {
                launch = this.getILaunch(this.previousSelection);
            }
            this.setTrackingSession(launch);
            this.setViewerReadonly(launch);
        } else if (this.selectedProject == null || !this.selectedProject.isAccessible()) {
            this.cleanViewOnInvalidProjectSelection();
        }
        return result;
    }

    private void cleanViewOnInvalidProjectSelection() {
        this.selectedProject = null;
        this.fProjectProperiesPanelAction.setEnabled(false);
        GUIUtils.exec(this::updateView);
    }

    private void setTrackingSession(ILaunch launch) {
        if (launch instanceof GdbLaunch) {
            this.m_viewer.setTrackingSession(((GdbLaunch)launch).getSession());
        }
    }

    private ILaunch getILaunch(Object obj) {
        if (obj instanceof IAdaptable) {
            return (ILaunch)((IAdaptable)obj).getAdapter(ILaunch.class);
        }
        return null;
    }

    private void detectCurrentSelectionInWorkbench() {
        ISelection selection = EmbSysRegView.getSelectionFromService();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.handleWorkbenchSelection((IStructuredSelection)selection);
        } else {
            this.scanByPartsSelection();
        }
    }

    private void scanByPartsSelection() {
        IWorkbenchPage activePage = GUIUtils.getActivePage();
        if (activePage != null) {
            IViewReference[] iViewReferenceArray = activePage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStructuredSelection structuredSelection;
                AbstractDebugView viewPart;
                Viewer viewer;
                IViewReference viewRef = iViewReferenceArray[n2];
                IViewPart view = viewRef.getView(false);
                ISelection selection = null;
                if (view instanceof AbstractDebugView && (viewer = (viewPart = (AbstractDebugView)view).getViewer()) instanceof TreeViewer) {
                    selection = viewer.getSelection();
                }
                if (view instanceof ProjectExplorer) {
                    viewPart = (ProjectExplorer)view;
                    viewer = viewPart.getCommonViewer();
                    selection = viewer.getSelection();
                }
                if (selection instanceof IStructuredSelection ? this.handleWorkbenchSelection(structuredSelection = (IStructuredSelection)selection) : this.scanByEditor(activePage)) break;
                ++n2;
            }
        }
    }

    private boolean scanByEditor(IWorkbenchPage activePage) {
        IResource resource;
        IEditorPart editorPart = activePage.getActiveEditor();
        if (editorPart != null && (resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class)) != null) {
            this.setSelectedProject(resource.getProject());
            return true;
        }
        return false;
    }

    private void setViewerReadonly(ILaunch launch) {
        if (launch == null || launch.isTerminated()) {
            this.previousSelection = null;
            this.setSelectedProject(null);
        }
        boolean terminated = true;
        IDMContext cntx = null;
        if (launch != null) {
            terminated = launch.isTerminated();
            IAdaptable context = DebugUITools.getDebugContext();
            if (context != null) {
                cntx = (IDMContext)context.getAdapter(IDMContext.class);
            }
        }
        boolean fterminated = terminated;
        IDMContext con = cntx;
        GUIUtils.exec(() -> this.m_viewer.setReadOnly(con == null, fterminated));
    }

    public void sessionEnded(DsfSession session) {
        String id = session.getId();
        if (id.equals(this.m_viewer.getEngine().getSessionTrackId())) {
            GUIUtils.exec(() -> this.m_viewer.setReadOnly(true, true));
        }
    }

    public static enum RegSet {
        ALL(true, true, "org.eclipse.cdt.embsysregview.views.AllEmbSysRegView"),
        EMBSYS(true, false, "org.eclipse.cdt.embsysregview.views.EmbSysRegView"),
        SPR(false, true, "org.eclipse.cdt.embsysregview.views.SprEmbSysRegView");

        public final boolean embsys;
        public final boolean spr;
        public final String id;

        private RegSet(boolean embsys, boolean spr, String id) {
            this.embsys = embsys;
            this.spr = spr;
            this.id = id;
        }

        public static RegSet byId(String id) {
            return Stream.of(RegSet.values()).filter(set -> set.id.equals(id)).findAny().orElseThrow(UnsupportedOperationException::new);
        }

        public boolean isSPR() {
            return this.spr;
        }
    }
}

