/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.properties;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.properties.PropertiesHolder;
import org.eclipse.cdt.embsysregview.properties.Property;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;

public class SettingsUtils {
    private static final Set<Property> EMPTY_PROPERTY_SET = new HashSet<Property>();
    public static final String STORAGE = "org.eclipse.embsys";
    public static final String EMPTY = "";

    private SettingsUtils() {
    }

    public static void setPropertyValueFromUI(IProject project, QualifiedName qualifiedName, Combo propertyCombo) {
        try {
            String oldValue = project.getPersistentProperty(qualifiedName);
            String newValue = propertyCombo.getText();
            if (oldValue == null && newValue != null || !EMPTY.equals(newValue) && !oldValue.equals(newValue)) {
                PropertiesHolder.getInstance(project).setPropertyValue(project, qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            Activator.log(0, e.getMessage(), e);
        }
    }

    public static Set<Property> initializePropertyValues(IProject project) {
        if (!SettingsUtils.checkProject(project).isOK()) {
            return EMPTY_PROPERTY_SET;
        }
        PropertiesHolder projectProperties = PropertiesHolder.getInstance(project);
        Set<Property> propertySet = projectProperties.getPropertySet();
        if (propertySet.stream().allMatch(p -> projectProperties.scheduleSetFromCProjectJob(project, (Property)p).isOK())) {
            projectProperties.saveProjectSettings(project);
        } else {
            propertySet = SettingsUtils.collectXMLPropertiesFromWorkspace(project);
        }
        return propertySet;
    }

    public static Set<Property> collectXMLPropertiesFromPrefs() {
        Set<Property> propertySet = PropertiesHolder.getInstance(null).getPropertySet();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Property property : propertySet) {
            String name = property.getName();
            String value = store.getString(name);
            property.setValue(value);
        }
        return propertySet;
    }

    public static IStatus checkProject(IProject project) {
        if (project != null) {
            try {
                if (project.isOpen() && project.isNatureEnabled("org.eclipse.cdt.core.cnature")) {
                    return Status.OK_STATUS;
                }
            }
            catch (CoreException e) {
                Activator.log(0, e.getMessage(), e);
                return e.getStatus();
            }
        }
        return new Status(1, "org.eclipse.cdt.embsysregview", "Project in not good for any use");
    }

    public static IStatus storePropertyInCProject(IProject project, String settingQualifier, String value, IProgressMonitor monitor) {
        IStatus status = SettingsUtils.checkProject(project);
        if (!status.isOK()) {
            return status;
        }
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        if (projectDescription == null) {
            return Status.CANCEL_STATUS;
        }
        ICSettingEntry[] entries = SettingsUtils.clearPreviousSettings(projectDescription, settingQualifier, value);
        if (entries == null) {
            CMacroEntry settingEntry = CDataUtil.createCMacroEntry((String)settingQualifier, (String)value, (int)0);
            entries = new ICSettingEntry[]{settingEntry};
        }
        try {
            ICStorageElement embsysStorage = projectDescription.getStorage(STORAGE, true);
            ICSettingEntry[] iCSettingEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICSettingEntry entry = iCSettingEntryArray[n2];
                embsysStorage.setAttribute(entry.getName(), entry.getValue());
                ++n2;
            }
            CoreModel.getDefault().setProjectDescription(project, projectDescription, false, monitor);
        }
        catch (CoreException e) {
            Activator.log(0, e.getMessage(), e);
        }
        Activator.log(1, NLS.bind((String)Messages.property_was_saved_in_cproject, (Object)settingQualifier));
        return Status.OK_STATUS;
    }

    public static IStatus setPropertyValueFromCProject(IProject project, Property property) {
        IStatus status = SettingsUtils.checkProject(project);
        if (!status.isOK()) {
            return status;
        }
        String qualifier = property.getQualifier();
        String message = NLS.bind((String)Messages.setting_was_not_found_no_project, (Object)qualifier);
        status = new Status(2, "org.eclipse.cdt.embsysregview", message);
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        if (projectDescription == null) {
            String projectName = project.getName();
            message = NLS.bind((String)Messages.setting_was_not_found_in_cproject_file, (Object)qualifier, (Object)projectName);
            return new Status(2, "org.eclipse.cdt.embsysregview", message);
        }
        try {
            ICConfigurationDescription[] configurations;
            status = SettingsUtils.handleProjectSetting(project, property);
            if (status.isOK()) {
                return status;
            }
            ICConfigurationDescription configuration = projectDescription.getActiveConfiguration();
            status = SettingsUtils.handleExternalSetting(project, configuration, property);
            if (status.isOK()) {
                return status;
            }
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription des = iCConfigurationDescriptionArray[n2];
                status = SettingsUtils.handleExternalSetting(project, des, property);
                if (status.isOK()) {
                    return status;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            message = NLS.bind((String)Messages.SettingsUtils_exception, (Object)e.getMessage());
            Activator.log(0, e.getMessage(), e);
            return new Status(2, "org.eclipse.cdt.embsysregview", message);
        }
        return status;
    }

    private static ICSettingEntry[] clearPreviousSettings(ICProjectDescription projectDescription, String settingQualifier, String value) {
        ICSettingEntry[] entries = null;
        ICConfigurationDescription configuration = projectDescription.getActiveConfiguration();
        entries = SettingsUtils.handleExternalSettings(configuration, settingQualifier, value);
        if (entries == null) {
            ICConfigurationDescription[] configurations;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription des = iCConfigurationDescriptionArray[n2];
                entries = SettingsUtils.handleExternalSettings(des, settingQualifier, value);
                ++n2;
            }
        }
        return entries;
    }

    private static ICSettingEntry[] handleExternalSettings(ICConfigurationDescription configuration, String settingQualifier, String value) {
        ICExternalSetting[] externalSettings;
        if (value == null || value.isEmpty()) {
            return null;
        }
        ICExternalSetting[] iCExternalSettingArray = externalSettings = configuration.getExternalSettings();
        int n = externalSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ICSettingEntry[] entries;
            ICExternalSetting setting = iCExternalSettingArray[n2];
            ICSettingEntry[] iCSettingEntryArray = entries = setting.getEntries();
            int n3 = entries.length;
            int n4 = 0;
            while (n4 < n3) {
                ICSettingEntry entry = iCSettingEntryArray[n4];
                if (settingQualifier.equals(entry.getName())) {
                    String oldValue = entry.getValue();
                    if (value.equals(oldValue)) {
                        return entries;
                    }
                    configuration.removeExternalSetting(setting);
                    return SettingsUtils.updateEntry(setting, settingQualifier, value);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static ICSettingEntry[] updateEntry(ICExternalSetting setting, String settingQualifier, String value) {
        ICSettingEntry[] entries = setting.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (settingQualifier.equals(entries[i].getName())) {
                entries[i] = CDataUtil.createCMacroEntry((String)settingQualifier, (String)value, (int)0);
            }
            ++i;
        }
        return entries;
    }

    private static IStatus handleProjectSetting(IProject project, Property property) throws CoreException {
        String attr;
        String name = project.getName();
        String qualifier = property.getQualifier();
        ICProjectDescription cd = CoreModel.getDefault().getProjectDescription(project);
        ICStorageElement elem = cd.getStorage(STORAGE, false);
        if (elem != null && (attr = elem.getAttribute(qualifier)) != null) {
            property.setValue(attr);
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)Messages.setting_was_not_found_in_cproject_file, (Object)qualifier, (Object)name);
        return new Status(2, "org.eclipse.cdt.embsysregview", message);
    }

    private static IStatus handleExternalSetting(IProject project, ICConfigurationDescription configuration, Property property) {
        String qualifier = property.getQualifier();
        ICExternalSetting[] iCExternalSettingArray = configuration.getExternalSettings();
        int n = iCExternalSettingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICExternalSetting setting = iCExternalSettingArray[n2];
            Optional<ICSettingEntry> entry = Stream.of(setting.getEntries()).filter(e -> qualifier.equals(e.getName())).findAny();
            if (entry.isPresent()) {
                property.setValue(entry.get().getValue());
                return Status.OK_STATUS;
            }
            ++n2;
        }
        if (property.isMandatory()) {
            return new Status(2, "org.eclipse.cdt.embsysregview", NLS.bind((String)Messages.setting_was_not_found_in_cproject_file, (Object)qualifier, (Object)project.getName()));
        }
        return Status.OK_STATUS;
    }

    private static Set<Property> collectXMLPropertiesFromWorkspace(IProject project) {
        PropertiesHolder propertiesHolder = PropertiesHolder.getInstance(project);
        Set<Property> propertySet = propertiesHolder.getPropertySet();
        try {
            for (Property property : propertySet) {
                QualifiedName qualifiedName = property.getQualifiedName();
                String value = project.getPersistentProperty(qualifiedName);
                if (value == null || value.isEmpty()) {
                    return propertySet;
                }
                property.setValue(value);
                propertiesHolder.scheduleUpdateCProjectJob(project, qualifiedName, value);
            }
        }
        catch (CoreException e) {
            Activator.log(0, e.getMessage(), e);
        }
        return propertySet;
    }
}

