/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.Activator;

public class DSFSessionState {
    protected final String m_sessionId;
    protected final List<Object> m_sessionListeners;
    protected final DsfServicesTracker m_servicesTracker;

    public DSFSessionState(DsfSession session) {
        this.m_sessionId = session.getId();
        this.m_sessionListeners = new ArrayList<Object>();
        this.m_servicesTracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), this.m_sessionId);
    }

    public void dispose() {
        if (this.m_sessionId != null) {
            this.removeAllServiceEventListeners();
        }
        if (this.m_servicesTracker != null) {
            this.m_servicesTracker.dispose();
        }
    }

    public String getSessionID() {
        return this.m_sessionId;
    }

    public void addServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session_f.addServiceEventListener(listener_f, null);
                        DSFSessionState.this.m_sessionListeners.add(listener_f);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Activator.log(0, e.getMessage(), e);
            }
        }
    }

    public void removeServiceEventListener(Object listener) {
        final Object listener_f = listener;
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionState.this.m_sessionListeners != null) {
                            session_f.removeServiceEventListener(listener_f);
                            DSFSessionState.this.m_sessionListeners.remove(listener_f);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Activator.log(0, e.getMessage(), e);
            }
        }
    }

    public void removeAllServiceEventListeners() {
        final DsfSession session_f = this.getDsfSession();
        if (session_f != null) {
            try {
                session_f.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (DSFSessionState.this.m_sessionListeners != null) {
                            for (Object listener : DSFSessionState.this.m_sessionListeners) {
                                session_f.removeServiceEventListener(listener);
                            }
                            DSFSessionState.this.m_sessionListeners.clear();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Activator.log(0, e.getMessage(), e);
            }
        }
    }

    protected DsfSession getDsfSession() {
        return DsfSession.getSession((String)this.m_sessionId);
    }

    public void execute(DsfRunnable runnable) {
        try {
            DsfSession session = this.getDsfSession();
            if (session == null) {
                Activator.log(0, "session is already null");
            } else {
                session.getExecutor().execute((Runnable)runnable);
            }
        }
        catch (RejectedExecutionException e) {
            Activator.log(0, e.getMessage(), e);
        }
    }

    @ConfinedToDsfExecutor(value="getDsfSession().getExecutor()")
    public <V> V getService(Class<V> serviceClass) {
        return (V)(this.m_servicesTracker == null ? null : this.m_servicesTracker.getService(serviceClass));
    }
}

