/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.utils;

import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.MIRegisters;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.internal.model.TreeRange;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.DSFDebugModelListener;
import org.eclipse.cdt.embsysregview.internal.utils.DSFSessionState;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;

public class DSFAccessor {
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void getEmbSysRegisterData(IDMContext context, DSFSessionState sessionState, TreeRegister register, DSFDebugModelListener listener, Object arg) {
        assert (register != null);
        if (register.isSPR()) {
            DSFAccessor.readSprRegister(context, sessionState, register, listener, arg);
        } else {
            DSFAccessor.readMemoryRegister(context, sessionState, register, listener, arg);
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void readSprRegister(IDMContext dmc, final DSFSessionState sessionState, final TreeRegister register, final DSFDebugModelListener listener, final Object arg) {
        IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        IMIExecutionDMContext[] exec = sessionState.getService(IGDBProcesses.class).getExecutionContexts(containerDmc);
        if (exec.length > 0) {
            DsfSession session = sessionState.getDsfSession();
            sessionState.getService(IStack.class).getTopFrame((IDMContext)exec[0], (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)session.getExecutor(), null){

                protected void handleSuccess() {
                    MIRegisters registers = (MIRegisters)sessionState.getService(IRegisters.class);
                    MIRegisters.MIRegisterDMC registerDmc = new MIRegisters.MIRegisterDMC(registers, null, (IStack.IFrameDMContext)this.getData(), (int)register.getRegisterAddress(), register.getName());
                    IFormattedValues.FormattedValueDMContext formattedDmc = registers.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)registerDmc, "NATURAL.Format");
                    registers.getFormattedExpressionValue(formattedDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)registers.getExecutor(), null){

                        protected void handleCompleted() {
                            if (this.getStatus().isOK()) {
                                register.setValue(Long.parseLong(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()));
                            }
                            listener.getEmbSysRegisterDataDone(this.getStatus(), register, arg);
                        }
                    });
                }

                protected void handleFailure() {
                    listener.getEmbSysRegisterDataDone(this.getStatus(), register, arg);
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void readMemoryRegister(IDMContext cont, DSFSessionState sessionState, final TreeRegister register, final DSFDebugModelListener listener, final Object arg) {
        IMemory.IMemoryDMContext context = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)cont, IMemory.IMemoryDMContext.class);
        IMemory fMemReg = sessionState.getService(IMemory.class);
        Status status = new Status(4, "org.eclipse.cdt.embsysregview", "Service down");
        if (fMemReg == null) {
            listener.getEmbSysRegisterDataDone((IStatus)status, register, arg);
            return;
        }
        Addr64 address1 = new Addr64(register.getRegisterAddrString());
        fMemReg.getMemory(context, (IAddress)address1, 0L, 1, register.getByteSize(), (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)fMemReg.getExecutor(), null){

            protected void handleSuccess() {
                MemoryByte[] bytes = (MemoryByte[])this.getData();
                long[] ret = new long[]{-1L};
                if (Utils.convertToUnsigned(bytes, 0, register.getByteSize(), ret)) {
                    register.setValue(ret[0]);
                    listener.getEmbSysRegisterDataDone(this.getStatus(), register, arg);
                } else {
                    Status statusRm = new Status(4, "org.eclipse.cdt.embsysregview", "Unable to convert");
                    listener.getEmbSysRegisterDataDone((IStatus)statusRm, register, arg);
                }
            }

            protected void handleFailure() {
                Status statusRm = new Status(0, "org.eclipse.cdt.embsysregview", "Read register fail");
                listener.getEmbSysRegisterDataDone((IStatus)statusRm, register, arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public static void writeEmbSysRegisterData(IDMContext context, DSFSessionState sessionState, TreeRegister register, DSFDebugModelListener listener, Object arg) {
        if (register.isSPR()) {
            DSFAccessor.writeSprRegisterData(sessionState, register, listener, arg);
        } else {
            DSFAccessor.writeMemoryRegisterData(context, sessionState, register, listener, arg);
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void writeSprRegisterData(DSFSessionState sessionState, final TreeRegister register, final DSFDebugModelListener listener, final Object arg) {
        IDMContext dmc = (IDMContext)DebugUITools.getDebugContext().getAdapter(IDMContext.class);
        final MIRegisters regService = (MIRegisters)sessionState.getService(IRegisters.class);
        DsfSession session = sessionState.getDsfSession();
        regService.getRegisterGroups(dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)session.getExecutor(), null){

            protected void handleSuccess() {
                MIRegisters.MIRegisterGroupDMC groupCtx = (MIRegisters.MIRegisterGroupDMC)((IRegisters.IRegisterGroupDMContext[])this.getData())[0];
                MIRegisters.MIRegisterDMC registerDmc = new MIRegisters.MIRegisterDMC(regService, groupCtx, (int)register.getRegisterAddress(), register.getName());
                regService.writeRegister((IRegisters.IRegisterDMContext)registerDmc, Integer.toString((int)register.getValue()), "NATURAL.Format", (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)regService.getExecutor(), null){

                    protected void handleSuccess() {
                        listener.writeEmbSysRegisterDataDone(this.getStatus(), register, arg);
                    }
                });
            }

            protected void handleFailure() {
                Status status = new Status(4, "org.eclipse.cdt.embsysregview", "Write SPR register fail");
                listener.writeEmbSysRegisterDataDone((IStatus)status, register, arg);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void writeMemoryRegisterData(IDMContext cont, DSFSessionState sessionState, TreeRegister register, DSFDebugModelListener listener, Object arg) {
        final IMemory.IMemoryDMContext context = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)cont, IMemory.IMemoryDMContext.class);
        final IGDBMemory fMemReg = sessionState.getService(IGDBMemory.class);
        Addr64 address = new Addr64(register.getRegisterAddrString());
        boolean isBigEndian = fMemReg.isBigEndian(context);
        fMemReg.setMemory(context, (IAddress)address, 0L, 1, register.getByteSize(), register.getByteBuffer(isBigEndian), new RequestMonitor((Executor)fMemReg.getExecutor(), null, (IAddress)address, register, listener, arg){
            private final /* synthetic */ IAddress val$address;
            private final /* synthetic */ TreeRegister val$register;
            private final /* synthetic */ DSFDebugModelListener val$listener;
            private final /* synthetic */ Object val$arg;
            {
                this.val$address = iAddress;
                this.val$register = treeRegister;
                this.val$listener = dSFDebugModelListener;
                this.val$arg = object;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                fMemReg.getMemory(context, this.val$address, 0L, 1, this.val$register.getByteSize(), (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)fMemReg.getExecutor(), null){

                    protected void handleCompleted() {
                        MemoryByte[] bytes = (MemoryByte[])this.getData();
                        long[] ret = new long[]{-1L};
                        if (Utils.convertToUnsigned(bytes, 0, val$register.getByteSize(), ret)) {
                            val$register.setValue(ret[0]);
                            val$listener.writeEmbSysRegisterDataDone(this.getStatus(), val$register, val$arg);
                        } else {
                            Status status = val$register.isWriteOnly() ? new Status(1, "org.eclipse.cdt.embsysregview", "Cannot read back") : new Status(4, "org.eclipse.cdt.embsysregview", "Unable to convert");
                            val$listener.writeEmbSysRegisterDataDone((IStatus)status, val$register, val$arg);
                        }
                    }
                });
            }

            protected void handleFailure() {
                Status status = new Status(4, "org.eclipse.cdt.embsysregview", "Write memory-mapped register fail");
                this.val$listener.writeEmbSysRegisterDataDone((IStatus)status, this.val$register, this.val$arg);
            }
        });
    }

    public static void getEmbSysDeviceData(IDMContext cont, DSFSessionState sessionState, final TreeRange range, final DSFDebugModelListener listener, final Object arg) {
        IMemory.IMemoryDMContext context = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)cont, IMemory.IMemoryDMContext.class);
        IMemory fMemReg = sessionState.getService(IMemory.class);
        Addr64 address1 = new Addr64(range.getRangeLowAddrString());
        fMemReg.getMemory(context, (IAddress)address1, 0L, 1, range.getRangeByteCount(), (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)fMemReg.getExecutor(), null){

            protected void handleSuccess() {
                MemoryByte[] bytes = (MemoryByte[])this.getData();
                listener.readEmbSysRangeDataDone(this.getStatus(), range, bytes, arg);
            }

            protected void handleFailure() {
                Status status = new Status(0, "org.eclipse.cdt.embsysregview", "Read memory fail");
                listener.readEmbSysRangeDataDone((IStatus)status, range, null, arg);
            }
        });
    }
}

