/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRange;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.utils.Utils;

public class TreeRegisterGroup
extends TreeParent {
    TreeRange currentRange;
    private boolean isExpanded;
    private boolean isChecked;
    private final List<TreeRegister> regsList = new ArrayList<TreeRegister>();

    public TreeRegisterGroup(String name, String description) {
        super(name, description);
        this.currentRange = new TreeRange(String.valueOf(name) + "Range0", "");
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    @Override
    public void addChild(TreeElement child) {
        this.regsList.add((TreeRegister)child);
    }

    public final void extractRanges() {
        Collections.sort(this.regsList, (a, b) -> {
            int addrComp = Utils.compare(a, b, TreeRegister::getRegisterAddress);
            if (addrComp != 0) {
                return addrComp;
            }
            return Utils.compare(a, b, TreeRegister::getByteSize);
        });
        for (TreeRegister reg : this.regsList) {
            if (this.currentRange.hasChildren()) {
                long lastKnown = this.currentRange.getLastAddress();
                if (reg.getRegisterAddress() - lastKnown > 0L) {
                    this.closeRange();
                    this.currentRange = new TreeRange(Long.toHexString(lastKnown), "");
                }
            }
            this.currentRange.addModelChild(reg);
            super.addChild(reg);
        }
        this.closeRange();
    }

    private void closeRange() {
        this.currentRange.setParent(this);
        super.addModelChild(this.currentRange);
    }

    public final void toggleChecked() {
        this.isChecked = !this.isChecked;
    }

    public final boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }
}

