/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.model;

import org.eclipse.cdt.embsysregview.internal.model.IEditable;
import org.eclipse.cdt.embsysregview.internal.model.Interpretations;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;

public class TreeField
extends TreeElement
implements IEditable {
    private final byte bitOffset;
    private final byte bitLength;
    private boolean isLabelSwap;
    private Interpretations interpretations;
    private final String access;

    public TreeField(String name, String description, byte bitOffset, byte bitLength, Interpretations interpretations, String access, boolean isLabelSwap) {
        super(name, description);
        this.bitOffset = bitOffset;
        this.bitLength = bitLength;
        this.isLabelSwap = isLabelSwap;
        this.interpretations = interpretations;
        this.interpretations.setTreeField(this);
        this.access = access;
    }

    public boolean hasValueChanged() {
        TreeRegister reg = (TreeRegister)this.getParent();
        if (reg != null && reg.hasValueChanged()) {
            return this.getOldValue() != this.getValue();
        }
        return false;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public byte getBitLength() {
        return this.bitLength;
    }

    public Interpretations getInterpretations() {
        return this.interpretations;
    }

    public long getValue() {
        return this.stripValue(((TreeRegister)this.getParent()).getValue());
    }

    private long stripValue(long value) {
        long tmp = value >> this.bitOffset;
        return tmp &= 0xFFFFFFFFL << this.bitLength ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private long getOldValue() {
        return this.stripValue(((TreeRegister)this.getParent()).getOldValue());
    }

    public String getInterpretation() {
        return this.interpretations.getInterpretation(this.getValue());
    }

    public boolean hasInterpretation() {
        return !this.getInterpretation().equals("");
    }

    public boolean hasInterpretations() {
        return this.interpretations.hasInterpretations();
    }

    public String getLabelString() {
        String format = String.format("%%%ds", this.getBitLength());
        return String.format(format, "").replace(' ', 'x');
    }

    public String getFieldLabel() {
        if (this.bitLength == 1) {
            return String.format("%s (bit %d)", this.getName(), this.bitOffset);
        }
        if (!this.isLabelSwap) {
            return String.format("%s (bits %d-%d)", this.getName(), this.bitOffset + this.bitLength - 1, this.bitOffset);
        }
        return String.format("%s (bits %d-%d)", this.getName(), this.bitOffset, this.bitOffset + this.bitLength - 1);
    }

    public final String getAccess() {
        return this.access;
    }

    public boolean isWriteOnly() {
        return "WO".equals(this.getAccess());
    }

    public long getBitMask() {
        long mask = 0xFFFFFFFFL >> 32 - this.getBitLength() << this.getBitOffset();
        return mask;
    }

    @Override
    public boolean isEditAllowed() {
        if (((TreeRegister)this.getParent()).isEditAllowed()) {
            return !"RO".equals(this.getAccess());
        }
        return false;
    }

    public long getMaxAllowedValue() {
        return (long)Math.pow(2.0, this.getBitLength()) - 1L;
    }
}

