/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptgen.internal.ui.handlers;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.gte.gas.GasPlugin;
import com.nxp.s32ds.gte.sptgen.internal.ui.handlers.Messages;
import com.nxp.s32ds.gte.sptgen.internal.ui.handlers.SptGenerateOperation;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import com.nxp.s32ds.vgt.ide.ui.dialogs.ValidationDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SptGenerateHandler
extends AbstractHandler {
    public static final String PLUGIN_ID = "com.nxp.s32ds.gte.sptgen.ui";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        ResourceSet resourceSet;
        IStatus status;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart == null || !(activePart instanceof DiagramEditor)) {
            ErrorDialog errorDialog = new ErrorDialog(shell, Messages.SptGenerateHandler_generation_error, Messages.SptGenerateHandler_should_open_diagram_title, (IStatus)new Status(4, PLUGIN_ID, Messages.SptGenerateHandler_should_open_diagram), 4);
            errorDialog.open();
            return null;
        }
        DiagramEditor diagramEditor = (DiagramEditor)activePart;
        if (diagramEditor.isDirty()) {
            diagramEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (!(status = BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate((EObject)GasPlugin.findProgramObject((ResourceSet)(resourceSet = (editingDomain = diagramEditor.getEditingDomain()).getResourceSet()))))).isOK()) {
            ValidateAction.runValidation((View)diagramEditor.getDiagram());
            if (!ValidationDialog.confirmContinuation((IStatus)status)) {
                return null;
            }
        }
        try {
            SptGenerateOperation operation = new SptGenerateOperation(resourceSet, activePart);
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)operation);
            this.dialogResult(operation.getPathGeneratedFile());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            Status thrStatus = new Status(4, PLUGIN_ID, target.getMessage());
            ErrorDialog.openError((Shell)shell, (String)Messages.SptGenerateHandler_error_title, (String)Messages.SptGenerateHandler_generation_failed, (IStatus)thrStatus);
        }
        catch (InterruptedException interruptedException) {
            String message = Messages.SptGenerateHandler_w_generation_cancelled;
            String warning = NLS.bind((String)message, (Object)EmfResources.extractURIs((ResourceSet)resourceSet));
            MessageDialog.openWarning((Shell)shell, (String)Messages.SptGenerateHandler_warning_title, (String)warning);
        }
        return null;
    }

    public void dialogResult(final String generatedFile) {
        final IPreferenceStore store = VgtIdeUi.getPreferenceStore();
        String strShow = store.getString("show_generation_result");
        if (strShow.equals("always")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SptGenerateHandler.this.createMessage(generatedFile, store, Messages.SptGenerateHandler_code_generation_completed);
                }
            });
        }
    }

    private void createMessage(String generatedFile, IPreferenceStore store, String header) {
        String message = String.valueOf(header) + "\n" + generatedFile;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)2, (Shell)Display.getDefault().getActiveShell(), (String)Messages.SptGenerateHandler_dailog_title, (String)message, (String)Messages.SptGenerateHandler_dont_show_this_dialog_again, (boolean)false, (IPreferenceStore)store, (String)"show_generation_result", (int)0x10000000);
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "always" : "never";
            store.setValue("show_generation_result", preferenceValue);
        }
    }
}

