/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptprogram;

public class SptTRAM
implements Comparable<SptTRAM> {
    public static final String TRAM_INC = "tram.inc";
    public static final int COLIMN_FIRST = 0;
    public static final int COLIMN_LAST = 511;
    public static final int SLICE_FIRST = 0;
    public static final int SLICE_LAST = 7;
    private static final String TR_PATTERN = "TR_%s_%s";
    private final int column;
    private final int slice;
    private String value;

    public static SptTRAM createFirst() {
        return SptTRAM.create(0, 0);
    }

    public static SptTRAM createLast() {
        return SptTRAM.create(511, 7);
    }

    public static SptTRAM create(int column, int slice) {
        return new SptTRAM(column, slice);
    }

    public SptTRAM(int column, int slice) {
        this.column = column;
        this.slice = slice;
    }

    public int getColumn() {
        return this.column;
    }

    public int getSlice() {
        return this.slice;
    }

    @Override
    public int compareTo(SptTRAM another) {
        if (another == null) {
            return 1;
        }
        if (another == this) {
            return 0;
        }
        int dcolumn = this.column - another.column;
        if (dcolumn != 0) {
            return dcolumn;
        }
        int dslice = this.slice - another.slice;
        if (dslice != 0) {
            return dslice;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SptTRAM other = (SptTRAM)obj;
        if (this.column != other.column) {
            return false;
        }
        return this.slice == other.slice;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.slice;
        return result;
    }

    public String toString() {
        if (this.value == null) {
            this.value = String.format(TR_PATTERN, this.column, this.slice);
        }
        return this.value;
    }
}

