/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptprogram;

public class SptORAM
implements Comparable<SptORAM> {
    public static final String ORAM_INC = "oram.inc";
    public static final int BANK_FIRST = 0;
    public static final int BANK_LAST = 3;
    public static final int COLIMN_FIRST = 0;
    public static final int COLIMN_LAST = 511;
    public static final int SLICE_FIRST = 0;
    public static final int SLICE_LAST = 7;
    private static final String OR_PATTERN = "OR_%s_%s_%s";
    private final int bank;
    private final int column;
    private final int slice;
    private String value;

    public static SptORAM createFirst() {
        return SptORAM.create(0, 0, 0);
    }

    public static SptORAM createLast() {
        return SptORAM.create(3, 511, 7);
    }

    public static SptORAM create(int bank, int column, int slice) {
        return new SptORAM(bank, column, slice);
    }

    public SptORAM(int bank, int column, int slice) {
        this.bank = bank;
        this.column = column;
        this.slice = slice;
    }

    public int getBank() {
        return this.bank;
    }

    public int getColumn() {
        return this.column;
    }

    public int getSlice() {
        return this.slice;
    }

    @Override
    public int compareTo(SptORAM another) {
        if (another == null) {
            return 1;
        }
        if (another == this) {
            return 0;
        }
        int dbank = this.bank - another.bank;
        if (dbank != 0) {
            return dbank;
        }
        int dcolumn = this.column - another.column;
        if (dcolumn != 0) {
            return dcolumn;
        }
        int dslice = this.slice - another.slice;
        if (dslice != 0) {
            return dslice;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SptORAM other = (SptORAM)obj;
        if (this.bank != other.bank) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        return this.slice == other.slice;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.bank;
        result = 31 * result + this.column;
        result = 31 * result + this.slice;
        return result;
    }

    public String toString() {
        if (this.value == null) {
            this.value = String.format(OR_PATTERN, this.bank, this.column, this.slice);
        }
        return this.value;
    }
}

