/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.ui;

import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectFacade;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.ui.ExampleImportOperation;
import com.nxp.s32ds.ext.ide.examples.ui.ExampleSelectionPage;
import com.nxp.s32ds.ext.ide.examples.ui.Messages;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.resources.PathLengthValidator;
import com.nxp.s32ds.ext.ide.resources.ProjectNameValidator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ExampleImportWizard
extends Wizard
implements IShellProvider,
INewWizard {
    ExampleProjectFacade exampleFacade = new ExampleProjectFacade();
    ExampleSelectionPage selectionPage = new ExampleSelectionPage(this.exampleFacade){

        @Override
        protected IStatus validate() {
            IStatus iStatus = ProjectNameValidator.getInstance().validate((Object)this.getName());
            if (!iStatus.isOK()) {
                return iStatus;
            }
            iStatus = PathLengthValidator.getInstance().validate((Object)(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getFullPath().toOSString()) + this.getName()));
            if (!iStatus.isOK()) {
                return iStatus;
            }
            iStatus = ExampleImportWizard.this.validateProjectLocation(this.getName());
            return iStatus;
        }
    };

    public ExampleImportWizard() throws CoreException, IOException {
        this.setHelpAvailable(false);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean performFinish() {
        try {
            String name = this.selectionPage.getName();
            ProjectSet projects = this.selectionPage.getProjects();
            this.getContainer().run(true, true, (IRunnableWithProgress)new ExampleImportOperation(name, projects));
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Status status = new Status(4, ExIdtUiExamplesActivator.getPluginId(), 1, t.getLocalizedMessage(), t);
            ExIdtUiExamplesActivator.log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, (String)message, (IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.Wizard_title);
    }

    private IStatus validateProjectLocation(String projectName) {
        IPath pathWrk = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath segmentPath = pathWrk.append(projectName);
        if (segmentPath.toFile().exists()) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", "A project with that name already exists in the workspace (file system).");
        }
        return Status.OK_STATUS;
    }
}

