/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.ui;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameRefactoring;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameRefactorService;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.ValidationExampleUtil;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.osgi.service.prefs.BackingStoreException;

public class ExampleImportOperation
extends WorkspaceModifyOperation {
    public static final String EMPTY = "";
    private final String name;
    private final ProjectSet projects;
    private final Map<String, String> nameMap;

    public ExampleImportOperation(String name, ProjectSet projects) {
        this.name = name;
        this.projects = projects;
        this.nameMap = Collections.unmodifiableMap(Stream.concat(projects.getProjects().map(IProjectDescription::getName), Stream.of(projects.getName())).distinct().collect(Collectors.toMap(String::toString, ValidationExampleUtil.replaceAllQuoted((String)("^" + Pattern.quote(projects.getName())), (String)name))));
    }

    public void execute(IProgressMonitor monitor) {
        try {
            for (IProjectDescription iter : this.projects.getProjects().collect(Collectors.toList())) {
                try {
                    IProject newProject = this.importProject(iter, monitor);
                    this.refreshProject(newProject);
                }
                catch (InterruptedException | InvocationTargetException | CoreException | BackingStoreException e) {
                    ExIdtUiExamplesActivator.log(e);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject importProject(IProjectDescription project, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, BackingStoreException {
        Path newPath;
        ExampleImportOperation.unHide(project);
        if (this.name.equals(this.projects.getName())) {
            newPath = new Path(String.valueOf(this.projects.getName()) + '/' + project.getName());
        } else {
            String nameProject = project.getName();
            String newProjectName = nameProject.replace(this.projects.getName(), this.name);
            newPath = new Path(String.valueOf(this.name) + '/' + newProjectName);
        }
        String newProjectName = this.nameMap.get(project.getName());
        IProject newProject = ValidationExampleUtil.toProject((String)newProjectName);
        IProjectDescription newProjectDecsr = ExampleImportOperation.copy(project, newProjectName, newPath.toString());
        newProject.create(newProjectDecsr, null);
        newProject.open(128, null);
        ExampleImportOperation.importSource(newProject, project.getLocation().toFile());
        ExampleImportOperation.unHide(newProject.getDescription());
        this.renameParticipants(newProject, monitor);
        IEclipsePreferences prefs = new ProjectScope(newProject).getNode("com.freescale.s32ds.cross.wizard");
        prefs.put("groupName", this.getName(prefs.get("groupName", EMPTY)));
        prefs.flush();
        return newProject;
    }

    private void refreshProject(IProject project) {
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ExIdtUiExamplesActivator.log(e);
        }
    }

    private static IProjectDescription copy(IProjectDescription src, String name, String path) {
        IProjectDescription dst = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        dst.setLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path));
        dst.setBuildSpec(src.getBuildSpec());
        dst.setComment(src.getComment());
        dst.setDynamicReferences(src.getDynamicReferences());
        dst.setNatureIds(src.getNatureIds());
        dst.setReferencedProjects(src.getReferencedProjects());
        return dst;
    }

    private void renameParticipants(IProject resource, IProgressMonitor monitor) {
        List lstRefactorParticipants = RenameRefactorService.getRefactoringParticipants();
        String oldNamePart = this.projects.getName();
        String newNamePart = this.name;
        for (IRenameRefactoring iter : lstRefactorParticipants) {
            iter.renameRefactorResources((IResource)resource, oldNamePart, newNamePart, monitor);
        }
    }

    private String getName(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    private static void importSource(IProject project, File importSource) throws InvocationTargetException, InterruptedException, CoreException {
        IStatus result = new ImportOperation(project.getFullPath(), importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, path -> "YES", FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource)){
            {
                this.setOverwriteResources(true);
                this.setCreateContainerStructure(false);
                this.run(null);
            }
        }.getStatus();
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    private static void unHide(IProjectDescription project) {
        File f;
        if (OSFamily.WINDOWS.isCurrent() && (f = new File(new File(project.getLocationURI()), ".project")).isHidden()) {
            try {
                Files.setAttribute(f.toPath(), "dos:hidden", false, new LinkOption[0]);
            }
            catch (IOException e) {
                ExIdtUiExamplesActivator.info("UNSET HIDDEN ERROR: " + e);
            }
        }
    }
}

