/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.gas.util;

import com.nxp.s32ds.gte.gas.GasDirective;
import com.nxp.s32ds.gte.gas.GasExternDirective;
import com.nxp.s32ds.gte.gas.GasGlobalDirective;
import com.nxp.s32ds.gte.gas.GasIncludeDirective;
import com.nxp.s32ds.gte.gas.GasInstruction;
import com.nxp.s32ds.gte.gas.GasLabel;
import com.nxp.s32ds.gte.gas.GasPackage;
import com.nxp.s32ds.gte.gas.GasPlugin;
import com.nxp.s32ds.gte.gas.GasProgram;
import com.nxp.s32ds.gte.gas.GasSectionDirective;
import com.nxp.s32ds.gte.gas.GasStatement;
import com.nxp.s32ds.gte.gas.GasStatementContainer;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class GasValidator
extends EObjectValidator {
    public static final GasValidator INSTANCE = new GasValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.gas";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return GasPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGasProgram((GasProgram)value, diagnostics, context);
            }
            case 1: {
                return this.validateGasStatement((GasStatement)value, diagnostics, context);
            }
            case 2: {
                return this.validateGasStatementContainer((GasStatementContainer)value, diagnostics, context);
            }
            case 3: {
                return this.validateGasLabel((GasLabel)value, diagnostics, context);
            }
            case 4: {
                return this.validateGasDirective((GasDirective)value, diagnostics, context);
            }
            case 5: {
                return this.validateGasExternDirective((GasExternDirective)value, diagnostics, context);
            }
            case 6: {
                return this.validateGasGlobalDirective((GasGlobalDirective)value, diagnostics, context);
            }
            case 7: {
                return this.validateGasIncludeDirective((GasIncludeDirective)value, diagnostics, context);
            }
            case 8: {
                return this.validateGasSectionDirective((GasSectionDirective)value, diagnostics, context);
            }
            case 9: {
                return this.validateGasInstruction((GasInstruction)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGasProgram(GasProgram gasProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasProgram, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasProgram, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatementContainer_containerHasStatements(gasProgram, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasStatement(GasStatement gasStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasStatement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasStatement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasStatement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasStatement, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasStatement_NoContainerChange(GasStatement statement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        GasStatementContainer successorContainer;
        GasStatementContainer statementContainer;
        boolean failed = false;
        GasStatement successor = statement.getSuccessor();
        if (successor != null && (statementContainer = statement.getContainer()) != null && !statementContainer.equals(successorContainer = successor.getContainer())) {
            failed = true;
        }
        if (failed) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GasStatement_NoContainerChange_diagnostic", new Object[]{"NoContainerChange", GasValidator.getObjectLabel((EObject)statement, context), GasValidator.getObjectLabel((EObject)successor, context)}, new Object[]{statement}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateGasStatement_NoCircularFlow(GasStatement statement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean failed = false;
        GasStatement successor = statement.getSuccessor();
        while (successor != null) {
            if (successor.equals(statement)) {
                failed = true;
                break;
            }
            successor = successor.getSuccessor();
        }
        if (failed) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GasStatement_NoCircularFlow_diagnostic", new Object[]{"NoCircularFlow", GasValidator.getObjectLabel((EObject)statement, context)}, new Object[]{statement}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateGasStatement_HasPredecessor(GasStatement statement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        GasStatementContainer container;
        boolean failed;
        GasStatement predecessor = statement.getPredecessor();
        boolean bl = failed = predecessor == null;
        if (failed && (container = statement.getContainer()) != null) {
            EList<GasStatement> statements = container.getStatements();
            BasicEList others = new BasicEList(statements);
            GasStatement successor = statement;
            while (successor != null) {
                others.remove((Object)successor);
                successor = successor.getSuccessor();
            }
            if (others.isEmpty()) {
                failed = false;
            }
        }
        if (failed) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GasStatement_HasPredecessor_diagnostic", new Object[]{"HasPredecessor", GasValidator.getObjectLabel((EObject)statement, context)}, new Object[]{statement}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateGasStatement_CheckComment(GasStatement gasStatement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean failed = false;
        if (gasStatement.getComment() != null && gasStatement.getComment().contains("#")) {
            failed = true;
        }
        if (failed) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GasStatement_CheckComment_diagnostic", new Object[]{"CheckComment", GasValidator.getObjectLabel((EObject)gasStatement, context)}, new Object[]{gasStatement}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateGasStatementContainer(GasStatementContainer gasStatementContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasStatementContainer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasStatementContainer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasStatementContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatementContainer_containerHasStatements(gasStatementContainer, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasStatementContainer_containerHasStatements(GasStatementContainer gasStatementContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (gasStatementContainer.getStatements().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Statement container should not be empty", GasValidator.getObjectLabel((EObject)gasStatementContainer, context)}, new Object[]{gasStatementContainer}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateGasLabel(GasLabel gasLabel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasLabel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasLabel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasLabel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasLabel, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasDirective(GasDirective gasDirective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasDirective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasDirective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasDirective, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasExternDirective(GasExternDirective gasExternDirective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasExternDirective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasExternDirective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasExternDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasExternDirective, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasGlobalDirective(GasGlobalDirective gasGlobalDirective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasGlobalDirective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasGlobalDirective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasGlobalDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasGlobalDirective, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasIncludeDirective(GasIncludeDirective gasIncludeDirective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasIncludeDirective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasIncludeDirective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasIncludeDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasIncludeDirective, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasSectionDirective(GasSectionDirective gasSectionDirective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasSectionDirective, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasSectionDirective, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasSectionDirective, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasSectionDirective, diagnostics, context);
        }
        return result;
    }

    public boolean validateGasInstruction(GasInstruction gasInstruction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gasInstruction, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gasInstruction, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoContainerChange(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_NoCircularFlow(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_HasPredecessor(gasInstruction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGasStatement_CheckComment(gasInstruction, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return GasPlugin.INSTANCE;
    }
}

