/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.internal;

import com.nxp.s32ds.cross.spt.explorer.Activator;
import com.nxp.s32ds.cross.spt.explorer.internal.ISPTInstructionsHolder;
import com.nxp.s32ds.cross.spt.explorer.internal.SPTInstructionsHolder;
import com.nxp.s32ds.cross.spt.explorer.internal.SPTInstructionsRoot;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionGroup;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionOption;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionParam;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTInstructionGroup;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTInstructionOption;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTInstructionParam;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class SPTInstructionsParser {
    private static final String EXT_POINT_ID = "SPTInstructions";
    private static final String ELEMENT_OPTIONS = "options";
    private static final String ELEMENT_GROUP = "group";
    private static final String ELEMENT_INSTRUCTIONS = "instructions";
    private static final String ELEMENT_INSTRUCTION = "instruction";
    private static final String ELEMENT_OPTION = "option";
    private static final String ELEMENT_PARAM = "param";
    private static final String ELEMENT_VALUE = "value";
    private static final String ATTRIBUTE_FILE = "file";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_COMMA = "comma";
    private static final String ATTRIBUTE_VERSION = "version";

    public static SPTInstructionsRoot parse() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.nxp.s32ds.cross.spt.explorer.SPTInstructions");
        if (ep == null) {
            Activator.logWarning(String.format("No extension point '%s' found", "com.nxp.s32ds.cross.spt.explorer.SPTInstructions"));
            return new SPTInstructionsRoot();
        }
        SPTInstructionsRoot root = new SPTInstructionsRoot();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement celk = iConfigurationElementArray[n4];
                if (ELEMENT_INSTRUCTIONS.equals(celk.getName())) {
                    String sptVersion = celk.getAttribute(ATTRIBUTE_VERSION);
                    String file = celk.getAttribute(ATTRIBUTE_FILE);
                    if (file == null || file.isEmpty()) {
                        SPTInstructionsParser.reportInstructionsLoadError(sptVersion);
                    } else {
                        SPTInstructionsParser.parseInstructions(sptVersion, file, root);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return root;
    }

    private static void parseInstructions(String sptVersion, String file, SPTInstructionsRoot root) {
        block25: {
            try {
                SPTInstructionsHolder holder = new SPTInstructionsHolder(ISPTInstructionsHolder.Type.INSTRUCTIONS, sptVersion);
                URL resolvedUrl = FileLocator.resolve((URL)Platform.getBundle((String)"com.nxp.s32ds.cross.spt.explorer").getEntry(file));
                InputStream is = resolvedUrl.openConnection().getInputStream();
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedInputStream bis = new BufferedInputStream(is);){
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    Element instructionsRoot = parser.parse(bis).getDocumentElement();
                    if (!ELEMENT_INSTRUCTIONS.equals(instructionsRoot.getNodeName())) break block25;
                    NodeList list = instructionsRoot.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        block26: {
                            Node childNode = list.item(i);
                            if (!(childNode instanceof Element)) break block26;
                            Element node = (Element)childNode;
                            switch (node.getNodeName()) {
                                case "options": {
                                    SPTInstructionsParser.parseOptions(node, holder);
                                }
                                case "group": {
                                    holder.addInstruction(SPTInstructionsParser.parseInstructionsGroup(node, holder));
                                    break;
                                }
                                case "instruction": {
                                    holder.addInstruction(SPTInstructionsParser.parseInstruction(node, null));
                                }
                            }
                        }
                        ++i;
                    }
                    root.addHolder(holder);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                SPTInstructionsParser.reportInstructionsLoadError(String.valueOf(sptVersion) + " [" + e.getMessage() + "]");
            }
        }
    }

    private static ISPTInstruction parseInstructionsGroup(Element node, ISPTInstructionsHolder holder) {
        String gName = node.getAttribute(ATTRIBUTE_NAME);
        SPTInstructionGroup group = new SPTInstructionGroup(gName);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block14: {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) break block14;
                Element item = (Element)childNode;
                switch (item.getNodeName()) {
                    case "option": {
                        ISPTInstructionOption option = holder.getOption(item.getAttribute(ATTRIBUTE_NAME));
                        group.addParam(option != null ? option : SPTInstructionsParser.parseOption(item));
                        break;
                    }
                    case "param": {
                        group.addParam(SPTInstructionsParser.parseParam(item));
                        break;
                    }
                    case "instruction": {
                        group.addInstruction(SPTInstructionsParser.parseInstruction(item, group));
                    }
                }
            }
            ++i;
        }
        return group;
    }

    private static ISPTInstruction parseInstruction(Element node, ISPTInstructionGroup group) {
        SPTInstruction instruction = new SPTInstruction(node.getAttribute(ATTRIBUTE_NAME), group);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block11: {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) break block11;
                Element item = (Element)childNode;
                switch (item.getNodeName()) {
                    case "option": {
                        instruction.addParam(SPTInstructionsParser.parseOption(item));
                        break;
                    }
                    case "param": {
                        instruction.addParam(SPTInstructionsParser.parseParam(item));
                    }
                }
            }
            ++i;
        }
        return instruction;
    }

    private static ISPTInstructionParam parseParam(Element item) {
        String paramName = item.getAttribute(ATTRIBUTE_NAME);
        String paramType = item.getAttribute(ATTRIBUTE_TYPE);
        paramType = paramType != null ? paramType.toUpperCase() : "";
        boolean isCommaNeeded = item.getAttribute(ATTRIBUTE_COMMA).isEmpty();
        SPTInstructionParam param = new SPTInstructionParam(paramName, paramType, isCommaNeeded);
        return param;
    }

    private static void parseOptions(Element item, ISPTInstructionsHolder holder) {
        NodeList options = item.getElementsByTagName(ELEMENT_OPTION);
        int i = 0;
        while (i < options.getLength()) {
            Element option = (Element)options.item(0);
            holder.addOption(SPTInstructionsParser.parseOption(option));
            ++i;
        }
    }

    private static ISPTInstructionOption parseOption(Element item) {
        String optionName = item.getAttribute(ATTRIBUTE_NAME);
        boolean isCommaNeeded = !item.getAttribute(ATTRIBUTE_COMMA).isEmpty();
        SPTInstructionOption option = new SPTInstructionOption(optionName, isCommaNeeded);
        NodeList values = item.getElementsByTagName(ELEMENT_VALUE);
        int i = 0;
        while (i < values.getLength()) {
            String value = values.item(i).getTextContent();
            option.addValue(value != null ? value : "");
            ++i;
        }
        return option;
    }

    private static void reportInstructionsLoadError(String sptVersion) {
        Activator.log((IStatus)new Status(4, "com.nxp.s32ds.cross.spt.explorer", "Unable to load instructions for " + sptVersion));
    }
}

