/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.internal;

import com.nxp.s32ds.cross.spt.explorer.internal.ISPTInstructionsHolder;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SPTInstructionsHolder
implements ISPTInstructionsHolder,
Comparable<SPTInstructionsHolder> {
    private ISPTInstructionsHolder.Type type;
    private String name;
    private String version;
    private Set<ISPTInstruction> instructions;
    private Map<String, ISPTInstructionOption> options;

    SPTInstructionsHolder(ISPTInstructionsHolder.Type type, String version) {
        this.type = type;
        this.version = version;
        this.setName(type, version);
        this.instructions = new TreeSet<ISPTInstruction>();
        this.options = new HashMap<String, ISPTInstructionOption>();
    }

    SPTInstructionsHolder(ISPTInstructionsHolder.Type type) {
        this(type, null);
    }

    @Override
    public void addInstruction(ISPTInstruction instruction) {
        this.instructions.add(instruction);
    }

    @Override
    public boolean hasInstructions() {
        return !this.instructions.isEmpty();
    }

    @Override
    public Set<ISPTInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    ISPTInstructionsHolder.Type getType() {
        return this.type;
    }

    @Override
    public boolean matchVersion(String version) {
        return this.version == null || this.version.isEmpty() || this.version.equals(version);
    }

    @Override
    public int compareTo(SPTInstructionsHolder o) {
        return this.name.compareTo(o.name);
    }

    private void setName(ISPTInstructionsHolder.Type type, String version) {
        StringBuilder sb = new StringBuilder(type.getTypeName());
        if (version != null) {
            sb.append(' ').append('(').append(version).append(')');
        }
        this.name = sb.toString();
    }

    @Override
    public void addOption(ISPTInstructionOption option) {
        this.options.put(option.getName(), option);
    }

    @Override
    public ISPTInstructionOption getOption(String name) {
        return this.options.get(name);
    }
}

